-- Copyright (C) 2007 - Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.

-------------------------------------------------------------------------------
--                                                                           --
-- Containing VHDL Model for the Atoms:                                      --
--                                                                           --
--                                 stratixiv_hssi_pcie_hip                         --
--                                                                           --
-------------------------------------------------------------------------------



-- -----------------------------------------------------------
--
-- Module Name : stratixiv_pciehip_param
--
-- Description : process parameters
--
-- -----------------------------------------------------------


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.stratixiv_pcie_hip_components.all;

ENTITY stratixiv_pciehip_param IS
   GENERIC (
      
      advanced_errors                    : STRING := "false";
      allow_rx_valid_empty               : STRING := "false";  -- ww27.2008
      bar0_64bit_mem_space               : STRING := "true";
      bar0_io_space                      : STRING := "false";
      bar0_prefetchable                  : STRING := "true";
      bar0_size_mask                     : INTEGER := 32;
      bar1_64bit_mem_space               : STRING := "false";
      bar1_io_space                      : STRING := "false";
      bar1_prefetchable                  : STRING := "false";
      bar1_size_mask                     : INTEGER := 4;
      bar2_64bit_mem_space               : STRING := "false";
      bar2_io_space                      : STRING := "false";
      bar2_prefetchable                  : STRING := "false";
      bar2_size_mask                     : INTEGER := 4;
      bar3_64bit_mem_space               : STRING := "false";
      bar3_io_space                      : STRING := "false";
      bar3_prefetchable                  : STRING := "false";
      bar3_size_mask                     : INTEGER := 4;
      bar4_64bit_mem_space               : STRING := "false";
      bar4_io_space                      : STRING := "false";
      bar4_prefetchable                  : STRING := "false";
      bar4_size_mask                     : INTEGER := 4;
      bar5_64bit_mem_space               : STRING := "false";
      bar5_io_space                      : STRING := "false";
      bar5_prefetchable                  : STRING := "false";
      bar5_size_mask                     : INTEGER := 4;
      bar_io_window_size                 : STRING := "NONE";
      bar_prefetchable                   : INTEGER := 0;
      base_address                       : INTEGER := 0;
      bridge_port_ssid_support           : STRING := "false";
      bridge_port_vga_enable             : STRING := "false";
      bypass_cdc                         : STRING := "false";
      bypass_tl                          : STRING := "false";
      class_code                         : INTEGER := 16711680;
      completion_timeout                 : STRING := "ABCD";
      core_clk_divider                   : INTEGER := 1;
      core_clk_source                    : STRING := "PLL_FIXED_CLK";
      credit_buffer_allocation_aux       : STRING := "BALANCED";
      deemphasis_enable                  : STRING := "false";
      device_address                     : INTEGER := 0;
      device_id                          : INTEGER := 1;
      device_number                      : INTEGER := 0;
      diffclock_nfts_count               : INTEGER := 128;
      disable_async_l2_logic             : STRING := "false";  -- ww27.2008
      disable_cdc_clk_ppm                : STRING := "true";
      disable_link_x2_support            : STRING := "false";
      disable_snoop_packet               : STD_LOGIC_VECTOR(7 DOWNTO 0) := "00000000";
      dll_active_report_support          : STRING := "false";
      ei_delay_powerdown_count           : INTEGER := 10;
      eie_before_nfts_count              : INTEGER := 4;
      enable_adapter_half_rate_mode      : STRING := "false";
      enable_ch0_pclk_out                : STRING := "true";
      enable_completion_timeout_disable  : STRING := "true";
      enable_coreclk_out_half_rate       : STRING := "false";
      enable_ecrc_check                  : STRING := "true";
      enable_ecrc_gen                    : STRING := "true";
      enable_function_msi_support        : STRING := "true";
      enable_function_msix_support       : STRING := "false";
      enable_gen2_core                   : STRING := "true";
      enable_hip_x1_loopback             : STRING := "false";
      enable_l1_aspm                     : STRING := "false";
      enable_msi_64bit_addressing        : STRING := "true";
      enable_msi_masking                 : STRING := "false";
      enable_rcv0buf_a_we                : STRING := "true";
      enable_rcv0buf_b_re                : STRING := "true";
      enable_rcv0buf_output_regs         : STRING := "false";
      enable_rcv1buf_a_we                : STRING := "true";
      enable_rcv1buf_b_re                : STRING := "true";
      enable_rcv1buf_output_regs         : STRING := "false";
      enable_retrybuf_a_we               : STRING := "true";
      enable_retrybuf_b_re               : STRING := "true";
      enable_retrybuf_ecc                : STRING := "false";		-- ww12
      enable_retrybuf_output_regs        : STRING := "false";
      enable_retrybuf_x8_clk_stealing    : INTEGER := 0;		-- ww12
      enable_rx0buf_ecc                  : STRING := "false";		-- ww12
      enable_rx0buf_x8_clk_stealing      : INTEGER := 0;		-- ww12
      enable_rx1buf_ecc                  : STRING := "false";		-- ww12
      enable_rx1buf_x8_clk_stealing      : INTEGER := 0;		-- ww12
      enable_rx_buffer_checking          : STRING := "false";
      enable_rx_ei_l0s_exit_refined      : STRING := "false";
      enable_rx_reordering               : STRING := "true";
      enable_slot_register               : STRING := "false";
      endpoint_l0_latency                : INTEGER := 0;
      endpoint_l1_latency                : INTEGER := 0;
      expansion_base_address_register    : INTEGER := 0;
      extend_tag_field                   : STRING := "false";
      fc_init_timer                      : INTEGER := 1024;
      flow_control_timeout_count         : INTEGER := 200;
      flow_control_update_count          : INTEGER := 30;
      gen2_diffclock_nfts_count          : INTEGER := 255;
      gen2_lane_rate_mode                : STRING := "false";
      gen2_sameclock_nfts_count          : INTEGER := 255;
      hot_plug_support                   : STD_LOGIC_VECTOR(6 DOWNTO 0) := "0000000";
      iei_logic                          : STRING := "DISABLE";
      indicator                          : INTEGER := 7;
      l01_entry_latency                  : INTEGER := 31;
      l0_exit_latency_diffclock          : INTEGER := 6;
      l0_exit_latency_sameclock          : INTEGER := 6;
      l1_exit_latency_diffclock          : INTEGER := 0;
      l1_exit_latency_sameclock          : INTEGER := 0;
      lane_mask                          : STD_LOGIC_VECTOR(7 DOWNTO 0) := "11110000";
      low_priority_vc                    : INTEGER := 0;
      max_link_width                     : INTEGER := 4;
      max_payload_size                   : INTEGER := 2;
      maximum_current                    : INTEGER := 0;
      migrated_from_prev_family          : STRING := "false";
      millisecond_cycle_count            : INTEGER := 0;
      mram_bist_settings                 : STRING := "";
      msi_function_count                 : INTEGER := 2;
      msix_pba_bir                       : INTEGER := 0;
      msix_pba_offset                    : INTEGER := 0;
      msix_table_bir                     : INTEGER := 0;
      msix_table_offset                  : INTEGER := 0;
      msix_table_size                    : INTEGER := 0;
      no_command_completed               : STRING := "true";
      no_soft_reset                      : STRING := "false";
      pcie_mode                          : STRING := "SHARED_MODE";
      pme_state_enable                   : STD_LOGIC_VECTOR(4 DOWNTO 0) := "00000";
      port_link_number                   : INTEGER := 1;
      port_address                       : INTEGER := 0;
      register_pipe_signals              : STRING := "false";
      retry_buffer_last_active_address   : INTEGER := 4095;
      retry_buffer_memory_settings       : INTEGER := 0;
      revision_id                        : INTEGER := 1;
      rx0_adap_fifo_full_value           : INTEGER := 9;
      rx1_adap_fifo_full_value           : INTEGER := 9;
      rx_cdc_full_value                  : INTEGER := 12;
      rx_idl_os_count                    : INTEGER := 0;
      rx_ptr0_nonposted_dpram_max        : INTEGER := 0;
      rx_ptr0_nonposted_dpram_min        : INTEGER := 0;
      rx_ptr0_posted_dpram_max           : INTEGER := 0;
      rx_ptr0_posted_dpram_min           : INTEGER := 0;
      rx_ptr1_nonposted_dpram_max        : INTEGER := 0;
      rx_ptr1_nonposted_dpram_min        : INTEGER := 0;
      rx_ptr1_posted_dpram_max           : INTEGER := 0;
      rx_ptr1_posted_dpram_min           : INTEGER := 0;
      sameclock_nfts_count               : INTEGER := 128;
      single_rx_detect                   : INTEGER := 0;
      skp_os_schedule_count              : INTEGER := 0;
      slot_number                        : INTEGER := 0;
      slot_power_limit                   : INTEGER := 0;
      slot_power_scale                   : INTEGER := 0;
      ssid                               : INTEGER := 0;
      ssvid                              : INTEGER := 0;
      subsystem_device_id                : INTEGER := 1;
      subsystem_vendor_id                : INTEGER := 4466;
      surprise_down_error_support        : STRING := "false";
      tx0_adap_fifo_full_value           : INTEGER := 11;
      tx1_adap_fifo_full_value           : INTEGER := 11;
      tx_cdc_full_value                  : INTEGER := 12;
      tx_cdc_stop_dummy_full_value       : INTEGER := 11;
      use_crc_forwarding                 : STRING := "false";
      vc0_clk_enable                     : STRING := "true";
      vc0_rx_buffer_memory_settings      : INTEGER := 0;
      vc0_rx_flow_ctrl_compl_data        : INTEGER := 448;
      vc0_rx_flow_ctrl_compl_header      : INTEGER := 112;
      vc0_rx_flow_ctrl_nonposted_data    : INTEGER := 0;
      vc0_rx_flow_ctrl_nonposted_header  : INTEGER := 54;
      vc0_rx_flow_ctrl_posted_data       : INTEGER := 360;
      vc0_rx_flow_ctrl_posted_header     : INTEGER := 50;
      vc1_clk_enable                     : STRING := "false";
      vc1_rx_buffer_memory_settings      : INTEGER := 0;
      vc1_rx_flow_ctrl_compl_data        : INTEGER := 448;
      vc1_rx_flow_ctrl_compl_header      : INTEGER := 112;
      vc1_rx_flow_ctrl_nonposted_data    : INTEGER := 0;
      vc1_rx_flow_ctrl_nonposted_header  : INTEGER := 54;
      vc1_rx_flow_ctrl_posted_data       : INTEGER := 360;
      vc1_rx_flow_ctrl_posted_header     : INTEGER := 50;
      vc_arbitration                     : INTEGER := 1;
      vc_enable                          : STD_LOGIC_VECTOR(6 DOWNTO 0) := "0000000";
      vendor_id                          : INTEGER := 4466
   );
   PORT (
      test_in                            : IN STD_LOGIC := '0';
      csr_hip_in                         : OUT STD_LOGIC_VECTOR(1759 DOWNTO 0)
   );
END stratixiv_pciehip_param;

ARCHITECTURE trans OF stratixiv_pciehip_param IS
   
   --////////////////////////////////////////////////////////////////////////////
   -- parameter list copied from top_level atom -------------------------------//
   --////////////////////////////////////////////////////////////////////////////
   
   --////////////////////////////////////////////////////////////////////////////
   -- temporary signals added to patch the conversion function - non-RTL       //
   --////////////////////////////////////////////////////////////////////////////
   SIGNAL init_use_crc_forwarding    : STD_LOGIC;
   
   --////////////////////////////////////////////////////////////////////////////
   -- k-bits init values regiser version - total 40----------------------------//
   --                                                                          //
   -- k-bits definition and map to ext_* is from hip_top.v out_hip -> k_bits   //
   --                                                                          //
   --////////////////////////////////////////////////////////////////////////////
   
   -- configuration signals
   SIGNAL init_k_gbl                 : STD_LOGIC_VECTOR(63 DOWNTO 0);
   SIGNAL init_k_dev                 : STD_LOGIC_VECTOR(4 DOWNTO 0);
   SIGNAL init_k_port                : STD_LOGIC_VECTOR(7 DOWNTO 0);
   
   -- clk-stealing enable signals for the MRAMs
   SIGNAL init_k_clk_x8_sel_rtry     : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL init_k_clk_x8_sel_rcv0     : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL init_k_clk_x8_sel_rcv1     : STD_LOGIC_VECTOR(3 DOWNTO 0);
   
   -- ECC enable signals for the MRAMs
   SIGNAL init_k_ecc_enable_rtry     : STD_LOGIC;
   SIGNAL init_k_ecc_enable_rcv0     : STD_LOGIC;
   SIGNAL init_k_ecc_enable_rcv1     : STD_LOGIC;
   
   -- clk mux selections
   SIGNAL init_k_pclk_sel            : STD_LOGIC;
   SIGNAL init_k_core_clk_source_sel : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL init_k_core_clk_div_sel    : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL init_k_core_clk_out_sel    : STD_LOGIC;
   SIGNAL init_k_core_clk_dbg_sel    : STD_LOGIC;
   
   -- RX,TX debug signal selection
   SIGNAL init_k_pipex1_dbg_sel      : STD_LOGIC;
   
   -- Electrical Idle Inferral enable
   SIGNAL init_k_iei_enable          : STD_LOGIC_VECTOR(5 DOWNTO 0);
   
   --reg   [383:0]   init_k_conf_func0;  
   --reg   [227:0]   init_k_bar_func0;     
   SIGNAL init_k_cnt                 : STD_LOGIC_VECTOR(127 DOWNTO 0);
   SIGNAL init_k_vc0                 : STD_LOGIC_VECTOR(55 DOWNTO 0);
   SIGNAL init_k_vc1                 : STD_LOGIC_VECTOR(55 DOWNTO 0);
   SIGNAL init_k_vc2                 : STD_LOGIC_VECTOR(55 DOWNTO 0);
   SIGNAL init_k_vc3                 : STD_LOGIC_VECTOR(55 DOWNTO 0);
   SIGNAL init_k_vc4                 : STD_LOGIC_VECTOR(55 DOWNTO 0);
   SIGNAL init_k_vc5                 : STD_LOGIC_VECTOR(55 DOWNTO 0);
   SIGNAL init_k_vc6                 : STD_LOGIC_VECTOR(55 DOWNTO 0);
   SIGNAL init_k_vc7                 : STD_LOGIC_VECTOR(55 DOWNTO 0);
   SIGNAL init_k_rtry                : STD_LOGIC_VECTOR(10 DOWNTO 0);
   SIGNAL init_k_ptr0                : STD_LOGIC_VECTOR(43 DOWNTO 0);
   SIGNAL init_k_ptr1                : STD_LOGIC_VECTOR(43 DOWNTO 0);
   SIGNAL init_k_hip                 : STD_LOGIC_VECTOR(22 DOWNTO 0);
   SIGNAL init_k_mem_bist            : STD_LOGIC_VECTOR(74 DOWNTO 0);
   SIGNAL init_k_rtry_mem            : STD_LOGIC_VECTOR(29 DOWNTO 0);
   SIGNAL init_k_rcv0_mem            : STD_LOGIC_VECTOR(29 DOWNTO 0);
   SIGNAL init_k_rcv1_mem            : STD_LOGIC_VECTOR(29 DOWNTO 0);
   --SIGNAL init_k_rcv_mem0            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   --SIGNAL init_k_rcv_mem1            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   
   -- Misc. functions for the MRAMs
   SIGNAL init_k_rtry_outreg         : STD_LOGIC;
   SIGNAL init_k_rtry_raen2          : STD_LOGIC;
   SIGNAL init_k_rtry_rben1          : STD_LOGIC;
   
   SIGNAL init_k_rcv0_outreg         : STD_LOGIC;
   SIGNAL init_k_rcv0_raen2          : STD_LOGIC;
   SIGNAL init_k_rcv0_rben1          : STD_LOGIC;
   
   SIGNAL init_k_rcv1_outreg         : STD_LOGIC;
   SIGNAL init_k_rcv1_raen2          : STD_LOGIC;
   SIGNAL init_k_rcv1_rben1          : STD_LOGIC;
   
   -- softtwisted k-bits names -----------------------------------------------
   SIGNAL init_k_conf                : STD_LOGIC_VECTOR(383 DOWNTO 0);
   SIGNAL init_k_bar                 : STD_LOGIC_VECTOR(227 DOWNTO 0);
   
   --////////////////////////////////////////////////////////////////////////////
   -- k-bits declarations - total 44-------------------------------------------//
   --////////////////////////////////////////////////////////////////////////////
   
   -- configuration signals
   SIGNAL k_gbl                      : STD_LOGIC_VECTOR(63 DOWNTO 0);
   SIGNAL k_dev                      : STD_LOGIC_VECTOR(4 DOWNTO 0);
   SIGNAL k_port                     : STD_LOGIC_VECTOR(7 DOWNTO 0);
   
   -- clk-stealing enable signals for the MRAMs
   SIGNAL k_clk_x8_sel_rtry          : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL k_clk_x8_sel_rcv0          : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL k_clk_x8_sel_rcv1          : STD_LOGIC_VECTOR(3 DOWNTO 0);
   
   -- ECC enable signals for the MRAMs
   SIGNAL k_ecc_enable_rtry          : STD_LOGIC;
   SIGNAL k_ecc_enable_rcv0          : STD_LOGIC;
   SIGNAL k_ecc_enable_rcv1          : STD_LOGIC;
   
   -- clk mux selections
   SIGNAL k_pclk_sel                 : STD_LOGIC;
   SIGNAL k_core_clk_source_sel      : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL k_core_clk_div_sel         : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL k_core_clk_out_sel         : STD_LOGIC;
   SIGNAL k_core_clk_dbg_sel         : STD_LOGIC;
   
   -- RX,TX debug signal selection
   SIGNAL k_pipex1_dbg_sel           : STD_LOGIC;
   
   -- Electrical Idle Inferral enable
   SIGNAL k_iei_enable               : STD_LOGIC_VECTOR(5 DOWNTO 0);
   
   SIGNAL k_conf_func0               : STD_LOGIC_VECTOR(383 DOWNTO 0);
   SIGNAL k_bar_func0                : STD_LOGIC_VECTOR(227 DOWNTO 0);
   SIGNAL k_cnt                      : STD_LOGIC_VECTOR(127 DOWNTO 0);
   SIGNAL k_vc0                      : STD_LOGIC_VECTOR(55 DOWNTO 0);
   SIGNAL k_vc1                      : STD_LOGIC_VECTOR(55 DOWNTO 0);
   SIGNAL k_vc2                      : STD_LOGIC_VECTOR(55 DOWNTO 0);
   SIGNAL k_vc3                      : STD_LOGIC_VECTOR(55 DOWNTO 0);
   SIGNAL k_vc4                      : STD_LOGIC_VECTOR(55 DOWNTO 0);
   SIGNAL k_vc5                      : STD_LOGIC_VECTOR(55 DOWNTO 0);
   SIGNAL k_vc6                      : STD_LOGIC_VECTOR(55 DOWNTO 0);
   SIGNAL k_vc7                      : STD_LOGIC_VECTOR(55 DOWNTO 0);
   SIGNAL k_rtry                     : STD_LOGIC_VECTOR(10 DOWNTO 0);
   SIGNAL k_ptr0                     : STD_LOGIC_VECTOR(43 DOWNTO 0);
   SIGNAL k_ptr1                     : STD_LOGIC_VECTOR(43 DOWNTO 0);
   SIGNAL k_hip                      : STD_LOGIC_VECTOR(22 DOWNTO 0);
   SIGNAL k_mem_bist                 : STD_LOGIC_VECTOR(74 DOWNTO 0);
   SIGNAL k_rtry_mem                 : STD_LOGIC_VECTOR(29 DOWNTO 0);
   SIGNAL k_rcv0_mem                 : STD_LOGIC_VECTOR(29 DOWNTO 0);
   SIGNAL k_rcv1_mem                 : STD_LOGIC_VECTOR(29 DOWNTO 0);
   --SIGNAL k_rcv_mem0                 : STD_LOGIC_VECTOR(15 DOWNTO 0);		-- no longer existed in HIP_TOP RTL shawn
   --SIGNAL k_rcv_mem1                 : STD_LOGIC_VECTOR(15 DOWNTO 0);		-- no longer existed in HIP_TOP RTL shawn
   
   
   -- Misc. functions for the MRAMs
   -- no longer in hip_top RTL but parameter still existed at WYS - Shawn
   SIGNAL k_rtry_outreg              : STD_LOGIC;
   SIGNAL k_rtry_raen2               : STD_LOGIC;
   SIGNAL k_rtry_rben1               : STD_LOGIC;
   
   SIGNAL k_rcv0_outreg              : STD_LOGIC;
   SIGNAL k_rcv0_raen2               : STD_LOGIC;
   SIGNAL k_rcv0_rben1               : STD_LOGIC;
   
   SIGNAL k_rcv1_outreg              : STD_LOGIC;
   SIGNAL k_rcv1_raen2               : STD_LOGIC;
   SIGNAL k_rcv1_rben1               : STD_LOGIC;
   
   --////////////////////////////////////////////////////////////////////////////
   -- DPRIO registers - total 111 ---------------------------------------------//
   --////////////////////////////////////////////////////////////////////////////
   SIGNAL ext_hip_ctrl_1             : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_2             : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_3             : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_4             : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_5             : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_6             : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_7             : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_8             : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_9             : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_10            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_11            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_12            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_13            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_14            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_15            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_16            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_17            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_18            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_19            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_20            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_21            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_22            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_23            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_24            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_25            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_26            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_27            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_28            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_29            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_30            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_31            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_32            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_33            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_34            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_35            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_36            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_37            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_38            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_39            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_40            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_41            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_42            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_43            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_44            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_45            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_46            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_47            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_48            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_49            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_50            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_51            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_52            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_53            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_54            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_55            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_56            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_57            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_58            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_59            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_60            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_61            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_62            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_63            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_64            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_65            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_66            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_67            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_68            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_69            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_70            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_71            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_72            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_73            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_74            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_75            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_76            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_77            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_78            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_79            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_80            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_81            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_82            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_83            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_84            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_85            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_86            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_87            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_88            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_89            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_90            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_91            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_92            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_93            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_94            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_95            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_96            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_97            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_98            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_99            : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_100           : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_101           : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_102           : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_103           : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_104           : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_105           : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_106           : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_107           : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_108           : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_109           : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL ext_hip_ctrl_110           : STD_LOGIC_VECTOR(15 DOWNTO 0);
BEGIN
   
   --////////////////////////////////////////////////////////////////////
   -- funtions assisting conversion of parameters ---------------------//
   --////////////////////////////////////////////////////////////////////
   
   -- purpose: Calculate the k_ptr values based on the supplied parameters
   -- calc_k_ptr
   -- Reserve Space for the NonPosted Headers (and also NonPosted Data)
   
   --nonp_siz = ((k_vc[27:20])) * 2;   -- updated 07.ww51
   
   -- function to convert at most 8-bit long string to binary
   
   --////////////////////////////////////////////////////////////////////////////
   -- initialize temporary signals -- non-RTL -------------------------------- //
   --////////////////////////////////////////////////////////////////////////////
   --initial begin
   --	
   --end
   
   PROCESS 
     FUNCTION calc_k_ptr(                                                              
     k_vc                               : IN STD_LOGIC_VECTOR(55 DOWNTO 0);            
     init_use_crc_forwarding            : IN STD_LOGIC) RETURN STD_LOGIC_VECTOR IS     
     VARIABLE post_min                 : STD_LOGIC_VECTOR(10 DOWNTO 0);                
     VARIABLE post_max                 : STD_LOGIC_VECTOR(10 DOWNTO 0);                
     VARIABLE nonp_min                 : STD_LOGIC_VECTOR(10 DOWNTO 0);                
     VARIABLE nonp_max                 : STD_LOGIC_VECTOR(10 DOWNTO 0);                
     VARIABLE nonp_siz                 : INTEGER;                                      
     VARIABLE calc_k_ptr               : STD_LOGIC_VECTOR(43 DOWNTO 0);                
  BEGIN                                                                                
     post_min := "00000000000";                                                        
     nonp_max := "11111111111";                                                        
     IF (init_use_crc_forwarding = '1') THEN                                           
        nonp_siz :=bin2int(k_vc(27 DOWNTO 20)) * 3;                                 
     ELSE                                                                              
        nonp_siz := bin2int(k_vc(27 DOWNTO 20)) * 2;                                 
     END IF;                                                                           
     post_max := nonp_max - int2bin(nonp_siz,11);                                                  
     nonp_min := post_max + "00000000001";                                             
     calc_k_ptr := ((nonp_max & nonp_min & post_max & post_min));                      
     RETURN calc_k_ptr;                                                                
  END calc_k_ptr;                                                                      
      
      
 variable init_use_crc_forwarding_var : std_logic;
   variable init_k_vc0_var                 : STD_LOGIC_VECTOR(55 DOWNTO 0);
   variable init_k_vc1_var                 : STD_LOGIC_VECTOR(55 DOWNTO 0);
   BEGIN
      --/////////////////////////////////////////////////////////////////////
      -- parameter to k_bits conversion - script generated ----------------//
      --/////////////////////////////////////////////////////////////////////
      init_use_crc_forwarding_var := mux_select((use_crc_forwarding = ("true")), '1', '0');		-- pcie 1.1+
      init_k_gbl(0) <= '1';
      init_k_gbl(7 DOWNTO 1) <=  vc_enable ; 
      init_k_gbl(8) <= '1';
      init_k_gbl(9) <= (mux_select((enable_slot_register = ("true")), '1', '0'));
      init_k_gbl(11 DOWNTO 10) <= "00";
      init_k_gbl(15 DOWNTO 12) <= ((mux_select((pcie_mode = ("EP_NATIVE")), "0000", "0000")) OR (mux_select((pcie_mode = ("EP_LEGACY")), "0001", "0000")) OR (mux_select((pcie_mode = ("RP")), "0010", "0000")) OR (mux_select((pcie_mode = ("SW_UP")), "0011", "0000")) OR (mux_select((pcie_mode = ("SW_DN")), "0100", "0000")) OR (mux_select((pcie_mode = ("BRIDGE")), "0101", "0000")) OR (mux_select((pcie_mode = ("SWITCH_MODE")), "1110", "0000")) OR (mux_select((pcie_mode = ("SHARED_MODE")), "1111", "0000")) OR "0000");		-- lane mask
      init_k_gbl(22 DOWNTO 16) <= "0000000";
      init_k_gbl(23) <= (mux_select((bypass_cdc = ("true")), '0', '1'));
      init_k_gbl(24) <= (mux_select((disable_cdc_clk_ppm = ("true")), '1', '0'));
      init_k_gbl(25) <= '0';
      init_k_gbl(26) <= (mux_select((enable_rx_reordering = ("true")), '1', '0'));
      init_k_gbl(27) <= (mux_select((enable_rx_buffer_checking = ("true")), '1', '0'));
      init_k_gbl(31 DOWNTO 28) <= int2bin(single_rx_detect, 4);
      init_k_gbl(32) <= (mux_select((use_crc_forwarding = ("true")), '1', '0'));
      init_k_gbl(33) <= (mux_select((bypass_tl = ("true")), '1', '0'));
      init_k_gbl(34) <= (mux_select((gen2_lane_rate_mode = ("true")), '1', '0'));
      init_k_gbl(42 DOWNTO 35) <=  lane_mask ; 
      init_k_gbl(43) <= (mux_select((disable_link_x2_support = ("true")), '1', '0'));		-- reserve
      init_k_gbl(63 DOWNTO 44) <= "00000000000000000000";
      init_k_port(7 DOWNTO 0) <= int2bin(port_link_number, 8);
      init_k_dev(4 DOWNTO 0) <= int2bin(device_number, 5);
      init_k_core_clk_out_sel <= (mux_select((enable_coreclk_out_half_rate = ("true")), '1', '0'));
      init_k_core_clk_div_sel <= mux_select((core_clk_divider = 1), "000", mux_select((core_clk_divider = 2), "001", mux_select((core_clk_divider = 4), "011", mux_select((core_clk_divider = 8), "101", mux_select((core_clk_divider = 16), "111", "000")))));
      init_k_core_clk_source_sel(1 DOWNTO 0) <= ((mux_select((alpha_tolower(core_clk_source) = ("pll_fixed_clk")), "00", "00")) OR (mux_select((alpha_tolower(core_clk_source) = ("pclk")), "01", "00")) OR (mux_select((alpha_tolower(core_clk_source) = ("core_clk_in")), "10", "00")) OR "00");
      init_k_pclk_sel <= (mux_select((enable_ch0_pclk_out = ("true")), '1', '0'));
      init_k_pipex1_dbg_sel <= (mux_select((enable_hip_x1_loopback = ("true")), '1', '0'));
      IF (alpha_tolower(iei_logic) = "disable") THEN
          init_k_iei_enable(5 DOWNTO 0) <= "001001";
      ELSIF (alpha_tolower(iei_logic) = "iei_idid") THEN
          init_k_iei_enable(5 DOWNTO 0) <= "100100";
      ELSIF (alpha_tolower(iei_logic) = "iei_idis") THEN
          init_k_iei_enable(5 DOWNTO 0) <= "100101";
      ELSIF (alpha_tolower(iei_logic) = "iei_isii") THEN
          init_k_iei_enable(5 DOWNTO 0) <= "110110";
      ELSIF (alpha_tolower(iei_logic) = "iei_iiis") THEN
          init_k_iei_enable(5 DOWNTO 0) <= "110101";
      ELSE
          init_k_iei_enable(5 DOWNTO 0) <= "000000";
      END IF;
      init_k_clk_x8_sel_rcv0 <= int2bin(enable_rx0buf_x8_clk_stealing, 4);
      init_k_clk_x8_sel_rcv1 <= int2bin(enable_rx1buf_x8_clk_stealing, 4);
      init_k_clk_x8_sel_rtry <= int2bin(enable_retrybuf_x8_clk_stealing, 4);
      init_k_ecc_enable_rcv0 <= (mux_select((enable_rx0buf_ecc = ("true")), '1', '0'));
      init_k_ecc_enable_rcv1 <= (mux_select((enable_rx1buf_ecc = ("true")), '1', '0'));
      init_k_ecc_enable_rtry <= (mux_select((enable_retrybuf_ecc = ("true")), '1', '0'));
      init_k_rtry_outreg <= (mux_select((enable_retrybuf_output_regs = ("true")), '1', '0'));
      init_k_rtry_raen2 <= (mux_select((enable_retrybuf_a_we = ("true")), '1', '0'));
      init_k_rtry_rben1 <= (mux_select((enable_retrybuf_b_re = ("true")), '1', '0'));
      init_k_rcv0_outreg <= (mux_select((enable_rcv0buf_output_regs = ("true")), '1', '0'));
      init_k_rcv0_raen2 <= (mux_select((enable_rcv0buf_a_we = ("true")), '1', '0'));
      init_k_rcv0_rben1 <= (mux_select((enable_rcv0buf_b_re = ("true")), '1', '0'));
      init_k_rcv1_outreg <= (mux_select((enable_rcv1buf_output_regs = ("true")), '1', '0'));
      init_k_rcv1_raen2 <= (mux_select((enable_rcv1buf_a_we = ("true")), '1', '0'));
      init_k_rcv1_rben1 <= (mux_select((enable_rcv1buf_b_re = ("true")), '1', '0'));
      init_k_conf(15 DOWNTO 0) <= int2bin(vendor_id, 16);
      init_k_conf(31 DOWNTO 16) <= int2bin(device_id, 16);
      init_k_conf(39 DOWNTO 32) <= int2bin(revision_id, 8);
      init_k_conf(63 DOWNTO 40) <= int2bin(class_code, 24);
      init_k_conf(79 DOWNTO 64) <= int2bin(subsystem_vendor_id, 16);
      init_k_conf(95 DOWNTO 80) <= int2bin(subsystem_device_id, 16);
      init_k_conf(96) <= (mux_select((no_soft_reset = ("true")), '1', '0'));		-- PME Clock
      init_k_conf(101 DOWNTO 97) <= "00000";
      init_k_conf(104 DOWNTO 102) <= int2bin(maximum_current, 3);		-- D1 D2
      init_k_conf(106 DOWNTO 105) <= "00";
      init_k_conf(111 DOWNTO 107) <=  pme_state_enable ; 
      init_k_conf(112) <= (mux_select((advanced_errors = ("true")), '1', '0'));
      init_k_conf(115 DOWNTO 113) <= int2bin(low_priority_vc, 3);
      init_k_conf(119 DOWNTO 116) <= int2bin(vc_arbitration, 4);
      init_k_conf(127 DOWNTO 120) <=  disable_snoop_packet ; 
      init_k_conf(130 DOWNTO 128) <= int2bin(max_payload_size, 3);
      init_k_conf(131) <= (mux_select((surprise_down_error_support = ("true")), '1', '0'));
      init_k_conf(132) <= (mux_select((dll_active_report_support = ("true")), '1', '0'));
      init_k_conf(133) <= (mux_select((extend_tag_field = ("true")), '1', '0'));
      init_k_conf(136 DOWNTO 134) <= int2bin(endpoint_l0_latency, 3);
      init_k_conf(139 DOWNTO 137) <= int2bin(endpoint_l1_latency, 3);
      init_k_conf(142 DOWNTO 140) <= int2bin(indicator, 3);		-- role base
      init_k_conf(143) <= '1';
      init_k_conf(145 DOWNTO 144) <= int2bin(slot_power_scale, 2);
      init_k_conf(151 DOWNTO 146) <= int2bin(max_link_width, 6);		-- l0s ASPM
      init_k_conf(152) <= '1';
      init_k_conf(153) <= (mux_select((enable_l1_aspm = ("true")), '1', '0'));
      init_k_conf(156 DOWNTO 154) <= int2bin(l1_exit_latency_sameclock, 3);
      init_k_conf(159 DOWNTO 157) <= int2bin(l1_exit_latency_diffclock, 3);
      init_k_conf(166 DOWNTO 160) <=  hot_plug_support ; 
      init_k_conf(169 DOWNTO 167) <= "000";
      init_k_conf(177 DOWNTO 170) <= int2bin(slot_power_limit, 8);		-- electromechanical lock present
      init_k_conf(178) <= '0';
      init_k_conf(191 DOWNTO 179) <= int2bin(slot_number, 13);
      init_k_conf(199 DOWNTO 192) <= int2bin(diffclock_nfts_count, 8);
      init_k_conf(207 DOWNTO 200) <= int2bin(sameclock_nfts_count, 8);
      init_k_conf(211 DOWNTO 208) <= ((mux_select((alpha_tolower(completion_timeout) = ("none")), "0000", "0000")) OR (mux_select((alpha_tolower(completion_timeout) = ("a")), "0001", "0000")) OR (mux_select((alpha_tolower(completion_timeout) = ("b")), "0010", "0000")) OR (mux_select((alpha_tolower(completion_timeout) = ("ab")), "0011", "0000")) OR (mux_select((alpha_tolower(completion_timeout) = ("bc")), "0110", "0000")) OR (mux_select((alpha_tolower(completion_timeout) = ("abc")), "0111", "0000")) OR (mux_select((alpha_tolower(completion_timeout) = ("bcd")), "1110", "0000")) OR (mux_select((alpha_tolower(completion_timeout) = ("abcd")), "1111", "0000")) OR "0000");
      init_k_conf(212) <= (mux_select((enable_completion_timeout_disable = ("true")), '1', '0'));		-- reserve
      init_k_conf(215 DOWNTO 213) <= "000";
      init_k_conf(216) <= (mux_select((enable_ecrc_gen = ("true")), '1', '0'));
      init_k_conf(217) <= (mux_select((enable_ecrc_check = ("true")), '1', '0'));
      init_k_conf(218) <= (mux_select((no_command_completed = ("true")), '1', '0'));
      init_k_conf(221 DOWNTO 219) <= int2bin(msi_function_count, 3);
      init_k_conf(222) <= (mux_select((enable_msi_64bit_addressing = ("true")), '1', '0'));
      init_k_conf(223) <= (mux_select((enable_msi_masking = ("true")), '1', '0'));
      init_k_conf(224) <= (mux_select((enable_function_msi_support = ("true")), '1', '0'));		-- interrupt pins
      init_k_conf(229 DOWNTO 225) <= "00001";
      init_k_conf(230) <= (mux_select((enable_function_msix_support = ("true")), '1', '0'));
      init_k_conf(233 DOWNTO 231) <= int2bin(msix_pba_bir, 3);
      init_k_conf(262 DOWNTO 234) <= int2bin(msix_pba_offset, 29);
      init_k_conf(265 DOWNTO 263) <= int2bin(msix_table_bir, 3);
      init_k_conf(294 DOWNTO 266) <= int2bin(msix_table_offset, 29);
      init_k_conf(305 DOWNTO 295) <= int2bin(msix_table_size, 11);
      init_k_conf(306) <= (mux_select((bridge_port_vga_enable = ("true")), '1', '0'));
      init_k_conf(307) <= (mux_select((bridge_port_ssid_support = ("true")), '1', '0'));
      init_k_conf(323 DOWNTO 308) <= int2bin(ssvid, 16);
      init_k_conf(339 DOWNTO 324) <= int2bin(ssid, 16);
      init_k_conf(343 DOWNTO 340) <= int2bin(eie_before_nfts_count, 4);
      init_k_conf(351 DOWNTO 344) <= int2bin(gen2_diffclock_nfts_count, 8);
      init_k_conf(359 DOWNTO 352) <= int2bin(gen2_sameclock_nfts_count, 8);
      init_k_conf(360) <= (mux_select((deemphasis_enable = ("true")), '1', '0'));
      init_k_conf(364 DOWNTO 361) <= (mux_select((enable_gen2_core = ("true")), "0010", "0000"));
      init_k_conf(367 DOWNTO 365) <= int2bin(l0_exit_latency_sameclock, 3);
      init_k_conf(370 DOWNTO 368) <= int2bin(l0_exit_latency_diffclock, 3);
      init_k_conf(371) <= (mux_select((enable_rx_ei_l0s_exit_refined = ("true")), '1', '0'));		-- reserve
      IF (disable_async_l2_logic = "true") THEN
          init_k_conf(372) <= '1';
      ELSE
          init_k_conf(372) <= '0';
      END IF;
      init_k_conf(383 DOWNTO 373) <= "00000000000";
      init_k_hip(0) <= (mux_select((enable_adapter_half_rate_mode = ("true")), '1', '0'));
      init_k_hip(1) <= (mux_select((vc0_clk_enable = ("true")), '1', '0'));
      init_k_hip(2) <= (mux_select((vc1_clk_enable = ("true")), '1', '0'));
      init_k_hip(3) <= (mux_select((register_pipe_signals = ("true")), '1', '0'));
      init_k_hip(7 DOWNTO 4) <= int2bin(rx0_adap_fifo_full_value, 4);
      init_k_hip(11 DOWNTO 8) <= int2bin(rx1_adap_fifo_full_value, 4);
      init_k_hip(16 DOWNTO 12) <= int2bin(tx0_adap_fifo_full_value, 5);
      init_k_hip(21 DOWNTO 17) <= int2bin(tx1_adap_fifo_full_value, 5);
      IF (allow_rx_valid_empty = "true") THEN
          init_k_hip(22) <= '1';
      ELSE
          init_k_hip(22) <= '0';
      END IF;
      init_k_bar(0) <= (mux_select((bar0_io_space = ("true")), '1', '0'));
      init_k_bar(2 DOWNTO 1) <= (mux_select((bar0_64bit_mem_space = ("true")), "10", "00"));
      init_k_bar(3) <= (mux_select((bar0_prefetchable = ("true")), '1', '0'));
      IF (bar0_64bit_mem_space = ("true")) THEN
         init_k_bar(63 DOWNTO 4) <= To_StdLogicVector("111111111111111111111111111111111111111111111111111111111111" SLL bin2int(int2bin(bar0_size_mask, 60) - "000000000000000000000000000000000000000000000000000000000100"));
      ELSE
         init_k_bar(31 DOWNTO 4) <= To_StdLogicVector("1111111111111111111111111111" SLL bin2int(int2bin(bar0_size_mask, 28) - "0000000000000000000000000100"));
         init_k_bar(32) <= (mux_select((bar1_io_space = ("true")), '1', '0'));
         init_k_bar(34 DOWNTO 33) <= (mux_select((bar1_64bit_mem_space = ("true")), "10", "00"));
         init_k_bar(35) <= (mux_select((bar1_prefetchable = ("true")), '1', '0'));
         init_k_bar(63 DOWNTO 36) <= To_StdLogicVector("1111111111111111111111111111" SLL bin2int(int2bin(bar1_size_mask, 28) - "0000000000000000000000000100"));
      END IF;
      init_k_bar(64) <= (mux_select((bar2_io_space = ("true")), '1', '0'));
      init_k_bar(66 DOWNTO 65) <= (mux_select((bar2_64bit_mem_space = ("true")), "10", "00"));
      init_k_bar(67) <= (mux_select((bar2_prefetchable = ("true")), '1', '0'));
      IF (bar2_64bit_mem_space = ("true")) THEN
         init_k_bar(127 DOWNTO 68) <= To_StdLogicVector("111111111111111111111111111111111111111111111111111111111111" SLL bin2int(int2bin(bar2_size_mask, 60) - "000000000000000000000000000000000000000000000000000000000100"));
      ELSE
         init_k_bar(95 DOWNTO 68) <= To_StdLogicVector("1111111111111111111111111111" SLL bin2int(int2bin(bar2_size_mask, 28) - "0000000000000000000000000100"));
         init_k_bar(96) <= (mux_select((bar3_io_space = ("true")), '1', '0'));
         init_k_bar(98 DOWNTO 97) <= (mux_select((bar3_64bit_mem_space = ("true")), "10", "00"));
         init_k_bar(99) <= (mux_select((bar3_prefetchable = ("true")), '1', '0'));
         init_k_bar(127 DOWNTO 100) <= To_StdLogicVector("1111111111111111111111111111" SLL bin2int(int2bin(bar3_size_mask, 28) - "0000000000000000000000000100"));
      END IF;
      init_k_bar(128) <= (mux_select((bar4_io_space = ("true")), '1', '0'));
      init_k_bar(130 DOWNTO 129) <= (mux_select((bar4_64bit_mem_space = ("true")), "10", "00"));
      init_k_bar(131) <= (mux_select((bar4_prefetchable = ("true")), '1', '0'));
      IF (bar4_64bit_mem_space = ("true")) THEN
         init_k_bar(191 DOWNTO 132) <= To_StdLogicVector("111111111111111111111111111111111111111111111111111111111111" SLL bin2int(int2bin(bar4_size_mask, 60) - "000000000000000000000000000000000000000000000000000000000100"));
      ELSE
         init_k_bar(159 DOWNTO 132) <= To_StdLogicVector("1111111111111111111111111111" SLL bin2int(int2bin(bar4_size_mask, 28) - "0000000000000000000000000100"));
         init_k_bar(160) <= (mux_select((bar5_io_space = ("true")), '1', '0'));
         init_k_bar(162 DOWNTO 161) <= (mux_select((bar5_64bit_mem_space = ("true")), "10", "00"));
         init_k_bar(163) <= (mux_select((bar5_prefetchable = ("true")), '1', '0'));
         init_k_bar(191 DOWNTO 164) <= To_StdLogicVector("1111111111111111111111111111" SLL bin2int(int2bin(bar5_size_mask, 28) - "0000000000000000000000000100"));
      END IF;
      IF (expansion_base_address_register > 0) THEN
         init_k_bar(223 DOWNTO 192) <= To_StdLogicVector("11111111111111111111111111111111" SLL expansion_base_address_register);
      ELSE
         init_k_bar(223 DOWNTO 192) <= int2bin(expansion_base_address_register, 32);
      END IF;
      init_k_bar(225 DOWNTO 224) <= ((mux_select((bar_io_window_size = ("NONE")), "00", "00")) OR (mux_select((bar_io_window_size = ("16BIT")), "01", "00")) OR (mux_select((bar_io_window_size = ("32BIT")), "10", "00")) OR "00");
      IF (bar_prefetchable = 32) THEN 
          init_k_bar(227 DOWNTO 226) <= "01";
      ELSIF (bar_prefetchable = 64) THEN
          init_k_bar(227 DOWNTO 226) <= "01";
      ELSE
          init_k_bar(227 DOWNTO 226) <= "00";
      END IF;
      init_k_cnt(35 DOWNTO 0) <= "000000000000000000000000000000000000";
      init_k_cnt(39 DOWNTO 36) <= int2bin(rx_cdc_full_value, 4);
      init_k_cnt(43 DOWNTO 40) <= int2bin(tx_cdc_full_value, 4);
      init_k_cnt(51 DOWNTO 44) <= int2bin(rx_idl_os_count, 8);
      init_k_cnt(52) <= '0';
      init_k_cnt(56 DOWNTO 53) <= int2bin(tx_cdc_stop_dummy_full_value, 4);
      init_k_cnt(64 DOWNTO 57) <= int2bin(ei_delay_powerdown_count, 8);
      init_k_cnt(84 DOWNTO 65) <= int2bin(millisecond_cycle_count, 20);
      init_k_cnt(95 DOWNTO 85) <= int2bin(skp_os_schedule_count, 11);
      init_k_cnt(106 DOWNTO 96) <= int2bin(fc_init_timer, 11);
      init_k_cnt(111 DOWNTO 107) <= int2bin(l01_entry_latency, 5);
      init_k_cnt(116 DOWNTO 112) <= int2bin(flow_control_update_count, 5);
      init_k_cnt(127 DOWNTO 120) <= int2bin(flow_control_timeout_count, 8);
      IF (alpha_tolower(credit_buffer_allocation_aux) = ("balanced")) THEN
         init_k_vc0_var(7 DOWNTO 0) := mux_select((use_crc_forwarding = ("true")), "00110010", "00110010");
         init_k_vc0_var(19 DOWNTO 8) := mux_select((use_crc_forwarding = ("true")), "000101010000", "000101101000");
         init_k_vc0_var(27 DOWNTO 20) := mux_select((use_crc_forwarding = ("true")), "00110110", "00110110");
         init_k_vc0_var(35 DOWNTO 28) := mux_select((use_crc_forwarding = ("true")), "00000000", "00000000");
         init_k_vc0_var(43 DOWNTO 36) := mux_select((use_crc_forwarding = ("true")), "01110000", "01110000");
         init_k_vc0_var(55 DOWNTO 44) := mux_select((use_crc_forwarding = ("true")), "000110100100", "000111000000");
         init_k_vc1_var(7 DOWNTO 0) := mux_select((use_crc_forwarding = ("true")), "00110010", "00010000");
         init_k_vc1_var(19 DOWNTO 8) := mux_select((use_crc_forwarding = ("true")), "000101010000", "000101101000");
         init_k_vc1_var(27 DOWNTO 20) := mux_select((use_crc_forwarding = ("true")), "00110110", "00110110");
         init_k_vc1_var(35 DOWNTO 28) := mux_select((use_crc_forwarding = ("true")), "00000000", "00000000");
         init_k_vc1_var(43 DOWNTO 36) := mux_select((use_crc_forwarding = ("true")), "01110000", "01110000");
         
         init_k_vc1_var(55 DOWNTO 44) := mux_select((use_crc_forwarding = ("true")), "000110100100", "000111000000");
         init_k_ptr0 <= calc_k_ptr(init_k_vc0_var, init_use_crc_forwarding_var);
         init_k_ptr1 <= calc_k_ptr(init_k_vc1_var, init_use_crc_forwarding_var);
      ELSIF (alpha_tolower(credit_buffer_allocation_aux) = ("initiator")) THEN
         init_k_vc0_var(7 DOWNTO 0) := mux_select((use_crc_forwarding = ("true")), "00010000", "00010000");
         init_k_vc0_var(19 DOWNTO 8) := mux_select((use_crc_forwarding = ("true")), "000010000000", "000010000000");
         init_k_vc0_var(27 DOWNTO 20) := mux_select((use_crc_forwarding = ("true")), "00010000", "00010000");
         init_k_vc0_var(35 DOWNTO 28) := mux_select((use_crc_forwarding = ("true")), "00000000", "00000000");
         init_k_vc0_var(43 DOWNTO 36) := mux_select((use_crc_forwarding = ("true")), "10000000", "10000000");
         init_k_vc0_var(55 DOWNTO 44) := mux_select((use_crc_forwarding = ("true")), "001011010000", "001011100000");
         init_k_vc1_var(7 DOWNTO 0) := mux_select((use_crc_forwarding = ("true")), "00010000", "00010000");
         init_k_vc1_var(19 DOWNTO 8) := mux_select((use_crc_forwarding = ("true")), "000010000000", "000010000000");
         init_k_vc1_var(27 DOWNTO 20) := mux_select((use_crc_forwarding = ("true")), "00010000", "00010000");
         init_k_vc1_var(35 DOWNTO 28) := mux_select((use_crc_forwarding = ("true")), "00000000", "00000000");
         init_k_vc1_var(43 DOWNTO 36) := mux_select((use_crc_forwarding = ("true")), "10000000", "10000000");
         
         init_k_vc1_var(55 DOWNTO 44) := mux_select((use_crc_forwarding = ("true")), "001011010000", "001011100000");
         init_k_ptr0 <= calc_k_ptr(init_k_vc0_var, init_use_crc_forwarding_var);
         init_k_ptr1 <= calc_k_ptr(init_k_vc1_var, init_use_crc_forwarding_var);
      ELSIF (alpha_tolower(credit_buffer_allocation_aux) = ("target")) THEN
         init_k_vc0_var(7 DOWNTO 0) := mux_select((use_crc_forwarding = ("true")), "01100110", "01100110");
         init_k_vc0_var(19 DOWNTO 8) := mux_select((use_crc_forwarding = ("true")), "001011010011", "001100110000");
         init_k_vc0_var(27 DOWNTO 20) := mux_select((use_crc_forwarding = ("true")), "01010110", "01010110");
         init_k_vc0_var(35 DOWNTO 28) := mux_select((use_crc_forwarding = ("true")), "00000000", "00000000");
         init_k_vc0_var(43 DOWNTO 36) := mux_select((use_crc_forwarding = ("true")), "00000100", "00000100");
         init_k_vc0_var(55 DOWNTO 44) := mux_select((use_crc_forwarding = ("true")), "000000001111", "000000010000");
         init_k_vc1_var(7 DOWNTO 0) := mux_select((use_crc_forwarding = ("true")), "01100110", "01100110");
         init_k_vc1_var(19 DOWNTO 8) := mux_select((use_crc_forwarding = ("true")), "001011010011", "001100110000");
         init_k_vc1_var(27 DOWNTO 20) := mux_select((use_crc_forwarding = ("true")), "01010110", "01010110");
         init_k_vc1_var(35 DOWNTO 28) := mux_select((use_crc_forwarding = ("true")), "00000000", "00000000");
         init_k_vc1_var(43 DOWNTO 36) := mux_select((use_crc_forwarding = ("true")), "00000100", "00000100");
         
         init_k_vc1_var(55 DOWNTO 44) := mux_select((use_crc_forwarding = ("true")), "000000001111", "000000010000");
         init_k_ptr0 <= calc_k_ptr(init_k_vc0_var, init_use_crc_forwarding_var);
         init_k_ptr1 <= calc_k_ptr(init_k_vc1_var, init_use_crc_forwarding_var);
      ELSIF (alpha_tolower(credit_buffer_allocation_aux) = ("absolute")) THEN
         init_k_vc0_var(7 DOWNTO 0) := int2bin(vc0_rx_flow_ctrl_posted_header, 8);
         init_k_vc0_var(19 DOWNTO 8) := int2bin(vc0_rx_flow_ctrl_posted_data, 12);
         init_k_vc0_var(27 DOWNTO 20) := int2bin(vc0_rx_flow_ctrl_nonposted_header, 8);
         init_k_vc0_var(35 DOWNTO 28) := int2bin(vc0_rx_flow_ctrl_nonposted_data, 8);
         init_k_vc0_var(43 DOWNTO 36) := int2bin(vc0_rx_flow_ctrl_compl_header, 8);
         init_k_vc0_var(55 DOWNTO 44) := int2bin(vc0_rx_flow_ctrl_compl_data, 12);
         init_k_vc1_var(7 DOWNTO 0) := int2bin(vc1_rx_flow_ctrl_posted_header, 8);
         init_k_vc1_var(19 DOWNTO 8) := int2bin(vc1_rx_flow_ctrl_posted_data, 12);
         init_k_vc1_var(27 DOWNTO 20) := int2bin(vc1_rx_flow_ctrl_nonposted_header, 8);
         init_k_vc1_var(35 DOWNTO 28) := int2bin(vc1_rx_flow_ctrl_nonposted_data, 8);
         init_k_vc1_var(43 DOWNTO 36) := int2bin(vc1_rx_flow_ctrl_compl_header, 8);
         
         init_k_vc1_var(55 DOWNTO 44) := int2bin(vc1_rx_flow_ctrl_compl_data, 12);
         init_k_ptr0(10 DOWNTO 0) <= int2bin(rx_ptr0_posted_dpram_min, 11);
         init_k_ptr0(21 DOWNTO 11) <= int2bin(rx_ptr0_posted_dpram_max, 11);
         init_k_ptr0(32 DOWNTO 22) <= int2bin(rx_ptr0_nonposted_dpram_min, 11);
         init_k_ptr0(43 DOWNTO 33) <= int2bin(rx_ptr0_nonposted_dpram_max, 11);
         init_k_ptr1(10 DOWNTO 0) <= int2bin(rx_ptr1_posted_dpram_min, 11);
         init_k_ptr1(21 DOWNTO 11) <= int2bin(rx_ptr1_posted_dpram_max, 11);
         init_k_ptr1(32 DOWNTO 22) <= int2bin(rx_ptr1_nonposted_dpram_min, 11);
         init_k_ptr1(43 DOWNTO 33) <= int2bin(rx_ptr1_nonposted_dpram_max, 11);
      END IF;
      
	  -- 273577: overwrite to advertise infinite complete after calc_k_ptr
	  init_k_vc0_var(55 DOWNTO 36) := "00000000000000000000"; 
	  init_k_vc1_var(55 DOWNTO 36) := "00000000000000000000"; 
      
      init_k_rtry(10 DOWNTO 0) <= int2bin(retry_buffer_last_active_address, 11);
      init_k_rtry_mem(29 DOWNTO 0) <= int2bin(retry_buffer_memory_settings, 30);
      init_k_rcv0_mem(29 DOWNTO 0) <= int2bin(vc0_rx_buffer_memory_settings,30);
      init_k_rcv1_mem(29 DOWNTO 0) <= int2bin(vc1_rx_buffer_memory_settings,30);		--mram_bist_settings;
      --init_k_rcv_mem0(15 DOWNTO 0) <= int2bin(vc0_rx_buffer_memory_settings, 16);
      --init_k_rcv_mem1(15 DOWNTO 0) <= int2bin(vc1_rx_buffer_memory_settings, 16);		--mram_bist_settings;
      init_k_mem_bist(74 DOWNTO 0) <= "000000000000000000000000000000000000000000000000000000000000000000000000000";
      init_k_core_clk_dbg_sel <= '0';
      
      init_use_crc_forwarding <= init_use_crc_forwarding_var;
      init_k_vc1 <= init_k_vc1_var;
      init_k_vc0 <= init_k_vc0_var;

      WAIT;
      
   END PROCESS;
   
   
   --/////////////////////////////////////////////////////////////////////
   -- init registers to k_bits  ----------------------------------------//
   --/////////////////////////////////////////////////////////////////////
   
   k_bar_func0 <= init_k_bar;		--sw param name twisted
   k_clk_x8_sel_rcv0 <= init_k_clk_x8_sel_rcv0;
   k_clk_x8_sel_rcv1 <= init_k_clk_x8_sel_rcv1;
   k_clk_x8_sel_rtry <= init_k_clk_x8_sel_rtry;
   k_cnt <= init_k_cnt;
   k_conf_func0 <= init_k_conf;		-- sw param name twisted
   k_core_clk_div_sel <= init_k_core_clk_div_sel;
   k_core_clk_out_sel <= init_k_core_clk_out_sel;
   k_core_clk_source_sel <= init_k_core_clk_source_sel;
   k_dev <= init_k_dev;
   k_ecc_enable_rtry <= init_k_ecc_enable_rtry;
   k_ecc_enable_rcv0 <= init_k_ecc_enable_rcv0;
   k_ecc_enable_rcv1 <= init_k_ecc_enable_rcv1;
   k_gbl <= init_k_gbl;
   k_hip <= init_k_hip;
   k_iei_enable <= init_k_iei_enable;
   k_mem_bist <= init_k_mem_bist;
   k_pclk_sel <= init_k_pclk_sel;
   k_pipex1_dbg_sel <= init_k_pipex1_dbg_sel;
   k_port <= init_k_port;
   k_ptr0 <= init_k_ptr0;
   k_ptr1 <= init_k_ptr1;
   --k_rcv_mem0 <= init_k_rcv_mem0;
   --k_rcv_mem1 <= init_k_rcv_mem1;
   k_rcv0_mem <= init_k_rcv0_mem;
   k_rcv0_outreg <= init_k_rcv0_outreg;
   k_rcv0_raen2 <= init_k_rcv0_raen2;
   k_rcv0_rben1 <= init_k_rcv0_rben1;
   k_rcv1_mem <= init_k_rcv1_mem;
   k_rcv1_outreg <= init_k_rcv1_outreg;
   k_rcv1_raen2 <= init_k_rcv1_raen2;
   k_rcv1_rben1 <= init_k_rcv1_rben1;
   k_rtry <= init_k_rtry;
   k_rtry_mem <= init_k_rtry_mem;
   k_rtry_outreg <= init_k_rtry_outreg;
   k_rtry_raen2 <= init_k_rtry_raen2;
   k_rtry_rben1 <= init_k_rtry_rben1;
   k_vc0 <= init_k_vc0;
   k_vc1 <= init_k_vc1;
   k_vc2 <= init_k_vc2;
   k_vc3 <= init_k_vc3;
   k_vc4 <= init_k_vc4;
   k_vc5 <= init_k_vc5;
   k_vc6 <= init_k_vc6;
   k_vc7 <= init_k_vc7;
   
   k_core_clk_dbg_sel <= init_k_core_clk_dbg_sel;

   --/////////////////////////////////////////////////////////////////////
   -- k_bits to dprio registers  ---------------------------------------//
   --/////////////////////////////////////////////////////////////////////
   
   ext_hip_ctrl_1 <= k_gbl(15 DOWNTO 0);
   ext_hip_ctrl_2 <= k_gbl(31 DOWNTO 16);
   ext_hip_ctrl_3 <= k_gbl(47 DOWNTO 32);
   ext_hip_ctrl_4 <= k_gbl(63 DOWNTO 48);
   ext_hip_ctrl_5(15 DOWNTO 11) <= k_dev(4 DOWNTO 0);
   ext_hip_ctrl_5(7 DOWNTO 0) <= k_port(7 DOWNTO 0);
   
   -- Register 6[6:0] for clk mux selection, bit [7]  to select 
   -- dbg_pipex1_rx or dbg_pipex1_tx signals, bit [8] to enable IEI logic
   ext_hip_ctrl_7(8 DOWNTO 7)   <= k_clk_x8_sel_rtry(3 DOWNTO 2);
   ext_hip_ctrl_7(6 DOWNTO 5)   <= k_clk_x8_sel_rcv1(3 DOWNTO 2);
   ext_hip_ctrl_7(4 DOWNTO 3)   <= k_clk_x8_sel_rcv0(3 DOWNTO 2);
   ext_hip_ctrl_6(15 DOWNTO 14) <= k_clk_x8_sel_rtry(1 DOWNTO 0);
   ext_hip_ctrl_6(13 DOWNTO 12) <= k_clk_x8_sel_rcv1(1 DOWNTO 0);
   ext_hip_ctrl_6(11 DOWNTO 10) <= k_clk_x8_sel_rcv0(1 DOWNTO 0);
   -- ext_hip_ctrl_6(9 DOWNTO 8) <= k_iei_enable;
   
   ext_hip_ctrl_6(7) <= k_pipex1_dbg_sel;
   
   ext_hip_ctrl_6(6) <= k_pclk_sel;
   ext_hip_ctrl_6(5 DOWNTO 4) <= k_core_clk_source_sel;
   ext_hip_ctrl_6(3 DOWNTO 1) <= k_core_clk_div_sel;
   ext_hip_ctrl_6(0) <= k_core_clk_out_sel;
   ext_hip_ctrl_7(9) <= k_core_clk_dbg_sel;
   
   -- Register 7 is used for Adapter functions
   
   ext_hip_ctrl_7(0) <= k_ecc_enable_rcv0;
   ext_hip_ctrl_7(1) <= k_ecc_enable_rcv1;
   ext_hip_ctrl_7(2) <= k_ecc_enable_rtry;
   ext_hip_ctrl_7(15 DOWNTO 12) <= k_hip(7 DOWNTO 4);
   
   -- Register 8 is used for Adapter functions
   
   ext_hip_ctrl_8(3 DOWNTO 0) <= k_hip(11 DOWNTO 8);
   ext_hip_ctrl_8(8 DOWNTO 4) <= k_hip(16 DOWNTO 12);
   ext_hip_ctrl_8(14 DOWNTO 9) <= k_hip(22 DOWNTO 17);
   
   ext_hip_ctrl_9 <= k_conf_func0(15 DOWNTO 0);
   ext_hip_ctrl_10 <= k_conf_func0(31 DOWNTO 16);
   ext_hip_ctrl_11 <= k_conf_func0(47 DOWNTO 32);
   ext_hip_ctrl_12 <= k_conf_func0(63 DOWNTO 48);
   ext_hip_ctrl_13 <= k_conf_func0(79 DOWNTO 64);
   ext_hip_ctrl_14 <= k_conf_func0(95 DOWNTO 80);
   ext_hip_ctrl_15 <= k_conf_func0(111 DOWNTO 96);
   ext_hip_ctrl_16 <= k_conf_func0(127 DOWNTO 112);
   ext_hip_ctrl_17 <= k_conf_func0(143 DOWNTO 128);
   ext_hip_ctrl_18 <= k_conf_func0(159 DOWNTO 144);
   ext_hip_ctrl_19 <= k_conf_func0(175 DOWNTO 160);
   ext_hip_ctrl_20 <= k_conf_func0(191 DOWNTO 176);
   ext_hip_ctrl_21 <= k_conf_func0(207 DOWNTO 192);
   ext_hip_ctrl_22 <= k_conf_func0(223 DOWNTO 208);
   ext_hip_ctrl_23 <= k_conf_func0(239 DOWNTO 224);
   ext_hip_ctrl_24 <= k_conf_func0(255 DOWNTO 240);
   ext_hip_ctrl_25 <= k_conf_func0(271 DOWNTO 256);
   ext_hip_ctrl_26 <= k_conf_func0(287 DOWNTO 272);
   ext_hip_ctrl_27 <= k_conf_func0(303 DOWNTO 288);
   ext_hip_ctrl_28 <= k_conf_func0(319 DOWNTO 304);
   ext_hip_ctrl_29 <= k_conf_func0(335 DOWNTO 320);
   ext_hip_ctrl_30 <= k_conf_func0(351 DOWNTO 336);
   ext_hip_ctrl_31 <= k_conf_func0(367 DOWNTO 352);
   ext_hip_ctrl_32 <= k_conf_func0(383 DOWNTO 368);
   ext_hip_ctrl_33 <= k_bar_func0(15 DOWNTO 0);
   ext_hip_ctrl_34 <= k_bar_func0(31 DOWNTO 16);
   ext_hip_ctrl_35 <= k_bar_func0(47 DOWNTO 32);
   ext_hip_ctrl_36 <= k_bar_func0(63 DOWNTO 48);
   ext_hip_ctrl_37 <= k_bar_func0(79 DOWNTO 64);
   ext_hip_ctrl_38 <= k_bar_func0(95 DOWNTO 80);
   ext_hip_ctrl_39 <= k_bar_func0(111 DOWNTO 96);
   ext_hip_ctrl_40 <= k_bar_func0(127 DOWNTO 112);
   ext_hip_ctrl_41 <= k_bar_func0(143 DOWNTO 128);
   ext_hip_ctrl_42 <= k_bar_func0(159 DOWNTO 144);
   ext_hip_ctrl_43 <= k_bar_func0(175 DOWNTO 160);
   ext_hip_ctrl_44 <= k_bar_func0(191 DOWNTO 176);
   ext_hip_ctrl_45 <= k_bar_func0(207 DOWNTO 192);
   ext_hip_ctrl_46 <= k_bar_func0(223 DOWNTO 208);
   ext_hip_ctrl_47(3 DOWNTO 0) <= k_bar_func0(227 DOWNTO 224);
   ext_hip_ctrl_48 <= k_cnt(15 DOWNTO 0);
   ext_hip_ctrl_49 <= k_cnt(31 DOWNTO 16);
   ext_hip_ctrl_50 <= k_cnt(47 DOWNTO 32);
   ext_hip_ctrl_51 <= k_cnt(63 DOWNTO 48);
   ext_hip_ctrl_52 <= k_cnt(79 DOWNTO 64);
   ext_hip_ctrl_53 <= k_cnt(95 DOWNTO 80);
   ext_hip_ctrl_54 <= k_cnt(111 DOWNTO 96);
   ext_hip_ctrl_55 <= k_cnt(127 DOWNTO 112);
   ext_hip_ctrl_56 <= k_vc0(15 DOWNTO 0);
   ext_hip_ctrl_57 <= k_vc0(31 DOWNTO 16);
   ext_hip_ctrl_58 <= k_vc0(47 DOWNTO 32);
   ext_hip_ctrl_59(7 DOWNTO 0) <= k_vc0(55 DOWNTO 48);
   ext_hip_ctrl_60 <= k_vc1(15 DOWNTO 0);
   ext_hip_ctrl_61 <= k_vc1(31 DOWNTO 16);
   ext_hip_ctrl_62 <= k_vc1(47 DOWNTO 32);
   ext_hip_ctrl_63(7 DOWNTO 0) <= k_vc1(55 DOWNTO 48);
   ext_hip_ctrl_64 <= k_vc2(15 DOWNTO 0);
   ext_hip_ctrl_65 <= k_vc2(31 DOWNTO 16);
   ext_hip_ctrl_66 <= k_vc2(47 DOWNTO 32);
   ext_hip_ctrl_67(7 DOWNTO 0) <= k_vc2(55 DOWNTO 48);
   ext_hip_ctrl_68 <= k_vc3(15 DOWNTO 0);
   ext_hip_ctrl_69 <= k_vc3(31 DOWNTO 16);
   ext_hip_ctrl_70 <= k_vc3(47 DOWNTO 32);
   ext_hip_ctrl_71(7 DOWNTO 0) <= k_vc3(55 DOWNTO 48);
   ext_hip_ctrl_72 <= k_vc4(15 DOWNTO 0);
   ext_hip_ctrl_73 <= k_vc4(31 DOWNTO 16);
   ext_hip_ctrl_74 <= k_vc4(47 DOWNTO 32);
   ext_hip_ctrl_75(7 DOWNTO 0) <= k_vc4(55 DOWNTO 48);
   ext_hip_ctrl_76 <= k_vc5(15 DOWNTO 0);
   ext_hip_ctrl_77 <= k_vc5(31 DOWNTO 16);
   ext_hip_ctrl_78 <= k_vc5(47 DOWNTO 32);
   ext_hip_ctrl_79(7 DOWNTO 0) <= k_vc5(55 DOWNTO 48);
   ext_hip_ctrl_80 <= k_vc6(15 DOWNTO 0);
   ext_hip_ctrl_81 <= k_vc6(31 DOWNTO 16);
   ext_hip_ctrl_82 <= k_vc6(47 DOWNTO 32);
   ext_hip_ctrl_83(7 DOWNTO 0) <= k_vc6(55 DOWNTO 48);
   ext_hip_ctrl_84 <= k_vc7(15 DOWNTO 0);
   ext_hip_ctrl_85 <= k_vc7(31 DOWNTO 16);
   ext_hip_ctrl_86 <= k_vc7(47 DOWNTO 32);
   ext_hip_ctrl_87(7 DOWNTO 0) <= k_vc7(55 DOWNTO 48);
   ext_hip_ctrl_88(15 DOWNTO 12) <= k_hip(3 DOWNTO 0);
   ext_hip_ctrl_88(10 DOWNTO 0) <= k_rtry(10 DOWNTO 0);
   ext_hip_ctrl_89 <= k_ptr0(15 DOWNTO 0);
   ext_hip_ctrl_90 <= k_ptr0(31 DOWNTO 16);
   ext_hip_ctrl_91(11 DOWNTO 0) <= k_ptr0(43 DOWNTO 32);
   ext_hip_ctrl_92 <= k_ptr1(15 DOWNTO 0);
   ext_hip_ctrl_93 <= k_ptr1(31 DOWNTO 16);
   ext_hip_ctrl_94(11 DOWNTO 0) <= k_ptr1(43 DOWNTO 32);
   ext_hip_ctrl_95 <= k_mem_bist(15 DOWNTO 0);
   ext_hip_ctrl_96 <= k_mem_bist(31 DOWNTO 16);
   ext_hip_ctrl_97 <= k_mem_bist(47 DOWNTO 32);
   ext_hip_ctrl_98 <= k_mem_bist(63 DOWNTO 48);
   ext_hip_ctrl_99(10 DOWNTO 0) <= k_mem_bist(74 DOWNTO 64);
   
   ext_hip_ctrl_100(14 DOWNTO 0) <= k_rtry_mem(14 DOWNTO 0)        ;
   ext_hip_ctrl_101(14 DOWNTO 0) <= k_rcv0_mem(14 DOWNTO 0)        ;
   ext_hip_ctrl_102(14 DOWNTO 0) <= k_rcv1_mem(14 DOWNTO 0)        ;
	
   ext_hip_ctrl_103(14 DOWNTO 0) <= k_rtry_mem(29 DOWNTO 15)       ;
   ext_hip_ctrl_104(14 DOWNTO 0) <= k_rcv0_mem(29 DOWNTO 15)       ;
   ext_hip_ctrl_105(14 DOWNTO 0) <= k_rcv1_mem(29 DOWNTO 15)       ;
   ext_hip_ctrl_106(5 DOWNTO 0)  <= k_iei_enable            ;
   
   --/////////////////////////////////////////////////////////////////////
   -- ext_hip_ctrl to csr_hip_in ---------------------------------------//
   --/////////////////////////////////////////////////////////////////////
   
   csr_hip_in(15 DOWNTO 0) <= ext_hip_ctrl_1;
   csr_hip_in(31 DOWNTO 16) <= ext_hip_ctrl_2;
   csr_hip_in(47 DOWNTO 32) <= ext_hip_ctrl_3;
   csr_hip_in(63 DOWNTO 48) <= ext_hip_ctrl_4;
   csr_hip_in(79 DOWNTO 64) <= ext_hip_ctrl_5;
   csr_hip_in(95 DOWNTO 80) <= ext_hip_ctrl_6;
   csr_hip_in(111 DOWNTO 96) <= ext_hip_ctrl_7;
   csr_hip_in(127 DOWNTO 112) <= ext_hip_ctrl_8;
   csr_hip_in(143 DOWNTO 128) <= ext_hip_ctrl_9;
   csr_hip_in(159 DOWNTO 144) <= ext_hip_ctrl_10;
   csr_hip_in(175 DOWNTO 160) <= ext_hip_ctrl_11;
   csr_hip_in(191 DOWNTO 176) <= ext_hip_ctrl_12;
   csr_hip_in(207 DOWNTO 192) <= ext_hip_ctrl_13;
   csr_hip_in(223 DOWNTO 208) <= ext_hip_ctrl_14;
   csr_hip_in(239 DOWNTO 224) <= ext_hip_ctrl_15;
   csr_hip_in(255 DOWNTO 240) <= ext_hip_ctrl_16;
   csr_hip_in(271 DOWNTO 256) <= ext_hip_ctrl_17;
   csr_hip_in(287 DOWNTO 272) <= ext_hip_ctrl_18;
   csr_hip_in(303 DOWNTO 288) <= ext_hip_ctrl_19;
   csr_hip_in(319 DOWNTO 304) <= ext_hip_ctrl_20;
   csr_hip_in(335 DOWNTO 320) <= ext_hip_ctrl_21;
   csr_hip_in(351 DOWNTO 336) <= ext_hip_ctrl_22;
   csr_hip_in(367 DOWNTO 352) <= ext_hip_ctrl_23;
   csr_hip_in(383 DOWNTO 368) <= ext_hip_ctrl_24;
   csr_hip_in(399 DOWNTO 384) <= ext_hip_ctrl_25;
   csr_hip_in(415 DOWNTO 400) <= ext_hip_ctrl_26;
   csr_hip_in(431 DOWNTO 416) <= ext_hip_ctrl_27;
   csr_hip_in(447 DOWNTO 432) <= ext_hip_ctrl_28;
   csr_hip_in(463 DOWNTO 448) <= ext_hip_ctrl_29;
   csr_hip_in(479 DOWNTO 464) <= ext_hip_ctrl_30;
   csr_hip_in(495 DOWNTO 480) <= ext_hip_ctrl_31;
   csr_hip_in(511 DOWNTO 496) <= ext_hip_ctrl_32;
   csr_hip_in(527 DOWNTO 512) <= ext_hip_ctrl_33;
   csr_hip_in(543 DOWNTO 528) <= ext_hip_ctrl_34;
   csr_hip_in(559 DOWNTO 544) <= ext_hip_ctrl_35;
   csr_hip_in(575 DOWNTO 560) <= ext_hip_ctrl_36;
   csr_hip_in(591 DOWNTO 576) <= ext_hip_ctrl_37;
   csr_hip_in(607 DOWNTO 592) <= ext_hip_ctrl_38;
   csr_hip_in(623 DOWNTO 608) <= ext_hip_ctrl_39;
   csr_hip_in(639 DOWNTO 624) <= ext_hip_ctrl_40;
   csr_hip_in(655 DOWNTO 640) <= ext_hip_ctrl_41;
   csr_hip_in(671 DOWNTO 656) <= ext_hip_ctrl_42;
   csr_hip_in(687 DOWNTO 672) <= ext_hip_ctrl_43;
   csr_hip_in(703 DOWNTO 688) <= ext_hip_ctrl_44;
   csr_hip_in(719 DOWNTO 704) <= ext_hip_ctrl_45;
   csr_hip_in(735 DOWNTO 720) <= ext_hip_ctrl_46;
   csr_hip_in(751 DOWNTO 736) <= ext_hip_ctrl_47;
   csr_hip_in(767 DOWNTO 752) <= ext_hip_ctrl_48;
   csr_hip_in(783 DOWNTO 768) <= ext_hip_ctrl_49;
   csr_hip_in(799 DOWNTO 784) <= ext_hip_ctrl_50;
   csr_hip_in(815 DOWNTO 800) <= ext_hip_ctrl_51;
   csr_hip_in(831 DOWNTO 816) <= ext_hip_ctrl_52;
   csr_hip_in(847 DOWNTO 832) <= ext_hip_ctrl_53;
   csr_hip_in(863 DOWNTO 848) <= ext_hip_ctrl_54;
   csr_hip_in(879 DOWNTO 864) <= ext_hip_ctrl_55;
   csr_hip_in(895 DOWNTO 880) <= ext_hip_ctrl_56;
   csr_hip_in(911 DOWNTO 896) <= ext_hip_ctrl_57;
   csr_hip_in(927 DOWNTO 912) <= ext_hip_ctrl_58;
   csr_hip_in(943 DOWNTO 928) <= ext_hip_ctrl_59;
   csr_hip_in(959 DOWNTO 944) <= ext_hip_ctrl_60;
   csr_hip_in(975 DOWNTO 960) <= ext_hip_ctrl_61;
   csr_hip_in(991 DOWNTO 976) <= ext_hip_ctrl_62;
   csr_hip_in(1007 DOWNTO 992) <= ext_hip_ctrl_63;
   csr_hip_in(1023 DOWNTO 1008) <= ext_hip_ctrl_64;
   csr_hip_in(1039 DOWNTO 1024) <= ext_hip_ctrl_65;
   csr_hip_in(1055 DOWNTO 1040) <= ext_hip_ctrl_66;
   csr_hip_in(1071 DOWNTO 1056) <= ext_hip_ctrl_67;
   csr_hip_in(1087 DOWNTO 1072) <= ext_hip_ctrl_68;
   csr_hip_in(1103 DOWNTO 1088) <= ext_hip_ctrl_69;
   csr_hip_in(1119 DOWNTO 1104) <= ext_hip_ctrl_70;
   csr_hip_in(1135 DOWNTO 1120) <= ext_hip_ctrl_71;
   csr_hip_in(1151 DOWNTO 1136) <= ext_hip_ctrl_72;
   csr_hip_in(1167 DOWNTO 1152) <= ext_hip_ctrl_73;
   csr_hip_in(1183 DOWNTO 1168) <= ext_hip_ctrl_74;
   csr_hip_in(1199 DOWNTO 1184) <= ext_hip_ctrl_75;
   csr_hip_in(1215 DOWNTO 1200) <= ext_hip_ctrl_76;
   csr_hip_in(1231 DOWNTO 1216) <= ext_hip_ctrl_77;
   csr_hip_in(1247 DOWNTO 1232) <= ext_hip_ctrl_78;
   csr_hip_in(1263 DOWNTO 1248) <= ext_hip_ctrl_79;
   csr_hip_in(1279 DOWNTO 1264) <= ext_hip_ctrl_80;
   csr_hip_in(1295 DOWNTO 1280) <= ext_hip_ctrl_81;
   csr_hip_in(1311 DOWNTO 1296) <= ext_hip_ctrl_82;
   csr_hip_in(1327 DOWNTO 1312) <= ext_hip_ctrl_83;
   csr_hip_in(1343 DOWNTO 1328) <= ext_hip_ctrl_84;
   csr_hip_in(1359 DOWNTO 1344) <= ext_hip_ctrl_85;
   csr_hip_in(1375 DOWNTO 1360) <= ext_hip_ctrl_86;
   csr_hip_in(1391 DOWNTO 1376) <= ext_hip_ctrl_87;
   csr_hip_in(1407 DOWNTO 1392) <= ext_hip_ctrl_88;
   csr_hip_in(1423 DOWNTO 1408) <= ext_hip_ctrl_89;
   csr_hip_in(1439 DOWNTO 1424) <= ext_hip_ctrl_90;
   csr_hip_in(1455 DOWNTO 1440) <= ext_hip_ctrl_91;
   csr_hip_in(1471 DOWNTO 1456) <= ext_hip_ctrl_92;
   csr_hip_in(1487 DOWNTO 1472) <= ext_hip_ctrl_93;
   csr_hip_in(1503 DOWNTO 1488) <= ext_hip_ctrl_94;
   csr_hip_in(1519 DOWNTO 1504) <= ext_hip_ctrl_95;
   csr_hip_in(1535 DOWNTO 1520) <= ext_hip_ctrl_96;
   csr_hip_in(1551 DOWNTO 1536) <= ext_hip_ctrl_97;
   csr_hip_in(1567 DOWNTO 1552) <= ext_hip_ctrl_98;
   csr_hip_in(1583 DOWNTO 1568) <= ext_hip_ctrl_99;
   csr_hip_in(1599 DOWNTO 1584) <= ext_hip_ctrl_100;
   csr_hip_in(1615 DOWNTO 1600) <= ext_hip_ctrl_101;
   csr_hip_in(1631 DOWNTO 1616) <= ext_hip_ctrl_102;
	
   csr_hip_in(1647 DOWNTO 1632)  <= ext_hip_ctrl_103   ;
   csr_hip_in(1663 DOWNTO 1648)  <= ext_hip_ctrl_104   ;
   csr_hip_in(1679 DOWNTO 1664)  <= ext_hip_ctrl_105   ;
   csr_hip_in(1695 DOWNTO 1680)  <= ext_hip_ctrl_106   ;
   csr_hip_in(1711 DOWNTO 1696)  <= ext_hip_ctrl_107   ;
   csr_hip_in(1727 DOWNTO 1712)  <= ext_hip_ctrl_108   ;
   csr_hip_in(1743 DOWNTO 1728)  <= ext_hip_ctrl_109   ;
   csr_hip_in(1759 DOWNTO 1744)  <= ext_hip_ctrl_110   ;
   
END trans;



LIBRARY ieee;
    USE ieee.std_logic_1164.all;
    USE ieee.std_logic_unsigned.all;

--====Revision Log================
--Rev: 1.6   Fri Mar 14 14:14:11 PDT 2008  

--****************************************************************************
--Copyright  2007 -- Altera Corporation
--This confidential code was developed by and is owned by Altera Corporation
--Please do not distribute, copy, modify or reproduce 
--without proper written authorization. Please destroy all
--copies immediately upon receipt if you have not received such authorization.
--****************************************************************************

--*********************************************************
-- Description
-- This module contains clock generations of pclk_out, core_clk and core_clk_out clocks.
-- pclk goes to the Phy MAC, core_clk to TL/DLL, and core_clk_out to the PLD core.
-- When in Scan mode (scan_en=1), all output clocks follow core_clk_in from the PLD
-- core. When in normal operation, the clocks derive their sources from different
-- inputs based on the CRAMs r_pclk_sel, r_core_clk_source_sel.
-- r_pclk_sel=0 : pclk_central drives pclk_out
-- r_pclk_sel=1 : pclk_ch0 drives pclk_out
-- r_core_clk_source_sel=00 : pll_fixed_clk (500MHz) drives core_clk
--			=01 : pclk_out drives core_clk
--			=10 : core_clk_in drives core_clk
--			=11 : pll_fixed_clk drives core_clk
-- core_clk can be divided down by ratios as shown below:
-- r_core_clk_div_sel	=000: div-by-1 core_clk
--			=001: div-by-2 core_clk
--			=010: div_by_1 core_clk
--			=011: div_by_4 core_clk
--			=100: div_by_1 core_clk
--			=101: div_by_8 core_clk
--			=110: div_by_1 core_clk
--			=111: div_by_16 core_clk
-- r_core_clk_out_sel	=0  : core_clk_out is div_by_1 version of core_clk
--			=1  : core_clk_out is div_by_2 version of core_clk
--
--*********************************************************

ENTITY stratixiv_pciehip_clkmux IS
    PORT (
        
        resetn                            : IN STD_LOGIC;		-- resetn for clock dividers
        scan_mode                         : IN STD_LOGIC;		-- Scan Enable
        pclk_ch0                          : IN STD_LOGIC;		-- PCLK from Channel 0
        pclk_central                      : IN STD_LOGIC;		-- PCLK from Central block
        pll_fixed_clk                     : IN STD_LOGIC;		-- 500MHz clock from PMA PLL
        core_clk_in                       : IN STD_LOGIC;		-- input clock from PLD core
        r_pclk_sel                        : IN STD_LOGIC;		-- RAM bit to select source for PCLK
        r_core_clk_source_sel             : IN STD_LOGIC_VECTOR(1 DOWNTO 0);		-- RAM bits to select core_clk source
        r_core_clk_div_sel                : IN STD_LOGIC_VECTOR(2 DOWNTO 0);		-- RAM bits to select division factor for core_clk
        r_core_clk_out_sel                : IN STD_LOGIC;		-- RAM bit to select div-by-2 core_clk to PLD
        r_core_clk_dbg_sel                : IN STD_LOGIC;		-- RAM bit to select core_clk to PHY MAC
        
        pclk_out                          : OUT STD_LOGIC;		-- PCLK output to PHY MAC
        core_clk                          : OUT STD_LOGIC;		-- core_clk output to TL and DLL
        core_clk_out                      : OUT STD_LOGIC		-- core_clk output to the PLD core
    );
END stratixiv_pciehip_clkmux;

ARCHITECTURE trans OF stratixiv_pciehip_clkmux IS
    
    SIGNAL core_clk_by1                     : STD_LOGIC;
    SIGNAL srst1                            : STD_LOGIC;
    SIGNAL srst_coreclkout1                 : STD_LOGIC;
    
    SIGNAL srst0                            : STD_LOGIC;
    SIGNAL srst1_int                        : STD_LOGIC;
    SIGNAL srst_coreclkout0                 : STD_LOGIC;
    SIGNAL srst_coreclkout1_int             : STD_LOGIC;
    SIGNAL core_clk_int                     : STD_LOGIC;
    SIGNAL core_clk_cnt                     : STD_LOGIC_VECTOR(3 DOWNTO 0);
    
    SIGNAL core_clk_by2                     : STD_LOGIC;
    
    -- Declare intermediate signals for referenced outputs
    SIGNAL pclk_out_xhdl1                   : STD_LOGIC;
    SIGNAL core_clk_xhdl0                   : STD_LOGIC;
BEGIN
    -- Drive referenced outputs
    pclk_out <= pclk_out_xhdl1;
    core_clk <= core_clk_xhdl0;
    
    -- ========================
    -- pclk source selection
    -- ========================
    -- Select between the Channel 0 PCLK and the central PCLK
    pclk_out_xhdl1 <= core_clk_in WHEN ((scan_mode OR r_core_clk_dbg_sel) = '1') ELSE		-- Scan always uses core_clk_in, otherwise 
                      pclk_ch0 WHEN (r_pclk_sel = '1') ELSE
                      pclk_central;
    -- default to pclk_central
    -- ========================
    -- core_clk source selection
    -- ========================
    
    -- clocks are assigned below in the order in which they appear in the out flowing clock path
    -- to core_clk_out pin
    core_clk_by1 <= core_clk_in WHEN (scan_mode = '1') ELSE
                    pclk_out_xhdl1 WHEN (r_core_clk_source_sel = "01") ELSE
                    core_clk_in WHEN (r_core_clk_source_sel = "10") ELSE
                    pll_fixed_clk;
    
    -- create sync. reset
    PROCESS (resetn, core_clk_by1)
    BEGIN
        IF ((NOT(resetn)) = '1') THEN
            srst0 <= '1';
            srst1_int <= '1';
        ELSIF (core_clk_by1'EVENT AND core_clk_by1 = '1') THEN
            srst0 <= '0';
            srst1_int <= srst0;
        END IF;
    END PROCESS;
    
    
    -- Block the reset signal when in Scan mode
    srst1 <= '0' WHEN (scan_mode = '1') ELSE
             srst1_int;
    
    -- core_clk division
    --  if (reset)
    PROCESS (srst1, core_clk_by1)
    BEGIN
        IF (srst1 = '1') THEN
            core_clk_int <= '0';
            core_clk_cnt <= "0000";
        ELSIF (core_clk_by1'EVENT AND core_clk_by1 = '1') THEN
            
            core_clk_cnt <= core_clk_cnt + "0001";
            CASE r_core_clk_div_sel(2 DOWNTO 1) IS		-- div-by-4
                WHEN "01" =>		-- div-by-8
               core_clk_int <=  TRANSPORT core_clk_cnt(1) AFTER 1* 1 ps;
                WHEN "10" =>		-- div-by-16
               core_clk_int <=  TRANSPORT core_clk_cnt(2) AFTER 1* 1 ps;
                WHEN "11" =>		-- div-by-2
               core_clk_int <=  TRANSPORT core_clk_cnt(3) AFTER 1* 1 ps;
                WHEN OTHERS =>
               core_clk_int <=  TRANSPORT core_clk_cnt(0) AFTER 1* 1 ps;
            END CASE;
        END IF;
    END PROCESS;
    
    
    core_clk_xhdl0 <= core_clk_by1 WHEN ((scan_mode = '1') OR (r_core_clk_div_sel(0) = '0')) ELSE		-- core_clk to TL and DLL
                      core_clk_int;
    
    -- ========================
    -- core_clk_out selection
    -- ========================
    -- This register is used to generate divided by two clock.
    
    -- always @(negedge resetn or posedge core_clk_by1)
    PROCESS (resetn, core_clk_xhdl0)
    BEGIN
        IF ((NOT(resetn)) = '1') THEN
            srst_coreclkout0 <= '1';
            srst_coreclkout1_int <= '1';
        ELSIF (core_clk_xhdl0'EVENT AND core_clk_xhdl0 = '1') THEN
            srst_coreclkout0 <= '0';
            srst_coreclkout1_int <= srst_coreclkout0;
        END IF;
    END PROCESS;
    
    
    -- Block the reset signal when in Scan mode
    srst_coreclkout1 <= '0' WHEN (scan_mode = '1') ELSE
                        srst_coreclkout1_int;
    
    PROCESS (srst_coreclkout1, core_clk_xhdl0)
    BEGIN
        IF (srst_coreclkout1 = '1') THEN
         core_clk_by2 <=  TRANSPORT '0' AFTER 1* 1 ps;
        ELSIF (core_clk_xhdl0'EVENT AND core_clk_xhdl0 = '1') THEN
            core_clk_by2 <= NOT(core_clk_by2);
        END IF;
    END PROCESS;
    
    
    core_clk_out <= core_clk_by2 WHEN (r_core_clk_out_sel = '1') ELSE
                    core_clk_xhdl0;
    
END trans;




LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.stratixiv_pcie_hip_components.all;

ENTITY stratixiv_pciehip_dprio_bit IS
   PORT (
      
      reset        : IN STD_LOGIC;		-- reset
      clk          : IN STD_LOGIC;		-- clock
      sig_in       : IN STD_LOGIC;		-- signal input
      ext_in       : IN STD_LOGIC;		-- external input port
      serial_mode  : IN STD_LOGIC;		-- serial shift mode enable  
      si           : IN STD_LOGIC;		-- scan input
      shift        : IN STD_LOGIC;		-- 1'b1=shift in data from si into scan flop
      -- 1'b0=load data from sig_in into scan flop
      mdio_dis     : IN STD_LOGIC;		-- 1'b1=choose ext_in to the sig_out mux
      -- 1'b0=choose so to the sign_out mux
      sig_out      : OUT STD_LOGIC;		-- signal output
      so           : OUT STD_LOGIC		-- scan output
   );
END stratixiv_pciehip_dprio_bit;

ARCHITECTURE trans OF stratixiv_pciehip_dprio_bit IS
   
   SIGNAL cram_int : STD_LOGIC;
   SIGNAL set_int  : STD_LOGIC;
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL so_xhdl0 : STD_LOGIC;
BEGIN
   -- Drive referenced outputs
   so <= so_xhdl0;
   
   -- select signal output
   sig_out <= (so_xhdl0 AND NOT(shift)) WHEN (serial_mode = '1') ELSE
              (cram_int);
   cram_int <= (ext_in) WHEN (mdio_dis = '1') ELSE
               (so_xhdl0);
   
   -- Set signal for the flop
   set_int <= '0' WHEN (shift = '1' OR reset = '1') ELSE
              ext_in;
   
   -- scan flop
   PROCESS (reset, set_int, clk)
VARIABLE  txt : LINE;
   BEGIN
      IF (reset = '1') THEN
         so_xhdl0 <= '0';
      ELSIF (set_int = '1') THEN
         so_xhdl0 <= '1';
      ELSIF (clk'EVENT AND clk = '1') THEN
         IF ((shift AND serial_mode) = '1') THEN
            so_xhdl0 <= si;
         ELSE
            
            so_xhdl0 <= sig_in;
         END IF;
      END IF;
   END PROCESS;
   
END trans;




LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.stratixiv_pcie_hip_components.all;

ENTITY stratixiv_pciehip_dprio_16bit IS
   PORT (
      
      reset        : IN STD_LOGIC;		-- reset
      mdio_wr      : IN STD_LOGIC;
      reg_addr     : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
      target_addr  : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
      clk          : IN STD_LOGIC;		-- clock
      sig_in       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);		-- signal input
      ext_in       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);		-- external port input
      serial_mode  : IN STD_LOGIC;		-- serial shift mode enable  
      si           : IN STD_LOGIC;		-- scan input
      shift        : IN STD_LOGIC;		-- 1'b1=shift in data from si into scan flop
      -- 1'b0=load data from sig_in into scan flop
      mdio_dis     : IN STD_LOGIC;		--
      -- 1'b1=output CRAM
      -- 1'b0=output MDIO control register
      sig_out      : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);		-- signal output
      so           : OUT STD_LOGIC		-- scan output
   );
END stratixiv_pciehip_dprio_16bit;

ARCHITECTURE trans OF stratixiv_pciehip_dprio_16bit IS
   COMPONENT stratixiv_pciehip_dprio_bit
      PORT (
         reset        : IN STD_LOGIC;
         clk          : IN STD_LOGIC;
         sig_in       : IN STD_LOGIC;
         ext_in       : IN STD_LOGIC;
         serial_mode  : IN STD_LOGIC;
         si           : IN STD_LOGIC;
         shift        : IN STD_LOGIC;
         mdio_dis     : IN STD_LOGIC;
         sig_out      : OUT STD_LOGIC;
         so           : OUT STD_LOGIC
      );
   END COMPONENT;
   
   
   SIGNAL signal_in_int : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL chain         : STD_LOGIC_VECTOR(14 DOWNTO 0);
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL sig_out_xhdl0 : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL so_xhdl1      : STD_LOGIC;
BEGIN
   -- Drive referenced outputs
   sig_out <= sig_out_xhdl0;
   so <= so_xhdl1;
   
   signal_in_int <= sig_in WHEN ((("000000000000000" & mdio_wr) AND int2bin((reg_addr = target_addr), 16)) /= "0000000000000000") ELSE
                    (so_xhdl1 & chain);
   
   
   
   ctrl_reg_bit_0 : stratixiv_pciehip_dprio_bit
      PORT MAP (
         reset        => reset,
         clk          => clk,
         sig_in       => signal_in_int(0),
         ext_in       => ext_in(0),
         serial_mode  => serial_mode,
         si           => si,
         shift        => shift,
         mdio_dis     => mdio_dis,
         sig_out      => sig_out_xhdl0(0),
         so           => chain(0)
      );
   
   
   
   ctrl_reg_bit_1 : stratixiv_pciehip_dprio_bit
      PORT MAP (
         reset        => reset,
         clk          => clk,
         sig_in       => signal_in_int(1),
         ext_in       => ext_in(1),
         serial_mode  => serial_mode,
         si           => chain(0),
         shift        => shift,
         mdio_dis     => mdio_dis,
         sig_out      => sig_out_xhdl0(1),
         so           => chain(1)
      );
   
   
   
   ctrl_reg_bit_2 : stratixiv_pciehip_dprio_bit
      PORT MAP (
         reset        => reset,
         clk          => clk,
         sig_in       => signal_in_int(2),
         ext_in       => ext_in(2),
         serial_mode  => serial_mode,
         si           => chain(1),
         shift        => shift,
         mdio_dis     => mdio_dis,
         sig_out      => sig_out_xhdl0(2),
         so           => chain(2)
      );
   
   
   
   ctrl_reg_bit_3 : stratixiv_pciehip_dprio_bit
      PORT MAP (
         reset        => reset,
         clk          => clk,
         sig_in       => signal_in_int(3),
         ext_in       => ext_in(3),
         serial_mode  => serial_mode,
         si           => chain(2),
         shift        => shift,
         mdio_dis     => mdio_dis,
         sig_out      => sig_out_xhdl0(3),
         so           => chain(3)
      );
   
   
   
   ctrl_reg_bit_4 : stratixiv_pciehip_dprio_bit
      PORT MAP (
         reset        => reset,
         clk          => clk,
         sig_in       => signal_in_int(4),
         ext_in       => ext_in(4),
         serial_mode  => serial_mode,
         si           => chain(3),
         shift        => shift,
         mdio_dis     => mdio_dis,
         sig_out      => sig_out_xhdl0(4),
         so           => chain(4)
      );
   
   
   
   ctrl_reg_bit_5 : stratixiv_pciehip_dprio_bit
      PORT MAP (
         reset        => reset,
         clk          => clk,
         sig_in       => signal_in_int(5),
         ext_in       => ext_in(5),
         serial_mode  => serial_mode,
         si           => chain(4),
         shift        => shift,
         mdio_dis     => mdio_dis,
         sig_out      => sig_out_xhdl0(5),
         so           => chain(5)
      );
   
   
   
   ctrl_reg_bit_6 : stratixiv_pciehip_dprio_bit
      PORT MAP (
         reset        => reset,
         clk          => clk,
         sig_in       => signal_in_int(6),
         ext_in       => ext_in(6),
         serial_mode  => serial_mode,
         si           => chain(5),
         shift        => shift,
         mdio_dis     => mdio_dis,
         sig_out      => sig_out_xhdl0(6),
         so           => chain(6)
      );
   
   
   
   ctrl_reg_bit_7 : stratixiv_pciehip_dprio_bit
      PORT MAP (
         reset        => reset,
         clk          => clk,
         sig_in       => signal_in_int(7),
         ext_in       => ext_in(7),
         serial_mode  => serial_mode,
         si           => chain(6),
         shift        => shift,
         mdio_dis     => mdio_dis,
         sig_out      => sig_out_xhdl0(7),
         so           => chain(7)
      );
   
   
   
   ctrl_reg_bit_8 : stratixiv_pciehip_dprio_bit
      PORT MAP (
         reset        => reset,
         clk          => clk,
         sig_in       => signal_in_int(8),
         ext_in       => ext_in(8),
         serial_mode  => serial_mode,
         si           => chain(7),
         shift        => shift,
         mdio_dis     => mdio_dis,
         sig_out      => sig_out_xhdl0(8),
         so           => chain(8)
      );
   
   
   
   ctrl_reg_bit_9 : stratixiv_pciehip_dprio_bit
      PORT MAP (
         reset        => reset,
         clk          => clk,
         sig_in       => signal_in_int(9),
         ext_in       => ext_in(9),
         serial_mode  => serial_mode,
         si           => chain(8),
         shift        => shift,
         mdio_dis     => mdio_dis,
         sig_out      => sig_out_xhdl0(9),
         so           => chain(9)
      );
   
   
   
   ctrl_reg_bit_10 : stratixiv_pciehip_dprio_bit
      PORT MAP (
         reset        => reset,
         clk          => clk,
         sig_in       => signal_in_int(10),
         ext_in       => ext_in(10),
         serial_mode  => serial_mode,
         si           => chain(9),
         shift        => shift,
         mdio_dis     => mdio_dis,
         sig_out      => sig_out_xhdl0(10),
         so           => chain(10)
      );
   
   
   
   ctrl_reg_bit_11 : stratixiv_pciehip_dprio_bit
      PORT MAP (
         reset        => reset,
         clk          => clk,
         sig_in       => signal_in_int(11),
         ext_in       => ext_in(11),
         serial_mode  => serial_mode,
         si           => chain(10),
         shift        => shift,
         mdio_dis     => mdio_dis,
         sig_out      => sig_out_xhdl0(11),
         so           => chain(11)
      );
   
   
   
   ctrl_reg_bit_12 : stratixiv_pciehip_dprio_bit
      PORT MAP (
         reset        => reset,
         clk          => clk,
         sig_in       => signal_in_int(12),
         ext_in       => ext_in(12),
         serial_mode  => serial_mode,
         si           => chain(11),
         shift        => shift,
         mdio_dis     => mdio_dis,
         sig_out      => sig_out_xhdl0(12),
         so           => chain(12)
      );
   
   
   
   ctrl_reg_bit_13 : stratixiv_pciehip_dprio_bit
      PORT MAP (
         reset        => reset,
         clk          => clk,
         sig_in       => signal_in_int(13),
         ext_in       => ext_in(13),
         serial_mode  => serial_mode,
         si           => chain(12),
         shift        => shift,
         mdio_dis     => mdio_dis,
         sig_out      => sig_out_xhdl0(13),
         so           => chain(13)
      );
   
   
   
   ctrl_reg_bit_14 : stratixiv_pciehip_dprio_bit
      PORT MAP (
         reset        => reset,
         clk          => clk,
         sig_in       => signal_in_int(14),
         ext_in       => ext_in(14),
         serial_mode  => serial_mode,
         si           => chain(13),
         shift        => shift,
         mdio_dis     => mdio_dis,
         sig_out      => sig_out_xhdl0(14),
         so           => chain(14)
      );
   
   
   
   ctrl_reg_bit_15 : stratixiv_pciehip_dprio_bit
      PORT MAP (
         reset        => reset,
         clk          => clk,
         sig_in       => signal_in_int(15),
         ext_in       => ext_in(15),
         serial_mode  => serial_mode,
         si           => chain(14),
         shift        => shift,
         mdio_dis     => mdio_dis,
         sig_out      => sig_out_xhdl0(15),
         so           => so_xhdl1
      );
   
END trans;


--IP Functional Simulation Model
--VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END


-- Copyright (C) 1991-2009 Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.

-- You may only use these simulation model output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event Altera disclaims all warranties of any kind).


--synopsys translate_off

 LIBRARY sgate;
 USE sgate.sgate_pack.all;

--synthesis_resources = lut 33 mux21 32 oper_add 1 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  stratixiv_pciehip_dprio_addr IS 
	 PORT 
	 ( 
		 incr_addr	:	IN  STD_LOGIC;
		 mdc	:	IN  STD_LOGIC;
		 mdio_in	:	IN  STD_LOGIC;
		 reg_addr	:	OUT  STD_LOGIC_VECTOR (15 DOWNTO 0);
		 reset	:	IN  STD_LOGIC;
		 shift_addr	:	IN  STD_LOGIC
	 ); 
 END stratixiv_pciehip_dprio_addr;

 ARCHITECTURE RTL OF stratixiv_pciehip_dprio_addr IS

	 ATTRIBUTE synthesis_clearbox : natural;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS 1;
	 SIGNAL	 nlO0i15	:	STD_LOGIC := '0';
	 SIGNAL	 nlO0i16	:	STD_LOGIC := '0';
	 SIGNAL	 nlO0l13	:	STD_LOGIC := '0';
	 SIGNAL	 nlO0l14	:	STD_LOGIC := '0';
	 SIGNAL	 nlO0O11	:	STD_LOGIC := '0';
	 SIGNAL	 nlO0O12	:	STD_LOGIC := '0';
	 SIGNAL  wire_nlO0O12_w_lg_w_lg_q45w46w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO0O12_w_lg_q45w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlOii10	:	STD_LOGIC := '0';
	 SIGNAL  wire_nlOii10_w_lg_w_lg_q37w38w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlOii10_w_lg_q37w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlOii9	:	STD_LOGIC := '0';
	 SIGNAL	 nlOil7	:	STD_LOGIC := '0';
	 SIGNAL	 nlOil8	:	STD_LOGIC := '0';
	 SIGNAL  wire_nlOil8_w_lg_w_lg_q33w34w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlOil8_w_lg_q33w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlOiO5	:	STD_LOGIC := '0';
	 SIGNAL	 nlOiO6	:	STD_LOGIC := '0';
	 SIGNAL  wire_nlOiO6_w_lg_w_lg_q30w31w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlOiO6_w_lg_q30w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlOli3	:	STD_LOGIC := '0';
	 SIGNAL	 nlOli4	:	STD_LOGIC := '0';
	 SIGNAL  wire_nlOli4_w_lg_w_lg_q25w26w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlOli4_w_lg_q25w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlOOi1	:	STD_LOGIC := '0';
	 SIGNAL	 nlOOi2	:	STD_LOGIC := '0';
	 SIGNAL	n0il	:	STD_LOGIC := '0';
	 SIGNAL	n0iO	:	STD_LOGIC := '0';
	 SIGNAL	n0li	:	STD_LOGIC := '0';
	 SIGNAL	n0ll	:	STD_LOGIC := '0';
	 SIGNAL	n0lO	:	STD_LOGIC := '0';
	 SIGNAL	n0Oi	:	STD_LOGIC := '0';
	 SIGNAL	n0Ol	:	STD_LOGIC := '0';
	 SIGNAL	n0OO	:	STD_LOGIC := '0';
	 SIGNAL	ni0i	:	STD_LOGIC := '0';
	 SIGNAL	ni0l	:	STD_LOGIC := '0';
	 SIGNAL	ni0O	:	STD_LOGIC := '0';
	 SIGNAL	ni1i	:	STD_LOGIC := '0';
	 SIGNAL	ni1l	:	STD_LOGIC := '0';
	 SIGNAL	ni1O	:	STD_LOGIC := '0';
	 SIGNAL	niii	:	STD_LOGIC := '0';
	 SIGNAL	niil	:	STD_LOGIC := '0';
	 SIGNAL	nili	:	STD_LOGIC := '0';
	 SIGNAL	wire_niiO_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_niiO_PRN	:	STD_LOGIC;
	 SIGNAL  wire_niiO_w_lg_w14w15w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w14w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_w_lg_w_lg_w_lg_w_lg_w_lg_w7w8w9w10w11w12w13w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_w_lg_w_lg_w_lg_w_lg_w7w8w9w10w11w12w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_w_lg_w_lg_w_lg_w7w8w9w10w11w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_w_lg_w_lg_w7w8w9w10w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_w_lg_w7w8w9w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_w7w8w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w7w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_w_lg_w_lg_w_lg_w_lg_w_lg_niil1w2w3w4w5w6w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_w_lg_w_lg_w_lg_w_lg_niil1w2w3w4w5w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_w_lg_w_lg_w_lg_niil1w2w3w4w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_w_lg_w_lg_niil1w2w3w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_w_lg_niil1w2w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_niil1w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni_a	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_ni_b	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_gnd	:	STD_LOGIC;
	 SIGNAL  wire_ni_o	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlOlO19w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_reset98w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  nlO1O :	STD_LOGIC;
	 SIGNAL  nlOll :	STD_LOGIC;
	 SIGNAL  nlOlO :	STD_LOGIC;
 BEGIN

	wire_gnd <= '0';
	wire_w_lg_nlOlO19w(0) <= NOT nlOlO;
	wire_w_lg_reset98w(0) <= NOT reset;
	nlO1O <= '1';
	nlOll <= (wire_w_lg_nlOlO19w(0) AND incr_addr);
	nlOlO <= (wire_niiO_w_lg_w14w15w(0) AND (nlOOi2 XOR nlOOi1));
	reg_addr <= ( niil & niii & ni0O & ni0l & ni0i & ni1O & ni1l & ni1i & n0OO & n0Ol & n0Oi & n0lO & n0ll & n0li & n0iO & n0il);
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlO0i15 <= nlO0i16;
		END IF;
		if (now = 0 ns) then
			nlO0i15 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlO0i16 <= nlO0i15;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlO0l13 <= nlO0l14;
		END IF;
		if (now = 0 ns) then
			nlO0l13 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlO0l14 <= nlO0l13;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlO0O11 <= nlO0O12;
		END IF;
		if (now = 0 ns) then
			nlO0O11 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlO0O12 <= nlO0O11;
		END IF;
	END PROCESS;
	wire_nlO0O12_w_lg_w_lg_q45w46w(0) <= wire_nlO0O12_w_lg_q45w(0) AND niil;
	wire_nlO0O12_w_lg_q45w(0) <= nlO0O12 XOR nlO0O11;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOii10 <= nlOii9;
		END IF;
	END PROCESS;
	wire_nlOii10_w_lg_w_lg_q37w38w(0) <= wire_nlOii10_w_lg_q37w(0) AND ni1l;
	wire_nlOii10_w_lg_q37w(0) <= nlOii10 XOR nlOii9;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOii9 <= nlOii10;
		END IF;
		if (now = 0 ns) then
			nlOii9 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOil7 <= nlOil8;
		END IF;
		if (now = 0 ns) then
			nlOil7 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOil8 <= nlOil7;
		END IF;
	END PROCESS;
	wire_nlOil8_w_lg_w_lg_q33w34w(0) <= wire_nlOil8_w_lg_q33w(0) AND n0OO;
	wire_nlOil8_w_lg_q33w(0) <= nlOil8 XOR nlOil7;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOiO5 <= nlOiO6;
		END IF;
		if (now = 0 ns) then
			nlOiO5 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOiO6 <= nlOiO5;
		END IF;
	END PROCESS;
	wire_nlOiO6_w_lg_w_lg_q30w31w(0) <= wire_nlOiO6_w_lg_q30w(0) AND n0Ol;
	wire_nlOiO6_w_lg_q30w(0) <= nlOiO6 XOR nlOiO5;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOli3 <= nlOli4;
		END IF;
		if (now = 0 ns) then
			nlOli3 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOli4 <= nlOli3;
		END IF;
	END PROCESS;
	wire_nlOli4_w_lg_w_lg_q25w26w(0) <= wire_nlOli4_w_lg_q25w(0) AND n0ll;
	wire_nlOli4_w_lg_q25w(0) <= nlOli4 XOR nlOli3;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOOi1 <= nlOOi2;
		END IF;
		if (now = 0 ns) then
			nlOOi1 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOOi2 <= nlOOi1;
		END IF;
	END PROCESS;
	PROCESS (mdc, wire_niiO_PRN, wire_niiO_CLRN)
	BEGIN
		IF (wire_niiO_PRN = '0') THEN
				n0il <= '1';
				n0iO <= '1';
				n0li <= '1';
				n0ll <= '1';
				n0lO <= '1';
				n0Oi <= '1';
				n0Ol <= '1';
				n0OO <= '1';
				ni0i <= '1';
				ni0l <= '1';
				ni0O <= '1';
				ni1i <= '1';
				ni1l <= '1';
				ni1O <= '1';
				niii <= '1';
				niil <= '1';
				nili <= '1';
		ELSIF (wire_niiO_CLRN = '0') THEN
				n0il <= '0';
				n0iO <= '0';
				n0li <= '0';
				n0ll <= '0';
				n0lO <= '0';
				n0Oi <= '0';
				n0Ol <= '0';
				n0OO <= '0';
				ni0i <= '0';
				ni0l <= '0';
				ni0O <= '0';
				ni1i <= '0';
				ni1l <= '0';
				ni1O <= '0';
				niii <= '0';
				niil <= '0';
				nili <= '0';
		ELSIF (mdc = '1' AND mdc'event) THEN
				n0il <= wire_nill_dataout;
				n0iO <= wire_nilO_dataout;
				n0li <= wire_niOi_dataout;
				n0ll <= wire_niOl_dataout;
				n0lO <= wire_niOO_dataout;
				n0Oi <= wire_nl1i_dataout;
				n0Ol <= wire_nl1l_dataout;
				n0OO <= wire_nl1O_dataout;
				ni0i <= wire_nlii_dataout;
				ni0l <= wire_nlil_dataout;
				ni0O <= wire_nliO_dataout;
				ni1i <= wire_nl0i_dataout;
				ni1l <= wire_nl0l_dataout;
				ni1O <= wire_nl0O_dataout;
				niii <= wire_nlli_dataout;
				niil <= wire_nlll_dataout;
				nili <= mdio_in;
		END IF;
	END PROCESS;
	wire_niiO_CLRN <= ((nlO0l14 XOR nlO0l13) AND wire_w_lg_reset98w(0));
	wire_niiO_PRN <= (nlO0i16 XOR nlO0i15);
	wire_niiO_w_lg_w14w15w(0) <= wire_niiO_w14w(0) AND n0il;
	wire_niiO_w14w(0) <= wire_niiO_w_lg_w_lg_w_lg_w_lg_w_lg_w_lg_w7w8w9w10w11w12w13w(0) AND n0iO;
	wire_niiO_w_lg_w_lg_w_lg_w_lg_w_lg_w_lg_w7w8w9w10w11w12w13w(0) <= wire_niiO_w_lg_w_lg_w_lg_w_lg_w_lg_w7w8w9w10w11w12w(0) AND n0li;
	wire_niiO_w_lg_w_lg_w_lg_w_lg_w_lg_w7w8w9w10w11w12w(0) <= wire_niiO_w_lg_w_lg_w_lg_w_lg_w7w8w9w10w11w(0) AND n0ll;
	wire_niiO_w_lg_w_lg_w_lg_w_lg_w7w8w9w10w11w(0) <= wire_niiO_w_lg_w_lg_w_lg_w7w8w9w10w(0) AND n0lO;
	wire_niiO_w_lg_w_lg_w_lg_w7w8w9w10w(0) <= wire_niiO_w_lg_w_lg_w7w8w9w(0) AND n0Oi;
	wire_niiO_w_lg_w_lg_w7w8w9w(0) <= wire_niiO_w_lg_w7w8w(0) AND n0Ol;
	wire_niiO_w_lg_w7w8w(0) <= wire_niiO_w7w(0) AND n0OO;
	wire_niiO_w7w(0) <= wire_niiO_w_lg_w_lg_w_lg_w_lg_w_lg_w_lg_niil1w2w3w4w5w6w(0) AND ni1i;
	wire_niiO_w_lg_w_lg_w_lg_w_lg_w_lg_w_lg_niil1w2w3w4w5w6w(0) <= wire_niiO_w_lg_w_lg_w_lg_w_lg_w_lg_niil1w2w3w4w5w(0) AND ni1l;
	wire_niiO_w_lg_w_lg_w_lg_w_lg_w_lg_niil1w2w3w4w5w(0) <= wire_niiO_w_lg_w_lg_w_lg_w_lg_niil1w2w3w4w(0) AND ni1O;
	wire_niiO_w_lg_w_lg_w_lg_w_lg_niil1w2w3w4w(0) <= wire_niiO_w_lg_w_lg_w_lg_niil1w2w3w(0) AND ni0i;
	wire_niiO_w_lg_w_lg_w_lg_niil1w2w3w(0) <= wire_niiO_w_lg_w_lg_niil1w2w(0) AND ni0l;
	wire_niiO_w_lg_w_lg_niil1w2w(0) <= wire_niiO_w_lg_niil1w(0) AND ni0O;
	wire_niiO_w_lg_niil1w(0) <= niil AND niii;
	wire_n0i_dataout <= wire_ni_o(7) WHEN nlOll = '1'  ELSE n0OO;
	wire_n0l_dataout <= wire_ni_o(8) WHEN nlOll = '1'  ELSE ni1i;
	wire_n0O_dataout <= wire_ni_o(9) WHEN nlOll = '1'  ELSE ni1l;
	wire_n1i_dataout <= wire_ni_o(4) WHEN nlOll = '1'  ELSE n0lO;
	wire_n1l_dataout <= wire_ni_o(5) WHEN nlOll = '1'  ELSE n0Oi;
	wire_n1O_dataout <= wire_ni_o(6) WHEN nlOll = '1'  ELSE n0Ol;
	wire_nii_dataout <= wire_ni_o(10) WHEN nlOll = '1'  ELSE ni1O;
	wire_nil_dataout <= wire_ni_o(11) WHEN nlOll = '1'  ELSE ni0i;
	wire_nill_dataout <= nili WHEN shift_addr = '1'  ELSE wire_nllO_dataout;
	wire_nilO_dataout <= n0il WHEN shift_addr = '1'  ELSE wire_nlOi_dataout;
	wire_niO_dataout <= wire_ni_o(12) WHEN nlOll = '1'  ELSE ni0l;
	wire_niOi_dataout <= n0iO WHEN shift_addr = '1'  ELSE wire_nlOl_dataout;
	wire_niOl_dataout <= n0li WHEN shift_addr = '1'  ELSE wire_nlOO_dataout;
	wire_niOO_dataout <= n0ll WHEN shift_addr = '1'  ELSE wire_n1i_dataout;
	wire_nl0i_dataout <= n0OO WHEN shift_addr = '1'  ELSE wire_n0l_dataout;
	wire_nl0l_dataout <= ni1i WHEN shift_addr = '1'  ELSE wire_n0O_dataout;
	wire_nl0O_dataout <= ni1l WHEN shift_addr = '1'  ELSE wire_nii_dataout;
	wire_nl1i_dataout <= n0lO WHEN shift_addr = '1'  ELSE wire_n1l_dataout;
	wire_nl1l_dataout <= n0Oi WHEN shift_addr = '1'  ELSE wire_n1O_dataout;
	wire_nl1O_dataout <= n0Ol WHEN shift_addr = '1'  ELSE wire_n0i_dataout;
	wire_nli_dataout <= wire_ni_o(13) WHEN nlOll = '1'  ELSE ni0O;
	wire_nlii_dataout <= ni1O WHEN shift_addr = '1'  ELSE wire_nil_dataout;
	wire_nlil_dataout <= ni0i WHEN shift_addr = '1'  ELSE wire_niO_dataout;
	wire_nliO_dataout <= ni0l WHEN shift_addr = '1'  ELSE wire_nli_dataout;
	wire_nll_dataout <= wire_ni_o(14) WHEN nlOll = '1'  ELSE niii;
	wire_nlli_dataout <= ni0O WHEN shift_addr = '1'  ELSE wire_nll_dataout;
	wire_nlll_dataout <= niii WHEN shift_addr = '1'  ELSE wire_nlO_dataout;
	wire_nllO_dataout <= wire_ni_o(0) WHEN nlOll = '1'  ELSE n0il;
	wire_nlO_dataout <= wire_ni_o(15) WHEN nlOll = '1'  ELSE niil;
	wire_nlOi_dataout <= wire_ni_o(1) WHEN nlOll = '1'  ELSE n0iO;
	wire_nlOl_dataout <= wire_ni_o(2) WHEN nlOll = '1'  ELSE n0li;
	wire_nlOO_dataout <= wire_ni_o(3) WHEN nlOll = '1'  ELSE n0ll;
	wire_ni_a <= ( wire_nlO0O12_w_lg_w_lg_q45w46w & niii & ni0O & ni0l & ni0i & ni1O & wire_nlOii10_w_lg_w_lg_q37w38w & ni1i & wire_nlOil8_w_lg_w_lg_q33w34w & wire_nlOiO6_w_lg_w_lg_q30w31w & n0Oi & n0lO & wire_nlOli4_w_lg_w_lg_q25w26w & n0li & n0iO & n0il);
	wire_ni_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "1");
	ni :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 16,
		width_b => 16,
		width_o => 16
	  )
	  PORT MAP ( 
		a => wire_ni_a,
		b => wire_ni_b,
		cin => wire_gnd,
		o => wire_ni_o
	  );

 END RTL; --stratixiv_pciehip_dprio_addr
--synopsys translate_on
--VALID FILE
--IP Functional Simulation Model
--VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END


-- Copyright (C) 1991-2009 Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.

-- You may only use these simulation model output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event Altera disclaims all warranties of any kind).


--synopsys translate_off

 LIBRARY sgate;
 USE sgate.sgate_pack.all;

--synthesis_resources = lut 17 mux21 10 oper_add 1 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  stratixiv_pciehip_dprio_cnt IS 
	 PORT 
	 ( 
		 cnt_eq_0	:	OUT  STD_LOGIC;
		 cnt_val	:	IN  STD_LOGIC_VECTOR (4 DOWNTO 0);
		 ld_cnt	:	IN  STD_LOGIC;
		 mdc	:	IN  STD_LOGIC;
		 reset	:	IN  STD_LOGIC
	 ); 
 END stratixiv_pciehip_dprio_cnt;

 ARCHITECTURE RTL OF stratixiv_pciehip_dprio_cnt IS

	 ATTRIBUTE synthesis_clearbox : natural;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS 1;
	 SIGNAL	 ni0O10	:	STD_LOGIC := '0';
	 SIGNAL	 ni0O9	:	STD_LOGIC := '0';
	 SIGNAL	 ni1O11	:	STD_LOGIC := '0';
	 SIGNAL	 ni1O12	:	STD_LOGIC := '0';
	 SIGNAL	 niiO7	:	STD_LOGIC := '0';
	 SIGNAL	 niiO8	:	STD_LOGIC := '0';
	 SIGNAL	 nili5	:	STD_LOGIC := '0';
	 SIGNAL	 nili6	:	STD_LOGIC := '0';
	 SIGNAL	 nill3	:	STD_LOGIC := '0';
	 SIGNAL	 nill4	:	STD_LOGIC := '0';
	 SIGNAL  wire_nill4_w_lg_w_lg_q16w17w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nill4_w_lg_q16w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niOi1	:	STD_LOGIC := '0';
	 SIGNAL	 niOi2	:	STD_LOGIC := '0';
	 SIGNAL	n1i	:	STD_LOGIC := '0';
	 SIGNAL	ni	:	STD_LOGIC := '0';
	 SIGNAL	nlOi	:	STD_LOGIC := '0';
	 SIGNAL	nlOl	:	STD_LOGIC := '0';
	 SIGNAL	nlOO	:	STD_LOGIC := '0';
	 SIGNAL	wire_nlO_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_nlO_PRN	:	STD_LOGIC;
	 SIGNAL  wire_nlO_w_lg_w_lg_w_lg_w_lg_ni1w2w3w4w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO_w_lg_w_lg_w_lg_ni1w2w3w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO_w_lg_w_lg_ni1w2w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO_w_lg_ni1w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl_a	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nl_b	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_gnd	:	STD_LOGIC;
	 SIGNAL  wire_nl_o	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_w_lg_ld_cnt51w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0l50w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_reset33w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  ni0l :	STD_LOGIC;
	 SIGNAL  niil :	STD_LOGIC;
	 SIGNAL  nilO :	STD_LOGIC;
 BEGIN

	wire_gnd <= '0';
	wire_w_lg_ld_cnt51w(0) <= NOT ld_cnt;
	wire_w_lg_ni0l50w(0) <= NOT ni0l;
	wire_w_lg_reset33w(0) <= NOT reset;
	cnt_eq_0 <= ((wire_w_lg_ni0l50w(0) AND wire_w_lg_ld_cnt51w(0)) AND (ni1O12 XOR ni1O11));
	ni0l <= (wire_nlO_w_lg_w_lg_w_lg_w_lg_ni1w2w3w4w(0) OR (NOT (ni0O10 XOR ni0O9)));
	niil <= '1';
	nilO <= (wire_nlO_w_lg_w_lg_w_lg_w_lg_ni1w2w3w4w(0) OR (NOT (niOi2 XOR niOi1)));
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN ni0O10 <= ni0O9;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN ni0O9 <= ni0O10;
		END IF;
		if (now = 0 ns) then
			ni0O9 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN ni1O11 <= ni1O12;
		END IF;
		if (now = 0 ns) then
			ni1O11 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN ni1O12 <= ni1O11;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niiO7 <= niiO8;
		END IF;
		if (now = 0 ns) then
			niiO7 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niiO8 <= niiO7;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nili5 <= nili6;
		END IF;
		if (now = 0 ns) then
			nili5 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nili6 <= nili5;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nill3 <= nill4;
		END IF;
		if (now = 0 ns) then
			nill3 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nill4 <= nill3;
		END IF;
	END PROCESS;
	wire_nill4_w_lg_w_lg_q16w17w(0) <= wire_nill4_w_lg_q16w(0) AND n1i;
	wire_nill4_w_lg_q16w(0) <= nill4 XOR nill3;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOi1 <= niOi2;
		END IF;
		if (now = 0 ns) then
			niOi1 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOi2 <= niOi1;
		END IF;
	END PROCESS;
	PROCESS (mdc, wire_nlO_PRN, wire_nlO_CLRN)
	BEGIN
		IF (wire_nlO_PRN = '0') THEN
				n1i <= '1';
				ni <= '1';
				nlOi <= '1';
				nlOl <= '1';
				nlOO <= '1';
		ELSIF (wire_nlO_CLRN = '0') THEN
				n1i <= '0';
				ni <= '0';
				nlOi <= '0';
				nlOl <= '0';
				nlOO <= '0';
		ELSIF (mdc = '1' AND mdc'event) THEN
				n1i <= wire_n0O_dataout;
				ni <= wire_n1l_dataout;
				nlOi <= wire_n1O_dataout;
				nlOl <= wire_n0i_dataout;
				nlOO <= wire_n0l_dataout;
		END IF;
	END PROCESS;
	wire_nlO_CLRN <= ((nili6 XOR nili5) AND wire_w_lg_reset33w(0));
	wire_nlO_PRN <= (niiO8 XOR niiO7);
	wire_nlO_w_lg_w_lg_w_lg_w_lg_ni1w2w3w4w(0) <= wire_nlO_w_lg_w_lg_w_lg_ni1w2w3w(0) OR nlOi;
	wire_nlO_w_lg_w_lg_w_lg_ni1w2w3w(0) <= wire_nlO_w_lg_w_lg_ni1w2w(0) OR nlOl;
	wire_nlO_w_lg_w_lg_ni1w2w(0) <= wire_nlO_w_lg_ni1w(0) OR nlOO;
	wire_nlO_w_lg_ni1w(0) <= ni OR n1i;
	wire_n0i_dataout <= cnt_val(2) WHEN ld_cnt = '1'  ELSE wire_niO_dataout;
	wire_n0l_dataout <= cnt_val(3) WHEN ld_cnt = '1'  ELSE wire_nli_dataout;
	wire_n0O_dataout <= cnt_val(4) WHEN ld_cnt = '1'  ELSE wire_nll_dataout;
	wire_n1l_dataout <= cnt_val(0) WHEN ld_cnt = '1'  ELSE wire_nii_dataout;
	wire_n1O_dataout <= cnt_val(1) WHEN ld_cnt = '1'  ELSE wire_nil_dataout;
	wire_nii_dataout <= wire_nl_o(1) WHEN nilO = '1'  ELSE ni;
	wire_nil_dataout <= wire_nl_o(2) WHEN nilO = '1'  ELSE nlOi;
	wire_niO_dataout <= wire_nl_o(3) WHEN nilO = '1'  ELSE nlOl;
	wire_nli_dataout <= wire_nl_o(4) WHEN nilO = '1'  ELSE nlOO;
	wire_nll_dataout <= wire_nl_o(5) WHEN nilO = '1'  ELSE n1i;
	wire_nl_a <= ( wire_nill4_w_lg_w_lg_q16w17w & nlOO & nlOl & nlOi & ni & "1");
	wire_nl_b <= ( "1" & "1" & "1" & "1" & "0" & "1");
	nl :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 6,
		width_b => 6,
		width_o => 6
	  )
	  PORT MAP ( 
		a => wire_nl_a,
		b => wire_nl_b,
		cin => wire_gnd,
		o => wire_nl_o
	  );

 END RTL; --stratixiv_pciehip_dprio_cnt
--synopsys translate_on
--VALID FILE
--IP Functional Simulation Model
--VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END


-- Copyright (C) 1991-2009 Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.

-- You may only use these simulation model output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event Altera disclaims all warranties of any kind).


--synopsys translate_off

--synthesis_resources = lut 47 mux21 36 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  stratixiv_pciehip_dprio_ctl_data IS 
	 PORT 
	 ( 
		 data_enable_n	:	OUT  STD_LOGIC;
		 dev_addr	:	IN  STD_LOGIC_VECTOR (4 DOWNTO 0);
		 latch_ctl	:	IN  STD_LOGIC;
		 ld_data	:	IN  STD_LOGIC;
		 mbus_in	:	OUT  STD_LOGIC_VECTOR (15 DOWNTO 0);
		 mbus_out	:	IN  STD_LOGIC_VECTOR (15 DOWNTO 0);
		 mdc	:	IN  STD_LOGIC;
		 mdio_in	:	IN  STD_LOGIC;
		 mdio_out	:	OUT  STD_LOGIC;
		 opcode	:	OUT  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 port_addr	:	IN  STD_LOGIC_VECTOR (4 DOWNTO 0);
		 reset	:	IN  STD_LOGIC;
		 shift_in	:	IN  STD_LOGIC;
		 shift_out	:	IN  STD_LOGIC;
		 valid_addr	:	OUT  STD_LOGIC;
		 valid_addr_lt	:	IN  STD_LOGIC
	 ); 
 END stratixiv_pciehip_dprio_ctl_data;

 ARCHITECTURE RTL OF stratixiv_pciehip_dprio_ctl_data IS

	 ATTRIBUTE synthesis_clearbox : natural;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS 1;
	 SIGNAL	 nilll25	:	STD_LOGIC := '0';
	 SIGNAL	 nilll26	:	STD_LOGIC := '0';
	 SIGNAL	 nilOi23	:	STD_LOGIC := '0';
	 SIGNAL	 nilOi24	:	STD_LOGIC := '0';
	 SIGNAL	 nilOO21	:	STD_LOGIC := '0';
	 SIGNAL	 nilOO22	:	STD_LOGIC := '0';
	 SIGNAL	 niO0i17	:	STD_LOGIC := '0';
	 SIGNAL	 niO0i18	:	STD_LOGIC := '0';
	 SIGNAL	 niO0O15	:	STD_LOGIC := '0';
	 SIGNAL	 niO0O16	:	STD_LOGIC := '0';
	 SIGNAL	 niO1l19	:	STD_LOGIC := '0';
	 SIGNAL	 niO1l20	:	STD_LOGIC := '0';
	 SIGNAL	 niOil13	:	STD_LOGIC := '0';
	 SIGNAL	 niOil14	:	STD_LOGIC := '0';
	 SIGNAL	 niOiO11	:	STD_LOGIC := '0';
	 SIGNAL	 niOiO12	:	STD_LOGIC := '0';
	 SIGNAL	 niOlO10	:	STD_LOGIC := '0';
	 SIGNAL	 niOlO9	:	STD_LOGIC := '0';
	 SIGNAL	 niOOl7	:	STD_LOGIC := '0';
	 SIGNAL	 niOOl8	:	STD_LOGIC := '0';
	 SIGNAL	 nl10l3	:	STD_LOGIC := '0';
	 SIGNAL	 nl10l4	:	STD_LOGIC := '0';
	 SIGNAL	 nl11l5	:	STD_LOGIC := '0';
	 SIGNAL	 nl11l6	:	STD_LOGIC := '0';
	 SIGNAL	 nl1iO1	:	STD_LOGIC := '0';
	 SIGNAL	 nl1iO2	:	STD_LOGIC := '0';
	 SIGNAL  wire_nl1iO2_w_lg_q6w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n1li	:	STD_LOGIC := '0';
	 SIGNAL	n1lO	:	STD_LOGIC := '0';
	 SIGNAL	wire_n1ll_PRN	:	STD_LOGIC;
	 SIGNAL	n00i	:	STD_LOGIC := '0';
	 SIGNAL	n00l	:	STD_LOGIC := '0';
	 SIGNAL	n00O	:	STD_LOGIC := '0';
	 SIGNAL	n01l	:	STD_LOGIC := '0';
	 SIGNAL	n01O	:	STD_LOGIC := '0';
	 SIGNAL	n0ii	:	STD_LOGIC := '0';
	 SIGNAL	n0il	:	STD_LOGIC := '0';
	 SIGNAL	n0iO	:	STD_LOGIC := '0';
	 SIGNAL	n0li	:	STD_LOGIC := '0';
	 SIGNAL	n0ll	:	STD_LOGIC := '0';
	 SIGNAL	n0lO	:	STD_LOGIC := '0';
	 SIGNAL	n0Oi	:	STD_LOGIC := '0';
	 SIGNAL	n0Ol	:	STD_LOGIC := '0';
	 SIGNAL	n0OO	:	STD_LOGIC := '0';
	 SIGNAL	n1iO	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi	:	STD_LOGIC := '0';
	 SIGNAL	ni0i	:	STD_LOGIC := '0';
	 SIGNAL	ni1i	:	STD_LOGIC := '0';
	 SIGNAL	ni1l	:	STD_LOGIC := '0';
	 SIGNAL	wire_ni1O_CLRN	:	STD_LOGIC;
	 SIGNAL  wire_ni1O_w_lg_w_lg_w_lg_w_lg_w_lg_ni1i2w4w7w8w9w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_w_lg_w_lg_w_lg_ni1i2w4w7w8w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_w_lg_w_lg_ni1i2w4w7w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_w_lg_ni1i2w4w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_n0Oi34w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_n0lO33w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_n0OO3w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_ni1i2w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_n00i107w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_n00l115w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_n0li84w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_n0ll92w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_reset30w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_shift_out48w49w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_shift_out48w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  niOll :	STD_LOGIC;
	 SIGNAL  nl10i :	STD_LOGIC;
	 SIGNAL  nl11i :	STD_LOGIC;
	 SIGNAL  nl11O :	STD_LOGIC;
	 SIGNAL  nl1ii :	STD_LOGIC;
	 SIGNAL  nl1il :	STD_LOGIC;
	 SIGNAL  wire_w_dev_addr_range106w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_dev_addr_range114w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_port_addr_range83w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_port_addr_range91w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
 BEGIN

	wire_w_lg_reset30w(0) <= NOT reset;
	wire_w_lg_w_lg_shift_out48w49w(0) <= wire_w_lg_shift_out48w(0) OR n01l;
	wire_w_lg_shift_out48w(0) <= shift_out OR ld_data;
	data_enable_n <= (NOT ((wire_w_lg_w_lg_shift_out48w49w(0) AND (nl10i OR valid_addr_lt)) AND (niO0O16 XOR niO0O15)));
	mbus_in <= ( ni0i & ni1l & ni1i & n0OO & n0Ol & n0Oi & n0lO & n0ll & n0li & n0iO & n0il & n0ii & n00O & n00l & n00i & n01O);
	mdio_out <= wire_nl_dataout;
	niOll <= (((n0Oi AND n0lO) OR (wire_ni1O_w_lg_n0Oi34w(0) AND (niOOl8 XOR niOOl7))) OR (NOT (niOlO10 XOR niOlO9)));
	nl10i <= (wire_ni1O_w_lg_w_lg_w_lg_w_lg_w_lg_ni1i2w4w7w8w9w(0) AND (nl10l4 XOR nl10l3));
	nl11i <= '1';
	nl11O <= (shift_in OR shift_out);
	nl1ii <= ((((((NOT (n01O XOR dev_addr(0))) AND (NOT (wire_ni1O_w_lg_n00i107w(0) XOR (NOT (nilOO22 XOR nilOO21))))) AND (NOT (wire_ni1O_w_lg_n00l115w(0) XOR (NOT (nilOi24 XOR nilOi23))))) AND (NOT (n00O XOR dev_addr(3)))) AND (NOT (n0ii XOR dev_addr(4)))) AND (nilll26 XOR nilll25));
	nl1il <= (((((NOT (n0il XOR port_addr(0))) AND (NOT (n0iO XOR port_addr(1)))) AND (NOT (wire_ni1O_w_lg_n0li84w(0) XOR (NOT (niO0i18 XOR niO0i17))))) AND (NOT (wire_ni1O_w_lg_n0ll92w(0) XOR (NOT (niO1l20 XOR niO1l19))))) AND (NOT (n0lO XOR port_addr(4))));
	opcode <= ( n1lO & n1li);
	valid_addr <= nl10i;
	wire_w_dev_addr_range106w(0) <= dev_addr(1);
	wire_w_dev_addr_range114w(0) <= dev_addr(2);
	wire_w_port_addr_range83w(0) <= port_addr(2);
	wire_w_port_addr_range91w(0) <= port_addr(3);
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nilll25 <= nilll26;
		END IF;
		if (now = 0 ns) then
			nilll25 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nilll26 <= nilll25;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nilOi23 <= nilOi24;
		END IF;
		if (now = 0 ns) then
			nilOi23 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nilOi24 <= nilOi23;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nilOO21 <= nilOO22;
		END IF;
		if (now = 0 ns) then
			nilOO21 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nilOO22 <= nilOO21;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niO0i17 <= niO0i18;
		END IF;
		if (now = 0 ns) then
			niO0i17 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niO0i18 <= niO0i17;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niO0O15 <= niO0O16;
		END IF;
		if (now = 0 ns) then
			niO0O15 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niO0O16 <= niO0O15;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niO1l19 <= niO1l20;
		END IF;
		if (now = 0 ns) then
			niO1l19 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niO1l20 <= niO1l19;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOil13 <= niOil14;
		END IF;
		if (now = 0 ns) then
			niOil13 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOil14 <= niOil13;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOiO11 <= niOiO12;
		END IF;
		if (now = 0 ns) then
			niOiO11 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOiO12 <= niOiO11;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOlO10 <= niOlO9;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOlO9 <= niOlO10;
		END IF;
		if (now = 0 ns) then
			niOlO9 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOOl7 <= niOOl8;
		END IF;
		if (now = 0 ns) then
			niOOl7 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOOl8 <= niOOl7;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nl10l3 <= nl10l4;
		END IF;
		if (now = 0 ns) then
			nl10l3 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nl10l4 <= nl10l3;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nl11l5 <= nl11l6;
		END IF;
		if (now = 0 ns) then
			nl11l5 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nl11l6 <= nl11l5;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nl1iO1 <= nl1iO2;
		END IF;
		if (now = 0 ns) then
			nl1iO1 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nl1iO2 <= nl1iO1;
		END IF;
	END PROCESS;
	wire_nl1iO2_w_lg_q6w(0) <= nl1iO2 XOR nl1iO1;
	PROCESS (mdc, wire_n1ll_PRN, reset)
	BEGIN
		IF (wire_n1ll_PRN = '0') THEN
				n1li <= '1';
				n1lO <= '1';
		ELSIF (reset = '1') THEN
				n1li <= '0';
				n1lO <= '0';
		ELSIF (mdc = '1' AND mdc'event) THEN
			IF (latch_ctl = '1') THEN
				n1li <= n0lO;
				n1lO <= n0Oi;
			END IF;
		END IF;
	END PROCESS;
	wire_n1ll_PRN <= (niOil14 XOR niOil13);
	PROCESS (mdc, wire_ni1O_CLRN)
	BEGIN
		IF (wire_ni1O_CLRN = '0') THEN
				n00i <= '0';
				n00l <= '0';
				n00O <= '0';
				n01l <= '0';
				n01O <= '0';
				n0ii <= '0';
				n0il <= '0';
				n0iO <= '0';
				n0li <= '0';
				n0ll <= '0';
				n0lO <= '0';
				n0Oi <= '0';
				n0Ol <= '0';
				n0OO <= '0';
				n1iO <= '0';
				n1Oi <= '0';
				ni0i <= '0';
				ni1i <= '0';
				ni1l <= '0';
		ELSIF (mdc = '1' AND mdc'event) THEN
				n00i <= wire_ni0O_dataout;
				n00l <= wire_niii_dataout;
				n00O <= wire_niil_dataout;
				n01l <= wire_n1Ol_dataout;
				n01O <= wire_ni0l_dataout;
				n0ii <= wire_niiO_dataout;
				n0il <= wire_nili_dataout;
				n0iO <= wire_nill_dataout;
				n0li <= wire_nilO_dataout;
				n0ll <= wire_niOi_dataout;
				n0lO <= wire_niOl_dataout;
				n0Oi <= wire_niOO_dataout;
				n0Ol <= wire_nl1i_dataout;
				n0OO <= wire_nl1l_dataout;
				n1iO <= wire_n1OO_dataout;
				n1Oi <= mdio_in;
				ni0i <= wire_nl0l_dataout;
				ni1i <= wire_nl1O_dataout;
				ni1l <= wire_nl0i_dataout;
		END IF;
	END PROCESS;
	wire_ni1O_CLRN <= ((nl11l6 XOR nl11l5) AND wire_w_lg_reset30w(0));
	wire_ni1O_w_lg_w_lg_w_lg_w_lg_w_lg_ni1i2w4w7w8w9w(0) <= wire_ni1O_w_lg_w_lg_w_lg_w_lg_ni1i2w4w7w8w(0) AND nl1ii;
	wire_ni1O_w_lg_w_lg_w_lg_w_lg_ni1i2w4w7w8w(0) <= wire_ni1O_w_lg_w_lg_w_lg_ni1i2w4w7w(0) AND nl1il;
	wire_ni1O_w_lg_w_lg_w_lg_ni1i2w4w7w(0) <= wire_ni1O_w_lg_w_lg_ni1i2w4w(0) AND wire_nl1iO2_w_lg_q6w(0);
	wire_ni1O_w_lg_w_lg_ni1i2w4w(0) <= wire_ni1O_w_lg_ni1i2w(0) AND wire_ni1O_w_lg_n0OO3w(0);
	wire_ni1O_w_lg_n0Oi34w(0) <= n0Oi AND wire_ni1O_w_lg_n0lO33w(0);
	wire_ni1O_w_lg_n0lO33w(0) <= NOT n0lO;
	wire_ni1O_w_lg_n0OO3w(0) <= NOT n0OO;
	wire_ni1O_w_lg_ni1i2w(0) <= NOT ni1i;
	wire_ni1O_w_lg_n00i107w(0) <= n00i XOR wire_w_dev_addr_range106w(0);
	wire_ni1O_w_lg_n00l115w(0) <= n00l XOR wire_w_dev_addr_range114w(0);
	wire_ni1O_w_lg_n0li84w(0) <= n0li XOR wire_w_port_addr_range83w(0);
	wire_ni1O_w_lg_n0ll92w(0) <= n0ll XOR wire_w_port_addr_range91w(0);
	wire_n0i_dataout <= n0OO WHEN nl11O = '1'  ELSE ni1i;
	wire_n0l_dataout <= ni1i WHEN nl11O = '1'  ELSE ni1l;
	wire_n0O_dataout <= ni1l WHEN nl11O = '1'  ELSE ni0i;
	wire_n1i_dataout <= n0lO WHEN nl11O = '1'  ELSE n0Oi;
	wire_n1l_dataout <= n0Oi WHEN nl11O = '1'  ELSE n0Ol;
	wire_n1O_dataout <= n0Ol WHEN nl11O = '1'  ELSE n0OO;
	wire_n1Ol_dataout <= niOll WHEN latch_ctl = '1'  ELSE ((n01l AND n1iO) AND (niOiO12 XOR niOiO11));
	wire_n1OO_dataout <= niOll AND latch_ctl;
	wire_ni0l_dataout <= mbus_out(15) WHEN ld_data = '1'  ELSE wire_nl0O_dataout;
	wire_ni0O_dataout <= mbus_out(0) WHEN ld_data = '1'  ELSE wire_nlii_dataout;
	wire_niii_dataout <= mbus_out(1) WHEN ld_data = '1'  ELSE wire_nlil_dataout;
	wire_niil_dataout <= mbus_out(2) WHEN ld_data = '1'  ELSE wire_nliO_dataout;
	wire_niiO_dataout <= mbus_out(3) WHEN ld_data = '1'  ELSE wire_nlli_dataout;
	wire_nili_dataout <= mbus_out(4) WHEN ld_data = '1'  ELSE wire_nlll_dataout;
	wire_nill_dataout <= mbus_out(5) WHEN ld_data = '1'  ELSE wire_nllO_dataout;
	wire_nilO_dataout <= mbus_out(6) WHEN ld_data = '1'  ELSE wire_nlOi_dataout;
	wire_niOi_dataout <= mbus_out(7) WHEN ld_data = '1'  ELSE wire_nlOl_dataout;
	wire_niOl_dataout <= mbus_out(8) WHEN ld_data = '1'  ELSE wire_nlOO_dataout;
	wire_niOO_dataout <= mbus_out(9) WHEN ld_data = '1'  ELSE wire_n1i_dataout;
	wire_nl_dataout <= mbus_out(15) WHEN ld_data = '1'  ELSE wire_nO_dataout;
	wire_nl0i_dataout <= mbus_out(13) WHEN ld_data = '1'  ELSE wire_n0l_dataout;
	wire_nl0l_dataout <= mbus_out(14) WHEN ld_data = '1'  ELSE wire_n0O_dataout;
	wire_nl0O_dataout <= n1Oi WHEN nl11O = '1'  ELSE n01O;
	wire_nl1i_dataout <= mbus_out(10) WHEN ld_data = '1'  ELSE wire_n1l_dataout;
	wire_nl1l_dataout <= mbus_out(11) WHEN ld_data = '1'  ELSE wire_n1O_dataout;
	wire_nl1O_dataout <= mbus_out(12) WHEN ld_data = '1'  ELSE wire_n0i_dataout;
	wire_nlii_dataout <= n01O WHEN nl11O = '1'  ELSE n00i;
	wire_nlil_dataout <= n00i WHEN nl11O = '1'  ELSE n00l;
	wire_nliO_dataout <= n00l WHEN nl11O = '1'  ELSE n00O;
	wire_nlli_dataout <= n00O WHEN nl11O = '1'  ELSE n0ii;
	wire_nlll_dataout <= n0ii WHEN nl11O = '1'  ELSE n0il;
	wire_nllO_dataout <= n0il WHEN nl11O = '1'  ELSE n0iO;
	wire_nlOi_dataout <= n0iO WHEN nl11O = '1'  ELSE n0li;
	wire_nlOl_dataout <= n0li WHEN nl11O = '1'  ELSE n0ll;
	wire_nlOO_dataout <= n0ll WHEN nl11O = '1'  ELSE n0lO;
	wire_nO_dataout <= ni0i AND shift_out;

 END RTL; --stratixiv_pciehip_dprio_ctl_data
--synopsys translate_on
--VALID FILE


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.stratixiv_pcie_hip_components.all;

ENTITY stratixiv_pciehip_dprio_sm IS
   GENERIC (
      
      IDLE           : INTEGER := 0;
      PREAMBLE       : INTEGER := 1;
      CONTROL        : INTEGER := 2;
      TURN_ARND_0    : INTEGER := 3;
      TURN_ARND_1    : INTEGER := 4;
      ADDR_DATA      : INTEGER := 5;
      ADDR_OP        : INTEGER := 0;
      WR_OP          : INTEGER := 1;
      RD_INC_OP      : INTEGER := 2;
      RD_OP          : INTEGER := 3
   );
   PORT (
      mdc            : IN STD_LOGIC;		-- Clock for MDIO interface
      mdio_in        : IN STD_LOGIC;		-- Signal bit data
      reset          : IN STD_LOGIC;		-- Active high Hard Reset
      opcode         : IN STD_LOGIC_VECTOR(1 DOWNTO 0);		-- 2 bit opcode from mdio_ctl_data module
      -- 00 - Address
      -- 01 - Write
      -- 10 - Read with no post Increment
      -- 11 - Read with post increment
      valid_addr     : IN STD_LOGIC;		-- When set the Port and Dev Address
      -- corresponds to this module
      cnt_eq_0       : IN STD_LOGIC;		-- From mdio_cnt module, down counter is 0
      shift_in       : OUT STD_LOGIC;		-- Shift in enable for either data or control
      shift_out      : OUT STD_LOGIC;		-- Shift out enable for mdio_ctl_data
      latch_ctl      : OUT STD_LOGIC;		-- Latch the Opcode, to mdio_ctl_data
      incr_addr      : OUT STD_LOGIC;		-- Increment signal for mdio_addr
      mdio_wr        : OUT STD_LOGIC;		-- This is used for writing the mdio registers
      mdio_rd        : OUT STD_LOGIC;		-- This is used for clearing the mdio status registers
      shift_addr     : OUT STD_LOGIC;		-- Shift in Enable for mdio_addr
      ld_data        : OUT STD_LOGIC;		-- When set, the shift register is mdio_ctl_data is parallely
      -- loaded with the data from mdio_reg module
      --output       ld_data_d;
      ld_cnt         : OUT STD_LOGIC;		-- Load Down counter
      cnt_val        : OUT STD_LOGIC_VECTOR(4 DOWNTO 0);		-- Value to load the down counter
      valid_addr_lt  : OUT STD_LOGIC;
      curr_state     : OUT STD_LOGIC_VECTOR(2 DOWNTO 0)
   );
END stratixiv_pciehip_dprio_sm;

ARCHITECTURE trans OF stratixiv_pciehip_dprio_sm IS
   
   --wire      ld_data_d;
   
   -- Allowed states for curr_state and next_state
   
   -- Decode for opcode
   
   SIGNAL next_state       : STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL cnt_val_xhdl0    : STD_LOGIC_VECTOR(4 DOWNTO 0);
   SIGNAL curr_state_xhdl1 : STD_LOGIC_VECTOR(2 DOWNTO 0);
BEGIN
   -- Drive referenced outputs
   cnt_val <= cnt_val_xhdl0;
   curr_state <= curr_state_xhdl1;
   
   -- Latch Curr State
   
   PROCESS (reset, mdc)
VARIABLE  txt : LINE;
   BEGIN
      IF (reset = '1') THEN
         curr_state_xhdl1 <= int2bin(IDLE, 3);
      ELSIF (mdc'EVENT AND mdc = '1') THEN
         curr_state_xhdl1 <= next_state;
      END IF;
   END PROCESS;
   
   -- Next State loic for mdio_sm
   
   PROCESS (curr_state_xhdl1, mdio_in, cnt_eq_0, valid_addr, opcode)
VARIABLE  txt : LINE;
   BEGIN
-- shawn manual fix      IF (curr_state_xhdl1'EVENT) THEN
         
         CASE curr_state_xhdl1 IS
            
            WHEN "000" =>
               IF (mdio_in = '1') THEN
                  next_state <= int2bin(PREAMBLE, 3);
               ELSE
                  next_state <= int2bin(IDLE, 3);
               END IF;
            WHEN "001" =>
               IF ((NOT(mdio_in) AND NOT(cnt_eq_0)) = '1') THEN
                  next_state <= int2bin(IDLE, 3);
               ELSIF ((NOT(mdio_in) AND cnt_eq_0) = '1') THEN
                  next_state <= int2bin(CONTROL, 3);
               ELSE
                  next_state <= int2bin(PREAMBLE, 3);
               END IF;
            
            WHEN "010" =>
               IF (cnt_eq_0 = '1') THEN
                  IF ((NOT(mdio_in)) = '1') THEN
                     next_state <= int2bin(IDLE, 3);
                  ELSE
                     next_state <= int2bin(TURN_ARND_0, 3);
                  END IF;
               ELSE
                  next_state <= int2bin(CONTROL, 3);
               END IF;
            
            WHEN "011" =>
               IF ((mdio_in OR NOT(valid_addr)) = '1') THEN
                  next_state <= int2bin(IDLE, 3);
               ELSIF (opcode = int2bin(WR_OP, 2) OR opcode = int2bin(ADDR_OP, 2)) THEN
                  next_state <= int2bin(TURN_ARND_1, 3);
               ELSE
                  next_state <= int2bin(ADDR_DATA, 3);
               END IF;
            --                     if (mdio_in)
            --                         next_state <= IDLE;
            --                     else
            
            WHEN "100" =>
               next_state <= int2bin(ADDR_DATA, 3);
            
            WHEN "101" =>
               IF ((cnt_eq_0 AND mdio_in) = '1' AND (opcode = int2bin(WR_OP, 2) OR opcode = int2bin(ADDR_OP, 2))) THEN
                  next_state <= int2bin(PREAMBLE, 3);
               ELSIF (cnt_eq_0 = '1') THEN
                  next_state <= int2bin(IDLE, 3);
               ELSE
                  next_state <= int2bin(ADDR_DATA, 3);
               END IF;
            
            WHEN OTHERS =>
               next_state <= int2bin(IDLE, 3);
         END CASE;
-- shawn manual fix      END IF;
   END PROCESS;
   
   -- Valid_addr_lt is used to enable mdio_out
   
   PROCESS (reset, mdc)
VARIABLE  txt : LINE;
   BEGIN
      IF (reset = '1') THEN
         valid_addr_lt <= '0';
      ELSIF (mdc'EVENT AND mdc = '1') THEN
         IF (valid_addr = '1' AND curr_state_xhdl1 = int2bin(TURN_ARND_0, 3)) THEN
            valid_addr_lt <= '1';
         ELSIF (curr_state_xhdl1 = int2bin(ADDR_DATA, 3) AND cnt_eq_0 = '1') THEN
            valid_addr_lt <= '0';
         END IF;
      END IF;
   END PROCESS;
   
   -- Logic for shift_in, This signal is used for shifting in
   -- control logic, during all commands, and data during
   -- Write command
   
   PROCESS (reset, mdc)
VARIABLE  txt : LINE;
   BEGIN
      IF (reset = '1') THEN
         shift_in <= '0';
      ELSIF (mdc'EVENT AND mdc = '1') THEN
         IF ((curr_state_xhdl1 = int2bin(PREAMBLE, 3) AND next_state = int2bin(CONTROL, 3)) OR (next_state = int2bin(CONTROL, 3)) OR (next_state = int2bin(ADDR_DATA, 3) AND opcode = int2bin(WR_OP, 2))) THEN
            shift_in <= '1';
         ELSE
            shift_in <= '0';
         END IF;
      END IF;
   END PROCESS;
   
   -- Shift_out logic, shift_out is set when data is shifted out on
   -- a RD_OP or RD_INC_OP command
   
   PROCESS (reset, mdc)
VARIABLE  txt : LINE;
   BEGIN
      IF (reset = '1') THEN
         shift_out <= '0';
      ELSIF (mdc'EVENT AND mdc = '1') THEN
         IF ((curr_state_xhdl1 = int2bin(TURN_ARND_0, 3) AND next_state = int2bin(ADDR_DATA, 3)) OR (curr_state_xhdl1 = int2bin(ADDR_DATA, 3) AND (opcode = int2bin(RD_OP, 2) OR opcode = int2bin(RD_INC_OP, 2)) AND ((NOT(cnt_eq_0))) = '1')) THEN
            shift_out <= '1';
         ELSE
            shift_out <= '0';
         END IF;
      END IF;
   END PROCESS;
   
   -- Logic for latch_ctl, this signal is used for latching the opcode
   -- This signal is set when in Control state and moving to TURN_ARND_0
   -- state
   
   PROCESS (cnt_eq_0, curr_state_xhdl1)
VARIABLE  txt : LINE;
   BEGIN
      IF (curr_state_xhdl1'EVENT) THEN
         
         -- Logic for incr_addr, incr_addr is set for opcode RD_INC_OP and
         -- after completely shifting out the read data for the current command
         
         latch_ctl <= cnt_eq_0 AND int2bin((curr_state_xhdl1 = int2bin(CONTROL, 3)), 3)(0);
      END IF;
   END PROCESS;
   PROCESS (reset, mdc)
VARIABLE  txt : LINE;
   BEGIN
      IF (reset = '1') THEN
         incr_addr <= '0';
      ELSIF (mdc'EVENT AND mdc = '1') THEN
         IF (curr_state_xhdl1 = int2bin(ADDR_DATA, 3) AND cnt_eq_0 = '1' AND opcode = int2bin(RD_INC_OP, 2)) THEN
            incr_addr <= '1';
         ELSE
            incr_addr <= '0';
         END IF;
      END IF;
   END PROCESS;
   
   -- Logic for shift addr, this bit is set when moving to ADDR_DATA 
   -- state and when in ADDR_DATA state for ADDR_OP command
   
   PROCESS (reset, mdc)
VARIABLE  txt : LINE;
   BEGIN
      IF (reset = '1') THEN
         shift_addr <= '0';
      ELSIF (mdc'EVENT AND mdc = '1') THEN
         IF (next_state = int2bin(ADDR_DATA, 3) AND opcode = int2bin(ADDR_OP, 2)) THEN
            shift_addr <= '1';
         ELSE
            shift_addr <= '0';
         END IF;
      END IF;
   END PROCESS;
   
   -- Logic for mdio_wr, this bit is set when moving from ADDR_DATA to the
   -- IDLE for a WR_OP command
   -- Logic for mdio_rd, this bit is set when moving from ADDR_DATA to the
   -- IDLE for a RD_OP/RD_INC_OP command
   
   PROCESS (reset, mdc)
VARIABLE  txt : LINE;
   BEGIN
      IF (reset = '1') THEN
         mdio_wr <= '0';
         mdio_rd <= '0';
      ELSIF (mdc'EVENT AND mdc = '1') THEN
         IF (curr_state_xhdl1 = int2bin(ADDR_DATA, 3) AND cnt_eq_0 = '1') THEN
            IF (opcode = int2bin(WR_OP, 2)) THEN
               mdio_wr <= '1';
            ELSE
               mdio_wr <= '0';
            END IF;
            IF (opcode = int2bin(RD_OP, 2) OR opcode = int2bin(RD_INC_OP, 2)) THEN
               mdio_rd <= '1';
            ELSE
               mdio_rd <= '0';
            END IF;
         ELSE
            mdio_wr <= '0';
            mdio_rd <= '0';
         END IF;
      END IF;
   END PROCESS;
   
   -- Logic for ld_data, this signal is used for parallely loading the
   -- shift register in mdio_ctl_data module with the data from mdio_reg
   -- module. This set is set for RD_OP and RD_INC_OP commands when the
   -- SM transitions from TURN_ARND_0 to ADDR_DATA state
   -- assign ld_data_d = (curr_state == TURN_ARND_0 && (opcode == RD_OP | opcode == RD_INC_OP));
   
   PROCESS (reset, mdc)
VARIABLE  txt : LINE;
   BEGIN
      IF (reset = '1') THEN
         ld_data <= '0';
      ELSIF (mdc'EVENT AND mdc = '1') THEN
         ld_data <= int2bit((curr_state_xhdl1 = int2bin(TURN_ARND_0, 3) AND next_state = int2bin(ADDR_DATA, 3)));
      END IF;
   END PROCESS;
   
   -- Logic for ld_cnt, this signal is used for loading the down counter
   -- with cnt_val signal. This signal is set when going to
   -- CONTROL state or ADDR_DATA state or PREAMBLE states
   
   PROCESS (reset, mdc)
VARIABLE  txt : LINE;
   BEGIN
      IF (reset = '1') THEN
         ld_cnt <= '0';
      ELSIF (mdc'EVENT AND mdc = '1') THEN
         IF ((curr_state_xhdl1 = int2bin(IDLE, 3) AND next_state = int2bin(PREAMBLE, 3)) OR (curr_state_xhdl1 = int2bin(ADDR_DATA, 3) AND next_state = int2bin(PREAMBLE, 3)) OR (curr_state_xhdl1 = int2bin(PREAMBLE, 3) AND next_state = int2bin(CONTROL, 3)) OR (curr_state_xhdl1 = int2bin(TURN_ARND_0, 3) AND next_state = int2bin(ADDR_DATA, 3)) OR (curr_state_xhdl1 = int2bin(TURN_ARND_1, 3) AND next_state = int2bin(ADDR_DATA, 3))) THEN
            ld_cnt <= '1';
         ELSE
            ld_cnt <= '0';
         END IF;
      END IF;
   END PROCESS;
   
   -- Logic for cnt_val, this counter value is used for sown counting
   -- the mdio_cnt, when the counter reaches zero, the cnt_eq_0 is
   -- set. The counter is loading with 31 for PREAMBLE, 13 for 
   -- CONTROL, and 15 for ADDR_DATA
   
   PROCESS (reset, mdc)
VARIABLE  txt : LINE;
   BEGIN
      IF (reset = '1') THEN
         cnt_val_xhdl0 <= "00000";
      ELSIF (mdc'EVENT AND mdc = '1') THEN
         IF ((curr_state_xhdl1 = int2bin(IDLE, 3) OR curr_state_xhdl1 = int2bin(ADDR_DATA, 3)) AND next_state = int2bin(PREAMBLE, 3)) THEN
            cnt_val_xhdl0 <= "11110";
         ELSIF (curr_state_xhdl1 = int2bin(PREAMBLE, 3) AND next_state = int2bin(CONTROL, 3)) THEN
            cnt_val_xhdl0 <= "01100";
         ELSIF (curr_state_xhdl1 = int2bin(TURN_ARND_0, 3) AND next_state = int2bin(ADDR_DATA, 3)) THEN
            cnt_val_xhdl0 <= "01110";
         ELSIF (curr_state_xhdl1 = int2bin(TURN_ARND_1, 3) AND next_state = int2bin(ADDR_DATA, 3)) THEN
            cnt_val_xhdl0 <= "01110";
         ELSE
            cnt_val_xhdl0 <= cnt_val_xhdl0;
         END IF;
      END IF;
   END PROCESS;
   
END trans;



LIBRARY ieee;
    USE ieee.std_logic_1164.all;

ENTITY stratixiv_pciehip_dprio_bus_out_mux IS
    PORT (
        
        hip_ctrl_in1           : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in2           : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in3           : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in4           : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in5           : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in6           : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in7           : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in8           : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in9           : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in10          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in11          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in12          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in13          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in14          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in15          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in16          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in17          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in18          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in19          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in20          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in21          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in22          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in23          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in24          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in25          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in26          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in27          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in28          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in29          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in30          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in31          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in32          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in33          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in34          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in35          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in36          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in37          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in38          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in39          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in40          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in41          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in42          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in43          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in44          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in45          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in46          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in47          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in48          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in49          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in50          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in51          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in52          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in53          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in54          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in55          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in56          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in57          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in58          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in59          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in60          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in61          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in62          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in63          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in64          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in65          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in66          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in67          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in68          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in69          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in70          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in71          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in72          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in73          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in74          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in75          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in76          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in77          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in78          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in79          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in80          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in81          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in82          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in83          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in84          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in85          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in86          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in87          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in88          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in89          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in90          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in91          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in92          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in93          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in94          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in95          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in96          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in97          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in98          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in99          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in100         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in101         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in102         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in103         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in104         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in105         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in106         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in107         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in108         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in109         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hip_ctrl_in110         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in1    : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in2    : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in3    : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in4    : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in5    : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in6    : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in7    : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in8    : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in9    : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in10   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in11   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in12   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in13   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in14   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in15   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in16   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in17   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in18   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in19   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in20   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in21   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in22   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in23   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in24   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in25   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in26   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in27   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in28   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in29   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in30   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in31   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in32   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in33   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in34   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in35   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in36   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in37   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in38   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in39   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in40   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in41   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in42   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in43   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in44   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in45   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in46   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in47   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in48   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in49   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in50   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in51   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in52   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in53   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in54   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in55   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in56   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in57   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in58   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in59   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in60   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in61   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in62   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in63   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in64   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in65   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in66   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in67   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in68   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in69   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in70   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in71   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in72   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in73   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in74   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in75   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in76   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in77   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in78   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in79   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in80   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in81   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in82   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in83   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in84   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in85   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in86   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in87   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in88   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in89   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in90   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in91   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in92   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in93   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in94   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in95   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in96   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in97   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in98   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in99   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in100  : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in101  : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in102  : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in103  : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in104  : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in105  : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in106  : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in107  : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in108  : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in109  : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        hw_address_ctrl_in110  : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        reg_addr               : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        
        hip_ctrl_out           : OUT STD_LOGIC_VECTOR(15 DOWNTO 0)
    );
END ENTITY stratixiv_pciehip_dprio_bus_out_mux;

ARCHITECTURE trans OF stratixiv_pciehip_dprio_bus_out_mux IS
BEGIN
    
    hip_ctrl_out <= hip_ctrl_in1 WHEN (reg_addr = hw_address_ctrl_in1) ELSE
                    hip_ctrl_in2 WHEN (reg_addr = hw_address_ctrl_in2) ELSE
                    hip_ctrl_in3 WHEN (reg_addr = hw_address_ctrl_in3) ELSE
                    hip_ctrl_in4 WHEN (reg_addr = hw_address_ctrl_in4) ELSE
                    hip_ctrl_in5 WHEN (reg_addr = hw_address_ctrl_in5) ELSE
                    hip_ctrl_in6 WHEN (reg_addr = hw_address_ctrl_in6) ELSE
                    hip_ctrl_in7 WHEN (reg_addr = hw_address_ctrl_in7) ELSE
                    hip_ctrl_in8 WHEN (reg_addr = hw_address_ctrl_in8) ELSE
                    hip_ctrl_in9 WHEN (reg_addr = hw_address_ctrl_in9) ELSE
                    hip_ctrl_in10 WHEN (reg_addr = hw_address_ctrl_in10) ELSE
                    hip_ctrl_in11 WHEN (reg_addr = hw_address_ctrl_in11) ELSE
                    hip_ctrl_in12 WHEN (reg_addr = hw_address_ctrl_in12) ELSE
                    hip_ctrl_in13 WHEN (reg_addr = hw_address_ctrl_in13) ELSE
                    hip_ctrl_in14 WHEN (reg_addr = hw_address_ctrl_in14) ELSE
                    hip_ctrl_in15 WHEN (reg_addr = hw_address_ctrl_in15) ELSE
                    hip_ctrl_in16 WHEN (reg_addr = hw_address_ctrl_in16) ELSE
                    hip_ctrl_in17 WHEN (reg_addr = hw_address_ctrl_in17) ELSE
                    hip_ctrl_in18 WHEN (reg_addr = hw_address_ctrl_in18) ELSE
                    hip_ctrl_in19 WHEN (reg_addr = hw_address_ctrl_in19) ELSE
                    hip_ctrl_in20 WHEN (reg_addr = hw_address_ctrl_in20) ELSE
                    hip_ctrl_in21 WHEN (reg_addr = hw_address_ctrl_in21) ELSE
                    hip_ctrl_in22 WHEN (reg_addr = hw_address_ctrl_in22) ELSE
                    hip_ctrl_in23 WHEN (reg_addr = hw_address_ctrl_in23) ELSE
                    hip_ctrl_in24 WHEN (reg_addr = hw_address_ctrl_in24) ELSE
                    hip_ctrl_in25 WHEN (reg_addr = hw_address_ctrl_in25) ELSE
                    hip_ctrl_in26 WHEN (reg_addr = hw_address_ctrl_in26) ELSE
                    hip_ctrl_in27 WHEN (reg_addr = hw_address_ctrl_in27) ELSE
                    hip_ctrl_in28 WHEN (reg_addr = hw_address_ctrl_in28) ELSE
                    hip_ctrl_in29 WHEN (reg_addr = hw_address_ctrl_in29) ELSE
                    hip_ctrl_in30 WHEN (reg_addr = hw_address_ctrl_in30) ELSE
                    hip_ctrl_in31 WHEN (reg_addr = hw_address_ctrl_in31) ELSE
                    hip_ctrl_in32 WHEN (reg_addr = hw_address_ctrl_in32) ELSE
                    hip_ctrl_in33 WHEN (reg_addr = hw_address_ctrl_in33) ELSE
                    hip_ctrl_in34 WHEN (reg_addr = hw_address_ctrl_in34) ELSE
                    hip_ctrl_in35 WHEN (reg_addr = hw_address_ctrl_in35) ELSE
                    hip_ctrl_in36 WHEN (reg_addr = hw_address_ctrl_in36) ELSE
                    hip_ctrl_in37 WHEN (reg_addr = hw_address_ctrl_in37) ELSE
                    hip_ctrl_in38 WHEN (reg_addr = hw_address_ctrl_in38) ELSE
                    hip_ctrl_in39 WHEN (reg_addr = hw_address_ctrl_in39) ELSE
                    hip_ctrl_in40 WHEN (reg_addr = hw_address_ctrl_in40) ELSE
                    hip_ctrl_in41 WHEN (reg_addr = hw_address_ctrl_in41) ELSE
                    hip_ctrl_in42 WHEN (reg_addr = hw_address_ctrl_in42) ELSE
                    hip_ctrl_in43 WHEN (reg_addr = hw_address_ctrl_in43) ELSE
                    hip_ctrl_in44 WHEN (reg_addr = hw_address_ctrl_in44) ELSE
                    hip_ctrl_in45 WHEN (reg_addr = hw_address_ctrl_in45) ELSE
                    hip_ctrl_in46 WHEN (reg_addr = hw_address_ctrl_in46) ELSE
                    hip_ctrl_in47 WHEN (reg_addr = hw_address_ctrl_in47) ELSE
                    hip_ctrl_in48 WHEN (reg_addr = hw_address_ctrl_in48) ELSE
                    hip_ctrl_in49 WHEN (reg_addr = hw_address_ctrl_in49) ELSE
                    hip_ctrl_in50 WHEN (reg_addr = hw_address_ctrl_in50) ELSE
                    hip_ctrl_in51 WHEN (reg_addr = hw_address_ctrl_in51) ELSE
                    hip_ctrl_in52 WHEN (reg_addr = hw_address_ctrl_in52) ELSE
                    hip_ctrl_in53 WHEN (reg_addr = hw_address_ctrl_in53) ELSE
                    hip_ctrl_in54 WHEN (reg_addr = hw_address_ctrl_in54) ELSE
                    hip_ctrl_in55 WHEN (reg_addr = hw_address_ctrl_in55) ELSE
                    hip_ctrl_in56 WHEN (reg_addr = hw_address_ctrl_in56) ELSE
                    hip_ctrl_in57 WHEN (reg_addr = hw_address_ctrl_in57) ELSE
                    hip_ctrl_in58 WHEN (reg_addr = hw_address_ctrl_in58) ELSE
                    hip_ctrl_in59 WHEN (reg_addr = hw_address_ctrl_in59) ELSE
                    hip_ctrl_in60 WHEN (reg_addr = hw_address_ctrl_in60) ELSE
                    hip_ctrl_in61 WHEN (reg_addr = hw_address_ctrl_in61) ELSE
                    hip_ctrl_in62 WHEN (reg_addr = hw_address_ctrl_in62) ELSE
                    hip_ctrl_in63 WHEN (reg_addr = hw_address_ctrl_in63) ELSE
                    hip_ctrl_in64 WHEN (reg_addr = hw_address_ctrl_in64) ELSE
                    hip_ctrl_in65 WHEN (reg_addr = hw_address_ctrl_in65) ELSE
                    hip_ctrl_in66 WHEN (reg_addr = hw_address_ctrl_in66) ELSE
                    hip_ctrl_in67 WHEN (reg_addr = hw_address_ctrl_in67) ELSE
                    hip_ctrl_in68 WHEN (reg_addr = hw_address_ctrl_in68) ELSE
                    hip_ctrl_in69 WHEN (reg_addr = hw_address_ctrl_in69) ELSE
                    hip_ctrl_in70 WHEN (reg_addr = hw_address_ctrl_in70) ELSE
                    hip_ctrl_in71 WHEN (reg_addr = hw_address_ctrl_in71) ELSE
                    hip_ctrl_in72 WHEN (reg_addr = hw_address_ctrl_in72) ELSE
                    hip_ctrl_in73 WHEN (reg_addr = hw_address_ctrl_in73) ELSE
                    hip_ctrl_in74 WHEN (reg_addr = hw_address_ctrl_in74) ELSE
                    hip_ctrl_in75 WHEN (reg_addr = hw_address_ctrl_in75) ELSE
                    hip_ctrl_in76 WHEN (reg_addr = hw_address_ctrl_in76) ELSE
                    hip_ctrl_in77 WHEN (reg_addr = hw_address_ctrl_in77) ELSE
                    hip_ctrl_in78 WHEN (reg_addr = hw_address_ctrl_in78) ELSE
                    hip_ctrl_in79 WHEN (reg_addr = hw_address_ctrl_in79) ELSE
                    hip_ctrl_in80 WHEN (reg_addr = hw_address_ctrl_in80) ELSE
                    hip_ctrl_in81 WHEN (reg_addr = hw_address_ctrl_in81) ELSE
                    hip_ctrl_in82 WHEN (reg_addr = hw_address_ctrl_in82) ELSE
                    hip_ctrl_in83 WHEN (reg_addr = hw_address_ctrl_in83) ELSE
                    hip_ctrl_in84 WHEN (reg_addr = hw_address_ctrl_in84) ELSE
                    hip_ctrl_in85 WHEN (reg_addr = hw_address_ctrl_in85) ELSE
                    hip_ctrl_in86 WHEN (reg_addr = hw_address_ctrl_in86) ELSE
                    hip_ctrl_in87 WHEN (reg_addr = hw_address_ctrl_in87) ELSE
                    hip_ctrl_in88 WHEN (reg_addr = hw_address_ctrl_in88) ELSE
                    hip_ctrl_in89 WHEN (reg_addr = hw_address_ctrl_in89) ELSE
                    hip_ctrl_in90 WHEN (reg_addr = hw_address_ctrl_in90) ELSE
                    hip_ctrl_in91 WHEN (reg_addr = hw_address_ctrl_in91) ELSE
                    hip_ctrl_in92 WHEN (reg_addr = hw_address_ctrl_in92) ELSE
                    hip_ctrl_in93 WHEN (reg_addr = hw_address_ctrl_in93) ELSE
                    hip_ctrl_in94 WHEN (reg_addr = hw_address_ctrl_in94) ELSE
                    hip_ctrl_in95 WHEN (reg_addr = hw_address_ctrl_in95) ELSE
                    hip_ctrl_in96 WHEN (reg_addr = hw_address_ctrl_in96) ELSE
                    hip_ctrl_in97 WHEN (reg_addr = hw_address_ctrl_in97) ELSE
                    hip_ctrl_in98 WHEN (reg_addr = hw_address_ctrl_in98) ELSE
                    hip_ctrl_in99 WHEN (reg_addr = hw_address_ctrl_in99) ELSE
                    hip_ctrl_in100 WHEN (reg_addr = hw_address_ctrl_in100) ELSE
                    hip_ctrl_in101 WHEN (reg_addr = hw_address_ctrl_in101) ELSE
                    hip_ctrl_in102 WHEN (reg_addr = hw_address_ctrl_in102) ELSE
                    hip_ctrl_in103 WHEN (reg_addr = hw_address_ctrl_in103) ELSE
                    hip_ctrl_in104 WHEN (reg_addr = hw_address_ctrl_in104) ELSE
                    hip_ctrl_in105 WHEN (reg_addr = hw_address_ctrl_in105) ELSE
                    hip_ctrl_in106 WHEN (reg_addr = hw_address_ctrl_in106) ELSE
                    hip_ctrl_in107 WHEN (reg_addr = hw_address_ctrl_in107) ELSE
                    hip_ctrl_in108 WHEN (reg_addr = hw_address_ctrl_in108) ELSE
                    hip_ctrl_in109 WHEN (reg_addr = hw_address_ctrl_in109) ELSE
                    hip_ctrl_in110 WHEN (reg_addr = hw_address_ctrl_in110) ELSE
                    "0000000000000000";
    
END ARCHITECTURE trans;


LIBRARY ieee;
    USE ieee.std_logic_1164.all;


ENTITY stratixiv_pciehip_dprio_reg IS
    PORT (
        -- CSR input
        
        -- DPRIO register output
        
        mdio_rst               : IN STD_LOGIC;
        mdio_wr                : IN STD_LOGIC;
        reg_addr               : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        mdc                    : IN STD_LOGIC;
        mbus_in                : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        serial_mode            : IN STD_LOGIC;
        mdio_dis               : IN STD_LOGIC;
        ser_shift_load         : IN STD_LOGIC;
        si                     : IN STD_LOGIC;
        ext_hip_ctrl_1         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_2         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_3         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_4         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_5         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_6         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_7         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_8         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_9         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_10        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_11        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_12        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_13        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_14        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_15        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_16        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_17        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_18        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_19        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_20        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_21        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_22        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_23        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_24        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_25        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_26        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_27        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_28        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_29        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_30        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_31        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_32        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_33        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_34        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_35        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_36        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_37        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_38        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_39        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_40        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_41        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_42        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_43        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_44        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_45        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_46        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_47        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_48        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_49        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_50        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_51        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_52        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_53        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_54        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_55        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_56        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_57        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_58        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_59        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_60        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_61        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_62        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_63        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_64        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_65        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_66        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_67        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_68        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_69        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_70        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_71        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_72        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_73        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_74        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_75        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_76        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_77        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_78        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_79        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_80        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_81        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_82        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_83        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_84        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_85        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_86        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_87        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_88        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_89        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_90        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_91        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_92        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_93        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_94        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_95        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_96        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_97        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_98        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_99        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_100       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_101       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_102       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_103       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_104       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_105       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_106       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_107       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_108       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_109       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        ext_hip_ctrl_110       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        
        targ_addr_ctrl_1       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_2       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_3       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_4       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_5       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_6       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_7       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_8       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_9       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_10      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_11      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_12      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_13      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_14      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_15      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_16      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_17      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_18      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_19      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_20      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_21      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_22      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_23      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_24      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_25      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_26      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_27      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_28      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_29      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_30      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_31      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_32      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_33      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_34      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_35      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_36      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_37      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_38      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_39      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_40      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_41      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_42      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_43      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_44      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_45      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_46      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_47      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_48      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_49      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_50      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_51      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_52      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_53      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_54      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_55      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_56      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_57      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_58      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_59      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_60      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_61      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_62      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_63      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_64      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_65      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_66      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_67      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_68      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_69      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_70      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_71      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_72      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_73      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_74      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_75      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_76      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_77      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_78      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_79      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_80      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_81      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_82      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_83      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_84      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_85      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_86      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_87      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_88      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_89      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_90      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_91      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_92      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_93      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_94      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_95      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_96      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_97      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_98      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_99      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_100     : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_101     : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_102     : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_103     : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_104     : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_105     : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_106     : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_107     : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_108     : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_109     : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        targ_addr_ctrl_110     : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
        
        out_hip_ctrl_1         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_2         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_3         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_4         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_5         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_6         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_7         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_8         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_9         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_10        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_11        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_12        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_13        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_14        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_15        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_16        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_17        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_18        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_19        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_20        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_21        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_22        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_23        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_24        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_25        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_26        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_27        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_28        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_29        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_30        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_31        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_32        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_33        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_34        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_35        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_36        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_37        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_38        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_39        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_40        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_41        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_42        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_43        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_44        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_45        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_46        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_47        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_48        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_49        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_50        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_51        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_52        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_53        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_54        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_55        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_56        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_57        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_58        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_59        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_60        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_61        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_62        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_63        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_64        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_65        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_66        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_67        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_68        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_69        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_70        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_71        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_72        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_73        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_74        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_75        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_76        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_77        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_78        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_79        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_80        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_81        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_82        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_83        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_84        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_85        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_86        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_87        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_88        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_89        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_90        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_91        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_92        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_93        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_94        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_95        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_96        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_97        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_98        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_99        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_100       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_101       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_102       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_103       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_104       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_105       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_106       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_107       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_108       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_109       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_110       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        so                     : OUT STD_LOGIC
    );
END ENTITY stratixiv_pciehip_dprio_reg;

ARCHITECTURE trans OF stratixiv_pciehip_dprio_reg IS
    COMPONENT stratixiv_pciehip_dprio_16bit IS
        PORT (
            reset                  : IN STD_LOGIC;
            mdio_wr                : IN STD_LOGIC;
            reg_addr               : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            target_addr            : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            clk                    : IN STD_LOGIC;
            sig_in                 : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_in                 : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            serial_mode            : IN STD_LOGIC;
            si                     : IN STD_LOGIC;
            shift                  : IN STD_LOGIC;
            mdio_dis               : IN STD_LOGIC;
            sig_out                : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            so                     : OUT STD_LOGIC
        );
    END COMPONENT;
    
    
    SIGNAL chain                   : STD_LOGIC_VECTOR(108 DOWNTO 0);
    
    -- Declare intermediate signals for referenced outputs
    SIGNAL out_hip_ctrl_1_xhdl0    : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_2_xhdl22   : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_3_xhdl33   : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_4_xhdl44   : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_5_xhdl55   : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_6_xhdl66   : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_7_xhdl77   : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_8_xhdl88   : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_9_xhdl99   : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_10_xhdl1   : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_11_xhdl12  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_12_xhdl14  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_13_xhdl15  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_14_xhdl16  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_15_xhdl17  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_16_xhdl18  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_17_xhdl19  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_18_xhdl20  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_19_xhdl21  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_20_xhdl23  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_21_xhdl24  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_22_xhdl25  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_23_xhdl26  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_24_xhdl27  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_25_xhdl28  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_26_xhdl29  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_27_xhdl30  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_28_xhdl31  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_29_xhdl32  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_30_xhdl34  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_31_xhdl35  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_32_xhdl36  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_33_xhdl37  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_34_xhdl38  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_35_xhdl39  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_36_xhdl40  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_37_xhdl41  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_38_xhdl42  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_39_xhdl43  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_40_xhdl45  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_41_xhdl46  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_42_xhdl47  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_43_xhdl48  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_44_xhdl49  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_45_xhdl50  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_46_xhdl51  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_47_xhdl52  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_48_xhdl53  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_49_xhdl54  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_50_xhdl56  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_51_xhdl57  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_52_xhdl58  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_53_xhdl59  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_54_xhdl60  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_55_xhdl61  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_56_xhdl62  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_57_xhdl63  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_58_xhdl64  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_59_xhdl65  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_60_xhdl67  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_61_xhdl68  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_62_xhdl69  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_63_xhdl70  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_64_xhdl71  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_65_xhdl72  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_66_xhdl73  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_67_xhdl74  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_68_xhdl75  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_69_xhdl76  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_70_xhdl78  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_71_xhdl79  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_72_xhdl80  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_73_xhdl81  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_74_xhdl82  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_75_xhdl83  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_76_xhdl84  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_77_xhdl85  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_78_xhdl86  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_79_xhdl87  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_80_xhdl89  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_81_xhdl90  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_82_xhdl91  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_83_xhdl92  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_84_xhdl93  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_85_xhdl94  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_86_xhdl95  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_87_xhdl96  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_88_xhdl97  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_89_xhdl98  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_90_xhdl100 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_91_xhdl101 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_92_xhdl102 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_93_xhdl103 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_94_xhdl104 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_95_xhdl105 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_96_xhdl106 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_97_xhdl107 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_98_xhdl108 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_99_xhdl109 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_100_xhdl2  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_101_xhdl3  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_102_xhdl4  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_103_xhdl5  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_104_xhdl6  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_105_xhdl7  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_106_xhdl8  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_107_xhdl9  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_108_xhdl10 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_109_xhdl11 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_110_xhdl13 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL so_xhdl110              : STD_LOGIC;
BEGIN
    -- Drive referenced outputs
    out_hip_ctrl_1 <= out_hip_ctrl_1_xhdl0;
    out_hip_ctrl_2 <= out_hip_ctrl_2_xhdl22;
    out_hip_ctrl_3 <= out_hip_ctrl_3_xhdl33;
    out_hip_ctrl_4 <= out_hip_ctrl_4_xhdl44;
    out_hip_ctrl_5 <= out_hip_ctrl_5_xhdl55;
    out_hip_ctrl_6 <= out_hip_ctrl_6_xhdl66;
    out_hip_ctrl_7 <= out_hip_ctrl_7_xhdl77;
    out_hip_ctrl_8 <= out_hip_ctrl_8_xhdl88;
    out_hip_ctrl_9 <= out_hip_ctrl_9_xhdl99;
    out_hip_ctrl_10 <= out_hip_ctrl_10_xhdl1;
    out_hip_ctrl_11 <= out_hip_ctrl_11_xhdl12;
    out_hip_ctrl_12 <= out_hip_ctrl_12_xhdl14;
    out_hip_ctrl_13 <= out_hip_ctrl_13_xhdl15;
    out_hip_ctrl_14 <= out_hip_ctrl_14_xhdl16;
    out_hip_ctrl_15 <= out_hip_ctrl_15_xhdl17;
    out_hip_ctrl_16 <= out_hip_ctrl_16_xhdl18;
    out_hip_ctrl_17 <= out_hip_ctrl_17_xhdl19;
    out_hip_ctrl_18 <= out_hip_ctrl_18_xhdl20;
    out_hip_ctrl_19 <= out_hip_ctrl_19_xhdl21;
    out_hip_ctrl_20 <= out_hip_ctrl_20_xhdl23;
    out_hip_ctrl_21 <= out_hip_ctrl_21_xhdl24;
    out_hip_ctrl_22 <= out_hip_ctrl_22_xhdl25;
    out_hip_ctrl_23 <= out_hip_ctrl_23_xhdl26;
    out_hip_ctrl_24 <= out_hip_ctrl_24_xhdl27;
    out_hip_ctrl_25 <= out_hip_ctrl_25_xhdl28;
    out_hip_ctrl_26 <= out_hip_ctrl_26_xhdl29;
    out_hip_ctrl_27 <= out_hip_ctrl_27_xhdl30;
    out_hip_ctrl_28 <= out_hip_ctrl_28_xhdl31;
    out_hip_ctrl_29 <= out_hip_ctrl_29_xhdl32;
    out_hip_ctrl_30 <= out_hip_ctrl_30_xhdl34;
    out_hip_ctrl_31 <= out_hip_ctrl_31_xhdl35;
    out_hip_ctrl_32 <= out_hip_ctrl_32_xhdl36;
    out_hip_ctrl_33 <= out_hip_ctrl_33_xhdl37;
    out_hip_ctrl_34 <= out_hip_ctrl_34_xhdl38;
    out_hip_ctrl_35 <= out_hip_ctrl_35_xhdl39;
    out_hip_ctrl_36 <= out_hip_ctrl_36_xhdl40;
    out_hip_ctrl_37 <= out_hip_ctrl_37_xhdl41;
    out_hip_ctrl_38 <= out_hip_ctrl_38_xhdl42;
    out_hip_ctrl_39 <= out_hip_ctrl_39_xhdl43;
    out_hip_ctrl_40 <= out_hip_ctrl_40_xhdl45;
    out_hip_ctrl_41 <= out_hip_ctrl_41_xhdl46;
    out_hip_ctrl_42 <= out_hip_ctrl_42_xhdl47;
    out_hip_ctrl_43 <= out_hip_ctrl_43_xhdl48;
    out_hip_ctrl_44 <= out_hip_ctrl_44_xhdl49;
    out_hip_ctrl_45 <= out_hip_ctrl_45_xhdl50;
    out_hip_ctrl_46 <= out_hip_ctrl_46_xhdl51;
    out_hip_ctrl_47 <= out_hip_ctrl_47_xhdl52;
    out_hip_ctrl_48 <= out_hip_ctrl_48_xhdl53;
    out_hip_ctrl_49 <= out_hip_ctrl_49_xhdl54;
    out_hip_ctrl_50 <= out_hip_ctrl_50_xhdl56;
    out_hip_ctrl_51 <= out_hip_ctrl_51_xhdl57;
    out_hip_ctrl_52 <= out_hip_ctrl_52_xhdl58;
    out_hip_ctrl_53 <= out_hip_ctrl_53_xhdl59;
    out_hip_ctrl_54 <= out_hip_ctrl_54_xhdl60;
    out_hip_ctrl_55 <= out_hip_ctrl_55_xhdl61;
    out_hip_ctrl_56 <= out_hip_ctrl_56_xhdl62;
    out_hip_ctrl_57 <= out_hip_ctrl_57_xhdl63;
    out_hip_ctrl_58 <= out_hip_ctrl_58_xhdl64;
    out_hip_ctrl_59 <= out_hip_ctrl_59_xhdl65;
    out_hip_ctrl_60 <= out_hip_ctrl_60_xhdl67;
    out_hip_ctrl_61 <= out_hip_ctrl_61_xhdl68;
    out_hip_ctrl_62 <= out_hip_ctrl_62_xhdl69;
    out_hip_ctrl_63 <= out_hip_ctrl_63_xhdl70;
    out_hip_ctrl_64 <= out_hip_ctrl_64_xhdl71;
    out_hip_ctrl_65 <= out_hip_ctrl_65_xhdl72;
    out_hip_ctrl_66 <= out_hip_ctrl_66_xhdl73;
    out_hip_ctrl_67 <= out_hip_ctrl_67_xhdl74;
    out_hip_ctrl_68 <= out_hip_ctrl_68_xhdl75;
    out_hip_ctrl_69 <= out_hip_ctrl_69_xhdl76;
    out_hip_ctrl_70 <= out_hip_ctrl_70_xhdl78;
    out_hip_ctrl_71 <= out_hip_ctrl_71_xhdl79;
    out_hip_ctrl_72 <= out_hip_ctrl_72_xhdl80;
    out_hip_ctrl_73 <= out_hip_ctrl_73_xhdl81;
    out_hip_ctrl_74 <= out_hip_ctrl_74_xhdl82;
    out_hip_ctrl_75 <= out_hip_ctrl_75_xhdl83;
    out_hip_ctrl_76 <= out_hip_ctrl_76_xhdl84;
    out_hip_ctrl_77 <= out_hip_ctrl_77_xhdl85;
    out_hip_ctrl_78 <= out_hip_ctrl_78_xhdl86;
    out_hip_ctrl_79 <= out_hip_ctrl_79_xhdl87;
    out_hip_ctrl_80 <= out_hip_ctrl_80_xhdl89;
    out_hip_ctrl_81 <= out_hip_ctrl_81_xhdl90;
    out_hip_ctrl_82 <= out_hip_ctrl_82_xhdl91;
    out_hip_ctrl_83 <= out_hip_ctrl_83_xhdl92;
    out_hip_ctrl_84 <= out_hip_ctrl_84_xhdl93;
    out_hip_ctrl_85 <= out_hip_ctrl_85_xhdl94;
    out_hip_ctrl_86 <= out_hip_ctrl_86_xhdl95;
    out_hip_ctrl_87 <= out_hip_ctrl_87_xhdl96;
    out_hip_ctrl_88 <= out_hip_ctrl_88_xhdl97;
    out_hip_ctrl_89 <= out_hip_ctrl_89_xhdl98;
    out_hip_ctrl_90 <= out_hip_ctrl_90_xhdl100;
    out_hip_ctrl_91 <= out_hip_ctrl_91_xhdl101;
    out_hip_ctrl_92 <= out_hip_ctrl_92_xhdl102;
    out_hip_ctrl_93 <= out_hip_ctrl_93_xhdl103;
    out_hip_ctrl_94 <= out_hip_ctrl_94_xhdl104;
    out_hip_ctrl_95 <= out_hip_ctrl_95_xhdl105;
    out_hip_ctrl_96 <= out_hip_ctrl_96_xhdl106;
    out_hip_ctrl_97 <= out_hip_ctrl_97_xhdl107;
    out_hip_ctrl_98 <= out_hip_ctrl_98_xhdl108;
    out_hip_ctrl_99 <= out_hip_ctrl_99_xhdl109;
    out_hip_ctrl_100 <= out_hip_ctrl_100_xhdl2;
    out_hip_ctrl_101 <= out_hip_ctrl_101_xhdl3;
    out_hip_ctrl_102 <= out_hip_ctrl_102_xhdl4;
    out_hip_ctrl_103 <= out_hip_ctrl_103_xhdl5;
    out_hip_ctrl_104 <= out_hip_ctrl_104_xhdl6;
    out_hip_ctrl_105 <= out_hip_ctrl_105_xhdl7;
    out_hip_ctrl_106 <= out_hip_ctrl_106_xhdl8;
    out_hip_ctrl_107 <= out_hip_ctrl_107_xhdl9;
    out_hip_ctrl_108 <= out_hip_ctrl_108_xhdl10;
    out_hip_ctrl_109 <= out_hip_ctrl_109_xhdl11;
    out_hip_ctrl_110 <= out_hip_ctrl_110_xhdl13;
    so <= so_xhdl110;
    
    
    
    centrl_ctrl_1 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_1,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_1,
            serial_mode  => serial_mode,
            si           => si,
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_1_xhdl0,
            so           => chain(0)
        );
    
    
    
    centrl_ctrl_2 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_2,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_2,
            serial_mode  => serial_mode,
            si           => chain(0),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_2_xhdl22,
            so           => chain(1)
        );
    
    
    
    centrl_ctrl_3 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_3,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_3,
            serial_mode  => serial_mode,
            si           => chain(1),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_3_xhdl33,
            so           => chain(2)
        );
    
    
    
    centrl_ctrl_4 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_4,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_4,
            serial_mode  => serial_mode,
            si           => chain(2),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_4_xhdl44,
            so           => chain(3)
        );
    
    
    
    centrl_ctrl_5 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_5,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_5,
            serial_mode  => serial_mode,
            si           => chain(3),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_5_xhdl55,
            so           => chain(4)
        );
    
    
    
    centrl_ctrl_6 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_6,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_6,
            serial_mode  => serial_mode,
            si           => chain(4),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_6_xhdl66,
            so           => chain(5)
        );
    
    
    
    centrl_ctrl_7 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_7,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_7,
            serial_mode  => serial_mode,
            si           => chain(5),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_7_xhdl77,
            so           => chain(6)
        );
    
    
    
    centrl_ctrl_8 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_8,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_8,
            serial_mode  => serial_mode,
            si           => chain(6),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_8_xhdl88,
            so           => chain(7)
        );
    
    
    
    centrl_ctrl_9 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_9,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_9,
            serial_mode  => serial_mode,
            si           => chain(7),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_9_xhdl99,
            so           => chain(8)
        );
    
    
    
    centrl_ctrl_10 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_10,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_10,
            serial_mode  => serial_mode,
            si           => chain(8),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_10_xhdl1,
            so           => chain(9)
        );
    
    
    
    centrl_ctrl_11 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_11,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_11,
            serial_mode  => serial_mode,
            si           => chain(9),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_11_xhdl12,
            so           => chain(10)
        );
    
    
    
    centrl_ctrl_12 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_12,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_12,
            serial_mode  => serial_mode,
            si           => chain(10),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_12_xhdl14,
            so           => chain(11)
        );
    
    
    
    centrl_ctrl_13 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_13,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_13,
            serial_mode  => serial_mode,
            si           => chain(11),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_13_xhdl15,
            so           => chain(12)
        );
    
    
    
    centrl_ctrl_14 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_14,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_14,
            serial_mode  => serial_mode,
            si           => chain(12),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_14_xhdl16,
            so           => chain(13)
        );
    
    
    
    centrl_ctrl_15 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_15,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_15,
            serial_mode  => serial_mode,
            si           => chain(13),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_15_xhdl17,
            so           => chain(14)
        );
    
    
    
    centrl_ctrl_16 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_16,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_16,
            serial_mode  => serial_mode,
            si           => chain(14),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_16_xhdl18,
            so           => chain(15)
        );
    
    
    
    centrl_ctrl_17 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_17,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_17,
            serial_mode  => serial_mode,
            si           => chain(15),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_17_xhdl19,
            so           => chain(16)
        );
    
    
    
    centrl_ctrl_18 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_18,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_18,
            serial_mode  => serial_mode,
            si           => chain(16),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_18_xhdl20,
            so           => chain(17)
        );
    
    
    
    centrl_ctrl_19 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_19,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_19,
            serial_mode  => serial_mode,
            si           => chain(17),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_19_xhdl21,
            so           => chain(18)
        );
    
    
    
    centrl_ctrl_20 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_20,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_20,
            serial_mode  => serial_mode,
            si           => chain(18),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_20_xhdl23,
            so           => chain(19)
        );
    
    
    
    centrl_ctrl_21 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_21,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_21,
            serial_mode  => serial_mode,
            si           => chain(19),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_21_xhdl24,
            so           => chain(20)
        );
    
    
    
    centrl_ctrl_22 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_22,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_22,
            serial_mode  => serial_mode,
            si           => chain(20),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_22_xhdl25,
            so           => chain(21)
        );
    
    
    
    centrl_ctrl_23 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_23,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_23,
            serial_mode  => serial_mode,
            si           => chain(21),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_23_xhdl26,
            so           => chain(22)
        );
    
    
    
    centrl_ctrl_24 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_24,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_24,
            serial_mode  => serial_mode,
            si           => chain(22),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_24_xhdl27,
            so           => chain(23)
        );
    
    
    
    centrl_ctrl_25 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_25,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_25,
            serial_mode  => serial_mode,
            si           => chain(23),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_25_xhdl28,
            so           => chain(24)
        );
    
    
    
    centrl_ctrl_26 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_26,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_26,
            serial_mode  => serial_mode,
            si           => chain(24),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_26_xhdl29,
            so           => chain(25)
        );
    
    
    
    centrl_ctrl_27 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_27,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_27,
            serial_mode  => serial_mode,
            si           => chain(25),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_27_xhdl30,
            so           => chain(26)
        );
    
    
    
    centrl_ctrl_28 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_28,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_28,
            serial_mode  => serial_mode,
            si           => chain(26),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_28_xhdl31,
            so           => chain(27)
        );
    
    
    
    centrl_ctrl_29 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_29,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_29,
            serial_mode  => serial_mode,
            si           => chain(27),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_29_xhdl32,
            so           => chain(28)
        );
    
    
    
    centrl_ctrl_30 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_30,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_30,
            serial_mode  => serial_mode,
            si           => chain(28),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_30_xhdl34,
            so           => chain(29)
        );
    
    
    
    centrl_ctrl_31 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_31,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_31,
            serial_mode  => serial_mode,
            si           => chain(29),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_31_xhdl35,
            so           => chain(30)
        );
    
    
    
    centrl_ctrl_32 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_32,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_32,
            serial_mode  => serial_mode,
            si           => chain(30),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_32_xhdl36,
            so           => chain(31)
        );
    
    
    
    centrl_ctrl_33 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_33,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_33,
            serial_mode  => serial_mode,
            si           => chain(31),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_33_xhdl37,
            so           => chain(32)
        );
    
    
    
    centrl_ctrl_34 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_34,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_34,
            serial_mode  => serial_mode,
            si           => chain(32),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_34_xhdl38,
            so           => chain(33)
        );
    
    
    
    centrl_ctrl_35 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_35,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_35,
            serial_mode  => serial_mode,
            si           => chain(33),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_35_xhdl39,
            so           => chain(34)
        );
    
    
    
    centrl_ctrl_36 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_36,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_36,
            serial_mode  => serial_mode,
            si           => chain(34),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_36_xhdl40,
            so           => chain(35)
        );
    
    
    
    centrl_ctrl_37 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_37,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_37,
            serial_mode  => serial_mode,
            si           => chain(35),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_37_xhdl41,
            so           => chain(36)
        );
    
    
    
    centrl_ctrl_38 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_38,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_38,
            serial_mode  => serial_mode,
            si           => chain(36),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_38_xhdl42,
            so           => chain(37)
        );
    
    
    
    centrl_ctrl_39 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_39,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_39,
            serial_mode  => serial_mode,
            si           => chain(37),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_39_xhdl43,
            so           => chain(38)
        );
    
    
    
    centrl_ctrl_40 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_40,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_40,
            serial_mode  => serial_mode,
            si           => chain(38),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_40_xhdl45,
            so           => chain(39)
        );
    
    
    
    centrl_ctrl_41 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_41,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_41,
            serial_mode  => serial_mode,
            si           => chain(39),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_41_xhdl46,
            so           => chain(40)
        );
    
    
    
    centrl_ctrl_42 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_42,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_42,
            serial_mode  => serial_mode,
            si           => chain(40),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_42_xhdl47,
            so           => chain(41)
        );
    
    
    
    centrl_ctrl_43 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_43,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_43,
            serial_mode  => serial_mode,
            si           => chain(41),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_43_xhdl48,
            so           => chain(42)
        );
    
    
    
    centrl_ctrl_44 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_44,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_44,
            serial_mode  => serial_mode,
            si           => chain(42),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_44_xhdl49,
            so           => chain(43)
        );
    
    
    
    centrl_ctrl_45 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_45,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_45,
            serial_mode  => serial_mode,
            si           => chain(43),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_45_xhdl50,
            so           => chain(44)
        );
    
    
    
    centrl_ctrl_46 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_46,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_46,
            serial_mode  => serial_mode,
            si           => chain(44),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_46_xhdl51,
            so           => chain(45)
        );
    
    
    
    centrl_ctrl_47 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_47,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_47,
            serial_mode  => serial_mode,
            si           => chain(45),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_47_xhdl52,
            so           => chain(46)
        );
    
    
    
    centrl_ctrl_48 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_48,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_48,
            serial_mode  => serial_mode,
            si           => chain(46),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_48_xhdl53,
            so           => chain(47)
        );
    
    
    
    centrl_ctrl_49 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_49,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_49,
            serial_mode  => serial_mode,
            si           => chain(47),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_49_xhdl54,
            so           => chain(48)
        );
    
    
    
    centrl_ctrl_50 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_50,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_50,
            serial_mode  => serial_mode,
            si           => chain(48),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_50_xhdl56,
            so           => chain(49)
        );
    
    
    
    centrl_ctrl_51 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_51,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_51,
            serial_mode  => serial_mode,
            si           => chain(49),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_51_xhdl57,
            so           => chain(50)
        );
    
    
    
    centrl_ctrl_52 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_52,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_52,
            serial_mode  => serial_mode,
            si           => chain(50),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_52_xhdl58,
            so           => chain(51)
        );
    
    
    
    centrl_ctrl_53 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_53,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_53,
            serial_mode  => serial_mode,
            si           => chain(51),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_53_xhdl59,
            so           => chain(52)
        );
    
    
    
    centrl_ctrl_54 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_54,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_54,
            serial_mode  => serial_mode,
            si           => chain(52),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_54_xhdl60,
            so           => chain(53)
        );
    
    
    
    centrl_ctrl_55 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_55,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_55,
            serial_mode  => serial_mode,
            si           => chain(53),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_55_xhdl61,
            so           => chain(54)
        );
    
    
    
    centrl_ctrl_56 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_56,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_56,
            serial_mode  => serial_mode,
            si           => chain(54),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_56_xhdl62,
            so           => chain(55)
        );
    
    
    
    centrl_ctrl_57 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_57,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_57,
            serial_mode  => serial_mode,
            si           => chain(55),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_57_xhdl63,
            so           => chain(56)
        );
    
    
    
    centrl_ctrl_58 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_58,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_58,
            serial_mode  => serial_mode,
            si           => chain(56),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_58_xhdl64,
            so           => chain(57)
        );
    
    
    
    centrl_ctrl_59 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_59,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_59,
            serial_mode  => serial_mode,
            si           => chain(57),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_59_xhdl65,
            so           => chain(58)
        );
    
    
    
    centrl_ctrl_60 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_60,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_60,
            serial_mode  => serial_mode,
            si           => chain(58),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_60_xhdl67,
            so           => chain(59)
        );
    
    
    
    centrl_ctrl_61 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_61,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_61,
            serial_mode  => serial_mode,
            si           => chain(59),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_61_xhdl68,
            so           => chain(60)
        );
    
    
    
    centrl_ctrl_62 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_62,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_62,
            serial_mode  => serial_mode,
            si           => chain(60),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_62_xhdl69,
            so           => chain(61)
        );
    
    
    
    centrl_ctrl_63 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_63,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_63,
            serial_mode  => serial_mode,
            si           => chain(61),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_63_xhdl70,
            so           => chain(62)
        );
    
    
    
    centrl_ctrl_64 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_64,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_64,
            serial_mode  => serial_mode,
            si           => chain(62),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_64_xhdl71,
            so           => chain(63)
        );
    
    
    
    centrl_ctrl_65 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_65,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_65,
            serial_mode  => serial_mode,
            si           => chain(63),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_65_xhdl72,
            so           => chain(64)
        );
    
    
    
    centrl_ctrl_66 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_66,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_66,
            serial_mode  => serial_mode,
            si           => chain(64),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_66_xhdl73,
            so           => chain(65)
        );
    
    
    
    centrl_ctrl_67 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_67,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_67,
            serial_mode  => serial_mode,
            si           => chain(65),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_67_xhdl74,
            so           => chain(66)
        );
    
    
    
    centrl_ctrl_68 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_68,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_68,
            serial_mode  => serial_mode,
            si           => chain(66),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_68_xhdl75,
            so           => chain(67)
        );
    
    
    
    centrl_ctrl_69 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_69,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_69,
            serial_mode  => serial_mode,
            si           => chain(67),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_69_xhdl76,
            so           => chain(68)
        );
    
    
    
    centrl_ctrl_70 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_70,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_70,
            serial_mode  => serial_mode,
            si           => chain(68),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_70_xhdl78,
            so           => chain(69)
        );
    
    
    
    centrl_ctrl_71 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_71,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_71,
            serial_mode  => serial_mode,
            si           => chain(69),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_71_xhdl79,
            so           => chain(70)
        );
    
    
    
    centrl_ctrl_72 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_72,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_72,
            serial_mode  => serial_mode,
            si           => chain(70),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_72_xhdl80,
            so           => chain(71)
        );
    
    
    
    centrl_ctrl_73 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_73,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_73,
            serial_mode  => serial_mode,
            si           => chain(71),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_73_xhdl81,
            so           => chain(72)
        );
    
    
    
    centrl_ctrl_74 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_74,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_74,
            serial_mode  => serial_mode,
            si           => chain(72),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_74_xhdl82,
            so           => chain(73)
        );
    
    
    
    centrl_ctrl_75 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_75,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_75,
            serial_mode  => serial_mode,
            si           => chain(73),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_75_xhdl83,
            so           => chain(74)
        );
    
    
    
    centrl_ctrl_76 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_76,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_76,
            serial_mode  => serial_mode,
            si           => chain(74),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_76_xhdl84,
            so           => chain(75)
        );
    
    
    
    centrl_ctrl_77 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_77,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_77,
            serial_mode  => serial_mode,
            si           => chain(75),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_77_xhdl85,
            so           => chain(76)
        );
    
    
    
    centrl_ctrl_78 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_78,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_78,
            serial_mode  => serial_mode,
            si           => chain(76),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_78_xhdl86,
            so           => chain(77)
        );
    
    
    
    centrl_ctrl_79 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_79,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_79,
            serial_mode  => serial_mode,
            si           => chain(77),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_79_xhdl87,
            so           => chain(78)
        );
    
    
    
    centrl_ctrl_80 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_80,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_80,
            serial_mode  => serial_mode,
            si           => chain(78),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_80_xhdl89,
            so           => chain(79)
        );
    
    
    
    centrl_ctrl_81 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_81,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_81,
            serial_mode  => serial_mode,
            si           => chain(79),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_81_xhdl90,
            so           => chain(80)
        );
    
    
    
    centrl_ctrl_82 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_82,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_82,
            serial_mode  => serial_mode,
            si           => chain(80),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_82_xhdl91,
            so           => chain(81)
        );
    
    
    
    centrl_ctrl_83 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_83,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_83,
            serial_mode  => serial_mode,
            si           => chain(81),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_83_xhdl92,
            so           => chain(82)
        );
    
    
    
    centrl_ctrl_84 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_84,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_84,
            serial_mode  => serial_mode,
            si           => chain(82),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_84_xhdl93,
            so           => chain(83)
        );
    
    
    
    centrl_ctrl_85 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_85,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_85,
            serial_mode  => serial_mode,
            si           => chain(83),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_85_xhdl94,
            so           => chain(84)
        );
    
    
    
    centrl_ctrl_86 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_86,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_86,
            serial_mode  => serial_mode,
            si           => chain(84),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_86_xhdl95,
            so           => chain(85)
        );
    
    
    
    centrl_ctrl_87 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_87,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_87,
            serial_mode  => serial_mode,
            si           => chain(85),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_87_xhdl96,
            so           => chain(86)
        );
    
    
    
    centrl_ctrl_88 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_88,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_88,
            serial_mode  => serial_mode,
            si           => chain(86),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_88_xhdl97,
            so           => chain(87)
        );
    
    
    
    centrl_ctrl_89 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_89,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_89,
            serial_mode  => serial_mode,
            si           => chain(87),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_89_xhdl98,
            so           => chain(88)
        );
    
    
    
    centrl_ctrl_90 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_90,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_90,
            serial_mode  => serial_mode,
            si           => chain(88),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_90_xhdl100,
            so           => chain(89)
        );
    
    
    
    centrl_ctrl_91 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_91,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_91,
            serial_mode  => serial_mode,
            si           => chain(89),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_91_xhdl101,
            so           => chain(90)
        );
    
    
    
    centrl_ctrl_92 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_92,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_92,
            serial_mode  => serial_mode,
            si           => chain(90),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_92_xhdl102,
            so           => chain(91)
        );
    
    
    
    centrl_ctrl_93 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_93,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_93,
            serial_mode  => serial_mode,
            si           => chain(91),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_93_xhdl103,
            so           => chain(92)
        );
    
    
    
    centrl_ctrl_94 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_94,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_94,
            serial_mode  => serial_mode,
            si           => chain(92),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_94_xhdl104,
            so           => chain(93)
        );
    
    
    
    centrl_ctrl_95 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_95,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_95,
            serial_mode  => serial_mode,
            si           => chain(93),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_95_xhdl105,
            so           => chain(94)
        );
    
    
    
    centrl_ctrl_96 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_96,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_96,
            serial_mode  => serial_mode,
            si           => chain(94),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_96_xhdl106,
            so           => chain(95)
        );
    
    
    
    centrl_ctrl_97 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_97,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_97,
            serial_mode  => serial_mode,
            si           => chain(95),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_97_xhdl107,
            so           => chain(96)
        );
    
    
    
    centrl_ctrl_98 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_98,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_98,
            serial_mode  => serial_mode,
            si           => chain(96),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_98_xhdl108,
            so           => chain(97)
        );
    
    
    
    centrl_ctrl_99 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_99,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_99,
            serial_mode  => serial_mode,
            si           => chain(97),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_99_xhdl109,
            so           => chain(98)
        );
    
    
    
    centrl_ctrl_100 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_100,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_100,
            serial_mode  => serial_mode,
            si           => chain(98),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_100_xhdl2,
            so           => chain(99)
        );
    
    
    
    centrl_ctrl_101 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_101,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_101,
            serial_mode  => serial_mode,
            si           => chain(99),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_101_xhdl3,
            so           => chain(100)
        );
    
    
    
    centrl_ctrl_102 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_102,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_102,
            serial_mode  => serial_mode,
            si           => chain(100),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_102_xhdl4,
            so           => chain(101)
        );
    
    
    
    centrl_ctrl_103 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_103,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_103,
            serial_mode  => serial_mode,
            si           => chain(101),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_103_xhdl5,
            so           => chain(102)
        );
    
    
    
    centrl_ctrl_104 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_104,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_104,
            serial_mode  => serial_mode,
            si           => chain(102),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_104_xhdl6,
            so           => chain(103)
        );
    
    
    
    centrl_ctrl_105 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_105,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_105,
            serial_mode  => serial_mode,
            si           => chain(103),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_105_xhdl7,
            so           => chain(104)
        );
    
    
    
    centrl_ctrl_106 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_106,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_106,
            serial_mode  => serial_mode,
            si           => chain(104),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_106_xhdl8,
            so           => chain(105)
        );
    
    
    
    centrl_ctrl_107 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_107,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_107,
            serial_mode  => serial_mode,
            si           => chain(105),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_107_xhdl9,
            so           => chain(106)
        );
    
    
    
    centrl_ctrl_108 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_108,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_108,
            serial_mode  => serial_mode,
            si           => chain(106),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_108_xhdl10,
            so           => chain(107)
        );
    
    
    
    centrl_ctrl_109 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_109,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_109,
            serial_mode  => serial_mode,
            si           => chain(107),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_109_xhdl11,
            so           => chain(108)
        );
    
    
    
    centrl_ctrl_110 : stratixiv_pciehip_dprio_16bit
        PORT MAP (
            reset        => mdio_rst,
            mdio_wr      => mdio_wr,
            reg_addr     => reg_addr,
            target_addr  => targ_addr_ctrl_110,
            clk          => mdc,
            sig_in       => mbus_in,
            ext_in       => ext_hip_ctrl_110,
            serial_mode  => serial_mode,
            si           => chain(108),
            shift        => ser_shift_load,
            mdio_dis     => mdio_dis,
            sig_out      => out_hip_ctrl_110_xhdl13,
            so           => so_xhdl110
        );
    
END ARCHITECTURE trans;


LIBRARY ieee;
    USE ieee.std_logic_1164.all;
    USE ieee.std_logic_unsigned.all;

ENTITY stratixiv_pciehip_dprio_reg_top IS
    PORT (
        
        mdio_rst               : IN STD_LOGIC;		-- DPRIO reset input
        mdio_wr                : IN STD_LOGIC;		-- DPRIO register write enable
        reg_addr               : IN STD_LOGIC_VECTOR(15 DOWNTO 0);		-- DPRIO register address from SM
        mdc                    : IN STD_LOGIC;		-- DPRIO clock
        mbus_in                : IN STD_LOGIC_VECTOR(15 DOWNTO 0);		-- DPRIO data in from SM
        serial_mode            : IN STD_LOGIC;		-- DPRIO serial mode enable
        mdio_dis               : IN STD_LOGIC;		-- DPRIO disable signal (using CSR input)
        ser_shift_load         : IN STD_LOGIC;		-- DPRIO serial shift or load control signal
        si                     : IN STD_LOGIC;		-- DPRIO serial input
        csr_hip_in             : IN STD_LOGIC_VECTOR(1759 DOWNTO 0);		-- CSR inputs
        hip_base_addr          : IN STD_LOGIC_VECTOR(7 DOWNTO 0);		-- DPRIO HIP base address
        
        so                     : OUT STD_LOGIC;		-- DPRIO serial out
        mbus_out               : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);		-- DPRIO dataout
        -- CRAM output
        out_hip_ctrl_1         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_2         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_3         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_4         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_5         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_6         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_7         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_8         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_9         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_10        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_11        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_12        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_13        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_14        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_15        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_16        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_17        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_18        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_19        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_20        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_21        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_22        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_23        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_24        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_25        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_26        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_27        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_28        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_29        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_30        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_31        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_32        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_33        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_34        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_35        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_36        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_37        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_38        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_39        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_40        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_41        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_42        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_43        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_44        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_45        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_46        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_47        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_48        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_49        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_50        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_51        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_52        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_53        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_54        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_55        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_56        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_57        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_58        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_59        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_60        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_61        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_62        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_63        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_64        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_65        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_66        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_67        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_68        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_69        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_70        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_71        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_72        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_73        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_74        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_75        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_76        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_77        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_78        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_79        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_80        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_81        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_82        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_83        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_84        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_85        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_86        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_87        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_88        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_89        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_90        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_91        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_92        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_93        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_94        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_95        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_96        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_97        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_98        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_99        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_100       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_101       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_102       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_103       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_104       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_105       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_106       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_107       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_108       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_109       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_110       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0)
    );
END ENTITY stratixiv_pciehip_dprio_reg_top;

ARCHITECTURE trans OF stratixiv_pciehip_dprio_reg_top IS
    COMPONENT stratixiv_pciehip_dprio_reg IS
        PORT (
            mdio_rst               : IN STD_LOGIC;
            mdio_wr                : IN STD_LOGIC;
            reg_addr               : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            mdc                    : IN STD_LOGIC;
            mbus_in                : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            serial_mode            : IN STD_LOGIC;
            mdio_dis               : IN STD_LOGIC;
            ser_shift_load         : IN STD_LOGIC;
            si                     : IN STD_LOGIC;
            ext_hip_ctrl_1         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_2         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_3         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_4         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_5         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_6         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_7         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_8         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_9         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_10        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_11        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_12        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_13        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_14        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_15        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_16        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_17        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_18        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_19        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_20        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_21        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_22        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_23        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_24        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_25        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_26        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_27        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_28        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_29        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_30        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_31        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_32        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_33        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_34        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_35        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_36        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_37        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_38        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_39        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_40        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_41        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_42        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_43        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_44        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_45        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_46        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_47        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_48        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_49        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_50        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_51        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_52        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_53        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_54        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_55        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_56        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_57        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_58        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_59        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_60        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_61        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_62        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_63        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_64        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_65        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_66        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_67        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_68        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_69        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_70        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_71        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_72        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_73        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_74        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_75        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_76        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_77        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_78        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_79        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_80        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_81        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_82        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_83        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_84        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_85        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_86        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_87        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_88        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_89        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_90        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_91        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_92        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_93        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_94        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_95        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_96        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_97        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_98        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_99        : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_100       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_101       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_102       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_103       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_104       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_105       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_106       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_107       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_108       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_109       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            ext_hip_ctrl_110       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_1       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_2       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_3       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_4       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_5       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_6       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_7       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_8       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_9       : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_10      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_11      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_12      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_13      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_14      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_15      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_16      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_17      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_18      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_19      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_20      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_21      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_22      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_23      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_24      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_25      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_26      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_27      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_28      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_29      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_30      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_31      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_32      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_33      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_34      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_35      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_36      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_37      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_38      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_39      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_40      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_41      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_42      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_43      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_44      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_45      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_46      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_47      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_48      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_49      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_50      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_51      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_52      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_53      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_54      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_55      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_56      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_57      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_58      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_59      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_60      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_61      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_62      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_63      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_64      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_65      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_66      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_67      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_68      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_69      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_70      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_71      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_72      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_73      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_74      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_75      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_76      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_77      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_78      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_79      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_80      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_81      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_82      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_83      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_84      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_85      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_86      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_87      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_88      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_89      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_90      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_91      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_92      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_93      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_94      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_95      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_96      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_97      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_98      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_99      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_100     : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_101     : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_102     : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_103     : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_104     : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_105     : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_106     : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_107     : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_108     : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_109     : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            targ_addr_ctrl_110     : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_1         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_2         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_3         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_4         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_5         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_6         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_7         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_8         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_9         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_10        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_11        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_12        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_13        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_14        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_15        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_16        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_17        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_18        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_19        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_20        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_21        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_22        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_23        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_24        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_25        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_26        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_27        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_28        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_29        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_30        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_31        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_32        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_33        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_34        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_35        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_36        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_37        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_38        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_39        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_40        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_41        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_42        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_43        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_44        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_45        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_46        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_47        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_48        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_49        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_50        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_51        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_52        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_53        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_54        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_55        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_56        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_57        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_58        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_59        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_60        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_61        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_62        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_63        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_64        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_65        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_66        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_67        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_68        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_69        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_70        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_71        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_72        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_73        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_74        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_75        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_76        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_77        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_78        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_79        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_80        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_81        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_82        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_83        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_84        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_85        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_86        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_87        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_88        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_89        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_90        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_91        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_92        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_93        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_94        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_95        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_96        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_97        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_98        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_99        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_100       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_101       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_102       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_103       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_104       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_105       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_106       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_107       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_108       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_109       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_110       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            so                     : OUT STD_LOGIC
        );
    END COMPONENT;
    
    COMPONENT stratixiv_pciehip_dprio_bus_out_mux IS
        PORT (
            hip_ctrl_in1           : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in2           : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in3           : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in4           : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in5           : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in6           : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in7           : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in8           : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in9           : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in10          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in11          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in12          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in13          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in14          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in15          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in16          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in17          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in18          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in19          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in20          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in21          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in22          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in23          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in24          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in25          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in26          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in27          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in28          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in29          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in30          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in31          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in32          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in33          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in34          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in35          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in36          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in37          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in38          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in39          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in40          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in41          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in42          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in43          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in44          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in45          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in46          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in47          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in48          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in49          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in50          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in51          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in52          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in53          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in54          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in55          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in56          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in57          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in58          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in59          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in60          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in61          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in62          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in63          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in64          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in65          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in66          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in67          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in68          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in69          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in70          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in71          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in72          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in73          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in74          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in75          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in76          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in77          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in78          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in79          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in80          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in81          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in82          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in83          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in84          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in85          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in86          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in87          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in88          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in89          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in90          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in91          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in92          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in93          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in94          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in95          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in96          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in97          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in98          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in99          : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in100         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in101         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in102         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in103         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in104         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in105         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in106         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in107         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in108         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in109         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_in110         : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in1    : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in2    : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in3    : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in4    : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in5    : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in6    : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in7    : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in8    : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in9    : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in10   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in11   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in12   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in13   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in14   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in15   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in16   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in17   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in18   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in19   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in20   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in21   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in22   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in23   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in24   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in25   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in26   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in27   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in28   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in29   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in30   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in31   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in32   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in33   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in34   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in35   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in36   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in37   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in38   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in39   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in40   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in41   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in42   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in43   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in44   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in45   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in46   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in47   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in48   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in49   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in50   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in51   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in52   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in53   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in54   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in55   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in56   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in57   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in58   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in59   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in60   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in61   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in62   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in63   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in64   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in65   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in66   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in67   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in68   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in69   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in70   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in71   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in72   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in73   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in74   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in75   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in76   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in77   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in78   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in79   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in80   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in81   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in82   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in83   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in84   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in85   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in86   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in87   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in88   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in89   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in90   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in91   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in92   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in93   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in94   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in95   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in96   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in97   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in98   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in99   : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in100  : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in101  : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in102  : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in103  : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in104  : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in105  : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in106  : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in107  : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in108  : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in109  : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hw_address_ctrl_in110  : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            reg_addr               : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            hip_ctrl_out           : OUT STD_LOGIC_VECTOR(15 DOWNTO 0)
        );
    END COMPONENT;
    
    
    -- Wiring
    SIGNAL targ_addr_ctrl_1        : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_2        : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_3        : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_4        : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_5        : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_6        : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_7        : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_8        : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_9        : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_10       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_11       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_12       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_13       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_14       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_15       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_16       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_17       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_18       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_19       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_20       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_21       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_22       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_23       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_24       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_25       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_26       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_27       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_28       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_29       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_30       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_31       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_32       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_33       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_34       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_35       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_36       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_37       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_38       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_39       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_40       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_41       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_42       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_43       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_44       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_45       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_46       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_47       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_48       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_49       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_50       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_51       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_52       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_53       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_54       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_55       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_56       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_57       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_58       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_59       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_60       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_61       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_62       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_63       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_64       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_65       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_66       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_67       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_68       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_69       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_70       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_71       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_72       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_73       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_74       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_75       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_76       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_77       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_78       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_79       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_80       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_81       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_82       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_83       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_84       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_85       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_86       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_87       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_88       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_89       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_90       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_91       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_92       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_93       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_94       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_95       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_96       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_97       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_98       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_99       : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_100      : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_101      : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_102      : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_103      : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_104      : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_105      : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_106      : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_107      : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_108      : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_109      : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL targ_addr_ctrl_110      : STD_LOGIC_VECTOR(15 DOWNTO 0);
    
    -- Declare intermediate signals for referenced outputs
    SIGNAL so_xhdl111              : STD_LOGIC;
    SIGNAL mbus_out_xhdl0          : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_1_xhdl1    : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_2_xhdl23   : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_3_xhdl34   : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_4_xhdl45   : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_5_xhdl56   : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_6_xhdl67   : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_7_xhdl78   : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_8_xhdl89   : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_9_xhdl100  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_10_xhdl2   : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_11_xhdl13  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_12_xhdl15  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_13_xhdl16  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_14_xhdl17  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_15_xhdl18  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_16_xhdl19  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_17_xhdl20  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_18_xhdl21  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_19_xhdl22  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_20_xhdl24  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_21_xhdl25  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_22_xhdl26  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_23_xhdl27  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_24_xhdl28  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_25_xhdl29  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_26_xhdl30  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_27_xhdl31  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_28_xhdl32  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_29_xhdl33  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_30_xhdl35  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_31_xhdl36  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_32_xhdl37  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_33_xhdl38  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_34_xhdl39  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_35_xhdl40  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_36_xhdl41  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_37_xhdl42  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_38_xhdl43  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_39_xhdl44  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_40_xhdl46  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_41_xhdl47  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_42_xhdl48  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_43_xhdl49  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_44_xhdl50  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_45_xhdl51  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_46_xhdl52  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_47_xhdl53  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_48_xhdl54  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_49_xhdl55  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_50_xhdl57  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_51_xhdl58  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_52_xhdl59  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_53_xhdl60  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_54_xhdl61  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_55_xhdl62  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_56_xhdl63  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_57_xhdl64  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_58_xhdl65  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_59_xhdl66  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_60_xhdl68  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_61_xhdl69  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_62_xhdl70  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_63_xhdl71  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_64_xhdl72  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_65_xhdl73  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_66_xhdl74  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_67_xhdl75  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_68_xhdl76  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_69_xhdl77  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_70_xhdl79  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_71_xhdl80  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_72_xhdl81  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_73_xhdl82  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_74_xhdl83  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_75_xhdl84  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_76_xhdl85  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_77_xhdl86  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_78_xhdl87  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_79_xhdl88  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_80_xhdl90  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_81_xhdl91  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_82_xhdl92  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_83_xhdl93  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_84_xhdl94  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_85_xhdl95  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_86_xhdl96  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_87_xhdl97  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_88_xhdl98  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_89_xhdl99  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_90_xhdl101 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_91_xhdl102 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_92_xhdl103 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_93_xhdl104 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_94_xhdl105 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_95_xhdl106 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_96_xhdl107 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_97_xhdl108 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_98_xhdl109 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_99_xhdl110 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_100_xhdl3  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_101_xhdl4  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_102_xhdl5  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_103_xhdl6  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_104_xhdl7  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_105_xhdl8  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_106_xhdl9  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_107_xhdl10 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_108_xhdl11 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_109_xhdl12 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_110_xhdl14 : STD_LOGIC_VECTOR(15 DOWNTO 0);
BEGIN
    -- Drive referenced outputs
    so <= so_xhdl111;
    mbus_out <= mbus_out_xhdl0;
    out_hip_ctrl_1 <= out_hip_ctrl_1_xhdl1;
    out_hip_ctrl_2 <= out_hip_ctrl_2_xhdl23;
    out_hip_ctrl_3 <= out_hip_ctrl_3_xhdl34;
    out_hip_ctrl_4 <= out_hip_ctrl_4_xhdl45;
    out_hip_ctrl_5 <= out_hip_ctrl_5_xhdl56;
    out_hip_ctrl_6 <= out_hip_ctrl_6_xhdl67;
    out_hip_ctrl_7 <= out_hip_ctrl_7_xhdl78;
    out_hip_ctrl_8 <= out_hip_ctrl_8_xhdl89;
    out_hip_ctrl_9 <= out_hip_ctrl_9_xhdl100;
    out_hip_ctrl_10 <= out_hip_ctrl_10_xhdl2;
    out_hip_ctrl_11 <= out_hip_ctrl_11_xhdl13;
    out_hip_ctrl_12 <= out_hip_ctrl_12_xhdl15;
    out_hip_ctrl_13 <= out_hip_ctrl_13_xhdl16;
    out_hip_ctrl_14 <= out_hip_ctrl_14_xhdl17;
    out_hip_ctrl_15 <= out_hip_ctrl_15_xhdl18;
    out_hip_ctrl_16 <= out_hip_ctrl_16_xhdl19;
    out_hip_ctrl_17 <= out_hip_ctrl_17_xhdl20;
    out_hip_ctrl_18 <= out_hip_ctrl_18_xhdl21;
    out_hip_ctrl_19 <= out_hip_ctrl_19_xhdl22;
    out_hip_ctrl_20 <= out_hip_ctrl_20_xhdl24;
    out_hip_ctrl_21 <= out_hip_ctrl_21_xhdl25;
    out_hip_ctrl_22 <= out_hip_ctrl_22_xhdl26;
    out_hip_ctrl_23 <= out_hip_ctrl_23_xhdl27;
    out_hip_ctrl_24 <= out_hip_ctrl_24_xhdl28;
    out_hip_ctrl_25 <= out_hip_ctrl_25_xhdl29;
    out_hip_ctrl_26 <= out_hip_ctrl_26_xhdl30;
    out_hip_ctrl_27 <= out_hip_ctrl_27_xhdl31;
    out_hip_ctrl_28 <= out_hip_ctrl_28_xhdl32;
    out_hip_ctrl_29 <= out_hip_ctrl_29_xhdl33;
    out_hip_ctrl_30 <= out_hip_ctrl_30_xhdl35;
    out_hip_ctrl_31 <= out_hip_ctrl_31_xhdl36;
    out_hip_ctrl_32 <= out_hip_ctrl_32_xhdl37;
    out_hip_ctrl_33 <= out_hip_ctrl_33_xhdl38;
    out_hip_ctrl_34 <= out_hip_ctrl_34_xhdl39;
    out_hip_ctrl_35 <= out_hip_ctrl_35_xhdl40;
    out_hip_ctrl_36 <= out_hip_ctrl_36_xhdl41;
    out_hip_ctrl_37 <= out_hip_ctrl_37_xhdl42;
    out_hip_ctrl_38 <= out_hip_ctrl_38_xhdl43;
    out_hip_ctrl_39 <= out_hip_ctrl_39_xhdl44;
    out_hip_ctrl_40 <= out_hip_ctrl_40_xhdl46;
    out_hip_ctrl_41 <= out_hip_ctrl_41_xhdl47;
    out_hip_ctrl_42 <= out_hip_ctrl_42_xhdl48;
    out_hip_ctrl_43 <= out_hip_ctrl_43_xhdl49;
    out_hip_ctrl_44 <= out_hip_ctrl_44_xhdl50;
    out_hip_ctrl_45 <= out_hip_ctrl_45_xhdl51;
    out_hip_ctrl_46 <= out_hip_ctrl_46_xhdl52;
    out_hip_ctrl_47 <= out_hip_ctrl_47_xhdl53;
    out_hip_ctrl_48 <= out_hip_ctrl_48_xhdl54;
    out_hip_ctrl_49 <= out_hip_ctrl_49_xhdl55;
    out_hip_ctrl_50 <= out_hip_ctrl_50_xhdl57;
    out_hip_ctrl_51 <= out_hip_ctrl_51_xhdl58;
    out_hip_ctrl_52 <= out_hip_ctrl_52_xhdl59;
    out_hip_ctrl_53 <= out_hip_ctrl_53_xhdl60;
    out_hip_ctrl_54 <= out_hip_ctrl_54_xhdl61;
    out_hip_ctrl_55 <= out_hip_ctrl_55_xhdl62;
    out_hip_ctrl_56 <= out_hip_ctrl_56_xhdl63;
    out_hip_ctrl_57 <= out_hip_ctrl_57_xhdl64;
    out_hip_ctrl_58 <= out_hip_ctrl_58_xhdl65;
    out_hip_ctrl_59 <= out_hip_ctrl_59_xhdl66;
    out_hip_ctrl_60 <= out_hip_ctrl_60_xhdl68;
    out_hip_ctrl_61 <= out_hip_ctrl_61_xhdl69;
    out_hip_ctrl_62 <= out_hip_ctrl_62_xhdl70;
    out_hip_ctrl_63 <= out_hip_ctrl_63_xhdl71;
    out_hip_ctrl_64 <= out_hip_ctrl_64_xhdl72;
    out_hip_ctrl_65 <= out_hip_ctrl_65_xhdl73;
    out_hip_ctrl_66 <= out_hip_ctrl_66_xhdl74;
    out_hip_ctrl_67 <= out_hip_ctrl_67_xhdl75;
    out_hip_ctrl_68 <= out_hip_ctrl_68_xhdl76;
    out_hip_ctrl_69 <= out_hip_ctrl_69_xhdl77;
    out_hip_ctrl_70 <= out_hip_ctrl_70_xhdl79;
    out_hip_ctrl_71 <= out_hip_ctrl_71_xhdl80;
    out_hip_ctrl_72 <= out_hip_ctrl_72_xhdl81;
    out_hip_ctrl_73 <= out_hip_ctrl_73_xhdl82;
    out_hip_ctrl_74 <= out_hip_ctrl_74_xhdl83;
    out_hip_ctrl_75 <= out_hip_ctrl_75_xhdl84;
    out_hip_ctrl_76 <= out_hip_ctrl_76_xhdl85;
    out_hip_ctrl_77 <= out_hip_ctrl_77_xhdl86;
    out_hip_ctrl_78 <= out_hip_ctrl_78_xhdl87;
    out_hip_ctrl_79 <= out_hip_ctrl_79_xhdl88;
    out_hip_ctrl_80 <= out_hip_ctrl_80_xhdl90;
    out_hip_ctrl_81 <= out_hip_ctrl_81_xhdl91;
    out_hip_ctrl_82 <= out_hip_ctrl_82_xhdl92;
    out_hip_ctrl_83 <= out_hip_ctrl_83_xhdl93;
    out_hip_ctrl_84 <= out_hip_ctrl_84_xhdl94;
    out_hip_ctrl_85 <= out_hip_ctrl_85_xhdl95;
    out_hip_ctrl_86 <= out_hip_ctrl_86_xhdl96;
    out_hip_ctrl_87 <= out_hip_ctrl_87_xhdl97;
    out_hip_ctrl_88 <= out_hip_ctrl_88_xhdl98;
    out_hip_ctrl_89 <= out_hip_ctrl_89_xhdl99;
    out_hip_ctrl_90 <= out_hip_ctrl_90_xhdl101;
    out_hip_ctrl_91 <= out_hip_ctrl_91_xhdl102;
    out_hip_ctrl_92 <= out_hip_ctrl_92_xhdl103;
    out_hip_ctrl_93 <= out_hip_ctrl_93_xhdl104;
    out_hip_ctrl_94 <= out_hip_ctrl_94_xhdl105;
    out_hip_ctrl_95 <= out_hip_ctrl_95_xhdl106;
    out_hip_ctrl_96 <= out_hip_ctrl_96_xhdl107;
    out_hip_ctrl_97 <= out_hip_ctrl_97_xhdl108;
    out_hip_ctrl_98 <= out_hip_ctrl_98_xhdl109;
    out_hip_ctrl_99 <= out_hip_ctrl_99_xhdl110;
    out_hip_ctrl_100 <= out_hip_ctrl_100_xhdl3;
    out_hip_ctrl_101 <= out_hip_ctrl_101_xhdl4;
    out_hip_ctrl_102 <= out_hip_ctrl_102_xhdl5;
    out_hip_ctrl_103 <= out_hip_ctrl_103_xhdl6;
    out_hip_ctrl_104 <= out_hip_ctrl_104_xhdl7;
    out_hip_ctrl_105 <= out_hip_ctrl_105_xhdl8;
    out_hip_ctrl_106 <= out_hip_ctrl_106_xhdl9;
    out_hip_ctrl_107 <= out_hip_ctrl_107_xhdl10;
    out_hip_ctrl_108 <= out_hip_ctrl_108_xhdl11;
    out_hip_ctrl_109 <= out_hip_ctrl_109_xhdl12;
    out_hip_ctrl_110 <= out_hip_ctrl_110_xhdl14;
    
    -- Control register address assignment
    targ_addr_ctrl_1 <= ("10000000" & hip_base_addr) + "0000000000000001";
    targ_addr_ctrl_2 <= ("10000000" & hip_base_addr) + "0000000000000010";
    targ_addr_ctrl_3 <= ("10000000" & hip_base_addr) + "0000000000000011";
    targ_addr_ctrl_4 <= ("10000000" & hip_base_addr) + "0000000000000100";
    targ_addr_ctrl_5 <= ("10000000" & hip_base_addr) + "0000000000000101";
    targ_addr_ctrl_6 <= ("10000000" & hip_base_addr) + "0000000000000110";
    targ_addr_ctrl_7 <= ("10000000" & hip_base_addr) + "0000000000000111";
    targ_addr_ctrl_8 <= ("10000000" & hip_base_addr) + "0000000000001000";
    targ_addr_ctrl_9 <= ("10000000" & hip_base_addr) + "0000000000001001";
    targ_addr_ctrl_10 <= ("10000000" & hip_base_addr) + "0000000000001010";
    targ_addr_ctrl_11 <= ("10000000" & hip_base_addr) + "0000000000001011";
    targ_addr_ctrl_12 <= ("10000000" & hip_base_addr) + "0000000000001100";
    targ_addr_ctrl_13 <= ("10000000" & hip_base_addr) + "0000000000001101";
    targ_addr_ctrl_14 <= ("10000000" & hip_base_addr) + "0000000000001110";
    targ_addr_ctrl_15 <= ("10000000" & hip_base_addr) + "0000000000001111";
    targ_addr_ctrl_16 <= ("10000000" & hip_base_addr) + "0000000000010000";
    targ_addr_ctrl_17 <= ("10000000" & hip_base_addr) + "0000000000010001";
    targ_addr_ctrl_18 <= ("10000000" & hip_base_addr) + "0000000000010010";
    targ_addr_ctrl_19 <= ("10000000" & hip_base_addr) + "0000000000010011";
    targ_addr_ctrl_20 <= ("10000000" & hip_base_addr) + "0000000000010100";
    targ_addr_ctrl_21 <= ("10000000" & hip_base_addr) + "0000000000010101";
    targ_addr_ctrl_22 <= ("10000000" & hip_base_addr) + "0000000000010110";
    targ_addr_ctrl_23 <= ("10000000" & hip_base_addr) + "0000000000010111";
    targ_addr_ctrl_24 <= ("10000000" & hip_base_addr) + "0000000000011000";
    targ_addr_ctrl_25 <= ("10000000" & hip_base_addr) + "0000000000011001";
    targ_addr_ctrl_26 <= ("10000000" & hip_base_addr) + "0000000000011010";
    targ_addr_ctrl_27 <= ("10000000" & hip_base_addr) + "0000000000011011";
    targ_addr_ctrl_28 <= ("10000000" & hip_base_addr) + "0000000000011100";
    targ_addr_ctrl_29 <= ("10000000" & hip_base_addr) + "0000000000011101";
    targ_addr_ctrl_30 <= ("10000000" & hip_base_addr) + "0000000000011110";
    targ_addr_ctrl_31 <= ("10000000" & hip_base_addr) + "0000000000011111";
    targ_addr_ctrl_32 <= ("10000000" & hip_base_addr) + "0000000000100000";
    targ_addr_ctrl_33 <= ("10000000" & hip_base_addr) + "0000000000100001";
    targ_addr_ctrl_34 <= ("10000000" & hip_base_addr) + "0000000000100010";
    targ_addr_ctrl_35 <= ("10000000" & hip_base_addr) + "0000000000100011";
    targ_addr_ctrl_36 <= ("10000000" & hip_base_addr) + "0000000000100100";
    targ_addr_ctrl_37 <= ("10000000" & hip_base_addr) + "0000000000100101";
    targ_addr_ctrl_38 <= ("10000000" & hip_base_addr) + "0000000000100110";
    targ_addr_ctrl_39 <= ("10000000" & hip_base_addr) + "0000000000100111";
    targ_addr_ctrl_40 <= ("10000000" & hip_base_addr) + "0000000000101000";
    targ_addr_ctrl_41 <= ("10000000" & hip_base_addr) + "0000000000101001";
    targ_addr_ctrl_42 <= ("10000000" & hip_base_addr) + "0000000000101010";
    targ_addr_ctrl_43 <= ("10000000" & hip_base_addr) + "0000000000101011";
    targ_addr_ctrl_44 <= ("10000000" & hip_base_addr) + "0000000000101100";
    targ_addr_ctrl_45 <= ("10000000" & hip_base_addr) + "0000000000101101";
    targ_addr_ctrl_46 <= ("10000000" & hip_base_addr) + "0000000000101110";
    targ_addr_ctrl_47 <= ("10000000" & hip_base_addr) + "0000000000101111";
    targ_addr_ctrl_48 <= ("10000000" & hip_base_addr) + "0000000000110000";
    targ_addr_ctrl_49 <= ("10000000" & hip_base_addr) + "0000000000110001";
    targ_addr_ctrl_50 <= ("10000000" & hip_base_addr) + "0000000000110010";
    targ_addr_ctrl_51 <= ("10000000" & hip_base_addr) + "0000000000110011";
    targ_addr_ctrl_52 <= ("10000000" & hip_base_addr) + "0000000000110100";
    targ_addr_ctrl_53 <= ("10000000" & hip_base_addr) + "0000000000110101";
    targ_addr_ctrl_54 <= ("10000000" & hip_base_addr) + "0000000000110110";
    targ_addr_ctrl_55 <= ("10000000" & hip_base_addr) + "0000000000110111";
    targ_addr_ctrl_56 <= ("10000000" & hip_base_addr) + "0000000000111000";
    targ_addr_ctrl_57 <= ("10000000" & hip_base_addr) + "0000000000111001";
    targ_addr_ctrl_58 <= ("10000000" & hip_base_addr) + "0000000000111010";
    targ_addr_ctrl_59 <= ("10000000" & hip_base_addr) + "0000000000111011";
    targ_addr_ctrl_60 <= ("10000000" & hip_base_addr) + "0000000000111100";
    targ_addr_ctrl_61 <= ("10000000" & hip_base_addr) + "0000000000111101";
    targ_addr_ctrl_62 <= ("10000000" & hip_base_addr) + "0000000000111110";
    targ_addr_ctrl_63 <= ("10000000" & hip_base_addr) + "0000000000111111";
    targ_addr_ctrl_64 <= ("10000000" & hip_base_addr) + "0000000001000000";
    targ_addr_ctrl_65 <= ("10000000" & hip_base_addr) + "0000000001000001";
    targ_addr_ctrl_66 <= ("10000000" & hip_base_addr) + "0000000001000010";
    targ_addr_ctrl_67 <= ("10000000" & hip_base_addr) + "0000000001000011";
    targ_addr_ctrl_68 <= ("10000000" & hip_base_addr) + "0000000001000100";
    targ_addr_ctrl_69 <= ("10000000" & hip_base_addr) + "0000000001000101";
    targ_addr_ctrl_70 <= ("10000000" & hip_base_addr) + "0000000001000110";
    targ_addr_ctrl_71 <= ("10000000" & hip_base_addr) + "0000000001000111";
    targ_addr_ctrl_72 <= ("10000000" & hip_base_addr) + "0000000001001000";
    targ_addr_ctrl_73 <= ("10000000" & hip_base_addr) + "0000000001001001";
    targ_addr_ctrl_74 <= ("10000000" & hip_base_addr) + "0000000001001010";
    targ_addr_ctrl_75 <= ("10000000" & hip_base_addr) + "0000000001001011";
    targ_addr_ctrl_76 <= ("10000000" & hip_base_addr) + "0000000001001100";
    targ_addr_ctrl_77 <= ("10000000" & hip_base_addr) + "0000000001001101";
    targ_addr_ctrl_78 <= ("10000000" & hip_base_addr) + "0000000001001110";
    targ_addr_ctrl_79 <= ("10000000" & hip_base_addr) + "0000000001001111";
    targ_addr_ctrl_80 <= ("10000000" & hip_base_addr) + "0000000001010000";
    targ_addr_ctrl_81 <= ("10000000" & hip_base_addr) + "0000000001010001";
    targ_addr_ctrl_82 <= ("10000000" & hip_base_addr) + "0000000001010010";
    targ_addr_ctrl_83 <= ("10000000" & hip_base_addr) + "0000000001010011";
    targ_addr_ctrl_84 <= ("10000000" & hip_base_addr) + "0000000001010100";
    targ_addr_ctrl_85 <= ("10000000" & hip_base_addr) + "0000000001010101";
    targ_addr_ctrl_86 <= ("10000000" & hip_base_addr) + "0000000001010110";
    targ_addr_ctrl_87 <= ("10000000" & hip_base_addr) + "0000000001010111";
    targ_addr_ctrl_88 <= ("10000000" & hip_base_addr) + "0000000001011000";
    targ_addr_ctrl_89 <= ("10000000" & hip_base_addr) + "0000000001011001";
    targ_addr_ctrl_90 <= ("10000000" & hip_base_addr) + "0000000001011010";
    targ_addr_ctrl_91 <= ("10000000" & hip_base_addr) + "0000000001011011";
    targ_addr_ctrl_92 <= ("10000000" & hip_base_addr) + "0000000001011100";
    targ_addr_ctrl_93 <= ("10000000" & hip_base_addr) + "0000000001011101";
    targ_addr_ctrl_94 <= ("10000000" & hip_base_addr) + "0000000001011110";
    targ_addr_ctrl_95 <= ("10000000" & hip_base_addr) + "0000000001011111";
    targ_addr_ctrl_96 <= ("10000000" & hip_base_addr) + "0000000001100000";
    targ_addr_ctrl_97 <= ("10000000" & hip_base_addr) + "0000000001100001";
    targ_addr_ctrl_98 <= ("10000000" & hip_base_addr) + "0000000001100010";
    targ_addr_ctrl_99 <= ("10000000" & hip_base_addr) + "0000000001100011";
    targ_addr_ctrl_100 <= ("10000000" & hip_base_addr) + "0000000001100100";
    targ_addr_ctrl_101 <= ("10000000" & hip_base_addr) + "0000000001100101";
    targ_addr_ctrl_102 <= ("10000000" & hip_base_addr) + "0000000001100110";
    targ_addr_ctrl_103 <= ("10000000" & hip_base_addr) + "0000000001100111";
    targ_addr_ctrl_104 <= ("10000000" & hip_base_addr) + "0000000001101000";
    targ_addr_ctrl_105 <= ("10000000" & hip_base_addr) + "0000000001101001";
    targ_addr_ctrl_106 <= ("10000000" & hip_base_addr) + "0000000001101010";
    targ_addr_ctrl_107 <= ("10000000" & hip_base_addr) + "0000000001101011";
    targ_addr_ctrl_108 <= ("10000000" & hip_base_addr) + "0000000001101100";
    targ_addr_ctrl_109 <= ("10000000" & hip_base_addr) + "0000000001101101";
    targ_addr_ctrl_110 <= ("10000000" & hip_base_addr) + "0000000001101110";
    
    -- CRAM output assignment
    
    -- DPRIO registers
    
    
    dprio_reg_1 : stratixiv_pciehip_dprio_reg
        PORT MAP (
            mdio_rst            => mdio_rst,
            mdio_wr             => mdio_wr,
            reg_addr            => reg_addr,
            mdc                 => mdc,
            mbus_in             => mbus_in,
            serial_mode         => serial_mode,
            mdio_dis            => mdio_dis,
            ser_shift_load      => ser_shift_load,
            si                  => si,
            -- CSR input
            ext_hip_ctrl_1      => csr_hip_in(15 DOWNTO 0),
            ext_hip_ctrl_2      => csr_hip_in(31 DOWNTO 16),
            ext_hip_ctrl_3      => csr_hip_in(47 DOWNTO 32),
            ext_hip_ctrl_4      => csr_hip_in(63 DOWNTO 48),
            ext_hip_ctrl_5      => csr_hip_in(79 DOWNTO 64),
            ext_hip_ctrl_6      => csr_hip_in(95 DOWNTO 80),
            ext_hip_ctrl_7      => csr_hip_in(111 DOWNTO 96),
            ext_hip_ctrl_8      => csr_hip_in(127 DOWNTO 112),
            ext_hip_ctrl_9      => csr_hip_in(143 DOWNTO 128),
            ext_hip_ctrl_10     => csr_hip_in(159 DOWNTO 144),
            ext_hip_ctrl_11     => csr_hip_in(175 DOWNTO 160),
            ext_hip_ctrl_12     => csr_hip_in(191 DOWNTO 176),
            ext_hip_ctrl_13     => csr_hip_in(207 DOWNTO 192),
            ext_hip_ctrl_14     => csr_hip_in(223 DOWNTO 208),
            ext_hip_ctrl_15     => csr_hip_in(239 DOWNTO 224),
            ext_hip_ctrl_16     => csr_hip_in(255 DOWNTO 240),
            ext_hip_ctrl_17     => csr_hip_in(271 DOWNTO 256),
            ext_hip_ctrl_18     => csr_hip_in(287 DOWNTO 272),
            ext_hip_ctrl_19     => csr_hip_in(303 DOWNTO 288),
            ext_hip_ctrl_20     => csr_hip_in(319 DOWNTO 304),
            ext_hip_ctrl_21     => csr_hip_in(335 DOWNTO 320),
            ext_hip_ctrl_22     => csr_hip_in(351 DOWNTO 336),
            ext_hip_ctrl_23     => csr_hip_in(367 DOWNTO 352),
            ext_hip_ctrl_24     => csr_hip_in(383 DOWNTO 368),
            ext_hip_ctrl_25     => csr_hip_in(399 DOWNTO 384),
            ext_hip_ctrl_26     => csr_hip_in(415 DOWNTO 400),
            ext_hip_ctrl_27     => csr_hip_in(431 DOWNTO 416),
            ext_hip_ctrl_28     => csr_hip_in(447 DOWNTO 432),
            ext_hip_ctrl_29     => csr_hip_in(463 DOWNTO 448),
            ext_hip_ctrl_30     => csr_hip_in(479 DOWNTO 464),
            ext_hip_ctrl_31     => csr_hip_in(495 DOWNTO 480),
            ext_hip_ctrl_32     => csr_hip_in(511 DOWNTO 496),
            ext_hip_ctrl_33     => csr_hip_in(527 DOWNTO 512),
            ext_hip_ctrl_34     => csr_hip_in(543 DOWNTO 528),
            ext_hip_ctrl_35     => csr_hip_in(559 DOWNTO 544),
            ext_hip_ctrl_36     => csr_hip_in(575 DOWNTO 560),
            ext_hip_ctrl_37     => csr_hip_in(591 DOWNTO 576),
            ext_hip_ctrl_38     => csr_hip_in(607 DOWNTO 592),
            ext_hip_ctrl_39     => csr_hip_in(623 DOWNTO 608),
            ext_hip_ctrl_40     => csr_hip_in(639 DOWNTO 624),
            ext_hip_ctrl_41     => csr_hip_in(655 DOWNTO 640),
            ext_hip_ctrl_42     => csr_hip_in(671 DOWNTO 656),
            ext_hip_ctrl_43     => csr_hip_in(687 DOWNTO 672),
            ext_hip_ctrl_44     => csr_hip_in(703 DOWNTO 688),
            ext_hip_ctrl_45     => csr_hip_in(719 DOWNTO 704),
            ext_hip_ctrl_46     => csr_hip_in(735 DOWNTO 720),
            ext_hip_ctrl_47     => csr_hip_in(751 DOWNTO 736),
            ext_hip_ctrl_48     => csr_hip_in(767 DOWNTO 752),
            ext_hip_ctrl_49     => csr_hip_in(783 DOWNTO 768),
            ext_hip_ctrl_50     => csr_hip_in(799 DOWNTO 784),
            ext_hip_ctrl_51     => csr_hip_in(815 DOWNTO 800),
            ext_hip_ctrl_52     => csr_hip_in(831 DOWNTO 816),
            ext_hip_ctrl_53     => csr_hip_in(847 DOWNTO 832),
            ext_hip_ctrl_54     => csr_hip_in(863 DOWNTO 848),
            ext_hip_ctrl_55     => csr_hip_in(879 DOWNTO 864),
            ext_hip_ctrl_56     => csr_hip_in(895 DOWNTO 880),
            ext_hip_ctrl_57     => csr_hip_in(911 DOWNTO 896),
            ext_hip_ctrl_58     => csr_hip_in(927 DOWNTO 912),
            ext_hip_ctrl_59     => csr_hip_in(943 DOWNTO 928),
            ext_hip_ctrl_60     => csr_hip_in(959 DOWNTO 944),
            ext_hip_ctrl_61     => csr_hip_in(975 DOWNTO 960),
            ext_hip_ctrl_62     => csr_hip_in(991 DOWNTO 976),
            ext_hip_ctrl_63     => csr_hip_in(1007 DOWNTO 992),
            ext_hip_ctrl_64     => csr_hip_in(1023 DOWNTO 1008),
            ext_hip_ctrl_65     => csr_hip_in(1039 DOWNTO 1024),
            ext_hip_ctrl_66     => csr_hip_in(1055 DOWNTO 1040),
            ext_hip_ctrl_67     => csr_hip_in(1071 DOWNTO 1056),
            ext_hip_ctrl_68     => csr_hip_in(1087 DOWNTO 1072),
            ext_hip_ctrl_69     => csr_hip_in(1103 DOWNTO 1088),
            ext_hip_ctrl_70     => csr_hip_in(1119 DOWNTO 1104),
            ext_hip_ctrl_71     => csr_hip_in(1135 DOWNTO 1120),
            ext_hip_ctrl_72     => csr_hip_in(1151 DOWNTO 1136),
            ext_hip_ctrl_73     => csr_hip_in(1167 DOWNTO 1152),
            ext_hip_ctrl_74     => csr_hip_in(1183 DOWNTO 1168),
            ext_hip_ctrl_75     => csr_hip_in(1199 DOWNTO 1184),
            ext_hip_ctrl_76     => csr_hip_in(1215 DOWNTO 1200),
            ext_hip_ctrl_77     => csr_hip_in(1231 DOWNTO 1216),
            ext_hip_ctrl_78     => csr_hip_in(1247 DOWNTO 1232),
            ext_hip_ctrl_79     => csr_hip_in(1263 DOWNTO 1248),
            ext_hip_ctrl_80     => csr_hip_in(1279 DOWNTO 1264),
            ext_hip_ctrl_81     => csr_hip_in(1295 DOWNTO 1280),
            ext_hip_ctrl_82     => csr_hip_in(1311 DOWNTO 1296),
            ext_hip_ctrl_83     => csr_hip_in(1327 DOWNTO 1312),
            ext_hip_ctrl_84     => csr_hip_in(1343 DOWNTO 1328),
            ext_hip_ctrl_85     => csr_hip_in(1359 DOWNTO 1344),
            ext_hip_ctrl_86     => csr_hip_in(1375 DOWNTO 1360),
            ext_hip_ctrl_87     => csr_hip_in(1391 DOWNTO 1376),
            ext_hip_ctrl_88     => csr_hip_in(1407 DOWNTO 1392),
            ext_hip_ctrl_89     => csr_hip_in(1423 DOWNTO 1408),
            ext_hip_ctrl_90     => csr_hip_in(1439 DOWNTO 1424),
            ext_hip_ctrl_91     => csr_hip_in(1455 DOWNTO 1440),
            ext_hip_ctrl_92     => csr_hip_in(1471 DOWNTO 1456),
            ext_hip_ctrl_93     => csr_hip_in(1487 DOWNTO 1472),
            ext_hip_ctrl_94     => csr_hip_in(1503 DOWNTO 1488),
            ext_hip_ctrl_95     => csr_hip_in(1519 DOWNTO 1504),
            ext_hip_ctrl_96     => csr_hip_in(1535 DOWNTO 1520),
            ext_hip_ctrl_97     => csr_hip_in(1551 DOWNTO 1536),
            ext_hip_ctrl_98     => csr_hip_in(1567 DOWNTO 1552),
            ext_hip_ctrl_99     => csr_hip_in(1583 DOWNTO 1568),
            ext_hip_ctrl_100    => csr_hip_in(1599 DOWNTO 1584),
            ext_hip_ctrl_101    => csr_hip_in(1615 DOWNTO 1600),
            ext_hip_ctrl_102    => csr_hip_in(1631 DOWNTO 1616),
            ext_hip_ctrl_103    => csr_hip_in(1647 DOWNTO 1632),
            ext_hip_ctrl_104    => csr_hip_in(1663 DOWNTO 1648),
            ext_hip_ctrl_105    => csr_hip_in(1679 DOWNTO 1664),
            ext_hip_ctrl_106    => csr_hip_in(1695 DOWNTO 1680),
            ext_hip_ctrl_107    => csr_hip_in(1711 DOWNTO 1696),
            ext_hip_ctrl_108    => csr_hip_in(1727 DOWNTO 1712),
            ext_hip_ctrl_109    => csr_hip_in(1743 DOWNTO 1728),
            ext_hip_ctrl_110    => csr_hip_in(1759 DOWNTO 1744),
            targ_addr_ctrl_1    => targ_addr_ctrl_1,
            targ_addr_ctrl_2    => targ_addr_ctrl_2,
            targ_addr_ctrl_3    => targ_addr_ctrl_3,
            targ_addr_ctrl_4    => targ_addr_ctrl_4,
            targ_addr_ctrl_5    => targ_addr_ctrl_5,
            targ_addr_ctrl_6    => targ_addr_ctrl_6,
            targ_addr_ctrl_7    => targ_addr_ctrl_7,
            targ_addr_ctrl_8    => targ_addr_ctrl_8,
            targ_addr_ctrl_9    => targ_addr_ctrl_9,
            targ_addr_ctrl_10   => targ_addr_ctrl_10,
            targ_addr_ctrl_11   => targ_addr_ctrl_11,
            targ_addr_ctrl_12   => targ_addr_ctrl_12,
            targ_addr_ctrl_13   => targ_addr_ctrl_13,
            targ_addr_ctrl_14   => targ_addr_ctrl_14,
            targ_addr_ctrl_15   => targ_addr_ctrl_15,
            targ_addr_ctrl_16   => targ_addr_ctrl_16,
            targ_addr_ctrl_17   => targ_addr_ctrl_17,
            targ_addr_ctrl_18   => targ_addr_ctrl_18,
            targ_addr_ctrl_19   => targ_addr_ctrl_19,
            targ_addr_ctrl_20   => targ_addr_ctrl_20,
            targ_addr_ctrl_21   => targ_addr_ctrl_21,
            targ_addr_ctrl_22   => targ_addr_ctrl_22,
            targ_addr_ctrl_23   => targ_addr_ctrl_23,
            targ_addr_ctrl_24   => targ_addr_ctrl_24,
            targ_addr_ctrl_25   => targ_addr_ctrl_25,
            targ_addr_ctrl_26   => targ_addr_ctrl_26,
            targ_addr_ctrl_27   => targ_addr_ctrl_27,
            targ_addr_ctrl_28   => targ_addr_ctrl_28,
            targ_addr_ctrl_29   => targ_addr_ctrl_29,
            targ_addr_ctrl_30   => targ_addr_ctrl_30,
            targ_addr_ctrl_31   => targ_addr_ctrl_31,
            targ_addr_ctrl_32   => targ_addr_ctrl_32,
            targ_addr_ctrl_33   => targ_addr_ctrl_33,
            targ_addr_ctrl_34   => targ_addr_ctrl_34,
            targ_addr_ctrl_35   => targ_addr_ctrl_35,
            targ_addr_ctrl_36   => targ_addr_ctrl_36,
            targ_addr_ctrl_37   => targ_addr_ctrl_37,
            targ_addr_ctrl_38   => targ_addr_ctrl_38,
            targ_addr_ctrl_39   => targ_addr_ctrl_39,
            targ_addr_ctrl_40   => targ_addr_ctrl_40,
            targ_addr_ctrl_41   => targ_addr_ctrl_41,
            targ_addr_ctrl_42   => targ_addr_ctrl_42,
            targ_addr_ctrl_43   => targ_addr_ctrl_43,
            targ_addr_ctrl_44   => targ_addr_ctrl_44,
            targ_addr_ctrl_45   => targ_addr_ctrl_45,
            targ_addr_ctrl_46   => targ_addr_ctrl_46,
            targ_addr_ctrl_47   => targ_addr_ctrl_47,
            targ_addr_ctrl_48   => targ_addr_ctrl_48,
            targ_addr_ctrl_49   => targ_addr_ctrl_49,
            targ_addr_ctrl_50   => targ_addr_ctrl_50,
            targ_addr_ctrl_51   => targ_addr_ctrl_51,
            targ_addr_ctrl_52   => targ_addr_ctrl_52,
            targ_addr_ctrl_53   => targ_addr_ctrl_53,
            targ_addr_ctrl_54   => targ_addr_ctrl_54,
            targ_addr_ctrl_55   => targ_addr_ctrl_55,
            targ_addr_ctrl_56   => targ_addr_ctrl_56,
            targ_addr_ctrl_57   => targ_addr_ctrl_57,
            targ_addr_ctrl_58   => targ_addr_ctrl_58,
            targ_addr_ctrl_59   => targ_addr_ctrl_59,
            targ_addr_ctrl_60   => targ_addr_ctrl_60,
            targ_addr_ctrl_61   => targ_addr_ctrl_61,
            targ_addr_ctrl_62   => targ_addr_ctrl_62,
            targ_addr_ctrl_63   => targ_addr_ctrl_63,
            targ_addr_ctrl_64   => targ_addr_ctrl_64,
            targ_addr_ctrl_65   => targ_addr_ctrl_65,
            targ_addr_ctrl_66   => targ_addr_ctrl_66,
            targ_addr_ctrl_67   => targ_addr_ctrl_67,
            targ_addr_ctrl_68   => targ_addr_ctrl_68,
            targ_addr_ctrl_69   => targ_addr_ctrl_69,
            targ_addr_ctrl_70   => targ_addr_ctrl_70,
            targ_addr_ctrl_71   => targ_addr_ctrl_71,
            targ_addr_ctrl_72   => targ_addr_ctrl_72,
            targ_addr_ctrl_73   => targ_addr_ctrl_73,
            targ_addr_ctrl_74   => targ_addr_ctrl_74,
            targ_addr_ctrl_75   => targ_addr_ctrl_75,
            targ_addr_ctrl_76   => targ_addr_ctrl_76,
            targ_addr_ctrl_77   => targ_addr_ctrl_77,
            targ_addr_ctrl_78   => targ_addr_ctrl_78,
            targ_addr_ctrl_79   => targ_addr_ctrl_79,
            targ_addr_ctrl_80   => targ_addr_ctrl_80,
            targ_addr_ctrl_81   => targ_addr_ctrl_81,
            targ_addr_ctrl_82   => targ_addr_ctrl_82,
            targ_addr_ctrl_83   => targ_addr_ctrl_83,
            targ_addr_ctrl_84   => targ_addr_ctrl_84,
            targ_addr_ctrl_85   => targ_addr_ctrl_85,
            targ_addr_ctrl_86   => targ_addr_ctrl_86,
            targ_addr_ctrl_87   => targ_addr_ctrl_87,
            targ_addr_ctrl_88   => targ_addr_ctrl_88,
            targ_addr_ctrl_89   => targ_addr_ctrl_89,
            targ_addr_ctrl_90   => targ_addr_ctrl_90,
            targ_addr_ctrl_91   => targ_addr_ctrl_91,
            targ_addr_ctrl_92   => targ_addr_ctrl_92,
            targ_addr_ctrl_93   => targ_addr_ctrl_93,
            targ_addr_ctrl_94   => targ_addr_ctrl_94,
            targ_addr_ctrl_95   => targ_addr_ctrl_95,
            targ_addr_ctrl_96   => targ_addr_ctrl_96,
            targ_addr_ctrl_97   => targ_addr_ctrl_97,
            targ_addr_ctrl_98   => targ_addr_ctrl_98,
            targ_addr_ctrl_99   => targ_addr_ctrl_99,
            targ_addr_ctrl_100  => targ_addr_ctrl_100,
            targ_addr_ctrl_101  => targ_addr_ctrl_101,
            targ_addr_ctrl_102  => targ_addr_ctrl_102,
            targ_addr_ctrl_103  => targ_addr_ctrl_103,
            targ_addr_ctrl_104  => targ_addr_ctrl_104,
            targ_addr_ctrl_105  => targ_addr_ctrl_105,
            targ_addr_ctrl_106  => targ_addr_ctrl_106,
            targ_addr_ctrl_107  => targ_addr_ctrl_107,
            targ_addr_ctrl_108  => targ_addr_ctrl_108,
            targ_addr_ctrl_109  => targ_addr_ctrl_109,
            targ_addr_ctrl_110  => targ_addr_ctrl_110,
            -- DPRIO register output
            out_hip_ctrl_1      => out_hip_ctrl_1_xhdl1,
            out_hip_ctrl_2      => out_hip_ctrl_2_xhdl23,
            out_hip_ctrl_3      => out_hip_ctrl_3_xhdl34,
            out_hip_ctrl_4      => out_hip_ctrl_4_xhdl45,
            out_hip_ctrl_5      => out_hip_ctrl_5_xhdl56,
            out_hip_ctrl_6      => out_hip_ctrl_6_xhdl67,
            out_hip_ctrl_7      => out_hip_ctrl_7_xhdl78,
            out_hip_ctrl_8      => out_hip_ctrl_8_xhdl89,
            out_hip_ctrl_9      => out_hip_ctrl_9_xhdl100,
            out_hip_ctrl_10     => out_hip_ctrl_10_xhdl2,
            out_hip_ctrl_11     => out_hip_ctrl_11_xhdl13,
            out_hip_ctrl_12     => out_hip_ctrl_12_xhdl15,
            out_hip_ctrl_13     => out_hip_ctrl_13_xhdl16,
            out_hip_ctrl_14     => out_hip_ctrl_14_xhdl17,
            out_hip_ctrl_15     => out_hip_ctrl_15_xhdl18,
            out_hip_ctrl_16     => out_hip_ctrl_16_xhdl19,
            out_hip_ctrl_17     => out_hip_ctrl_17_xhdl20,
            out_hip_ctrl_18     => out_hip_ctrl_18_xhdl21,
            out_hip_ctrl_19     => out_hip_ctrl_19_xhdl22,
            out_hip_ctrl_20     => out_hip_ctrl_20_xhdl24,
            out_hip_ctrl_21     => out_hip_ctrl_21_xhdl25,
            out_hip_ctrl_22     => out_hip_ctrl_22_xhdl26,
            out_hip_ctrl_23     => out_hip_ctrl_23_xhdl27,
            out_hip_ctrl_24     => out_hip_ctrl_24_xhdl28,
            out_hip_ctrl_25     => out_hip_ctrl_25_xhdl29,
            out_hip_ctrl_26     => out_hip_ctrl_26_xhdl30,
            out_hip_ctrl_27     => out_hip_ctrl_27_xhdl31,
            out_hip_ctrl_28     => out_hip_ctrl_28_xhdl32,
            out_hip_ctrl_29     => out_hip_ctrl_29_xhdl33,
            out_hip_ctrl_30     => out_hip_ctrl_30_xhdl35,
            out_hip_ctrl_31     => out_hip_ctrl_31_xhdl36,
            out_hip_ctrl_32     => out_hip_ctrl_32_xhdl37,
            out_hip_ctrl_33     => out_hip_ctrl_33_xhdl38,
            out_hip_ctrl_34     => out_hip_ctrl_34_xhdl39,
            out_hip_ctrl_35     => out_hip_ctrl_35_xhdl40,
            out_hip_ctrl_36     => out_hip_ctrl_36_xhdl41,
            out_hip_ctrl_37     => out_hip_ctrl_37_xhdl42,
            out_hip_ctrl_38     => out_hip_ctrl_38_xhdl43,
            out_hip_ctrl_39     => out_hip_ctrl_39_xhdl44,
            out_hip_ctrl_40     => out_hip_ctrl_40_xhdl46,
            out_hip_ctrl_41     => out_hip_ctrl_41_xhdl47,
            out_hip_ctrl_42     => out_hip_ctrl_42_xhdl48,
            out_hip_ctrl_43     => out_hip_ctrl_43_xhdl49,
            out_hip_ctrl_44     => out_hip_ctrl_44_xhdl50,
            out_hip_ctrl_45     => out_hip_ctrl_45_xhdl51,
            out_hip_ctrl_46     => out_hip_ctrl_46_xhdl52,
            out_hip_ctrl_47     => out_hip_ctrl_47_xhdl53,
            out_hip_ctrl_48     => out_hip_ctrl_48_xhdl54,
            out_hip_ctrl_49     => out_hip_ctrl_49_xhdl55,
            out_hip_ctrl_50     => out_hip_ctrl_50_xhdl57,
            out_hip_ctrl_51     => out_hip_ctrl_51_xhdl58,
            out_hip_ctrl_52     => out_hip_ctrl_52_xhdl59,
            out_hip_ctrl_53     => out_hip_ctrl_53_xhdl60,
            out_hip_ctrl_54     => out_hip_ctrl_54_xhdl61,
            out_hip_ctrl_55     => out_hip_ctrl_55_xhdl62,
            out_hip_ctrl_56     => out_hip_ctrl_56_xhdl63,
            out_hip_ctrl_57     => out_hip_ctrl_57_xhdl64,
            out_hip_ctrl_58     => out_hip_ctrl_58_xhdl65,
            out_hip_ctrl_59     => out_hip_ctrl_59_xhdl66,
            out_hip_ctrl_60     => out_hip_ctrl_60_xhdl68,
            out_hip_ctrl_61     => out_hip_ctrl_61_xhdl69,
            out_hip_ctrl_62     => out_hip_ctrl_62_xhdl70,
            out_hip_ctrl_63     => out_hip_ctrl_63_xhdl71,
            out_hip_ctrl_64     => out_hip_ctrl_64_xhdl72,
            out_hip_ctrl_65     => out_hip_ctrl_65_xhdl73,
            out_hip_ctrl_66     => out_hip_ctrl_66_xhdl74,
            out_hip_ctrl_67     => out_hip_ctrl_67_xhdl75,
            out_hip_ctrl_68     => out_hip_ctrl_68_xhdl76,
            out_hip_ctrl_69     => out_hip_ctrl_69_xhdl77,
            out_hip_ctrl_70     => out_hip_ctrl_70_xhdl79,
            out_hip_ctrl_71     => out_hip_ctrl_71_xhdl80,
            out_hip_ctrl_72     => out_hip_ctrl_72_xhdl81,
            out_hip_ctrl_73     => out_hip_ctrl_73_xhdl82,
            out_hip_ctrl_74     => out_hip_ctrl_74_xhdl83,
            out_hip_ctrl_75     => out_hip_ctrl_75_xhdl84,
            out_hip_ctrl_76     => out_hip_ctrl_76_xhdl85,
            out_hip_ctrl_77     => out_hip_ctrl_77_xhdl86,
            out_hip_ctrl_78     => out_hip_ctrl_78_xhdl87,
            out_hip_ctrl_79     => out_hip_ctrl_79_xhdl88,
            out_hip_ctrl_80     => out_hip_ctrl_80_xhdl90,
            out_hip_ctrl_81     => out_hip_ctrl_81_xhdl91,
            out_hip_ctrl_82     => out_hip_ctrl_82_xhdl92,
            out_hip_ctrl_83     => out_hip_ctrl_83_xhdl93,
            out_hip_ctrl_84     => out_hip_ctrl_84_xhdl94,
            out_hip_ctrl_85     => out_hip_ctrl_85_xhdl95,
            out_hip_ctrl_86     => out_hip_ctrl_86_xhdl96,
            out_hip_ctrl_87     => out_hip_ctrl_87_xhdl97,
            out_hip_ctrl_88     => out_hip_ctrl_88_xhdl98,
            out_hip_ctrl_89     => out_hip_ctrl_89_xhdl99,
            out_hip_ctrl_90     => out_hip_ctrl_90_xhdl101,
            out_hip_ctrl_91     => out_hip_ctrl_91_xhdl102,
            out_hip_ctrl_92     => out_hip_ctrl_92_xhdl103,
            out_hip_ctrl_93     => out_hip_ctrl_93_xhdl104,
            out_hip_ctrl_94     => out_hip_ctrl_94_xhdl105,
            out_hip_ctrl_95     => out_hip_ctrl_95_xhdl106,
            out_hip_ctrl_96     => out_hip_ctrl_96_xhdl107,
            out_hip_ctrl_97     => out_hip_ctrl_97_xhdl108,
            out_hip_ctrl_98     => out_hip_ctrl_98_xhdl109,
            out_hip_ctrl_99     => out_hip_ctrl_99_xhdl110,
            out_hip_ctrl_100    => out_hip_ctrl_100_xhdl3,
            out_hip_ctrl_101    => out_hip_ctrl_101_xhdl4,
            out_hip_ctrl_102    => out_hip_ctrl_102_xhdl5,
            out_hip_ctrl_103    => out_hip_ctrl_103_xhdl6,
            out_hip_ctrl_104    => out_hip_ctrl_104_xhdl7,
            out_hip_ctrl_105    => out_hip_ctrl_105_xhdl8,
            out_hip_ctrl_106    => out_hip_ctrl_106_xhdl9,
            out_hip_ctrl_107    => out_hip_ctrl_107_xhdl10,
            out_hip_ctrl_108    => out_hip_ctrl_108_xhdl11,
            out_hip_ctrl_109    => out_hip_ctrl_109_xhdl12,
            out_hip_ctrl_110    => out_hip_ctrl_110_xhdl14,
            so                  => so_xhdl111
        );
    
    -- MBUS_OUT muxing for central channel
    
    
    mbus_mux : stratixiv_pciehip_dprio_bus_out_mux
        PORT MAP (
            hip_ctrl_in1           => out_hip_ctrl_1_xhdl1,
            hip_ctrl_in2           => out_hip_ctrl_2_xhdl23,
            hip_ctrl_in3           => out_hip_ctrl_3_xhdl34,
            hip_ctrl_in4           => out_hip_ctrl_4_xhdl45,
            hip_ctrl_in5           => out_hip_ctrl_5_xhdl56,
            hip_ctrl_in6           => out_hip_ctrl_6_xhdl67,
            hip_ctrl_in7           => out_hip_ctrl_7_xhdl78,
            hip_ctrl_in8           => out_hip_ctrl_8_xhdl89,
            hip_ctrl_in9           => out_hip_ctrl_9_xhdl100,
            hip_ctrl_in10          => out_hip_ctrl_10_xhdl2,
            hip_ctrl_in11          => out_hip_ctrl_11_xhdl13,
            hip_ctrl_in12          => out_hip_ctrl_12_xhdl15,
            hip_ctrl_in13          => out_hip_ctrl_13_xhdl16,
            hip_ctrl_in14          => out_hip_ctrl_14_xhdl17,
            hip_ctrl_in15          => out_hip_ctrl_15_xhdl18,
            hip_ctrl_in16          => out_hip_ctrl_16_xhdl19,
            hip_ctrl_in17          => out_hip_ctrl_17_xhdl20,
            hip_ctrl_in18          => out_hip_ctrl_18_xhdl21,
            hip_ctrl_in19          => out_hip_ctrl_19_xhdl22,
            hip_ctrl_in20          => out_hip_ctrl_20_xhdl24,
            hip_ctrl_in21          => out_hip_ctrl_21_xhdl25,
            hip_ctrl_in22          => out_hip_ctrl_22_xhdl26,
            hip_ctrl_in23          => out_hip_ctrl_23_xhdl27,
            hip_ctrl_in24          => out_hip_ctrl_24_xhdl28,
            hip_ctrl_in25          => out_hip_ctrl_25_xhdl29,
            hip_ctrl_in26          => out_hip_ctrl_26_xhdl30,
            hip_ctrl_in27          => out_hip_ctrl_27_xhdl31,
            hip_ctrl_in28          => out_hip_ctrl_28_xhdl32,
            hip_ctrl_in29          => out_hip_ctrl_29_xhdl33,
            hip_ctrl_in30          => out_hip_ctrl_30_xhdl35,
            hip_ctrl_in31          => out_hip_ctrl_31_xhdl36,
            hip_ctrl_in32          => out_hip_ctrl_32_xhdl37,
            hip_ctrl_in33          => out_hip_ctrl_33_xhdl38,
            hip_ctrl_in34          => out_hip_ctrl_34_xhdl39,
            hip_ctrl_in35          => out_hip_ctrl_35_xhdl40,
            hip_ctrl_in36          => out_hip_ctrl_36_xhdl41,
            hip_ctrl_in37          => out_hip_ctrl_37_xhdl42,
            hip_ctrl_in38          => out_hip_ctrl_38_xhdl43,
            hip_ctrl_in39          => out_hip_ctrl_39_xhdl44,
            hip_ctrl_in40          => out_hip_ctrl_40_xhdl46,
            hip_ctrl_in41          => out_hip_ctrl_41_xhdl47,
            hip_ctrl_in42          => out_hip_ctrl_42_xhdl48,
            hip_ctrl_in43          => out_hip_ctrl_43_xhdl49,
            hip_ctrl_in44          => out_hip_ctrl_44_xhdl50,
            hip_ctrl_in45          => out_hip_ctrl_45_xhdl51,
            hip_ctrl_in46          => out_hip_ctrl_46_xhdl52,
            hip_ctrl_in47          => out_hip_ctrl_47_xhdl53,
            hip_ctrl_in48          => out_hip_ctrl_48_xhdl54,
            hip_ctrl_in49          => out_hip_ctrl_49_xhdl55,
            hip_ctrl_in50          => out_hip_ctrl_50_xhdl57,
            hip_ctrl_in51          => out_hip_ctrl_51_xhdl58,
            hip_ctrl_in52          => out_hip_ctrl_52_xhdl59,
            hip_ctrl_in53          => out_hip_ctrl_53_xhdl60,
            hip_ctrl_in54          => out_hip_ctrl_54_xhdl61,
            hip_ctrl_in55          => out_hip_ctrl_55_xhdl62,
            hip_ctrl_in56          => out_hip_ctrl_56_xhdl63,
            hip_ctrl_in57          => out_hip_ctrl_57_xhdl64,
            hip_ctrl_in58          => out_hip_ctrl_58_xhdl65,
            hip_ctrl_in59          => out_hip_ctrl_59_xhdl66,
            hip_ctrl_in60          => out_hip_ctrl_60_xhdl68,
            hip_ctrl_in61          => out_hip_ctrl_61_xhdl69,
            hip_ctrl_in62          => out_hip_ctrl_62_xhdl70,
            hip_ctrl_in63          => out_hip_ctrl_63_xhdl71,
            hip_ctrl_in64          => out_hip_ctrl_64_xhdl72,
            hip_ctrl_in65          => out_hip_ctrl_65_xhdl73,
            hip_ctrl_in66          => out_hip_ctrl_66_xhdl74,
            hip_ctrl_in67          => out_hip_ctrl_67_xhdl75,
            hip_ctrl_in68          => out_hip_ctrl_68_xhdl76,
            hip_ctrl_in69          => out_hip_ctrl_69_xhdl77,
            hip_ctrl_in70          => out_hip_ctrl_70_xhdl79,
            hip_ctrl_in71          => out_hip_ctrl_71_xhdl80,
            hip_ctrl_in72          => out_hip_ctrl_72_xhdl81,
            hip_ctrl_in73          => out_hip_ctrl_73_xhdl82,
            hip_ctrl_in74          => out_hip_ctrl_74_xhdl83,
            hip_ctrl_in75          => out_hip_ctrl_75_xhdl84,
            hip_ctrl_in76          => out_hip_ctrl_76_xhdl85,
            hip_ctrl_in77          => out_hip_ctrl_77_xhdl86,
            hip_ctrl_in78          => out_hip_ctrl_78_xhdl87,
            hip_ctrl_in79          => out_hip_ctrl_79_xhdl88,
            hip_ctrl_in80          => out_hip_ctrl_80_xhdl90,
            hip_ctrl_in81          => out_hip_ctrl_81_xhdl91,
            hip_ctrl_in82          => out_hip_ctrl_82_xhdl92,
            hip_ctrl_in83          => out_hip_ctrl_83_xhdl93,
            hip_ctrl_in84          => out_hip_ctrl_84_xhdl94,
            hip_ctrl_in85          => out_hip_ctrl_85_xhdl95,
            hip_ctrl_in86          => out_hip_ctrl_86_xhdl96,
            hip_ctrl_in87          => out_hip_ctrl_87_xhdl97,
            hip_ctrl_in88          => out_hip_ctrl_88_xhdl98,
            hip_ctrl_in89          => out_hip_ctrl_89_xhdl99,
            hip_ctrl_in90          => out_hip_ctrl_90_xhdl101,
            hip_ctrl_in91          => out_hip_ctrl_91_xhdl102,
            hip_ctrl_in92          => out_hip_ctrl_92_xhdl103,
            hip_ctrl_in93          => out_hip_ctrl_93_xhdl104,
            hip_ctrl_in94          => out_hip_ctrl_94_xhdl105,
            hip_ctrl_in95          => out_hip_ctrl_95_xhdl106,
            hip_ctrl_in96          => out_hip_ctrl_96_xhdl107,
            hip_ctrl_in97          => out_hip_ctrl_97_xhdl108,
            hip_ctrl_in98          => out_hip_ctrl_98_xhdl109,
            hip_ctrl_in99          => out_hip_ctrl_99_xhdl110,
            hip_ctrl_in100         => out_hip_ctrl_100_xhdl3,
            hip_ctrl_in101         => out_hip_ctrl_101_xhdl4,
            hip_ctrl_in102         => out_hip_ctrl_102_xhdl5,
            hip_ctrl_in103         => out_hip_ctrl_103_xhdl6,
            hip_ctrl_in104         => out_hip_ctrl_104_xhdl7,
            hip_ctrl_in105         => out_hip_ctrl_105_xhdl8,
            hip_ctrl_in106         => out_hip_ctrl_106_xhdl9,
            hip_ctrl_in107         => out_hip_ctrl_107_xhdl10,
            hip_ctrl_in108         => out_hip_ctrl_108_xhdl11,
            hip_ctrl_in109         => out_hip_ctrl_109_xhdl12,
            hip_ctrl_in110         => out_hip_ctrl_110_xhdl14,
            hw_address_ctrl_in1    => targ_addr_ctrl_1,
            hw_address_ctrl_in2    => targ_addr_ctrl_2,
            hw_address_ctrl_in3    => targ_addr_ctrl_3,
            hw_address_ctrl_in4    => targ_addr_ctrl_4,
            hw_address_ctrl_in5    => targ_addr_ctrl_5,
            hw_address_ctrl_in6    => targ_addr_ctrl_6,
            hw_address_ctrl_in7    => targ_addr_ctrl_7,
            hw_address_ctrl_in8    => targ_addr_ctrl_8,
            hw_address_ctrl_in9    => targ_addr_ctrl_9,
            hw_address_ctrl_in10   => targ_addr_ctrl_10,
            hw_address_ctrl_in11   => targ_addr_ctrl_11,
            hw_address_ctrl_in12   => targ_addr_ctrl_12,
            hw_address_ctrl_in13   => targ_addr_ctrl_13,
            hw_address_ctrl_in14   => targ_addr_ctrl_14,
            hw_address_ctrl_in15   => targ_addr_ctrl_15,
            hw_address_ctrl_in16   => targ_addr_ctrl_16,
            hw_address_ctrl_in17   => targ_addr_ctrl_17,
            hw_address_ctrl_in18   => targ_addr_ctrl_18,
            hw_address_ctrl_in19   => targ_addr_ctrl_19,
            hw_address_ctrl_in20   => targ_addr_ctrl_20,
            hw_address_ctrl_in21   => targ_addr_ctrl_21,
            hw_address_ctrl_in22   => targ_addr_ctrl_22,
            hw_address_ctrl_in23   => targ_addr_ctrl_23,
            hw_address_ctrl_in24   => targ_addr_ctrl_24,
            hw_address_ctrl_in25   => targ_addr_ctrl_25,
            hw_address_ctrl_in26   => targ_addr_ctrl_26,
            hw_address_ctrl_in27   => targ_addr_ctrl_27,
            hw_address_ctrl_in28   => targ_addr_ctrl_28,
            hw_address_ctrl_in29   => targ_addr_ctrl_29,
            hw_address_ctrl_in30   => targ_addr_ctrl_30,
            hw_address_ctrl_in31   => targ_addr_ctrl_31,
            hw_address_ctrl_in32   => targ_addr_ctrl_32,
            hw_address_ctrl_in33   => targ_addr_ctrl_33,
            hw_address_ctrl_in34   => targ_addr_ctrl_34,
            hw_address_ctrl_in35   => targ_addr_ctrl_35,
            hw_address_ctrl_in36   => targ_addr_ctrl_36,
            hw_address_ctrl_in37   => targ_addr_ctrl_37,
            hw_address_ctrl_in38   => targ_addr_ctrl_38,
            hw_address_ctrl_in39   => targ_addr_ctrl_39,
            hw_address_ctrl_in40   => targ_addr_ctrl_40,
            hw_address_ctrl_in41   => targ_addr_ctrl_41,
            hw_address_ctrl_in42   => targ_addr_ctrl_42,
            hw_address_ctrl_in43   => targ_addr_ctrl_43,
            hw_address_ctrl_in44   => targ_addr_ctrl_44,
            hw_address_ctrl_in45   => targ_addr_ctrl_45,
            hw_address_ctrl_in46   => targ_addr_ctrl_46,
            hw_address_ctrl_in47   => targ_addr_ctrl_47,
            hw_address_ctrl_in48   => targ_addr_ctrl_48,
            hw_address_ctrl_in49   => targ_addr_ctrl_49,
            hw_address_ctrl_in50   => targ_addr_ctrl_50,
            hw_address_ctrl_in51   => targ_addr_ctrl_51,
            hw_address_ctrl_in52   => targ_addr_ctrl_52,
            hw_address_ctrl_in53   => targ_addr_ctrl_53,
            hw_address_ctrl_in54   => targ_addr_ctrl_54,
            hw_address_ctrl_in55   => targ_addr_ctrl_55,
            hw_address_ctrl_in56   => targ_addr_ctrl_56,
            hw_address_ctrl_in57   => targ_addr_ctrl_57,
            hw_address_ctrl_in58   => targ_addr_ctrl_58,
            hw_address_ctrl_in59   => targ_addr_ctrl_59,
            hw_address_ctrl_in60   => targ_addr_ctrl_60,
            hw_address_ctrl_in61   => targ_addr_ctrl_61,
            hw_address_ctrl_in62   => targ_addr_ctrl_62,
            hw_address_ctrl_in63   => targ_addr_ctrl_63,
            hw_address_ctrl_in64   => targ_addr_ctrl_64,
            hw_address_ctrl_in65   => targ_addr_ctrl_65,
            hw_address_ctrl_in66   => targ_addr_ctrl_66,
            hw_address_ctrl_in67   => targ_addr_ctrl_67,
            hw_address_ctrl_in68   => targ_addr_ctrl_68,
            hw_address_ctrl_in69   => targ_addr_ctrl_69,
            hw_address_ctrl_in70   => targ_addr_ctrl_70,
            hw_address_ctrl_in71   => targ_addr_ctrl_71,
            hw_address_ctrl_in72   => targ_addr_ctrl_72,
            hw_address_ctrl_in73   => targ_addr_ctrl_73,
            hw_address_ctrl_in74   => targ_addr_ctrl_74,
            hw_address_ctrl_in75   => targ_addr_ctrl_75,
            hw_address_ctrl_in76   => targ_addr_ctrl_76,
            hw_address_ctrl_in77   => targ_addr_ctrl_77,
            hw_address_ctrl_in78   => targ_addr_ctrl_78,
            hw_address_ctrl_in79   => targ_addr_ctrl_79,
            hw_address_ctrl_in80   => targ_addr_ctrl_80,
            hw_address_ctrl_in81   => targ_addr_ctrl_81,
            hw_address_ctrl_in82   => targ_addr_ctrl_82,
            hw_address_ctrl_in83   => targ_addr_ctrl_83,
            hw_address_ctrl_in84   => targ_addr_ctrl_84,
            hw_address_ctrl_in85   => targ_addr_ctrl_85,
            hw_address_ctrl_in86   => targ_addr_ctrl_86,
            hw_address_ctrl_in87   => targ_addr_ctrl_87,
            hw_address_ctrl_in88   => targ_addr_ctrl_88,
            hw_address_ctrl_in89   => targ_addr_ctrl_89,
            hw_address_ctrl_in90   => targ_addr_ctrl_90,
            hw_address_ctrl_in91   => targ_addr_ctrl_91,
            hw_address_ctrl_in92   => targ_addr_ctrl_92,
            hw_address_ctrl_in93   => targ_addr_ctrl_93,
            hw_address_ctrl_in94   => targ_addr_ctrl_94,
            hw_address_ctrl_in95   => targ_addr_ctrl_95,
            hw_address_ctrl_in96   => targ_addr_ctrl_96,
            hw_address_ctrl_in97   => targ_addr_ctrl_97,
            hw_address_ctrl_in98   => targ_addr_ctrl_98,
            hw_address_ctrl_in99   => targ_addr_ctrl_99,
            hw_address_ctrl_in100  => targ_addr_ctrl_100,
            hw_address_ctrl_in101  => targ_addr_ctrl_101,
            hw_address_ctrl_in102  => targ_addr_ctrl_102,
            hw_address_ctrl_in103  => targ_addr_ctrl_103,
            hw_address_ctrl_in104  => targ_addr_ctrl_104,
            hw_address_ctrl_in105  => targ_addr_ctrl_105,
            hw_address_ctrl_in106  => targ_addr_ctrl_106,
            hw_address_ctrl_in107  => targ_addr_ctrl_107,
            hw_address_ctrl_in108  => targ_addr_ctrl_108,
            hw_address_ctrl_in109  => targ_addr_ctrl_109,
            hw_address_ctrl_in110  => targ_addr_ctrl_110,
            reg_addr               => reg_addr,
            hip_ctrl_out           => mbus_out_xhdl0
        );
    
END ARCHITECTURE trans;


LIBRARY ieee;
    USE ieee.std_logic_1164.all;

--====Revision Log================
--Rev: 1.5   Wed Mar 19 13:08:01 PDT 2008

ENTITY stratixiv_pciehip_hip_dprio_top IS
    PORT (
        
        -- MDIO inputs/outpus
        mdc                    : IN STD_LOGIC;		-- MDIO Interface clock
        dev_addr               : IN STD_LOGIC_VECTOR(4 DOWNTO 0);		-- 5 bit device address
        port_addr              : IN STD_LOGIC_VECTOR(4 DOWNTO 0);		-- 5 bit port address
        mdio_in                : IN STD_LOGIC;		-- Single bit data-in for MDIO Interface
        mdio_dis               : IN STD_LOGIC;		-- MDIO disable input (using CSR)
        -- 1'b1=output CRAM
        -- 1'b0=output MDIO control register
        mdio_rst               : IN STD_LOGIC;		-- MDIO reset from Quad reset
        
        serial_mode            : IN STD_LOGIC;		-- Serial programming mode enable
        ser_shift_load         : IN STD_LOGIC;		-- Serial programming mode shift/load control
        ser_si                 : IN STD_LOGIC;		-- Serial programming mode data in
        csr_hip_in             : IN STD_LOGIC_VECTOR(1759 DOWNTO 0);		-- CSR inputs
        hip_base_addr          : IN STD_LOGIC_VECTOR(7 DOWNTO 0);		-- DPRIO HIP base address
        
        ser_so                 : OUT STD_LOGIC;		-- Serial programming mode data out
        mdio_out               : OUT STD_LOGIC;		-- Single bit data-out for MDIO Interface
        data_enable_n          : OUT STD_LOGIC;
        curr_state             : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);		-- MDIO current state for digital testbus
        
        -- CRAM output
        out_hip_ctrl_1         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_2         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_3         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_4         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_5         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_6         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_7         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_8         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_9         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_10        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_11        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_12        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_13        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_14        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_15        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_16        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_17        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_18        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_19        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_20        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_21        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_22        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_23        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_24        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_25        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_26        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_27        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_28        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_29        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_30        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_31        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_32        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_33        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_34        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_35        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_36        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_37        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_38        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_39        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_40        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_41        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_42        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_43        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_44        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_45        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_46        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_47        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_48        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_49        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_50        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_51        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_52        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_53        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_54        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_55        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_56        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_57        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_58        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_59        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_60        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_61        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_62        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_63        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_64        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_65        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_66        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_67        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_68        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_69        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_70        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_71        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_72        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_73        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_74        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_75        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_76        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_77        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_78        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_79        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_80        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_81        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_82        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_83        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_84        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_85        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_86        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_87        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_88        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_89        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_90        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_91        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_92        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_93        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_94        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_95        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_96        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_97        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_98        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_99        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_100       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_101       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_102       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_103       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_104       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_105       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_106       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_107       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_108       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_109       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
        out_hip_ctrl_110       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0)
    );
END ENTITY stratixiv_pciehip_hip_dprio_top;

ARCHITECTURE trans OF stratixiv_pciehip_hip_dprio_top IS
    COMPONENT stratixiv_pciehip_dprio_sm IS
        GENERIC (
      
          IDLE           : INTEGER := 0;
          PREAMBLE       : INTEGER := 1;
          CONTROL        : INTEGER := 2;
          TURN_ARND_0    : INTEGER := 3;
          TURN_ARND_1    : INTEGER := 4;
          ADDR_DATA      : INTEGER := 5;
          ADDR_OP        : INTEGER := 0;
          WR_OP          : INTEGER := 1;
          RD_INC_OP      : INTEGER := 2;
          RD_OP          : INTEGER := 3
        );
        PORT (
            mdc                    : IN STD_LOGIC;
            mdio_in                : IN STD_LOGIC;
            reset                  : IN STD_LOGIC;
            opcode                 : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
            valid_addr             : IN STD_LOGIC;
            cnt_eq_0               : IN STD_LOGIC;
            shift_in               : OUT STD_LOGIC;
            shift_out              : OUT STD_LOGIC;
            latch_ctl              : OUT STD_LOGIC;
            incr_addr              : OUT STD_LOGIC;
            mdio_wr                : OUT STD_LOGIC;
            mdio_rd                : OUT STD_LOGIC;
            shift_addr             : OUT STD_LOGIC;
            ld_data                : OUT STD_LOGIC;
            ld_cnt                 : OUT STD_LOGIC;
            cnt_val                : OUT STD_LOGIC_VECTOR(4 DOWNTO 0);
            valid_addr_lt          : OUT STD_LOGIC;
            curr_state             : OUT STD_LOGIC_VECTOR(2 DOWNTO 0)
        );
    END COMPONENT;
    
    COMPONENT stratixiv_pciehip_dprio_ctl_data IS
        PORT (
            mdc                    : IN STD_LOGIC;
            reset                  : IN STD_LOGIC;
            mdio_in                : IN STD_LOGIC;
            shift_in               : IN STD_LOGIC;
            shift_out              : IN STD_LOGIC;
            ld_data                : IN STD_LOGIC;
            latch_ctl              : IN STD_LOGIC;
            port_addr              : IN STD_LOGIC_VECTOR(4 DOWNTO 0);
            dev_addr               : IN STD_LOGIC_VECTOR(4 DOWNTO 0);
            valid_addr_lt          : IN STD_LOGIC;
            mbus_out               : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            mdio_out               : OUT STD_LOGIC;
            data_enable_n          : OUT STD_LOGIC;
            mbus_in                : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            opcode                 : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
            valid_addr             : OUT STD_LOGIC
        );
    END COMPONENT;
    
    COMPONENT stratixiv_pciehip_dprio_cnt IS
        PORT (
            mdc                    : IN STD_LOGIC;
            reset                  : IN STD_LOGIC;
            ld_cnt                 : IN STD_LOGIC;
            cnt_val                : IN STD_LOGIC_VECTOR(4 DOWNTO 0);
            cnt_eq_0               : OUT STD_LOGIC
        );
    END COMPONENT;
    
    COMPONENT stratixiv_pciehip_dprio_reg_top IS
        PORT (
            mdio_rst               : IN STD_LOGIC;
            mdio_wr                : IN STD_LOGIC;
            reg_addr               : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            mdc                    : IN STD_LOGIC;
            mbus_in                : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
            serial_mode            : IN STD_LOGIC;
            mdio_dis               : IN STD_LOGIC;
            ser_shift_load         : IN STD_LOGIC;
            si                     : IN STD_LOGIC;
            csr_hip_in             : IN STD_LOGIC_VECTOR(1759 DOWNTO 0);
            hip_base_addr          : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
            so                     : OUT STD_LOGIC;
            mbus_out               : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_1         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_2         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_3         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_4         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_5         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_6         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_7         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_8         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_9         : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_10        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_11        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_12        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_13        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_14        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_15        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_16        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_17        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_18        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_19        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_20        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_21        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_22        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_23        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_24        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_25        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_26        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_27        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_28        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_29        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_30        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_31        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_32        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_33        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_34        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_35        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_36        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_37        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_38        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_39        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_40        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_41        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_42        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_43        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_44        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_45        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_46        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_47        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_48        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_49        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_50        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_51        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_52        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_53        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_54        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_55        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_56        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_57        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_58        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_59        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_60        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_61        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_62        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_63        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_64        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_65        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_66        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_67        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_68        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_69        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_70        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_71        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_72        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_73        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_74        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_75        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_76        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_77        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_78        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_79        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_80        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_81        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_82        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_83        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_84        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_85        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_86        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_87        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_88        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_89        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_90        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_91        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_92        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_93        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_94        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_95        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_96        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_97        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_98        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_99        : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_100       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_101       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_102       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_103       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_104       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_105       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_106       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_107       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_108       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_109       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
            out_hip_ctrl_110       : OUT STD_LOGIC_VECTOR(15 DOWNTO 0)
        );
    END COMPONENT;
    
    COMPONENT stratixiv_pciehip_dprio_addr IS
        PORT (
            mdc                    : IN STD_LOGIC;
            reset                  : IN STD_LOGIC;
            mdio_in                : IN STD_LOGIC;
            shift_addr             : IN STD_LOGIC;
            incr_addr              : IN STD_LOGIC;
            reg_addr               : OUT STD_LOGIC_VECTOR(15 DOWNTO 0)
        );
    END COMPONENT;
    
    
    -- Wiring section
    SIGNAL mdio_rd                 : STD_LOGIC;		-- MDIO read from SM
    SIGNAL mbus_out                : STD_LOGIC_VECTOR(15 DOWNTO 0);		-- Data out to mdio_ctrl
    SIGNAL shift_addr              : STD_LOGIC;
    SIGNAL incr_addr               : STD_LOGIC;
    SIGNAL ld_cnt                  : STD_LOGIC;
    SIGNAL cnt_val                 : STD_LOGIC_VECTOR(4 DOWNTO 0);
    SIGNAL cnt_eq_0                : STD_LOGIC;
    SIGNAL opcode                  : STD_LOGIC_VECTOR(1 DOWNTO 0);
    SIGNAL valid_addr              : STD_LOGIC;
    SIGNAL shift_in                : STD_LOGIC;
    SIGNAL shift_out               : STD_LOGIC;
    SIGNAL ld_data                 : STD_LOGIC;
    SIGNAL latch_ctl               : STD_LOGIC;
    SIGNAL valid_addr_lt           : STD_LOGIC;
    -- Single bit data-out for MDIO Interface
    SIGNAL mdio_wr                 : STD_LOGIC;		-- MDIO write from SM
    SIGNAL reg_addr                : STD_LOGIC_VECTOR(15 DOWNTO 0);		-- Register address from mdio_addr module
    SIGNAL mbus_in                 : STD_LOGIC_VECTOR(15 DOWNTO 0);		-- data to channel and central MDIO registers
    
    -- Declare intermediate signals for referenced outputs
    SIGNAL ser_so_xhdl113          : STD_LOGIC;
    SIGNAL mdio_out_xhdl2          : STD_LOGIC;
    SIGNAL data_enable_n_xhdl1     : STD_LOGIC;
    SIGNAL curr_state_xhdl0        : STD_LOGIC_VECTOR(2 DOWNTO 0);
    SIGNAL out_hip_ctrl_1_xhdl3    : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_2_xhdl25   : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_3_xhdl36   : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_4_xhdl47   : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_5_xhdl58   : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_6_xhdl69   : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_7_xhdl80   : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_8_xhdl91   : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_9_xhdl102  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_10_xhdl4   : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_11_xhdl15  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_12_xhdl17  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_13_xhdl18  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_14_xhdl19  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_15_xhdl20  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_16_xhdl21  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_17_xhdl22  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_18_xhdl23  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_19_xhdl24  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_20_xhdl26  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_21_xhdl27  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_22_xhdl28  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_23_xhdl29  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_24_xhdl30  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_25_xhdl31  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_26_xhdl32  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_27_xhdl33  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_28_xhdl34  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_29_xhdl35  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_30_xhdl37  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_31_xhdl38  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_32_xhdl39  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_33_xhdl40  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_34_xhdl41  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_35_xhdl42  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_36_xhdl43  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_37_xhdl44  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_38_xhdl45  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_39_xhdl46  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_40_xhdl48  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_41_xhdl49  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_42_xhdl50  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_43_xhdl51  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_44_xhdl52  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_45_xhdl53  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_46_xhdl54  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_47_xhdl55  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_48_xhdl56  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_49_xhdl57  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_50_xhdl59  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_51_xhdl60  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_52_xhdl61  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_53_xhdl62  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_54_xhdl63  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_55_xhdl64  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_56_xhdl65  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_57_xhdl66  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_58_xhdl67  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_59_xhdl68  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_60_xhdl70  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_61_xhdl71  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_62_xhdl72  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_63_xhdl73  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_64_xhdl74  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_65_xhdl75  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_66_xhdl76  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_67_xhdl77  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_68_xhdl78  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_69_xhdl79  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_70_xhdl81  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_71_xhdl82  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_72_xhdl83  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_73_xhdl84  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_74_xhdl85  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_75_xhdl86  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_76_xhdl87  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_77_xhdl88  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_78_xhdl89  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_79_xhdl90  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_80_xhdl92  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_81_xhdl93  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_82_xhdl94  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_83_xhdl95  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_84_xhdl96  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_85_xhdl97  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_86_xhdl98  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_87_xhdl99  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_88_xhdl100 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_89_xhdl101 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_90_xhdl103 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_91_xhdl104 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_92_xhdl105 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_93_xhdl106 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_94_xhdl107 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_95_xhdl108 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_96_xhdl109 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_97_xhdl110 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_98_xhdl111 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_99_xhdl112 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_100_xhdl5  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_101_xhdl6  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_102_xhdl7  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_103_xhdl8  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_104_xhdl9  : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_105_xhdl10 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_106_xhdl11 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_107_xhdl12 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_108_xhdl13 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_109_xhdl14 : STD_LOGIC_VECTOR(15 DOWNTO 0);
    SIGNAL out_hip_ctrl_110_xhdl16 : STD_LOGIC_VECTOR(15 DOWNTO 0);
BEGIN
    -- Drive referenced outputs
    ser_so <= ser_so_xhdl113;
    mdio_out <= mdio_out_xhdl2;
    data_enable_n <= data_enable_n_xhdl1;
    curr_state <= curr_state_xhdl0;
    out_hip_ctrl_1 <= out_hip_ctrl_1_xhdl3;
    out_hip_ctrl_2 <= out_hip_ctrl_2_xhdl25;
    out_hip_ctrl_3 <= out_hip_ctrl_3_xhdl36;
    out_hip_ctrl_4 <= out_hip_ctrl_4_xhdl47;
    out_hip_ctrl_5 <= out_hip_ctrl_5_xhdl58;
    out_hip_ctrl_6 <= out_hip_ctrl_6_xhdl69;
    out_hip_ctrl_7 <= out_hip_ctrl_7_xhdl80;
    out_hip_ctrl_8 <= out_hip_ctrl_8_xhdl91;
    out_hip_ctrl_9 <= out_hip_ctrl_9_xhdl102;
    out_hip_ctrl_10 <= out_hip_ctrl_10_xhdl4;
    out_hip_ctrl_11 <= out_hip_ctrl_11_xhdl15;
    out_hip_ctrl_12 <= out_hip_ctrl_12_xhdl17;
    out_hip_ctrl_13 <= out_hip_ctrl_13_xhdl18;
    out_hip_ctrl_14 <= out_hip_ctrl_14_xhdl19;
    out_hip_ctrl_15 <= out_hip_ctrl_15_xhdl20;
    out_hip_ctrl_16 <= out_hip_ctrl_16_xhdl21;
    out_hip_ctrl_17 <= out_hip_ctrl_17_xhdl22;
    out_hip_ctrl_18 <= out_hip_ctrl_18_xhdl23;
    out_hip_ctrl_19 <= out_hip_ctrl_19_xhdl24;
    out_hip_ctrl_20 <= out_hip_ctrl_20_xhdl26;
    out_hip_ctrl_21 <= out_hip_ctrl_21_xhdl27;
    out_hip_ctrl_22 <= out_hip_ctrl_22_xhdl28;
    out_hip_ctrl_23 <= out_hip_ctrl_23_xhdl29;
    out_hip_ctrl_24 <= out_hip_ctrl_24_xhdl30;
    out_hip_ctrl_25 <= out_hip_ctrl_25_xhdl31;
    out_hip_ctrl_26 <= out_hip_ctrl_26_xhdl32;
    out_hip_ctrl_27 <= out_hip_ctrl_27_xhdl33;
    out_hip_ctrl_28 <= out_hip_ctrl_28_xhdl34;
    out_hip_ctrl_29 <= out_hip_ctrl_29_xhdl35;
    out_hip_ctrl_30 <= out_hip_ctrl_30_xhdl37;
    out_hip_ctrl_31 <= out_hip_ctrl_31_xhdl38;
    out_hip_ctrl_32 <= out_hip_ctrl_32_xhdl39;
    out_hip_ctrl_33 <= out_hip_ctrl_33_xhdl40;
    out_hip_ctrl_34 <= out_hip_ctrl_34_xhdl41;
    out_hip_ctrl_35 <= out_hip_ctrl_35_xhdl42;
    out_hip_ctrl_36 <= out_hip_ctrl_36_xhdl43;
    out_hip_ctrl_37 <= out_hip_ctrl_37_xhdl44;
    out_hip_ctrl_38 <= out_hip_ctrl_38_xhdl45;
    out_hip_ctrl_39 <= out_hip_ctrl_39_xhdl46;
    out_hip_ctrl_40 <= out_hip_ctrl_40_xhdl48;
    out_hip_ctrl_41 <= out_hip_ctrl_41_xhdl49;
    out_hip_ctrl_42 <= out_hip_ctrl_42_xhdl50;
    out_hip_ctrl_43 <= out_hip_ctrl_43_xhdl51;
    out_hip_ctrl_44 <= out_hip_ctrl_44_xhdl52;
    out_hip_ctrl_45 <= out_hip_ctrl_45_xhdl53;
    out_hip_ctrl_46 <= out_hip_ctrl_46_xhdl54;
    out_hip_ctrl_47 <= out_hip_ctrl_47_xhdl55;
    out_hip_ctrl_48 <= out_hip_ctrl_48_xhdl56;
    out_hip_ctrl_49 <= out_hip_ctrl_49_xhdl57;
    out_hip_ctrl_50 <= out_hip_ctrl_50_xhdl59;
    out_hip_ctrl_51 <= out_hip_ctrl_51_xhdl60;
    out_hip_ctrl_52 <= out_hip_ctrl_52_xhdl61;
    out_hip_ctrl_53 <= out_hip_ctrl_53_xhdl62;
    out_hip_ctrl_54 <= out_hip_ctrl_54_xhdl63;
    out_hip_ctrl_55 <= out_hip_ctrl_55_xhdl64;
    out_hip_ctrl_56 <= out_hip_ctrl_56_xhdl65;
    out_hip_ctrl_57 <= out_hip_ctrl_57_xhdl66;
    out_hip_ctrl_58 <= out_hip_ctrl_58_xhdl67;
    out_hip_ctrl_59 <= out_hip_ctrl_59_xhdl68;
    out_hip_ctrl_60 <= out_hip_ctrl_60_xhdl70;
    out_hip_ctrl_61 <= out_hip_ctrl_61_xhdl71;
    out_hip_ctrl_62 <= out_hip_ctrl_62_xhdl72;
    out_hip_ctrl_63 <= out_hip_ctrl_63_xhdl73;
    out_hip_ctrl_64 <= out_hip_ctrl_64_xhdl74;
    out_hip_ctrl_65 <= out_hip_ctrl_65_xhdl75;
    out_hip_ctrl_66 <= out_hip_ctrl_66_xhdl76;
    out_hip_ctrl_67 <= out_hip_ctrl_67_xhdl77;
    out_hip_ctrl_68 <= out_hip_ctrl_68_xhdl78;
    out_hip_ctrl_69 <= out_hip_ctrl_69_xhdl79;
    out_hip_ctrl_70 <= out_hip_ctrl_70_xhdl81;
    out_hip_ctrl_71 <= out_hip_ctrl_71_xhdl82;
    out_hip_ctrl_72 <= out_hip_ctrl_72_xhdl83;
    out_hip_ctrl_73 <= out_hip_ctrl_73_xhdl84;
    out_hip_ctrl_74 <= out_hip_ctrl_74_xhdl85;
    out_hip_ctrl_75 <= out_hip_ctrl_75_xhdl86;
    out_hip_ctrl_76 <= out_hip_ctrl_76_xhdl87;
    out_hip_ctrl_77 <= out_hip_ctrl_77_xhdl88;
    out_hip_ctrl_78 <= out_hip_ctrl_78_xhdl89;
    out_hip_ctrl_79 <= out_hip_ctrl_79_xhdl90;
    out_hip_ctrl_80 <= out_hip_ctrl_80_xhdl92;
    out_hip_ctrl_81 <= out_hip_ctrl_81_xhdl93;
    out_hip_ctrl_82 <= out_hip_ctrl_82_xhdl94;
    out_hip_ctrl_83 <= out_hip_ctrl_83_xhdl95;
    out_hip_ctrl_84 <= out_hip_ctrl_84_xhdl96;
    out_hip_ctrl_85 <= out_hip_ctrl_85_xhdl97;
    out_hip_ctrl_86 <= out_hip_ctrl_86_xhdl98;
    out_hip_ctrl_87 <= out_hip_ctrl_87_xhdl99;
    out_hip_ctrl_88 <= out_hip_ctrl_88_xhdl100;
    out_hip_ctrl_89 <= out_hip_ctrl_89_xhdl101;
    out_hip_ctrl_90 <= out_hip_ctrl_90_xhdl103;
    out_hip_ctrl_91 <= out_hip_ctrl_91_xhdl104;
    out_hip_ctrl_92 <= out_hip_ctrl_92_xhdl105;
    out_hip_ctrl_93 <= out_hip_ctrl_93_xhdl106;
    out_hip_ctrl_94 <= out_hip_ctrl_94_xhdl107;
    out_hip_ctrl_95 <= out_hip_ctrl_95_xhdl108;
    out_hip_ctrl_96 <= out_hip_ctrl_96_xhdl109;
    out_hip_ctrl_97 <= out_hip_ctrl_97_xhdl110;
    out_hip_ctrl_98 <= out_hip_ctrl_98_xhdl111;
    out_hip_ctrl_99 <= out_hip_ctrl_99_xhdl112;
    out_hip_ctrl_100 <= out_hip_ctrl_100_xhdl5;
    out_hip_ctrl_101 <= out_hip_ctrl_101_xhdl6;
    out_hip_ctrl_102 <= out_hip_ctrl_102_xhdl7;
    out_hip_ctrl_103 <= out_hip_ctrl_103_xhdl8;
    out_hip_ctrl_104 <= out_hip_ctrl_104_xhdl9;
    out_hip_ctrl_105 <= out_hip_ctrl_105_xhdl10;
    out_hip_ctrl_106 <= out_hip_ctrl_106_xhdl11;
    out_hip_ctrl_107 <= out_hip_ctrl_107_xhdl12;
    out_hip_ctrl_108 <= out_hip_ctrl_108_xhdl13;
    out_hip_ctrl_109 <= out_hip_ctrl_109_xhdl14;
    out_hip_ctrl_110 <= out_hip_ctrl_110_xhdl16;
    
    -- Central MDIO registers
    
    
    dprio_reg_1 : stratixiv_pciehip_dprio_reg_top
        PORT MAP (
            mdio_rst          => mdio_rst,
            mdio_wr           => mdio_wr,
            reg_addr          => reg_addr,
            mdc               => mdc,
            mbus_in           => mbus_in,
            serial_mode       => serial_mode,
            mdio_dis          => mdio_dis,
            ser_shift_load    => ser_shift_load,
            si                => ser_si,
            csr_hip_in        => csr_hip_in,
            hip_base_addr     => hip_base_addr,
            so                => ser_so_xhdl113,
            mbus_out          => mbus_out,
            -- DPRIO register output
            out_hip_ctrl_1    => out_hip_ctrl_1_xhdl3,
            out_hip_ctrl_2    => out_hip_ctrl_2_xhdl25,
            out_hip_ctrl_3    => out_hip_ctrl_3_xhdl36,
            out_hip_ctrl_4    => out_hip_ctrl_4_xhdl47,
            out_hip_ctrl_5    => out_hip_ctrl_5_xhdl58,
            out_hip_ctrl_6    => out_hip_ctrl_6_xhdl69,
            out_hip_ctrl_7    => out_hip_ctrl_7_xhdl80,
            out_hip_ctrl_8    => out_hip_ctrl_8_xhdl91,
            out_hip_ctrl_9    => out_hip_ctrl_9_xhdl102,
            out_hip_ctrl_10   => out_hip_ctrl_10_xhdl4,
            out_hip_ctrl_11   => out_hip_ctrl_11_xhdl15,
            out_hip_ctrl_12   => out_hip_ctrl_12_xhdl17,
            out_hip_ctrl_13   => out_hip_ctrl_13_xhdl18,
            out_hip_ctrl_14   => out_hip_ctrl_14_xhdl19,
            out_hip_ctrl_15   => out_hip_ctrl_15_xhdl20,
            out_hip_ctrl_16   => out_hip_ctrl_16_xhdl21,
            out_hip_ctrl_17   => out_hip_ctrl_17_xhdl22,
            out_hip_ctrl_18   => out_hip_ctrl_18_xhdl23,
            out_hip_ctrl_19   => out_hip_ctrl_19_xhdl24,
            out_hip_ctrl_20   => out_hip_ctrl_20_xhdl26,
            out_hip_ctrl_21   => out_hip_ctrl_21_xhdl27,
            out_hip_ctrl_22   => out_hip_ctrl_22_xhdl28,
            out_hip_ctrl_23   => out_hip_ctrl_23_xhdl29,
            out_hip_ctrl_24   => out_hip_ctrl_24_xhdl30,
            out_hip_ctrl_25   => out_hip_ctrl_25_xhdl31,
            out_hip_ctrl_26   => out_hip_ctrl_26_xhdl32,
            out_hip_ctrl_27   => out_hip_ctrl_27_xhdl33,
            out_hip_ctrl_28   => out_hip_ctrl_28_xhdl34,
            out_hip_ctrl_29   => out_hip_ctrl_29_xhdl35,
            out_hip_ctrl_30   => out_hip_ctrl_30_xhdl37,
            out_hip_ctrl_31   => out_hip_ctrl_31_xhdl38,
            out_hip_ctrl_32   => out_hip_ctrl_32_xhdl39,
            out_hip_ctrl_33   => out_hip_ctrl_33_xhdl40,
            out_hip_ctrl_34   => out_hip_ctrl_34_xhdl41,
            out_hip_ctrl_35   => out_hip_ctrl_35_xhdl42,
            out_hip_ctrl_36   => out_hip_ctrl_36_xhdl43,
            out_hip_ctrl_37   => out_hip_ctrl_37_xhdl44,
            out_hip_ctrl_38   => out_hip_ctrl_38_xhdl45,
            out_hip_ctrl_39   => out_hip_ctrl_39_xhdl46,
            out_hip_ctrl_40   => out_hip_ctrl_40_xhdl48,
            out_hip_ctrl_41   => out_hip_ctrl_41_xhdl49,
            out_hip_ctrl_42   => out_hip_ctrl_42_xhdl50,
            out_hip_ctrl_43   => out_hip_ctrl_43_xhdl51,
            out_hip_ctrl_44   => out_hip_ctrl_44_xhdl52,
            out_hip_ctrl_45   => out_hip_ctrl_45_xhdl53,
            out_hip_ctrl_46   => out_hip_ctrl_46_xhdl54,
            out_hip_ctrl_47   => out_hip_ctrl_47_xhdl55,
            out_hip_ctrl_48   => out_hip_ctrl_48_xhdl56,
            out_hip_ctrl_49   => out_hip_ctrl_49_xhdl57,
            out_hip_ctrl_50   => out_hip_ctrl_50_xhdl59,
            out_hip_ctrl_51   => out_hip_ctrl_51_xhdl60,
            out_hip_ctrl_52   => out_hip_ctrl_52_xhdl61,
            out_hip_ctrl_53   => out_hip_ctrl_53_xhdl62,
            out_hip_ctrl_54   => out_hip_ctrl_54_xhdl63,
            out_hip_ctrl_55   => out_hip_ctrl_55_xhdl64,
            out_hip_ctrl_56   => out_hip_ctrl_56_xhdl65,
            out_hip_ctrl_57   => out_hip_ctrl_57_xhdl66,
            out_hip_ctrl_58   => out_hip_ctrl_58_xhdl67,
            out_hip_ctrl_59   => out_hip_ctrl_59_xhdl68,
            out_hip_ctrl_60   => out_hip_ctrl_60_xhdl70,
            out_hip_ctrl_61   => out_hip_ctrl_61_xhdl71,
            out_hip_ctrl_62   => out_hip_ctrl_62_xhdl72,
            out_hip_ctrl_63   => out_hip_ctrl_63_xhdl73,
            out_hip_ctrl_64   => out_hip_ctrl_64_xhdl74,
            out_hip_ctrl_65   => out_hip_ctrl_65_xhdl75,
            out_hip_ctrl_66   => out_hip_ctrl_66_xhdl76,
            out_hip_ctrl_67   => out_hip_ctrl_67_xhdl77,
            out_hip_ctrl_68   => out_hip_ctrl_68_xhdl78,
            out_hip_ctrl_69   => out_hip_ctrl_69_xhdl79,
            out_hip_ctrl_70   => out_hip_ctrl_70_xhdl81,
            out_hip_ctrl_71   => out_hip_ctrl_71_xhdl82,
            out_hip_ctrl_72   => out_hip_ctrl_72_xhdl83,
            out_hip_ctrl_73   => out_hip_ctrl_73_xhdl84,
            out_hip_ctrl_74   => out_hip_ctrl_74_xhdl85,
            out_hip_ctrl_75   => out_hip_ctrl_75_xhdl86,
            out_hip_ctrl_76   => out_hip_ctrl_76_xhdl87,
            out_hip_ctrl_77   => out_hip_ctrl_77_xhdl88,
            out_hip_ctrl_78   => out_hip_ctrl_78_xhdl89,
            out_hip_ctrl_79   => out_hip_ctrl_79_xhdl90,
            out_hip_ctrl_80   => out_hip_ctrl_80_xhdl92,
            out_hip_ctrl_81   => out_hip_ctrl_81_xhdl93,
            out_hip_ctrl_82   => out_hip_ctrl_82_xhdl94,
            out_hip_ctrl_83   => out_hip_ctrl_83_xhdl95,
            out_hip_ctrl_84   => out_hip_ctrl_84_xhdl96,
            out_hip_ctrl_85   => out_hip_ctrl_85_xhdl97,
            out_hip_ctrl_86   => out_hip_ctrl_86_xhdl98,
            out_hip_ctrl_87   => out_hip_ctrl_87_xhdl99,
            out_hip_ctrl_88   => out_hip_ctrl_88_xhdl100,
            out_hip_ctrl_89   => out_hip_ctrl_89_xhdl101,
            out_hip_ctrl_90   => out_hip_ctrl_90_xhdl103,
            out_hip_ctrl_91   => out_hip_ctrl_91_xhdl104,
            out_hip_ctrl_92   => out_hip_ctrl_92_xhdl105,
            out_hip_ctrl_93   => out_hip_ctrl_93_xhdl106,
            out_hip_ctrl_94   => out_hip_ctrl_94_xhdl107,
            out_hip_ctrl_95   => out_hip_ctrl_95_xhdl108,
            out_hip_ctrl_96   => out_hip_ctrl_96_xhdl109,
            out_hip_ctrl_97   => out_hip_ctrl_97_xhdl110,
            out_hip_ctrl_98   => out_hip_ctrl_98_xhdl111,
            out_hip_ctrl_99   => out_hip_ctrl_99_xhdl112,
            out_hip_ctrl_100  => out_hip_ctrl_100_xhdl5,
            out_hip_ctrl_101  => out_hip_ctrl_101_xhdl6,
            out_hip_ctrl_102  => out_hip_ctrl_102_xhdl7,
            out_hip_ctrl_103  => out_hip_ctrl_103_xhdl8,
            out_hip_ctrl_104  => out_hip_ctrl_104_xhdl9,
            out_hip_ctrl_105  => out_hip_ctrl_105_xhdl10,
            out_hip_ctrl_106  => out_hip_ctrl_106_xhdl11,
            out_hip_ctrl_107  => out_hip_ctrl_107_xhdl12,
            out_hip_ctrl_108  => out_hip_ctrl_108_xhdl13,
            out_hip_ctrl_109  => out_hip_ctrl_109_xhdl14,
            out_hip_ctrl_110  => out_hip_ctrl_110_xhdl16
        );
    
    -- DPRIO address decoding
    
    
    dprio_addr_1 : stratixiv_pciehip_dprio_addr
        PORT MAP (
            reset       => mdio_rst,
            mdc         => mdc,
            mdio_in     => mdio_in,
            shift_addr  => shift_addr,
            incr_addr   => incr_addr,
            reg_addr    => reg_addr
        );
    
    -- DPRIO counter
    
    
    dprio_cnt_1 : stratixiv_pciehip_dprio_cnt
        PORT MAP (
            reset     => mdio_rst,
            mdc       => mdc,
            ld_cnt    => ld_cnt,
            cnt_val   => cnt_val,
            cnt_eq_0  => cnt_eq_0
        );
    
    -- DPRIO SM
    
    
    dprio_sm_1 : stratixiv_pciehip_dprio_sm
        PORT MAP (
            reset          => mdio_rst,
            mdio_in        => mdio_in,
            mdc            => mdc,
            opcode         => opcode,
            valid_addr     => valid_addr,
            cnt_eq_0       => cnt_eq_0,
            shift_in       => shift_in,
            shift_out      => shift_out,
            latch_ctl      => latch_ctl,
            incr_addr      => incr_addr,
            mdio_wr        => mdio_wr,
            mdio_rd        => mdio_rd,
            shift_addr     => shift_addr,
            ld_data        => ld_data,
            ld_cnt         => ld_cnt,
            cnt_val        => cnt_val,
            valid_addr_lt  => valid_addr_lt,
            curr_state     => curr_state_xhdl0
        );
    
    -- DPRIO data control
    
    
    dprio_ctl_data_1 : stratixiv_pciehip_dprio_ctl_data
        PORT MAP (
            reset          => mdio_rst,
            mdc            => mdc,
            mdio_in        => mdio_in,
            shift_in       => shift_in,
            shift_out      => shift_out,
            ld_data        => ld_data,
            latch_ctl      => latch_ctl,
            port_addr      => port_addr,
            dev_addr       => dev_addr,
            valid_addr_lt  => valid_addr_lt,
            mbus_out       => mbus_out,
            mdio_out       => mdio_out_xhdl2,
            mbus_in        => mbus_in,
            opcode         => opcode,
            valid_addr     => valid_addr,
            data_enable_n  => data_enable_n_xhdl1
        );
    
END ARCHITECTURE trans;



-------------------------------------------------------------------------------
-- Result Bit Computing Module
-------------------------------------------------------------------------------

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.stratixiv_pcie_hip_components.all;

ENTITY stratixiv_pciehip_compute_bit IS
   PORT (
      datain  : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
      s       : IN STD_LOGIC;
      r       : OUT STD_LOGIC
   );
END stratixiv_pciehip_compute_bit;

ARCHITECTURE trans OF stratixiv_pciehip_compute_bit IS
BEGIN
   --   begin
   r <= datain(0) XOR datain(1) XOR datain(2) XOR datain(3) XOR datain(4) XOR datain(5) XOR datain(6) XOR datain(7) XOR datain(10) XOR datain(13) XOR datain(14) XOR datain(17) XOR datain(20) XOR datain(23) XOR datain(24) XOR datain(27) XOR datain(35) XOR datain(43) XOR datain(46) XOR datain(47) XOR datain(51) XOR datain(52) XOR datain(53) XOR datain(56) XOR datain(57) XOR datain(58) XOR s;
   
END trans;


--   end


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.stratixiv_pcie_hip_components.all;

ENTITY stratixiv_pciehip_ecc_gen IS
   PORT (
      datain    : IN STD_LOGIC_VECTOR(63 DOWNTO 0);		-- Data on which ECC is required 
      syndrome  : IN STD_LOGIC_VECTOR(7 DOWNTO 0);		-- Syndrome uses 8'h00 while generating 
      -- Result 
      result    : OUT STD_LOGIC_VECTOR(7 DOWNTO 0)
   );
END stratixiv_pciehip_ecc_gen;

ARCHITECTURE trans OF stratixiv_pciehip_ecc_gen IS
   COMPONENT stratixiv_pciehip_compute_bit
      PORT (
         datain    : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
         s         : IN STD_LOGIC;
         r         : OUT STD_LOGIC
      );
   END COMPONENT;
   
   -- X-HDL generated signals

   SIGNAL xhdl6 : STD_LOGIC_VECTOR(63 DOWNTO 0);
   SIGNAL xhdl7 : STD_LOGIC_VECTOR(63 DOWNTO 0);
   SIGNAL xhdl8 : STD_LOGIC_VECTOR(63 DOWNTO 0);
   SIGNAL xhdl9 : STD_LOGIC_VECTOR(63 DOWNTO 0);
   SIGNAL xhdl10 : STD_LOGIC_VECTOR(63 DOWNTO 0);
   SIGNAL xhdl11 : STD_LOGIC_VECTOR(63 DOWNTO 0);
   SIGNAL xhdl12 : STD_LOGIC_VECTOR(63 DOWNTO 0);
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL result_xhdl0 : STD_LOGIC_VECTOR(7 DOWNTO 0);
BEGIN
   -- Drive referenced outputs
   result <= result_xhdl0;
   
   -------------------------------------------------------------------------------
   -- Instantiate Result Compute block for 8 bits  
   -------------------------------------------------------------------------------
   
   
   cb_0 : stratixiv_pciehip_compute_bit
      PORT MAP (
         datain  => datain,
         s       => syndrome(0),
         r       => result_xhdl0(0)
      );
   
   
   xhdl6 <= (datain(7 DOWNTO 0) & datain(63 DOWNTO 8));
   cb_1 : stratixiv_pciehip_compute_bit
      PORT MAP (
         datain  => xhdl6,
         s       => syndrome(1),
         r       => result_xhdl0(1)
      );
   
   
   xhdl7 <= (datain(15 DOWNTO 0) & datain(63 DOWNTO 16));
   cb_2 : stratixiv_pciehip_compute_bit
      PORT MAP (
         datain  => xhdl7,
         s       => syndrome(2),
         r       => result_xhdl0(2)
      );
   
   
   xhdl8 <= (datain(23 DOWNTO 0) & datain(63 DOWNTO 24));
   cb_3 : stratixiv_pciehip_compute_bit
      PORT MAP (
         datain  => xhdl8,
         s       => syndrome(3),
         r       => result_xhdl0(3)
      );
   
   
   xhdl9 <= (datain(31 DOWNTO 0) & datain(63 DOWNTO 32));
   cb_4 : stratixiv_pciehip_compute_bit
      PORT MAP (
         datain  => xhdl9,
         s       => syndrome(4),
         r       => result_xhdl0(4)
      );
   
   
   xhdl10 <= (datain(39 DOWNTO 0) & datain(63 DOWNTO 40));
   cb_5 : stratixiv_pciehip_compute_bit
      PORT MAP (
         datain  => xhdl10,
         s       => syndrome(5),
         r       => result_xhdl0(5)
      );
   
   
   xhdl11 <= (datain(47 DOWNTO 0) & datain(63 DOWNTO 48));
   cb_6 : stratixiv_pciehip_compute_bit
      PORT MAP (
         datain  => xhdl11,
         s       => syndrome(6),
         r       => result_xhdl0(6)
      );
   
   
   xhdl12 <= (datain(55 DOWNTO 0) & datain(63 DOWNTO 56));
   cb_7 : stratixiv_pciehip_compute_bit
      PORT MAP (
         datain  => xhdl12,
         s       => syndrome(7),
         r       => result_xhdl0(7)
      );
   
END trans;




LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.stratixiv_pcie_hip_components.all;

ENTITY stratixiv_pciehip_ecc_chk IS
   PORT (
      enable_ecc  : IN STD_LOGIC;		-- Active High Enable ECC
      datain      : IN STD_LOGIC_VECTOR(63 DOWNTO 0);		-- Data on which ECC is required 
      syndrome    : IN STD_LOGIC_VECTOR(7 DOWNTO 0);		-- Syndrome uses the result stored during ECC gen 
      dataout     : OUT STD_LOGIC_VECTOR(63 DOWNTO 0);		-- Single bit Corrected Data
      single_err  : OUT STD_LOGIC;		-- Single Bit Error Detected 
      -- Multiple Bit Error detected 
      multi_err   : OUT STD_LOGIC
   );
END stratixiv_pciehip_ecc_chk;

ARCHITECTURE trans OF stratixiv_pciehip_ecc_chk IS
   COMPONENT stratixiv_pciehip_ecc_gen
      PORT (
         datain      : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
         syndrome    : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
         result      : OUT STD_LOGIC_VECTOR(7 DOWNTO 0)
      );
   END COMPONENT;
   
   
   -------------------------------------------------------------------------------
   -- Declare wires
   -------------------------------------------------------------------------------
   SIGNAL correct_data : STD_LOGIC_VECTOR(63 DOWNTO 0);
   SIGNAL result       : STD_LOGIC_VECTOR(7 DOWNTO 0);
BEGIN
   
   -------------------------------------------------------------------------------
   -- Instantiate ECC Generator Block, to generate the result 
   -------------------------------------------------------------------------------
   
   
   stratixiv_pciehip_ecc_gen_inst : stratixiv_pciehip_ecc_gen
      PORT MAP (
         datain    => datain,
         syndrome  => syndrome,
         result    => result
      );
   
   single_err <= '1' WHEN (reduction_or(result) = '1' AND reduction_xor((result)) = '1' AND enable_ecc = '1') ELSE
                 '0';
   multi_err <= '1' WHEN (reduction_or(result) = '1' AND reduction_xor((result)) = '0' AND enable_ecc = '1') ELSE
                '0';
   
   -------------------------------------------------------------------------------
   -- Check which bit is error by looking at the result polynomial 
   -- Designed based on the Paper:c3343, SEC-DEC Codecs, Figure 3 & Figure 5
   -------------------------------------------------------------------------------
   PROCESS (result)
VARIABLE  txt : LINE;
   BEGIN
      CASE result IS
         WHEN "00100011" =>
            correct_data <= "0000000000000000000000000000000000000000000000000000000000000001";
         WHEN "01000011" =>
            correct_data <= "0000000000000000000000000000000000000000000000000000000000000010";
         WHEN "10000011" =>
            correct_data <= "0000000000000000000000000000000000000000000000000000000000000100";
         WHEN "00111101" =>
            correct_data <= "0000000000000000000000000000000000000000000000000000000000001000";
         WHEN "01000101" =>
            correct_data <= "0000000000000000000000000000000000000000000000000000000000010000";
         WHEN "10000101" =>
            correct_data <= "0000000000000000000000000000000000000000000000000000000000100000";
         WHEN "10001001" =>
            correct_data <= "0000000000000000000000000000000000000000000000000000000001000000";
         
         WHEN "01001001" =>
            correct_data <= "0000000000000000000000000000000000000000000000000000000010000000";
         WHEN "01000110" =>
            correct_data <= "0000000000000000000000000000000000000000000000000000000100000000";
         WHEN "10000110" =>
            correct_data <= "0000000000000000000000000000000000000000000000000000001000000000";
         WHEN "00000111" =>
            correct_data <= "0000000000000000000000000000000000000000000000000000010000000000";
         WHEN "01111010" =>
            correct_data <= "0000000000000000000000000000000000000000000000000000100000000000";
         WHEN "10001010" =>
            correct_data <= "0000000000000000000000000000000000000000000000000001000000000000";
         WHEN "00001011" =>
            correct_data <= "0000000000000000000000000000000000000000000000000010000000000000";
         WHEN "00010011" =>
            correct_data <= "0000000000000000000000000000000000000000000000000100000000000000";
         
         WHEN "10010010" =>
            correct_data <= "0000000000000000000000000000000000000000000000001000000000000000";
         WHEN "10001100" =>
            correct_data <= "0000000000000000000000000000000000000000000000010000000000000000";
         WHEN "00001101" =>
            correct_data <= "0000000000000000000000000000000000000000000000100000000000000000";
         WHEN "00001110" =>
            correct_data <= "0000000000000000000000000000000000000000000001000000000000000000";
         WHEN "11110100" =>
            correct_data <= "0000000000000000000000000000000000000000000010000000000000000000";
         WHEN "00010101" =>
            correct_data <= "0000000000000000000000000000000000000000000100000000000000000000";
         WHEN "00010110" =>
            correct_data <= "0000000000000000000000000000000000000000001000000000000000000000";
         WHEN "00100110" =>
            correct_data <= "0000000000000000000000000000000000000000010000000000000000000000";
         
         WHEN "00100101" =>
            correct_data <= "0000000000000000000000000000000000000000100000000000000000000000";
         WHEN "00011001" =>
            correct_data <= "0000000000000000000000000000000000000001000000000000000000000000";
         WHEN "00011010" =>
            correct_data <= "0000000000000000000000000000000000000010000000000000000000000000";
         WHEN "00011100" =>
            correct_data <= "0000000000000000000000000000000000000100000000000000000000000000";
         WHEN "11101001" =>
            correct_data <= "0000000000000000000000000000000000001000000000000000000000000000";
         WHEN "00101010" =>
            correct_data <= "0000000000000000000000000000000000010000000000000000000000000000";
         WHEN "00101100" =>
            correct_data <= "0000000000000000000000000000000000100000000000000000000000000000";
         WHEN "01001100" =>
            correct_data <= "0000000000000000000000000000000001000000000000000000000000000000";
         
         WHEN "01001010" =>
            correct_data <= "0000000000000000000000000000000010000000000000000000000000000000";
         WHEN "00110010" =>
            correct_data <= "0000000000000000000000000000000100000000000000000000000000000000";
         WHEN "00110100" =>
            correct_data <= "0000000000000000000000000000001000000000000000000000000000000000";
         WHEN "00111000" =>
            correct_data <= "0000000000000000000000000000010000000000000000000000000000000000";
         WHEN "11010011" =>
            correct_data <= "0000000000000000000000000000100000000000000000000000000000000000";
         WHEN "01010100" =>
            correct_data <= "0000000000000000000000000001000000000000000000000000000000000000";
         WHEN "01011000" =>
            correct_data <= "0000000000000000000000000010000000000000000000000000000000000000";
         WHEN "10011000" =>
            correct_data <= "0000000000000000000000000100000000000000000000000000000000000000";
         
         WHEN "10010100" =>
            correct_data <= "0000000000000000000000001000000000000000000000000000000000000000";
         WHEN "01100100" =>
            correct_data <= "0000000000000000000000010000000000000000000000000000000000000000";
         WHEN "01101000" =>
            correct_data <= "0000000000000000000000100000000000000000000000000000000000000000";
         WHEN "01110000" =>
            correct_data <= "0000000000000000000001000000000000000000000000000000000000000000";
         WHEN "10100111" =>
            correct_data <= "0000000000000000000010000000000000000000000000000000000000000000";
         WHEN "10101000" =>
            correct_data <= "0000000000000000000100000000000000000000000000000000000000000000";
         WHEN "10110000" =>
            correct_data <= "0000000000000000001000000000000000000000000000000000000000000000";
         WHEN "00110001" =>
            correct_data <= "0000000000000000010000000000000000000000000000000000000000000000";
         
         WHEN "00101001" =>
            correct_data <= "0000000000000000100000000000000000000000000000000000000000000000";
         WHEN "11001000" =>
            correct_data <= "0000000000000001000000000000000000000000000000000000000000000000";
         WHEN "11010000" =>
            correct_data <= "0000000000000010000000000000000000000000000000000000000000000000";
         WHEN "11100000" =>
            correct_data <= "0000000000000100000000000000000000000000000000000000000000000000";
         WHEN "01001111" =>
            correct_data <= "0000000000001000000000000000000000000000000000000000000000000000";
         WHEN "01010001" =>
            correct_data <= "0000000000010000000000000000000000000000000000000000000000000000";
         WHEN "01100001" =>
            correct_data <= "0000000000100000000000000000000000000000000000000000000000000000";
         WHEN "01100010" =>
            correct_data <= "0000000001000000000000000000000000000000000000000000000000000000";
         
         WHEN "01010010" =>
            correct_data <= "0000000010000000000000000000000000000000000000000000000000000000";
         WHEN "10010001" =>
            correct_data <= "0000000100000000000000000000000000000000000000000000000000000000";
         WHEN "10100001" =>
            correct_data <= "0000001000000000000000000000000000000000000000000000000000000000";
         WHEN "11000001" =>
            correct_data <= "0000010000000000000000000000000000000000000000000000000000000000";
         WHEN "10011110" =>
            correct_data <= "0000100000000000000000000000000000000000000000000000000000000000";
         WHEN "10100010" =>
            correct_data <= "0001000000000000000000000000000000000000000000000000000000000000";
         WHEN "11000010" =>
            correct_data <= "0010000000000000000000000000000000000000000000000000000000000000";
         WHEN "11000100" =>
            correct_data <= "0100000000000000000000000000000000000000000000000000000000000000";
         WHEN "10100100" =>
            correct_data <= "1000000000000000000000000000000000000000000000000000000000000000";
         WHEN OTHERS =>
            correct_data <= "0000000000000000000000000000000000000000000000000000000000000000";
      END CASE;
   END PROCESS;
   
   -------------------------------------------------------------------------------
   -- Generate Final corrected Data, Flip the data bit based on the correct_data
   -------------------------------------------------------------------------------
   dataout <= (datain XOR correct_data) WHEN (enable_ecc = '1') ELSE
              datain;
   
END trans;




LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.stratixiv_pcie_hip_components.all;

ENTITY stratixiv_pciehip_ecc_decoder IS
   PORT (
      
      flag        : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      derr        : OUT STD_LOGIC;
      derr_cor    : OUT STD_LOGIC
   );
END stratixiv_pciehip_ecc_decoder;

ARCHITECTURE trans OF stratixiv_pciehip_ecc_decoder IS
BEGIN
   
   derr <= flag(2) AND NOT((flag(1))) AND flag(0);
   derr_cor <= NOT((flag(2))) AND flag(1) AND flag(0);
   
END trans;




LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.stratixiv_pcie_hip_components.all;

ENTITY stratixiv_pciehip_pulse_ext IS
   PORT (
      
      core_clk      : IN STD_LOGIC;
      rstn          : IN STD_LOGIC;
      srst          : IN STD_LOGIC;
      derr_cor      : IN STD_LOGIC;
      derr_cor_ext  : OUT STD_LOGIC
   );
END stratixiv_pciehip_pulse_ext;

ARCHITECTURE trans OF stratixiv_pciehip_pulse_ext IS
   
   SIGNAL n1           : STD_LOGIC;
   SIGNAL n2           : STD_LOGIC;
BEGIN
   
   -- Pulse width extender
   
   PROCESS (rstn, core_clk)
VARIABLE  txt : LINE;
   BEGIN
      IF (rstn = '0') THEN
         n1 <= '0';
      ELSIF (core_clk'EVENT AND core_clk = '1') THEN
         IF (srst = '1') THEN
            n1 <= '0';
         ELSE
            n1 <= derr_cor;
         END IF;
      END IF;
   END PROCESS;
   
   n2 <= n1 OR derr_cor;
   
   PROCESS (rstn, core_clk)
VARIABLE  txt : LINE;
   BEGIN
      IF (rstn = '0') THEN
         derr_cor_ext <= '0';
      ELSIF (core_clk'EVENT AND core_clk = '1') THEN
         IF (srst = '1') THEN
            derr_cor_ext <= '0';
         ELSE
            derr_cor_ext <= n2;
         END IF;
      END IF;
   END PROCESS;
   
END trans;



---------------------------------------------------------------
--
-- hip_mram 
--		
-- MRAM implementation for DPRAM used in Receive and Retry buffers
-- 
--
---------------------------------------------------------------


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.stratixiv_pcie_hip_components.all;

LIBRARY altera_mf;
USE altera_mf.all;

ENTITY stratixiv_pciehip_hip_mram IS
   GENERIC (
      
      ADDR_WIDTH            : INTEGER := 14;
      DATA_WIDTH            : INTEGER := 72
   );
   PORT (
      
      dprio_mram_in         : IN STD_LOGIC_VECTOR(16 DOWNTO 0);
      
      wrclock               : IN STD_LOGIC;
      wren                  : IN STD_LOGIC;
      rden                  : IN STD_LOGIC;
      wraddress             : IN STD_LOGIC_VECTOR(ADDR_WIDTH - 1 DOWNTO 0);
      data                  : IN STD_LOGIC_VECTOR(DATA_WIDTH - 1 DOWNTO 0);
      rdclock               : IN STD_LOGIC;
      rdaddress             : IN STD_LOGIC_VECTOR(ADDR_WIDTH - 1 DOWNTO 0);
      addrstallA            : IN STD_LOGIC;
      addrstallB            : IN STD_LOGIC;
      
      r0_regscanin          : IN STD_LOGIC;
      r1_regscanin          : IN STD_LOGIC;
      r2_regscanin          : IN STD_LOGIC;
      r3_regscanin          : IN STD_LOGIC;
      r4_regscanin          : IN STD_LOGIC;
      r5_regscanin          : IN STD_LOGIC;
      r6_regscanin          : IN STD_LOGIC;
      r7_regscanin          : IN STD_LOGIC;
      
      rsclk                 : IN STD_LOGIC;
      rscen                 : IN STD_LOGIC;
      rscin                 : IN STD_LOGIC;
      rscsel                : IN STD_LOGIC;
      rscrst                : IN STD_LOGIC;
      id                    : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
      
      -- output  [63:0] q;
      q                     : OUT STD_LOGIC_VECTOR(DATA_WIDTH - 1 DOWNTO 0);
      
      DFT_out               : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);
      rscout                : OUT STD_LOGIC;
      r0_regscanout         : OUT STD_LOGIC;
      r1_regscanout         : OUT STD_LOGIC;
      r2_regscanout         : OUT STD_LOGIC;
      r3_regscanout         : OUT STD_LOGIC;
      r4_regscanout         : OUT STD_LOGIC;
      r5_regscanout         : OUT STD_LOGIC;
      r6_regscanout         : OUT STD_LOGIC;
      r7_regscanout         : OUT STD_LOGIC;
      nfrzdrv               : IN STD_LOGIC;
      frzreg                : IN STD_LOGIC;
      frzlogic              : IN STD_LOGIC;
      wrap_back_data        : IN STD_LOGIC_VECTOR(71 DOWNTO 0);
      
      flag                  : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      prv_mram              : IN STD_LOGIC;
      mram_hip_test_enable  : IN STD_LOGIC;
      scanen                : IN STD_LOGIC;
      enscan                : IN STD_LOGIC
   );
END stratixiv_pciehip_hip_mram;

ARCHITECTURE trans OF stratixiv_pciehip_hip_mram IS
   COMPONENT altsyncram
      GENERIC (
         width_a               : INTEGER := 1;
         widthad_a             : INTEGER := 1;
         numwords_a            : INTEGER := 0;
         outdata_reg_a         : STRING := "UNREGISTERED";
         address_aclr_a        : STRING := "NONE";
         outdata_aclr_a        : STRING := "NONE";
         indata_aclr_a         : STRING := "NONE";
         wrcontrol_aclr_a      : STRING := "NONE";
         byteena_aclr_a        : STRING := "NONE";
         width_byteena_a       : INTEGER := 1;
         width_b               : INTEGER := 1;
         widthad_b             : INTEGER := 1;
         numwords_b            : INTEGER := 0;
         rdcontrol_reg_b       : STRING := "CLOCK1";
         address_reg_b         : STRING := "CLOCK1";
         outdata_reg_b         : STRING := "UNREGISTERED";
         outdata_aclr_b        : STRING := "NONE";
         rdcontrol_aclr_b      : STRING := "NONE";
         indata_reg_b          : STRING := "CLOCK1";
         wrcontrol_wraddress_reg_b : STRING := "CLOCK1";
         byteena_reg_b         : STRING := "CLOCK1";
         indata_aclr_b         : STRING := "NONE";
         wrcontrol_aclr_b      : STRING := "NONE";
         address_aclr_b        : STRING := "NONE";
         byteena_aclr_b        : STRING := "NONE";
         width_byteena_b       : INTEGER := 1;
         clock_enable_input_a  : STRING := "NORMAL";
         clock_enable_output_a : STRING := "NORMAL";
         clock_enable_input_b  : STRING := "NORMAL";
         clock_enable_output_b : STRING := "NORMAL";
         clock_enable_core_a   : STRING := "USE_INPUT_CLKEN";
         clock_enable_core_b   : STRING := "USE_INPUT_CLKEN";
         read_during_write_mode_port_a : STRING := "NEW_DATA_NO_NBE_READ";
         read_during_write_mode_port_b : STRING := "NEW_DATA_NO_NBE_READ";
         enable_ecc            : STRING := "FALSE";
         operation_mode        : STRING := "BIDIR_DUAL_PORT";
         byte_size             : INTEGER := 0;
         read_during_write_mode_mixed_ports : STRING := "DONT_CARE";
         sim_show_memory_data_in_port_b_layout :  string  := "OFF";         
         ram_block_type        : STRING := "AUTO";
         init_file             : STRING := "UNUSED";
         init_file_layout      : STRING := "UNUSED";
         maximum_depth         : INTEGER := 0;
         intended_device_family : STRING := "Stratix";
         lpm_hint              : STRING := "UNUSED";
         lpm_type              : STRING := "altsyncram";
         implement_in_les      : STRING := "OFF";
         power_up_uninitialized : STRING := "FALSE"
      );
      PORT (
         wren_a                : IN STD_LOGIC;
         wren_b                : IN STD_LOGIC;
         rden_a                : IN STD_LOGIC;
         rden_b                : IN STD_LOGIC;
         data_a                : IN STD_LOGIC_VECTOR(width_a - 1 DOWNTO 0);
         data_b                : IN STD_LOGIC_VECTOR(width_b - 1 DOWNTO 0);
         address_a             : IN STD_LOGIC_VECTOR(widthad_a - 1 DOWNTO 0);
         address_b             : IN STD_LOGIC_VECTOR(widthad_b - 1 DOWNTO 0);
         clock0                : IN STD_LOGIC;
         clock1                : IN STD_LOGIC;
         clocken0              : IN STD_LOGIC;
         clocken1              : IN STD_LOGIC;
         clocken2              : IN STD_LOGIC;
         clocken3              : IN STD_LOGIC;
         aclr0                 : IN STD_LOGIC;
         aclr1                 : IN STD_LOGIC;
         byteena_a             : IN STD_LOGIC_VECTOR(width_byteena_a - 1 DOWNTO 0);
         byteena_b             : IN STD_LOGIC_VECTOR(width_byteena_b - 1 DOWNTO 0);
         addressstall_a        : IN STD_LOGIC;
         addressstall_b        : IN STD_LOGIC;
         q_a                   : OUT STD_LOGIC_VECTOR(width_a - 1 DOWNTO 0);
         q_b                   : OUT STD_LOGIC_VECTOR(width_b - 1 DOWNTO 0);
         eccstatus             : OUT STD_LOGIC_VECTOR(2 DOWNTO 0)
      );
   END COMPONENT;
   
   SIGNAL rxcorea      : STD_LOGIC_VECTOR(32 DOWNTO 0);
   SIGNAL rxcoreb      : STD_LOGIC_VECTOR(32 DOWNTO 0);
   -- X-HDL generated signals

   SIGNAL xhdl13 : STD_LOGIC_VECTOR(71 DOWNTO 0);
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL q_xhdl1      : STD_LOGIC_VECTOR(DATA_WIDTH - 1 DOWNTO 0);
BEGIN
   -- Drive referenced outputs
   q <= q_xhdl1;
   
   DFT_out <= "00000000";		-- Hard-wired ID for redundancy repair; set to all 0's for now
   rscout <= '0';
   flag <= "000";
   
   r0_regscanout <= '0';
   r1_regscanout <= '0';
   r2_regscanout <= '0';
   r3_regscanout <= '0';
   r4_regscanout <= '0';
   r5_regscanout <= '0';
   r6_regscanout <= '0';
   r7_regscanout <= '0';
   -- MRAM
   
   
   
   xhdl13 <= '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1' & '1';
   altsyncram_component : altsyncram
   GENERIC MAP(               
   				 address_aclr_b => "NONE",
                address_reg_b => "CLOCK0",
                clock_enable_input_a => "BYPASS",
                clock_enable_input_b => "BYPASS",
                clock_enable_output_a => "BYPASS",
                clock_enable_output_b => "BYPASS",
                enable_ecc => "FALSE",
                intended_device_family => "Stratix III",
                lpm_type => "altsyncram",
				numwords_a => 16384,
				numwords_b => 16384,
                operation_mode => "DUAL_PORT",
                outdata_aclr_b => "NONE",
                outdata_reg_b => "UNREGISTERED",
                ram_block_type => "M144K",
                read_during_write_mode_mixed_ports => "DONT_CARE",
                widthad_a => 14,
                widthad_b => 14,
                width_a => 72,
                width_b => 72,
                width_byteena_a => 1
   )
   
      PORT MAP (
         addressstall_a  => addrstallA,
         addressstall_b  => addrstallB,
         wren_a          => wren,
         clock0          => wrclock,
         address_a       => wraddress,
         address_b       => rdaddress,
         data_a          => data,
         q_b             => q_xhdl1,
         aclr0           => '0',
         aclr1           => '0',
         byteena_a       => "1",
         byteena_b       => "1",
         clock1          => '1',
         clocken0        => '1',
         clocken1        => '1',
         clocken2        => '1',
         clocken3        => '1',
         data_b          => xhdl13,
         rden_a          => '1',
         rden_b          => '1',
         wren_b          => '0'
      );
   
END trans;


--.eccstatus (),
--.q_a (),
--.rden_b (rden),
--                altsyncram_component.numwords_a = 2^ADDR_WIDTH,
--                altsyncram_component.numwords_b = 2^ADDR_WIDTH,
--                altsyncram_component.outdata_reg_b = "CLOCK0",


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.stratixiv_pcie_hip_components.all;

ENTITY stratixiv_pciehip_mram_top IS
   GENERIC (
      -- Added bits[18:17]:clk-stealing enable, bit[16] for ECC enable
      -- Async Reset for ECC error pulse width extender and BIST
      -- Sync Reset for ECC error pulse width extender
      -- Enable for BIST
      -- DPRIO inputs for BIST
      -- Enable for Redundancy Scan, to be tested w/ full model later
      -- Scan Enable for Redundancy testing, to be tested w/ full model later
      -- Redundancy scan input from previous MRAM in the chain
      -- Scan Input for Redundancy testing, to be tested w/ full model later
      -- Scan Select for Redundancy testing, to be tested w/ full model later
      -- Scan reset for Redundancy testing, to be tested w/ full model later
      -- Scan Clock for Redundancy testing, to be tested w/ full model later
      -- Hard-wired ID for Redundancy repair
      -- RegScan Enable for MRAM I/O scan chain, to be tested w/ full model later
      -- RegScan Input for MRAM I/O scan chain, to be tested w/ full model later
      -- Signal to disable WE of MRAM during RegScan
      -- Scan Enable for BIST debug logic
      -- Scan Input for BIST debug logic
      -- Input to choose between normal mode inputs and BIST inputs to MRAM
      -- Input to choose between extended and non-extended uncorrected error flags
      -- RegScan Output for MRAM I/O scan chain, to be tested w/ full model later
      -- Scan Output for Redundancy testing, to be tested w/ full model later
      -- Scan Output for BIST debug logic
      -- BIST Done indicator for Port A
      -- BIST Done indicator for Port B
      -- BIST pass/fail indicator
      -- ECC uncorrected error signal
      -- ECC corrected error signal (extended)
      -- Freeze signal from PLD Control Block
      -- Freeze signal from PLD Control Block
      -- Freeze signal from PLD Control Block
      -- Scan mode signal to disable clock stealing
      
      ADDR_WIDTH            : INTEGER := 14;
      DATA_WIDTH            : INTEGER := 72
   );
   PORT (
      core_clk              : IN STD_LOGIC;
      dprio_mram_in         : IN STD_LOGIC_VECTOR(34 DOWNTO 0);
      addrA                 : IN STD_LOGIC_VECTOR(ADDR_WIDTH - 1 DOWNTO 0);
      addrB                 : IN STD_LOGIC_VECTOR(ADDR_WIDTH - 1 DOWNTO 0);
      data                  : IN STD_LOGIC_VECTOR(DATA_WIDTH - 1 DOWNTO 0);
      wren                  : IN STD_LOGIC;
      
      dout                  : OUT STD_LOGIC_VECTOR(DATA_WIDTH - 1 DOWNTO 0);
      rstn                  : IN STD_LOGIC;
      srst                  : IN STD_LOGIC;
      bisten                : IN STD_LOGIC;
      dprio_bist_in         : IN STD_LOGIC_VECTOR(74 DOWNTO 0);
      enscan                : IN STD_LOGIC;
      rscen                 : IN STD_LOGIC;
      prv_mram              : IN STD_LOGIC;
      rscin                 : IN STD_LOGIC;
      rscsel                : IN STD_LOGIC;
      rscrst                : IN STD_LOGIC;
      rsclk                 : IN STD_LOGIC;
      id                    : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
      scanen                : IN STD_LOGIC;
      scanin                : IN STD_LOGIC;
      mram_hip_test_enable  : IN STD_LOGIC;
      bist_scanen           : IN STD_LOGIC;
      bist_scanin           : IN STD_LOGIC;
      testen                : IN STD_LOGIC;
      uncor_err_ext_en      : IN STD_LOGIC;
      
      scanout               : OUT STD_LOGIC;
      
      rscout                : OUT STD_LOGIC;
      bist_scanout          : OUT STD_LOGIC;
      bistdoneA             : OUT STD_LOGIC;
      bistdoneB             : OUT STD_LOGIC;
      pass                  : OUT STD_LOGIC;
      derr                  : OUT STD_LOGIC;
      derr_cor_ext          : OUT STD_LOGIC;
      nfrzdrv               : IN STD_LOGIC;
      frzreg                : IN STD_LOGIC;
      frzlogic              : IN STD_LOGIC;
      scan_mode             : IN STD_LOGIC
   );
END stratixiv_pciehip_mram_top;

ARCHITECTURE trans OF stratixiv_pciehip_mram_top IS
   COMPONENT stratixiv_pciehip_ecc_chk
      PORT (
         enable_ecc            : IN STD_LOGIC;
         datain                : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
         syndrome              : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
         dataout               : OUT STD_LOGIC_VECTOR(63 DOWNTO 0);
         single_err            : OUT STD_LOGIC;
         multi_err             : OUT STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT stratixiv_pciehip_ecc_decoder
      PORT (
         flag                  : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         derr                  : OUT STD_LOGIC;
         derr_cor              : OUT STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT stratixiv_pciehip_hip_mram
      GENERIC (
         ADDR_WIDTH            : INTEGER := 14;
         DATA_WIDTH            : INTEGER := 72
      );
      PORT (
         dprio_mram_in         : IN STD_LOGIC_VECTOR(16 DOWNTO 0);
         wrclock               : IN STD_LOGIC;
         wren                  : IN STD_LOGIC;
         rden                  : IN STD_LOGIC;
         wraddress             : IN STD_LOGIC_VECTOR(ADDR_WIDTH - 1 DOWNTO 0);
         data                  : IN STD_LOGIC_VECTOR(DATA_WIDTH - 1 DOWNTO 0);
         rdclock               : IN STD_LOGIC;
         rdaddress             : IN STD_LOGIC_VECTOR(ADDR_WIDTH - 1 DOWNTO 0);
         addrstallA            : IN STD_LOGIC;
         addrstallB            : IN STD_LOGIC;
         r0_regscanin          : IN STD_LOGIC;
         r1_regscanin          : IN STD_LOGIC;
         r2_regscanin          : IN STD_LOGIC;
         r3_regscanin          : IN STD_LOGIC;
         r4_regscanin          : IN STD_LOGIC;
         r5_regscanin          : IN STD_LOGIC;
         r6_regscanin          : IN STD_LOGIC;
         r7_regscanin          : IN STD_LOGIC;
         rsclk                 : IN STD_LOGIC;
         rscen                 : IN STD_LOGIC;
         rscin                 : IN STD_LOGIC;
         rscsel                : IN STD_LOGIC;
         rscrst                : IN STD_LOGIC;
         id                    : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
         q                     : OUT STD_LOGIC_VECTOR(DATA_WIDTH - 1 DOWNTO 0);
         DFT_out               : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);
         rscout                : OUT STD_LOGIC;
         r0_regscanout         : OUT STD_LOGIC;
         r1_regscanout         : OUT STD_LOGIC;
         r2_regscanout         : OUT STD_LOGIC;
         r3_regscanout         : OUT STD_LOGIC;
         r4_regscanout         : OUT STD_LOGIC;
         r5_regscanout         : OUT STD_LOGIC;
         r6_regscanout         : OUT STD_LOGIC;
         r7_regscanout         : OUT STD_LOGIC;
         nfrzdrv               : IN STD_LOGIC;
         frzreg                : IN STD_LOGIC;
         frzlogic              : IN STD_LOGIC;
         wrap_back_data        : IN STD_LOGIC_VECTOR(71 DOWNTO 0);
         flag                  : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
         prv_mram              : IN STD_LOGIC;
         mram_hip_test_enable  : IN STD_LOGIC;
         scanen                : IN STD_LOGIC;
         enscan                : IN STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT stratixiv_pciehip_pulse_ext
      PORT (
         core_clk              : IN STD_LOGIC;
         rstn                  : IN STD_LOGIC;
         srst                  : IN STD_LOGIC;
         derr_cor              : IN STD_LOGIC;
         derr_cor_ext          : OUT STD_LOGIC
      );
   END COMPONENT;
   
   
   SIGNAL rdclock_dummy      : STD_LOGIC;		-- shawn
   
   SIGNAL dout_int           : STD_LOGIC_VECTOR(DATA_WIDTH - 1 DOWNTO 0);
   
   SIGNAL DFT_out            : STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL addrstallA_bist    : STD_LOGIC;
   SIGNAL addrstallB_bist    : STD_LOGIC;
   SIGNAL addrstallA         : STD_LOGIC;
   SIGNAL addrstallB         : STD_LOGIC;
   SIGNAL writedata          : STD_LOGIC_VECTOR(DATA_WIDTH - 1 DOWNTO 0);
   SIGNAL din                : STD_LOGIC_VECTOR(DATA_WIDTH - 1 DOWNTO 0);
   SIGNAL addrA_bist         : STD_LOGIC_VECTOR(13 DOWNTO 0);
   SIGNAL addrB_bist         : STD_LOGIC_VECTOR(13 DOWNTO 0);
   SIGNAL adwr               : STD_LOGIC_VECTOR(13 DOWNTO 0);
   SIGNAL adrd               : STD_LOGIC_VECTOR(13 DOWNTO 0);
   SIGNAL wren_bist          : STD_LOGIC;
   SIGNAL write_en           : STD_LOGIC;
   SIGNAL r0_regscanout      : STD_LOGIC;
   SIGNAL r1_regscanout      : STD_LOGIC;
   SIGNAL r2_regscanout      : STD_LOGIC;
   SIGNAL r3_regscanout      : STD_LOGIC;
   SIGNAL r4_regscanout      : STD_LOGIC;
   SIGNAL r5_regscanout      : STD_LOGIC;
   SIGNAL r6_regscanout      : STD_LOGIC;
   -- wire    derr_cor;
   
   SIGNAL derr_int           : STD_LOGIC;
   SIGNAL derr_cor_int       : STD_LOGIC;
   SIGNAL derr_int_ext       : STD_LOGIC;
   SIGNAL derr_int_nc        : STD_LOGIC;
   SIGNAL derr_cor_int_nc    : STD_LOGIC;
   
   SIGNAL flag               : STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   SIGNAL wrap_back_data     : STD_LOGIC_VECTOR(71 DOWNTO 0);
   
   SIGNAL core_clk_int       : STD_LOGIC;
   SIGNAL temp               : STD_LOGIC_VECTOR(63 DOWNTO 0);
   -- X-HDL generated signals

   SIGNAL xhdl13 : STD_LOGIC_VECTOR(63 DOWNTO 0);
   SIGNAL xhdl14 : STD_LOGIC_VECTOR(7 DOWNTO 0);
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL scanout_xhdl4      : STD_LOGIC;
   SIGNAL rscout_xhdl3       : STD_LOGIC;
   SIGNAL derr_cor_ext_xhdl2 : STD_LOGIC;
BEGIN
   -- Drive referenced outputs
   scanout <= scanout_xhdl4;
   rscout <= rscout_xhdl3;
   derr_cor_ext <= derr_cor_ext_xhdl2;
   
   -- wire	[32:0]	rxcorea;
   -- wire	[32:0]	rxcoreb;
   
   addrstallA <= addrstallA_bist WHEN (testen = '1') ELSE
                 '0';
   addrstallB <= addrstallB_bist WHEN (testen = '1') ELSE
                 '0';
   adwr <= addrA_bist WHEN (testen = '1') ELSE
           addrA;
   adrd <= addrB_bist WHEN (testen = '1') ELSE
           addrB;
   write_en <= wren_bist WHEN (testen = '1') ELSE
               wren;
   din <= writedata WHEN (testen = '1') ELSE
          data;
   
   -- assign rxcorea = 33'h000000000;		// hard-wired to 0's for now; change this to program MRAM setting
   -- assign rxcoreb = 33'h000000000;		// hard-wired to 0's for now; change this to program MRAM setting
   
   -- Instantiate the BIST muxes for Ports A and B
   
   core_clk_int <= core_clk;
   dout(70 DOWNTO 63) <= temp(63 DOWNTO 56);
   dout(61 DOWNTO 54) <= temp(55 DOWNTO 48);
   dout(52 DOWNTO 45) <= temp(47 DOWNTO 40);
   dout(43 DOWNTO 36) <= temp(39 DOWNTO 32);
   dout(34 DOWNTO 27) <= temp(31 DOWNTO 24);
   dout(25 DOWNTO 18) <= temp(23 DOWNTO 16);
   dout(16 DOWNTO 9) <= temp(15 DOWNTO 8);
   dout(7 DOWNTO 0) <= temp(7 DOWNTO 0);
   
   
   xhdl13 <= (dout_int(70 DOWNTO 63) & dout_int(61 DOWNTO 54) & dout_int(52 DOWNTO 45) & dout_int(43 DOWNTO 36) & dout_int(34 DOWNTO 27) & dout_int(25 DOWNTO 18) & dout_int(16 DOWNTO 9) & dout_int(7 DOWNTO 0));
   xhdl14 <= (dout_int(71) & dout_int(62) & dout_int(53) & dout_int(44) & dout_int(35) & dout_int(26) & dout_int(17) & dout_int(8));
   u_ecc_chk : stratixiv_pciehip_ecc_chk
      PORT MAP (
         enable_ecc  => dprio_mram_in(16),
         datain      => xhdl13,
         syndrome    => xhdl14,
         dataout     => temp,
         single_err  => derr_cor_int,
         multi_err   => derr_int
      );
   
   dout(71) <= '0';
   dout(62) <= '0';
   dout(53) <= '0';
   dout(44) <= '0';
   dout(35) <= '0';
   dout(26) <= '0';
   dout(17) <= '0';
   dout(8) <= '0';
   
   -- Full-model buffer w/ REGSCAN, redundancy scan
   
   
   memory : stratixiv_pciehip_hip_mram
      GENERIC MAP (
         ADDR_WIDTH  => 14,
         DATA_WIDTH  => 72
      )
      PORT MAP (
         dprio_mram_in         => dprio_mram_in(16 DOWNTO 0),
         wrclock               => core_clk_int,
         wren                  => write_en,
         rden                  => '1',
         --        .rden(dprio_mram_in[18]),
         wraddress             => adwr,
         data                  => din,
         rdaddress             => adrd,
         addrstallA            => addrstallA,
         addrstallB            => addrstallB,
         r0_regscanin          => scanin,
         r1_regscanin          => r0_regscanout,
         r2_regscanin          => r1_regscanout,
         r3_regscanin          => r2_regscanout,
         r4_regscanin          => r3_regscanout,
         r5_regscanin          => r4_regscanout,
         r6_regscanin          => r5_regscanout,
         r7_regscanin          => r6_regscanout,
         rsclk                 => rsclk,
         rscen                 => rscen,
         rscin                 => rscin,
         rscsel                => rscsel,
         rscrst                => rscrst,
         id                    => id,
         q                     => dout_int,
         flag                  => flag,
         DFT_out               => DFT_out,
         rscout                => rscout_xhdl3,
         r0_regscanout         => r0_regscanout,
         r1_regscanout         => r1_regscanout,
         r2_regscanout         => r2_regscanout,
         r3_regscanout         => r3_regscanout,
         r4_regscanout         => r4_regscanout,
         r5_regscanout         => r5_regscanout,
         r6_regscanout         => r6_regscanout,
         r7_regscanout         => scanout_xhdl4,
         nfrzdrv               => nfrzdrv,
         frzreg                => frzreg,
         frzlogic              => frzlogic,
         wrap_back_data        => wrap_back_data,
         enscan                => enscan,
         scanen                => scanen,
         prv_mram              => prv_mram,
         rdclock               => rdclock_dummy,		-- shawn
         mram_hip_test_enable  => mram_hip_test_enable
      );
   
   -- Instantiate decoding logic for MRAM ECC flags
   
   
   
   ed : stratixiv_pciehip_ecc_decoder
      PORT MAP (
         flag      => flag,
         derr      => derr_int_nc,
         derr_cor  => derr_cor_int_nc
      );
   
   -- Instantiate Pulse width extenders
   
   
   
   pe0 : stratixiv_pciehip_pulse_ext
      PORT MAP (
         core_clk      => core_clk,
         rstn          => rstn,
         srst          => srst,
         derr_cor      => derr_int,
         derr_cor_ext  => derr_int_ext
      );
   
   derr <= derr_int_ext WHEN (uncor_err_ext_en = '1') ELSE
           derr_int;
   
   
   
   pe1 : stratixiv_pciehip_pulse_ext
      PORT MAP (
         core_clk      => core_clk,
         rstn          => rstn,
         srst          => srst,
         derr_cor      => derr_cor_int,
         derr_cor_ext  => derr_cor_ext_xhdl2
      );
   
END trans;




LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.stratixiv_pcie_hip_components.all;

ENTITY stratixiv_pciehip_pciexp_dcfiforam IS
   GENERIC (
      
      addr_width  : INTEGER := 4;
      data_width  : INTEGER := 32
   );
   PORT (
      data        : IN STD_LOGIC_VECTOR((data_width - 1) DOWNTO 0);
      wren        : IN STD_LOGIC;
      wraddress   : IN STD_LOGIC_VECTOR((addr_width - 1) DOWNTO 0);
      rdaddress   : IN STD_LOGIC_VECTOR((addr_width - 1) DOWNTO 0);
      wrclock     : IN STD_LOGIC;
      rdclock     : IN STD_LOGIC;
      q           : OUT STD_LOGIC_VECTOR(data_width - 1 DOWNTO 0)
   );
END stratixiv_pciehip_pciexp_dcfiforam;

ARCHITECTURE trans OF stratixiv_pciehip_pciexp_dcfiforam IS
   TYPE type_xhdl0 IS ARRAY (0 TO 2 ** addr_width - 1) OF STD_LOGIC_VECTOR(data_width - 1 DOWNTO 0);
   
   
   SIGNAL ram_block : type_xhdl0;
   SIGNAL rdaddr_r  : STD_LOGIC_VECTOR(addr_width - 1 DOWNTO 0);
   SIGNAL wraddr_r  : STD_LOGIC_VECTOR(addr_width - 1 DOWNTO 0);
   SIGNAL wren_r    : STD_LOGIC;
   SIGNAL wrdata_r  : STD_LOGIC_VECTOR(data_width - 1 DOWNTO 0);
BEGIN
   
   -- Write process
   PROCESS (wrclock)
VARIABLE  txt : LINE;
   BEGIN
      IF (wrclock'EVENT AND wrclock = '1') THEN
         wren_r <= wren;
         wraddr_r <= wraddress;
         wrdata_r <=  data;
         IF (wren_r = '1') THEN
            ram_block(bin2int(wraddr_r)) <= wrdata_r;
         END IF;
      END IF;
   END PROCESS;
   
   -- Read process
   PROCESS (rdclock)
VARIABLE  txt : LINE;
   BEGIN
      IF (rdclock'EVENT AND rdclock = '1') THEN
         rdaddr_r <=  rdaddress;
      END IF;
   END PROCESS;
   q <= ram_block(bin2int(rdaddr_r));
   
END trans;




LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.stratixiv_pcie_hip_components.all;

ENTITY stratixiv_pciehip_pciexp_dcram_rtry IS
   GENERIC (
      
      addr_width  : INTEGER := 4;
      data_width  : INTEGER := 32
   );
   PORT (
      
      wrclock     : IN STD_LOGIC;
      wren        : IN STD_LOGIC;
      wraddress   : IN STD_LOGIC_VECTOR(addr_width - 1 DOWNTO 0);
      data        : IN STD_LOGIC_VECTOR(data_width - 1 DOWNTO 0);
      rdclock     : IN STD_LOGIC;
      rdaddress   : IN STD_LOGIC_VECTOR(addr_width - 1 DOWNTO 0);
      q           : OUT STD_LOGIC_VECTOR(data_width - 1 DOWNTO 0)
   );
END stratixiv_pciehip_pciexp_dcram_rtry;

ARCHITECTURE trans OF stratixiv_pciehip_pciexp_dcram_rtry IS
   TYPE type_xhdl1 IS ARRAY ((2**addr_width) - 1 DOWNTO 0) OF STD_LOGIC_VECTOR(data_width - 1 DOWNTO 0);
   
   
   -- -------------------------------------------------------------
   
   SIGNAL ram_block   : type_xhdl1;
   SIGNAL read_addr_r : STD_LOGIC_VECTOR(addr_width - 1 DOWNTO 0);
   SIGNAL wraddr_r    : STD_LOGIC_VECTOR(addr_width - 1 DOWNTO 0);
   SIGNAL wren_r      : STD_LOGIC;
   SIGNAL wrdata_r    : STD_LOGIC_VECTOR(data_width - 1 DOWNTO 0);
BEGIN
   
   -- Write process
   PROCESS (wrclock)
VARIABLE  txt : LINE;
   BEGIN
      IF (wrclock'EVENT AND wrclock = '1') THEN
         wren_r <= wren;
         wraddr_r <= wraddress;
         
         wrdata_r <= data;
         IF (wren_r = '1') THEN
            ram_block(bin2int(wraddr_r)) <= wrdata_r;
         END IF;
      END IF;
   END PROCESS;
   
   --  Read process
   PROCESS (rdclock)
VARIABLE  txt : LINE;
   BEGIN
      IF (rdclock'EVENT AND rdclock = '1') THEN
         read_addr_r <= rdaddress;
      END IF;
   END PROCESS;
   
   q <= ram_block(bin2int(read_addr_r));
   
END trans;




LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.stratixiv_pcie_hip_components.all;

ENTITY stratixiv_pciehip_pciexp_dcram_rxvc IS
   GENERIC (
      
      addr_width  : INTEGER := 4;
      data_width  : INTEGER := 32
   );
   PORT (
      
      wrclock     : IN STD_LOGIC;
      wren        : IN STD_LOGIC;
      wraddress   : IN STD_LOGIC_VECTOR(addr_width - 1 DOWNTO 0);
      data        : IN STD_LOGIC_VECTOR(data_width - 1 DOWNTO 0);
      rdclock     : IN STD_LOGIC;
      rdaddress   : IN STD_LOGIC_VECTOR(addr_width - 1 DOWNTO 0);
      q           : OUT STD_LOGIC_VECTOR(data_width - 1 DOWNTO 0)
   );
END stratixiv_pciehip_pciexp_dcram_rxvc;

ARCHITECTURE trans OF stratixiv_pciehip_pciexp_dcram_rxvc IS
   TYPE type_xhdl2 IS ARRAY ((2**addr_width) - 1 DOWNTO 0) OF STD_LOGIC_VECTOR(data_width - 1 DOWNTO 0);
   
   
   -- -------------------------------------------------------------
   
   SIGNAL ram_block   : type_xhdl2;
   SIGNAL read_addr_r : STD_LOGIC_VECTOR(addr_width - 1 DOWNTO 0);
   SIGNAL wraddr_r    : STD_LOGIC_VECTOR(addr_width - 1 DOWNTO 0);
   SIGNAL wren_r      : STD_LOGIC;
   SIGNAL wrdata_r    : STD_LOGIC_VECTOR(data_width - 1 DOWNTO 0);
BEGIN
   
   -- Write process
   PROCESS (wrclock)
VARIABLE  txt : LINE;
   BEGIN
      IF (wrclock'EVENT AND wrclock = '1') THEN
         wren_r <= wren;
         wraddr_r <= wraddress;
         
         wrdata_r <= data;
         IF (wren_r = '1') THEN
            ram_block(bin2int(wraddr_r)) <= wrdata_r;
         END IF;
      END IF;
   END PROCESS;
   
   --  Read process
   PROCESS (rdclock)
VARIABLE  txt : LINE;
   BEGIN
      IF (rdclock'EVENT AND rdclock = '1') THEN
         read_addr_r <= rdaddress;
      END IF;
   END PROCESS;
   
   q <= ram_block(bin2int(read_addr_r));
   
END trans;


--IP Functional Simulation Model
--VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END


-- Copyright (C) 1991-2009 Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.

-- You may only use these simulation model output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event Altera disclaims all warranties of any kind).


--synopsys translate_off

 LIBRARY sgate;
 USE sgate.sgate_pack.all;

--synthesis_resources = lut 808 mux21 840 oper_add 40 oper_less_than 16 oper_mux 24 oper_selector 32 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  stratixiv_pciehip_iei_detect IS 
	 PORT 
	 ( 
		 datain_ch0	:	IN  STD_LOGIC_VECTOR (8 DOWNTO 0);
		 datain_ch1	:	IN  STD_LOGIC_VECTOR (8 DOWNTO 0);
		 datain_ch2	:	IN  STD_LOGIC_VECTOR (8 DOWNTO 0);
		 datain_ch3	:	IN  STD_LOGIC_VECTOR (8 DOWNTO 0);
		 datain_ch4	:	IN  STD_LOGIC_VECTOR (8 DOWNTO 0);
		 datain_ch5	:	IN  STD_LOGIC_VECTOR (8 DOWNTO 0);
		 datain_ch6	:	IN  STD_LOGIC_VECTOR (8 DOWNTO 0);
		 datain_ch7	:	IN  STD_LOGIC_VECTOR (8 DOWNTO 0);
		 eidleinfersel	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 enable_inf_ei	:	IN  STD_LOGIC_VECTOR (5 DOWNTO 0);
		 pclk	:	IN  STD_LOGIC;
		 prstn	:	IN  STD_LOGIC;
		 rate	:	IN  STD_LOGIC;
		 rxelecidle	:	OUT  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 rxelecidle_in	:	IN  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 rxupdatefc	:	IN  STD_LOGIC;
		 rxvalid	:	IN  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 test_in_0	:	IN  STD_LOGIC;
		 uclk	:	IN  STD_LOGIC;
		 urstn	:	IN  STD_LOGIC
	 ); 
 END stratixiv_pciehip_iei_detect;

 ARCHITECTURE RTL OF stratixiv_pciehip_iei_detect IS

	 ATTRIBUTE synthesis_clearbox : natural;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS 1;
	 SIGNAL	 nli00OO67	:	STD_LOGIC := '0';
	 SIGNAL	 nli00OO68	:	STD_LOGIC := '0';
	 SIGNAL	 nli0i1i65	:	STD_LOGIC := '0';
	 SIGNAL	 nli0i1i66	:	STD_LOGIC := '0';
	 SIGNAL	 nli0O0i63	:	STD_LOGIC := '0';
	 SIGNAL	 nli0O0i64	:	STD_LOGIC := '0';
	 SIGNAL	 nli0O0l61	:	STD_LOGIC := '0';
	 SIGNAL	 nli0O0l62	:	STD_LOGIC := '0';
	 SIGNAL	 nli1iiO71	:	STD_LOGIC := '0';
	 SIGNAL	 nli1iiO72	:	STD_LOGIC := '0';
	 SIGNAL	 nli1OlO69	:	STD_LOGIC := '0';
	 SIGNAL	 nli1OlO70	:	STD_LOGIC := '0';
	 SIGNAL	 nlii0il59	:	STD_LOGIC := '0';
	 SIGNAL	 nlii0il60	:	STD_LOGIC := '0';
	 SIGNAL	 nliilll57	:	STD_LOGIC := '0';
	 SIGNAL	 nliilll58	:	STD_LOGIC := '0';
	 SIGNAL	 nlil1Ol55	:	STD_LOGIC := '0';
	 SIGNAL	 nlil1Ol56	:	STD_LOGIC := '0';
	 SIGNAL	 nliliOl53	:	STD_LOGIC := '0';
	 SIGNAL	 nliliOl54	:	STD_LOGIC := '0';
	 SIGNAL	 nliliOO51	:	STD_LOGIC := '0';
	 SIGNAL	 nliliOO52	:	STD_LOGIC := '0';
	 SIGNAL	 nlill0O45	:	STD_LOGIC := '0';
	 SIGNAL	 nlill0O46	:	STD_LOGIC := '0';
	 SIGNAL	 nlill1i49	:	STD_LOGIC := '0';
	 SIGNAL	 nlill1i50	:	STD_LOGIC := '0';
	 SIGNAL	 nlill1l47	:	STD_LOGIC := '0';
	 SIGNAL	 nlill1l48	:	STD_LOGIC := '0';
	 SIGNAL	 nlillOl43	:	STD_LOGIC := '0';
	 SIGNAL	 nlillOl44	:	STD_LOGIC := '0';
	 SIGNAL	 nlilO0i41	:	STD_LOGIC := '0';
	 SIGNAL	 nlilO0i42	:	STD_LOGIC := '0';
	 SIGNAL	 nlilOiO39	:	STD_LOGIC := '0';
	 SIGNAL	 nlilOiO40	:	STD_LOGIC := '0';
	 SIGNAL	 nliO01O23	:	STD_LOGIC := '0';
	 SIGNAL	 nliO01O24	:	STD_LOGIC := '0';
	 SIGNAL  wire_nliO01O24_w_lg_w_lg_q161w162w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliO01O24_w_lg_q161w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nliO0iO21	:	STD_LOGIC := '0';
	 SIGNAL	 nliO0iO22	:	STD_LOGIC := '0';
	 SIGNAL  wire_nliO0iO22_w_lg_w_lg_q123w124w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliO0iO22_w_lg_q123w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nliO0li19	:	STD_LOGIC := '0';
	 SIGNAL	 nliO0li20	:	STD_LOGIC := '0';
	 SIGNAL  wire_nliO0li20_w_lg_w_lg_q120w121w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliO0li20_w_lg_q120w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nliO0ll17	:	STD_LOGIC := '0';
	 SIGNAL	 nliO0ll18	:	STD_LOGIC := '0';
	 SIGNAL  wire_nliO0ll18_w_lg_w_lg_q91w92w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliO0ll18_w_lg_q91w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nliO0lO15	:	STD_LOGIC := '0';
	 SIGNAL	 nliO0lO16	:	STD_LOGIC := '0';
	 SIGNAL  wire_nliO0lO16_w_lg_w_lg_q85w86w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliO0lO16_w_lg_q85w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nliO0Oi13	:	STD_LOGIC := '0';
	 SIGNAL	 nliO0Oi14	:	STD_LOGIC := '0';
	 SIGNAL  wire_nliO0Oi14_w_lg_w_lg_q54w55w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliO0Oi14_w_lg_q54w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nliO0Ol11	:	STD_LOGIC := '0';
	 SIGNAL	 nliO0Ol12	:	STD_LOGIC := '0';
	 SIGNAL  wire_nliO0Ol12_w_lg_w_lg_q50w51w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliO0Ol12_w_lg_q50w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nliO0OO10	:	STD_LOGIC := '0';
	 SIGNAL  wire_nliO0OO10_w_lg_w_lg_q46w47w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliO0OO10_w_lg_q46w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nliO0OO9	:	STD_LOGIC := '0';
	 SIGNAL	 nliO10i35	:	STD_LOGIC := '0';
	 SIGNAL	 nliO10i36	:	STD_LOGIC := '0';
	 SIGNAL  wire_nliO10i36_w_lg_w_lg_q257w258w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliO10i36_w_lg_q257w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nliO10l33	:	STD_LOGIC := '0';
	 SIGNAL	 nliO10l34	:	STD_LOGIC := '0';
	 SIGNAL  wire_nliO10l34_w_lg_w_lg_q231w232w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliO10l34_w_lg_q231w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nliO10O31	:	STD_LOGIC := '0';
	 SIGNAL	 nliO10O32	:	STD_LOGIC := '0';
	 SIGNAL  wire_nliO10O32_w_lg_w_lg_q225w226w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliO10O32_w_lg_q225w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nliO11i37	:	STD_LOGIC := '0';
	 SIGNAL	 nliO11i38	:	STD_LOGIC := '0';
	 SIGNAL	 nliO1il29	:	STD_LOGIC := '0';
	 SIGNAL	 nliO1il30	:	STD_LOGIC := '0';
	 SIGNAL	 nliO1li27	:	STD_LOGIC := '0';
	 SIGNAL	 nliO1li28	:	STD_LOGIC := '0';
	 SIGNAL	 nliO1lO25	:	STD_LOGIC := '0';
	 SIGNAL	 nliO1lO26	:	STD_LOGIC := '0';
	 SIGNAL	 nliOi0i3	:	STD_LOGIC := '0';
	 SIGNAL	 nliOi0i4	:	STD_LOGIC := '0';
	 SIGNAL	 nliOi1i7	:	STD_LOGIC := '0';
	 SIGNAL	 nliOi1i8	:	STD_LOGIC := '0';
	 SIGNAL	 nliOi1l5	:	STD_LOGIC := '0';
	 SIGNAL	 nliOi1l6	:	STD_LOGIC := '0';
	 SIGNAL	 nliOiiO1	:	STD_LOGIC := '0';
	 SIGNAL	 nliOiiO2	:	STD_LOGIC := '0';
	 SIGNAL	n0iO0O	:	STD_LOGIC := '0';
	 SIGNAL	n0iOil	:	STD_LOGIC := '0';
	 SIGNAL	wire_n0iOii_PRN	:	STD_LOGIC;
	 SIGNAL	n1l0l	:	STD_LOGIC := '0';
	 SIGNAL	n1l1O	:	STD_LOGIC := '0';
	 SIGNAL	wire_n1l0i_PRN	:	STD_LOGIC;
	 SIGNAL	n1ll0l	:	STD_LOGIC := '0';
	 SIGNAL	n1ll1O	:	STD_LOGIC := '0';
	 SIGNAL	wire_n1ll0i_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_n1ll0i_PRN	:	STD_LOGIC;
	 SIGNAL	nii1iO	:	STD_LOGIC := '0';
	 SIGNAL	nii1ll	:	STD_LOGIC := '0';
	 SIGNAL	wire_nii1li_CLRN	:	STD_LOGIC;
	 SIGNAL	nl00lO	:	STD_LOGIC := '0';
	 SIGNAL	nl00Ol	:	STD_LOGIC := '0';
	 SIGNAL	wire_nl00Oi_PRN	:	STD_LOGIC;
	 SIGNAL	n0001l	:	STD_LOGIC := '0';
	 SIGNAL	n011OO	:	STD_LOGIC := '0';
	 SIGNAL	n0i0iO	:	STD_LOGIC := '0';
	 SIGNAL	n0iiiO	:	STD_LOGIC := '0';
	 SIGNAL	n0iOiO	:	STD_LOGIC := '0';
	 SIGNAL	n0iOli	:	STD_LOGIC := '0';
	 SIGNAL	n0iOll	:	STD_LOGIC := '0';
	 SIGNAL	n0iOlO	:	STD_LOGIC := '0';
	 SIGNAL	n0Oi1O	:	STD_LOGIC := '0';
	 SIGNAL	n100O	:	STD_LOGIC := '0';
	 SIGNAL	n10OOl	:	STD_LOGIC := '0';
	 SIGNAL	n110O	:	STD_LOGIC := '0';
	 SIGNAL	n11OlO	:	STD_LOGIC := '0';
	 SIGNAL	n1l00O	:	STD_LOGIC := '0';
	 SIGNAL	n1l0O	:	STD_LOGIC := '0';
	 SIGNAL	n1l10O	:	STD_LOGIC := '0';
	 SIGNAL	n1lii	:	STD_LOGIC := '0';
	 SIGNAL	n1lil	:	STD_LOGIC := '0';
	 SIGNAL	n1liO	:	STD_LOGIC := '0';
	 SIGNAL	n1ll0O	:	STD_LOGIC := '0';
	 SIGNAL	n1llii	:	STD_LOGIC := '0';
	 SIGNAL	n1llil	:	STD_LOGIC := '0';
	 SIGNAL	n1lliO	:	STD_LOGIC := '0';
	 SIGNAL	ni0ilO	:	STD_LOGIC := '0';
	 SIGNAL	ni0llO	:	STD_LOGIC := '0';
	 SIGNAL	ni1i0l	:	STD_LOGIC := '0';
	 SIGNAL	ni1OO	:	STD_LOGIC := '0';
	 SIGNAL	nii1lO	:	STD_LOGIC := '0';
	 SIGNAL	nii1Oi	:	STD_LOGIC := '0';
	 SIGNAL	nii1Ol	:	STD_LOGIC := '0';
	 SIGNAL	nii1OO	:	STD_LOGIC := '0';
	 SIGNAL	nill0O	:	STD_LOGIC := '0';
	 SIGNAL	niOlil	:	STD_LOGIC := '0';
	 SIGNAL	nl00OO	:	STD_LOGIC := '0';
	 SIGNAL	nl01O	:	STD_LOGIC := '0';
	 SIGNAL	nl0i1i	:	STD_LOGIC := '0';
	 SIGNAL	nl0i1l	:	STD_LOGIC := '0';
	 SIGNAL	nl0i1O	:	STD_LOGIC := '0';
	 SIGNAL	nl1lOO	:	STD_LOGIC := '0';
	 SIGNAL	nl1OOO	:	STD_LOGIC := '0';
	 SIGNAL	nliOiO	:	STD_LOGIC := '0';
	 SIGNAL	nll10lO	:	STD_LOGIC := '0';
	 SIGNAL	nll1ilO	:	STD_LOGIC := '0';
	 SIGNAL	nll1OlO	:	STD_LOGIC := '0';
	 SIGNAL	nll1OOi	:	STD_LOGIC := '0';
	 SIGNAL	nll1OOl	:	STD_LOGIC := '0';
	 SIGNAL	nll1OOO	:	STD_LOGIC := '0';
	 SIGNAL	nllii0O	:	STD_LOGIC := '0';
	 SIGNAL	nllliil	:	STD_LOGIC := '0';
	 SIGNAL	nllOiOO	:	STD_LOGIC := '0';
	 SIGNAL	nllOll	:	STD_LOGIC := '0';
	 SIGNAL	nllOlOO	:	STD_LOGIC := '0';
	 SIGNAL	nlO0liO	:	STD_LOGIC := '0';
	 SIGNAL	nlO101i	:	STD_LOGIC := '0';
	 SIGNAL	nlO101l	:	STD_LOGIC := '0';
	 SIGNAL	nlO101O	:	STD_LOGIC := '0';
	 SIGNAL	nlO11OO	:	STD_LOGIC := '0';
	 SIGNAL	nlOilll	:	STD_LOGIC := '0';
	 SIGNAL	nlOlO1O	:	STD_LOGIC := '0';
	 SIGNAL	nlOO11O	:	STD_LOGIC := '0';
	 SIGNAL	nlOOi0i	:	STD_LOGIC := '0';
	 SIGNAL	nlOOi0l	:	STD_LOGIC := '0';
	 SIGNAL	nlOOi0O	:	STD_LOGIC := '0';
	 SIGNAL	nlOOi1O	:	STD_LOGIC := '0';
	 SIGNAL	wire_nl01l_PRN	:	STD_LOGIC;
	 SIGNAL  wire_nl01l_w_lg_w_lg_w_lg_n0iOlO1995w1999w2000w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_w_lg_n0iOlO1988w1990w1992w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_w_lg_n1liO370w374w375w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_w_lg_n1liO363w365w367w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_w_lg_n1lliO2531w2535w2536w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_w_lg_n1lliO2524w2526w2528w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_w_lg_nii1OO1458w1462w1463w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_w_lg_nii1OO1451w1453w1455w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_w_lg_nl0i1O922w926w927w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_w_lg_nl0i1O915w917w919w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_w_lg_nll1OOO4143w4147w4148w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_w_lg_nll1OOO4136w4138w4140w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_w_lg_nlO101O3607w3611w3612w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_w_lg_nlO101O3600w3602w3604w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_w_lg_nlOOi0O3069w3073w3074w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_w_lg_nlOOi0O3062w3064w3066w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_n0iOlO1995w1999w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_n0iOlO1995w1996w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_n0iOlO1988w1990w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_n1liO370w374w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_n1liO370w371w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_n1liO363w365w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_n1lliO2531w2535w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_n1lliO2531w2532w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_n1lliO2524w2526w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_nii1OO1458w1462w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_nii1OO1458w1459w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_nii1OO1451w1453w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_nl0i1O922w926w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_nl0i1O922w923w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_nl0i1O915w917w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_nll1OOO4143w4147w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_nll1OOO4143w4144w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_nll1OOO4136w4138w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_nlO101O3607w3611w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_nlO101O3607w3608w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_nlO101O3600w3602w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_nlOOi0O3069w3073w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_nlOOi0O3069w3070w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_nlOOi0O3062w3064w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_n0iOlO1995w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_n0iOlO1988w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_n1liO370w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_n1liO363w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_n1lliO2531w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_n1lliO2524w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nii1OO1458w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nii1OO1451w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nl0i1O922w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nl0i1O915w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nll1OOO4143w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nll1OOO4136w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nlO101O3607w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nlO101O3600w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nlOOi0O3069w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nlOOi0O3062w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_n0i0iO2046w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_n0iOiO1991w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_n0iOli1989w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_n0iOll1994w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_n0iOlO2226w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_n110O421w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_n1l0O366w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_n1l10O2584w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_n1lii364w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_n1lil369w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_n1liO612w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_n1ll0O2527w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_n1llii2525w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_n1llil2530w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_n1lliO2764w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_ni0ilO1510w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nii1lO1454w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nii1Oi1452w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nii1Ol1457w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nii1OO1690w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nl00OO918w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nl0i1i916w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nl0i1l921w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nl0i1O1153w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nl1lOO973w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nll10lO4195w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nll1OlO4139w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nll1OOi4137w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nll1OOl4142w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nll1OOO4375w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nllOiOO3658w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nlO101i3601w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nlO101l3606w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nlO101O3838w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nlO11OO3603w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nlOlO1O3122w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nlOOi0i3063w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nlOOi0l3068w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nlOOi0O3302w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_nlOOi1O3065w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_w_lg_w_lg_n0iOlO1988w1990w1992w1993w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_w_lg_w_lg_n1liO363w365w367w368w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_w_lg_w_lg_n1lliO2524w2526w2528w2529w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_w_lg_w_lg_nii1OO1451w1453w1455w1456w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_w_lg_w_lg_nl0i1O915w917w919w920w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_w_lg_w_lg_nll1OOO4136w4138w4140w4141w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_w_lg_w_lg_nlO101O3600w3602w3604w3605w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl01l_w_lg_w_lg_w_lg_w_lg_nlOOi0O3062w3064w3066w3067w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n000il	:	STD_LOGIC := '0';
	 SIGNAL	n000iO	:	STD_LOGIC := '0';
	 SIGNAL	n000li	:	STD_LOGIC := '0';
	 SIGNAL	n000ll	:	STD_LOGIC := '0';
	 SIGNAL	n000lO	:	STD_LOGIC := '0';
	 SIGNAL	n000Oi	:	STD_LOGIC := '0';
	 SIGNAL	n000Ol	:	STD_LOGIC := '0';
	 SIGNAL	n000OO	:	STD_LOGIC := '0';
	 SIGNAL	n00i0i	:	STD_LOGIC := '0';
	 SIGNAL	n00i0l	:	STD_LOGIC := '0';
	 SIGNAL	n00i0O	:	STD_LOGIC := '0';
	 SIGNAL	n00i1i	:	STD_LOGIC := '0';
	 SIGNAL	n00i1l	:	STD_LOGIC := '0';
	 SIGNAL	n00i1O	:	STD_LOGIC := '0';
	 SIGNAL	n00ili	:	STD_LOGIC := '0';
	 SIGNAL	n00iOi	:	STD_LOGIC := '0';
	 SIGNAL	n00iOl	:	STD_LOGIC := '0';
	 SIGNAL	n0110i	:	STD_LOGIC := '0';
	 SIGNAL	n0110l	:	STD_LOGIC := '0';
	 SIGNAL	n0110O	:	STD_LOGIC := '0';
	 SIGNAL	n0111i	:	STD_LOGIC := '0';
	 SIGNAL	n0111l	:	STD_LOGIC := '0';
	 SIGNAL	n0111O	:	STD_LOGIC := '0';
	 SIGNAL	n011ii	:	STD_LOGIC := '0';
	 SIGNAL	n011il	:	STD_LOGIC := '0';
	 SIGNAL	n011iO	:	STD_LOGIC := '0';
	 SIGNAL	n011li	:	STD_LOGIC := '0';
	 SIGNAL	n011ll	:	STD_LOGIC := '0';
	 SIGNAL	n011lO	:	STD_LOGIC := '0';
	 SIGNAL	n011Oi	:	STD_LOGIC := '0';
	 SIGNAL	n011Ol	:	STD_LOGIC := '0';
	 SIGNAL	n0i0i	:	STD_LOGIC := '0';
	 SIGNAL	n0i0ii	:	STD_LOGIC := '0';
	 SIGNAL	n0i0il	:	STD_LOGIC := '0';
	 SIGNAL	n0i0l	:	STD_LOGIC := '0';
	 SIGNAL	n0i0li	:	STD_LOGIC := '0';
	 SIGNAL	n0i0O	:	STD_LOGIC := '0';
	 SIGNAL	n0iili	:	STD_LOGIC := '0';
	 SIGNAL	n0iill	:	STD_LOGIC := '0';
	 SIGNAL	n0iilO	:	STD_LOGIC := '0';
	 SIGNAL	n0iiOi	:	STD_LOGIC := '0';
	 SIGNAL	n0iiOl	:	STD_LOGIC := '0';
	 SIGNAL	n0iiOO	:	STD_LOGIC := '0';
	 SIGNAL	n0il1i	:	STD_LOGIC := '0';
	 SIGNAL	n0iO0l	:	STD_LOGIC := '0';
	 SIGNAL	n0iO1l	:	STD_LOGIC := '0';
	 SIGNAL	n0iOOi	:	STD_LOGIC := '0';
	 SIGNAL	n0iOOl	:	STD_LOGIC := '0';
	 SIGNAL	n0l0i	:	STD_LOGIC := '0';
	 SIGNAL	n0l0l	:	STD_LOGIC := '0';
	 SIGNAL	n0l0O	:	STD_LOGIC := '0';
	 SIGNAL	n0l1l	:	STD_LOGIC := '0';
	 SIGNAL	n0l1O	:	STD_LOGIC := '0';
	 SIGNAL	n0lii	:	STD_LOGIC := '0';
	 SIGNAL	n0lil	:	STD_LOGIC := '0';
	 SIGNAL	n0liO	:	STD_LOGIC := '0';
	 SIGNAL	n0lli	:	STD_LOGIC := '0';
	 SIGNAL	n0llii	:	STD_LOGIC := '0';
	 SIGNAL	n0llil	:	STD_LOGIC := '0';
	 SIGNAL	n0lliO	:	STD_LOGIC := '0';
	 SIGNAL	n0lll	:	STD_LOGIC := '0';
	 SIGNAL	n0llO	:	STD_LOGIC := '0';
	 SIGNAL	n0lO0l	:	STD_LOGIC := '0';
	 SIGNAL	n0lO0O	:	STD_LOGIC := '0';
	 SIGNAL	n0lOi	:	STD_LOGIC := '0';
	 SIGNAL	n0lOii	:	STD_LOGIC := '0';
	 SIGNAL	n0lOil	:	STD_LOGIC := '0';
	 SIGNAL	n0lOiO	:	STD_LOGIC := '0';
	 SIGNAL	n0lOl	:	STD_LOGIC := '0';
	 SIGNAL	n0lOli	:	STD_LOGIC := '0';
	 SIGNAL	n0lOll	:	STD_LOGIC := '0';
	 SIGNAL	n0lOlO	:	STD_LOGIC := '0';
	 SIGNAL	n0lOO	:	STD_LOGIC := '0';
	 SIGNAL	n0lOOi	:	STD_LOGIC := '0';
	 SIGNAL	n0lOOl	:	STD_LOGIC := '0';
	 SIGNAL	n0lOOO	:	STD_LOGIC := '0';
	 SIGNAL	n0O00i	:	STD_LOGIC := '0';
	 SIGNAL	n0O00l	:	STD_LOGIC := '0';
	 SIGNAL	n0O00O	:	STD_LOGIC := '0';
	 SIGNAL	n0O01i	:	STD_LOGIC := '0';
	 SIGNAL	n0O01l	:	STD_LOGIC := '0';
	 SIGNAL	n0O01O	:	STD_LOGIC := '0';
	 SIGNAL	n0O0i	:	STD_LOGIC := '0';
	 SIGNAL	n0O0ii	:	STD_LOGIC := '0';
	 SIGNAL	n0O0il	:	STD_LOGIC := '0';
	 SIGNAL	n0O0iO	:	STD_LOGIC := '0';
	 SIGNAL	n0O0l	:	STD_LOGIC := '0';
	 SIGNAL	n0O0li	:	STD_LOGIC := '0';
	 SIGNAL	n0O0ll	:	STD_LOGIC := '0';
	 SIGNAL	n0O0lO	:	STD_LOGIC := '0';
	 SIGNAL	n0O0O	:	STD_LOGIC := '0';
	 SIGNAL	n0O0Oi	:	STD_LOGIC := '0';
	 SIGNAL	n0O0Ol	:	STD_LOGIC := '0';
	 SIGNAL	n0O0OO	:	STD_LOGIC := '0';
	 SIGNAL	n0O10i	:	STD_LOGIC := '0';
	 SIGNAL	n0O10l	:	STD_LOGIC := '0';
	 SIGNAL	n0O10O	:	STD_LOGIC := '0';
	 SIGNAL	n0O11i	:	STD_LOGIC := '0';
	 SIGNAL	n0O11l	:	STD_LOGIC := '0';
	 SIGNAL	n0O11O	:	STD_LOGIC := '0';
	 SIGNAL	n0O1i	:	STD_LOGIC := '0';
	 SIGNAL	n0O1ii	:	STD_LOGIC := '0';
	 SIGNAL	n0O1il	:	STD_LOGIC := '0';
	 SIGNAL	n0O1iO	:	STD_LOGIC := '0';
	 SIGNAL	n0O1l	:	STD_LOGIC := '0';
	 SIGNAL	n0O1li	:	STD_LOGIC := '0';
	 SIGNAL	n0O1ll	:	STD_LOGIC := '0';
	 SIGNAL	n0O1lO	:	STD_LOGIC := '0';
	 SIGNAL	n0O1O	:	STD_LOGIC := '0';
	 SIGNAL	n0O1Oi	:	STD_LOGIC := '0';
	 SIGNAL	n0O1Ol	:	STD_LOGIC := '0';
	 SIGNAL	n0O1OO	:	STD_LOGIC := '0';
	 SIGNAL	n0Oi1i	:	STD_LOGIC := '0';
	 SIGNAL	n0Oi1l	:	STD_LOGIC := '0';
	 SIGNAL	n0Oii	:	STD_LOGIC := '0';
	 SIGNAL	n0Oil	:	STD_LOGIC := '0';
	 SIGNAL	n0OiO	:	STD_LOGIC := '0';
	 SIGNAL	n0Oli	:	STD_LOGIC := '0';
	 SIGNAL	n0Oll	:	STD_LOGIC := '0';
	 SIGNAL	n0OlO	:	STD_LOGIC := '0';
	 SIGNAL	n0OOi	:	STD_LOGIC := '0';
	 SIGNAL	n0OOl	:	STD_LOGIC := '0';
	 SIGNAL	n0OOO	:	STD_LOGIC := '0';
	 SIGNAL	n10ii	:	STD_LOGIC := '0';
	 SIGNAL	n10il	:	STD_LOGIC := '0';
	 SIGNAL	n10iO	:	STD_LOGIC := '0';
	 SIGNAL	n10li	:	STD_LOGIC := '0';
	 SIGNAL	n10ll	:	STD_LOGIC := '0';
	 SIGNAL	n10lO	:	STD_LOGIC := '0';
	 SIGNAL	n10Oi	:	STD_LOGIC := '0';
	 SIGNAL	n1101i	:	STD_LOGIC := '0';
	 SIGNAL	n1101l	:	STD_LOGIC := '0';
	 SIGNAL	n1101O	:	STD_LOGIC := '0';
	 SIGNAL	n110i	:	STD_LOGIC := '0';
	 SIGNAL	n110l	:	STD_LOGIC := '0';
	 SIGNAL	n110Ol	:	STD_LOGIC := '0';
	 SIGNAL	n110OO	:	STD_LOGIC := '0';
	 SIGNAL	n11i0i	:	STD_LOGIC := '0';
	 SIGNAL	n11i0l	:	STD_LOGIC := '0';
	 SIGNAL	n11i0O	:	STD_LOGIC := '0';
	 SIGNAL	n11i1i	:	STD_LOGIC := '0';
	 SIGNAL	n11i1l	:	STD_LOGIC := '0';
	 SIGNAL	n11i1O	:	STD_LOGIC := '0';
	 SIGNAL	n11ii	:	STD_LOGIC := '0';
	 SIGNAL	n11iii	:	STD_LOGIC := '0';
	 SIGNAL	n11iil	:	STD_LOGIC := '0';
	 SIGNAL	n11iiO	:	STD_LOGIC := '0';
	 SIGNAL	n11ili	:	STD_LOGIC := '0';
	 SIGNAL	n11ill	:	STD_LOGIC := '0';
	 SIGNAL	n11ilO	:	STD_LOGIC := '0';
	 SIGNAL	n11iOi	:	STD_LOGIC := '0';
	 SIGNAL	n11iOl	:	STD_LOGIC := '0';
	 SIGNAL	n11iOO	:	STD_LOGIC := '0';
	 SIGNAL	n11l0i	:	STD_LOGIC := '0';
	 SIGNAL	n11l0l	:	STD_LOGIC := '0';
	 SIGNAL	n11l0O	:	STD_LOGIC := '0';
	 SIGNAL	n11l1i	:	STD_LOGIC := '0';
	 SIGNAL	n11l1l	:	STD_LOGIC := '0';
	 SIGNAL	n11l1O	:	STD_LOGIC := '0';
	 SIGNAL	n11lii	:	STD_LOGIC := '0';
	 SIGNAL	n11lil	:	STD_LOGIC := '0';
	 SIGNAL	n11liO	:	STD_LOGIC := '0';
	 SIGNAL	n11lli	:	STD_LOGIC := '0';
	 SIGNAL	n11lll	:	STD_LOGIC := '0';
	 SIGNAL	n11llO	:	STD_LOGIC := '0';
	 SIGNAL	n11lOi	:	STD_LOGIC := '0';
	 SIGNAL	n11lOl	:	STD_LOGIC := '0';
	 SIGNAL	n11lOO	:	STD_LOGIC := '0';
	 SIGNAL	n11O0i	:	STD_LOGIC := '0';
	 SIGNAL	n11O0l	:	STD_LOGIC := '0';
	 SIGNAL	n11O0O	:	STD_LOGIC := '0';
	 SIGNAL	n11O1i	:	STD_LOGIC := '0';
	 SIGNAL	n11O1l	:	STD_LOGIC := '0';
	 SIGNAL	n11O1O	:	STD_LOGIC := '0';
	 SIGNAL	n11Oii	:	STD_LOGIC := '0';
	 SIGNAL	n11Oil	:	STD_LOGIC := '0';
	 SIGNAL	n11OiO	:	STD_LOGIC := '0';
	 SIGNAL	n11Oli	:	STD_LOGIC := '0';
	 SIGNAL	n11Oll	:	STD_LOGIC := '0';
	 SIGNAL	n1i01i	:	STD_LOGIC := '0';
	 SIGNAL	n1i01l	:	STD_LOGIC := '0';
	 SIGNAL	n1i01O	:	STD_LOGIC := '0';
	 SIGNAL	n1i0ii	:	STD_LOGIC := '0';
	 SIGNAL	n1i0li	:	STD_LOGIC := '0';
	 SIGNAL	n1i0ll	:	STD_LOGIC := '0';
	 SIGNAL	n1i10l	:	STD_LOGIC := '0';
	 SIGNAL	n1i10O	:	STD_LOGIC := '0';
	 SIGNAL	n1i1ii	:	STD_LOGIC := '0';
	 SIGNAL	n1i1il	:	STD_LOGIC := '0';
	 SIGNAL	n1i1iO	:	STD_LOGIC := '0';
	 SIGNAL	n1i1li	:	STD_LOGIC := '0';
	 SIGNAL	n1i1ll	:	STD_LOGIC := '0';
	 SIGNAL	n1i1lO	:	STD_LOGIC := '0';
	 SIGNAL	n1i1Oi	:	STD_LOGIC := '0';
	 SIGNAL	n1i1Ol	:	STD_LOGIC := '0';
	 SIGNAL	n1i1OO	:	STD_LOGIC := '0';
	 SIGNAL	n1iOl	:	STD_LOGIC := '0';
	 SIGNAL	n1l0ii	:	STD_LOGIC := '0';
	 SIGNAL	n1l0il	:	STD_LOGIC := '0';
	 SIGNAL	n1l0iO	:	STD_LOGIC := '0';
	 SIGNAL	n1l0li	:	STD_LOGIC := '0';
	 SIGNAL	n1l0ll	:	STD_LOGIC := '0';
	 SIGNAL	n1l0lO	:	STD_LOGIC := '0';
	 SIGNAL	n1l0Oi	:	STD_LOGIC := '0';
	 SIGNAL	n1l10i	:	STD_LOGIC := '0';
	 SIGNAL	n1l10l	:	STD_LOGIC := '0';
	 SIGNAL	n1l1ii	:	STD_LOGIC := '0';
	 SIGNAL	n1l1l	:	STD_LOGIC := '0';
	 SIGNAL	n1liOl	:	STD_LOGIC := '0';
	 SIGNAL	n1ll1l	:	STD_LOGIC := '0';
	 SIGNAL	n1lli	:	STD_LOGIC := '0';
	 SIGNAL	n1lll	:	STD_LOGIC := '0';
	 SIGNAL	n1llli	:	STD_LOGIC := '0';
	 SIGNAL	n1llll	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi0i	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi0l	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi0O	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol0i	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol0l	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol0O	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol1l	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol1O	:	STD_LOGIC := '0';
	 SIGNAL	n1Olii	:	STD_LOGIC := '0';
	 SIGNAL	n1Olil	:	STD_LOGIC := '0';
	 SIGNAL	n1OliO	:	STD_LOGIC := '0';
	 SIGNAL	n1Olli	:	STD_LOGIC := '0';
	 SIGNAL	n1Olll	:	STD_LOGIC := '0';
	 SIGNAL	n1OllO	:	STD_LOGIC := '0';
	 SIGNAL	n1OlOi	:	STD_LOGIC := '0';
	 SIGNAL	n1OlOl	:	STD_LOGIC := '0';
	 SIGNAL	n1OlOO	:	STD_LOGIC := '0';
	 SIGNAL	n1OO0i	:	STD_LOGIC := '0';
	 SIGNAL	n1OO0l	:	STD_LOGIC := '0';
	 SIGNAL	n1OO0O	:	STD_LOGIC := '0';
	 SIGNAL	n1OO1i	:	STD_LOGIC := '0';
	 SIGNAL	n1OO1l	:	STD_LOGIC := '0';
	 SIGNAL	n1OO1O	:	STD_LOGIC := '0';
	 SIGNAL	n1OOii	:	STD_LOGIC := '0';
	 SIGNAL	n1OOil	:	STD_LOGIC := '0';
	 SIGNAL	n1OOiO	:	STD_LOGIC := '0';
	 SIGNAL	n1OOli	:	STD_LOGIC := '0';
	 SIGNAL	n1OOll	:	STD_LOGIC := '0';
	 SIGNAL	n1OOlO	:	STD_LOGIC := '0';
	 SIGNAL	n1OOOi	:	STD_LOGIC := '0';
	 SIGNAL	n1OOOl	:	STD_LOGIC := '0';
	 SIGNAL	n1OOOO	:	STD_LOGIC := '0';
	 SIGNAL	ni0ili	:	STD_LOGIC := '0';
	 SIGNAL	ni0ill	:	STD_LOGIC := '0';
	 SIGNAL	ni0iOi	:	STD_LOGIC := '0';
	 SIGNAL	ni0lOi	:	STD_LOGIC := '0';
	 SIGNAL	ni0lOl	:	STD_LOGIC := '0';
	 SIGNAL	ni0lOO	:	STD_LOGIC := '0';
	 SIGNAL	ni0O0i	:	STD_LOGIC := '0';
	 SIGNAL	ni0O1i	:	STD_LOGIC := '0';
	 SIGNAL	ni0O1l	:	STD_LOGIC := '0';
	 SIGNAL	ni0O1O	:	STD_LOGIC := '0';
	 SIGNAL	ni10i	:	STD_LOGIC := '0';
	 SIGNAL	ni10l	:	STD_LOGIC := '0';
	 SIGNAL	ni10O	:	STD_LOGIC := '0';
	 SIGNAL	ni11i	:	STD_LOGIC := '0';
	 SIGNAL	ni11l	:	STD_LOGIC := '0';
	 SIGNAL	ni11O	:	STD_LOGIC := '0';
	 SIGNAL	ni1ii	:	STD_LOGIC := '0';
	 SIGNAL	ni1il	:	STD_LOGIC := '0';
	 SIGNAL	ni1ill	:	STD_LOGIC := '0';
	 SIGNAL	ni1ilO	:	STD_LOGIC := '0';
	 SIGNAL	ni1iO	:	STD_LOGIC := '0';
	 SIGNAL	ni1iOi	:	STD_LOGIC := '0';
	 SIGNAL	ni1iOl	:	STD_LOGIC := '0';
	 SIGNAL	ni1iOO	:	STD_LOGIC := '0';
	 SIGNAL	ni1l0i	:	STD_LOGIC := '0';
	 SIGNAL	ni1l0l	:	STD_LOGIC := '0';
	 SIGNAL	ni1l0O	:	STD_LOGIC := '0';
	 SIGNAL	ni1l1i	:	STD_LOGIC := '0';
	 SIGNAL	ni1l1l	:	STD_LOGIC := '0';
	 SIGNAL	ni1l1O	:	STD_LOGIC := '0';
	 SIGNAL	ni1li	:	STD_LOGIC := '0';
	 SIGNAL	ni1lii	:	STD_LOGIC := '0';
	 SIGNAL	ni1lil	:	STD_LOGIC := '0';
	 SIGNAL	ni1liO	:	STD_LOGIC := '0';
	 SIGNAL	ni1ll	:	STD_LOGIC := '0';
	 SIGNAL	ni1lO	:	STD_LOGIC := '0';
	 SIGNAL	ni1lOi	:	STD_LOGIC := '0';
	 SIGNAL	ni1O1i	:	STD_LOGIC := '0';
	 SIGNAL	ni1O1l	:	STD_LOGIC := '0';
	 SIGNAL	ni1Oi	:	STD_LOGIC := '0';
	 SIGNAL	ni1Ol	:	STD_LOGIC := '0';
	 SIGNAL	nii01i	:	STD_LOGIC := '0';
	 SIGNAL	nii01l	:	STD_LOGIC := '0';
	 SIGNAL	nii10l	:	STD_LOGIC := '0';
	 SIGNAL	nii1il	:	STD_LOGIC := '0';
	 SIGNAL	niiOli	:	STD_LOGIC := '0';
	 SIGNAL	niiOll	:	STD_LOGIC := '0';
	 SIGNAL	niiOlO	:	STD_LOGIC := '0';
	 SIGNAL	nil00i	:	STD_LOGIC := '0';
	 SIGNAL	nil00l	:	STD_LOGIC := '0';
	 SIGNAL	nil00O	:	STD_LOGIC := '0';
	 SIGNAL	nil01i	:	STD_LOGIC := '0';
	 SIGNAL	nil01l	:	STD_LOGIC := '0';
	 SIGNAL	nil01O	:	STD_LOGIC := '0';
	 SIGNAL	nil0ii	:	STD_LOGIC := '0';
	 SIGNAL	nil0il	:	STD_LOGIC := '0';
	 SIGNAL	nil0iO	:	STD_LOGIC := '0';
	 SIGNAL	nil0li	:	STD_LOGIC := '0';
	 SIGNAL	nil0ll	:	STD_LOGIC := '0';
	 SIGNAL	nil0lO	:	STD_LOGIC := '0';
	 SIGNAL	nil0Oi	:	STD_LOGIC := '0';
	 SIGNAL	nil0Ol	:	STD_LOGIC := '0';
	 SIGNAL	nil0OO	:	STD_LOGIC := '0';
	 SIGNAL	nil1il	:	STD_LOGIC := '0';
	 SIGNAL	nil1iO	:	STD_LOGIC := '0';
	 SIGNAL	nil1li	:	STD_LOGIC := '0';
	 SIGNAL	nil1ll	:	STD_LOGIC := '0';
	 SIGNAL	nil1lO	:	STD_LOGIC := '0';
	 SIGNAL	nil1Oi	:	STD_LOGIC := '0';
	 SIGNAL	nil1Ol	:	STD_LOGIC := '0';
	 SIGNAL	nil1OO	:	STD_LOGIC := '0';
	 SIGNAL	nili0i	:	STD_LOGIC := '0';
	 SIGNAL	nili0l	:	STD_LOGIC := '0';
	 SIGNAL	nili0O	:	STD_LOGIC := '0';
	 SIGNAL	nili1i	:	STD_LOGIC := '0';
	 SIGNAL	nili1l	:	STD_LOGIC := '0';
	 SIGNAL	nili1O	:	STD_LOGIC := '0';
	 SIGNAL	niliii	:	STD_LOGIC := '0';
	 SIGNAL	niliil	:	STD_LOGIC := '0';
	 SIGNAL	niliiO	:	STD_LOGIC := '0';
	 SIGNAL	nilili	:	STD_LOGIC := '0';
	 SIGNAL	nilill	:	STD_LOGIC := '0';
	 SIGNAL	nililO	:	STD_LOGIC := '0';
	 SIGNAL	niliOi	:	STD_LOGIC := '0';
	 SIGNAL	niliOl	:	STD_LOGIC := '0';
	 SIGNAL	niliOO	:	STD_LOGIC := '0';
	 SIGNAL	nill0i	:	STD_LOGIC := '0';
	 SIGNAL	nill0l	:	STD_LOGIC := '0';
	 SIGNAL	nill1i	:	STD_LOGIC := '0';
	 SIGNAL	nill1l	:	STD_LOGIC := '0';
	 SIGNAL	nill1O	:	STD_LOGIC := '0';
	 SIGNAL	niOlOl	:	STD_LOGIC := '0';
	 SIGNAL	niOlOO	:	STD_LOGIC := '0';
	 SIGNAL	niOO0i	:	STD_LOGIC := '0';
	 SIGNAL	niOO0l	:	STD_LOGIC := '0';
	 SIGNAL	niOO0O	:	STD_LOGIC := '0';
	 SIGNAL	niOO1i	:	STD_LOGIC := '0';
	 SIGNAL	niOO1l	:	STD_LOGIC := '0';
	 SIGNAL	niOO1O	:	STD_LOGIC := '0';
	 SIGNAL	niOOii	:	STD_LOGIC := '0';
	 SIGNAL	niOOil	:	STD_LOGIC := '0';
	 SIGNAL	niOOiO	:	STD_LOGIC := '0';
	 SIGNAL	niOOli	:	STD_LOGIC := '0';
	 SIGNAL	niOOll	:	STD_LOGIC := '0';
	 SIGNAL	niOOlO	:	STD_LOGIC := '0';
	 SIGNAL	nl00il	:	STD_LOGIC := '0';
	 SIGNAL	nl00ll	:	STD_LOGIC := '0';
	 SIGNAL	nl010i	:	STD_LOGIC := '0';
	 SIGNAL	nl010l	:	STD_LOGIC := '0';
	 SIGNAL	nl010O	:	STD_LOGIC := '0';
	 SIGNAL	nl011i	:	STD_LOGIC := '0';
	 SIGNAL	nl011l	:	STD_LOGIC := '0';
	 SIGNAL	nl011O	:	STD_LOGIC := '0';
	 SIGNAL	nl01ii	:	STD_LOGIC := '0';
	 SIGNAL	nl0i0i	:	STD_LOGIC := '0';
	 SIGNAL	nl0i0l	:	STD_LOGIC := '0';
	 SIGNAL	nl0iO	:	STD_LOGIC := '0';
	 SIGNAL	nl0li	:	STD_LOGIC := '0';
	 SIGNAL	nl0ll	:	STD_LOGIC := '0';
	 SIGNAL	nl0lO	:	STD_LOGIC := '0';
	 SIGNAL	nl0Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl0Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl0OO	:	STD_LOGIC := '0';
	 SIGNAL	nl110i	:	STD_LOGIC := '0';
	 SIGNAL	nl110l	:	STD_LOGIC := '0';
	 SIGNAL	nl111i	:	STD_LOGIC := '0';
	 SIGNAL	nl1lOi	:	STD_LOGIC := '0';
	 SIGNAL	nl1lOl	:	STD_LOGIC := '0';
	 SIGNAL	nl1O1i	:	STD_LOGIC := '0';
	 SIGNAL	nli0i	:	STD_LOGIC := '0';
	 SIGNAL	nli0l	:	STD_LOGIC := '0';
	 SIGNAL	nli0ll	:	STD_LOGIC := '0';
	 SIGNAL	nli0lO	:	STD_LOGIC := '0';
	 SIGNAL	nli0O	:	STD_LOGIC := '0';
	 SIGNAL	nli0Oi	:	STD_LOGIC := '0';
	 SIGNAL	nli0Ol	:	STD_LOGIC := '0';
	 SIGNAL	nli0OO	:	STD_LOGIC := '0';
	 SIGNAL	nli1i	:	STD_LOGIC := '0';
	 SIGNAL	nli1l	:	STD_LOGIC := '0';
	 SIGNAL	nli1O	:	STD_LOGIC := '0';
	 SIGNAL	nli1Oi	:	STD_LOGIC := '0';
	 SIGNAL	nli1Ol	:	STD_LOGIC := '0';
	 SIGNAL	nli1OO	:	STD_LOGIC := '0';
	 SIGNAL	nlii0i	:	STD_LOGIC := '0';
	 SIGNAL	nlii0l	:	STD_LOGIC := '0';
	 SIGNAL	nlii0O	:	STD_LOGIC := '0';
	 SIGNAL	nlii1i	:	STD_LOGIC := '0';
	 SIGNAL	nlii1l	:	STD_LOGIC := '0';
	 SIGNAL	nlii1O	:	STD_LOGIC := '0';
	 SIGNAL	nliiii	:	STD_LOGIC := '0';
	 SIGNAL	nliiil	:	STD_LOGIC := '0';
	 SIGNAL	nliiiO	:	STD_LOGIC := '0';
	 SIGNAL	nliil	:	STD_LOGIC := '0';
	 SIGNAL	nliili	:	STD_LOGIC := '0';
	 SIGNAL	nliill	:	STD_LOGIC := '0';
	 SIGNAL	nliilO	:	STD_LOGIC := '0';
	 SIGNAL	nliiOi	:	STD_LOGIC := '0';
	 SIGNAL	nliiOl	:	STD_LOGIC := '0';
	 SIGNAL	nliiOO	:	STD_LOGIC := '0';
	 SIGNAL	nlil0i	:	STD_LOGIC := '0';
	 SIGNAL	nlil0l	:	STD_LOGIC := '0';
	 SIGNAL	nlil0O	:	STD_LOGIC := '0';
	 SIGNAL	nlil1i	:	STD_LOGIC := '0';
	 SIGNAL	nlil1l	:	STD_LOGIC := '0';
	 SIGNAL	nlil1O	:	STD_LOGIC := '0';
	 SIGNAL	nlilii	:	STD_LOGIC := '0';
	 SIGNAL	nlilil	:	STD_LOGIC := '0';
	 SIGNAL	nliliO	:	STD_LOGIC := '0';
	 SIGNAL	nlilli	:	STD_LOGIC := '0';
	 SIGNAL	nlilll	:	STD_LOGIC := '0';
	 SIGNAL	nlillO	:	STD_LOGIC := '0';
	 SIGNAL	nlilOi	:	STD_LOGIC := '0';
	 SIGNAL	nlilOl	:	STD_LOGIC := '0';
	 SIGNAL	nlilOO	:	STD_LOGIC := '0';
	 SIGNAL	nliO0i	:	STD_LOGIC := '0';
	 SIGNAL	nliO0l	:	STD_LOGIC := '0';
	 SIGNAL	nliO0O	:	STD_LOGIC := '0';
	 SIGNAL	nliO1i	:	STD_LOGIC := '0';
	 SIGNAL	nliO1l	:	STD_LOGIC := '0';
	 SIGNAL	nliO1O	:	STD_LOGIC := '0';
	 SIGNAL	nliOii	:	STD_LOGIC := '0';
	 SIGNAL	nliOil	:	STD_LOGIC := '0';
	 SIGNAL	nliOiOi	:	STD_LOGIC := '0';
	 SIGNAL	nliOl1i	:	STD_LOGIC := '0';
	 SIGNAL	nliOl1l	:	STD_LOGIC := '0';
	 SIGNAL	nll011i	:	STD_LOGIC := '0';
	 SIGNAL	nll011l	:	STD_LOGIC := '0';
	 SIGNAL	nll0lli	:	STD_LOGIC := '0';
	 SIGNAL	nll0lll	:	STD_LOGIC := '0';
	 SIGNAL	nll0llO	:	STD_LOGIC := '0';
	 SIGNAL	nll0Oil	:	STD_LOGIC := '0';
	 SIGNAL	nll0OiO	:	STD_LOGIC := '0';
	 SIGNAL	nll0Oli	:	STD_LOGIC := '0';
	 SIGNAL	nll0Oll	:	STD_LOGIC := '0';
	 SIGNAL	nll0OlO	:	STD_LOGIC := '0';
	 SIGNAL	nll0OOi	:	STD_LOGIC := '0';
	 SIGNAL	nll0OOl	:	STD_LOGIC := '0';
	 SIGNAL	nll0OOO	:	STD_LOGIC := '0';
	 SIGNAL	nll10li	:	STD_LOGIC := '0';
	 SIGNAL	nll10ll	:	STD_LOGIC := '0';
	 SIGNAL	nll10Oi	:	STD_LOGIC := '0';
	 SIGNAL	nll1iOi	:	STD_LOGIC := '0';
	 SIGNAL	nll1iOl	:	STD_LOGIC := '0';
	 SIGNAL	nll1iOO	:	STD_LOGIC := '0';
	 SIGNAL	nll1l0i	:	STD_LOGIC := '0';
	 SIGNAL	nll1l1i	:	STD_LOGIC := '0';
	 SIGNAL	nll1l1l	:	STD_LOGIC := '0';
	 SIGNAL	nll1l1O	:	STD_LOGIC := '0';
	 SIGNAL	nll1O0l	:	STD_LOGIC := '0';
	 SIGNAL	nll1Oil	:	STD_LOGIC := '0';
	 SIGNAL	nlli00i	:	STD_LOGIC := '0';
	 SIGNAL	nlli00l	:	STD_LOGIC := '0';
	 SIGNAL	nlli00O	:	STD_LOGIC := '0';
	 SIGNAL	nlli01i	:	STD_LOGIC := '0';
	 SIGNAL	nlli01l	:	STD_LOGIC := '0';
	 SIGNAL	nlli01O	:	STD_LOGIC := '0';
	 SIGNAL	nlli0ii	:	STD_LOGIC := '0';
	 SIGNAL	nlli0il	:	STD_LOGIC := '0';
	 SIGNAL	nlli0iO	:	STD_LOGIC := '0';
	 SIGNAL	nlli0li	:	STD_LOGIC := '0';
	 SIGNAL	nlli0ll	:	STD_LOGIC := '0';
	 SIGNAL	nlli0lO	:	STD_LOGIC := '0';
	 SIGNAL	nlli0Oi	:	STD_LOGIC := '0';
	 SIGNAL	nlli0Ol	:	STD_LOGIC := '0';
	 SIGNAL	nlli0OO	:	STD_LOGIC := '0';
	 SIGNAL	nlli10i	:	STD_LOGIC := '0';
	 SIGNAL	nlli10l	:	STD_LOGIC := '0';
	 SIGNAL	nlli10O	:	STD_LOGIC := '0';
	 SIGNAL	nlli11i	:	STD_LOGIC := '0';
	 SIGNAL	nlli11l	:	STD_LOGIC := '0';
	 SIGNAL	nlli11O	:	STD_LOGIC := '0';
	 SIGNAL	nlli1ii	:	STD_LOGIC := '0';
	 SIGNAL	nlli1il	:	STD_LOGIC := '0';
	 SIGNAL	nlli1iO	:	STD_LOGIC := '0';
	 SIGNAL	nlli1li	:	STD_LOGIC := '0';
	 SIGNAL	nlli1ll	:	STD_LOGIC := '0';
	 SIGNAL	nlli1lO	:	STD_LOGIC := '0';
	 SIGNAL	nlli1Oi	:	STD_LOGIC := '0';
	 SIGNAL	nlli1Ol	:	STD_LOGIC := '0';
	 SIGNAL	nlli1OO	:	STD_LOGIC := '0';
	 SIGNAL	nllii0i	:	STD_LOGIC := '0';
	 SIGNAL	nllii0l	:	STD_LOGIC := '0';
	 SIGNAL	nllii1i	:	STD_LOGIC := '0';
	 SIGNAL	nllii1l	:	STD_LOGIC := '0';
	 SIGNAL	nllii1O	:	STD_LOGIC := '0';
	 SIGNAL	nllliOl	:	STD_LOGIC := '0';
	 SIGNAL	nllliOO	:	STD_LOGIC := '0';
	 SIGNAL	nllll0i	:	STD_LOGIC := '0';
	 SIGNAL	nllll0l	:	STD_LOGIC := '0';
	 SIGNAL	nllll0O	:	STD_LOGIC := '0';
	 SIGNAL	nllll1i	:	STD_LOGIC := '0';
	 SIGNAL	nllll1l	:	STD_LOGIC := '0';
	 SIGNAL	nllll1O	:	STD_LOGIC := '0';
	 SIGNAL	nllllii	:	STD_LOGIC := '0';
	 SIGNAL	nllllil	:	STD_LOGIC := '0';
	 SIGNAL	nlllliO	:	STD_LOGIC := '0';
	 SIGNAL	nllllli	:	STD_LOGIC := '0';
	 SIGNAL	nllllll	:	STD_LOGIC := '0';
	 SIGNAL	nlllllO	:	STD_LOGIC := '0';
	 SIGNAL	nlllO0i	:	STD_LOGIC := '0';
	 SIGNAL	nlllO0l	:	STD_LOGIC := '0';
	 SIGNAL	nlllO1i	:	STD_LOGIC := '0';
	 SIGNAL	nllOiOi	:	STD_LOGIC := '0';
	 SIGNAL	nllOiOl	:	STD_LOGIC := '0';
	 SIGNAL	nllOl1i	:	STD_LOGIC := '0';
	 SIGNAL	nllOO0i	:	STD_LOGIC := '0';
	 SIGNAL	nllOO0l	:	STD_LOGIC := '0';
	 SIGNAL	nllOO0O	:	STD_LOGIC := '0';
	 SIGNAL	nllOO1i	:	STD_LOGIC := '0';
	 SIGNAL	nllOO1l	:	STD_LOGIC := '0';
	 SIGNAL	nllOO1O	:	STD_LOGIC := '0';
	 SIGNAL	nllOOii	:	STD_LOGIC := '0';
	 SIGNAL	nlO000i	:	STD_LOGIC := '0';
	 SIGNAL	nlO000l	:	STD_LOGIC := '0';
	 SIGNAL	nlO000O	:	STD_LOGIC := '0';
	 SIGNAL	nlO001i	:	STD_LOGIC := '0';
	 SIGNAL	nlO001l	:	STD_LOGIC := '0';
	 SIGNAL	nlO001O	:	STD_LOGIC := '0';
	 SIGNAL	nlO00ii	:	STD_LOGIC := '0';
	 SIGNAL	nlO00il	:	STD_LOGIC := '0';
	 SIGNAL	nlO00iO	:	STD_LOGIC := '0';
	 SIGNAL	nlO00l	:	STD_LOGIC := '0';
	 SIGNAL	nlO00li	:	STD_LOGIC := '0';
	 SIGNAL	nlO00ll	:	STD_LOGIC := '0';
	 SIGNAL	nlO00lO	:	STD_LOGIC := '0';
	 SIGNAL	nlO00Oi	:	STD_LOGIC := '0';
	 SIGNAL	nlO00Ol	:	STD_LOGIC := '0';
	 SIGNAL	nlO00OO	:	STD_LOGIC := '0';
	 SIGNAL	nlO01ll	:	STD_LOGIC := '0';
	 SIGNAL	nlO01lO	:	STD_LOGIC := '0';
	 SIGNAL	nlO01Oi	:	STD_LOGIC := '0';
	 SIGNAL	nlO01Ol	:	STD_LOGIC := '0';
	 SIGNAL	nlO01OO	:	STD_LOGIC := '0';
	 SIGNAL	nlO0i0i	:	STD_LOGIC := '0';
	 SIGNAL	nlO0i0l	:	STD_LOGIC := '0';
	 SIGNAL	nlO0i0O	:	STD_LOGIC := '0';
	 SIGNAL	nlO0i1i	:	STD_LOGIC := '0';
	 SIGNAL	nlO0i1l	:	STD_LOGIC := '0';
	 SIGNAL	nlO0i1O	:	STD_LOGIC := '0';
	 SIGNAL	nlO0iii	:	STD_LOGIC := '0';
	 SIGNAL	nlO0iil	:	STD_LOGIC := '0';
	 SIGNAL	nlO0iiO	:	STD_LOGIC := '0';
	 SIGNAL	nlO0ili	:	STD_LOGIC := '0';
	 SIGNAL	nlO0ill	:	STD_LOGIC := '0';
	 SIGNAL	nlO0ilO	:	STD_LOGIC := '0';
	 SIGNAL	nlO0iO	:	STD_LOGIC := '0';
	 SIGNAL	nlO0iOi	:	STD_LOGIC := '0';
	 SIGNAL	nlO0iOl	:	STD_LOGIC := '0';
	 SIGNAL	nlO0iOO	:	STD_LOGIC := '0';
	 SIGNAL	nlO0l0i	:	STD_LOGIC := '0';
	 SIGNAL	nlO0l0l	:	STD_LOGIC := '0';
	 SIGNAL	nlO0l0O	:	STD_LOGIC := '0';
	 SIGNAL	nlO0l1i	:	STD_LOGIC := '0';
	 SIGNAL	nlO0l1l	:	STD_LOGIC := '0';
	 SIGNAL	nlO0l1O	:	STD_LOGIC := '0';
	 SIGNAL	nlO0li	:	STD_LOGIC := '0';
	 SIGNAL	nlO0lii	:	STD_LOGIC := '0';
	 SIGNAL	nlO0lil	:	STD_LOGIC := '0';
	 SIGNAL	nlO100i	:	STD_LOGIC := '0';
	 SIGNAL	nlO100l	:	STD_LOGIC := '0';
	 SIGNAL	nlO10i	:	STD_LOGIC := '0';
	 SIGNAL	nlO10l	:	STD_LOGIC := '0';
	 SIGNAL	nlO10O	:	STD_LOGIC := '0';
	 SIGNAL	nlO11il	:	STD_LOGIC := '0';
	 SIGNAL	nlO11l	:	STD_LOGIC := '0';
	 SIGNAL	nlO11ll	:	STD_LOGIC := '0';
	 SIGNAL	nlO11O	:	STD_LOGIC := '0';
	 SIGNAL	nlO1ii	:	STD_LOGIC := '0';
	 SIGNAL	nlO1il	:	STD_LOGIC := '0';
	 SIGNAL	nlO1iO	:	STD_LOGIC := '0';
	 SIGNAL	nlO1li	:	STD_LOGIC := '0';
	 SIGNAL	nlO1ll	:	STD_LOGIC := '0';
	 SIGNAL	nlO1lO	:	STD_LOGIC := '0';
	 SIGNAL	nlO1Oi	:	STD_LOGIC := '0';
	 SIGNAL	nlO1Ol	:	STD_LOGIC := '0';
	 SIGNAL	nlO1OO	:	STD_LOGIC := '0';
	 SIGNAL	nlO1OOi	:	STD_LOGIC := '0';
	 SIGNAL	nlO1OOl	:	STD_LOGIC := '0';
	 SIGNAL	nlO1OOO	:	STD_LOGIC := '0';
	 SIGNAL	nlOiO0i	:	STD_LOGIC := '0';
	 SIGNAL	nlOiO0l	:	STD_LOGIC := '0';
	 SIGNAL	nlOiO0O	:	STD_LOGIC := '0';
	 SIGNAL	nlOiO1l	:	STD_LOGIC := '0';
	 SIGNAL	nlOiO1O	:	STD_LOGIC := '0';
	 SIGNAL	nlOiOii	:	STD_LOGIC := '0';
	 SIGNAL	nlOiOil	:	STD_LOGIC := '0';
	 SIGNAL	nlOiOiO	:	STD_LOGIC := '0';
	 SIGNAL	nlOiOli	:	STD_LOGIC := '0';
	 SIGNAL	nlOiOll	:	STD_LOGIC := '0';
	 SIGNAL	nlOiOlO	:	STD_LOGIC := '0';
	 SIGNAL	nlOiOOi	:	STD_LOGIC := '0';
	 SIGNAL	nlOiOOl	:	STD_LOGIC := '0';
	 SIGNAL	nlOiOOO	:	STD_LOGIC := '0';
	 SIGNAL	nlOl10i	:	STD_LOGIC := '0';
	 SIGNAL	nlOl1ii	:	STD_LOGIC := '0';
	 SIGNAL	nlOl1il	:	STD_LOGIC := '0';
	 SIGNAL	nlOlO0i	:	STD_LOGIC := '0';
	 SIGNAL	nlOlO1i	:	STD_LOGIC := '0';
	 SIGNAL	nlOlO1l	:	STD_LOGIC := '0';
	 SIGNAL	nlOO0ll	:	STD_LOGIC := '0';
	 SIGNAL	nlOO0Ol	:	STD_LOGIC := '0';
	 SIGNAL	nlOO10i	:	STD_LOGIC := '0';
	 SIGNAL	nlOO10l	:	STD_LOGIC := '0';
	 SIGNAL	nlOO10O	:	STD_LOGIC := '0';
	 SIGNAL	nlOO1ii	:	STD_LOGIC := '0';
	 SIGNAL	nlOO1il	:	STD_LOGIC := '0';
	 SIGNAL	nlOO1iO	:	STD_LOGIC := '0';
	 SIGNAL	nlOO1li	:	STD_LOGIC := '0';
	 SIGNAL	nlOOiii	:	STD_LOGIC := '0';
	 SIGNAL	nlOOiil	:	STD_LOGIC := '0';
	 SIGNAL	wire_nliii_CLRN	:	STD_LOGIC;
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w2757w2758w2759w2760w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w2117w2118w2120w2132w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w494w496w508w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w3193w3194w3196w3208w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w3295w3296w3297w3298w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w2655w2656w2658w2670w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w2219w2220w2221w2222w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w1581w1582w1584w1596w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w1683w1684w1685w1686w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w606w607w608w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w1044w1045w1047w1059w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w4266w4267w4269w4281w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w4368w4369w4370w4371w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w3729w3730w3732w3744w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w1146w1147w1148w1149w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w3831w3832w3833w3834w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w2740w2741w2742w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w3278w3279w3280w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w2202w2203w2204w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w1666w1667w1668w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w589w590w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w4351w4352w4353w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w1129w1130w1131w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w3814w3815w3816w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w2757w2758w2759w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w2747w2749w2750w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w2117w2118w2120w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w494w496w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w3193w3194w3196w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w3295w3296w3297w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w3285w3287w3288w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w2655w2656w2658w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w2219w2220w2221w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w2209w2211w2212w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w1581w1582w1584w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w1683w1684w1685w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w1673w1675w1676w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w606w607w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w597w598w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w1044w1045w1047w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w4266w4267w4269w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w4368w4369w4370w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w4358w4360w4361w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w3729w3730w3732w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w1146w1147w1148w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w1136w1138w1139w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w3831w3832w3833w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w3821w3823w3824w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w2740w2741w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w2753w2754w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w3278w3279w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w3291w3292w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w2202w2203w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w2215w2216w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w1666w1667w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w1679w1680w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w589w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w602w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w4351w4352w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w4364w4365w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w1129w1130w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w1142w1143w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w3814w3815w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w3827w3828w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w2725w2726w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w2757w2758w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w2747w2749w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w2716w2717w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w2117w2118w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w494w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w3193w3194w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w3263w3264w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w3295w3296w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w3285w3287w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w3254w3255w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w2655w2656w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w2187w2188w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w2219w2220w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w2209w2211w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w2178w2179w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w1581w1582w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w1651w1652w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w1683w1684w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w1673w1675w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w1642w1643w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w574w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w606w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w597w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w565w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w1044w1045w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w4266w4267w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w4336w4337w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w4368w4369w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w4358w4360w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w4327w4328w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w3729w3730w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w1114w1115w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w1146w1147w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w1136w1138w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w1105w1106w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w3799w3800w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w3831w3832w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w3821w3823w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w3790w3791w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w2740w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w2753w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w2706w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w3278w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w3291w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w3244w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w2202w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w2215w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w2168w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w1666w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w1679w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w1632w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_nliil550w551w552w587w588w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_nliil550w551w552w553w601w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_nliil550w551w552w553w554w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w4351w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w4364w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w4317w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w1129w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w1142w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w1095w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w3814w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w3827w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w3780w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w2725w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w2757w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w2747w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w2716w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_n0lll526w527w528w529w530w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w2154w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w2117w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w2101w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_n0Oli473w487w489w491w493w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_n0Oli473w474w475w476w477w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w3230w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w3193w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w3177w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w3263w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w3295w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w3285w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w3254w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w2692w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w2655w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w2639w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w2187w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w2219w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w2209w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w2178w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w1618w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w1581w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w1565w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w1651w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w1683w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w1673w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w1642w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w1081w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_nliil560w569w571w572w573w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_nliil560w561w592w594w605w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_nliil560w561w592w594w595w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_nliil560w561w562w563w564w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w1044w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w1028w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w4266w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w4250w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w4303w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w4336w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w4368w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w4358w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w4327w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w3766w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w3729w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w3713w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w1114w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w1146w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w1136w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w1105w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w3799w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w3831w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w3821w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w3790w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_n00i0O2702w2703w2704w2739w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_n00i0O2702w2703w2704w2705w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_n0liO510w511w513w514w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_n0lOlO2134w2135w2137w2138w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_n0O1ll2081w2082w2084w2085w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_n0Oil456w457w459w460w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_n11i0O3210w3211w3213w3214w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_n11l0l3157w3158w3160w3161w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_n1i01O3240w3241w3242w3277w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_n1i01O3240w3241w3242w3243w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_n1OliO2672w2673w2675w2676w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_n1OOil2619w2620w2622w2623w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_ni1liO2164w2165w2166w2201w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_ni1liO2164w2165w2166w2167w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nil0Ol1545w1546w1548w1549w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nil1OO1598w1599w1601w1602w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_niOOlO1628w1629w1630w1665w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_niOOlO1628w1629w1630w1631w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nlii1O1061w1062w1064w1065w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nliil550w551w552w587w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nliil550w551w552w553w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nlil1l1008w1009w1011w1012w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nll0OOO4283w4284w4286w4287w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nlli1Ol4230w4231w4233w4234w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nlllllO4313w4314w4315w4350w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nlllllO4313w4314w4315w4316w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO001O3746w3747w3749w3750w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO0i1l3693w3694w3696w3697w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO1OO1091w1092w1093w1128w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO1OO1091w1092w1093w1094w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nlOiOOO3776w3777w3778w3813w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nlOiOOO3776w3777w3778w3779w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_n00i0O2712w2721w2723w2724w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_n00i0O2712w2713w2744w2746w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_n00i0O2712w2713w2714w2715w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_n0lll526w527w528w529w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_n0lOOl2150w2151w2152w2153w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_n0O1Oi2097w2111w2113w2115w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_n0O1Oi2097w2098w2099w2100w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_n0Oli473w487w489w491w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_n0Oli473w474w475w476w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_n11iil3226w3227w3228w3229w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_n11lii3173w3187w3189w3191w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_n11lii3173w3174w3175w3176w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_n1i01O3250w3259w3261w3262w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_n1i01O3250w3251w3282w3284w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_n1i01O3250w3251w3252w3253w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_n1Olll2688w2689w2690w2691w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_n1OOli2635w2649w2651w2653w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_n1OOli2635w2636w2637w2638w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_ni1liO2174w2183w2185w2186w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_ni1liO2174w2175w2206w2208w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_ni1liO2174w2175w2176w2177w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nil01l1614w1615w1616w1617w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nili1i1561w1575w1577w1579w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nili1i1561w1562w1563w1564w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_niOOlO1638w1647w1649w1650w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_niOOlO1638w1639w1670w1672w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_niOOlO1638w1639w1640w1641w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nlii0l1077w1078w1079w1080w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nliil560w569w571w572w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nliil560w561w592w594w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nliil560w561w562w563w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nlil0i1024w1038w1040w1042w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nlil0i1024w1025w1026w1027w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nlli01i4246w4260w4262w4264w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nlli01i4246w4247w4248w4249w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nlli11l4299w4300w4301w4302w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nlllllO4323w4332w4334w4335w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nlllllO4323w4324w4355w4357w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nlllllO4323w4324w4325w4326w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO000l3762w3763w3764w3765w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO0i0i3709w3723w3725w3727w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO0i0i3709w3710w3711w3712w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO1OO1101w1110w1112w1113w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO1OO1101w1102w1133w1135w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO1OO1101w1102w1103w1104w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nlOiOOO3786w3795w3797w3798w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nlOiOOO3786w3787w3818w3820w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_w_lg_nlOiOOO3786w3787w3788w3789w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_n00i0O2702w2703w2704w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_n00i0O2730w2731w2732w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_n0liO510w511w513w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_n0lOlO2134w2135w2137w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_n0O1ll2081w2082w2084w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_n0Oil456w457w459w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_n11i0O3210w3211w3213w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_n11l0l3157w3158w3160w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_n1i01O3240w3241w3242w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_n1i01O3268w3269w3270w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_n1OliO2672w2673w2675w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_n1OOil2619w2620w2622w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_ni1liO2164w2165w2166w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_ni1liO2192w2193w2194w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nil0Ol1545w1546w1548w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nil1OO1598w1599w1601w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_niOOlO1628w1629w1630w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_niOOlO1656w1657w1658w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nlii1O1061w1062w1064w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nliil550w551w552w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nliil578w579w580w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nlil1l1008w1009w1011w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nll0OOO4283w4284w4286w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nlli1Ol4230w4231w4233w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nlllllO4313w4314w4315w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nlllllO4341w4342w4343w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nlO001O3746w3747w3749w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nlO0i1l3693w3694w3696w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nlO1OO1091w1092w1093w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nlO1OO1119w1120w1121w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nlOiOOO3776w3777w3778w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nlOiOOO3804w3805w3806w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_n00i0O2712w2721w2723w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_n00i0O2712w2713w2744w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_n00i0O2712w2713w2714w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_n0lll526w527w528w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_n0lOOl2150w2151w2152w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_n0O1Oi2097w2111w2113w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_n0O1Oi2097w2098w2099w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_n0Oli473w487w489w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_n0Oli473w474w475w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_n11iil3226w3227w3228w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_n11lii3173w3187w3189w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_n11lii3173w3174w3175w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_n1i01O3250w3259w3261w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_n1i01O3250w3251w3282w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_n1i01O3250w3251w3252w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_n1Olll2688w2689w2690w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_n1OOli2635w2649w2651w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_n1OOli2635w2636w2637w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_ni1liO2174w2183w2185w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_ni1liO2174w2175w2206w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_ni1liO2174w2175w2176w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nil01l1614w1615w1616w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nili1i1561w1575w1577w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nili1i1561w1562w1563w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_niOOlO1638w1647w1649w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_niOOlO1638w1639w1670w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_niOOlO1638w1639w1640w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nlii0l1077w1078w1079w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nliil560w569w571w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nliil560w561w592w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nliil560w561w562w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nlil0i1024w1038w1040w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nlil0i1024w1025w1026w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nlli01i4246w4260w4262w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nlli01i4246w4247w4248w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nlli11l4299w4300w4301w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nlllllO4323w4332w4334w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nlllllO4323w4324w4355w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nlllllO4323w4324w4325w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nlO000l3762w3763w3764w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nlO0i0i3709w3723w3725w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nlO0i0i3709w3710w3711w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nlO1OO1101w1110w1112w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nlO1OO1101w1102w1133w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nlO1OO1101w1102w1103w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nlOiOOO3786w3795w3797w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nlOiOOO3786w3787w3818w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nlOiOOO3786w3787w3788w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n00i0O2702w2703w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n00i0O2730w2731w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n0iiOl2055w2056w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n0liO510w511w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n0lOlO2134w2135w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n0O1ll2081w2082w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n0Oil456w457w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n10ll430w431w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n11i0O3210w3211w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n11l0l3157w3158w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n1i01O3240w3241w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n1i01O3268w3269w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n1l0ll2593w2594w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n1OliO2672w2673w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n1OOil2619w2620w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_ni0O1l1519w1520w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_ni1liO2164w2165w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_ni1liO2192w2193w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nil0Ol1545w1546w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nil1OO1598w1599w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_niOOlO1628w1629w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_niOOlO1656w1657w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nl010l982w983w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nlii1O1061w1062w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nliil550w551w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nliil578w579w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nlil1l1008w1009w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nll0OOO4283w4284w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nll1l1l4204w4205w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nlli1Ol4230w4231w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nlllllO4313w4314w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nlllllO4341w4342w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nllOO0l3667w3668w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nlO001O3746w3747w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nlO0i1l3693w3694w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nlO1OO1091w1092w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nlO1OO1119w1120w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nlOiOOO3776w3777w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nlOiOOO3804w3805w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nlOO1il3131w3132w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n00i0O2712w2721w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n00i0O2712w2713w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n0lll526w527w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n0lOOl2150w2151w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n0O1Oi2097w2111w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n0O1Oi2097w2098w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n0Oli473w487w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n0Oli473w474w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n11iil3226w3227w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n11lii3173w3187w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n11lii3173w3174w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n1i01O3250w3259w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n1i01O3250w3251w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n1Olll2688w2689w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n1OOli2635w2649w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_n1OOli2635w2636w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_ni1liO2174w2183w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_ni1liO2174w2175w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nil01l1614w1615w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nili1i1561w1575w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nili1i1561w1562w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_niOOlO1638w1647w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_niOOlO1638w1639w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nl0Ol282w283w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nlii0l1077w1078w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nliil560w569w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nliil560w561w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nlil0i1024w1038w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nlil0i1024w1025w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nlli01i4246w4260w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nlli01i4246w4247w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nlli11l4299w4300w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nlllllO4323w4332w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nlllllO4323w4324w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nlO000l3762w3763w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nlO0i0i3709w3723w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nlO0i0i3709w3710w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nlO1OO1101w1110w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nlO1OO1101w1102w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nlOiOOO3786w3795w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nlOiOOO3786w3787w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n00i0O2702w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n00i0O2730w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0iiOl2055w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0liO510w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0lOlO2134w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0O1ll2081w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0Oil456w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n10ll430w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n11i0O3210w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n11l0l3157w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1i01O3240w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1i01O3268w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1l0ll2593w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1OliO2672w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1OOil2619w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_ni0O1l1519w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_ni1liO2164w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_ni1liO2192w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nil0Ol1545w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nil1OO1598w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_niOOlO1628w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_niOOlO1656w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nl010l982w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nl0Oi294w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlii1O1061w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nliil550w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nliil578w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlil1l1008w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nll0OOO4283w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nll1l1l4204w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlli1Ol4230w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlllllO4313w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlllllO4341w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nllOO0l3667w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlO001O3746w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlO0i1l3693w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlO1OO1091w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlO1OO1119w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlOiOOO3776w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlOiOOO3804w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlOO1il3131w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n000ll2557w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n000Oi2453w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n000Ol2709w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n000OO2707w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n00i0i2722w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n00i0l2701w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n00i0O2712w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n00i1i2748w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n00i1l2733w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n00i1O2745w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n00ili2237w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0iilO2054w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0iiOi2059w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0iO0l2011w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0l0O512w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0l1O515w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0lll526w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0lO0O2139w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0lOiO2136w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0lOOl2150w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0O0i495w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0O0l458w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0O0O492w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0O10l2086w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0O10O2121w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0O1ii2119w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0O1il2083w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0O1iO2116w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0O1l461w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0O1li2114w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0O1ll2112w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0O1lO2110w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0O1O497w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0O1Oi2097w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0Oii490w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0Oil488w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0OiO486w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0Oli473w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n10iO429w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n10li434w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n110OO3215w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n11i1O3212w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n11iil3226w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n11iOl3162w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n11iOO3197w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n11l0i3190w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n11l0l3188w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n11l0O3186w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n11l1i3195w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n11l1l3159w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n11l1O3192w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n11lii3173w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1i01i3260w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1i01l3239w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1i01O3250w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1i0ii2775w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1i1il3095w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1i1li2991w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1i1ll3247w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1i1lO3245w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1i1Oi3286w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1i1Ol3271w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1i1OO3283w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1l0iO2592w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1l0li2597w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1l1l386w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1ll1l2549w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1Ol0O2674w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1Ol1O2677w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1Olll2688w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1OO0i2657w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1OO0l2621w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1OO0O2654w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1OO1l2624w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1OO1O2659w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1OOii2652w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1OOil2650w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1OOiO2648w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n1OOli2635w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_ni0lOO1518w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_ni0O1i1523w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_ni1iOl2019w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_ni1l0i2210w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_ni1l0l2195w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_ni1l0O2207w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_ni1l1i1917w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_ni1l1l2171w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_ni1l1O2169w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_ni1lii2184w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_ni1lil2163w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_ni1liO2174w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_ni1lOi1701w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nii1il1475w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nil01l1614w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nil0il1550w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nil0iO1585w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nil0li1583w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nil0ll1547w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nil0lO1580w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nil0Oi1578w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nil0Ol1576w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nil0OO1574w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nil1iO1603w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nil1lO1600w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nili1i1561w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_niOO0i1380w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_niOO0l1635w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_niOO0O1633w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_niOO1l1483w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_niOOii1674w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_niOOil1659w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_niOOiO1671w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_niOOli1648w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_niOOll1627w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_niOOlO1638w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nl00ll938w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nl010i986w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nl011O981w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nl0lO394w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nl0Ol282w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nl0OO557w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nl111i1164w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nli0i593w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nli0l570w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nli0lO1066w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nli0O549w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nli0OO1063w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nli1i555w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nli1l596w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nli1O581w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlii0l1077w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nliil560w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nliill1013w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nliilO1048w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nliiOi1046w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nliiOl1010w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nliiOO1043w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlil0i1024w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlil1i1041w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlil1l1039w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlil1O1037w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nliOiOi4386w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nll0OiO4288w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nll0OlO4285w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nll1iOO4203w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nll1l1i4208w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nll1Oil4160w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlli01i4246w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlli11l4299w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlli1il4235w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlli1iO4270w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlli1li4268w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlli1ll4232w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlli1lO4265w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlli1Oi4263w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlli1Ol4261w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlli1OO4259w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nllll0i4065w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nllll0l4320w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nllll0O4318w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nllll1l4168w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nllllii4359w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nllllil4344w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlllliO4356w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nllllli4333w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nllllll4312w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlllllO4323w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlllO1i3849w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nllOO0i3671w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nllOO1O3666w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlO000l3762w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlO00l627w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlO00ll3698w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlO00lO3733w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlO00Oi3731w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlO00Ol3695w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlO00OO3728w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlO01lO3751w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlO01OO3748w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlO0i0i3709w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlO0i1i3726w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlO0i1l3724w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlO0i1O3722w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlO10l946w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlO11ll3623w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlO1ii844w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlO1il1098w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlO1iO1096w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlO1li1137w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlO1ll1122w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlO1lO1134w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlO1Oi1111w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlO1Ol1090w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlO1OO1101w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlOiO0l3631w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlOiOii3529w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlOiOil3783w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlOiOiO3781w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlOiOli3822w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlOiOll3807w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlOiOlO3819w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlOiOOi3796w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlOiOOl3775w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlOiOOO3786w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlOl10i3313w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlOO0Ol3087w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlOO10O3130w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nlOO1ii3135w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nll1OiO	:	STD_LOGIC := '0';
	 SIGNAL	nll1Oll	:	STD_LOGIC := '0';
	 SIGNAL	wire_nll1Oli_CLRN	:	STD_LOGIC;
	 SIGNAL	n00iii	:	STD_LOGIC := '0';
	 SIGNAL	n1i00i	:	STD_LOGIC := '0';
	 SIGNAL	ni1lli	:	STD_LOGIC := '0';
	 SIGNAL	niOOOi	:	STD_LOGIC := '0';
	 SIGNAL	nliOili	:	STD_LOGIC := '0';
	 SIGNAL	nllllOi	:	STD_LOGIC := '0';
	 SIGNAL	nlO01l	:	STD_LOGIC := '0';
	 SIGNAL	nlOl11i	:	STD_LOGIC := '0';
	 SIGNAL	wire_nlO01i_PRN	:	STD_LOGIC;
	 SIGNAL	n00ilO	:	STD_LOGIC := '0';
	 SIGNAL	n1i0iO	:	STD_LOGIC := '0';
	 SIGNAL	ni1lOO	:	STD_LOGIC := '0';
	 SIGNAL	nl111O	:	STD_LOGIC := '0';
	 SIGNAL	nliOiOO	:	STD_LOGIC := '0';
	 SIGNAL	nlllO1O	:	STD_LOGIC := '0';
	 SIGNAL	nlO0il	:	STD_LOGIC := '0';
	 SIGNAL	nlOl10O	:	STD_LOGIC := '0';
	 SIGNAL	wire_nlO0ii_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_nlO0ii_PRN	:	STD_LOGIC;
	 SIGNAL	n00ill	:	STD_LOGIC := '0';
	 SIGNAL	n00iOO	:	STD_LOGIC := '0';
	 SIGNAL	n00l1i	:	STD_LOGIC := '0';
	 SIGNAL	n1i0il	:	STD_LOGIC := '0';
	 SIGNAL	n1i0lO	:	STD_LOGIC := '0';
	 SIGNAL	n1i0Oi	:	STD_LOGIC := '0';
	 SIGNAL	ni1lOl	:	STD_LOGIC := '0';
	 SIGNAL	ni1O0i	:	STD_LOGIC := '0';
	 SIGNAL	ni1O1O	:	STD_LOGIC := '0';
	 SIGNAL	nl110O	:	STD_LOGIC := '0';
	 SIGNAL	nl111l	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii	:	STD_LOGIC := '0';
	 SIGNAL	nliOiOl	:	STD_LOGIC := '0';
	 SIGNAL	nliOl0i	:	STD_LOGIC := '0';
	 SIGNAL	nliOl1O	:	STD_LOGIC := '0';
	 SIGNAL	nlllO0O	:	STD_LOGIC := '0';
	 SIGNAL	nlllO1l	:	STD_LOGIC := '0';
	 SIGNAL	nlllOii	:	STD_LOGIC := '0';
	 SIGNAL	nlO00O	:	STD_LOGIC := '0';
	 SIGNAL	nlO0ll	:	STD_LOGIC := '0';
	 SIGNAL	nlO0Oi	:	STD_LOGIC := '0';
	 SIGNAL	nlOl10l	:	STD_LOGIC := '0';
	 SIGNAL	nlOl1iO	:	STD_LOGIC := '0';
	 SIGNAL	nlOl1li	:	STD_LOGIC := '0';
	 SIGNAL	wire_nlO0lO_CLRN	:	STD_LOGIC;
	 SIGNAL  wire_nlO0lO_w_lg_n00iOO2233w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO0lO_w_lg_n1i0lO2771w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO0lO_w_lg_ni1O1O1697w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO0lO_w_lg_nl110O1160w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO0lO_w_lg_nliOl1O4382w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO0lO_w_lg_nlllO0O3845w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO0lO_w_lg_nlO0ll619w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO0lO_w_lg_nlOl1iO3309w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nlO11lO	:	STD_LOGIC := '0';
	 SIGNAL	nlO11Ol	:	STD_LOGIC := '0';
	 SIGNAL	wire_nlO11Oi_PRN	:	STD_LOGIC;
	 SIGNAL	nlOO0OO	:	STD_LOGIC := '0';
	 SIGNAL	nlOOi1l	:	STD_LOGIC := '0';
	 SIGNAL	wire_nlOOi1i_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_nlOOi1i_PRN	:	STD_LOGIC;
	 SIGNAL	wire_n0001i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0001O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0010i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0010l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0010O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0011i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0011O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00iil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00l0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00l1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0100i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0100l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0100O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0101i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0101l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0101O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01i0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01i0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01i0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01i1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01i1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01i1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01iii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01iiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01ili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01ill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01ilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01iOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01iOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01iOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01l0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01l0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01l0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01l1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01l1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01l1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01lii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01lil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01liO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01lli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01llO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01lOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01lOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01lOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01O0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01O1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01O1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01Oli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01Oll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01OlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01OOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01OOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ii0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ii0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ii0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ii1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ii1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ii1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iiii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iiil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0li0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0li0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0li0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0li1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0li1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0li1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0llOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0llOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0llOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oi0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oi0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oi0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oiii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oiil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OiiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OiOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OiOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OiOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Ol0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Ol0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Ol0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Ol1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Ol1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Ol1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Olii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Olil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Olli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OlOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OlOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OlOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1000i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1000O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1001i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1001l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1001O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n100i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n100ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n100il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n100iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n100l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n100li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n100ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n100lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n100Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n100Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n100OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1010i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1010l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1010O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1011i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1011l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1011O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n101i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n101ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n101il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n101iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n101l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n101li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n101ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n101lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n101O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n101Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n101Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n101OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10i0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10i0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10i0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10i1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10i1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10i1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10iii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10iil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10iiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10ili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10ill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10ilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10iOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10iOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10iOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10l1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10l1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10l1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10lii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10lil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10liO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10lli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10llO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10lOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10lOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10O0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10O1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10O1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10Oil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10OiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10Oli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10Oll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10OlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10OOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n110ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n110il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n110iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n110li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n110ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11OOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11OOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ii1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OiOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OiOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0l0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0l0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0l0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0l1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0lii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0lil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0liO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0lli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni100i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni100O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni101i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni101l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni101O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni110i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni110l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni110O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni111i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni111l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni111O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1i0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1i0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1i1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1i1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1i1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1Oil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiiOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiiOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiiOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niil0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niil0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niil0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niil1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niil1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niil1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niilii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niilil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nillii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nillil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nillli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nillll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nillO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nillOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nillOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nillOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOiii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOiiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOiOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOiOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOiOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOlii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0ill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0ilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0iOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0iOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0iOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0O0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0O1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0O1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Oii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Oil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0OiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Oli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Oll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0OlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1Oii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1Oil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1OiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1Oli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1Oll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1OlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1OOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOl0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOlil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll00Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll00Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll00OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll01il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll01iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll01li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll01ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll01lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0i0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0i0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0i0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0i1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0i1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0i1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0iii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0iil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0iiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0O1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0O1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1i0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1i0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1i0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1i1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1iii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1iil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1iiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1ili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1ill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlli0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlli0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlli0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlli1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlli1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlli1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliiii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliiil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliiiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliiOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliiOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliiOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllil0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllil0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllil0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllil1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllil1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllil1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllilii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllilil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllilli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllilll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllillO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllilOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllilOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllli0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllli0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllli0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllli1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllli1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllliii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllliiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllllOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOl0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOlii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOlil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOlli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOlll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOlOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOlOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO010i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO010l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO010O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO01ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO01il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0lli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0llO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0lOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0lOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0lOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0O0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0O1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0O1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0Oii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0Oil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0OiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0Oli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0Oll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0OlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0OOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0OOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1l0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1l0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1l0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1l1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1l1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1l1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1lii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1lil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1liO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1lli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1llO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOii0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOii0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOii0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiiii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiiil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiiiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiiOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiiOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiiOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOil0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOil0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOil1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOil1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOil1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOilii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOilil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOilli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOillO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOiOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOiOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOl1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOl1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOl1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOOOO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n000i_a	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n000i_b	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_gnd	:	STD_LOGIC;
	 SIGNAL  wire_n000i_o	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n0011l_a	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_n0011l_b	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_n0011l_o	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_n001li_a	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_n001li_b	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_n001li_o	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_n01iil_a	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n01iil_b	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n01iil_o	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n01Oii_a	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n01Oii_b	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n01Oii_o	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n0liii_a	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n0liii_b	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n0liii_o	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n0Olll_a	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n0Olll_b	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n0Olll_o	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n1000l_a	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n1000l_b	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n1000l_o	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n10l0i_a	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n10l0i_b	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n10l0i_o	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n10lOl_a	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_n10lOl_b	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_n10lOl_o	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_n10Oii_a	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_n10Oii_b	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_n10Oii_o	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_n1111i_a	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n1111i_b	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n1111i_o	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n1O00i_a	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n1O00i_b	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n1O00i_o	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_ni100l_a	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_ni100l_b	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_ni100l_o	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_ni10Oi_a	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_ni10Oi_b	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_ni10Oi_o	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_ni11li_a	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_ni11li_b	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_ni11li_o	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_niiil_a	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_niiil_b	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_niiil_o	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_niilli_a	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_niilli_b	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_niilli_o	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nilOOl_a	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nilOOl_b	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nilOOl_o	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_niO0Oi_a	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_niO0Oi_b	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_niO0Oi_o	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_niOii_a	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_niOii_b	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_niOii_o	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_niOiil_a	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_niOiil_b	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_niOiil_o	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_niOl1i_a	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_niOl1i_b	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_niOl1i_o	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nl0OOi_a	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nl0OOi_b	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nl0OOi_o	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nl11l_a	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nl11l_b	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nl11l_o	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nl1li_a	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nl1li_b	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nl1li_o	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nll01l_a	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nll01l_b	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nll01l_o	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nll0ili_a	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nll0ili_b	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nll0ili_o	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nllilOl_a	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nllilOl_b	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nllilOl_o	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlll0il_a	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nlll0il_b	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nlll0il_o	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nlll1i_a	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlll1i_b	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlll1i_o	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlll1Oi_a	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlll1Oi_b	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlll1Oi_o	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nllli1i_a	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nllli1i_b	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nllli1i_o	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nlllll_a	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nlllll_b	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nlllll_o	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nllO0i_a	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nllO0i_b	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nllO0i_o	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nlO1lOi_a	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nlO1lOi_b	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nlO1lOi_o	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nlOi11l_a	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlOi11l_b	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlOi11l_o	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlOii1i_a	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlOii1i_b	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlOii1i_o	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlOiill_a	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nlOiill_b	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nlOiill_o	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nlOil0i_a	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nlOil0i_b	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nlOil0i_o	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_n010O_a	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n010O_b	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_vcc	:	STD_LOGIC;
	 SIGNAL  wire_n010O_o	:	STD_LOGIC;
	 SIGNAL  wire_n0l01i_a	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n0l01i_b	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n0l01i_o	:	STD_LOGIC;
	 SIGNAL  wire_n0l0iO_a	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n0l0iO_b	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n0l0iO_o	:	STD_LOGIC;
	 SIGNAL  wire_n1lOOi_a	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1lOOi_b	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1lOOi_o	:	STD_LOGIC;
	 SIGNAL  wire_n1O10O_a	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1O10O_b	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1O10O_o	:	STD_LOGIC;
	 SIGNAL  wire_n1OOi_a	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1OOi_b	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1OOi_o	:	STD_LOGIC;
	 SIGNAL  wire_niii0i_a	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niii0i_b	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niii0i_o	:	STD_LOGIC;
	 SIGNAL  wire_niiilO_a	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niiilO_b	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niiilO_o	:	STD_LOGIC;
	 SIGNAL  wire_nl0lii_a	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nl0lii_b	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nl0lii_o	:	STD_LOGIC;
	 SIGNAL  wire_nl0lOO_a	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nl0lOO_b	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nl0lOO_o	:	STD_LOGIC;
	 SIGNAL  wire_nll000i_a	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nll000i_b	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nll000i_o	:	STD_LOGIC;
	 SIGNAL  wire_nll00lO_a	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nll00lO_b	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nll00lO_o	:	STD_LOGIC;
	 SIGNAL  wire_nlO1iii_a	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlO1iii_b	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlO1iii_o	:	STD_LOGIC;
	 SIGNAL  wire_nlO1iOO_a	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlO1iOO_b	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlO1iOO_o	:	STD_LOGIC;
	 SIGNAL  wire_nlOOlli_a	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlOOlli_b	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlOOlli_o	:	STD_LOGIC;
	 SIGNAL  wire_nlOOO1O_a	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlOOO1O_b	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlOOO1O_o	:	STD_LOGIC;
	 SIGNAL  wire_n0iii_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_n0iii_o	:	STD_LOGIC;
	 SIGNAL  wire_n0iii_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0iil_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_n0iil_o	:	STD_LOGIC;
	 SIGNAL  wire_n0iil_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0iiO_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_n0iiO_o	:	STD_LOGIC;
	 SIGNAL  wire_n0iiO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0llli_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_n0llli_o	:	STD_LOGIC;
	 SIGNAL  wire_n0llli_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0llll_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_n0llll_o	:	STD_LOGIC;
	 SIGNAL  wire_n0llll_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0lllO_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_n0lllO_o	:	STD_LOGIC;
	 SIGNAL  wire_n0lllO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1100i_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_n1100i_o	:	STD_LOGIC;
	 SIGNAL  wire_n1100i_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1100l_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_n1100l_o	:	STD_LOGIC;
	 SIGNAL  wire_n1100l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1100O_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_n1100O_o	:	STD_LOGIC;
	 SIGNAL  wire_n1100O_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1Oiii_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_n1Oiii_o	:	STD_LOGIC;
	 SIGNAL  wire_n1Oiii_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1Oiil_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_n1Oiil_o	:	STD_LOGIC;
	 SIGNAL  wire_n1Oiil_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1OiiO_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_n1OiiO_o	:	STD_LOGIC;
	 SIGNAL  wire_n1OiiO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_niiOOi_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_niiOOi_o	:	STD_LOGIC;
	 SIGNAL  wire_niiOOi_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_niiOOl_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_niiOOl_o	:	STD_LOGIC;
	 SIGNAL  wire_niiOOl_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_niiOOO_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_niiOOO_o	:	STD_LOGIC;
	 SIGNAL  wire_niiOOO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nli01i_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nli01i_o	:	STD_LOGIC;
	 SIGNAL  wire_nli01i_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nli01l_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nli01l_o	:	STD_LOGIC;
	 SIGNAL  wire_nli01l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nli01O_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nli01O_o	:	STD_LOGIC;
	 SIGNAL  wire_nli01O_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll0lOi_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nll0lOi_o	:	STD_LOGIC;
	 SIGNAL  wire_nll0lOi_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll0lOl_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nll0lOl_o	:	STD_LOGIC;
	 SIGNAL  wire_nll0lOl_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll0lOO_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nll0lOO_o	:	STD_LOGIC;
	 SIGNAL  wire_nll0lOO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlO011i_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nlO011i_o	:	STD_LOGIC;
	 SIGNAL  wire_nlO011i_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlO011l_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nlO011l_o	:	STD_LOGIC;
	 SIGNAL  wire_nlO011l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlO011O_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nlO011O_o	:	STD_LOGIC;
	 SIGNAL  wire_nlO011O_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0i0ll_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n0i0ll_o	:	STD_LOGIC;
	 SIGNAL  wire_n0i0ll_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n0i0lO_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0i0lO_o	:	STD_LOGIC;
	 SIGNAL  wire_n0i0lO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0i0Oi_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0i0Oi_o	:	STD_LOGIC;
	 SIGNAL  wire_n0i0Oi_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0i0Ol_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0i0Ol_o	:	STD_LOGIC;
	 SIGNAL  wire_n0i0Ol_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n11il_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n11il_o	:	STD_LOGIC;
	 SIGNAL  wire_n11il_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n11iO_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n11iO_o	:	STD_LOGIC;
	 SIGNAL  wire_n11iO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n11li_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n11li_o	:	STD_LOGIC;
	 SIGNAL  wire_n11li_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n11ll_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n11ll_o	:	STD_LOGIC;
	 SIGNAL  wire_n11ll_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1l1il_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n1l1il_o	:	STD_LOGIC;
	 SIGNAL  wire_n1l1il_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n1l1iO_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1l1iO_o	:	STD_LOGIC;
	 SIGNAL  wire_n1l1iO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1l1li_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1l1li_o	:	STD_LOGIC;
	 SIGNAL  wire_n1l1li_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1l1ll_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1l1ll_o	:	STD_LOGIC;
	 SIGNAL  wire_n1l1ll_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_ni0iOl_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni0iOl_o	:	STD_LOGIC;
	 SIGNAL  wire_ni0iOl_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni0iOO_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_ni0iOO_o	:	STD_LOGIC;
	 SIGNAL  wire_ni0iOO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_ni0l1i_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_ni0l1i_o	:	STD_LOGIC;
	 SIGNAL  wire_ni0l1i_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_ni0l1l_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_ni0l1l_o	:	STD_LOGIC;
	 SIGNAL  wire_ni0l1l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl1O0i_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl1O0i_o	:	STD_LOGIC;
	 SIGNAL  wire_nl1O0i_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl1O0l_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl1O0l_o	:	STD_LOGIC;
	 SIGNAL  wire_nl1O0l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl1O1l_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nl1O1l_o	:	STD_LOGIC;
	 SIGNAL  wire_nl1O1l_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nl1O1O_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl1O1O_o	:	STD_LOGIC;
	 SIGNAL  wire_nl1O1O_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll10Ol_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nll10Ol_o	:	STD_LOGIC;
	 SIGNAL  wire_nll10Ol_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nll10OO_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll10OO_o	:	STD_LOGIC;
	 SIGNAL  wire_nll10OO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll1i1i_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll1i1i_o	:	STD_LOGIC;
	 SIGNAL  wire_nll1i1i_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll1i1l_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll1i1l_o	:	STD_LOGIC;
	 SIGNAL  wire_nll1i1l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nllOl0i_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nllOl0i_o	:	STD_LOGIC;
	 SIGNAL  wire_nllOl0i_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nllOl0l_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nllOl0l_o	:	STD_LOGIC;
	 SIGNAL  wire_nllOl0l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nllOl1l_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nllOl1l_o	:	STD_LOGIC;
	 SIGNAL  wire_nllOl1l_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nllOl1O_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nllOl1O_o	:	STD_LOGIC;
	 SIGNAL  wire_nllOl1O_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOlO0l_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlOlO0l_o	:	STD_LOGIC;
	 SIGNAL  wire_nlOlO0l_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlOlO0O_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOlO0O_o	:	STD_LOGIC;
	 SIGNAL  wire_nlOlO0O_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOlOii_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOlOii_o	:	STD_LOGIC;
	 SIGNAL  wire_nlOlOii_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOlOil_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOlOil_o	:	STD_LOGIC;
	 SIGNAL  wire_nlOlOil_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nli01li3598w3616w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nli0iOl3060w3078w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nli1lii4134w4152w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nlii11O2522w2540w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nliii0O1986w2004w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nliiOiO1449w1467w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nlil0lO913w931w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nlilOil361w379w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_nli01ii3619w3621w3622w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_nli0ill3083w3085w3086w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_nli0OOO2545w2547w2548w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_nli1l0i4156w4158w4159w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_nliii1O2007w2009w2010w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_nliiO0O1471w1473w1474w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_nlil0iO934w936w937w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_nlilO1O382w384w385w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli00Ol3136w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli010i3620w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli01ii3619w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli01Oi3669w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli01Oi3673w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli0iil3084w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli0ill3083w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli0l1l3133w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli0l1l3137w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli0O1O2598w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli0OlO2546w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli0OOO2545w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli1iil4209w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli1l0i4156w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli1l1i4157w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli1lli4206w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli1lli4210w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli1Oll3672w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlii0ii2060w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlii0OO2008w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlii10O2595w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlii10O2599w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nliii1O2007w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nliiiiO2057w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nliiiiO2061w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nliilli1524w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nliiO0O1471w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nliiO1O1472w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nliiOlO1521w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nliiOlO1525w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlil00O935w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlil0iO934w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlil0OO984w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlil0OO988w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlil1Oi987w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlill0l435w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlillOi383w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlilO1O382w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlilOOi432w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlilOOi436w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_enable_inf_ei_range40w540w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli00lO3310w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli01li3598w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli01ll3615w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli01Oi3676w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli01OO3675w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli0i1O3024w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli0iOl3060w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli0iOO3077w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli0l0i3139w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli0l1l3140w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli0O1i2772w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli0Oii2486w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli1i0O4383w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli1ill4098w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli1lii4134w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli1lil4151w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli1lli4213w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli1llO4212w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli1OiO3846w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli1OOl3562w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlii00l2234w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlii0li1950w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlii10i2539w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlii10O2602w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlii11O2522w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlii1il2601w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nliii0O1986w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nliiiii2003w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nliiiiO2064w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nliiill2063w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nliilil1698w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nliilOi1413w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nliiOiO1449w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nliiOli1466w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nliiOlO1528w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nliiOOl1527w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlil01i877w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlil0lO913w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlil0Oi930w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlil0OO991w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlil1ll1161w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlili1l990w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlill1O620w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlillil325w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlilOil361w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlilOll378w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlilOOi439w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlilOOO438w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_test_in_0466w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_enable_inf_ei_range41w539w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nli01ii3619w3621w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nli0ill3083w3085w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nli0OOO2545w2547w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nli1l0i4156w4158w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nliii1O2007w2009w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nliiO0O1471w1473w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nlil0iO934w936w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nlilO1O382w384w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlilO1l293w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_eidleinfersel_range23w200w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_eidleinfersel_range22w207w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  nli000i :	STD_LOGIC;
	 SIGNAL  nli000l :	STD_LOGIC;
	 SIGNAL  nli000O :	STD_LOGIC;
	 SIGNAL  nli001i :	STD_LOGIC;
	 SIGNAL  nli001l :	STD_LOGIC;
	 SIGNAL  nli001O :	STD_LOGIC;
	 SIGNAL  nli00ii :	STD_LOGIC;
	 SIGNAL  nli00il :	STD_LOGIC;
	 SIGNAL  nli00iO :	STD_LOGIC;
	 SIGNAL  nli00li :	STD_LOGIC;
	 SIGNAL  nli00ll :	STD_LOGIC;
	 SIGNAL  nli00lO :	STD_LOGIC;
	 SIGNAL  nli00Oi :	STD_LOGIC;
	 SIGNAL  nli00Ol :	STD_LOGIC;
	 SIGNAL  nli010i :	STD_LOGIC;
	 SIGNAL  nli010l :	STD_LOGIC;
	 SIGNAL  nli010O :	STD_LOGIC;
	 SIGNAL  nli011i :	STD_LOGIC;
	 SIGNAL  nli011l :	STD_LOGIC;
	 SIGNAL  nli011O :	STD_LOGIC;
	 SIGNAL  nli01ii :	STD_LOGIC;
	 SIGNAL  nli01il :	STD_LOGIC;
	 SIGNAL  nli01iO :	STD_LOGIC;
	 SIGNAL  nli01li :	STD_LOGIC;
	 SIGNAL  nli01ll :	STD_LOGIC;
	 SIGNAL  nli01lO :	STD_LOGIC;
	 SIGNAL  nli01Oi :	STD_LOGIC;
	 SIGNAL  nli01Ol :	STD_LOGIC;
	 SIGNAL  nli01OO :	STD_LOGIC;
	 SIGNAL  nli0i0i :	STD_LOGIC;
	 SIGNAL  nli0i0l :	STD_LOGIC;
	 SIGNAL  nli0i0O :	STD_LOGIC;
	 SIGNAL  nli0i1l :	STD_LOGIC;
	 SIGNAL  nli0i1O :	STD_LOGIC;
	 SIGNAL  nli0iii :	STD_LOGIC;
	 SIGNAL  nli0iil :	STD_LOGIC;
	 SIGNAL  nli0iiO :	STD_LOGIC;
	 SIGNAL  nli0ili :	STD_LOGIC;
	 SIGNAL  nli0ill :	STD_LOGIC;
	 SIGNAL  nli0ilO :	STD_LOGIC;
	 SIGNAL  nli0iOi :	STD_LOGIC;
	 SIGNAL  nli0iOl :	STD_LOGIC;
	 SIGNAL  nli0iOO :	STD_LOGIC;
	 SIGNAL  nli0l0i :	STD_LOGIC;
	 SIGNAL  nli0l0l :	STD_LOGIC;
	 SIGNAL  nli0l0O :	STD_LOGIC;
	 SIGNAL  nli0l1i :	STD_LOGIC;
	 SIGNAL  nli0l1l :	STD_LOGIC;
	 SIGNAL  nli0l1O :	STD_LOGIC;
	 SIGNAL  nli0lii :	STD_LOGIC;
	 SIGNAL  nli0lil :	STD_LOGIC;
	 SIGNAL  nli0liO :	STD_LOGIC;
	 SIGNAL  nli0lli :	STD_LOGIC;
	 SIGNAL  nli0lll :	STD_LOGIC;
	 SIGNAL  nli0llO :	STD_LOGIC;
	 SIGNAL  nli0lOi :	STD_LOGIC;
	 SIGNAL  nli0lOl :	STD_LOGIC;
	 SIGNAL  nli0lOO :	STD_LOGIC;
	 SIGNAL  nli0O0O :	STD_LOGIC;
	 SIGNAL  nli0O1i :	STD_LOGIC;
	 SIGNAL  nli0O1l :	STD_LOGIC;
	 SIGNAL  nli0O1O :	STD_LOGIC;
	 SIGNAL  nli0Oii :	STD_LOGIC;
	 SIGNAL  nli0Oil :	STD_LOGIC;
	 SIGNAL  nli0OiO :	STD_LOGIC;
	 SIGNAL  nli0Oli :	STD_LOGIC;
	 SIGNAL  nli0Oll :	STD_LOGIC;
	 SIGNAL  nli0OlO :	STD_LOGIC;
	 SIGNAL  nli0OOi :	STD_LOGIC;
	 SIGNAL  nli0OOl :	STD_LOGIC;
	 SIGNAL  nli0OOO :	STD_LOGIC;
	 SIGNAL  nli1i0O :	STD_LOGIC;
	 SIGNAL  nli1iii :	STD_LOGIC;
	 SIGNAL  nli1iil :	STD_LOGIC;
	 SIGNAL  nli1ili :	STD_LOGIC;
	 SIGNAL  nli1ill :	STD_LOGIC;
	 SIGNAL  nli1ilO :	STD_LOGIC;
	 SIGNAL  nli1iOi :	STD_LOGIC;
	 SIGNAL  nli1iOl :	STD_LOGIC;
	 SIGNAL  nli1iOO :	STD_LOGIC;
	 SIGNAL  nli1l0i :	STD_LOGIC;
	 SIGNAL  nli1l0l :	STD_LOGIC;
	 SIGNAL  nli1l0O :	STD_LOGIC;
	 SIGNAL  nli1l1i :	STD_LOGIC;
	 SIGNAL  nli1l1l :	STD_LOGIC;
	 SIGNAL  nli1l1O :	STD_LOGIC;
	 SIGNAL  nli1lii :	STD_LOGIC;
	 SIGNAL  nli1lil :	STD_LOGIC;
	 SIGNAL  nli1liO :	STD_LOGIC;
	 SIGNAL  nli1lli :	STD_LOGIC;
	 SIGNAL  nli1lll :	STD_LOGIC;
	 SIGNAL  nli1llO :	STD_LOGIC;
	 SIGNAL  nli1lOi :	STD_LOGIC;
	 SIGNAL  nli1lOl :	STD_LOGIC;
	 SIGNAL  nli1lOO :	STD_LOGIC;
	 SIGNAL  nli1O0i :	STD_LOGIC;
	 SIGNAL  nli1O0l :	STD_LOGIC;
	 SIGNAL  nli1O0O :	STD_LOGIC;
	 SIGNAL  nli1O1i :	STD_LOGIC;
	 SIGNAL  nli1O1l :	STD_LOGIC;
	 SIGNAL  nli1O1O :	STD_LOGIC;
	 SIGNAL  nli1Oii :	STD_LOGIC;
	 SIGNAL  nli1Oil :	STD_LOGIC;
	 SIGNAL  nli1OiO :	STD_LOGIC;
	 SIGNAL  nli1Oli :	STD_LOGIC;
	 SIGNAL  nli1Oll :	STD_LOGIC;
	 SIGNAL  nli1OOi :	STD_LOGIC;
	 SIGNAL  nli1OOl :	STD_LOGIC;
	 SIGNAL  nli1OOO :	STD_LOGIC;
	 SIGNAL  nlii00i :	STD_LOGIC;
	 SIGNAL  nlii00l :	STD_LOGIC;
	 SIGNAL  nlii00O :	STD_LOGIC;
	 SIGNAL  nlii01i :	STD_LOGIC;
	 SIGNAL  nlii01l :	STD_LOGIC;
	 SIGNAL  nlii01O :	STD_LOGIC;
	 SIGNAL  nlii0ii :	STD_LOGIC;
	 SIGNAL  nlii0iO :	STD_LOGIC;
	 SIGNAL  nlii0li :	STD_LOGIC;
	 SIGNAL  nlii0ll :	STD_LOGIC;
	 SIGNAL  nlii0lO :	STD_LOGIC;
	 SIGNAL  nlii0Oi :	STD_LOGIC;
	 SIGNAL  nlii0Ol :	STD_LOGIC;
	 SIGNAL  nlii0OO :	STD_LOGIC;
	 SIGNAL  nlii10i :	STD_LOGIC;
	 SIGNAL  nlii10l :	STD_LOGIC;
	 SIGNAL  nlii10O :	STD_LOGIC;
	 SIGNAL  nlii11i :	STD_LOGIC;
	 SIGNAL  nlii11l :	STD_LOGIC;
	 SIGNAL  nlii11O :	STD_LOGIC;
	 SIGNAL  nlii1ii :	STD_LOGIC;
	 SIGNAL  nlii1il :	STD_LOGIC;
	 SIGNAL  nlii1iO :	STD_LOGIC;
	 SIGNAL  nlii1li :	STD_LOGIC;
	 SIGNAL  nlii1ll :	STD_LOGIC;
	 SIGNAL  nlii1lO :	STD_LOGIC;
	 SIGNAL  nlii1Oi :	STD_LOGIC;
	 SIGNAL  nlii1Ol :	STD_LOGIC;
	 SIGNAL  nlii1OO :	STD_LOGIC;
	 SIGNAL  nliii0i :	STD_LOGIC;
	 SIGNAL  nliii0l :	STD_LOGIC;
	 SIGNAL  nliii0O :	STD_LOGIC;
	 SIGNAL  nliii1i :	STD_LOGIC;
	 SIGNAL  nliii1l :	STD_LOGIC;
	 SIGNAL  nliii1O :	STD_LOGIC;
	 SIGNAL  nliiiii :	STD_LOGIC;
	 SIGNAL  nliiiil :	STD_LOGIC;
	 SIGNAL  nliiiiO :	STD_LOGIC;
	 SIGNAL  nliiili :	STD_LOGIC;
	 SIGNAL  nliiill :	STD_LOGIC;
	 SIGNAL  nliiilO :	STD_LOGIC;
	 SIGNAL  nliiiOi :	STD_LOGIC;
	 SIGNAL  nliiiOl :	STD_LOGIC;
	 SIGNAL  nliiiOO :	STD_LOGIC;
	 SIGNAL  nliil0i :	STD_LOGIC;
	 SIGNAL  nliil0l :	STD_LOGIC;
	 SIGNAL  nliil0O :	STD_LOGIC;
	 SIGNAL  nliil1i :	STD_LOGIC;
	 SIGNAL  nliil1l :	STD_LOGIC;
	 SIGNAL  nliil1O :	STD_LOGIC;
	 SIGNAL  nliilii :	STD_LOGIC;
	 SIGNAL  nliilil :	STD_LOGIC;
	 SIGNAL  nliiliO :	STD_LOGIC;
	 SIGNAL  nliilli :	STD_LOGIC;
	 SIGNAL  nliillO :	STD_LOGIC;
	 SIGNAL  nliilOi :	STD_LOGIC;
	 SIGNAL  nliilOl :	STD_LOGIC;
	 SIGNAL  nliilOO :	STD_LOGIC;
	 SIGNAL  nliiO0i :	STD_LOGIC;
	 SIGNAL  nliiO0l :	STD_LOGIC;
	 SIGNAL  nliiO0O :	STD_LOGIC;
	 SIGNAL  nliiO1i :	STD_LOGIC;
	 SIGNAL  nliiO1l :	STD_LOGIC;
	 SIGNAL  nliiO1O :	STD_LOGIC;
	 SIGNAL  nliiOii :	STD_LOGIC;
	 SIGNAL  nliiOil :	STD_LOGIC;
	 SIGNAL  nliiOiO :	STD_LOGIC;
	 SIGNAL  nliiOli :	STD_LOGIC;
	 SIGNAL  nliiOll :	STD_LOGIC;
	 SIGNAL  nliiOlO :	STD_LOGIC;
	 SIGNAL  nliiOOi :	STD_LOGIC;
	 SIGNAL  nliiOOl :	STD_LOGIC;
	 SIGNAL  nliiOOO :	STD_LOGIC;
	 SIGNAL  nlil00i :	STD_LOGIC;
	 SIGNAL  nlil00l :	STD_LOGIC;
	 SIGNAL  nlil00O :	STD_LOGIC;
	 SIGNAL  nlil01i :	STD_LOGIC;
	 SIGNAL  nlil01l :	STD_LOGIC;
	 SIGNAL  nlil01O :	STD_LOGIC;
	 SIGNAL  nlil0ii :	STD_LOGIC;
	 SIGNAL  nlil0il :	STD_LOGIC;
	 SIGNAL  nlil0iO :	STD_LOGIC;
	 SIGNAL  nlil0li :	STD_LOGIC;
	 SIGNAL  nlil0ll :	STD_LOGIC;
	 SIGNAL  nlil0lO :	STD_LOGIC;
	 SIGNAL  nlil0Oi :	STD_LOGIC;
	 SIGNAL  nlil0Ol :	STD_LOGIC;
	 SIGNAL  nlil0OO :	STD_LOGIC;
	 SIGNAL  nlil10i :	STD_LOGIC;
	 SIGNAL  nlil10l :	STD_LOGIC;
	 SIGNAL  nlil10O :	STD_LOGIC;
	 SIGNAL  nlil11i :	STD_LOGIC;
	 SIGNAL  nlil11l :	STD_LOGIC;
	 SIGNAL  nlil11O :	STD_LOGIC;
	 SIGNAL  nlil1ii :	STD_LOGIC;
	 SIGNAL  nlil1il :	STD_LOGIC;
	 SIGNAL  nlil1iO :	STD_LOGIC;
	 SIGNAL  nlil1li :	STD_LOGIC;
	 SIGNAL  nlil1ll :	STD_LOGIC;
	 SIGNAL  nlil1lO :	STD_LOGIC;
	 SIGNAL  nlil1Oi :	STD_LOGIC;
	 SIGNAL  nlil1OO :	STD_LOGIC;
	 SIGNAL  nlili0i :	STD_LOGIC;
	 SIGNAL  nlili0l :	STD_LOGIC;
	 SIGNAL  nlili0O :	STD_LOGIC;
	 SIGNAL  nlili1i :	STD_LOGIC;
	 SIGNAL  nlili1l :	STD_LOGIC;
	 SIGNAL  nlili1O :	STD_LOGIC;
	 SIGNAL  nliliii :	STD_LOGIC;
	 SIGNAL  nliliil :	STD_LOGIC;
	 SIGNAL  nliliiO :	STD_LOGIC;
	 SIGNAL  nlilili :	STD_LOGIC;
	 SIGNAL  nlilill :	STD_LOGIC;
	 SIGNAL  nlililO :	STD_LOGIC;
	 SIGNAL  nliliOi :	STD_LOGIC;
	 SIGNAL  nlill0i :	STD_LOGIC;
	 SIGNAL  nlill0l :	STD_LOGIC;
	 SIGNAL  nlill1O :	STD_LOGIC;
	 SIGNAL  nlillii :	STD_LOGIC;
	 SIGNAL  nlillil :	STD_LOGIC;
	 SIGNAL  nlilliO :	STD_LOGIC;
	 SIGNAL  nlillli :	STD_LOGIC;
	 SIGNAL  nlillll :	STD_LOGIC;
	 SIGNAL  nlilllO :	STD_LOGIC;
	 SIGNAL  nlillOi :	STD_LOGIC;
	 SIGNAL  nlilO0O :	STD_LOGIC;
	 SIGNAL  nlilO1i :	STD_LOGIC;
	 SIGNAL  nlilO1l :	STD_LOGIC;
	 SIGNAL  nlilO1O :	STD_LOGIC;
	 SIGNAL  nlilOii :	STD_LOGIC;
	 SIGNAL  nlilOil :	STD_LOGIC;
	 SIGNAL  nlilOll :	STD_LOGIC;
	 SIGNAL  nlilOlO :	STD_LOGIC;
	 SIGNAL  nlilOOi :	STD_LOGIC;
	 SIGNAL  nlilOOl :	STD_LOGIC;
	 SIGNAL  nlilOOO :	STD_LOGIC;
	 SIGNAL  nliO00i :	STD_LOGIC;
	 SIGNAL  nliO00l :	STD_LOGIC;
	 SIGNAL  nliO00O :	STD_LOGIC;
	 SIGNAL  nliO01i :	STD_LOGIC;
	 SIGNAL  nliO01l :	STD_LOGIC;
	 SIGNAL  nliO0ii :	STD_LOGIC;
	 SIGNAL  nliO0il :	STD_LOGIC;
	 SIGNAL  nliO11O :	STD_LOGIC;
	 SIGNAL  nliO1ii :	STD_LOGIC;
	 SIGNAL  nliO1Ol :	STD_LOGIC;
	 SIGNAL  nliO1OO :	STD_LOGIC;
	 SIGNAL  nliOiii :	STD_LOGIC;
	 SIGNAL  wire_w_eidleinfersel_range23w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_eidleinfersel_range22w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_enable_inf_ei_range40w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_enable_inf_ei_range41w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
 BEGIN

	wire_gnd <= '0';
	wire_vcc <= '1';
	wire_w_lg_w_lg_nli01li3598w3616w(0) <= wire_w_lg_nli01li3598w(0) AND nli011i;
	wire_w_lg_w_lg_nli0iOl3060w3078w(0) <= wire_w_lg_nli0iOl3060w(0) AND nli0i0l;
	wire_w_lg_w_lg_nli1lii4134w4152w(0) <= wire_w_lg_nli1lii4134w(0) AND nli1iOi;
	wire_w_lg_w_lg_nlii11O2522w2540w(0) <= wire_w_lg_nlii11O2522w(0) AND nli0OiO;
	wire_w_lg_w_lg_nliii0O1986w2004w(0) <= wire_w_lg_nliii0O1986w(0) AND nlii0lO;
	wire_w_lg_w_lg_nliiOiO1449w1467w(0) <= wire_w_lg_nliiOiO1449w(0) AND nliilOO;
	wire_w_lg_w_lg_nlil0lO913w931w(0) <= wire_w_lg_nlil0lO913w(0) AND nlil01O;
	wire_w_lg_w_lg_nlilOil361w379w(0) <= wire_w_lg_nlilOil361w(0) AND nlillli;
	wire_w_lg_w_lg_w_lg_nli01ii3619w3621w3622w(0) <= wire_w_lg_w_lg_nli01ii3619w3621w(0) AND nli011l;
	wire_w_lg_w_lg_w_lg_nli0ill3083w3085w3086w(0) <= wire_w_lg_w_lg_nli0ill3083w3085w(0) AND nli0i0O;
	wire_w_lg_w_lg_w_lg_nli0OOO2545w2547w2548w(0) <= wire_w_lg_w_lg_nli0OOO2545w2547w(0) AND nli0Oli;
	wire_w_lg_w_lg_w_lg_nli1l0i4156w4158w4159w(0) <= wire_w_lg_w_lg_nli1l0i4156w4158w(0) AND nli1iOl;
	wire_w_lg_w_lg_w_lg_nliii1O2007w2009w2010w(0) <= wire_w_lg_w_lg_nliii1O2007w2009w(0) AND nlii0Oi;
	wire_w_lg_w_lg_w_lg_nliiO0O1471w1473w1474w(0) <= wire_w_lg_w_lg_nliiO0O1471w1473w(0) AND nliiO1i;
	wire_w_lg_w_lg_w_lg_nlil0iO934w936w937w(0) <= wire_w_lg_w_lg_nlil0iO934w936w(0) AND nlil00i;
	wire_w_lg_w_lg_w_lg_nlilO1O382w384w385w(0) <= wire_w_lg_w_lg_nlilO1O382w384w(0) AND nlillll;
	wire_w_lg_nli00Ol3136w(0) <= nli00Ol AND wire_nliii_w_lg_nlOO1ii3135w(0);
	wire_w_lg_nli010i3620w(0) <= nli010i AND nlO11lO;
	wire_w_lg_nli01ii3619w(0) <= nli01ii AND nlO11Ol;
	wire_w_lg_nli01Oi3669w(0) <= nli01Oi AND wire_nliii_w_lg_w_lg_nllOO0l3667w3668w(0);
	wire_w_lg_nli01Oi3673w(0) <= nli01Oi AND wire_w_lg_nli1Oll3672w(0);
	wire_w_lg_nli0iil3084w(0) <= nli0iil AND nlOO0OO;
	wire_w_lg_nli0ill3083w(0) <= nli0ill AND nlOOi1l;
	wire_w_lg_nli0l1l3133w(0) <= nli0l1l AND wire_nliii_w_lg_w_lg_nlOO1il3131w3132w(0);
	wire_w_lg_nli0l1l3137w(0) <= nli0l1l AND wire_w_lg_nli00Ol3136w(0);
	wire_w_lg_nli0O1O2598w(0) <= nli0O1O AND wire_nliii_w_lg_n1l0li2597w(0);
	wire_w_lg_nli0OlO2546w(0) <= nli0OlO AND n1ll1O;
	wire_w_lg_nli0OOO2545w(0) <= nli0OOO AND n1ll0l;
	wire_w_lg_nli1iil4209w(0) <= nli1iil AND wire_nliii_w_lg_nll1l1i4208w(0);
	wire_w_lg_nli1l0i4156w(0) <= nli1l0i AND nll1Oll;
	wire_w_lg_nli1l1i4157w(0) <= nli1l1i AND nll1OiO;
	wire_w_lg_nli1lli4206w(0) <= nli1lli AND wire_nliii_w_lg_w_lg_nll1l1l4204w4205w(0);
	wire_w_lg_nli1lli4210w(0) <= nli1lli AND wire_w_lg_nli1iil4209w(0);
	wire_w_lg_nli1Oll3672w(0) <= nli1Oll AND wire_nliii_w_lg_nllOO0i3671w(0);
	wire_w_lg_nlii0ii2060w(0) <= nlii0ii AND wire_nliii_w_lg_n0iiOi2059w(0);
	wire_w_lg_nlii0OO2008w(0) <= nlii0OO AND n0iO0O;
	wire_w_lg_nlii10O2595w(0) <= nlii10O AND wire_nliii_w_lg_w_lg_n1l0ll2593w2594w(0);
	wire_w_lg_nlii10O2599w(0) <= nlii10O AND wire_w_lg_nli0O1O2598w(0);
	wire_w_lg_nliii1O2007w(0) <= nliii1O AND n0iOil;
	wire_w_lg_nliiiiO2057w(0) <= nliiiiO AND wire_nliii_w_lg_w_lg_n0iiOl2055w2056w(0);
	wire_w_lg_nliiiiO2061w(0) <= nliiiiO AND wire_w_lg_nlii0ii2060w(0);
	wire_w_lg_nliilli1524w(0) <= nliilli AND wire_nliii_w_lg_ni0O1i1523w(0);
	wire_w_lg_nliiO0O1471w(0) <= nliiO0O AND nii1ll;
	wire_w_lg_nliiO1O1472w(0) <= nliiO1O AND nii1iO;
	wire_w_lg_nliiOlO1521w(0) <= nliiOlO AND wire_nliii_w_lg_w_lg_ni0O1l1519w1520w(0);
	wire_w_lg_nliiOlO1525w(0) <= nliiOlO AND wire_w_lg_nliilli1524w(0);
	wire_w_lg_nlil00O935w(0) <= nlil00O AND nl00lO;
	wire_w_lg_nlil0iO934w(0) <= nlil0iO AND nl00Ol;
	wire_w_lg_nlil0OO984w(0) <= nlil0OO AND wire_nliii_w_lg_w_lg_nl010l982w983w(0);
	wire_w_lg_nlil0OO988w(0) <= nlil0OO AND wire_w_lg_nlil1Oi987w(0);
	wire_w_lg_nlil1Oi987w(0) <= nlil1Oi AND wire_nliii_w_lg_nl010i986w(0);
	wire_w_lg_nlill0l435w(0) <= nlill0l AND wire_nliii_w_lg_n10li434w(0);
	wire_w_lg_nlillOi383w(0) <= nlillOi AND n1l1O;
	wire_w_lg_nlilO1O382w(0) <= nlilO1O AND n1l0l;
	wire_w_lg_nlilOOi432w(0) <= nlilOOi AND wire_nliii_w_lg_w_lg_n10ll430w431w(0);
	wire_w_lg_nlilOOi436w(0) <= nlilOOi AND wire_w_lg_nlill0l435w(0);
	wire_w_lg_w_enable_inf_ei_range40w540w(0) <= wire_w_enable_inf_ei_range40w(0) AND wire_w_lg_w_enable_inf_ei_range41w539w(0);
	wire_w_lg_nli00lO3310w(0) <= NOT nli00lO;
	wire_w_lg_nli01li3598w(0) <= NOT nli01li;
	wire_w_lg_nli01ll3615w(0) <= NOT nli01ll;
	wire_w_lg_nli01Oi3676w(0) <= NOT nli01Oi;
	wire_w_lg_nli01OO3675w(0) <= NOT nli01OO;
	wire_w_lg_nli0i1O3024w(0) <= NOT nli0i1O;
	wire_w_lg_nli0iOl3060w(0) <= NOT nli0iOl;
	wire_w_lg_nli0iOO3077w(0) <= NOT nli0iOO;
	wire_w_lg_nli0l0i3139w(0) <= NOT nli0l0i;
	wire_w_lg_nli0l1l3140w(0) <= NOT nli0l1l;
	wire_w_lg_nli0O1i2772w(0) <= NOT nli0O1i;
	wire_w_lg_nli0Oii2486w(0) <= NOT nli0Oii;
	wire_w_lg_nli1i0O4383w(0) <= NOT nli1i0O;
	wire_w_lg_nli1ill4098w(0) <= NOT nli1ill;
	wire_w_lg_nli1lii4134w(0) <= NOT nli1lii;
	wire_w_lg_nli1lil4151w(0) <= NOT nli1lil;
	wire_w_lg_nli1lli4213w(0) <= NOT nli1lli;
	wire_w_lg_nli1llO4212w(0) <= NOT nli1llO;
	wire_w_lg_nli1OiO3846w(0) <= NOT nli1OiO;
	wire_w_lg_nli1OOl3562w(0) <= NOT nli1OOl;
	wire_w_lg_nlii00l2234w(0) <= NOT nlii00l;
	wire_w_lg_nlii0li1950w(0) <= NOT nlii0li;
	wire_w_lg_nlii10i2539w(0) <= NOT nlii10i;
	wire_w_lg_nlii10O2602w(0) <= NOT nlii10O;
	wire_w_lg_nlii11O2522w(0) <= NOT nlii11O;
	wire_w_lg_nlii1il2601w(0) <= NOT nlii1il;
	wire_w_lg_nliii0O1986w(0) <= NOT nliii0O;
	wire_w_lg_nliiiii2003w(0) <= NOT nliiiii;
	wire_w_lg_nliiiiO2064w(0) <= NOT nliiiiO;
	wire_w_lg_nliiill2063w(0) <= NOT nliiill;
	wire_w_lg_nliilil1698w(0) <= NOT nliilil;
	wire_w_lg_nliilOi1413w(0) <= NOT nliilOi;
	wire_w_lg_nliiOiO1449w(0) <= NOT nliiOiO;
	wire_w_lg_nliiOli1466w(0) <= NOT nliiOli;
	wire_w_lg_nliiOlO1528w(0) <= NOT nliiOlO;
	wire_w_lg_nliiOOl1527w(0) <= NOT nliiOOl;
	wire_w_lg_nlil01i877w(0) <= NOT nlil01i;
	wire_w_lg_nlil0lO913w(0) <= NOT nlil0lO;
	wire_w_lg_nlil0Oi930w(0) <= NOT nlil0Oi;
	wire_w_lg_nlil0OO991w(0) <= NOT nlil0OO;
	wire_w_lg_nlil1ll1161w(0) <= NOT nlil1ll;
	wire_w_lg_nlili1l990w(0) <= NOT nlili1l;
	wire_w_lg_nlill1O620w(0) <= NOT nlill1O;
	wire_w_lg_nlillil325w(0) <= NOT nlillil;
	wire_w_lg_nlilOil361w(0) <= NOT nlilOil;
	wire_w_lg_nlilOll378w(0) <= NOT nlilOll;
	wire_w_lg_nlilOOi439w(0) <= NOT nlilOOi;
	wire_w_lg_nlilOOO438w(0) <= NOT nlilOOO;
	wire_w_lg_test_in_0466w(0) <= NOT test_in_0;
	wire_w_lg_w_enable_inf_ei_range41w539w(0) <= NOT wire_w_enable_inf_ei_range41w(0);
	wire_w_lg_w_lg_nli01ii3619w3621w(0) <= wire_w_lg_nli01ii3619w(0) OR wire_w_lg_nli010i3620w(0);
	wire_w_lg_w_lg_nli0ill3083w3085w(0) <= wire_w_lg_nli0ill3083w(0) OR wire_w_lg_nli0iil3084w(0);
	wire_w_lg_w_lg_nli0OOO2545w2547w(0) <= wire_w_lg_nli0OOO2545w(0) OR wire_w_lg_nli0OlO2546w(0);
	wire_w_lg_w_lg_nli1l0i4156w4158w(0) <= wire_w_lg_nli1l0i4156w(0) OR wire_w_lg_nli1l1i4157w(0);
	wire_w_lg_w_lg_nliii1O2007w2009w(0) <= wire_w_lg_nliii1O2007w(0) OR wire_w_lg_nlii0OO2008w(0);
	wire_w_lg_w_lg_nliiO0O1471w1473w(0) <= wire_w_lg_nliiO0O1471w(0) OR wire_w_lg_nliiO1O1472w(0);
	wire_w_lg_w_lg_nlil0iO934w936w(0) <= wire_w_lg_nlil0iO934w(0) OR wire_w_lg_nlil00O935w(0);
	wire_w_lg_w_lg_nlilO1O382w384w(0) <= wire_w_lg_nlilO1O382w(0) OR wire_w_lg_nlillOi383w(0);
	wire_w_lg_nlilO1l293w(0) <= nlilO1l OR nlilO1i;
	wire_w_lg_w_eidleinfersel_range23w200w(0) <= wire_w_eidleinfersel_range23w(0) XOR nl0li;
	wire_w_lg_w_eidleinfersel_range22w207w(0) <= wire_w_eidleinfersel_range22w(0) XOR nl0ll;
	nli000i <= ((((((nlO0lil AND nlO0lii) AND nlO0l0O) AND nlO0l0l) AND nlO0l0i) AND nlO0l1O) AND nlO0l1l);
	nli000l <= ((((wire_nliii_w3766w(0) AND wire_nliii_w_lg_nlO01lO3751w(0)) AND (NOT (test_in_0 XOR nlO01Ol))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nlO01OO))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nlO000i)));
	nli000O <= ((((wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO001O3746w3747w3749w3750w(0) AND wire_nliii_w_lg_nlO01lO3751w(0)) AND (NOT (test_in_0 XOR nlO01Oi))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nlO000i))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nlO000l)));
	nli001i <= (((wire_nliii_w3780w(0) AND wire_nliii_w_lg_nlOiOiO3781w(0)) AND wire_nliii_w_lg_nlOiOil3783w(0)) AND nlOiOii);
	nli001l <= ((((wire_w_lg_w_enable_inf_ei_range40w540w(0) AND (NOT enable_inf_ei(2))) AND (NOT enable_inf_ei(3))) AND (NOT enable_inf_ei(4))) AND (NOT enable_inf_ei(5)));
	nli001O <= ((((((nlO0l1i AND nlO0iOO) AND nlO0iOl) AND nlO0iOi) AND nlO0ilO) AND nlO0ill) AND nlO0ili);
	nli00ii <= (wire_nliii_w_lg_w_lg_w_lg_w3729w3730w3732w3744w(0) AND wire_nliii_w_lg_nlO00ll3698w(0));
	nli00il <= ((((wire_nliii_w3729w(0) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nlO00ll))) AND (NOT (test_in_0 XOR nlO00lO))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nlO00Oi))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nlO00Ol)));
	nli00iO <= ((wire_nliii_w_lg_w_lg_w3729w3730w3732w(0) AND wire_nliii_w_lg_nlO00lO3733w(0)) AND nlO00ll);
	nli00li <= ((((wire_nliii_w3713w(0) AND wire_nliii_w_lg_nlO00ll3698w(0)) AND (NOT (test_in_0 XOR nlO00Oi))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nlO00Ol))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nlO0i1O)));
	nli00ll <= ((((wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO0i1l3693w3694w3696w3697w(0) AND wire_nliii_w_lg_nlO00ll3698w(0)) AND (NOT (test_in_0 XOR nlO00lO))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nlO0i1O))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nlO0i0i)));
	nli00lO <= (nlOl1iO XOR nlOl10l);
	nli00Oi <= (((wire_nliii_w_lg_w3263w3264w(0) AND wire_nliii_w_lg_n1i1lO3245w(0)) AND wire_nliii_w_lg_n1i1ll3247w(0)) AND n1i1li);
	nli00Ol <= (nlOO1il AND nlOO10O);
	nli010i <= (nlOiO0O AND (nli010O OR nli010l));
	nli010l <= (wire_nliii_w_lg_w_lg_w_lg_w3831w3832w3833w3834w(0) AND wire_nliii_w_lg_nlOiOii3529w(0));
	nli010O <= ((wire_nliii_w_lg_w3827w3828w(0) AND wire_nliii_w_lg_nlOiOil3783w(0)) AND wire_nliii_w_lg_nlOiOii3529w(0));
	nli011i <= (wire_nl01l_w_lg_w_lg_nlO101O3600w3602w(0) AND nlO11OO);
	nli011l <= (((wire_nl01l_w_lg_nlO101O3838w(0) AND wire_nl01l_w_lg_nlO101l3606w(0)) AND wire_nl01l_w_lg_nlO101i3601w(0)) AND wire_nl01l_w_lg_nlO11OO3603w(0));
	nli011O <= ((nli01ll OR nli01li) AND nlO100i);
	nli01ii <= (nlOiO0O AND (nli01iO OR nli01il));
	nli01il <= ((wire_nliii_w_lg_w_lg_w3821w3823w3824w(0) AND wire_nliii_w_lg_nlOiOil3783w(0)) AND wire_nliii_w_lg_nlOiOii3529w(0));
	nli01iO <= (wire_nliii_w_lg_w_lg_w3814w3815w3816w(0) AND wire_nliii_w_lg_nlOiOii3529w(0));
	nli01li <= (wire_nliii_w_lg_nlOiOii3529w(0) AND nlOiO0O);
	nli01ll <= (nlOiO0O AND nli01lO);
	nli01lO <= (((((wire_nliii_w_lg_w_lg_w_lg_nlOiOOO3804w3805w3806w(0) AND wire_nliii_w_lg_nlOiOll3807w(0)) AND nlOiOli) AND nlOiOiO) AND nlOiOil) AND nlOiOii);
	nli01Oi <= (nlOiO0O AND nli01Ol);
	nli01Ol <= (((wire_nliii_w_lg_w3790w3791w(0) AND wire_nliii_w_lg_nlOiOiO3781w(0)) AND wire_nliii_w_lg_nlOiOil3783w(0)) AND nlOiOii);
	nli01OO <= (nlOiO0O AND nli001i);
	nli0i0i <= ((nli0iOl OR nli0i0O) OR (nli0iOO AND nli0i0l));
	nli0i0l <= (wire_nl01l_w_lg_w_lg_nlOOi0O3062w3064w(0) AND nlOOi1O);
	nli0i0O <= (((wire_nl01l_w_lg_nlOOi0O3302w(0) AND wire_nl01l_w_lg_nlOOi0l3068w(0)) AND wire_nl01l_w_lg_nlOOi0i3063w(0)) AND wire_nl01l_w_lg_nlOOi1O3065w(0));
	nli0i1l <= (wire_nl01l_w_lg_w_lg_nlOOi0O3069w3070w(0) AND nlOOi1O);
	nli0i1O <= ((wire_nl01l_w_lg_nlOOi0O3062w(0) AND nlOOi0i) AND nlOOi1O);
	nli0iii <= ((nli0iOO OR nli0iOl) AND nlOOiii);
	nli0iil <= (n1i1iO AND (nli0ili OR nli0iiO));
	nli0iiO <= (wire_nliii_w_lg_w_lg_w_lg_w3295w3296w3297w3298w(0) AND wire_nliii_w_lg_n1i1li2991w(0));
	nli0ili <= ((wire_nliii_w_lg_w3291w3292w(0) AND wire_nliii_w_lg_n1i1ll3247w(0)) AND wire_nliii_w_lg_n1i1li2991w(0));
	nli0ill <= (n1i1iO AND (nli0iOi OR nli0ilO));
	nli0ilO <= ((wire_nliii_w_lg_w_lg_w3285w3287w3288w(0) AND wire_nliii_w_lg_n1i1ll3247w(0)) AND wire_nliii_w_lg_n1i1li2991w(0));
	nli0iOi <= (wire_nliii_w_lg_w_lg_w3278w3279w3280w(0) AND wire_nliii_w_lg_n1i1li2991w(0));
	nli0iOl <= (wire_nliii_w_lg_n1i1li2991w(0) AND n1i1iO);
	nli0iOO <= (n1i1iO AND nli0l1i);
	nli0l0i <= (n1i1iO AND nli0l0l);
	nli0l0l <= (((wire_nliii_w3244w(0) AND wire_nliii_w_lg_n1i1lO3245w(0)) AND wire_nliii_w_lg_n1i1ll3247w(0)) AND n1i1li);
	nli0l0O <= ((((wire_w_lg_w_enable_inf_ei_range40w540w(0) AND (NOT enable_inf_ei(2))) AND (NOT enable_inf_ei(3))) AND (NOT enable_inf_ei(4))) AND (NOT enable_inf_ei(5)));
	nli0l1i <= (((((wire_nliii_w_lg_w_lg_w_lg_n1i01O3268w3269w3270w(0) AND wire_nliii_w_lg_n1i1Ol3271w(0)) AND n1i1Oi) AND n1i1lO) AND n1i1ll) AND n1i1li);
	nli0l1l <= (n1i1iO AND nli0l1O);
	nli0l1O <= (((wire_nliii_w_lg_w3254w3255w(0) AND wire_nliii_w_lg_n1i1lO3245w(0)) AND wire_nliii_w_lg_n1i1ll3247w(0)) AND n1i1li);
	nli0lii <= ((((((n11O0i AND n11O1O) AND n11O1l) AND n11O1i) AND n11lOO) AND n11lOl) AND n11lOi);
	nli0lil <= ((((((n11Oll AND n11Oli) AND n11OiO) AND n11Oil) AND n11Oii) AND n11O0O) AND n11O0l);
	nli0liO <= ((((wire_nliii_w3230w(0) AND wire_nliii_w_lg_n110OO3215w(0)) AND (NOT (test_in_0 XOR n11i1l))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n11i1O))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n11iii)));
	nli0lli <= ((((wire_nliii_w_lg_w_lg_w_lg_w_lg_n11i0O3210w3211w3213w3214w(0) AND wire_nliii_w_lg_n110OO3215w(0)) AND (NOT (test_in_0 XOR n11i1i))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n11iii))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n11iil)));
	nli0lll <= (wire_nliii_w_lg_w_lg_w_lg_w3193w3194w3196w3208w(0) AND wire_nliii_w_lg_n11iOl3162w(0));
	nli0llO <= ((((wire_nliii_w3193w(0) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n11iOl))) AND (NOT (test_in_0 XOR n11iOO))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n11l1i))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n11l1l)));
	nli0lOi <= ((wire_nliii_w_lg_w_lg_w3193w3194w3196w(0) AND wire_nliii_w_lg_n11iOO3197w(0)) AND n11iOl);
	nli0lOl <= ((((wire_nliii_w3177w(0) AND wire_nliii_w_lg_n11iOl3162w(0)) AND (NOT (test_in_0 XOR n11l1i))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n11l1l))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n11l0O)));
	nli0lOO <= ((((wire_nliii_w_lg_w_lg_w_lg_w_lg_n11l0l3157w3158w3160w3161w(0) AND wire_nliii_w_lg_n11iOl3162w(0)) AND (NOT (test_in_0 XOR n11iOO))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n11l0O))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n11lii)));
	nli0O0O <= (wire_nl01l_w_lg_w_lg_n1lliO2531w2532w(0) AND n1ll0O);
	nli0O1i <= (n1i0lO XOR n1i0il);
	nli0O1l <= (((wire_nliii_w_lg_w2725w2726w(0) AND wire_nliii_w_lg_n000OO2707w(0)) AND wire_nliii_w_lg_n000Ol2709w(0)) AND n000Oi);
	nli0O1O <= (n1l0ll AND n1l0iO);
	nli0Oii <= ((wire_nl01l_w_lg_n1lliO2524w(0) AND n1llii) AND n1ll0O);
	nli0Oil <= ((nlii11O OR nli0Oli) OR (nlii10i AND nli0OiO));
	nli0OiO <= (wire_nl01l_w_lg_w_lg_n1lliO2524w2526w(0) AND n1ll0O);
	nli0Oli <= (((wire_nl01l_w_lg_n1lliO2764w(0) AND wire_nl01l_w_lg_n1llil2530w(0)) AND wire_nl01l_w_lg_n1llii2525w(0)) AND wire_nl01l_w_lg_n1ll0O2527w(0));
	nli0Oll <= ((nlii10i OR nlii11O) AND n1llli);
	nli0OlO <= (n000lO AND (nli0OOl OR nli0OOi));
	nli0OOi <= (wire_nliii_w_lg_w_lg_w_lg_w2757w2758w2759w2760w(0) AND wire_nliii_w_lg_n000Oi2453w(0));
	nli0OOl <= ((wire_nliii_w_lg_w2753w2754w(0) AND wire_nliii_w_lg_n000Ol2709w(0)) AND wire_nliii_w_lg_n000Oi2453w(0));
	nli0OOO <= (n000lO AND (nlii11l OR nlii11i));
	nli1i0O <= (nliOl1O XOR nliOiOl);
	nli1iii <= (((wire_nliii_w_lg_w4336w4337w(0) AND wire_nliii_w_lg_nllll0O4318w(0)) AND wire_nliii_w_lg_nllll0l4320w(0)) AND nllll0i);
	nli1iil <= (nll1l1l AND nll1iOO);
	nli1ili <= (wire_nl01l_w_lg_w_lg_nll1OOO4143w4144w(0) AND nll1OlO);
	nli1ill <= ((wire_nl01l_w_lg_nll1OOO4136w(0) AND nll1OOi) AND nll1OlO);
	nli1ilO <= ((nli1lii OR nli1iOl) OR (nli1lil AND nli1iOi));
	nli1iOi <= (wire_nl01l_w_lg_w_lg_nll1OOO4136w4138w(0) AND nll1OlO);
	nli1iOl <= (((wire_nl01l_w_lg_nll1OOO4375w(0) AND wire_nl01l_w_lg_nll1OOl4142w(0)) AND wire_nl01l_w_lg_nll1OOi4137w(0)) AND wire_nl01l_w_lg_nll1OlO4139w(0));
	nli1iOO <= ((nli1lil OR nli1lii) AND nll011i);
	nli1l0i <= (nllll1O AND (nli1l0O OR nli1l0l));
	nli1l0l <= ((wire_nliii_w_lg_w_lg_w4358w4360w4361w(0) AND wire_nliii_w_lg_nllll0l4320w(0)) AND wire_nliii_w_lg_nllll0i4065w(0));
	nli1l0O <= (wire_nliii_w_lg_w_lg_w4351w4352w4353w(0) AND wire_nliii_w_lg_nllll0i4065w(0));
	nli1l1i <= (nllll1O AND (nli1l1O OR nli1l1l));
	nli1l1l <= (wire_nliii_w_lg_w_lg_w_lg_w4368w4369w4370w4371w(0) AND wire_nliii_w_lg_nllll0i4065w(0));
	nli1l1O <= ((wire_nliii_w_lg_w4364w4365w(0) AND wire_nliii_w_lg_nllll0l4320w(0)) AND wire_nliii_w_lg_nllll0i4065w(0));
	nli1lii <= (wire_nliii_w_lg_nllll0i4065w(0) AND nllll1O);
	nli1lil <= (nllll1O AND nli1liO);
	nli1liO <= (((((wire_nliii_w_lg_w_lg_w_lg_nlllllO4341w4342w4343w(0) AND wire_nliii_w_lg_nllllil4344w(0)) AND nllllii) AND nllll0O) AND nllll0l) AND nllll0i);
	nli1lli <= (nllll1O AND nli1lll);
	nli1lll <= (((wire_nliii_w_lg_w4327w4328w(0) AND wire_nliii_w_lg_nllll0O4318w(0)) AND wire_nliii_w_lg_nllll0l4320w(0)) AND nllll0i);
	nli1llO <= (nllll1O AND nli1lOi);
	nli1lOi <= (((wire_nliii_w4317w(0) AND wire_nliii_w_lg_nllll0O4318w(0)) AND wire_nliii_w_lg_nllll0l4320w(0)) AND nllll0i);
	nli1lOl <= ((((wire_w_lg_w_enable_inf_ei_range40w540w(0) AND (NOT enable_inf_ei(2))) AND (NOT enable_inf_ei(3))) AND (NOT enable_inf_ei(4))) AND (NOT enable_inf_ei(5)));
	nli1lOO <= ((((((nlli0Oi AND nlli0lO) AND nlli0ll) AND nlli0li) AND nlli0iO) AND nlli0il) AND nlli0ii);
	nli1O0i <= (wire_nliii_w_lg_w_lg_w_lg_w4266w4267w4269w4281w(0) AND wire_nliii_w_lg_nlli1il4235w(0));
	nli1O0l <= ((((wire_nliii_w4266w(0) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nlli1il))) AND (NOT (test_in_0 XOR nlli1iO))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nlli1li))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nlli1ll)));
	nli1O0O <= ((wire_nliii_w_lg_w_lg_w4266w4267w4269w(0) AND wire_nliii_w_lg_nlli1iO4270w(0)) AND nlli1il);
	nli1O1i <= ((((((nllii0l AND nllii0i) AND nllii1O) AND nllii1l) AND nllii1i) AND nlli0OO) AND nlli0Ol);
	nli1O1l <= ((((wire_nliii_w4303w(0) AND wire_nliii_w_lg_nll0OiO4288w(0)) AND (NOT (test_in_0 XOR nll0Oll))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nll0OlO))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nlli11i)));
	nli1O1O <= ((((wire_nliii_w_lg_w_lg_w_lg_w_lg_nll0OOO4283w4284w4286w4287w(0) AND wire_nliii_w_lg_nll0OiO4288w(0)) AND (NOT (test_in_0 XOR nll0Oli))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nlli11i))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nlli11l)));
	nli1Oii <= ((((wire_nliii_w4250w(0) AND wire_nliii_w_lg_nlli1il4235w(0)) AND (NOT (test_in_0 XOR nlli1li))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nlli1ll))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nlli1OO)));
	nli1Oil <= ((((wire_nliii_w_lg_w_lg_w_lg_w_lg_nlli1Ol4230w4231w4233w4234w(0) AND wire_nliii_w_lg_nlli1il4235w(0)) AND (NOT (test_in_0 XOR nlli1iO))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nlli1OO))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nlli01i)));
	nli1OiO <= (nlllO0O XOR nlllO1l);
	nli1Oli <= (((wire_nliii_w_lg_w3799w3800w(0) AND wire_nliii_w_lg_nlOiOiO3781w(0)) AND wire_nliii_w_lg_nlOiOil3783w(0)) AND nlOiOii);
	nli1Oll <= (nllOO0l AND nllOO1O);
	nli1OOi <= (wire_nl01l_w_lg_w_lg_nlO101O3607w3608w(0) AND nlO11OO);
	nli1OOl <= ((wire_nl01l_w_lg_nlO101O3600w(0) AND nlO101i) AND nlO11OO);
	nli1OOO <= ((nli01li OR nli011l) OR (nli01ll AND nli011i));
	nlii00i <= ((((wire_nliii_w_lg_w_lg_w_lg_w_lg_n1OOil2619w2620w2622w2623w(0) AND wire_nliii_w_lg_n1OO1l2624w(0)) AND (NOT (test_in_0 XOR n1OO1O))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n1OOiO))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n1OOli)));
	nlii00l <= (n00iOO XOR n00ill);
	nlii00O <= (((wire_nliii_w_lg_w2187w2188w(0) AND wire_nliii_w_lg_ni1l1O2169w(0)) AND wire_nliii_w_lg_ni1l1l2171w(0)) AND ni1l1i);
	nlii01i <= ((((wire_nliii_w2655w(0) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n1OO1l))) AND (NOT (test_in_0 XOR n1OO1O))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n1OO0i))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n1OO0l)));
	nlii01l <= ((wire_nliii_w_lg_w_lg_w2655w2656w2658w(0) AND wire_nliii_w_lg_n1OO1O2659w(0)) AND n1OO1l);
	nlii01O <= ((((wire_nliii_w2639w(0) AND wire_nliii_w_lg_n1OO1l2624w(0)) AND (NOT (test_in_0 XOR n1OO0i))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n1OO0l))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n1OOiO)));
	nlii0ii <= (n0iiOl AND n0iilO);
	nlii0iO <= (wire_nl01l_w_lg_w_lg_n0iOlO1995w1996w(0) AND n0iOiO);
	nlii0li <= ((wire_nl01l_w_lg_n0iOlO1988w(0) AND n0iOli) AND n0iOiO);
	nlii0ll <= ((nliii0O OR nlii0Oi) OR (nliiiii AND nlii0lO));
	nlii0lO <= (wire_nl01l_w_lg_w_lg_n0iOlO1988w1990w(0) AND n0iOiO);
	nlii0Oi <= (((wire_nl01l_w_lg_n0iOlO2226w(0) AND wire_nl01l_w_lg_n0iOll1994w(0)) AND wire_nl01l_w_lg_n0iOli1989w(0)) AND wire_nl01l_w_lg_n0iOiO1991w(0));
	nlii0Ol <= ((nliiiii OR nliii0O) AND n0iOOi);
	nlii0OO <= (ni1iOO AND (nliii1l OR nliii1i));
	nlii10i <= (n000lO AND nlii10l);
	nlii10l <= (((((wire_nliii_w_lg_w_lg_w_lg_n00i0O2730w2731w2732w(0) AND wire_nliii_w_lg_n00i1l2733w(0)) AND n00i1i) AND n000OO) AND n000Ol) AND n000Oi);
	nlii10O <= (n000lO AND nlii1ii);
	nlii11i <= ((wire_nliii_w_lg_w_lg_w2747w2749w2750w(0) AND wire_nliii_w_lg_n000Ol2709w(0)) AND wire_nliii_w_lg_n000Oi2453w(0));
	nlii11l <= (wire_nliii_w_lg_w_lg_w2740w2741w2742w(0) AND wire_nliii_w_lg_n000Oi2453w(0));
	nlii11O <= (wire_nliii_w_lg_n000Oi2453w(0) AND n000lO);
	nlii1ii <= (((wire_nliii_w_lg_w2716w2717w(0) AND wire_nliii_w_lg_n000OO2707w(0)) AND wire_nliii_w_lg_n000Ol2709w(0)) AND n000Oi);
	nlii1il <= (n000lO AND nlii1iO);
	nlii1iO <= (((wire_nliii_w2706w(0) AND wire_nliii_w_lg_n000OO2707w(0)) AND wire_nliii_w_lg_n000Ol2709w(0)) AND n000Oi);
	nlii1li <= ((((wire_w_lg_w_enable_inf_ei_range40w540w(0) AND (NOT enable_inf_ei(2))) AND (NOT enable_inf_ei(3))) AND (NOT enable_inf_ei(4))) AND (NOT enable_inf_ei(5)));
	nlii1ll <= ((((((n011ii AND n0110O) AND n0110l) AND n0110i) AND n0111O) AND n0111l) AND n0111i);
	nlii1lO <= ((((((n011Ol AND n011Oi) AND n011lO) AND n011ll) AND n011li) AND n011iO) AND n011il);
	nlii1Oi <= ((((wire_nliii_w2692w(0) AND wire_nliii_w_lg_n1Ol1O2677w(0)) AND (NOT (test_in_0 XOR n1Ol0l))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n1Ol0O))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n1Olli)));
	nlii1Ol <= ((((wire_nliii_w_lg_w_lg_w_lg_w_lg_n1OliO2672w2673w2675w2676w(0) AND wire_nliii_w_lg_n1Ol1O2677w(0)) AND (NOT (test_in_0 XOR n1Ol0i))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n1Olli))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n1Olll)));
	nlii1OO <= (wire_nliii_w_lg_w_lg_w_lg_w2655w2656w2658w2670w(0) AND wire_nliii_w_lg_n1OO1l2624w(0));
	nliii0i <= ((wire_nliii_w_lg_w_lg_w2209w2211w2212w(0) AND wire_nliii_w_lg_ni1l1l2171w(0)) AND wire_nliii_w_lg_ni1l1i1917w(0));
	nliii0l <= (wire_nliii_w_lg_w_lg_w2202w2203w2204w(0) AND wire_nliii_w_lg_ni1l1i1917w(0));
	nliii0O <= (wire_nliii_w_lg_ni1l1i1917w(0) AND ni1iOO);
	nliii1i <= (wire_nliii_w_lg_w_lg_w_lg_w2219w2220w2221w2222w(0) AND wire_nliii_w_lg_ni1l1i1917w(0));
	nliii1l <= ((wire_nliii_w_lg_w2215w2216w(0) AND wire_nliii_w_lg_ni1l1l2171w(0)) AND wire_nliii_w_lg_ni1l1i1917w(0));
	nliii1O <= (ni1iOO AND (nliii0l OR nliii0i));
	nliiiii <= (ni1iOO AND nliiiil);
	nliiiil <= (((((wire_nliii_w_lg_w_lg_w_lg_ni1liO2192w2193w2194w(0) AND wire_nliii_w_lg_ni1l0l2195w(0)) AND ni1l0i) AND ni1l1O) AND ni1l1l) AND ni1l1i);
	nliiiiO <= (ni1iOO AND nliiili);
	nliiili <= (((wire_nliii_w_lg_w2178w2179w(0) AND wire_nliii_w_lg_ni1l1O2169w(0)) AND wire_nliii_w_lg_ni1l1l2171w(0)) AND ni1l1i);
	nliiill <= (ni1iOO AND nliiilO);
	nliiilO <= (((wire_nliii_w2168w(0) AND wire_nliii_w_lg_ni1l1O2169w(0)) AND wire_nliii_w_lg_ni1l1l2171w(0)) AND ni1l1i);
	nliiiOi <= ((((wire_w_lg_w_enable_inf_ei_range40w540w(0) AND (NOT enable_inf_ei(2))) AND (NOT enable_inf_ei(3))) AND (NOT enable_inf_ei(4))) AND (NOT enable_inf_ei(5)));
	nliiiOl <= ((((((n0O0li AND n0O0iO) AND n0O0il) AND n0O0ii) AND n0O00O) AND n0O00l) AND n0O00i);
	nliiiOO <= ((((((n0Oi1l AND n0Oi1i) AND n0O0OO) AND n0O0Ol) AND n0O0Oi) AND n0O0lO) AND n0O0ll);
	nliil0i <= ((((wire_nliii_w2117w(0) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n0O10l))) AND (NOT (test_in_0 XOR n0O10O))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n0O1ii))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n0O1il)));
	nliil0l <= ((wire_nliii_w_lg_w_lg_w2117w2118w2120w(0) AND wire_nliii_w_lg_n0O10O2121w(0)) AND n0O10l);
	nliil0O <= ((((wire_nliii_w2101w(0) AND wire_nliii_w_lg_n0O10l2086w(0)) AND (NOT (test_in_0 XOR n0O1ii))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n0O1il))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n0O1lO)));
	nliil1i <= ((((wire_nliii_w2154w(0) AND wire_nliii_w_lg_n0lO0O2139w(0)) AND (NOT (test_in_0 XOR n0lOil))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n0lOiO))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n0lOOi)));
	nliil1l <= ((((wire_nliii_w_lg_w_lg_w_lg_w_lg_n0lOlO2134w2135w2137w2138w(0) AND wire_nliii_w_lg_n0lO0O2139w(0)) AND (NOT (test_in_0 XOR n0lOii))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n0lOOi))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n0lOOl)));
	nliil1O <= (wire_nliii_w_lg_w_lg_w_lg_w2117w2118w2120w2132w(0) AND wire_nliii_w_lg_n0O10l2086w(0));
	nliilii <= ((((wire_nliii_w_lg_w_lg_w_lg_w_lg_n0O1ll2081w2082w2084w2085w(0) AND wire_nliii_w_lg_n0O10l2086w(0)) AND (NOT (test_in_0 XOR n0O10O))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n0O1lO))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n0O1Oi)));
	nliilil <= (ni1O1O XOR ni1lOl);
	nliiliO <= (((wire_nliii_w_lg_w1651w1652w(0) AND wire_nliii_w_lg_niOO0O1633w(0)) AND wire_nliii_w_lg_niOO0l1635w(0)) AND niOO0i);
	nliilli <= (ni0O1l AND ni0lOO);
	nliillO <= (wire_nl01l_w_lg_w_lg_nii1OO1458w1459w(0) AND nii1lO);
	nliilOi <= ((wire_nl01l_w_lg_nii1OO1451w(0) AND nii1Oi) AND nii1lO);
	nliilOl <= ((nliiOiO OR nliiO1i) OR (nliiOli AND nliilOO));
	nliilOO <= (wire_nl01l_w_lg_w_lg_nii1OO1451w1453w(0) AND nii1lO);
	nliiO0i <= (wire_nliii_w_lg_w_lg_w_lg_w1683w1684w1685w1686w(0) AND wire_nliii_w_lg_niOO0i1380w(0));
	nliiO0l <= ((wire_nliii_w_lg_w1679w1680w(0) AND wire_nliii_w_lg_niOO0l1635w(0)) AND wire_nliii_w_lg_niOO0i1380w(0));
	nliiO0O <= (niOO1O AND (nliiOil OR nliiOii));
	nliiO1i <= (((wire_nl01l_w_lg_nii1OO1690w(0) AND wire_nl01l_w_lg_nii1Ol1457w(0)) AND wire_nl01l_w_lg_nii1Oi1452w(0)) AND wire_nl01l_w_lg_nii1lO1454w(0));
	nliiO1l <= ((nliiOli OR nliiOiO) AND nii01i);
	nliiO1O <= (niOO1O AND (nliiO0l OR nliiO0i));
	nliiOii <= ((wire_nliii_w_lg_w_lg_w1673w1675w1676w(0) AND wire_nliii_w_lg_niOO0l1635w(0)) AND wire_nliii_w_lg_niOO0i1380w(0));
	nliiOil <= (wire_nliii_w_lg_w_lg_w1666w1667w1668w(0) AND wire_nliii_w_lg_niOO0i1380w(0));
	nliiOiO <= (wire_nliii_w_lg_niOO0i1380w(0) AND niOO1O);
	nliiOli <= (niOO1O AND nliiOll);
	nliiOll <= (((((wire_nliii_w_lg_w_lg_w_lg_niOOlO1656w1657w1658w(0) AND wire_nliii_w_lg_niOOil1659w(0)) AND niOOii) AND niOO0O) AND niOO0l) AND niOO0i);
	nliiOlO <= (niOO1O AND nliiOOi);
	nliiOOi <= (((wire_nliii_w_lg_w1642w1643w(0) AND wire_nliii_w_lg_niOO0O1633w(0)) AND wire_nliii_w_lg_niOO0l1635w(0)) AND niOO0i);
	nliiOOl <= (niOO1O AND nliiOOO);
	nliiOOO <= (((wire_nliii_w1632w(0) AND wire_nliii_w_lg_niOO0O1633w(0)) AND wire_nliii_w_lg_niOO0l1635w(0)) AND niOO0i);
	nlil00i <= (((wire_nl01l_w_lg_nl0i1O1153w(0) AND wire_nl01l_w_lg_nl0i1l921w(0)) AND wire_nl01l_w_lg_nl0i1i916w(0)) AND wire_nl01l_w_lg_nl00OO918w(0));
	nlil00l <= ((nlil0Oi OR nlil0lO) AND nl0i0i);
	nlil00O <= (nlO10O AND (nlil0il OR nlil0ii));
	nlil01i <= ((wire_nl01l_w_lg_nl0i1O915w(0) AND nl0i1i) AND nl00OO);
	nlil01l <= ((nlil0lO OR nlil00i) OR (nlil0Oi AND nlil01O));
	nlil01O <= (wire_nl01l_w_lg_w_lg_nl0i1O915w917w(0) AND nl00OO);
	nlil0ii <= (wire_nliii_w_lg_w_lg_w_lg_w1146w1147w1148w1149w(0) AND wire_nliii_w_lg_nlO1ii844w(0));
	nlil0il <= ((wire_nliii_w_lg_w1142w1143w(0) AND wire_nliii_w_lg_nlO1il1098w(0)) AND wire_nliii_w_lg_nlO1ii844w(0));
	nlil0iO <= (nlO10O AND (nlil0ll OR nlil0li));
	nlil0li <= ((wire_nliii_w_lg_w_lg_w1136w1138w1139w(0) AND wire_nliii_w_lg_nlO1il1098w(0)) AND wire_nliii_w_lg_nlO1ii844w(0));
	nlil0ll <= (wire_nliii_w_lg_w_lg_w1129w1130w1131w(0) AND wire_nliii_w_lg_nlO1ii844w(0));
	nlil0lO <= (wire_nliii_w_lg_nlO1ii844w(0) AND nlO10O);
	nlil0Oi <= (nlO10O AND nlil0Ol);
	nlil0Ol <= (((((wire_nliii_w_lg_w_lg_w_lg_nlO1OO1119w1120w1121w(0) AND wire_nliii_w_lg_nlO1ll1122w(0)) AND nlO1li) AND nlO1iO) AND nlO1il) AND nlO1ii);
	nlil0OO <= (nlO10O AND nlili1i);
	nlil10i <= ((((wire_nliii_w1618w(0) AND wire_nliii_w_lg_nil1iO1603w(0)) AND (NOT (test_in_0 XOR nil1ll))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nil1lO))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nil01i)));
	nlil10l <= ((((wire_nliii_w_lg_w_lg_w_lg_w_lg_nil1OO1598w1599w1601w1602w(0) AND wire_nliii_w_lg_nil1iO1603w(0)) AND (NOT (test_in_0 XOR nil1li))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nil01i))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nil01l)));
	nlil10O <= (wire_nliii_w_lg_w_lg_w_lg_w1581w1582w1584w1596w(0) AND wire_nliii_w_lg_nil0il1550w(0));
	nlil11i <= ((((wire_w_lg_w_enable_inf_ei_range40w540w(0) AND (NOT enable_inf_ei(2))) AND (NOT enable_inf_ei(3))) AND (NOT enable_inf_ei(4))) AND (NOT enable_inf_ei(5)));
	nlil11l <= ((((((niliOi AND nililO) AND nilill) AND nilili) AND niliiO) AND niliil) AND niliii);
	nlil11O <= ((((((nill0l AND nill0i) AND nill1O) AND nill1l) AND nill1i) AND niliOO) AND niliOl);
	nlil1ii <= ((((wire_nliii_w1581w(0) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nil0il))) AND (NOT (test_in_0 XOR nil0iO))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nil0li))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nil0ll)));
	nlil1il <= ((wire_nliii_w_lg_w_lg_w1581w1582w1584w(0) AND wire_nliii_w_lg_nil0iO1585w(0)) AND nil0il);
	nlil1iO <= ((((wire_nliii_w1565w(0) AND wire_nliii_w_lg_nil0il1550w(0)) AND (NOT (test_in_0 XOR nil0li))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nil0ll))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nil0OO)));
	nlil1li <= ((((wire_nliii_w_lg_w_lg_w_lg_w_lg_nil0Ol1545w1546w1548w1549w(0) AND wire_nliii_w_lg_nil0il1550w(0)) AND (NOT (test_in_0 XOR nil0iO))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nil0OO))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nili1i)));
	nlil1ll <= (nl110O XOR nl111l);
	nlil1lO <= (((wire_nliii_w_lg_w1114w1115w(0) AND wire_nliii_w_lg_nlO1iO1096w(0)) AND wire_nliii_w_lg_nlO1il1098w(0)) AND nlO1ii);
	nlil1Oi <= (nl010l AND nl011O);
	nlil1OO <= (wire_nl01l_w_lg_w_lg_nl0i1O922w923w(0) AND nl00OO);
	nlili0i <= ((((wire_w_lg_w_enable_inf_ei_range40w540w(0) AND (NOT enable_inf_ei(2))) AND (NOT enable_inf_ei(3))) AND (NOT enable_inf_ei(4))) AND (NOT enable_inf_ei(5)));
	nlili0l <= ((((((nliO1i AND nlilOO) AND nlilOl) AND nlilOi) AND nlillO) AND nlilll) AND nlilli);
	nlili0O <= ((((((nliOil AND nliOii) AND nliO0O) AND nliO0l) AND nliO0i) AND nliO1O) AND nliO1l);
	nlili1i <= (((wire_nliii_w_lg_w1105w1106w(0) AND wire_nliii_w_lg_nlO1iO1096w(0)) AND wire_nliii_w_lg_nlO1il1098w(0)) AND nlO1ii);
	nlili1l <= (nlO10O AND nlili1O);
	nlili1O <= (((wire_nliii_w1095w(0) AND wire_nliii_w_lg_nlO1iO1096w(0)) AND wire_nliii_w_lg_nlO1il1098w(0)) AND nlO1ii);
	nliliii <= ((((wire_nliii_w1081w(0) AND wire_nliii_w_lg_nli0lO1066w(0)) AND (NOT (test_in_0 XOR nli0Ol))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nli0OO))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nlii0i)));
	nliliil <= ((((wire_nliii_w_lg_w_lg_w_lg_w_lg_nlii1O1061w1062w1064w1065w(0) AND wire_nliii_w_lg_nli0lO1066w(0)) AND (NOT (test_in_0 XOR nli0Oi))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nlii0i))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nlii0l)));
	nliliiO <= (wire_nliii_w_lg_w_lg_w_lg_w1044w1045w1047w1059w(0) AND wire_nliii_w_lg_nliill1013w(0));
	nlilili <= ((((wire_nliii_w1044w(0) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nliill))) AND (NOT (test_in_0 XOR nliilO))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nliiOi))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nliiOl)));
	nlilill <= ((wire_nliii_w_lg_w_lg_w1044w1045w1047w(0) AND wire_nliii_w_lg_nliilO1048w(0)) AND nliill);
	nlililO <= ((((wire_nliii_w1028w(0) AND wire_nliii_w_lg_nliill1013w(0)) AND (NOT (test_in_0 XOR nliiOi))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nliiOl))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nlil1O)));
	nliliOi <= ((((wire_nliii_w_lg_w_lg_w_lg_w_lg_nlil1l1008w1009w1011w1012w(0) AND wire_nliii_w_lg_nliill1013w(0)) AND (NOT (test_in_0 XOR nliilO))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nlil1O))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR nlil0i)));
	nlill0i <= (((wire_nliii_w574w(0) AND wire_nliii_w_lg_nli1i555w(0)) AND wire_nliii_w_lg_nl0OO557w(0)) AND nl0Ol);
	nlill0l <= (n10ll AND n10iO);
	nlill1O <= (nlO0ll XOR nlO00O);
	nlillii <= (wire_nl01l_w_lg_w_lg_n1liO370w371w(0) AND n1l0O);
	nlillil <= ((wire_nl01l_w_lg_n1liO363w(0) AND n1lii) AND n1l0O);
	nlilliO <= ((nlilOil OR nlillll) OR (nlilOll AND nlillli));
	nlillli <= (wire_nl01l_w_lg_w_lg_n1liO363w365w(0) AND n1l0O);
	nlillll <= (((wire_nl01l_w_lg_n1liO612w(0) AND wire_nl01l_w_lg_n1lil369w(0)) AND wire_nl01l_w_lg_n1lii364w(0)) AND wire_nl01l_w_lg_n1l0O366w(0));
	nlilllO <= ((nlilOll OR nlilOil) AND n1lli);
	nlillOi <= (wire_nliii_w_lg_nl0Oi294w(0) AND (nlillOl44 XOR nlillOl43));
	nlilO0O <= ((wire_nliii_w_lg_w597w598w(0) AND wire_nliii_w_lg_nl0OO557w(0)) AND wire_nliii_w_lg_nl0Ol282w(0));
	nlilO1i <= (wire_nliii_w_lg_w_lg_w606w607w608w(0) AND wire_nliii_w_lg_nl0Ol282w(0));
	nlilO1l <= ((wire_nliii_w602w(0) AND wire_nliii_w_lg_nl0OO557w(0)) AND wire_nliii_w_lg_nl0Ol282w(0));
	nlilO1O <= (nl0Oi AND ((nlilOii OR nlilO0O) OR (NOT (nlilO0i42 XOR nlilO0i41))));
	nlilOii <= (wire_nliii_w_lg_w589w590w(0) AND wire_nliii_w_lg_nl0Ol282w(0));
	nlilOil <= (wire_nliii_w_lg_w_lg_nl0Ol282w283w(0) AND (nlilOiO40 XOR nlilOiO39));
	nlilOll <= (nl0Oi AND nlilOlO);
	nlilOlO <= (((((wire_nliii_w_lg_w_lg_w_lg_nliil578w579w580w(0) AND wire_nliii_w_lg_nli1O581w(0)) AND nli1l) AND nli1i) AND nl0OO) AND nl0Ol);
	nlilOOi <= (nl0Oi AND nlilOOl);
	nlilOOl <= (((wire_nliii_w565w(0) AND wire_nliii_w_lg_nli1i555w(0)) AND wire_nliii_w_lg_nl0OO557w(0)) AND nl0Ol);
	nlilOOO <= ((nl0Oi AND nliO11O) AND (nliO11i38 XOR nliO11i37));
	nliO00i <= (wire_nliii_w_lg_w_lg_w494w496w508w(0) AND wire_nliii_w_lg_n0O1l461w(0));
	nliO00l <= ((((wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_n0Oli473w487w489w491w493w(0) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n0O1l))) AND (NOT (test_in_0 XOR n0O1O))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n0O0i))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n0O0l)));
	nliO00O <= ((wire_nliii_w_lg_w494w496w(0) AND wire_nliii_w_lg_n0O1O497w(0)) AND n0O1l);
	nliO01i <= ((((wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_n0lll526w527w528w529w530w(0) AND wire_nliii_w_lg_n0l1O515w(0)) AND (NOT (test_in_0 XOR n0l0l))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n0l0O))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n0lli)));
	nliO01l <= ((((wire_nliii_w_lg_w_lg_w_lg_w_lg_n0liO510w511w513w514w(0) AND wire_nliii_w_lg_n0l1O515w(0)) AND (NOT (test_in_0 XOR n0l0i))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n0lli))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n0lll)));
	nliO0ii <= ((((wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_n0Oli473w474w475w476w477w(0) AND wire_nliii_w_lg_n0O1l461w(0)) AND (NOT (test_in_0 XOR n0O0i))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n0O0l))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n0OiO)));
	nliO0il <= ((((wire_nliii_w_lg_w_lg_w_lg_w_lg_n0Oil456w457w459w460w(0) AND wire_nliii_w_lg_n0O1l461w(0)) AND (NOT (test_in_0 XOR n0O1O))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n0OiO))) AND (NOT (wire_w_lg_test_in_0466w(0) XOR n0Oli)));
	nliO11O <= (((wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_nliil550w551w552w553w554w(0) AND wire_nliii_w_lg_nli1i555w(0)) AND wire_nliii_w_lg_nl0OO557w(0)) AND nl0Ol);
	nliO1ii <= ((((wire_w_lg_w_enable_inf_ei_range40w540w(0) AND (NOT enable_inf_ei(2))) AND (NOT enable_inf_ei(3))) AND (NOT enable_inf_ei(4))) AND (NOT enable_inf_ei(5)));
	nliO1Ol <= ((((((ni1ii AND ni10O) AND ni10l) AND ni10i) AND ni11O) AND ni11l) AND ni11i);
	nliO1OO <= ((((((ni1Ol AND ni1Oi) AND ni1lO) AND ni1ll) AND ni1li) AND ni1iO) AND ni1il);
	nliOiii <= '1';
	rxelecidle <= ( ni1OO & nliOiO & nill0O & n0Oi1O & n011OO & n11OlO & nlO0liO & nllii0O);
	wire_w_eidleinfersel_range23w(0) <= eidleinfersel(1);
	wire_w_eidleinfersel_range22w(0) <= eidleinfersel(2);
	wire_w_enable_inf_ei_range40w(0) <= enable_inf_ei(0);
	wire_w_enable_inf_ei_range41w(0) <= enable_inf_ei(1);
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nli00OO67 <= nli00OO68;
		END IF;
		if (now = 0 ns) then
			nli00OO67 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nli00OO68 <= nli00OO67;
		END IF;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nli0i1i65 <= nli0i1i66;
		END IF;
		if (now = 0 ns) then
			nli0i1i65 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nli0i1i66 <= nli0i1i65;
		END IF;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nli0O0i63 <= nli0O0i64;
		END IF;
		if (now = 0 ns) then
			nli0O0i63 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nli0O0i64 <= nli0O0i63;
		END IF;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nli0O0l61 <= nli0O0l62;
		END IF;
		if (now = 0 ns) then
			nli0O0l61 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nli0O0l62 <= nli0O0l61;
		END IF;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nli1iiO71 <= nli1iiO72;
		END IF;
		if (now = 0 ns) then
			nli1iiO71 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nli1iiO72 <= nli1iiO71;
		END IF;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nli1OlO69 <= nli1OlO70;
		END IF;
		if (now = 0 ns) then
			nli1OlO69 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nli1OlO70 <= nli1OlO69;
		END IF;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nlii0il59 <= nlii0il60;
		END IF;
		if (now = 0 ns) then
			nlii0il59 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nlii0il60 <= nlii0il59;
		END IF;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliilll57 <= nliilll58;
		END IF;
		if (now = 0 ns) then
			nliilll57 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliilll58 <= nliilll57;
		END IF;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nlil1Ol55 <= nlil1Ol56;
		END IF;
		if (now = 0 ns) then
			nlil1Ol55 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nlil1Ol56 <= nlil1Ol55;
		END IF;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliliOl53 <= nliliOl54;
		END IF;
		if (now = 0 ns) then
			nliliOl53 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliliOl54 <= nliliOl53;
		END IF;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliliOO51 <= nliliOO52;
		END IF;
		if (now = 0 ns) then
			nliliOO51 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliliOO52 <= nliliOO51;
		END IF;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nlill0O45 <= nlill0O46;
		END IF;
		if (now = 0 ns) then
			nlill0O45 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nlill0O46 <= nlill0O45;
		END IF;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nlill1i49 <= nlill1i50;
		END IF;
		if (now = 0 ns) then
			nlill1i49 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nlill1i50 <= nlill1i49;
		END IF;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nlill1l47 <= nlill1l48;
		END IF;
		if (now = 0 ns) then
			nlill1l47 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nlill1l48 <= nlill1l47;
		END IF;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nlillOl43 <= nlillOl44;
		END IF;
		if (now = 0 ns) then
			nlillOl43 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nlillOl44 <= nlillOl43;
		END IF;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nlilO0i41 <= nlilO0i42;
		END IF;
		if (now = 0 ns) then
			nlilO0i41 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nlilO0i42 <= nlilO0i41;
		END IF;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nlilOiO39 <= nlilOiO40;
		END IF;
		if (now = 0 ns) then
			nlilOiO39 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nlilOiO40 <= nlilOiO39;
		END IF;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliO01O23 <= nliO01O24;
		END IF;
		if (now = 0 ns) then
			nliO01O23 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliO01O24 <= nliO01O23;
		END IF;
	END PROCESS;
	wire_nliO01O24_w_lg_w_lg_q161w162w(0) <= wire_nliO01O24_w_lg_q161w(0) AND n0l0l;
	wire_nliO01O24_w_lg_q161w(0) <= nliO01O24 XOR nliO01O23;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliO0iO21 <= nliO0iO22;
		END IF;
		if (now = 0 ns) then
			nliO0iO21 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliO0iO22 <= nliO0iO21;
		END IF;
	END PROCESS;
	wire_nliO0iO22_w_lg_w_lg_q123w124w(0) <= wire_nliO0iO22_w_lg_q123w(0) AND n0O0O;
	wire_nliO0iO22_w_lg_q123w(0) <= nliO0iO22 XOR nliO0iO21;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliO0li19 <= nliO0li20;
		END IF;
		if (now = 0 ns) then
			nliO0li19 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliO0li20 <= nliO0li19;
		END IF;
	END PROCESS;
	wire_nliO0li20_w_lg_w_lg_q120w121w(0) <= wire_nliO0li20_w_lg_q120w(0) AND n0O0l;
	wire_nliO0li20_w_lg_q120w(0) <= nliO0li20 XOR nliO0li19;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliO0ll17 <= nliO0ll18;
		END IF;
		if (now = 0 ns) then
			nliO0ll17 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliO0ll18 <= nliO0ll17;
		END IF;
	END PROCESS;
	wire_nliO0ll18_w_lg_w_lg_q91w92w(0) <= wire_nliO0ll18_w_lg_q91w(0) AND ni1ii;
	wire_nliO0ll18_w_lg_q91w(0) <= nliO0ll18 XOR nliO0ll17;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliO0lO15 <= nliO0lO16;
		END IF;
		if (now = 0 ns) then
			nliO0lO15 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliO0lO16 <= nliO0lO15;
		END IF;
	END PROCESS;
	wire_nliO0lO16_w_lg_w_lg_q85w86w(0) <= wire_nliO0lO16_w_lg_q85w(0) AND ni11O;
	wire_nliO0lO16_w_lg_q85w(0) <= nliO0lO16 XOR nliO0lO15;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliO0Oi13 <= nliO0Oi14;
		END IF;
		if (now = 0 ns) then
			nliO0Oi13 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliO0Oi14 <= nliO0Oi13;
		END IF;
	END PROCESS;
	wire_nliO0Oi14_w_lg_w_lg_q54w55w(0) <= wire_nliO0Oi14_w_lg_q54w(0) AND ni1ll;
	wire_nliO0Oi14_w_lg_q54w(0) <= nliO0Oi14 XOR nliO0Oi13;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliO0Ol11 <= nliO0Ol12;
		END IF;
		if (now = 0 ns) then
			nliO0Ol11 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliO0Ol12 <= nliO0Ol11;
		END IF;
	END PROCESS;
	wire_nliO0Ol12_w_lg_w_lg_q50w51w(0) <= wire_nliO0Ol12_w_lg_q50w(0) AND ni1iO;
	wire_nliO0Ol12_w_lg_q50w(0) <= nliO0Ol12 XOR nliO0Ol11;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliO0OO10 <= nliO0OO9;
		END IF;
	END PROCESS;
	wire_nliO0OO10_w_lg_w_lg_q46w47w(0) <= wire_nliO0OO10_w_lg_q46w(0) AND ni1il;
	wire_nliO0OO10_w_lg_q46w(0) <= nliO0OO10 XOR nliO0OO9;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliO0OO9 <= nliO0OO10;
		END IF;
		if (now = 0 ns) then
			nliO0OO9 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliO10i35 <= nliO10i36;
		END IF;
		if (now = 0 ns) then
			nliO10i35 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliO10i36 <= nliO10i35;
		END IF;
	END PROCESS;
	wire_nliO10i36_w_lg_w_lg_q257w258w(0) <= wire_nliO10i36_w_lg_q257w(0) AND nl0iO;
	wire_nliO10i36_w_lg_q257w(0) <= nliO10i36 XOR nliO10i35;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliO10l33 <= nliO10l34;
		END IF;
		if (now = 0 ns) then
			nliO10l33 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliO10l34 <= nliO10l33;
		END IF;
	END PROCESS;
	wire_nliO10l34_w_lg_w_lg_q231w232w(0) <= wire_nliO10l34_w_lg_q231w(0) AND wire_n0ili_dataout;
	wire_nliO10l34_w_lg_q231w(0) <= nliO10l34 XOR nliO10l33;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliO10O31 <= nliO10O32;
		END IF;
		if (now = 0 ns) then
			nliO10O31 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliO10O32 <= nliO10O31;
		END IF;
	END PROCESS;
	wire_nliO10O32_w_lg_w_lg_q225w226w(0) <= wire_nliO10O32_w_lg_q225w(0) AND nl0li;
	wire_nliO10O32_w_lg_q225w(0) <= nliO10O32 XOR nliO10O31;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliO11i37 <= nliO11i38;
		END IF;
		if (now = 0 ns) then
			nliO11i37 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliO11i38 <= nliO11i37;
		END IF;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliO1il29 <= nliO1il30;
		END IF;
		if (now = 0 ns) then
			nliO1il29 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliO1il30 <= nliO1il29;
		END IF;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliO1li27 <= nliO1li28;
		END IF;
		if (now = 0 ns) then
			nliO1li27 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliO1li28 <= nliO1li27;
		END IF;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliO1lO25 <= nliO1lO26;
		END IF;
		if (now = 0 ns) then
			nliO1lO25 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliO1lO26 <= nliO1lO25;
		END IF;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliOi0i3 <= nliOi0i4;
		END IF;
		if (now = 0 ns) then
			nliOi0i3 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliOi0i4 <= nliOi0i3;
		END IF;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliOi1i7 <= nliOi1i8;
		END IF;
		if (now = 0 ns) then
			nliOi1i7 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliOi1i8 <= nliOi1i7;
		END IF;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliOi1l5 <= nliOi1l6;
		END IF;
		if (now = 0 ns) then
			nliOi1l5 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliOi1l6 <= nliOi1l5;
		END IF;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliOiiO1 <= nliOiiO2;
		END IF;
		if (now = 0 ns) then
			nliOiiO1 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (pclk)
	BEGIN
		IF (pclk = '1' AND pclk'event) THEN nliOiiO2 <= nliOiiO1;
		END IF;
	END PROCESS;
	PROCESS (pclk, wire_n0iOii_PRN, prstn)
	BEGIN
		IF (wire_n0iOii_PRN = '0') THEN
				n0iO0O <= '1';
				n0iOil <= '1';
		ELSIF (prstn = '0') THEN
				n0iO0O <= '0';
				n0iOil <= '0';
		ELSIF (pclk = '1' AND pclk'event) THEN
			IF (wire_n0l0iO_o = '1') THEN
				n0iO0O <= nlii0OO;
				n0iOil <= nliii1O;
			END IF;
		END IF;
	END PROCESS;
	wire_n0iOii_PRN <= (nlii0il60 XOR nlii0il59);
	PROCESS (pclk, wire_n1l0i_PRN, prstn)
	BEGIN
		IF (wire_n1l0i_PRN = '0') THEN
				n1l0l <= '1';
				n1l1O <= '1';
		ELSIF (prstn = '0') THEN
				n1l0l <= '0';
				n1l1O <= '0';
		ELSIF (pclk = '1' AND pclk'event) THEN
			IF (wire_n010O_o = '1') THEN
				n1l0l <= nlilO1O;
				n1l1O <= nlillOi;
			END IF;
		END IF;
	END PROCESS;
	wire_n1l0i_PRN <= (nlill0O46 XOR nlill0O45);
	PROCESS (pclk, wire_n1ll0i_PRN, wire_n1ll0i_CLRN)
	BEGIN
		IF (wire_n1ll0i_PRN = '0') THEN
				n1ll0l <= '1';
				n1ll1O <= '1';
		ELSIF (wire_n1ll0i_CLRN = '0') THEN
				n1ll0l <= '0';
				n1ll1O <= '0';
		ELSIF (pclk = '1' AND pclk'event) THEN
			IF (wire_n1O10O_o = '1') THEN
				n1ll0l <= nli0OOO;
				n1ll1O <= nli0OlO;
			END IF;
		END IF;
	END PROCESS;
	wire_n1ll0i_CLRN <= ((nli0O0l62 XOR nli0O0l61) AND prstn);
	wire_n1ll0i_PRN <= (nli0O0i64 XOR nli0O0i63);
	PROCESS (pclk, wire_nii1li_CLRN)
	BEGIN
		IF (wire_nii1li_CLRN = '0') THEN
				nii1iO <= '0';
				nii1ll <= '0';
		ELSIF (pclk = '1' AND pclk'event) THEN
			IF (wire_niiilO_o = '1') THEN
				nii1iO <= nliiO1O;
				nii1ll <= nliiO0O;
			END IF;
		END IF;
	END PROCESS;
	wire_nii1li_CLRN <= ((nliilll58 XOR nliilll57) AND prstn);
	PROCESS (pclk, wire_nl00Oi_PRN, prstn)
	BEGIN
		IF (wire_nl00Oi_PRN = '0') THEN
				nl00lO <= '1';
				nl00Ol <= '1';
		ELSIF (prstn = '0') THEN
				nl00lO <= '0';
				nl00Ol <= '0';
		ELSIF (pclk = '1' AND pclk'event) THEN
			IF (wire_nl0lOO_o = '1') THEN
				nl00lO <= nlil00O;
				nl00Ol <= nlil0iO;
			END IF;
		END IF;
	END PROCESS;
	wire_nl00Oi_PRN <= (nlil1Ol56 XOR nlil1Ol55);
	PROCESS (pclk, wire_nl01l_PRN)
	BEGIN
		IF (wire_nl01l_PRN = '0') THEN
				n0001l <= '1';
				n011OO <= '1';
				n0i0iO <= '1';
				n0iiiO <= '1';
				n0iOiO <= '1';
				n0iOli <= '1';
				n0iOll <= '1';
				n0iOlO <= '1';
				n0Oi1O <= '1';
				n100O <= '1';
				n10OOl <= '1';
				n110O <= '1';
				n11OlO <= '1';
				n1l00O <= '1';
				n1l0O <= '1';
				n1l10O <= '1';
				n1lii <= '1';
				n1lil <= '1';
				n1liO <= '1';
				n1ll0O <= '1';
				n1llii <= '1';
				n1llil <= '1';
				n1lliO <= '1';
				ni0ilO <= '1';
				ni0llO <= '1';
				ni1i0l <= '1';
				ni1OO <= '1';
				nii1lO <= '1';
				nii1Oi <= '1';
				nii1Ol <= '1';
				nii1OO <= '1';
				nill0O <= '1';
				niOlil <= '1';
				nl00OO <= '1';
				nl01O <= '1';
				nl0i1i <= '1';
				nl0i1l <= '1';
				nl0i1O <= '1';
				nl1lOO <= '1';
				nl1OOO <= '1';
				nliOiO <= '1';
				nll10lO <= '1';
				nll1ilO <= '1';
				nll1OlO <= '1';
				nll1OOi <= '1';
				nll1OOl <= '1';
				nll1OOO <= '1';
				nllii0O <= '1';
				nllliil <= '1';
				nllOiOO <= '1';
				nllOll <= '1';
				nllOlOO <= '1';
				nlO0liO <= '1';
				nlO101i <= '1';
				nlO101l <= '1';
				nlO101O <= '1';
				nlO11OO <= '1';
				nlOilll <= '1';
				nlOlO1O <= '1';
				nlOO11O <= '1';
				nlOOi0i <= '1';
				nlOOi0l <= '1';
				nlOOi0O <= '1';
				nlOOi1O <= '1';
		ELSIF (pclk = '1' AND pclk'event) THEN
				n0001l <= rxelecidle_in(3);
				n011OO <= wire_n0001O_dataout;
				n0i0iO <= wire_n0i0Oi_o;
				n0iiiO <= wire_n0i0Ol_o;
				n0iOiO <= wire_n0l0li_dataout;
				n0iOli <= wire_n0l0ll_dataout;
				n0iOll <= wire_n0l0lO_dataout;
				n0iOlO <= wire_n0l0Oi_dataout;
				n0Oi1O <= wire_ni1i0O_dataout;
				n100O <= wire_n11ll_o;
				n10OOl <= rxelecidle_in(2);
				n110O <= wire_n11li_o;
				n11OlO <= wire_n10OOO_dataout;
				n1l00O <= wire_n1l1ll_o;
				n1l0O <= wire_n01ii_dataout;
				n1l10O <= wire_n1l1li_o;
				n1lii <= wire_n01il_dataout;
				n1lil <= wire_n01iO_dataout;
				n1liO <= wire_n01li_dataout;
				n1ll0O <= wire_n1O1ii_dataout;
				n1llii <= wire_n1O1il_dataout;
				n1llil <= wire_n1O1iO_dataout;
				n1lliO <= wire_n1O1li_dataout;
				ni0ilO <= wire_ni0l1i_o;
				ni0llO <= wire_ni0l1l_o;
				ni1i0l <= rxelecidle_in(4);
				ni1OO <= wire_nl00i_dataout;
				nii1lO <= wire_niiiOi_dataout;
				nii1Oi <= wire_niiiOl_dataout;
				nii1Ol <= wire_niiiOO_dataout;
				nii1OO <= wire_niil1i_dataout;
				nill0O <= wire_niOliO_dataout;
				niOlil <= rxelecidle_in(5);
				nl00OO <= wire_nl0O1i_dataout;
				nl01O <= rxelecidle_in(7);
				nl0i1i <= wire_nl0O1l_dataout;
				nl0i1l <= wire_nl0O1O_dataout;
				nl0i1O <= wire_nl0O0i_dataout;
				nl1lOO <= wire_nl1O0i_o;
				nl1OOO <= wire_nl1O0l_o;
				nliOiO <= wire_nllOlO_dataout;
				nll10lO <= wire_nll1i1i_o;
				nll1ilO <= wire_nll1i1l_o;
				nll1OlO <= wire_nll00Oi_dataout;
				nll1OOi <= wire_nll00Ol_dataout;
				nll1OOl <= wire_nll00OO_dataout;
				nll1OOO <= wire_nll0i1i_dataout;
				nllii0O <= wire_nllliiO_dataout;
				nllliil <= rxelecidle_in(0);
				nllOiOO <= wire_nllOl0i_o;
				nllOll <= rxelecidle_in(6);
				nllOlOO <= wire_nllOl0l_o;
				nlO0liO <= wire_nlOillO_dataout;
				nlO101i <= wire_nlO1l1l_dataout;
				nlO101l <= wire_nlO1l1O_dataout;
				nlO101O <= wire_nlO1l0i_dataout;
				nlO11OO <= wire_nlO1l1i_dataout;
				nlOilll <= rxelecidle_in(1);
				nlOlO1O <= wire_nlOlOii_o;
				nlOO11O <= wire_nlOlOil_o;
				nlOOi0i <= wire_nlOOO0l_dataout;
				nlOOi0l <= wire_nlOOO0O_dataout;
				nlOOi0O <= wire_nlOOOii_dataout;
				nlOOi1O <= wire_nlOOO0i_dataout;
		END IF;
	END PROCESS;
	wire_nl01l_PRN <= ((nliOi1i8 XOR nliOi1i7) AND prstn);
	wire_nl01l_w_lg_w_lg_w_lg_n0iOlO1995w1999w2000w(0) <= wire_nl01l_w_lg_w_lg_n0iOlO1995w1999w(0) AND n0iOiO;
	wire_nl01l_w_lg_w_lg_w_lg_n0iOlO1988w1990w1992w(0) <= wire_nl01l_w_lg_w_lg_n0iOlO1988w1990w(0) AND wire_nl01l_w_lg_n0iOiO1991w(0);
	wire_nl01l_w_lg_w_lg_w_lg_n1liO370w374w375w(0) <= wire_nl01l_w_lg_w_lg_n1liO370w374w(0) AND n1l0O;
	wire_nl01l_w_lg_w_lg_w_lg_n1liO363w365w367w(0) <= wire_nl01l_w_lg_w_lg_n1liO363w365w(0) AND wire_nl01l_w_lg_n1l0O366w(0);
	wire_nl01l_w_lg_w_lg_w_lg_n1lliO2531w2535w2536w(0) <= wire_nl01l_w_lg_w_lg_n1lliO2531w2535w(0) AND n1ll0O;
	wire_nl01l_w_lg_w_lg_w_lg_n1lliO2524w2526w2528w(0) <= wire_nl01l_w_lg_w_lg_n1lliO2524w2526w(0) AND wire_nl01l_w_lg_n1ll0O2527w(0);
	wire_nl01l_w_lg_w_lg_w_lg_nii1OO1458w1462w1463w(0) <= wire_nl01l_w_lg_w_lg_nii1OO1458w1462w(0) AND nii1lO;
	wire_nl01l_w_lg_w_lg_w_lg_nii1OO1451w1453w1455w(0) <= wire_nl01l_w_lg_w_lg_nii1OO1451w1453w(0) AND wire_nl01l_w_lg_nii1lO1454w(0);
	wire_nl01l_w_lg_w_lg_w_lg_nl0i1O922w926w927w(0) <= wire_nl01l_w_lg_w_lg_nl0i1O922w926w(0) AND nl00OO;
	wire_nl01l_w_lg_w_lg_w_lg_nl0i1O915w917w919w(0) <= wire_nl01l_w_lg_w_lg_nl0i1O915w917w(0) AND wire_nl01l_w_lg_nl00OO918w(0);
	wire_nl01l_w_lg_w_lg_w_lg_nll1OOO4143w4147w4148w(0) <= wire_nl01l_w_lg_w_lg_nll1OOO4143w4147w(0) AND nll1OlO;
	wire_nl01l_w_lg_w_lg_w_lg_nll1OOO4136w4138w4140w(0) <= wire_nl01l_w_lg_w_lg_nll1OOO4136w4138w(0) AND wire_nl01l_w_lg_nll1OlO4139w(0);
	wire_nl01l_w_lg_w_lg_w_lg_nlO101O3607w3611w3612w(0) <= wire_nl01l_w_lg_w_lg_nlO101O3607w3611w(0) AND nlO11OO;
	wire_nl01l_w_lg_w_lg_w_lg_nlO101O3600w3602w3604w(0) <= wire_nl01l_w_lg_w_lg_nlO101O3600w3602w(0) AND wire_nl01l_w_lg_nlO11OO3603w(0);
	wire_nl01l_w_lg_w_lg_w_lg_nlOOi0O3069w3073w3074w(0) <= wire_nl01l_w_lg_w_lg_nlOOi0O3069w3073w(0) AND nlOOi1O;
	wire_nl01l_w_lg_w_lg_w_lg_nlOOi0O3062w3064w3066w(0) <= wire_nl01l_w_lg_w_lg_nlOOi0O3062w3064w(0) AND wire_nl01l_w_lg_nlOOi1O3065w(0);
	wire_nl01l_w_lg_w_lg_n0iOlO1995w1999w(0) <= wire_nl01l_w_lg_n0iOlO1995w(0) AND wire_nl01l_w_lg_n0iOli1989w(0);
	wire_nl01l_w_lg_w_lg_n0iOlO1995w1996w(0) <= wire_nl01l_w_lg_n0iOlO1995w(0) AND n0iOli;
	wire_nl01l_w_lg_w_lg_n0iOlO1988w1990w(0) <= wire_nl01l_w_lg_n0iOlO1988w(0) AND wire_nl01l_w_lg_n0iOli1989w(0);
	wire_nl01l_w_lg_w_lg_n1liO370w374w(0) <= wire_nl01l_w_lg_n1liO370w(0) AND wire_nl01l_w_lg_n1lii364w(0);
	wire_nl01l_w_lg_w_lg_n1liO370w371w(0) <= wire_nl01l_w_lg_n1liO370w(0) AND n1lii;
	wire_nl01l_w_lg_w_lg_n1liO363w365w(0) <= wire_nl01l_w_lg_n1liO363w(0) AND wire_nl01l_w_lg_n1lii364w(0);
	wire_nl01l_w_lg_w_lg_n1lliO2531w2535w(0) <= wire_nl01l_w_lg_n1lliO2531w(0) AND wire_nl01l_w_lg_n1llii2525w(0);
	wire_nl01l_w_lg_w_lg_n1lliO2531w2532w(0) <= wire_nl01l_w_lg_n1lliO2531w(0) AND n1llii;
	wire_nl01l_w_lg_w_lg_n1lliO2524w2526w(0) <= wire_nl01l_w_lg_n1lliO2524w(0) AND wire_nl01l_w_lg_n1llii2525w(0);
	wire_nl01l_w_lg_w_lg_nii1OO1458w1462w(0) <= wire_nl01l_w_lg_nii1OO1458w(0) AND wire_nl01l_w_lg_nii1Oi1452w(0);
	wire_nl01l_w_lg_w_lg_nii1OO1458w1459w(0) <= wire_nl01l_w_lg_nii1OO1458w(0) AND nii1Oi;
	wire_nl01l_w_lg_w_lg_nii1OO1451w1453w(0) <= wire_nl01l_w_lg_nii1OO1451w(0) AND wire_nl01l_w_lg_nii1Oi1452w(0);
	wire_nl01l_w_lg_w_lg_nl0i1O922w926w(0) <= wire_nl01l_w_lg_nl0i1O922w(0) AND wire_nl01l_w_lg_nl0i1i916w(0);
	wire_nl01l_w_lg_w_lg_nl0i1O922w923w(0) <= wire_nl01l_w_lg_nl0i1O922w(0) AND nl0i1i;
	wire_nl01l_w_lg_w_lg_nl0i1O915w917w(0) <= wire_nl01l_w_lg_nl0i1O915w(0) AND wire_nl01l_w_lg_nl0i1i916w(0);
	wire_nl01l_w_lg_w_lg_nll1OOO4143w4147w(0) <= wire_nl01l_w_lg_nll1OOO4143w(0) AND wire_nl01l_w_lg_nll1OOi4137w(0);
	wire_nl01l_w_lg_w_lg_nll1OOO4143w4144w(0) <= wire_nl01l_w_lg_nll1OOO4143w(0) AND nll1OOi;
	wire_nl01l_w_lg_w_lg_nll1OOO4136w4138w(0) <= wire_nl01l_w_lg_nll1OOO4136w(0) AND wire_nl01l_w_lg_nll1OOi4137w(0);
	wire_nl01l_w_lg_w_lg_nlO101O3607w3611w(0) <= wire_nl01l_w_lg_nlO101O3607w(0) AND wire_nl01l_w_lg_nlO101i3601w(0);
	wire_nl01l_w_lg_w_lg_nlO101O3607w3608w(0) <= wire_nl01l_w_lg_nlO101O3607w(0) AND nlO101i;
	wire_nl01l_w_lg_w_lg_nlO101O3600w3602w(0) <= wire_nl01l_w_lg_nlO101O3600w(0) AND wire_nl01l_w_lg_nlO101i3601w(0);
	wire_nl01l_w_lg_w_lg_nlOOi0O3069w3073w(0) <= wire_nl01l_w_lg_nlOOi0O3069w(0) AND wire_nl01l_w_lg_nlOOi0i3063w(0);
	wire_nl01l_w_lg_w_lg_nlOOi0O3069w3070w(0) <= wire_nl01l_w_lg_nlOOi0O3069w(0) AND nlOOi0i;
	wire_nl01l_w_lg_w_lg_nlOOi0O3062w3064w(0) <= wire_nl01l_w_lg_nlOOi0O3062w(0) AND wire_nl01l_w_lg_nlOOi0i3063w(0);
	wire_nl01l_w_lg_n0iOlO1995w(0) <= n0iOlO AND wire_nl01l_w_lg_n0iOll1994w(0);
	wire_nl01l_w_lg_n0iOlO1988w(0) <= n0iOlO AND n0iOll;
	wire_nl01l_w_lg_n1liO370w(0) <= n1liO AND wire_nl01l_w_lg_n1lil369w(0);
	wire_nl01l_w_lg_n1liO363w(0) <= n1liO AND n1lil;
	wire_nl01l_w_lg_n1lliO2531w(0) <= n1lliO AND wire_nl01l_w_lg_n1llil2530w(0);
	wire_nl01l_w_lg_n1lliO2524w(0) <= n1lliO AND n1llil;
	wire_nl01l_w_lg_nii1OO1458w(0) <= nii1OO AND wire_nl01l_w_lg_nii1Ol1457w(0);
	wire_nl01l_w_lg_nii1OO1451w(0) <= nii1OO AND nii1Ol;
	wire_nl01l_w_lg_nl0i1O922w(0) <= nl0i1O AND wire_nl01l_w_lg_nl0i1l921w(0);
	wire_nl01l_w_lg_nl0i1O915w(0) <= nl0i1O AND nl0i1l;
	wire_nl01l_w_lg_nll1OOO4143w(0) <= nll1OOO AND wire_nl01l_w_lg_nll1OOl4142w(0);
	wire_nl01l_w_lg_nll1OOO4136w(0) <= nll1OOO AND nll1OOl;
	wire_nl01l_w_lg_nlO101O3607w(0) <= nlO101O AND wire_nl01l_w_lg_nlO101l3606w(0);
	wire_nl01l_w_lg_nlO101O3600w(0) <= nlO101O AND nlO101l;
	wire_nl01l_w_lg_nlOOi0O3069w(0) <= nlOOi0O AND wire_nl01l_w_lg_nlOOi0l3068w(0);
	wire_nl01l_w_lg_nlOOi0O3062w(0) <= nlOOi0O AND nlOOi0l;
	wire_nl01l_w_lg_n0i0iO2046w(0) <= NOT n0i0iO;
	wire_nl01l_w_lg_n0iOiO1991w(0) <= NOT n0iOiO;
	wire_nl01l_w_lg_n0iOli1989w(0) <= NOT n0iOli;
	wire_nl01l_w_lg_n0iOll1994w(0) <= NOT n0iOll;
	wire_nl01l_w_lg_n0iOlO2226w(0) <= NOT n0iOlO;
	wire_nl01l_w_lg_n110O421w(0) <= NOT n110O;
	wire_nl01l_w_lg_n1l0O366w(0) <= NOT n1l0O;
	wire_nl01l_w_lg_n1l10O2584w(0) <= NOT n1l10O;
	wire_nl01l_w_lg_n1lii364w(0) <= NOT n1lii;
	wire_nl01l_w_lg_n1lil369w(0) <= NOT n1lil;
	wire_nl01l_w_lg_n1liO612w(0) <= NOT n1liO;
	wire_nl01l_w_lg_n1ll0O2527w(0) <= NOT n1ll0O;
	wire_nl01l_w_lg_n1llii2525w(0) <= NOT n1llii;
	wire_nl01l_w_lg_n1llil2530w(0) <= NOT n1llil;
	wire_nl01l_w_lg_n1lliO2764w(0) <= NOT n1lliO;
	wire_nl01l_w_lg_ni0ilO1510w(0) <= NOT ni0ilO;
	wire_nl01l_w_lg_nii1lO1454w(0) <= NOT nii1lO;
	wire_nl01l_w_lg_nii1Oi1452w(0) <= NOT nii1Oi;
	wire_nl01l_w_lg_nii1Ol1457w(0) <= NOT nii1Ol;
	wire_nl01l_w_lg_nii1OO1690w(0) <= NOT nii1OO;
	wire_nl01l_w_lg_nl00OO918w(0) <= NOT nl00OO;
	wire_nl01l_w_lg_nl0i1i916w(0) <= NOT nl0i1i;
	wire_nl01l_w_lg_nl0i1l921w(0) <= NOT nl0i1l;
	wire_nl01l_w_lg_nl0i1O1153w(0) <= NOT nl0i1O;
	wire_nl01l_w_lg_nl1lOO973w(0) <= NOT nl1lOO;
	wire_nl01l_w_lg_nll10lO4195w(0) <= NOT nll10lO;
	wire_nl01l_w_lg_nll1OlO4139w(0) <= NOT nll1OlO;
	wire_nl01l_w_lg_nll1OOi4137w(0) <= NOT nll1OOi;
	wire_nl01l_w_lg_nll1OOl4142w(0) <= NOT nll1OOl;
	wire_nl01l_w_lg_nll1OOO4375w(0) <= NOT nll1OOO;
	wire_nl01l_w_lg_nllOiOO3658w(0) <= NOT nllOiOO;
	wire_nl01l_w_lg_nlO101i3601w(0) <= NOT nlO101i;
	wire_nl01l_w_lg_nlO101l3606w(0) <= NOT nlO101l;
	wire_nl01l_w_lg_nlO101O3838w(0) <= NOT nlO101O;
	wire_nl01l_w_lg_nlO11OO3603w(0) <= NOT nlO11OO;
	wire_nl01l_w_lg_nlOlO1O3122w(0) <= NOT nlOlO1O;
	wire_nl01l_w_lg_nlOOi0i3063w(0) <= NOT nlOOi0i;
	wire_nl01l_w_lg_nlOOi0l3068w(0) <= NOT nlOOi0l;
	wire_nl01l_w_lg_nlOOi0O3302w(0) <= NOT nlOOi0O;
	wire_nl01l_w_lg_nlOOi1O3065w(0) <= NOT nlOOi1O;
	wire_nl01l_w_lg_w_lg_w_lg_w_lg_n0iOlO1988w1990w1992w1993w(0) <= wire_nl01l_w_lg_w_lg_w_lg_n0iOlO1988w1990w1992w(0) OR nlii0iO;
	wire_nl01l_w_lg_w_lg_w_lg_w_lg_n1liO363w365w367w368w(0) <= wire_nl01l_w_lg_w_lg_w_lg_n1liO363w365w367w(0) OR nlillii;
	wire_nl01l_w_lg_w_lg_w_lg_w_lg_n1lliO2524w2526w2528w2529w(0) <= wire_nl01l_w_lg_w_lg_w_lg_n1lliO2524w2526w2528w(0) OR nli0O0O;
	wire_nl01l_w_lg_w_lg_w_lg_w_lg_nii1OO1451w1453w1455w1456w(0) <= wire_nl01l_w_lg_w_lg_w_lg_nii1OO1451w1453w1455w(0) OR nliillO;
	wire_nl01l_w_lg_w_lg_w_lg_w_lg_nl0i1O915w917w919w920w(0) <= wire_nl01l_w_lg_w_lg_w_lg_nl0i1O915w917w919w(0) OR nlil1OO;
	wire_nl01l_w_lg_w_lg_w_lg_w_lg_nll1OOO4136w4138w4140w4141w(0) <= wire_nl01l_w_lg_w_lg_w_lg_nll1OOO4136w4138w4140w(0) OR nli1ili;
	wire_nl01l_w_lg_w_lg_w_lg_w_lg_nlO101O3600w3602w3604w3605w(0) <= wire_nl01l_w_lg_w_lg_w_lg_nlO101O3600w3602w3604w(0) OR nli1OOi;
	wire_nl01l_w_lg_w_lg_w_lg_w_lg_nlOOi0O3062w3064w3066w3067w(0) <= wire_nl01l_w_lg_w_lg_w_lg_nlOOi0O3062w3064w3066w(0) OR nli0i1l;
	PROCESS (pclk, wire_nliii_CLRN)
	BEGIN
		IF (wire_nliii_CLRN = '0') THEN
				n000il <= '0';
				n000iO <= '0';
				n000li <= '0';
				n000ll <= '0';
				n000lO <= '0';
				n000Oi <= '0';
				n000Ol <= '0';
				n000OO <= '0';
				n00i0i <= '0';
				n00i0l <= '0';
				n00i0O <= '0';
				n00i1i <= '0';
				n00i1l <= '0';
				n00i1O <= '0';
				n00ili <= '0';
				n00iOi <= '0';
				n00iOl <= '0';
				n0110i <= '0';
				n0110l <= '0';
				n0110O <= '0';
				n0111i <= '0';
				n0111l <= '0';
				n0111O <= '0';
				n011ii <= '0';
				n011il <= '0';
				n011iO <= '0';
				n011li <= '0';
				n011ll <= '0';
				n011lO <= '0';
				n011Oi <= '0';
				n011Ol <= '0';
				n0i0i <= '0';
				n0i0ii <= '0';
				n0i0il <= '0';
				n0i0l <= '0';
				n0i0li <= '0';
				n0i0O <= '0';
				n0iili <= '0';
				n0iill <= '0';
				n0iilO <= '0';
				n0iiOi <= '0';
				n0iiOl <= '0';
				n0iiOO <= '0';
				n0il1i <= '0';
				n0iO0l <= '0';
				n0iO1l <= '0';
				n0iOOi <= '0';
				n0iOOl <= '0';
				n0l0i <= '0';
				n0l0l <= '0';
				n0l0O <= '0';
				n0l1l <= '0';
				n0l1O <= '0';
				n0lii <= '0';
				n0lil <= '0';
				n0liO <= '0';
				n0lli <= '0';
				n0llii <= '0';
				n0llil <= '0';
				n0lliO <= '0';
				n0lll <= '0';
				n0llO <= '0';
				n0lO0l <= '0';
				n0lO0O <= '0';
				n0lOi <= '0';
				n0lOii <= '0';
				n0lOil <= '0';
				n0lOiO <= '0';
				n0lOl <= '0';
				n0lOli <= '0';
				n0lOll <= '0';
				n0lOlO <= '0';
				n0lOO <= '0';
				n0lOOi <= '0';
				n0lOOl <= '0';
				n0lOOO <= '0';
				n0O00i <= '0';
				n0O00l <= '0';
				n0O00O <= '0';
				n0O01i <= '0';
				n0O01l <= '0';
				n0O01O <= '0';
				n0O0i <= '0';
				n0O0ii <= '0';
				n0O0il <= '0';
				n0O0iO <= '0';
				n0O0l <= '0';
				n0O0li <= '0';
				n0O0ll <= '0';
				n0O0lO <= '0';
				n0O0O <= '0';
				n0O0Oi <= '0';
				n0O0Ol <= '0';
				n0O0OO <= '0';
				n0O10i <= '0';
				n0O10l <= '0';
				n0O10O <= '0';
				n0O11i <= '0';
				n0O11l <= '0';
				n0O11O <= '0';
				n0O1i <= '0';
				n0O1ii <= '0';
				n0O1il <= '0';
				n0O1iO <= '0';
				n0O1l <= '0';
				n0O1li <= '0';
				n0O1ll <= '0';
				n0O1lO <= '0';
				n0O1O <= '0';
				n0O1Oi <= '0';
				n0O1Ol <= '0';
				n0O1OO <= '0';
				n0Oi1i <= '0';
				n0Oi1l <= '0';
				n0Oii <= '0';
				n0Oil <= '0';
				n0OiO <= '0';
				n0Oli <= '0';
				n0Oll <= '0';
				n0OlO <= '0';
				n0OOi <= '0';
				n0OOl <= '0';
				n0OOO <= '0';
				n10ii <= '0';
				n10il <= '0';
				n10iO <= '0';
				n10li <= '0';
				n10ll <= '0';
				n10lO <= '0';
				n10Oi <= '0';
				n1101i <= '0';
				n1101l <= '0';
				n1101O <= '0';
				n110i <= '0';
				n110l <= '0';
				n110Ol <= '0';
				n110OO <= '0';
				n11i0i <= '0';
				n11i0l <= '0';
				n11i0O <= '0';
				n11i1i <= '0';
				n11i1l <= '0';
				n11i1O <= '0';
				n11ii <= '0';
				n11iii <= '0';
				n11iil <= '0';
				n11iiO <= '0';
				n11ili <= '0';
				n11ill <= '0';
				n11ilO <= '0';
				n11iOi <= '0';
				n11iOl <= '0';
				n11iOO <= '0';
				n11l0i <= '0';
				n11l0l <= '0';
				n11l0O <= '0';
				n11l1i <= '0';
				n11l1l <= '0';
				n11l1O <= '0';
				n11lii <= '0';
				n11lil <= '0';
				n11liO <= '0';
				n11lli <= '0';
				n11lll <= '0';
				n11llO <= '0';
				n11lOi <= '0';
				n11lOl <= '0';
				n11lOO <= '0';
				n11O0i <= '0';
				n11O0l <= '0';
				n11O0O <= '0';
				n11O1i <= '0';
				n11O1l <= '0';
				n11O1O <= '0';
				n11Oii <= '0';
				n11Oil <= '0';
				n11OiO <= '0';
				n11Oli <= '0';
				n11Oll <= '0';
				n1i01i <= '0';
				n1i01l <= '0';
				n1i01O <= '0';
				n1i0ii <= '0';
				n1i0li <= '0';
				n1i0ll <= '0';
				n1i10l <= '0';
				n1i10O <= '0';
				n1i1ii <= '0';
				n1i1il <= '0';
				n1i1iO <= '0';
				n1i1li <= '0';
				n1i1ll <= '0';
				n1i1lO <= '0';
				n1i1Oi <= '0';
				n1i1Ol <= '0';
				n1i1OO <= '0';
				n1iOl <= '0';
				n1l0ii <= '0';
				n1l0il <= '0';
				n1l0iO <= '0';
				n1l0li <= '0';
				n1l0ll <= '0';
				n1l0lO <= '0';
				n1l0Oi <= '0';
				n1l10i <= '0';
				n1l10l <= '0';
				n1l1ii <= '0';
				n1l1l <= '0';
				n1liOl <= '0';
				n1ll1l <= '0';
				n1lli <= '0';
				n1lll <= '0';
				n1llli <= '0';
				n1llll <= '0';
				n1Oi0i <= '0';
				n1Oi0l <= '0';
				n1Oi0O <= '0';
				n1Ol0i <= '0';
				n1Ol0l <= '0';
				n1Ol0O <= '0';
				n1Ol1l <= '0';
				n1Ol1O <= '0';
				n1Olii <= '0';
				n1Olil <= '0';
				n1OliO <= '0';
				n1Olli <= '0';
				n1Olll <= '0';
				n1OllO <= '0';
				n1OlOi <= '0';
				n1OlOl <= '0';
				n1OlOO <= '0';
				n1OO0i <= '0';
				n1OO0l <= '0';
				n1OO0O <= '0';
				n1OO1i <= '0';
				n1OO1l <= '0';
				n1OO1O <= '0';
				n1OOii <= '0';
				n1OOil <= '0';
				n1OOiO <= '0';
				n1OOli <= '0';
				n1OOll <= '0';
				n1OOlO <= '0';
				n1OOOi <= '0';
				n1OOOl <= '0';
				n1OOOO <= '0';
				ni0ili <= '0';
				ni0ill <= '0';
				ni0iOi <= '0';
				ni0lOi <= '0';
				ni0lOl <= '0';
				ni0lOO <= '0';
				ni0O0i <= '0';
				ni0O1i <= '0';
				ni0O1l <= '0';
				ni0O1O <= '0';
				ni10i <= '0';
				ni10l <= '0';
				ni10O <= '0';
				ni11i <= '0';
				ni11l <= '0';
				ni11O <= '0';
				ni1ii <= '0';
				ni1il <= '0';
				ni1ill <= '0';
				ni1ilO <= '0';
				ni1iO <= '0';
				ni1iOi <= '0';
				ni1iOl <= '0';
				ni1iOO <= '0';
				ni1l0i <= '0';
				ni1l0l <= '0';
				ni1l0O <= '0';
				ni1l1i <= '0';
				ni1l1l <= '0';
				ni1l1O <= '0';
				ni1li <= '0';
				ni1lii <= '0';
				ni1lil <= '0';
				ni1liO <= '0';
				ni1ll <= '0';
				ni1lO <= '0';
				ni1lOi <= '0';
				ni1O1i <= '0';
				ni1O1l <= '0';
				ni1Oi <= '0';
				ni1Ol <= '0';
				nii01i <= '0';
				nii01l <= '0';
				nii10l <= '0';
				nii1il <= '0';
				niiOli <= '0';
				niiOll <= '0';
				niiOlO <= '0';
				nil00i <= '0';
				nil00l <= '0';
				nil00O <= '0';
				nil01i <= '0';
				nil01l <= '0';
				nil01O <= '0';
				nil0ii <= '0';
				nil0il <= '0';
				nil0iO <= '0';
				nil0li <= '0';
				nil0ll <= '0';
				nil0lO <= '0';
				nil0Oi <= '0';
				nil0Ol <= '0';
				nil0OO <= '0';
				nil1il <= '0';
				nil1iO <= '0';
				nil1li <= '0';
				nil1ll <= '0';
				nil1lO <= '0';
				nil1Oi <= '0';
				nil1Ol <= '0';
				nil1OO <= '0';
				nili0i <= '0';
				nili0l <= '0';
				nili0O <= '0';
				nili1i <= '0';
				nili1l <= '0';
				nili1O <= '0';
				niliii <= '0';
				niliil <= '0';
				niliiO <= '0';
				nilili <= '0';
				nilill <= '0';
				nililO <= '0';
				niliOi <= '0';
				niliOl <= '0';
				niliOO <= '0';
				nill0i <= '0';
				nill0l <= '0';
				nill1i <= '0';
				nill1l <= '0';
				nill1O <= '0';
				niOlOl <= '0';
				niOlOO <= '0';
				niOO0i <= '0';
				niOO0l <= '0';
				niOO0O <= '0';
				niOO1i <= '0';
				niOO1l <= '0';
				niOO1O <= '0';
				niOOii <= '0';
				niOOil <= '0';
				niOOiO <= '0';
				niOOli <= '0';
				niOOll <= '0';
				niOOlO <= '0';
				nl00il <= '0';
				nl00ll <= '0';
				nl010i <= '0';
				nl010l <= '0';
				nl010O <= '0';
				nl011i <= '0';
				nl011l <= '0';
				nl011O <= '0';
				nl01ii <= '0';
				nl0i0i <= '0';
				nl0i0l <= '0';
				nl0iO <= '0';
				nl0li <= '0';
				nl0ll <= '0';
				nl0lO <= '0';
				nl0Oi <= '0';
				nl0Ol <= '0';
				nl0OO <= '0';
				nl110i <= '0';
				nl110l <= '0';
				nl111i <= '0';
				nl1lOi <= '0';
				nl1lOl <= '0';
				nl1O1i <= '0';
				nli0i <= '0';
				nli0l <= '0';
				nli0ll <= '0';
				nli0lO <= '0';
				nli0O <= '0';
				nli0Oi <= '0';
				nli0Ol <= '0';
				nli0OO <= '0';
				nli1i <= '0';
				nli1l <= '0';
				nli1O <= '0';
				nli1Oi <= '0';
				nli1Ol <= '0';
				nli1OO <= '0';
				nlii0i <= '0';
				nlii0l <= '0';
				nlii0O <= '0';
				nlii1i <= '0';
				nlii1l <= '0';
				nlii1O <= '0';
				nliiii <= '0';
				nliiil <= '0';
				nliiiO <= '0';
				nliil <= '0';
				nliili <= '0';
				nliill <= '0';
				nliilO <= '0';
				nliiOi <= '0';
				nliiOl <= '0';
				nliiOO <= '0';
				nlil0i <= '0';
				nlil0l <= '0';
				nlil0O <= '0';
				nlil1i <= '0';
				nlil1l <= '0';
				nlil1O <= '0';
				nlilii <= '0';
				nlilil <= '0';
				nliliO <= '0';
				nlilli <= '0';
				nlilll <= '0';
				nlillO <= '0';
				nlilOi <= '0';
				nlilOl <= '0';
				nlilOO <= '0';
				nliO0i <= '0';
				nliO0l <= '0';
				nliO0O <= '0';
				nliO1i <= '0';
				nliO1l <= '0';
				nliO1O <= '0';
				nliOii <= '0';
				nliOil <= '0';
				nliOiOi <= '0';
				nliOl1i <= '0';
				nliOl1l <= '0';
				nll011i <= '0';
				nll011l <= '0';
				nll0lli <= '0';
				nll0lll <= '0';
				nll0llO <= '0';
				nll0Oil <= '0';
				nll0OiO <= '0';
				nll0Oli <= '0';
				nll0Oll <= '0';
				nll0OlO <= '0';
				nll0OOi <= '0';
				nll0OOl <= '0';
				nll0OOO <= '0';
				nll10li <= '0';
				nll10ll <= '0';
				nll10Oi <= '0';
				nll1iOi <= '0';
				nll1iOl <= '0';
				nll1iOO <= '0';
				nll1l0i <= '0';
				nll1l1i <= '0';
				nll1l1l <= '0';
				nll1l1O <= '0';
				nll1O0l <= '0';
				nll1Oil <= '0';
				nlli00i <= '0';
				nlli00l <= '0';
				nlli00O <= '0';
				nlli01i <= '0';
				nlli01l <= '0';
				nlli01O <= '0';
				nlli0ii <= '0';
				nlli0il <= '0';
				nlli0iO <= '0';
				nlli0li <= '0';
				nlli0ll <= '0';
				nlli0lO <= '0';
				nlli0Oi <= '0';
				nlli0Ol <= '0';
				nlli0OO <= '0';
				nlli10i <= '0';
				nlli10l <= '0';
				nlli10O <= '0';
				nlli11i <= '0';
				nlli11l <= '0';
				nlli11O <= '0';
				nlli1ii <= '0';
				nlli1il <= '0';
				nlli1iO <= '0';
				nlli1li <= '0';
				nlli1ll <= '0';
				nlli1lO <= '0';
				nlli1Oi <= '0';
				nlli1Ol <= '0';
				nlli1OO <= '0';
				nllii0i <= '0';
				nllii0l <= '0';
				nllii1i <= '0';
				nllii1l <= '0';
				nllii1O <= '0';
				nllliOl <= '0';
				nllliOO <= '0';
				nllll0i <= '0';
				nllll0l <= '0';
				nllll0O <= '0';
				nllll1i <= '0';
				nllll1l <= '0';
				nllll1O <= '0';
				nllllii <= '0';
				nllllil <= '0';
				nlllliO <= '0';
				nllllli <= '0';
				nllllll <= '0';
				nlllllO <= '0';
				nlllO0i <= '0';
				nlllO0l <= '0';
				nlllO1i <= '0';
				nllOiOi <= '0';
				nllOiOl <= '0';
				nllOl1i <= '0';
				nllOO0i <= '0';
				nllOO0l <= '0';
				nllOO0O <= '0';
				nllOO1i <= '0';
				nllOO1l <= '0';
				nllOO1O <= '0';
				nllOOii <= '0';
				nlO000i <= '0';
				nlO000l <= '0';
				nlO000O <= '0';
				nlO001i <= '0';
				nlO001l <= '0';
				nlO001O <= '0';
				nlO00ii <= '0';
				nlO00il <= '0';
				nlO00iO <= '0';
				nlO00l <= '0';
				nlO00li <= '0';
				nlO00ll <= '0';
				nlO00lO <= '0';
				nlO00Oi <= '0';
				nlO00Ol <= '0';
				nlO00OO <= '0';
				nlO01ll <= '0';
				nlO01lO <= '0';
				nlO01Oi <= '0';
				nlO01Ol <= '0';
				nlO01OO <= '0';
				nlO0i0i <= '0';
				nlO0i0l <= '0';
				nlO0i0O <= '0';
				nlO0i1i <= '0';
				nlO0i1l <= '0';
				nlO0i1O <= '0';
				nlO0iii <= '0';
				nlO0iil <= '0';
				nlO0iiO <= '0';
				nlO0ili <= '0';
				nlO0ill <= '0';
				nlO0ilO <= '0';
				nlO0iO <= '0';
				nlO0iOi <= '0';
				nlO0iOl <= '0';
				nlO0iOO <= '0';
				nlO0l0i <= '0';
				nlO0l0l <= '0';
				nlO0l0O <= '0';
				nlO0l1i <= '0';
				nlO0l1l <= '0';
				nlO0l1O <= '0';
				nlO0li <= '0';
				nlO0lii <= '0';
				nlO0lil <= '0';
				nlO100i <= '0';
				nlO100l <= '0';
				nlO10i <= '0';
				nlO10l <= '0';
				nlO10O <= '0';
				nlO11il <= '0';
				nlO11l <= '0';
				nlO11ll <= '0';
				nlO11O <= '0';
				nlO1ii <= '0';
				nlO1il <= '0';
				nlO1iO <= '0';
				nlO1li <= '0';
				nlO1ll <= '0';
				nlO1lO <= '0';
				nlO1Oi <= '0';
				nlO1Ol <= '0';
				nlO1OO <= '0';
				nlO1OOi <= '0';
				nlO1OOl <= '0';
				nlO1OOO <= '0';
				nlOiO0i <= '0';
				nlOiO0l <= '0';
				nlOiO0O <= '0';
				nlOiO1l <= '0';
				nlOiO1O <= '0';
				nlOiOii <= '0';
				nlOiOil <= '0';
				nlOiOiO <= '0';
				nlOiOli <= '0';
				nlOiOll <= '0';
				nlOiOlO <= '0';
				nlOiOOi <= '0';
				nlOiOOl <= '0';
				nlOiOOO <= '0';
				nlOl10i <= '0';
				nlOl1ii <= '0';
				nlOl1il <= '0';
				nlOlO0i <= '0';
				nlOlO1i <= '0';
				nlOlO1l <= '0';
				nlOO0ll <= '0';
				nlOO0Ol <= '0';
				nlOO10i <= '0';
				nlOO10l <= '0';
				nlOO10O <= '0';
				nlOO1ii <= '0';
				nlOO1il <= '0';
				nlOO1iO <= '0';
				nlOO1li <= '0';
				nlOOiii <= '0';
				nlOOiil <= '0';
		ELSIF (pclk = '1' AND pclk'event) THEN
				n000il <= eidleinfersel(0);
				n000iO <= eidleinfersel(1);
				n000li <= eidleinfersel(2);
				n000ll <= n000lO;
				n000lO <= rxvalid(3);
				n000Oi <= datain_ch3(8);
				n000Ol <= datain_ch3(0);
				n000OO <= datain_ch3(1);
				n00i0i <= datain_ch3(5);
				n00i0l <= datain_ch3(6);
				n00i0O <= datain_ch3(7);
				n00i1i <= datain_ch3(2);
				n00i1l <= datain_ch3(3);
				n00i1O <= datain_ch3(4);
				n00ili <= wire_n00iil_dataout;
				n00iOi <= n00iOl;
				n00iOl <= n00ilO;
				n0110i <= wire_n01OOi_dataout;
				n0110l <= wire_n01OOl_dataout;
				n0110O <= wire_n01OOO_dataout;
				n0111i <= wire_n01Oli_dataout;
				n0111l <= wire_n01Oll_dataout;
				n0111O <= wire_n01OlO_dataout;
				n011ii <= wire_n0011i_dataout;
				n011il <= wire_n0011O_dataout;
				n011iO <= wire_n0010i_dataout;
				n011li <= wire_n0010l_dataout;
				n011ll <= wire_n0010O_dataout;
				n011lO <= wire_n001ii_dataout;
				n011Oi <= wire_n001il_dataout;
				n011Ol <= wire_n001iO_dataout;
				n0i0i <= wire_n0iii_o;
				n0i0ii <= wire_n0i0ll_o;
				n0i0il <= wire_n0i0lO_o;
				n0i0l <= wire_n0iil_o;
				n0i0li <= ((((nliiiiO AND n0iili) OR wire_w_lg_nliiiiO2057w(0)) OR wire_w_lg_nliiiiO2061w(0)) OR (wire_w_lg_nliiill2063w(0) AND (wire_w_lg_nliiiiO2064w(0) AND (nlii0ii AND n0iiOi))));
				n0i0O <= wire_ni01i_dataout;
				n0iili <= (nliiiiO AND n0iill);
				n0iill <= (nliiiiO AND n0iOOi);
				n0iilO <= n0iiOi;
				n0iiOi <= nliiiiO;
				n0iiOl <= n0iiOO;
				n0iiOO <= n0iOOi;
				n0il1i <= (n0iOOi AND (nliiill OR (ni1iOO AND nlii00O)));
				n0iO0l <= wire_n0l10l_dataout;
				n0iO1l <= (wire_w_lg_w_lg_w_lg_nliii1O2007w2009w2010w(0) AND wire_nliii_w_lg_n0iO0l2011w(0));
				n0iOOi <= nliiill;
				n0iOOl <= wire_n0lllO_o;
				n0l0i <= wire_ni00i_dataout;
				n0l0l <= wire_ni00l_dataout;
				n0l0O <= wire_ni00O_dataout;
				n0l1l <= wire_ni01l_dataout;
				n0l1O <= wire_ni01O_dataout;
				n0lii <= wire_ni0ii_dataout;
				n0lil <= wire_ni0il_dataout;
				n0liO <= wire_ni0iO_dataout;
				n0lli <= wire_ni0li_dataout;
				n0llii <= wire_n0llli_o;
				n0llil <= wire_n0llll_o;
				n0lliO <= wire_n0Oi0i_dataout;
				n0lll <= wire_ni0ll_dataout;
				n0llO <= wire_niiiO_dataout;
				n0lO0l <= wire_n0Oi0l_dataout;
				n0lO0O <= wire_n0Oi0O_dataout;
				n0lOi <= wire_niili_dataout;
				n0lOii <= wire_n0Oiii_dataout;
				n0lOil <= wire_n0Oiil_dataout;
				n0lOiO <= wire_n0OiiO_dataout;
				n0lOl <= wire_niill_dataout;
				n0lOli <= wire_n0Oili_dataout;
				n0lOll <= wire_n0Oill_dataout;
				n0lOlO <= wire_n0OilO_dataout;
				n0lOO <= wire_niilO_dataout;
				n0lOOi <= wire_n0OiOi_dataout;
				n0lOOl <= wire_n0OiOl_dataout;
				n0lOOO <= wire_n0OllO_dataout;
				n0O00i <= wire_ni11Oi_dataout;
				n0O00l <= wire_ni11Ol_dataout;
				n0O00O <= wire_ni11OO_dataout;
				n0O01i <= (NOT (((NOT (eidleinfersel(0) XOR ni1ill)) AND (NOT (eidleinfersel(1) XOR ni1ilO))) AND (NOT (eidleinfersel(2) XOR ni1iOi))));
				n0O01l <= nliiiOl;
				n0O01O <= nliiiOO;
				n0O0i <= wire_nil1i_dataout;
				n0O0ii <= wire_ni101i_dataout;
				n0O0il <= wire_ni101l_dataout;
				n0O0iO <= wire_ni101O_dataout;
				n0O0l <= wire_nil1l_dataout;
				n0O0li <= wire_ni100i_dataout;
				n0O0ll <= wire_ni100O_dataout;
				n0O0lO <= wire_ni10ii_dataout;
				n0O0O <= wire_nil1O_dataout;
				n0O0Oi <= wire_ni10il_dataout;
				n0O0Ol <= wire_ni10iO_dataout;
				n0O0OO <= wire_ni10li_dataout;
				n0O10i <= wire_n0OO1i_dataout;
				n0O10l <= wire_n0OO1l_dataout;
				n0O10O <= wire_n0OO1O_dataout;
				n0O11i <= wire_n0OlOi_dataout;
				n0O11l <= wire_n0OlOl_dataout;
				n0O11O <= wire_n0OlOO_dataout;
				n0O1i <= wire_niiOi_dataout;
				n0O1ii <= wire_n0OO0i_dataout;
				n0O1il <= wire_n0OO0l_dataout;
				n0O1iO <= wire_n0OO0O_dataout;
				n0O1l <= wire_niiOl_dataout;
				n0O1li <= wire_n0OOii_dataout;
				n0O1ll <= wire_n0OOil_dataout;
				n0O1lO <= wire_n0OOiO_dataout;
				n0O1O <= wire_niiOO_dataout;
				n0O1Oi <= wire_n0OOli_dataout;
				n0O1Ol <= (n0O01i OR n0llii);
				n0O1OO <= (n0O01i OR n0llil);
				n0Oi1i <= wire_ni10ll_dataout;
				n0Oi1l <= wire_ni10lO_dataout;
				n0Oii <= wire_nil0i_dataout;
				n0Oil <= wire_nil0l_dataout;
				n0OiO <= wire_nil0O_dataout;
				n0Oli <= wire_nilii_dataout;
				n0Oll <= (n0OOi OR n0i0i);
				n0OlO <= (n0OOi OR n0i0l);
				n0OOi <= (NOT (((NOT (eidleinfersel(0) XOR nl0iO)) AND (NOT (wire_w_lg_w_eidleinfersel_range23w200w(0) XOR (NOT (nliO1lO26 XOR nliO1lO25))))) AND (NOT (wire_w_lg_w_eidleinfersel_range22w207w(0) XOR (NOT (nliO1li28 XOR nliO1li27))))));
				n0OOl <= nliO1Ol;
				n0OOO <= nliO1OO;
				n10ii <= (nlilOOi AND n10il);
				n10il <= (nlilOOi AND n1lli);
				n10iO <= n10li;
				n10li <= nlilOOi;
				n10ll <= n10lO;
				n10lO <= n1lli;
				n10Oi <= (n1lli AND (nlilOOO OR (nl0Oi AND nlill0i)));
				n1101i <= wire_n1100i_o;
				n1101l <= wire_n1100l_o;
				n1101O <= wire_n11OOi_dataout;
				n110i <= wire_n11il_o;
				n110l <= wire_n11iO_o;
				n110Ol <= wire_n11OOl_dataout;
				n110OO <= wire_n11OOO_dataout;
				n11i0i <= wire_n1010i_dataout;
				n11i0l <= wire_n1010l_dataout;
				n11i0O <= wire_n1010O_dataout;
				n11i1i <= wire_n1011i_dataout;
				n11i1l <= wire_n1011l_dataout;
				n11i1O <= wire_n1011O_dataout;
				n11ii <= ((((nlilOOi AND n10ii) OR wire_w_lg_nlilOOi432w(0)) OR wire_w_lg_nlilOOi436w(0)) OR (wire_w_lg_nlilOOO438w(0) AND (wire_w_lg_nlilOOi439w(0) AND (nlill0l AND n10li))));
				n11iii <= wire_n101ii_dataout;
				n11iil <= wire_n101il_dataout;
				n11iiO <= wire_n1000O_dataout;
				n11ili <= wire_n100ii_dataout;
				n11ill <= wire_n100il_dataout;
				n11ilO <= wire_n100iO_dataout;
				n11iOi <= wire_n100li_dataout;
				n11iOl <= wire_n100ll_dataout;
				n11iOO <= wire_n100lO_dataout;
				n11l0i <= wire_n10i1i_dataout;
				n11l0l <= wire_n10i1l_dataout;
				n11l0O <= wire_n10i1O_dataout;
				n11l1i <= wire_n100Oi_dataout;
				n11l1l <= wire_n100Ol_dataout;
				n11l1O <= wire_n100OO_dataout;
				n11lii <= wire_n10i0i_dataout;
				n11lil <= (n11lli OR n1101i);
				n11liO <= (n11lli OR n1101l);
				n11lli <= (NOT (((NOT (eidleinfersel(0) XOR n1i10l)) AND (NOT (eidleinfersel(1) XOR n1i10O))) AND (NOT (eidleinfersel(2) XOR n1i1ii))));
				n11lll <= nli0lii;
				n11llO <= nli0lil;
				n11lOi <= wire_n10lii_dataout;
				n11lOl <= wire_n10lil_dataout;
				n11lOO <= wire_n10liO_dataout;
				n11O0i <= wire_n10lOi_dataout;
				n11O0l <= wire_n10lOO_dataout;
				n11O0O <= wire_n10O1i_dataout;
				n11O1i <= wire_n10lli_dataout;
				n11O1l <= wire_n10lll_dataout;
				n11O1O <= wire_n10llO_dataout;
				n11Oii <= wire_n10O1l_dataout;
				n11Oil <= wire_n10O1O_dataout;
				n11OiO <= wire_n10O0i_dataout;
				n11Oli <= wire_n10O0l_dataout;
				n11Oll <= wire_n10O0O_dataout;
				n1i01i <= datain_ch2(5);
				n1i01l <= datain_ch2(6);
				n1i01O <= datain_ch2(7);
				n1i0ii <= wire_n1i00l_dataout;
				n1i0li <= n1i0ll;
				n1i0ll <= n1i0iO;
				n1i10l <= eidleinfersel(0);
				n1i10O <= eidleinfersel(1);
				n1i1ii <= eidleinfersel(2);
				n1i1il <= n1i1iO;
				n1i1iO <= rxvalid(2);
				n1i1li <= datain_ch2(8);
				n1i1ll <= datain_ch2(0);
				n1i1lO <= datain_ch2(1);
				n1i1Oi <= datain_ch2(2);
				n1i1Ol <= datain_ch2(3);
				n1i1OO <= datain_ch2(4);
				n1iOl <= (wire_w_lg_w_lg_w_lg_nlilO1O382w384w385w(0) AND wire_nliii_w_lg_n1l1l386w(0));
				n1l0ii <= (nlii10O AND n1l0il);
				n1l0il <= (nlii10O AND n1llli);
				n1l0iO <= n1l0li;
				n1l0li <= nlii10O;
				n1l0ll <= n1l0lO;
				n1l0lO <= n1llli;
				n1l0Oi <= (n1llli AND (nlii1il OR (n000lO AND nli0O1l)));
				n1l10i <= wire_n1l1il_o;
				n1l10l <= wire_n1l1iO_o;
				n1l1ii <= ((((nlii10O AND n1l0ii) OR wire_w_lg_nlii10O2595w(0)) OR wire_w_lg_nlii10O2599w(0)) OR (wire_w_lg_nlii1il2601w(0) AND (wire_w_lg_nlii10O2602w(0) AND (nli0O1O AND n1l0li))));
				n1l1l <= wire_n1O1l_dataout;
				n1liOl <= (wire_w_lg_w_lg_w_lg_nli0OOO2545w2547w2548w(0) AND wire_nliii_w_lg_n1ll1l2549w(0));
				n1ll1l <= wire_n1lO1l_dataout;
				n1lli <= nlilOOO;
				n1lll <= wire_n0iiO_o;
				n1llli <= nlii1il;
				n1llll <= wire_n1OiiO_o;
				n1Oi0i <= wire_n1Oiii_o;
				n1Oi0l <= wire_n1Oiil_o;
				n1Oi0O <= wire_n0101i_dataout;
				n1Ol0i <= wire_n0100i_dataout;
				n1Ol0l <= wire_n0100l_dataout;
				n1Ol0O <= wire_n0100O_dataout;
				n1Ol1l <= wire_n0101l_dataout;
				n1Ol1O <= wire_n0101O_dataout;
				n1Olii <= wire_n010ii_dataout;
				n1Olil <= wire_n010il_dataout;
				n1OliO <= wire_n010iO_dataout;
				n1Olli <= wire_n010li_dataout;
				n1Olll <= wire_n010ll_dataout;
				n1OllO <= wire_n01iiO_dataout;
				n1OlOi <= wire_n01ili_dataout;
				n1OlOl <= wire_n01ill_dataout;
				n1OlOO <= wire_n01ilO_dataout;
				n1OO0i <= wire_n01l1i_dataout;
				n1OO0l <= wire_n01l1l_dataout;
				n1OO0O <= wire_n01l1O_dataout;
				n1OO1i <= wire_n01iOi_dataout;
				n1OO1l <= wire_n01iOl_dataout;
				n1OO1O <= wire_n01iOO_dataout;
				n1OOii <= wire_n01l0i_dataout;
				n1OOil <= wire_n01l0l_dataout;
				n1OOiO <= wire_n01l0O_dataout;
				n1OOli <= wire_n01lii_dataout;
				n1OOll <= (n1OOOi OR n1Oi0i);
				n1OOlO <= (n1OOOi OR n1Oi0l);
				n1OOOi <= (NOT (((NOT (eidleinfersel(0) XOR n000il)) AND (NOT (eidleinfersel(1) XOR n000iO))) AND (NOT (eidleinfersel(2) XOR n000li))));
				n1OOOl <= nlii1ll;
				n1OOOO <= nlii1lO;
				ni0ili <= wire_ni0iOl_o;
				ni0ill <= wire_ni0iOO_o;
				ni0iOi <= ((((nliiOlO AND ni0lOi) OR wire_w_lg_nliiOlO1521w(0)) OR wire_w_lg_nliiOlO1525w(0)) OR (wire_w_lg_nliiOOl1527w(0) AND (wire_w_lg_nliiOlO1528w(0) AND (nliilli AND ni0O1i))));
				ni0lOi <= (nliiOlO AND ni0lOl);
				ni0lOl <= (nliiOlO AND nii01i);
				ni0lOO <= ni0O1i;
				ni0O0i <= (nii01i AND (nliiOOl OR (niOO1O AND nliiliO)));
				ni0O1i <= nliiOlO;
				ni0O1l <= ni0O1O;
				ni0O1O <= nii01i;
				ni10i <= wire_niOOi_dataout;
				ni10l <= wire_niOOl_dataout;
				ni10O <= wire_niOOO_dataout;
				ni11i <= wire_niOli_dataout;
				ni11l <= wire_niOll_dataout;
				ni11O <= wire_niOlO_dataout;
				ni1ii <= wire_nl11i_dataout;
				ni1il <= wire_nl11O_dataout;
				ni1ill <= eidleinfersel(0);
				ni1ilO <= eidleinfersel(1);
				ni1iO <= wire_nl10i_dataout;
				ni1iOi <= eidleinfersel(2);
				ni1iOl <= ni1iOO;
				ni1iOO <= rxvalid(4);
				ni1l0i <= datain_ch4(2);
				ni1l0l <= datain_ch4(3);
				ni1l0O <= datain_ch4(4);
				ni1l1i <= datain_ch4(8);
				ni1l1l <= datain_ch4(0);
				ni1l1O <= datain_ch4(1);
				ni1li <= wire_nl10l_dataout;
				ni1lii <= datain_ch4(5);
				ni1lil <= datain_ch4(6);
				ni1liO <= datain_ch4(7);
				ni1ll <= wire_nl10O_dataout;
				ni1lO <= wire_nl1ii_dataout;
				ni1lOi <= wire_ni1lll_dataout;
				ni1O1i <= ni1O1l;
				ni1O1l <= ni1lOO;
				ni1Oi <= wire_nl1il_dataout;
				ni1Ol <= wire_nl1iO_dataout;
				nii01i <= nliiOOl;
				nii01l <= wire_niiOOO_o;
				nii10l <= (wire_w_lg_w_lg_w_lg_nliiO0O1471w1473w1474w(0) AND wire_nliii_w_lg_nii1il1475w(0));
				nii1il <= wire_nii0il_dataout;
				niiOli <= wire_niiOOi_o;
				niiOll <= wire_niiOOl_o;
				niiOlO <= wire_nillii_dataout;
				nil00i <= wire_niO11i_dataout;
				nil00l <= wire_niO11l_dataout;
				nil00O <= wire_niO11O_dataout;
				nil01i <= wire_nilO1i_dataout;
				nil01l <= wire_nilO1l_dataout;
				nil01O <= wire_nilOOO_dataout;
				nil0ii <= wire_niO10i_dataout;
				nil0il <= wire_niO10l_dataout;
				nil0iO <= wire_niO10O_dataout;
				nil0li <= wire_niO1ii_dataout;
				nil0ll <= wire_niO1il_dataout;
				nil0lO <= wire_niO1iO_dataout;
				nil0Oi <= wire_niO1li_dataout;
				nil0Ol <= wire_niO1ll_dataout;
				nil0OO <= wire_niO1lO_dataout;
				nil1il <= wire_nillil_dataout;
				nil1iO <= wire_nilliO_dataout;
				nil1li <= wire_nillli_dataout;
				nil1ll <= wire_nillll_dataout;
				nil1lO <= wire_nilllO_dataout;
				nil1Oi <= wire_nillOi_dataout;
				nil1Ol <= wire_nillOl_dataout;
				nil1OO <= wire_nillOO_dataout;
				nili0i <= (NOT (((NOT (eidleinfersel(0) XOR niOlOl)) AND (NOT (eidleinfersel(1) XOR niOlOO))) AND (NOT (eidleinfersel(2) XOR niOO1i))));
				nili0l <= nlil11l;
				nili0O <= nlil11O;
				nili1i <= wire_niO1Oi_dataout;
				nili1l <= (nili0i OR niiOli);
				nili1O <= (nili0i OR niiOll);
				niliii <= wire_niOi1i_dataout;
				niliil <= wire_niOi1l_dataout;
				niliiO <= wire_niOi1O_dataout;
				nilili <= wire_niOi0i_dataout;
				nilill <= wire_niOi0l_dataout;
				nililO <= wire_niOi0O_dataout;
				niliOi <= wire_niOiii_dataout;
				niliOl <= wire_niOiiO_dataout;
				niliOO <= wire_niOili_dataout;
				nill0i <= wire_niOiOl_dataout;
				nill0l <= wire_niOiOO_dataout;
				nill1i <= wire_niOill_dataout;
				nill1l <= wire_niOilO_dataout;
				nill1O <= wire_niOiOi_dataout;
				niOlOl <= eidleinfersel(0);
				niOlOO <= eidleinfersel(1);
				niOO0i <= datain_ch5(8);
				niOO0l <= datain_ch5(0);
				niOO0O <= datain_ch5(1);
				niOO1i <= eidleinfersel(2);
				niOO1l <= niOO1O;
				niOO1O <= rxvalid(5);
				niOOii <= datain_ch5(2);
				niOOil <= datain_ch5(3);
				niOOiO <= datain_ch5(4);
				niOOli <= datain_ch5(5);
				niOOll <= datain_ch5(6);
				niOOlO <= datain_ch5(7);
				nl00il <= (wire_w_lg_w_lg_w_lg_nlil0iO934w936w937w(0) AND wire_nliii_w_lg_nl00ll938w(0));
				nl00ll <= wire_nl0ill_dataout;
				nl010i <= nlil0OO;
				nl010l <= nl010O;
				nl010O <= nl0i0i;
				nl011i <= (nlil0OO AND nl011l);
				nl011l <= (nlil0OO AND nl0i0i);
				nl011O <= nl010i;
				nl01ii <= (nl0i0i AND (nlili1l OR (nlO10O AND nlil1lO)));
				nl0i0i <= nlili1l;
				nl0i0l <= wire_nli01O_o;
				nl0iO <= eidleinfersel(0);
				nl0li <= eidleinfersel(1);
				nl0ll <= eidleinfersel(2);
				nl0lO <= nl0Oi;
				nl0Oi <= rxvalid(7);
				nl0Ol <= datain_ch7(8);
				nl0OO <= datain_ch7(0);
				nl110i <= nl110l;
				nl110l <= nl111O;
				nl111i <= wire_niOOOl_dataout;
				nl1lOi <= wire_nl1O1l_o;
				nl1lOl <= wire_nl1O1O_o;
				nl1O1i <= ((((nlil0OO AND nl011i) OR wire_w_lg_nlil0OO984w(0)) OR wire_w_lg_nlil0OO988w(0)) OR (wire_w_lg_nlili1l990w(0) AND (wire_w_lg_nlil0OO991w(0) AND (nlil1Oi AND nl010i))));
				nli0i <= datain_ch7(4);
				nli0l <= datain_ch7(5);
				nli0ll <= wire_nliOll_dataout;
				nli0lO <= wire_nliOlO_dataout;
				nli0O <= datain_ch7(6);
				nli0Oi <= wire_nliOOi_dataout;
				nli0Ol <= wire_nliOOl_dataout;
				nli0OO <= wire_nliOOO_dataout;
				nli1i <= datain_ch7(1);
				nli1l <= datain_ch7(2);
				nli1O <= datain_ch7(3);
				nli1Oi <= wire_nli01i_o;
				nli1Ol <= wire_nli01l_o;
				nli1OO <= wire_nliOli_dataout;
				nlii0i <= wire_nll10i_dataout;
				nlii0l <= wire_nll10l_dataout;
				nlii0O <= wire_nll01O_dataout;
				nlii1i <= wire_nll11i_dataout;
				nlii1l <= wire_nll11l_dataout;
				nlii1O <= wire_nll11O_dataout;
				nliiii <= wire_nll00i_dataout;
				nliiil <= wire_nll00l_dataout;
				nliiiO <= wire_nll00O_dataout;
				nliil <= datain_ch7(7);
				nliili <= wire_nll0ii_dataout;
				nliill <= wire_nll0il_dataout;
				nliilO <= wire_nll0iO_dataout;
				nliiOi <= wire_nll0li_dataout;
				nliiOl <= wire_nll0ll_dataout;
				nliiOO <= wire_nll0lO_dataout;
				nlil0i <= wire_nlli1i_dataout;
				nlil0l <= (nlilii OR nli1Oi);
				nlil0O <= (nlilii OR nli1Ol);
				nlil1i <= wire_nll0Oi_dataout;
				nlil1l <= wire_nll0Ol_dataout;
				nlil1O <= wire_nll0OO_dataout;
				nlilii <= (NOT (((NOT (eidleinfersel(0) XOR nlO11l)) AND (NOT (eidleinfersel(1) XOR nlO11O))) AND (NOT (eidleinfersel(2) XOR nlO10i))));
				nlilil <= nlili0l;
				nliliO <= nlili0O;
				nlilli <= wire_nlll0i_dataout;
				nlilll <= wire_nlll0l_dataout;
				nlillO <= wire_nlll0O_dataout;
				nlilOi <= wire_nlllii_dataout;
				nlilOl <= wire_nlllil_dataout;
				nlilOO <= wire_nllliO_dataout;
				nliO0i <= wire_nlllOl_dataout;
				nliO0l <= wire_nlllOO_dataout;
				nliO0O <= wire_nllO1i_dataout;
				nliO1i <= wire_nlllli_dataout;
				nliO1l <= wire_nllllO_dataout;
				nliO1O <= wire_nlllOi_dataout;
				nliOii <= wire_nllO1l_dataout;
				nliOil <= wire_nllO1O_dataout;
				nliOiOi <= wire_nliOill_dataout;
				nliOl1i <= nliOl1l;
				nliOl1l <= nliOiOO;
				nll011i <= nli1llO;
				nll011l <= wire_nll0lOO_o;
				nll0lli <= wire_nll0lOi_o;
				nll0lll <= wire_nll0lOl_o;
				nll0llO <= wire_nlliiii_dataout;
				nll0Oil <= wire_nlliiil_dataout;
				nll0OiO <= wire_nlliiiO_dataout;
				nll0Oli <= wire_nlliili_dataout;
				nll0Oll <= wire_nlliill_dataout;
				nll0OlO <= wire_nlliilO_dataout;
				nll0OOi <= wire_nlliiOi_dataout;
				nll0OOl <= wire_nlliiOl_dataout;
				nll0OOO <= wire_nlliiOO_dataout;
				nll10li <= wire_nll10Ol_o;
				nll10ll <= wire_nll10OO_o;
				nll10Oi <= ((((nli1lli AND nll1iOi) OR wire_w_lg_nli1lli4206w(0)) OR wire_w_lg_nli1lli4210w(0)) OR (wire_w_lg_nli1llO4212w(0) AND (wire_w_lg_nli1lli4213w(0) AND (nli1iil AND nll1l1i))));
				nll1iOi <= (nli1lli AND nll1iOl);
				nll1iOl <= (nli1lli AND nll011i);
				nll1iOO <= nll1l1i;
				nll1l0i <= (nll011i AND (nli1llO OR (nllll1O AND nli1iii)));
				nll1l1i <= nli1lli;
				nll1l1l <= nll1l1O;
				nll1l1O <= nll011i;
				nll1O0l <= (wire_w_lg_w_lg_w_lg_nli1l0i4156w4158w4159w(0) AND wire_nliii_w_lg_nll1Oil4160w(0));
				nll1Oil <= wire_nll01il_dataout;
				nlli00i <= (NOT (((NOT (eidleinfersel(0) XOR nllliOl)) AND (NOT (eidleinfersel(1) XOR nllliOO))) AND (NOT (eidleinfersel(2) XOR nllll1i))));
				nlli00l <= nli1lOO;
				nlli00O <= nli1O1i;
				nlli01i <= wire_nlliOOi_dataout;
				nlli01l <= (nlli00i OR nll0lli);
				nlli01O <= (nlli00i OR nll0lll);
				nlli0ii <= wire_nlll01i_dataout;
				nlli0il <= wire_nlll01l_dataout;
				nlli0iO <= wire_nlll01O_dataout;
				nlli0li <= wire_nlll00i_dataout;
				nlli0ll <= wire_nlll00l_dataout;
				nlli0lO <= wire_nlll00O_dataout;
				nlli0Oi <= wire_nlll0ii_dataout;
				nlli0Ol <= wire_nlll0iO_dataout;
				nlli0OO <= wire_nlll0li_dataout;
				nlli10i <= wire_nlliO1i_dataout;
				nlli10l <= wire_nlliO1l_dataout;
				nlli10O <= wire_nlliO1O_dataout;
				nlli11i <= wire_nllil1i_dataout;
				nlli11l <= wire_nllil1l_dataout;
				nlli11O <= wire_nllilOO_dataout;
				nlli1ii <= wire_nlliO0i_dataout;
				nlli1il <= wire_nlliO0l_dataout;
				nlli1iO <= wire_nlliO0O_dataout;
				nlli1li <= wire_nlliOii_dataout;
				nlli1ll <= wire_nlliOil_dataout;
				nlli1lO <= wire_nlliOiO_dataout;
				nlli1Oi <= wire_nlliOli_dataout;
				nlli1Ol <= wire_nlliOll_dataout;
				nlli1OO <= wire_nlliOlO_dataout;
				nllii0i <= wire_nlll0Ol_dataout;
				nllii0l <= wire_nlll0OO_dataout;
				nllii1i <= wire_nlll0ll_dataout;
				nllii1l <= wire_nlll0lO_dataout;
				nllii1O <= wire_nlll0Oi_dataout;
				nllliOl <= eidleinfersel(0);
				nllliOO <= eidleinfersel(1);
				nllll0i <= datain_ch0(8);
				nllll0l <= datain_ch0(0);
				nllll0O <= datain_ch0(1);
				nllll1i <= eidleinfersel(2);
				nllll1l <= nllll1O;
				nllll1O <= rxvalid(0);
				nllllii <= datain_ch0(2);
				nllllil <= datain_ch0(3);
				nlllliO <= datain_ch0(4);
				nllllli <= datain_ch0(5);
				nllllll <= datain_ch0(6);
				nlllllO <= datain_ch0(7);
				nlllO0i <= nlllO0l;
				nlllO0l <= nlllO1O;
				nlllO1i <= wire_nllllOl_dataout;
				nllOiOi <= wire_nllOl1l_o;
				nllOiOl <= wire_nllOl1O_o;
				nllOl1i <= ((((nli01Oi AND nllOO1i) OR wire_w_lg_nli01Oi3669w(0)) OR wire_w_lg_nli01Oi3673w(0)) OR (wire_w_lg_nli01OO3675w(0) AND (wire_w_lg_nli01Oi3676w(0) AND (nli1Oll AND nllOO0i))));
				nllOO0i <= nli01Oi;
				nllOO0l <= nllOO0O;
				nllOO0O <= nlO100i;
				nllOO1i <= (nli01Oi AND nllOO1l);
				nllOO1l <= (nli01Oi AND nlO100i);
				nllOO1O <= nllOO0i;
				nllOOii <= (nlO100i AND (nli01OO OR (nlOiO0O AND nli1Oli)));
				nlO000i <= wire_nlO0O0i_dataout;
				nlO000l <= wire_nlO0O0l_dataout;
				nlO000O <= wire_nlOi11O_dataout;
				nlO001i <= wire_nlO0O1i_dataout;
				nlO001l <= wire_nlO0O1l_dataout;
				nlO001O <= wire_nlO0O1O_dataout;
				nlO00ii <= wire_nlOi10i_dataout;
				nlO00il <= wire_nlOi10l_dataout;
				nlO00iO <= wire_nlOi10O_dataout;
				nlO00l <= wire_nlO01O_dataout;
				nlO00li <= wire_nlOi1ii_dataout;
				nlO00ll <= wire_nlOi1il_dataout;
				nlO00lO <= wire_nlOi1iO_dataout;
				nlO00Oi <= wire_nlOi1li_dataout;
				nlO00Ol <= wire_nlOi1ll_dataout;
				nlO00OO <= wire_nlOi1lO_dataout;
				nlO01ll <= wire_nlO0lll_dataout;
				nlO01lO <= wire_nlO0llO_dataout;
				nlO01Oi <= wire_nlO0lOi_dataout;
				nlO01Ol <= wire_nlO0lOl_dataout;
				nlO01OO <= wire_nlO0lOO_dataout;
				nlO0i0i <= wire_nlOi01i_dataout;
				nlO0i0l <= (nlO0iii OR nlO1OOi);
				nlO0i0O <= (nlO0iii OR nlO1OOl);
				nlO0i1i <= wire_nlOi1Oi_dataout;
				nlO0i1l <= wire_nlOi1Ol_dataout;
				nlO0i1O <= wire_nlOi1OO_dataout;
				nlO0iii <= (NOT (((NOT (eidleinfersel(0) XOR nlOiO1l)) AND (NOT (eidleinfersel(1) XOR nlOiO1O))) AND (NOT (eidleinfersel(2) XOR nlOiO0i))));
				nlO0iil <= nli001O;
				nlO0iiO <= nli000i;
				nlO0ili <= wire_nlOii0i_dataout;
				nlO0ill <= wire_nlOii0l_dataout;
				nlO0ilO <= wire_nlOii0O_dataout;
				nlO0iO <= nlO0li;
				nlO0iOi <= wire_nlOiiii_dataout;
				nlO0iOl <= wire_nlOiiil_dataout;
				nlO0iOO <= wire_nlOiiiO_dataout;
				nlO0l0i <= wire_nlOiiOl_dataout;
				nlO0l0l <= wire_nlOiiOO_dataout;
				nlO0l0O <= wire_nlOil1i_dataout;
				nlO0l1i <= wire_nlOiili_dataout;
				nlO0l1l <= wire_nlOiilO_dataout;
				nlO0l1O <= wire_nlOiiOi_dataout;
				nlO0li <= nlO0il;
				nlO0lii <= wire_nlOil1l_dataout;
				nlO0lil <= wire_nlOil1O_dataout;
				nlO100i <= nli01OO;
				nlO100l <= wire_nlO011O_o;
				nlO10i <= eidleinfersel(2);
				nlO10l <= nlO10O;
				nlO10O <= rxvalid(6);
				nlO11il <= (wire_w_lg_w_lg_w_lg_nli01ii3619w3621w3622w(0) AND wire_nliii_w_lg_nlO11ll3623w(0));
				nlO11l <= eidleinfersel(0);
				nlO11ll <= wire_nlO10ll_dataout;
				nlO11O <= eidleinfersel(1);
				nlO1ii <= datain_ch6(8);
				nlO1il <= datain_ch6(0);
				nlO1iO <= datain_ch6(1);
				nlO1li <= datain_ch6(2);
				nlO1ll <= datain_ch6(3);
				nlO1lO <= datain_ch6(4);
				nlO1Oi <= datain_ch6(5);
				nlO1Ol <= datain_ch6(6);
				nlO1OO <= datain_ch6(7);
				nlO1OOi <= wire_nlO011i_o;
				nlO1OOl <= wire_nlO011l_o;
				nlO1OOO <= wire_nlO0lli_dataout;
				nlOiO0i <= eidleinfersel(2);
				nlOiO0l <= nlOiO0O;
				nlOiO0O <= rxvalid(1);
				nlOiO1l <= eidleinfersel(0);
				nlOiO1O <= eidleinfersel(1);
				nlOiOii <= datain_ch1(8);
				nlOiOil <= datain_ch1(0);
				nlOiOiO <= datain_ch1(1);
				nlOiOli <= datain_ch1(2);
				nlOiOll <= datain_ch1(3);
				nlOiOlO <= datain_ch1(4);
				nlOiOOi <= datain_ch1(5);
				nlOiOOl <= datain_ch1(6);
				nlOiOOO <= datain_ch1(7);
				nlOl10i <= wire_nlOl11l_dataout;
				nlOl1ii <= nlOl1il;
				nlOl1il <= nlOl10O;
				nlOlO0i <= ((((nli0l1l AND nlOO10i) OR wire_w_lg_nli0l1l3133w(0)) OR wire_w_lg_nli0l1l3137w(0)) OR (wire_w_lg_nli0l0i3139w(0) AND (wire_w_lg_nli0l1l3140w(0) AND (nli00Ol AND nlOO1ii))));
				nlOlO1i <= wire_nlOlO0l_o;
				nlOlO1l <= wire_nlOlO0O_o;
				nlOO0ll <= (wire_w_lg_w_lg_w_lg_nli0ill3083w3085w3086w(0) AND wire_nliii_w_lg_nlOO0Ol3087w(0));
				nlOO0Ol <= wire_nlOOiOl_dataout;
				nlOO10i <= (nli0l1l AND nlOO10l);
				nlOO10l <= (nli0l1l AND nlOOiii);
				nlOO10O <= nlOO1ii;
				nlOO1ii <= nli0l1l;
				nlOO1il <= nlOO1iO;
				nlOO1iO <= nlOOiii;
				nlOO1li <= (nlOOiii AND (nli0l0i OR (n1i1iO AND nli00Oi)));
				nlOOiii <= nli0l0i;
				nlOOiil <= wire_n1100O_o;
		END IF;
	END PROCESS;
	wire_nliii_CLRN <= ((nliOiiO2 XOR nliOiiO1) AND prstn);
	wire_nliii_w_lg_w_lg_w_lg_w2757w2758w2759w2760w(0) <= wire_nliii_w_lg_w_lg_w2757w2758w2759w(0) AND n000Ol;
	wire_nliii_w_lg_w_lg_w_lg_w2117w2118w2120w2132w(0) <= wire_nliii_w_lg_w_lg_w2117w2118w2120w(0) AND n0O10O;
	wire_nliii_w_lg_w_lg_w494w496w508w(0) <= wire_nliii_w_lg_w494w496w(0) AND n0O1O;
	wire_nliii_w_lg_w_lg_w_lg_w3193w3194w3196w3208w(0) <= wire_nliii_w_lg_w_lg_w3193w3194w3196w(0) AND n11iOO;
	wire_nliii_w_lg_w_lg_w_lg_w3295w3296w3297w3298w(0) <= wire_nliii_w_lg_w_lg_w3295w3296w3297w(0) AND n1i1ll;
	wire_nliii_w_lg_w_lg_w_lg_w2655w2656w2658w2670w(0) <= wire_nliii_w_lg_w_lg_w2655w2656w2658w(0) AND n1OO1O;
	wire_nliii_w_lg_w_lg_w_lg_w2219w2220w2221w2222w(0) <= wire_nliii_w_lg_w_lg_w2219w2220w2221w(0) AND ni1l1l;
	wire_nliii_w_lg_w_lg_w_lg_w1581w1582w1584w1596w(0) <= wire_nliii_w_lg_w_lg_w1581w1582w1584w(0) AND nil0iO;
	wire_nliii_w_lg_w_lg_w_lg_w1683w1684w1685w1686w(0) <= wire_nliii_w_lg_w_lg_w1683w1684w1685w(0) AND niOO0l;
	wire_nliii_w_lg_w_lg_w606w607w608w(0) <= wire_nliii_w_lg_w606w607w(0) AND nl0OO;
	wire_nliii_w_lg_w_lg_w_lg_w1044w1045w1047w1059w(0) <= wire_nliii_w_lg_w_lg_w1044w1045w1047w(0) AND nliilO;
	wire_nliii_w_lg_w_lg_w_lg_w4266w4267w4269w4281w(0) <= wire_nliii_w_lg_w_lg_w4266w4267w4269w(0) AND nlli1iO;
	wire_nliii_w_lg_w_lg_w_lg_w4368w4369w4370w4371w(0) <= wire_nliii_w_lg_w_lg_w4368w4369w4370w(0) AND nllll0l;
	wire_nliii_w_lg_w_lg_w_lg_w3729w3730w3732w3744w(0) <= wire_nliii_w_lg_w_lg_w3729w3730w3732w(0) AND nlO00lO;
	wire_nliii_w_lg_w_lg_w_lg_w1146w1147w1148w1149w(0) <= wire_nliii_w_lg_w_lg_w1146w1147w1148w(0) AND nlO1il;
	wire_nliii_w_lg_w_lg_w_lg_w3831w3832w3833w3834w(0) <= wire_nliii_w_lg_w_lg_w3831w3832w3833w(0) AND nlOiOil;
	wire_nliii_w_lg_w_lg_w2740w2741w2742w(0) <= wire_nliii_w_lg_w2740w2741w(0) AND n000Ol;
	wire_nliii_w_lg_w_lg_w3278w3279w3280w(0) <= wire_nliii_w_lg_w3278w3279w(0) AND n1i1ll;
	wire_nliii_w_lg_w_lg_w2202w2203w2204w(0) <= wire_nliii_w_lg_w2202w2203w(0) AND ni1l1l;
	wire_nliii_w_lg_w_lg_w1666w1667w1668w(0) <= wire_nliii_w_lg_w1666w1667w(0) AND niOO0l;
	wire_nliii_w_lg_w589w590w(0) <= wire_nliii_w589w(0) AND nl0OO;
	wire_nliii_w_lg_w_lg_w4351w4352w4353w(0) <= wire_nliii_w_lg_w4351w4352w(0) AND nllll0l;
	wire_nliii_w_lg_w_lg_w1129w1130w1131w(0) <= wire_nliii_w_lg_w1129w1130w(0) AND nlO1il;
	wire_nliii_w_lg_w_lg_w3814w3815w3816w(0) <= wire_nliii_w_lg_w3814w3815w(0) AND nlOiOil;
	wire_nliii_w_lg_w_lg_w2757w2758w2759w(0) <= wire_nliii_w_lg_w2757w2758w(0) AND wire_nliii_w_lg_n000OO2707w(0);
	wire_nliii_w_lg_w_lg_w2747w2749w2750w(0) <= wire_nliii_w_lg_w2747w2749w(0) AND n000OO;
	wire_nliii_w_lg_w_lg_w2117w2118w2120w(0) <= wire_nliii_w_lg_w2117w2118w(0) AND wire_nliii_w_lg_n0O1ii2119w(0);
	wire_nliii_w_lg_w494w496w(0) <= wire_nliii_w494w(0) AND wire_nliii_w_lg_n0O0i495w(0);
	wire_nliii_w_lg_w_lg_w3193w3194w3196w(0) <= wire_nliii_w_lg_w3193w3194w(0) AND wire_nliii_w_lg_n11l1i3195w(0);
	wire_nliii_w_lg_w_lg_w3295w3296w3297w(0) <= wire_nliii_w_lg_w3295w3296w(0) AND wire_nliii_w_lg_n1i1lO3245w(0);
	wire_nliii_w_lg_w_lg_w3285w3287w3288w(0) <= wire_nliii_w_lg_w3285w3287w(0) AND n1i1lO;
	wire_nliii_w_lg_w_lg_w2655w2656w2658w(0) <= wire_nliii_w_lg_w2655w2656w(0) AND wire_nliii_w_lg_n1OO0i2657w(0);
	wire_nliii_w_lg_w_lg_w2219w2220w2221w(0) <= wire_nliii_w_lg_w2219w2220w(0) AND wire_nliii_w_lg_ni1l1O2169w(0);
	wire_nliii_w_lg_w_lg_w2209w2211w2212w(0) <= wire_nliii_w_lg_w2209w2211w(0) AND ni1l1O;
	wire_nliii_w_lg_w_lg_w1581w1582w1584w(0) <= wire_nliii_w_lg_w1581w1582w(0) AND wire_nliii_w_lg_nil0li1583w(0);
	wire_nliii_w_lg_w_lg_w1683w1684w1685w(0) <= wire_nliii_w_lg_w1683w1684w(0) AND wire_nliii_w_lg_niOO0O1633w(0);
	wire_nliii_w_lg_w_lg_w1673w1675w1676w(0) <= wire_nliii_w_lg_w1673w1675w(0) AND niOO0O;
	wire_nliii_w_lg_w606w607w(0) <= wire_nliii_w606w(0) AND wire_nliii_w_lg_nli1i555w(0);
	wire_nliii_w_lg_w597w598w(0) <= wire_nliii_w597w(0) AND nli1i;
	wire_nliii_w_lg_w_lg_w1044w1045w1047w(0) <= wire_nliii_w_lg_w1044w1045w(0) AND wire_nliii_w_lg_nliiOi1046w(0);
	wire_nliii_w_lg_w_lg_w4266w4267w4269w(0) <= wire_nliii_w_lg_w4266w4267w(0) AND wire_nliii_w_lg_nlli1li4268w(0);
	wire_nliii_w_lg_w_lg_w4368w4369w4370w(0) <= wire_nliii_w_lg_w4368w4369w(0) AND wire_nliii_w_lg_nllll0O4318w(0);
	wire_nliii_w_lg_w_lg_w4358w4360w4361w(0) <= wire_nliii_w_lg_w4358w4360w(0) AND nllll0O;
	wire_nliii_w_lg_w_lg_w3729w3730w3732w(0) <= wire_nliii_w_lg_w3729w3730w(0) AND wire_nliii_w_lg_nlO00Oi3731w(0);
	wire_nliii_w_lg_w_lg_w1146w1147w1148w(0) <= wire_nliii_w_lg_w1146w1147w(0) AND wire_nliii_w_lg_nlO1iO1096w(0);
	wire_nliii_w_lg_w_lg_w1136w1138w1139w(0) <= wire_nliii_w_lg_w1136w1138w(0) AND nlO1iO;
	wire_nliii_w_lg_w_lg_w3831w3832w3833w(0) <= wire_nliii_w_lg_w3831w3832w(0) AND wire_nliii_w_lg_nlOiOiO3781w(0);
	wire_nliii_w_lg_w_lg_w3821w3823w3824w(0) <= wire_nliii_w_lg_w3821w3823w(0) AND nlOiOiO;
	wire_nliii_w_lg_w2740w2741w(0) <= wire_nliii_w2740w(0) AND wire_nliii_w_lg_n000OO2707w(0);
	wire_nliii_w_lg_w2753w2754w(0) <= wire_nliii_w2753w(0) AND n000OO;
	wire_nliii_w_lg_w3278w3279w(0) <= wire_nliii_w3278w(0) AND wire_nliii_w_lg_n1i1lO3245w(0);
	wire_nliii_w_lg_w3291w3292w(0) <= wire_nliii_w3291w(0) AND n1i1lO;
	wire_nliii_w_lg_w2202w2203w(0) <= wire_nliii_w2202w(0) AND wire_nliii_w_lg_ni1l1O2169w(0);
	wire_nliii_w_lg_w2215w2216w(0) <= wire_nliii_w2215w(0) AND ni1l1O;
	wire_nliii_w_lg_w1666w1667w(0) <= wire_nliii_w1666w(0) AND wire_nliii_w_lg_niOO0O1633w(0);
	wire_nliii_w_lg_w1679w1680w(0) <= wire_nliii_w1679w(0) AND niOO0O;
	wire_nliii_w589w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_nliil550w551w552w587w588w(0) AND wire_nliii_w_lg_nli1i555w(0);
	wire_nliii_w602w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_nliil550w551w552w553w601w(0) AND nli1i;
	wire_nliii_w_lg_w4351w4352w(0) <= wire_nliii_w4351w(0) AND wire_nliii_w_lg_nllll0O4318w(0);
	wire_nliii_w_lg_w4364w4365w(0) <= wire_nliii_w4364w(0) AND nllll0O;
	wire_nliii_w_lg_w1129w1130w(0) <= wire_nliii_w1129w(0) AND wire_nliii_w_lg_nlO1iO1096w(0);
	wire_nliii_w_lg_w1142w1143w(0) <= wire_nliii_w1142w(0) AND nlO1iO;
	wire_nliii_w_lg_w3814w3815w(0) <= wire_nliii_w3814w(0) AND wire_nliii_w_lg_nlOiOiO3781w(0);
	wire_nliii_w_lg_w3827w3828w(0) <= wire_nliii_w3827w(0) AND nlOiOiO;
	wire_nliii_w_lg_w2725w2726w(0) <= wire_nliii_w2725w(0) AND n00i1i;
	wire_nliii_w_lg_w2757w2758w(0) <= wire_nliii_w2757w(0) AND n00i1i;
	wire_nliii_w_lg_w2747w2749w(0) <= wire_nliii_w2747w(0) AND wire_nliii_w_lg_n00i1i2748w(0);
	wire_nliii_w_lg_w2716w2717w(0) <= wire_nliii_w2716w(0) AND n00i1i;
	wire_nliii_w_lg_w2117w2118w(0) <= wire_nliii_w2117w(0) AND wire_nliii_w_lg_n0O1il2083w(0);
	wire_nliii_w494w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_n0Oli473w487w489w491w493w(0) AND wire_nliii_w_lg_n0O0l458w(0);
	wire_nliii_w_lg_w3193w3194w(0) <= wire_nliii_w3193w(0) AND wire_nliii_w_lg_n11l1l3159w(0);
	wire_nliii_w_lg_w3263w3264w(0) <= wire_nliii_w3263w(0) AND n1i1Oi;
	wire_nliii_w_lg_w3295w3296w(0) <= wire_nliii_w3295w(0) AND n1i1Oi;
	wire_nliii_w_lg_w3285w3287w(0) <= wire_nliii_w3285w(0) AND wire_nliii_w_lg_n1i1Oi3286w(0);
	wire_nliii_w_lg_w3254w3255w(0) <= wire_nliii_w3254w(0) AND n1i1Oi;
	wire_nliii_w_lg_w2655w2656w(0) <= wire_nliii_w2655w(0) AND wire_nliii_w_lg_n1OO0l2621w(0);
	wire_nliii_w_lg_w2187w2188w(0) <= wire_nliii_w2187w(0) AND ni1l0i;
	wire_nliii_w_lg_w2219w2220w(0) <= wire_nliii_w2219w(0) AND ni1l0i;
	wire_nliii_w_lg_w2209w2211w(0) <= wire_nliii_w2209w(0) AND wire_nliii_w_lg_ni1l0i2210w(0);
	wire_nliii_w_lg_w2178w2179w(0) <= wire_nliii_w2178w(0) AND ni1l0i;
	wire_nliii_w_lg_w1581w1582w(0) <= wire_nliii_w1581w(0) AND wire_nliii_w_lg_nil0ll1547w(0);
	wire_nliii_w_lg_w1651w1652w(0) <= wire_nliii_w1651w(0) AND niOOii;
	wire_nliii_w_lg_w1683w1684w(0) <= wire_nliii_w1683w(0) AND niOOii;
	wire_nliii_w_lg_w1673w1675w(0) <= wire_nliii_w1673w(0) AND wire_nliii_w_lg_niOOii1674w(0);
	wire_nliii_w_lg_w1642w1643w(0) <= wire_nliii_w1642w(0) AND niOOii;
	wire_nliii_w574w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_nliil560w569w571w572w573w(0) AND nli1l;
	wire_nliii_w606w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_nliil560w561w592w594w605w(0) AND nli1l;
	wire_nliii_w597w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_nliil560w561w592w594w595w(0) AND wire_nliii_w_lg_nli1l596w(0);
	wire_nliii_w565w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_nliil560w561w562w563w564w(0) AND nli1l;
	wire_nliii_w_lg_w1044w1045w(0) <= wire_nliii_w1044w(0) AND wire_nliii_w_lg_nliiOl1010w(0);
	wire_nliii_w_lg_w4266w4267w(0) <= wire_nliii_w4266w(0) AND wire_nliii_w_lg_nlli1ll4232w(0);
	wire_nliii_w_lg_w4336w4337w(0) <= wire_nliii_w4336w(0) AND nllllii;
	wire_nliii_w_lg_w4368w4369w(0) <= wire_nliii_w4368w(0) AND nllllii;
	wire_nliii_w_lg_w4358w4360w(0) <= wire_nliii_w4358w(0) AND wire_nliii_w_lg_nllllii4359w(0);
	wire_nliii_w_lg_w4327w4328w(0) <= wire_nliii_w4327w(0) AND nllllii;
	wire_nliii_w_lg_w3729w3730w(0) <= wire_nliii_w3729w(0) AND wire_nliii_w_lg_nlO00Ol3695w(0);
	wire_nliii_w_lg_w1114w1115w(0) <= wire_nliii_w1114w(0) AND nlO1li;
	wire_nliii_w_lg_w1146w1147w(0) <= wire_nliii_w1146w(0) AND nlO1li;
	wire_nliii_w_lg_w1136w1138w(0) <= wire_nliii_w1136w(0) AND wire_nliii_w_lg_nlO1li1137w(0);
	wire_nliii_w_lg_w1105w1106w(0) <= wire_nliii_w1105w(0) AND nlO1li;
	wire_nliii_w_lg_w3799w3800w(0) <= wire_nliii_w3799w(0) AND nlOiOli;
	wire_nliii_w_lg_w3831w3832w(0) <= wire_nliii_w3831w(0) AND nlOiOli;
	wire_nliii_w_lg_w3821w3823w(0) <= wire_nliii_w3821w(0) AND wire_nliii_w_lg_nlOiOli3822w(0);
	wire_nliii_w_lg_w3790w3791w(0) <= wire_nliii_w3790w(0) AND nlOiOli;
	wire_nliii_w2740w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_n00i0O2702w2703w2704w2739w(0) AND n00i1i;
	wire_nliii_w2753w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_n00i0O2702w2703w2704w2705w(0) AND wire_nliii_w_lg_n00i1i2748w(0);
	wire_nliii_w2706w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_n00i0O2702w2703w2704w2705w(0) AND n00i1i;
	wire_nliii_w3278w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_n1i01O3240w3241w3242w3277w(0) AND n1i1Oi;
	wire_nliii_w3291w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_n1i01O3240w3241w3242w3243w(0) AND wire_nliii_w_lg_n1i1Oi3286w(0);
	wire_nliii_w3244w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_n1i01O3240w3241w3242w3243w(0) AND n1i1Oi;
	wire_nliii_w2202w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_ni1liO2164w2165w2166w2201w(0) AND ni1l0i;
	wire_nliii_w2215w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_ni1liO2164w2165w2166w2167w(0) AND wire_nliii_w_lg_ni1l0i2210w(0);
	wire_nliii_w2168w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_ni1liO2164w2165w2166w2167w(0) AND ni1l0i;
	wire_nliii_w1666w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_niOOlO1628w1629w1630w1665w(0) AND niOOii;
	wire_nliii_w1679w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_niOOlO1628w1629w1630w1631w(0) AND wire_nliii_w_lg_niOOii1674w(0);
	wire_nliii_w1632w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_niOOlO1628w1629w1630w1631w(0) AND niOOii;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_nliil550w551w552w587w588w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nliil550w551w552w587w(0) AND nli1l;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_nliil550w551w552w553w601w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nliil550w551w552w553w(0) AND wire_nliii_w_lg_nli1l596w(0);
	wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_nliil550w551w552w553w554w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nliil550w551w552w553w(0) AND nli1l;
	wire_nliii_w4351w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nlllllO4313w4314w4315w4350w(0) AND nllllii;
	wire_nliii_w4364w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nlllllO4313w4314w4315w4316w(0) AND wire_nliii_w_lg_nllllii4359w(0);
	wire_nliii_w4317w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nlllllO4313w4314w4315w4316w(0) AND nllllii;
	wire_nliii_w1129w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO1OO1091w1092w1093w1128w(0) AND nlO1li;
	wire_nliii_w1142w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO1OO1091w1092w1093w1094w(0) AND wire_nliii_w_lg_nlO1li1137w(0);
	wire_nliii_w1095w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO1OO1091w1092w1093w1094w(0) AND nlO1li;
	wire_nliii_w3814w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nlOiOOO3776w3777w3778w3813w(0) AND nlOiOli;
	wire_nliii_w3827w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nlOiOOO3776w3777w3778w3779w(0) AND wire_nliii_w_lg_nlOiOli3822w(0);
	wire_nliii_w3780w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nlOiOOO3776w3777w3778w3779w(0) AND nlOiOli;
	wire_nliii_w2725w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_n00i0O2712w2721w2723w2724w(0) AND n00i1l;
	wire_nliii_w2757w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_n00i0O2712w2713w2744w2746w(0) AND wire_nliii_w_lg_n00i1l2733w(0);
	wire_nliii_w2747w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_n00i0O2712w2713w2744w2746w(0) AND n00i1l;
	wire_nliii_w2716w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_n00i0O2712w2713w2714w2715w(0) AND n00i1l;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_n0lll526w527w528w529w530w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_n0lll526w527w528w529w(0) AND n0l0i;
	wire_nliii_w2154w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_n0lOOl2150w2151w2152w2153w(0) AND n0lOii;
	wire_nliii_w2117w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_n0O1Oi2097w2111w2113w2115w(0) AND wire_nliii_w_lg_n0O1iO2116w(0);
	wire_nliii_w2101w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_n0O1Oi2097w2098w2099w2100w(0) AND n0O10O;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_n0Oli473w487w489w491w493w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_n0Oli473w487w489w491w(0) AND wire_nliii_w_lg_n0O0O492w(0);
	wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_n0Oli473w474w475w476w477w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_n0Oli473w474w475w476w(0) AND n0O1O;
	wire_nliii_w3230w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_n11iil3226w3227w3228w3229w(0) AND n11i1i;
	wire_nliii_w3193w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_n11lii3173w3187w3189w3191w(0) AND wire_nliii_w_lg_n11l1O3192w(0);
	wire_nliii_w3177w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_n11lii3173w3174w3175w3176w(0) AND n11iOO;
	wire_nliii_w3263w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_n1i01O3250w3259w3261w3262w(0) AND n1i1Ol;
	wire_nliii_w3295w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_n1i01O3250w3251w3282w3284w(0) AND wire_nliii_w_lg_n1i1Ol3271w(0);
	wire_nliii_w3285w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_n1i01O3250w3251w3282w3284w(0) AND n1i1Ol;
	wire_nliii_w3254w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_n1i01O3250w3251w3252w3253w(0) AND n1i1Ol;
	wire_nliii_w2692w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_n1Olll2688w2689w2690w2691w(0) AND n1Ol0i;
	wire_nliii_w2655w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_n1OOli2635w2649w2651w2653w(0) AND wire_nliii_w_lg_n1OO0O2654w(0);
	wire_nliii_w2639w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_n1OOli2635w2636w2637w2638w(0) AND n1OO1O;
	wire_nliii_w2187w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_ni1liO2174w2183w2185w2186w(0) AND ni1l0l;
	wire_nliii_w2219w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_ni1liO2174w2175w2206w2208w(0) AND wire_nliii_w_lg_ni1l0l2195w(0);
	wire_nliii_w2209w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_ni1liO2174w2175w2206w2208w(0) AND ni1l0l;
	wire_nliii_w2178w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_ni1liO2174w2175w2176w2177w(0) AND ni1l0l;
	wire_nliii_w1618w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nil01l1614w1615w1616w1617w(0) AND nil1li;
	wire_nliii_w1581w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nili1i1561w1575w1577w1579w(0) AND wire_nliii_w_lg_nil0lO1580w(0);
	wire_nliii_w1565w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nili1i1561w1562w1563w1564w(0) AND nil0iO;
	wire_nliii_w1651w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_niOOlO1638w1647w1649w1650w(0) AND niOOil;
	wire_nliii_w1683w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_niOOlO1638w1639w1670w1672w(0) AND wire_nliii_w_lg_niOOil1659w(0);
	wire_nliii_w1673w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_niOOlO1638w1639w1670w1672w(0) AND niOOil;
	wire_nliii_w1642w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_niOOlO1638w1639w1640w1641w(0) AND niOOil;
	wire_nliii_w1081w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nlii0l1077w1078w1079w1080w(0) AND nli0Oi;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_nliil560w569w571w572w573w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nliil560w569w571w572w(0) AND nli1O;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_nliil560w561w592w594w605w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nliil560w561w592w594w(0) AND wire_nliii_w_lg_nli1O581w(0);
	wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_nliil560w561w592w594w595w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nliil560w561w592w594w(0) AND nli1O;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_w_lg_nliil560w561w562w563w564w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nliil560w561w562w563w(0) AND nli1O;
	wire_nliii_w1044w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nlil0i1024w1038w1040w1042w(0) AND wire_nliii_w_lg_nliiOO1043w(0);
	wire_nliii_w1028w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nlil0i1024w1025w1026w1027w(0) AND nliilO;
	wire_nliii_w4266w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nlli01i4246w4260w4262w4264w(0) AND wire_nliii_w_lg_nlli1lO4265w(0);
	wire_nliii_w4250w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nlli01i4246w4247w4248w4249w(0) AND nlli1iO;
	wire_nliii_w4303w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nlli11l4299w4300w4301w4302w(0) AND nll0Oli;
	wire_nliii_w4336w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nlllllO4323w4332w4334w4335w(0) AND nllllil;
	wire_nliii_w4368w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nlllllO4323w4324w4355w4357w(0) AND wire_nliii_w_lg_nllllil4344w(0);
	wire_nliii_w4358w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nlllllO4323w4324w4355w4357w(0) AND nllllil;
	wire_nliii_w4327w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nlllllO4323w4324w4325w4326w(0) AND nllllil;
	wire_nliii_w3766w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO000l3762w3763w3764w3765w(0) AND nlO01Oi;
	wire_nliii_w3729w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO0i0i3709w3723w3725w3727w(0) AND wire_nliii_w_lg_nlO00OO3728w(0);
	wire_nliii_w3713w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO0i0i3709w3710w3711w3712w(0) AND nlO00lO;
	wire_nliii_w1114w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO1OO1101w1110w1112w1113w(0) AND nlO1ll;
	wire_nliii_w1146w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO1OO1101w1102w1133w1135w(0) AND wire_nliii_w_lg_nlO1ll1122w(0);
	wire_nliii_w1136w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO1OO1101w1102w1133w1135w(0) AND nlO1ll;
	wire_nliii_w1105w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO1OO1101w1102w1103w1104w(0) AND nlO1ll;
	wire_nliii_w3799w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nlOiOOO3786w3795w3797w3798w(0) AND nlOiOll;
	wire_nliii_w3831w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nlOiOOO3786w3787w3818w3820w(0) AND wire_nliii_w_lg_nlOiOll3807w(0);
	wire_nliii_w3821w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nlOiOOO3786w3787w3818w3820w(0) AND nlOiOll;
	wire_nliii_w3790w(0) <= wire_nliii_w_lg_w_lg_w_lg_w_lg_nlOiOOO3786w3787w3788w3789w(0) AND nlOiOll;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_n00i0O2702w2703w2704w2739w(0) <= wire_nliii_w_lg_w_lg_w_lg_n00i0O2702w2703w2704w(0) AND wire_nliii_w_lg_n00i1l2733w(0);
	wire_nliii_w_lg_w_lg_w_lg_w_lg_n00i0O2702w2703w2704w2705w(0) <= wire_nliii_w_lg_w_lg_w_lg_n00i0O2702w2703w2704w(0) AND n00i1l;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_n0liO510w511w513w514w(0) <= wire_nliii_w_lg_w_lg_w_lg_n0liO510w511w513w(0) AND n0l0l;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_n0lOlO2134w2135w2137w2138w(0) <= wire_nliii_w_lg_w_lg_w_lg_n0lOlO2134w2135w2137w(0) AND n0lOil;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_n0O1ll2081w2082w2084w2085w(0) <= wire_nliii_w_lg_w_lg_w_lg_n0O1ll2081w2082w2084w(0) AND n0O1ii;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_n0Oil456w457w459w460w(0) <= wire_nliii_w_lg_w_lg_w_lg_n0Oil456w457w459w(0) AND n0O0i;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_n11i0O3210w3211w3213w3214w(0) <= wire_nliii_w_lg_w_lg_w_lg_n11i0O3210w3211w3213w(0) AND n11i1l;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_n11l0l3157w3158w3160w3161w(0) <= wire_nliii_w_lg_w_lg_w_lg_n11l0l3157w3158w3160w(0) AND n11l1i;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_n1i01O3240w3241w3242w3277w(0) <= wire_nliii_w_lg_w_lg_w_lg_n1i01O3240w3241w3242w(0) AND wire_nliii_w_lg_n1i1Ol3271w(0);
	wire_nliii_w_lg_w_lg_w_lg_w_lg_n1i01O3240w3241w3242w3243w(0) <= wire_nliii_w_lg_w_lg_w_lg_n1i01O3240w3241w3242w(0) AND n1i1Ol;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_n1OliO2672w2673w2675w2676w(0) <= wire_nliii_w_lg_w_lg_w_lg_n1OliO2672w2673w2675w(0) AND n1Ol0l;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_n1OOil2619w2620w2622w2623w(0) <= wire_nliii_w_lg_w_lg_w_lg_n1OOil2619w2620w2622w(0) AND n1OO0i;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_ni1liO2164w2165w2166w2201w(0) <= wire_nliii_w_lg_w_lg_w_lg_ni1liO2164w2165w2166w(0) AND wire_nliii_w_lg_ni1l0l2195w(0);
	wire_nliii_w_lg_w_lg_w_lg_w_lg_ni1liO2164w2165w2166w2167w(0) <= wire_nliii_w_lg_w_lg_w_lg_ni1liO2164w2165w2166w(0) AND ni1l0l;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nil0Ol1545w1546w1548w1549w(0) <= wire_nliii_w_lg_w_lg_w_lg_nil0Ol1545w1546w1548w(0) AND nil0li;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nil1OO1598w1599w1601w1602w(0) <= wire_nliii_w_lg_w_lg_w_lg_nil1OO1598w1599w1601w(0) AND nil1ll;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_niOOlO1628w1629w1630w1665w(0) <= wire_nliii_w_lg_w_lg_w_lg_niOOlO1628w1629w1630w(0) AND wire_nliii_w_lg_niOOil1659w(0);
	wire_nliii_w_lg_w_lg_w_lg_w_lg_niOOlO1628w1629w1630w1631w(0) <= wire_nliii_w_lg_w_lg_w_lg_niOOlO1628w1629w1630w(0) AND niOOil;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nlii1O1061w1062w1064w1065w(0) <= wire_nliii_w_lg_w_lg_w_lg_nlii1O1061w1062w1064w(0) AND nli0Ol;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nliil550w551w552w587w(0) <= wire_nliii_w_lg_w_lg_w_lg_nliil550w551w552w(0) AND wire_nliii_w_lg_nli1O581w(0);
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nliil550w551w552w553w(0) <= wire_nliii_w_lg_w_lg_w_lg_nliil550w551w552w(0) AND nli1O;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nlil1l1008w1009w1011w1012w(0) <= wire_nliii_w_lg_w_lg_w_lg_nlil1l1008w1009w1011w(0) AND nliiOi;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nll0OOO4283w4284w4286w4287w(0) <= wire_nliii_w_lg_w_lg_w_lg_nll0OOO4283w4284w4286w(0) AND nll0Oll;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nlli1Ol4230w4231w4233w4234w(0) <= wire_nliii_w_lg_w_lg_w_lg_nlli1Ol4230w4231w4233w(0) AND nlli1li;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nlllllO4313w4314w4315w4350w(0) <= wire_nliii_w_lg_w_lg_w_lg_nlllllO4313w4314w4315w(0) AND wire_nliii_w_lg_nllllil4344w(0);
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nlllllO4313w4314w4315w4316w(0) <= wire_nliii_w_lg_w_lg_w_lg_nlllllO4313w4314w4315w(0) AND nllllil;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO001O3746w3747w3749w3750w(0) <= wire_nliii_w_lg_w_lg_w_lg_nlO001O3746w3747w3749w(0) AND nlO01Ol;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO0i1l3693w3694w3696w3697w(0) <= wire_nliii_w_lg_w_lg_w_lg_nlO0i1l3693w3694w3696w(0) AND nlO00Oi;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO1OO1091w1092w1093w1128w(0) <= wire_nliii_w_lg_w_lg_w_lg_nlO1OO1091w1092w1093w(0) AND wire_nliii_w_lg_nlO1ll1122w(0);
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO1OO1091w1092w1093w1094w(0) <= wire_nliii_w_lg_w_lg_w_lg_nlO1OO1091w1092w1093w(0) AND nlO1ll;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nlOiOOO3776w3777w3778w3813w(0) <= wire_nliii_w_lg_w_lg_w_lg_nlOiOOO3776w3777w3778w(0) AND wire_nliii_w_lg_nlOiOll3807w(0);
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nlOiOOO3776w3777w3778w3779w(0) <= wire_nliii_w_lg_w_lg_w_lg_nlOiOOO3776w3777w3778w(0) AND nlOiOll;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_n00i0O2712w2721w2723w2724w(0) <= wire_nliii_w_lg_w_lg_w_lg_n00i0O2712w2721w2723w(0) AND n00i1O;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_n00i0O2712w2713w2744w2746w(0) <= wire_nliii_w_lg_w_lg_w_lg_n00i0O2712w2713w2744w(0) AND wire_nliii_w_lg_n00i1O2745w(0);
	wire_nliii_w_lg_w_lg_w_lg_w_lg_n00i0O2712w2713w2714w2715w(0) <= wire_nliii_w_lg_w_lg_w_lg_n00i0O2712w2713w2714w(0) AND n00i1O;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_n0lll526w527w528w529w(0) <= wire_nliii_w_lg_w_lg_w_lg_n0lll526w527w528w(0) AND n0lii;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_n0lOOl2150w2151w2152w2153w(0) <= wire_nliii_w_lg_w_lg_w_lg_n0lOOl2150w2151w2152w(0) AND n0lOli;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_n0O1Oi2097w2111w2113w2115w(0) <= wire_nliii_w_lg_w_lg_w_lg_n0O1Oi2097w2111w2113w(0) AND wire_nliii_w_lg_n0O1li2114w(0);
	wire_nliii_w_lg_w_lg_w_lg_w_lg_n0O1Oi2097w2098w2099w2100w(0) <= wire_nliii_w_lg_w_lg_w_lg_n0O1Oi2097w2098w2099w(0) AND n0O1iO;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_n0Oli473w487w489w491w(0) <= wire_nliii_w_lg_w_lg_w_lg_n0Oli473w487w489w(0) AND wire_nliii_w_lg_n0Oii490w(0);
	wire_nliii_w_lg_w_lg_w_lg_w_lg_n0Oli473w474w475w476w(0) <= wire_nliii_w_lg_w_lg_w_lg_n0Oli473w474w475w(0) AND n0O0O;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_n11iil3226w3227w3228w3229w(0) <= wire_nliii_w_lg_w_lg_w_lg_n11iil3226w3227w3228w(0) AND n11i0i;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_n11lii3173w3187w3189w3191w(0) <= wire_nliii_w_lg_w_lg_w_lg_n11lii3173w3187w3189w(0) AND wire_nliii_w_lg_n11l0i3190w(0);
	wire_nliii_w_lg_w_lg_w_lg_w_lg_n11lii3173w3174w3175w3176w(0) <= wire_nliii_w_lg_w_lg_w_lg_n11lii3173w3174w3175w(0) AND n11l1O;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_n1i01O3250w3259w3261w3262w(0) <= wire_nliii_w_lg_w_lg_w_lg_n1i01O3250w3259w3261w(0) AND n1i1OO;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_n1i01O3250w3251w3282w3284w(0) <= wire_nliii_w_lg_w_lg_w_lg_n1i01O3250w3251w3282w(0) AND wire_nliii_w_lg_n1i1OO3283w(0);
	wire_nliii_w_lg_w_lg_w_lg_w_lg_n1i01O3250w3251w3252w3253w(0) <= wire_nliii_w_lg_w_lg_w_lg_n1i01O3250w3251w3252w(0) AND n1i1OO;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_n1Olll2688w2689w2690w2691w(0) <= wire_nliii_w_lg_w_lg_w_lg_n1Olll2688w2689w2690w(0) AND n1Olii;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_n1OOli2635w2649w2651w2653w(0) <= wire_nliii_w_lg_w_lg_w_lg_n1OOli2635w2649w2651w(0) AND wire_nliii_w_lg_n1OOii2652w(0);
	wire_nliii_w_lg_w_lg_w_lg_w_lg_n1OOli2635w2636w2637w2638w(0) <= wire_nliii_w_lg_w_lg_w_lg_n1OOli2635w2636w2637w(0) AND n1OO0O;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_ni1liO2174w2183w2185w2186w(0) <= wire_nliii_w_lg_w_lg_w_lg_ni1liO2174w2183w2185w(0) AND ni1l0O;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_ni1liO2174w2175w2206w2208w(0) <= wire_nliii_w_lg_w_lg_w_lg_ni1liO2174w2175w2206w(0) AND wire_nliii_w_lg_ni1l0O2207w(0);
	wire_nliii_w_lg_w_lg_w_lg_w_lg_ni1liO2174w2175w2176w2177w(0) <= wire_nliii_w_lg_w_lg_w_lg_ni1liO2174w2175w2176w(0) AND ni1l0O;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nil01l1614w1615w1616w1617w(0) <= wire_nliii_w_lg_w_lg_w_lg_nil01l1614w1615w1616w(0) AND nil1Oi;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nili1i1561w1575w1577w1579w(0) <= wire_nliii_w_lg_w_lg_w_lg_nili1i1561w1575w1577w(0) AND wire_nliii_w_lg_nil0Oi1578w(0);
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nili1i1561w1562w1563w1564w(0) <= wire_nliii_w_lg_w_lg_w_lg_nili1i1561w1562w1563w(0) AND nil0lO;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_niOOlO1638w1647w1649w1650w(0) <= wire_nliii_w_lg_w_lg_w_lg_niOOlO1638w1647w1649w(0) AND niOOiO;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_niOOlO1638w1639w1670w1672w(0) <= wire_nliii_w_lg_w_lg_w_lg_niOOlO1638w1639w1670w(0) AND wire_nliii_w_lg_niOOiO1671w(0);
	wire_nliii_w_lg_w_lg_w_lg_w_lg_niOOlO1638w1639w1640w1641w(0) <= wire_nliii_w_lg_w_lg_w_lg_niOOlO1638w1639w1640w(0) AND niOOiO;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nlii0l1077w1078w1079w1080w(0) <= wire_nliii_w_lg_w_lg_w_lg_nlii0l1077w1078w1079w(0) AND nlii1i;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nliil560w569w571w572w(0) <= wire_nliii_w_lg_w_lg_w_lg_nliil560w569w571w(0) AND nli0i;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nliil560w561w592w594w(0) <= wire_nliii_w_lg_w_lg_w_lg_nliil560w561w592w(0) AND wire_nliii_w_lg_nli0i593w(0);
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nliil560w561w562w563w(0) <= wire_nliii_w_lg_w_lg_w_lg_nliil560w561w562w(0) AND nli0i;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nlil0i1024w1038w1040w1042w(0) <= wire_nliii_w_lg_w_lg_w_lg_nlil0i1024w1038w1040w(0) AND wire_nliii_w_lg_nlil1i1041w(0);
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nlil0i1024w1025w1026w1027w(0) <= wire_nliii_w_lg_w_lg_w_lg_nlil0i1024w1025w1026w(0) AND nliiOO;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nlli01i4246w4260w4262w4264w(0) <= wire_nliii_w_lg_w_lg_w_lg_nlli01i4246w4260w4262w(0) AND wire_nliii_w_lg_nlli1Oi4263w(0);
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nlli01i4246w4247w4248w4249w(0) <= wire_nliii_w_lg_w_lg_w_lg_nlli01i4246w4247w4248w(0) AND nlli1lO;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nlli11l4299w4300w4301w4302w(0) <= wire_nliii_w_lg_w_lg_w_lg_nlli11l4299w4300w4301w(0) AND nll0OOi;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nlllllO4323w4332w4334w4335w(0) <= wire_nliii_w_lg_w_lg_w_lg_nlllllO4323w4332w4334w(0) AND nlllliO;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nlllllO4323w4324w4355w4357w(0) <= wire_nliii_w_lg_w_lg_w_lg_nlllllO4323w4324w4355w(0) AND wire_nliii_w_lg_nlllliO4356w(0);
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nlllllO4323w4324w4325w4326w(0) <= wire_nliii_w_lg_w_lg_w_lg_nlllllO4323w4324w4325w(0) AND nlllliO;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO000l3762w3763w3764w3765w(0) <= wire_nliii_w_lg_w_lg_w_lg_nlO000l3762w3763w3764w(0) AND nlO001i;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO0i0i3709w3723w3725w3727w(0) <= wire_nliii_w_lg_w_lg_w_lg_nlO0i0i3709w3723w3725w(0) AND wire_nliii_w_lg_nlO0i1i3726w(0);
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO0i0i3709w3710w3711w3712w(0) <= wire_nliii_w_lg_w_lg_w_lg_nlO0i0i3709w3710w3711w(0) AND nlO00OO;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO1OO1101w1110w1112w1113w(0) <= wire_nliii_w_lg_w_lg_w_lg_nlO1OO1101w1110w1112w(0) AND nlO1lO;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO1OO1101w1102w1133w1135w(0) <= wire_nliii_w_lg_w_lg_w_lg_nlO1OO1101w1102w1133w(0) AND wire_nliii_w_lg_nlO1lO1134w(0);
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nlO1OO1101w1102w1103w1104w(0) <= wire_nliii_w_lg_w_lg_w_lg_nlO1OO1101w1102w1103w(0) AND nlO1lO;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nlOiOOO3786w3795w3797w3798w(0) <= wire_nliii_w_lg_w_lg_w_lg_nlOiOOO3786w3795w3797w(0) AND nlOiOlO;
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nlOiOOO3786w3787w3818w3820w(0) <= wire_nliii_w_lg_w_lg_w_lg_nlOiOOO3786w3787w3818w(0) AND wire_nliii_w_lg_nlOiOlO3819w(0);
	wire_nliii_w_lg_w_lg_w_lg_w_lg_nlOiOOO3786w3787w3788w3789w(0) <= wire_nliii_w_lg_w_lg_w_lg_nlOiOOO3786w3787w3788w(0) AND nlOiOlO;
	wire_nliii_w_lg_w_lg_w_lg_n00i0O2702w2703w2704w(0) <= wire_nliii_w_lg_w_lg_n00i0O2702w2703w(0) AND n00i1O;
	wire_nliii_w_lg_w_lg_w_lg_n00i0O2730w2731w2732w(0) <= wire_nliii_w_lg_w_lg_n00i0O2730w2731w(0) AND n00i1O;
	wire_nliii_w_lg_w_lg_w_lg_n0liO510w511w513w(0) <= wire_nliii_w_lg_w_lg_n0liO510w511w(0) AND wire_nliii_w_lg_n0l0O512w(0);
	wire_nliii_w_lg_w_lg_w_lg_n0lOlO2134w2135w2137w(0) <= wire_nliii_w_lg_w_lg_n0lOlO2134w2135w(0) AND wire_nliii_w_lg_n0lOiO2136w(0);
	wire_nliii_w_lg_w_lg_w_lg_n0O1ll2081w2082w2084w(0) <= wire_nliii_w_lg_w_lg_n0O1ll2081w2082w(0) AND wire_nliii_w_lg_n0O1il2083w(0);
	wire_nliii_w_lg_w_lg_w_lg_n0Oil456w457w459w(0) <= wire_nliii_w_lg_w_lg_n0Oil456w457w(0) AND wire_nliii_w_lg_n0O0l458w(0);
	wire_nliii_w_lg_w_lg_w_lg_n11i0O3210w3211w3213w(0) <= wire_nliii_w_lg_w_lg_n11i0O3210w3211w(0) AND wire_nliii_w_lg_n11i1O3212w(0);
	wire_nliii_w_lg_w_lg_w_lg_n11l0l3157w3158w3160w(0) <= wire_nliii_w_lg_w_lg_n11l0l3157w3158w(0) AND wire_nliii_w_lg_n11l1l3159w(0);
	wire_nliii_w_lg_w_lg_w_lg_n1i01O3240w3241w3242w(0) <= wire_nliii_w_lg_w_lg_n1i01O3240w3241w(0) AND n1i1OO;
	wire_nliii_w_lg_w_lg_w_lg_n1i01O3268w3269w3270w(0) <= wire_nliii_w_lg_w_lg_n1i01O3268w3269w(0) AND n1i1OO;
	wire_nliii_w_lg_w_lg_w_lg_n1OliO2672w2673w2675w(0) <= wire_nliii_w_lg_w_lg_n1OliO2672w2673w(0) AND wire_nliii_w_lg_n1Ol0O2674w(0);
	wire_nliii_w_lg_w_lg_w_lg_n1OOil2619w2620w2622w(0) <= wire_nliii_w_lg_w_lg_n1OOil2619w2620w(0) AND wire_nliii_w_lg_n1OO0l2621w(0);
	wire_nliii_w_lg_w_lg_w_lg_ni1liO2164w2165w2166w(0) <= wire_nliii_w_lg_w_lg_ni1liO2164w2165w(0) AND ni1l0O;
	wire_nliii_w_lg_w_lg_w_lg_ni1liO2192w2193w2194w(0) <= wire_nliii_w_lg_w_lg_ni1liO2192w2193w(0) AND ni1l0O;
	wire_nliii_w_lg_w_lg_w_lg_nil0Ol1545w1546w1548w(0) <= wire_nliii_w_lg_w_lg_nil0Ol1545w1546w(0) AND wire_nliii_w_lg_nil0ll1547w(0);
	wire_nliii_w_lg_w_lg_w_lg_nil1OO1598w1599w1601w(0) <= wire_nliii_w_lg_w_lg_nil1OO1598w1599w(0) AND wire_nliii_w_lg_nil1lO1600w(0);
	wire_nliii_w_lg_w_lg_w_lg_niOOlO1628w1629w1630w(0) <= wire_nliii_w_lg_w_lg_niOOlO1628w1629w(0) AND niOOiO;
	wire_nliii_w_lg_w_lg_w_lg_niOOlO1656w1657w1658w(0) <= wire_nliii_w_lg_w_lg_niOOlO1656w1657w(0) AND niOOiO;
	wire_nliii_w_lg_w_lg_w_lg_nlii1O1061w1062w1064w(0) <= wire_nliii_w_lg_w_lg_nlii1O1061w1062w(0) AND wire_nliii_w_lg_nli0OO1063w(0);
	wire_nliii_w_lg_w_lg_w_lg_nliil550w551w552w(0) <= wire_nliii_w_lg_w_lg_nliil550w551w(0) AND nli0i;
	wire_nliii_w_lg_w_lg_w_lg_nliil578w579w580w(0) <= wire_nliii_w_lg_w_lg_nliil578w579w(0) AND nli0i;
	wire_nliii_w_lg_w_lg_w_lg_nlil1l1008w1009w1011w(0) <= wire_nliii_w_lg_w_lg_nlil1l1008w1009w(0) AND wire_nliii_w_lg_nliiOl1010w(0);
	wire_nliii_w_lg_w_lg_w_lg_nll0OOO4283w4284w4286w(0) <= wire_nliii_w_lg_w_lg_nll0OOO4283w4284w(0) AND wire_nliii_w_lg_nll0OlO4285w(0);
	wire_nliii_w_lg_w_lg_w_lg_nlli1Ol4230w4231w4233w(0) <= wire_nliii_w_lg_w_lg_nlli1Ol4230w4231w(0) AND wire_nliii_w_lg_nlli1ll4232w(0);
	wire_nliii_w_lg_w_lg_w_lg_nlllllO4313w4314w4315w(0) <= wire_nliii_w_lg_w_lg_nlllllO4313w4314w(0) AND nlllliO;
	wire_nliii_w_lg_w_lg_w_lg_nlllllO4341w4342w4343w(0) <= wire_nliii_w_lg_w_lg_nlllllO4341w4342w(0) AND nlllliO;
	wire_nliii_w_lg_w_lg_w_lg_nlO001O3746w3747w3749w(0) <= wire_nliii_w_lg_w_lg_nlO001O3746w3747w(0) AND wire_nliii_w_lg_nlO01OO3748w(0);
	wire_nliii_w_lg_w_lg_w_lg_nlO0i1l3693w3694w3696w(0) <= wire_nliii_w_lg_w_lg_nlO0i1l3693w3694w(0) AND wire_nliii_w_lg_nlO00Ol3695w(0);
	wire_nliii_w_lg_w_lg_w_lg_nlO1OO1091w1092w1093w(0) <= wire_nliii_w_lg_w_lg_nlO1OO1091w1092w(0) AND nlO1lO;
	wire_nliii_w_lg_w_lg_w_lg_nlO1OO1119w1120w1121w(0) <= wire_nliii_w_lg_w_lg_nlO1OO1119w1120w(0) AND nlO1lO;
	wire_nliii_w_lg_w_lg_w_lg_nlOiOOO3776w3777w3778w(0) <= wire_nliii_w_lg_w_lg_nlOiOOO3776w3777w(0) AND nlOiOlO;
	wire_nliii_w_lg_w_lg_w_lg_nlOiOOO3804w3805w3806w(0) <= wire_nliii_w_lg_w_lg_nlOiOOO3804w3805w(0) AND nlOiOlO;
	wire_nliii_w_lg_w_lg_w_lg_n00i0O2712w2721w2723w(0) <= wire_nliii_w_lg_w_lg_n00i0O2712w2721w(0) AND wire_nliii_w_lg_n00i0i2722w(0);
	wire_nliii_w_lg_w_lg_w_lg_n00i0O2712w2713w2744w(0) <= wire_nliii_w_lg_w_lg_n00i0O2712w2713w(0) AND wire_nliii_w_lg_n00i0i2722w(0);
	wire_nliii_w_lg_w_lg_w_lg_n00i0O2712w2713w2714w(0) <= wire_nliii_w_lg_w_lg_n00i0O2712w2713w(0) AND n00i0i;
	wire_nliii_w_lg_w_lg_w_lg_n0lll526w527w528w(0) <= wire_nliii_w_lg_w_lg_n0lll526w527w(0) AND n0lil;
	wire_nliii_w_lg_w_lg_w_lg_n0lOOl2150w2151w2152w(0) <= wire_nliii_w_lg_w_lg_n0lOOl2150w2151w(0) AND n0lOll;
	wire_nliii_w_lg_w_lg_w_lg_n0O1Oi2097w2111w2113w(0) <= wire_nliii_w_lg_w_lg_n0O1Oi2097w2111w(0) AND wire_nliii_w_lg_n0O1ll2112w(0);
	wire_nliii_w_lg_w_lg_w_lg_n0O1Oi2097w2098w2099w(0) <= wire_nliii_w_lg_w_lg_n0O1Oi2097w2098w(0) AND n0O1li;
	wire_nliii_w_lg_w_lg_w_lg_n0Oli473w487w489w(0) <= wire_nliii_w_lg_w_lg_n0Oli473w487w(0) AND wire_nliii_w_lg_n0Oil488w(0);
	wire_nliii_w_lg_w_lg_w_lg_n0Oli473w474w475w(0) <= wire_nliii_w_lg_w_lg_n0Oli473w474w(0) AND n0Oii;
	wire_nliii_w_lg_w_lg_w_lg_n11iil3226w3227w3228w(0) <= wire_nliii_w_lg_w_lg_n11iil3226w3227w(0) AND n11i0l;
	wire_nliii_w_lg_w_lg_w_lg_n11lii3173w3187w3189w(0) <= wire_nliii_w_lg_w_lg_n11lii3173w3187w(0) AND wire_nliii_w_lg_n11l0l3188w(0);
	wire_nliii_w_lg_w_lg_w_lg_n11lii3173w3174w3175w(0) <= wire_nliii_w_lg_w_lg_n11lii3173w3174w(0) AND n11l0i;
	wire_nliii_w_lg_w_lg_w_lg_n1i01O3250w3259w3261w(0) <= wire_nliii_w_lg_w_lg_n1i01O3250w3259w(0) AND wire_nliii_w_lg_n1i01i3260w(0);
	wire_nliii_w_lg_w_lg_w_lg_n1i01O3250w3251w3282w(0) <= wire_nliii_w_lg_w_lg_n1i01O3250w3251w(0) AND wire_nliii_w_lg_n1i01i3260w(0);
	wire_nliii_w_lg_w_lg_w_lg_n1i01O3250w3251w3252w(0) <= wire_nliii_w_lg_w_lg_n1i01O3250w3251w(0) AND n1i01i;
	wire_nliii_w_lg_w_lg_w_lg_n1Olll2688w2689w2690w(0) <= wire_nliii_w_lg_w_lg_n1Olll2688w2689w(0) AND n1Olil;
	wire_nliii_w_lg_w_lg_w_lg_n1OOli2635w2649w2651w(0) <= wire_nliii_w_lg_w_lg_n1OOli2635w2649w(0) AND wire_nliii_w_lg_n1OOil2650w(0);
	wire_nliii_w_lg_w_lg_w_lg_n1OOli2635w2636w2637w(0) <= wire_nliii_w_lg_w_lg_n1OOli2635w2636w(0) AND n1OOii;
	wire_nliii_w_lg_w_lg_w_lg_ni1liO2174w2183w2185w(0) <= wire_nliii_w_lg_w_lg_ni1liO2174w2183w(0) AND wire_nliii_w_lg_ni1lii2184w(0);
	wire_nliii_w_lg_w_lg_w_lg_ni1liO2174w2175w2206w(0) <= wire_nliii_w_lg_w_lg_ni1liO2174w2175w(0) AND wire_nliii_w_lg_ni1lii2184w(0);
	wire_nliii_w_lg_w_lg_w_lg_ni1liO2174w2175w2176w(0) <= wire_nliii_w_lg_w_lg_ni1liO2174w2175w(0) AND ni1lii;
	wire_nliii_w_lg_w_lg_w_lg_nil01l1614w1615w1616w(0) <= wire_nliii_w_lg_w_lg_nil01l1614w1615w(0) AND nil1Ol;
	wire_nliii_w_lg_w_lg_w_lg_nili1i1561w1575w1577w(0) <= wire_nliii_w_lg_w_lg_nili1i1561w1575w(0) AND wire_nliii_w_lg_nil0Ol1576w(0);
	wire_nliii_w_lg_w_lg_w_lg_nili1i1561w1562w1563w(0) <= wire_nliii_w_lg_w_lg_nili1i1561w1562w(0) AND nil0Oi;
	wire_nliii_w_lg_w_lg_w_lg_niOOlO1638w1647w1649w(0) <= wire_nliii_w_lg_w_lg_niOOlO1638w1647w(0) AND wire_nliii_w_lg_niOOli1648w(0);
	wire_nliii_w_lg_w_lg_w_lg_niOOlO1638w1639w1670w(0) <= wire_nliii_w_lg_w_lg_niOOlO1638w1639w(0) AND wire_nliii_w_lg_niOOli1648w(0);
	wire_nliii_w_lg_w_lg_w_lg_niOOlO1638w1639w1640w(0) <= wire_nliii_w_lg_w_lg_niOOlO1638w1639w(0) AND niOOli;
	wire_nliii_w_lg_w_lg_w_lg_nlii0l1077w1078w1079w(0) <= wire_nliii_w_lg_w_lg_nlii0l1077w1078w(0) AND nlii1l;
	wire_nliii_w_lg_w_lg_w_lg_nliil560w569w571w(0) <= wire_nliii_w_lg_w_lg_nliil560w569w(0) AND wire_nliii_w_lg_nli0l570w(0);
	wire_nliii_w_lg_w_lg_w_lg_nliil560w561w592w(0) <= wire_nliii_w_lg_w_lg_nliil560w561w(0) AND wire_nliii_w_lg_nli0l570w(0);
	wire_nliii_w_lg_w_lg_w_lg_nliil560w561w562w(0) <= wire_nliii_w_lg_w_lg_nliil560w561w(0) AND nli0l;
	wire_nliii_w_lg_w_lg_w_lg_nlil0i1024w1038w1040w(0) <= wire_nliii_w_lg_w_lg_nlil0i1024w1038w(0) AND wire_nliii_w_lg_nlil1l1039w(0);
	wire_nliii_w_lg_w_lg_w_lg_nlil0i1024w1025w1026w(0) <= wire_nliii_w_lg_w_lg_nlil0i1024w1025w(0) AND nlil1i;
	wire_nliii_w_lg_w_lg_w_lg_nlli01i4246w4260w4262w(0) <= wire_nliii_w_lg_w_lg_nlli01i4246w4260w(0) AND wire_nliii_w_lg_nlli1Ol4261w(0);
	wire_nliii_w_lg_w_lg_w_lg_nlli01i4246w4247w4248w(0) <= wire_nliii_w_lg_w_lg_nlli01i4246w4247w(0) AND nlli1Oi;
	wire_nliii_w_lg_w_lg_w_lg_nlli11l4299w4300w4301w(0) <= wire_nliii_w_lg_w_lg_nlli11l4299w4300w(0) AND nll0OOl;
	wire_nliii_w_lg_w_lg_w_lg_nlllllO4323w4332w4334w(0) <= wire_nliii_w_lg_w_lg_nlllllO4323w4332w(0) AND wire_nliii_w_lg_nllllli4333w(0);
	wire_nliii_w_lg_w_lg_w_lg_nlllllO4323w4324w4355w(0) <= wire_nliii_w_lg_w_lg_nlllllO4323w4324w(0) AND wire_nliii_w_lg_nllllli4333w(0);
	wire_nliii_w_lg_w_lg_w_lg_nlllllO4323w4324w4325w(0) <= wire_nliii_w_lg_w_lg_nlllllO4323w4324w(0) AND nllllli;
	wire_nliii_w_lg_w_lg_w_lg_nlO000l3762w3763w3764w(0) <= wire_nliii_w_lg_w_lg_nlO000l3762w3763w(0) AND nlO001l;
	wire_nliii_w_lg_w_lg_w_lg_nlO0i0i3709w3723w3725w(0) <= wire_nliii_w_lg_w_lg_nlO0i0i3709w3723w(0) AND wire_nliii_w_lg_nlO0i1l3724w(0);
	wire_nliii_w_lg_w_lg_w_lg_nlO0i0i3709w3710w3711w(0) <= wire_nliii_w_lg_w_lg_nlO0i0i3709w3710w(0) AND nlO0i1i;
	wire_nliii_w_lg_w_lg_w_lg_nlO1OO1101w1110w1112w(0) <= wire_nliii_w_lg_w_lg_nlO1OO1101w1110w(0) AND wire_nliii_w_lg_nlO1Oi1111w(0);
	wire_nliii_w_lg_w_lg_w_lg_nlO1OO1101w1102w1133w(0) <= wire_nliii_w_lg_w_lg_nlO1OO1101w1102w(0) AND wire_nliii_w_lg_nlO1Oi1111w(0);
	wire_nliii_w_lg_w_lg_w_lg_nlO1OO1101w1102w1103w(0) <= wire_nliii_w_lg_w_lg_nlO1OO1101w1102w(0) AND nlO1Oi;
	wire_nliii_w_lg_w_lg_w_lg_nlOiOOO3786w3795w3797w(0) <= wire_nliii_w_lg_w_lg_nlOiOOO3786w3795w(0) AND wire_nliii_w_lg_nlOiOOi3796w(0);
	wire_nliii_w_lg_w_lg_w_lg_nlOiOOO3786w3787w3818w(0) <= wire_nliii_w_lg_w_lg_nlOiOOO3786w3787w(0) AND wire_nliii_w_lg_nlOiOOi3796w(0);
	wire_nliii_w_lg_w_lg_w_lg_nlOiOOO3786w3787w3788w(0) <= wire_nliii_w_lg_w_lg_nlOiOOO3786w3787w(0) AND nlOiOOi;
	wire_nliii_w_lg_w_lg_n00i0O2702w2703w(0) <= wire_nliii_w_lg_n00i0O2702w(0) AND n00i0i;
	wire_nliii_w_lg_w_lg_n00i0O2730w2731w(0) <= wire_nliii_w_lg_n00i0O2730w(0) AND n00i0i;
	wire_nliii_w_lg_w_lg_n0iiOl2055w2056w(0) <= wire_nliii_w_lg_n0iiOl2055w(0) AND n0iiOi;
	wire_nliii_w_lg_w_lg_n0liO510w511w(0) <= wire_nliii_w_lg_n0liO510w(0) AND n0lii;
	wire_nliii_w_lg_w_lg_n0lOlO2134w2135w(0) <= wire_nliii_w_lg_n0lOlO2134w(0) AND n0lOli;
	wire_nliii_w_lg_w_lg_n0O1ll2081w2082w(0) <= wire_nliii_w_lg_n0O1ll2081w(0) AND n0O1iO;
	wire_nliii_w_lg_w_lg_n0Oil456w457w(0) <= wire_nliii_w_lg_n0Oil456w(0) AND n0O0O;
	wire_nliii_w_lg_w_lg_n10ll430w431w(0) <= wire_nliii_w_lg_n10ll430w(0) AND n10li;
	wire_nliii_w_lg_w_lg_n11i0O3210w3211w(0) <= wire_nliii_w_lg_n11i0O3210w(0) AND n11i0i;
	wire_nliii_w_lg_w_lg_n11l0l3157w3158w(0) <= wire_nliii_w_lg_n11l0l3157w(0) AND n11l1O;
	wire_nliii_w_lg_w_lg_n1i01O3240w3241w(0) <= wire_nliii_w_lg_n1i01O3240w(0) AND n1i01i;
	wire_nliii_w_lg_w_lg_n1i01O3268w3269w(0) <= wire_nliii_w_lg_n1i01O3268w(0) AND n1i01i;
	wire_nliii_w_lg_w_lg_n1l0ll2593w2594w(0) <= wire_nliii_w_lg_n1l0ll2593w(0) AND n1l0li;
	wire_nliii_w_lg_w_lg_n1OliO2672w2673w(0) <= wire_nliii_w_lg_n1OliO2672w(0) AND n1Olii;
	wire_nliii_w_lg_w_lg_n1OOil2619w2620w(0) <= wire_nliii_w_lg_n1OOil2619w(0) AND n1OO0O;
	wire_nliii_w_lg_w_lg_ni0O1l1519w1520w(0) <= wire_nliii_w_lg_ni0O1l1519w(0) AND ni0O1i;
	wire_nliii_w_lg_w_lg_ni1liO2164w2165w(0) <= wire_nliii_w_lg_ni1liO2164w(0) AND ni1lii;
	wire_nliii_w_lg_w_lg_ni1liO2192w2193w(0) <= wire_nliii_w_lg_ni1liO2192w(0) AND ni1lii;
	wire_nliii_w_lg_w_lg_nil0Ol1545w1546w(0) <= wire_nliii_w_lg_nil0Ol1545w(0) AND nil0lO;
	wire_nliii_w_lg_w_lg_nil1OO1598w1599w(0) <= wire_nliii_w_lg_nil1OO1598w(0) AND nil1Oi;
	wire_nliii_w_lg_w_lg_niOOlO1628w1629w(0) <= wire_nliii_w_lg_niOOlO1628w(0) AND niOOli;
	wire_nliii_w_lg_w_lg_niOOlO1656w1657w(0) <= wire_nliii_w_lg_niOOlO1656w(0) AND niOOli;
	wire_nliii_w_lg_w_lg_nl010l982w983w(0) <= wire_nliii_w_lg_nl010l982w(0) AND nl010i;
	wire_nliii_w_lg_w_lg_nlii1O1061w1062w(0) <= wire_nliii_w_lg_nlii1O1061w(0) AND nlii1i;
	wire_nliii_w_lg_w_lg_nliil550w551w(0) <= wire_nliii_w_lg_nliil550w(0) AND nli0l;
	wire_nliii_w_lg_w_lg_nliil578w579w(0) <= wire_nliii_w_lg_nliil578w(0) AND nli0l;
	wire_nliii_w_lg_w_lg_nlil1l1008w1009w(0) <= wire_nliii_w_lg_nlil1l1008w(0) AND nliiOO;
	wire_nliii_w_lg_w_lg_nll0OOO4283w4284w(0) <= wire_nliii_w_lg_nll0OOO4283w(0) AND nll0OOi;
	wire_nliii_w_lg_w_lg_nll1l1l4204w4205w(0) <= wire_nliii_w_lg_nll1l1l4204w(0) AND nll1l1i;
	wire_nliii_w_lg_w_lg_nlli1Ol4230w4231w(0) <= wire_nliii_w_lg_nlli1Ol4230w(0) AND nlli1lO;
	wire_nliii_w_lg_w_lg_nlllllO4313w4314w(0) <= wire_nliii_w_lg_nlllllO4313w(0) AND nllllli;
	wire_nliii_w_lg_w_lg_nlllllO4341w4342w(0) <= wire_nliii_w_lg_nlllllO4341w(0) AND nllllli;
	wire_nliii_w_lg_w_lg_nllOO0l3667w3668w(0) <= wire_nliii_w_lg_nllOO0l3667w(0) AND nllOO0i;
	wire_nliii_w_lg_w_lg_nlO001O3746w3747w(0) <= wire_nliii_w_lg_nlO001O3746w(0) AND nlO001i;
	wire_nliii_w_lg_w_lg_nlO0i1l3693w3694w(0) <= wire_nliii_w_lg_nlO0i1l3693w(0) AND nlO00OO;
	wire_nliii_w_lg_w_lg_nlO1OO1091w1092w(0) <= wire_nliii_w_lg_nlO1OO1091w(0) AND nlO1Oi;
	wire_nliii_w_lg_w_lg_nlO1OO1119w1120w(0) <= wire_nliii_w_lg_nlO1OO1119w(0) AND nlO1Oi;
	wire_nliii_w_lg_w_lg_nlOiOOO3776w3777w(0) <= wire_nliii_w_lg_nlOiOOO3776w(0) AND nlOiOOi;
	wire_nliii_w_lg_w_lg_nlOiOOO3804w3805w(0) <= wire_nliii_w_lg_nlOiOOO3804w(0) AND nlOiOOi;
	wire_nliii_w_lg_w_lg_nlOO1il3131w3132w(0) <= wire_nliii_w_lg_nlOO1il3131w(0) AND nlOO1ii;
	wire_nliii_w_lg_w_lg_n00i0O2712w2721w(0) <= wire_nliii_w_lg_n00i0O2712w(0) AND wire_nliii_w_lg_n00i0l2701w(0);
	wire_nliii_w_lg_w_lg_n00i0O2712w2713w(0) <= wire_nliii_w_lg_n00i0O2712w(0) AND n00i0l;
	wire_nliii_w_lg_w_lg_n0lll526w527w(0) <= wire_nliii_w_lg_n0lll526w(0) AND n0liO;
	wire_nliii_w_lg_w_lg_n0lOOl2150w2151w(0) <= wire_nliii_w_lg_n0lOOl2150w(0) AND n0lOlO;
	wire_nliii_w_lg_w_lg_n0O1Oi2097w2111w(0) <= wire_nliii_w_lg_n0O1Oi2097w(0) AND wire_nliii_w_lg_n0O1lO2110w(0);
	wire_nliii_w_lg_w_lg_n0O1Oi2097w2098w(0) <= wire_nliii_w_lg_n0O1Oi2097w(0) AND n0O1ll;
	wire_nliii_w_lg_w_lg_n0Oli473w487w(0) <= wire_nliii_w_lg_n0Oli473w(0) AND wire_nliii_w_lg_n0OiO486w(0);
	wire_nliii_w_lg_w_lg_n0Oli473w474w(0) <= wire_nliii_w_lg_n0Oli473w(0) AND n0Oil;
	wire_nliii_w_lg_w_lg_n11iil3226w3227w(0) <= wire_nliii_w_lg_n11iil3226w(0) AND n11i0O;
	wire_nliii_w_lg_w_lg_n11lii3173w3187w(0) <= wire_nliii_w_lg_n11lii3173w(0) AND wire_nliii_w_lg_n11l0O3186w(0);
	wire_nliii_w_lg_w_lg_n11lii3173w3174w(0) <= wire_nliii_w_lg_n11lii3173w(0) AND n11l0l;
	wire_nliii_w_lg_w_lg_n1i01O3250w3259w(0) <= wire_nliii_w_lg_n1i01O3250w(0) AND wire_nliii_w_lg_n1i01l3239w(0);
	wire_nliii_w_lg_w_lg_n1i01O3250w3251w(0) <= wire_nliii_w_lg_n1i01O3250w(0) AND n1i01l;
	wire_nliii_w_lg_w_lg_n1Olll2688w2689w(0) <= wire_nliii_w_lg_n1Olll2688w(0) AND n1OliO;
	wire_nliii_w_lg_w_lg_n1OOli2635w2649w(0) <= wire_nliii_w_lg_n1OOli2635w(0) AND wire_nliii_w_lg_n1OOiO2648w(0);
	wire_nliii_w_lg_w_lg_n1OOli2635w2636w(0) <= wire_nliii_w_lg_n1OOli2635w(0) AND n1OOil;
	wire_nliii_w_lg_w_lg_ni1liO2174w2183w(0) <= wire_nliii_w_lg_ni1liO2174w(0) AND wire_nliii_w_lg_ni1lil2163w(0);
	wire_nliii_w_lg_w_lg_ni1liO2174w2175w(0) <= wire_nliii_w_lg_ni1liO2174w(0) AND ni1lil;
	wire_nliii_w_lg_w_lg_nil01l1614w1615w(0) <= wire_nliii_w_lg_nil01l1614w(0) AND nil1OO;
	wire_nliii_w_lg_w_lg_nili1i1561w1575w(0) <= wire_nliii_w_lg_nili1i1561w(0) AND wire_nliii_w_lg_nil0OO1574w(0);
	wire_nliii_w_lg_w_lg_nili1i1561w1562w(0) <= wire_nliii_w_lg_nili1i1561w(0) AND nil0Ol;
	wire_nliii_w_lg_w_lg_niOOlO1638w1647w(0) <= wire_nliii_w_lg_niOOlO1638w(0) AND wire_nliii_w_lg_niOOll1627w(0);
	wire_nliii_w_lg_w_lg_niOOlO1638w1639w(0) <= wire_nliii_w_lg_niOOlO1638w(0) AND niOOll;
	wire_nliii_w_lg_w_lg_nl0Ol282w283w(0) <= wire_nliii_w_lg_nl0Ol282w(0) AND nl0Oi;
	wire_nliii_w_lg_w_lg_nlii0l1077w1078w(0) <= wire_nliii_w_lg_nlii0l1077w(0) AND nlii1O;
	wire_nliii_w_lg_w_lg_nliil560w569w(0) <= wire_nliii_w_lg_nliil560w(0) AND wire_nliii_w_lg_nli0O549w(0);
	wire_nliii_w_lg_w_lg_nliil560w561w(0) <= wire_nliii_w_lg_nliil560w(0) AND nli0O;
	wire_nliii_w_lg_w_lg_nlil0i1024w1038w(0) <= wire_nliii_w_lg_nlil0i1024w(0) AND wire_nliii_w_lg_nlil1O1037w(0);
	wire_nliii_w_lg_w_lg_nlil0i1024w1025w(0) <= wire_nliii_w_lg_nlil0i1024w(0) AND nlil1l;
	wire_nliii_w_lg_w_lg_nlli01i4246w4260w(0) <= wire_nliii_w_lg_nlli01i4246w(0) AND wire_nliii_w_lg_nlli1OO4259w(0);
	wire_nliii_w_lg_w_lg_nlli01i4246w4247w(0) <= wire_nliii_w_lg_nlli01i4246w(0) AND nlli1Ol;
	wire_nliii_w_lg_w_lg_nlli11l4299w4300w(0) <= wire_nliii_w_lg_nlli11l4299w(0) AND nll0OOO;
	wire_nliii_w_lg_w_lg_nlllllO4323w4332w(0) <= wire_nliii_w_lg_nlllllO4323w(0) AND wire_nliii_w_lg_nllllll4312w(0);
	wire_nliii_w_lg_w_lg_nlllllO4323w4324w(0) <= wire_nliii_w_lg_nlllllO4323w(0) AND nllllll;
	wire_nliii_w_lg_w_lg_nlO000l3762w3763w(0) <= wire_nliii_w_lg_nlO000l3762w(0) AND nlO001O;
	wire_nliii_w_lg_w_lg_nlO0i0i3709w3723w(0) <= wire_nliii_w_lg_nlO0i0i3709w(0) AND wire_nliii_w_lg_nlO0i1O3722w(0);
	wire_nliii_w_lg_w_lg_nlO0i0i3709w3710w(0) <= wire_nliii_w_lg_nlO0i0i3709w(0) AND nlO0i1l;
	wire_nliii_w_lg_w_lg_nlO1OO1101w1110w(0) <= wire_nliii_w_lg_nlO1OO1101w(0) AND wire_nliii_w_lg_nlO1Ol1090w(0);
	wire_nliii_w_lg_w_lg_nlO1OO1101w1102w(0) <= wire_nliii_w_lg_nlO1OO1101w(0) AND nlO1Ol;
	wire_nliii_w_lg_w_lg_nlOiOOO3786w3795w(0) <= wire_nliii_w_lg_nlOiOOO3786w(0) AND wire_nliii_w_lg_nlOiOOl3775w(0);
	wire_nliii_w_lg_w_lg_nlOiOOO3786w3787w(0) <= wire_nliii_w_lg_nlOiOOO3786w(0) AND nlOiOOl;
	wire_nliii_w_lg_n00i0O2702w(0) <= n00i0O AND wire_nliii_w_lg_n00i0l2701w(0);
	wire_nliii_w_lg_n00i0O2730w(0) <= n00i0O AND n00i0l;
	wire_nliii_w_lg_n0iiOl2055w(0) <= n0iiOl AND wire_nliii_w_lg_n0iilO2054w(0);
	wire_nliii_w_lg_n0liO510w(0) <= n0liO AND n0lil;
	wire_nliii_w_lg_n0lOlO2134w(0) <= n0lOlO AND n0lOll;
	wire_nliii_w_lg_n0O1ll2081w(0) <= n0O1ll AND n0O1li;
	wire_nliii_w_lg_n0Oil456w(0) <= n0Oil AND n0Oii;
	wire_nliii_w_lg_n10ll430w(0) <= n10ll AND wire_nliii_w_lg_n10iO429w(0);
	wire_nliii_w_lg_n11i0O3210w(0) <= n11i0O AND n11i0l;
	wire_nliii_w_lg_n11l0l3157w(0) <= n11l0l AND n11l0i;
	wire_nliii_w_lg_n1i01O3240w(0) <= n1i01O AND wire_nliii_w_lg_n1i01l3239w(0);
	wire_nliii_w_lg_n1i01O3268w(0) <= n1i01O AND n1i01l;
	wire_nliii_w_lg_n1l0ll2593w(0) <= n1l0ll AND wire_nliii_w_lg_n1l0iO2592w(0);
	wire_nliii_w_lg_n1OliO2672w(0) <= n1OliO AND n1Olil;
	wire_nliii_w_lg_n1OOil2619w(0) <= n1OOil AND n1OOii;
	wire_nliii_w_lg_ni0O1l1519w(0) <= ni0O1l AND wire_nliii_w_lg_ni0lOO1518w(0);
	wire_nliii_w_lg_ni1liO2164w(0) <= ni1liO AND wire_nliii_w_lg_ni1lil2163w(0);
	wire_nliii_w_lg_ni1liO2192w(0) <= ni1liO AND ni1lil;
	wire_nliii_w_lg_nil0Ol1545w(0) <= nil0Ol AND nil0Oi;
	wire_nliii_w_lg_nil1OO1598w(0) <= nil1OO AND nil1Ol;
	wire_nliii_w_lg_niOOlO1628w(0) <= niOOlO AND wire_nliii_w_lg_niOOll1627w(0);
	wire_nliii_w_lg_niOOlO1656w(0) <= niOOlO AND niOOll;
	wire_nliii_w_lg_nl010l982w(0) <= nl010l AND wire_nliii_w_lg_nl011O981w(0);
	wire_nliii_w_lg_nl0Oi294w(0) <= nl0Oi AND wire_w_lg_nlilO1l293w(0);
	wire_nliii_w_lg_nlii1O1061w(0) <= nlii1O AND nlii1l;
	wire_nliii_w_lg_nliil550w(0) <= nliil AND wire_nliii_w_lg_nli0O549w(0);
	wire_nliii_w_lg_nliil578w(0) <= nliil AND nli0O;
	wire_nliii_w_lg_nlil1l1008w(0) <= nlil1l AND nlil1i;
	wire_nliii_w_lg_nll0OOO4283w(0) <= nll0OOO AND nll0OOl;
	wire_nliii_w_lg_nll1l1l4204w(0) <= nll1l1l AND wire_nliii_w_lg_nll1iOO4203w(0);
	wire_nliii_w_lg_nlli1Ol4230w(0) <= nlli1Ol AND nlli1Oi;
	wire_nliii_w_lg_nlllllO4313w(0) <= nlllllO AND wire_nliii_w_lg_nllllll4312w(0);
	wire_nliii_w_lg_nlllllO4341w(0) <= nlllllO AND nllllll;
	wire_nliii_w_lg_nllOO0l3667w(0) <= nllOO0l AND wire_nliii_w_lg_nllOO1O3666w(0);
	wire_nliii_w_lg_nlO001O3746w(0) <= nlO001O AND nlO001l;
	wire_nliii_w_lg_nlO0i1l3693w(0) <= nlO0i1l AND nlO0i1i;
	wire_nliii_w_lg_nlO1OO1091w(0) <= nlO1OO AND wire_nliii_w_lg_nlO1Ol1090w(0);
	wire_nliii_w_lg_nlO1OO1119w(0) <= nlO1OO AND nlO1Ol;
	wire_nliii_w_lg_nlOiOOO3776w(0) <= nlOiOOO AND wire_nliii_w_lg_nlOiOOl3775w(0);
	wire_nliii_w_lg_nlOiOOO3804w(0) <= nlOiOOO AND nlOiOOl;
	wire_nliii_w_lg_nlOO1il3131w(0) <= nlOO1il AND wire_nliii_w_lg_nlOO10O3130w(0);
	wire_nliii_w_lg_n000ll2557w(0) <= NOT n000ll;
	wire_nliii_w_lg_n000Oi2453w(0) <= NOT n000Oi;
	wire_nliii_w_lg_n000Ol2709w(0) <= NOT n000Ol;
	wire_nliii_w_lg_n000OO2707w(0) <= NOT n000OO;
	wire_nliii_w_lg_n00i0i2722w(0) <= NOT n00i0i;
	wire_nliii_w_lg_n00i0l2701w(0) <= NOT n00i0l;
	wire_nliii_w_lg_n00i0O2712w(0) <= NOT n00i0O;
	wire_nliii_w_lg_n00i1i2748w(0) <= NOT n00i1i;
	wire_nliii_w_lg_n00i1l2733w(0) <= NOT n00i1l;
	wire_nliii_w_lg_n00i1O2745w(0) <= NOT n00i1O;
	wire_nliii_w_lg_n00ili2237w(0) <= NOT n00ili;
	wire_nliii_w_lg_n0iilO2054w(0) <= NOT n0iilO;
	wire_nliii_w_lg_n0iiOi2059w(0) <= NOT n0iiOi;
	wire_nliii_w_lg_n0iO0l2011w(0) <= NOT n0iO0l;
	wire_nliii_w_lg_n0l0O512w(0) <= NOT n0l0O;
	wire_nliii_w_lg_n0l1O515w(0) <= NOT n0l1O;
	wire_nliii_w_lg_n0lll526w(0) <= NOT n0lll;
	wire_nliii_w_lg_n0lO0O2139w(0) <= NOT n0lO0O;
	wire_nliii_w_lg_n0lOiO2136w(0) <= NOT n0lOiO;
	wire_nliii_w_lg_n0lOOl2150w(0) <= NOT n0lOOl;
	wire_nliii_w_lg_n0O0i495w(0) <= NOT n0O0i;
	wire_nliii_w_lg_n0O0l458w(0) <= NOT n0O0l;
	wire_nliii_w_lg_n0O0O492w(0) <= NOT n0O0O;
	wire_nliii_w_lg_n0O10l2086w(0) <= NOT n0O10l;
	wire_nliii_w_lg_n0O10O2121w(0) <= NOT n0O10O;
	wire_nliii_w_lg_n0O1ii2119w(0) <= NOT n0O1ii;
	wire_nliii_w_lg_n0O1il2083w(0) <= NOT n0O1il;
	wire_nliii_w_lg_n0O1iO2116w(0) <= NOT n0O1iO;
	wire_nliii_w_lg_n0O1l461w(0) <= NOT n0O1l;
	wire_nliii_w_lg_n0O1li2114w(0) <= NOT n0O1li;
	wire_nliii_w_lg_n0O1ll2112w(0) <= NOT n0O1ll;
	wire_nliii_w_lg_n0O1lO2110w(0) <= NOT n0O1lO;
	wire_nliii_w_lg_n0O1O497w(0) <= NOT n0O1O;
	wire_nliii_w_lg_n0O1Oi2097w(0) <= NOT n0O1Oi;
	wire_nliii_w_lg_n0Oii490w(0) <= NOT n0Oii;
	wire_nliii_w_lg_n0Oil488w(0) <= NOT n0Oil;
	wire_nliii_w_lg_n0OiO486w(0) <= NOT n0OiO;
	wire_nliii_w_lg_n0Oli473w(0) <= NOT n0Oli;
	wire_nliii_w_lg_n10iO429w(0) <= NOT n10iO;
	wire_nliii_w_lg_n10li434w(0) <= NOT n10li;
	wire_nliii_w_lg_n110OO3215w(0) <= NOT n110OO;
	wire_nliii_w_lg_n11i1O3212w(0) <= NOT n11i1O;
	wire_nliii_w_lg_n11iil3226w(0) <= NOT n11iil;
	wire_nliii_w_lg_n11iOl3162w(0) <= NOT n11iOl;
	wire_nliii_w_lg_n11iOO3197w(0) <= NOT n11iOO;
	wire_nliii_w_lg_n11l0i3190w(0) <= NOT n11l0i;
	wire_nliii_w_lg_n11l0l3188w(0) <= NOT n11l0l;
	wire_nliii_w_lg_n11l0O3186w(0) <= NOT n11l0O;
	wire_nliii_w_lg_n11l1i3195w(0) <= NOT n11l1i;
	wire_nliii_w_lg_n11l1l3159w(0) <= NOT n11l1l;
	wire_nliii_w_lg_n11l1O3192w(0) <= NOT n11l1O;
	wire_nliii_w_lg_n11lii3173w(0) <= NOT n11lii;
	wire_nliii_w_lg_n1i01i3260w(0) <= NOT n1i01i;
	wire_nliii_w_lg_n1i01l3239w(0) <= NOT n1i01l;
	wire_nliii_w_lg_n1i01O3250w(0) <= NOT n1i01O;
	wire_nliii_w_lg_n1i0ii2775w(0) <= NOT n1i0ii;
	wire_nliii_w_lg_n1i1il3095w(0) <= NOT n1i1il;
	wire_nliii_w_lg_n1i1li2991w(0) <= NOT n1i1li;
	wire_nliii_w_lg_n1i1ll3247w(0) <= NOT n1i1ll;
	wire_nliii_w_lg_n1i1lO3245w(0) <= NOT n1i1lO;
	wire_nliii_w_lg_n1i1Oi3286w(0) <= NOT n1i1Oi;
	wire_nliii_w_lg_n1i1Ol3271w(0) <= NOT n1i1Ol;
	wire_nliii_w_lg_n1i1OO3283w(0) <= NOT n1i1OO;
	wire_nliii_w_lg_n1l0iO2592w(0) <= NOT n1l0iO;
	wire_nliii_w_lg_n1l0li2597w(0) <= NOT n1l0li;
	wire_nliii_w_lg_n1l1l386w(0) <= NOT n1l1l;
	wire_nliii_w_lg_n1ll1l2549w(0) <= NOT n1ll1l;
	wire_nliii_w_lg_n1Ol0O2674w(0) <= NOT n1Ol0O;
	wire_nliii_w_lg_n1Ol1O2677w(0) <= NOT n1Ol1O;
	wire_nliii_w_lg_n1Olll2688w(0) <= NOT n1Olll;
	wire_nliii_w_lg_n1OO0i2657w(0) <= NOT n1OO0i;
	wire_nliii_w_lg_n1OO0l2621w(0) <= NOT n1OO0l;
	wire_nliii_w_lg_n1OO0O2654w(0) <= NOT n1OO0O;
	wire_nliii_w_lg_n1OO1l2624w(0) <= NOT n1OO1l;
	wire_nliii_w_lg_n1OO1O2659w(0) <= NOT n1OO1O;
	wire_nliii_w_lg_n1OOii2652w(0) <= NOT n1OOii;
	wire_nliii_w_lg_n1OOil2650w(0) <= NOT n1OOil;
	wire_nliii_w_lg_n1OOiO2648w(0) <= NOT n1OOiO;
	wire_nliii_w_lg_n1OOli2635w(0) <= NOT n1OOli;
	wire_nliii_w_lg_ni0lOO1518w(0) <= NOT ni0lOO;
	wire_nliii_w_lg_ni0O1i1523w(0) <= NOT ni0O1i;
	wire_nliii_w_lg_ni1iOl2019w(0) <= NOT ni1iOl;
	wire_nliii_w_lg_ni1l0i2210w(0) <= NOT ni1l0i;
	wire_nliii_w_lg_ni1l0l2195w(0) <= NOT ni1l0l;
	wire_nliii_w_lg_ni1l0O2207w(0) <= NOT ni1l0O;
	wire_nliii_w_lg_ni1l1i1917w(0) <= NOT ni1l1i;
	wire_nliii_w_lg_ni1l1l2171w(0) <= NOT ni1l1l;
	wire_nliii_w_lg_ni1l1O2169w(0) <= NOT ni1l1O;
	wire_nliii_w_lg_ni1lii2184w(0) <= NOT ni1lii;
	wire_nliii_w_lg_ni1lil2163w(0) <= NOT ni1lil;
	wire_nliii_w_lg_ni1liO2174w(0) <= NOT ni1liO;
	wire_nliii_w_lg_ni1lOi1701w(0) <= NOT ni1lOi;
	wire_nliii_w_lg_nii1il1475w(0) <= NOT nii1il;
	wire_nliii_w_lg_nil01l1614w(0) <= NOT nil01l;
	wire_nliii_w_lg_nil0il1550w(0) <= NOT nil0il;
	wire_nliii_w_lg_nil0iO1585w(0) <= NOT nil0iO;
	wire_nliii_w_lg_nil0li1583w(0) <= NOT nil0li;
	wire_nliii_w_lg_nil0ll1547w(0) <= NOT nil0ll;
	wire_nliii_w_lg_nil0lO1580w(0) <= NOT nil0lO;
	wire_nliii_w_lg_nil0Oi1578w(0) <= NOT nil0Oi;
	wire_nliii_w_lg_nil0Ol1576w(0) <= NOT nil0Ol;
	wire_nliii_w_lg_nil0OO1574w(0) <= NOT nil0OO;
	wire_nliii_w_lg_nil1iO1603w(0) <= NOT nil1iO;
	wire_nliii_w_lg_nil1lO1600w(0) <= NOT nil1lO;
	wire_nliii_w_lg_nili1i1561w(0) <= NOT nili1i;
	wire_nliii_w_lg_niOO0i1380w(0) <= NOT niOO0i;
	wire_nliii_w_lg_niOO0l1635w(0) <= NOT niOO0l;
	wire_nliii_w_lg_niOO0O1633w(0) <= NOT niOO0O;
	wire_nliii_w_lg_niOO1l1483w(0) <= NOT niOO1l;
	wire_nliii_w_lg_niOOii1674w(0) <= NOT niOOii;
	wire_nliii_w_lg_niOOil1659w(0) <= NOT niOOil;
	wire_nliii_w_lg_niOOiO1671w(0) <= NOT niOOiO;
	wire_nliii_w_lg_niOOli1648w(0) <= NOT niOOli;
	wire_nliii_w_lg_niOOll1627w(0) <= NOT niOOll;
	wire_nliii_w_lg_niOOlO1638w(0) <= NOT niOOlO;
	wire_nliii_w_lg_nl00ll938w(0) <= NOT nl00ll;
	wire_nliii_w_lg_nl010i986w(0) <= NOT nl010i;
	wire_nliii_w_lg_nl011O981w(0) <= NOT nl011O;
	wire_nliii_w_lg_nl0lO394w(0) <= NOT nl0lO;
	wire_nliii_w_lg_nl0Ol282w(0) <= NOT nl0Ol;
	wire_nliii_w_lg_nl0OO557w(0) <= NOT nl0OO;
	wire_nliii_w_lg_nl111i1164w(0) <= NOT nl111i;
	wire_nliii_w_lg_nli0i593w(0) <= NOT nli0i;
	wire_nliii_w_lg_nli0l570w(0) <= NOT nli0l;
	wire_nliii_w_lg_nli0lO1066w(0) <= NOT nli0lO;
	wire_nliii_w_lg_nli0O549w(0) <= NOT nli0O;
	wire_nliii_w_lg_nli0OO1063w(0) <= NOT nli0OO;
	wire_nliii_w_lg_nli1i555w(0) <= NOT nli1i;
	wire_nliii_w_lg_nli1l596w(0) <= NOT nli1l;
	wire_nliii_w_lg_nli1O581w(0) <= NOT nli1O;
	wire_nliii_w_lg_nlii0l1077w(0) <= NOT nlii0l;
	wire_nliii_w_lg_nliil560w(0) <= NOT nliil;
	wire_nliii_w_lg_nliill1013w(0) <= NOT nliill;
	wire_nliii_w_lg_nliilO1048w(0) <= NOT nliilO;
	wire_nliii_w_lg_nliiOi1046w(0) <= NOT nliiOi;
	wire_nliii_w_lg_nliiOl1010w(0) <= NOT nliiOl;
	wire_nliii_w_lg_nliiOO1043w(0) <= NOT nliiOO;
	wire_nliii_w_lg_nlil0i1024w(0) <= NOT nlil0i;
	wire_nliii_w_lg_nlil1i1041w(0) <= NOT nlil1i;
	wire_nliii_w_lg_nlil1l1039w(0) <= NOT nlil1l;
	wire_nliii_w_lg_nlil1O1037w(0) <= NOT nlil1O;
	wire_nliii_w_lg_nliOiOi4386w(0) <= NOT nliOiOi;
	wire_nliii_w_lg_nll0OiO4288w(0) <= NOT nll0OiO;
	wire_nliii_w_lg_nll0OlO4285w(0) <= NOT nll0OlO;
	wire_nliii_w_lg_nll1iOO4203w(0) <= NOT nll1iOO;
	wire_nliii_w_lg_nll1l1i4208w(0) <= NOT nll1l1i;
	wire_nliii_w_lg_nll1Oil4160w(0) <= NOT nll1Oil;
	wire_nliii_w_lg_nlli01i4246w(0) <= NOT nlli01i;
	wire_nliii_w_lg_nlli11l4299w(0) <= NOT nlli11l;
	wire_nliii_w_lg_nlli1il4235w(0) <= NOT nlli1il;
	wire_nliii_w_lg_nlli1iO4270w(0) <= NOT nlli1iO;
	wire_nliii_w_lg_nlli1li4268w(0) <= NOT nlli1li;
	wire_nliii_w_lg_nlli1ll4232w(0) <= NOT nlli1ll;
	wire_nliii_w_lg_nlli1lO4265w(0) <= NOT nlli1lO;
	wire_nliii_w_lg_nlli1Oi4263w(0) <= NOT nlli1Oi;
	wire_nliii_w_lg_nlli1Ol4261w(0) <= NOT nlli1Ol;
	wire_nliii_w_lg_nlli1OO4259w(0) <= NOT nlli1OO;
	wire_nliii_w_lg_nllll0i4065w(0) <= NOT nllll0i;
	wire_nliii_w_lg_nllll0l4320w(0) <= NOT nllll0l;
	wire_nliii_w_lg_nllll0O4318w(0) <= NOT nllll0O;
	wire_nliii_w_lg_nllll1l4168w(0) <= NOT nllll1l;
	wire_nliii_w_lg_nllllii4359w(0) <= NOT nllllii;
	wire_nliii_w_lg_nllllil4344w(0) <= NOT nllllil;
	wire_nliii_w_lg_nlllliO4356w(0) <= NOT nlllliO;
	wire_nliii_w_lg_nllllli4333w(0) <= NOT nllllli;
	wire_nliii_w_lg_nllllll4312w(0) <= NOT nllllll;
	wire_nliii_w_lg_nlllllO4323w(0) <= NOT nlllllO;
	wire_nliii_w_lg_nlllO1i3849w(0) <= NOT nlllO1i;
	wire_nliii_w_lg_nllOO0i3671w(0) <= NOT nllOO0i;
	wire_nliii_w_lg_nllOO1O3666w(0) <= NOT nllOO1O;
	wire_nliii_w_lg_nlO000l3762w(0) <= NOT nlO000l;
	wire_nliii_w_lg_nlO00l627w(0) <= NOT nlO00l;
	wire_nliii_w_lg_nlO00ll3698w(0) <= NOT nlO00ll;
	wire_nliii_w_lg_nlO00lO3733w(0) <= NOT nlO00lO;
	wire_nliii_w_lg_nlO00Oi3731w(0) <= NOT nlO00Oi;
	wire_nliii_w_lg_nlO00Ol3695w(0) <= NOT nlO00Ol;
	wire_nliii_w_lg_nlO00OO3728w(0) <= NOT nlO00OO;
	wire_nliii_w_lg_nlO01lO3751w(0) <= NOT nlO01lO;
	wire_nliii_w_lg_nlO01OO3748w(0) <= NOT nlO01OO;
	wire_nliii_w_lg_nlO0i0i3709w(0) <= NOT nlO0i0i;
	wire_nliii_w_lg_nlO0i1i3726w(0) <= NOT nlO0i1i;
	wire_nliii_w_lg_nlO0i1l3724w(0) <= NOT nlO0i1l;
	wire_nliii_w_lg_nlO0i1O3722w(0) <= NOT nlO0i1O;
	wire_nliii_w_lg_nlO10l946w(0) <= NOT nlO10l;
	wire_nliii_w_lg_nlO11ll3623w(0) <= NOT nlO11ll;
	wire_nliii_w_lg_nlO1ii844w(0) <= NOT nlO1ii;
	wire_nliii_w_lg_nlO1il1098w(0) <= NOT nlO1il;
	wire_nliii_w_lg_nlO1iO1096w(0) <= NOT nlO1iO;
	wire_nliii_w_lg_nlO1li1137w(0) <= NOT nlO1li;
	wire_nliii_w_lg_nlO1ll1122w(0) <= NOT nlO1ll;
	wire_nliii_w_lg_nlO1lO1134w(0) <= NOT nlO1lO;
	wire_nliii_w_lg_nlO1Oi1111w(0) <= NOT nlO1Oi;
	wire_nliii_w_lg_nlO1Ol1090w(0) <= NOT nlO1Ol;
	wire_nliii_w_lg_nlO1OO1101w(0) <= NOT nlO1OO;
	wire_nliii_w_lg_nlOiO0l3631w(0) <= NOT nlOiO0l;
	wire_nliii_w_lg_nlOiOii3529w(0) <= NOT nlOiOii;
	wire_nliii_w_lg_nlOiOil3783w(0) <= NOT nlOiOil;
	wire_nliii_w_lg_nlOiOiO3781w(0) <= NOT nlOiOiO;
	wire_nliii_w_lg_nlOiOli3822w(0) <= NOT nlOiOli;
	wire_nliii_w_lg_nlOiOll3807w(0) <= NOT nlOiOll;
	wire_nliii_w_lg_nlOiOlO3819w(0) <= NOT nlOiOlO;
	wire_nliii_w_lg_nlOiOOi3796w(0) <= NOT nlOiOOi;
	wire_nliii_w_lg_nlOiOOl3775w(0) <= NOT nlOiOOl;
	wire_nliii_w_lg_nlOiOOO3786w(0) <= NOT nlOiOOO;
	wire_nliii_w_lg_nlOl10i3313w(0) <= NOT nlOl10i;
	wire_nliii_w_lg_nlOO0Ol3087w(0) <= NOT nlOO0Ol;
	wire_nliii_w_lg_nlOO10O3130w(0) <= NOT nlOO10O;
	wire_nliii_w_lg_nlOO1ii3135w(0) <= NOT nlOO1ii;
	PROCESS (pclk, wire_nll1Oli_CLRN)
	BEGIN
		IF (wire_nll1Oli_CLRN = '0') THEN
				nll1OiO <= '0';
				nll1Oll <= '0';
		ELSIF (pclk = '1' AND pclk'event) THEN
			IF (wire_nll00lO_o = '1') THEN
				nll1OiO <= nli1l1i;
				nll1Oll <= nli1l0i;
			END IF;
		END IF;
	END PROCESS;
	wire_nll1Oli_CLRN <= ((nli1iiO72 XOR nli1iiO71) AND prstn);
	PROCESS (uclk, wire_nlO01i_PRN)
	BEGIN
		IF (wire_nlO01i_PRN = '0') THEN
				n00iii <= '1';
				n1i00i <= '1';
				ni1lli <= '1';
				niOOOi <= '1';
				nliOili <= '1';
				nllllOi <= '1';
				nlO01l <= '1';
				nlOl11i <= '1';
		ELSIF (uclk = '1' AND uclk'event) THEN
				n00iii <= n00iOi;
				n1i00i <= n1i0li;
				ni1lli <= ni1O1i;
				niOOOi <= nl110i;
				nliOili <= nliOl1i;
				nllllOi <= nlllO0i;
				nlO01l <= nlO0iO;
				nlOl11i <= nlOl1ii;
		END IF;
	END PROCESS;
	wire_nlO01i_PRN <= (nliliOl54 XOR nliliOl53);
	PROCESS (pclk, wire_nlO0ii_PRN, wire_nlO0ii_CLRN)
	BEGIN
		IF (wire_nlO0ii_PRN = '0') THEN
				n00ilO <= '1';
				n1i0iO <= '1';
				ni1lOO <= '1';
				nl111O <= '1';
				nliOiOO <= '1';
				nlllO1O <= '1';
				nlO0il <= '1';
				nlOl10O <= '1';
		ELSIF (wire_nlO0ii_CLRN = '0') THEN
				n00ilO <= '0';
				n1i0iO <= '0';
				ni1lOO <= '0';
				nl111O <= '0';
				nliOiOO <= '0';
				nlllO1O <= '0';
				nlO0il <= '0';
				nlOl10O <= '0';
		ELSIF (pclk = '1' AND pclk'event) THEN
				n00ilO <= n00iOO;
				n1i0iO <= n1i0lO;
				ni1lOO <= ni1O1O;
				nl111O <= nl110O;
				nliOiOO <= nliOl1O;
				nlllO1O <= nlllO0O;
				nlO0il <= nlO0ll;
				nlOl10O <= nlOl1iO;
		END IF;
	END PROCESS;
	wire_nlO0ii_CLRN <= (nlill1i50 XOR nlill1i49);
	wire_nlO0ii_PRN <= (nliliOO52 XOR nliliOO51);
	PROCESS (uclk, wire_nlO0lO_CLRN)
	BEGIN
		IF (wire_nlO0lO_CLRN = '0') THEN
				n00ill <= '0';
				n00iOO <= '0';
				n00l1i <= '0';
				n1i0il <= '0';
				n1i0lO <= '0';
				n1i0Oi <= '0';
				ni1lOl <= '0';
				ni1O0i <= '0';
				ni1O1O <= '0';
				nl110O <= '0';
				nl111l <= '0';
				nl11ii <= '0';
				nliOiOl <= '0';
				nliOl0i <= '0';
				nliOl1O <= '0';
				nlllO0O <= '0';
				nlllO1l <= '0';
				nlllOii <= '0';
				nlO00O <= '0';
				nlO0ll <= '0';
				nlO0Oi <= '0';
				nlOl10l <= '0';
				nlOl1iO <= '0';
				nlOl1li <= '0';
		ELSIF (uclk = '1' AND uclk'event) THEN
				n00ill <= n00iii;
				n00iOO <= wire_n00l1l_dataout;
				n00l1i <= wire_n00l0l_dataout;
				n1i0il <= n1i00i;
				n1i0lO <= wire_n1i0Ol_dataout;
				n1i0Oi <= wire_n1ii1l_dataout;
				ni1lOl <= ni1lli;
				ni1O0i <= wire_ni1Oil_dataout;
				ni1O1O <= wire_ni1O0l_dataout;
				nl110O <= wire_nl11il_dataout;
				nl111l <= niOOOi;
				nl11ii <= wire_nl11ll_dataout;
				nliOiOl <= nliOili;
				nliOl0i <= wire_nliOlil_dataout;
				nliOl1O <= wire_nliOl0l_dataout;
				nlllO0O <= wire_nlllOil_dataout;
				nlllO1l <= nllllOi;
				nlllOii <= wire_nlllOll_dataout;
				nlO00O <= nlO01l;
				nlO0ll <= wire_nlO0Ol_dataout;
				nlO0Oi <= wire_nlOi1l_dataout;
				nlOl10l <= nlOl11i;
				nlOl1iO <= wire_nlOl1ll_dataout;
				nlOl1li <= wire_nlOl1Ol_dataout;
		END IF;
	END PROCESS;
	wire_nlO0lO_CLRN <= ((nlill1l48 XOR nlill1l47) AND urstn);
	wire_nlO0lO_w_lg_n00iOO2233w(0) <= NOT n00iOO;
	wire_nlO0lO_w_lg_n1i0lO2771w(0) <= NOT n1i0lO;
	wire_nlO0lO_w_lg_ni1O1O1697w(0) <= NOT ni1O1O;
	wire_nlO0lO_w_lg_nl110O1160w(0) <= NOT nl110O;
	wire_nlO0lO_w_lg_nliOl1O4382w(0) <= NOT nliOl1O;
	wire_nlO0lO_w_lg_nlllO0O3845w(0) <= NOT nlllO0O;
	wire_nlO0lO_w_lg_nlO0ll619w(0) <= NOT nlO0ll;
	wire_nlO0lO_w_lg_nlOl1iO3309w(0) <= NOT nlOl1iO;
	PROCESS (pclk, wire_nlO11Oi_PRN, prstn)
	BEGIN
		IF (wire_nlO11Oi_PRN = '0') THEN
				nlO11lO <= '1';
				nlO11Ol <= '1';
		ELSIF (prstn = '0') THEN
				nlO11lO <= '0';
				nlO11Ol <= '0';
		ELSIF (pclk = '1' AND pclk'event) THEN
			IF (wire_nlO1iOO_o = '1') THEN
				nlO11lO <= nli010i;
				nlO11Ol <= nli01ii;
			END IF;
		END IF;
	END PROCESS;
	wire_nlO11Oi_PRN <= (nli1OlO70 XOR nli1OlO69);
	PROCESS (pclk, wire_nlOOi1i_PRN, wire_nlOOi1i_CLRN)
	BEGIN
		IF (wire_nlOOi1i_PRN = '0') THEN
				nlOO0OO <= '1';
				nlOOi1l <= '1';
		ELSIF (wire_nlOOi1i_CLRN = '0') THEN
				nlOO0OO <= '0';
				nlOOi1l <= '0';
		ELSIF (pclk = '1' AND pclk'event) THEN
			IF (wire_nlOOO1O_o = '1') THEN
				nlOO0OO <= nli0iil;
				nlOOi1l <= nli0ill;
			END IF;
		END IF;
	END PROCESS;
	wire_nlOOi1i_CLRN <= ((nli0i1i66 XOR nli0i1i65) AND prstn);
	wire_nlOOi1i_PRN <= (nli00OO68 XOR nli00OO67);
	wire_n0001i_dataout <= n0001l AND enable_inf_ei(0);
	wire_n0001O_dataout <= ((wire_n001lO_dataout OR wire_n001ll_dataout) OR wire_n001Oi_dataout) WHEN rate = '1'  ELSE ((wire_n001OO_dataout OR wire_n001Ol_dataout) OR wire_n0001i_dataout);
	wire_n0010i_dataout <= wire_n001li_o(1) AND NOT(n1OOlO);
	wire_n0010l_dataout <= wire_n001li_o(2) AND NOT(n1OOlO);
	wire_n0010O_dataout <= wire_n001li_o(3) AND NOT(n1OOlO);
	wire_n0011i_dataout <= wire_n0011l_o(6) AND NOT(n1OOll);
	wire_n0011O_dataout <= wire_n001li_o(0) AND NOT(n1OOlO);
	wire_n001i_dataout <= wire_n000i_o(2) AND nlilliO;
	wire_n001ii_dataout <= wire_n001li_o(4) AND NOT(n1OOlO);
	wire_n001il_dataout <= wire_n001li_o(5) AND NOT(n1OOlO);
	wire_n001iO_dataout <= wire_n001li_o(6) AND NOT(n1OOlO);
	wire_n001l_dataout <= wire_n000i_o(3) AND nlilliO;
	wire_n001ll_dataout <= n1llll AND enable_inf_ei(5);
	wire_n001lO_dataout <= n1l00O AND enable_inf_ei(4);
	wire_n001O_dataout <= wire_n000i_o(4) AND nlilliO;
	wire_n001Oi_dataout <= n0001l AND enable_inf_ei(3);
	wire_n001Ol_dataout <= n1llll AND enable_inf_ei(2);
	wire_n001OO_dataout <= n1l00O AND enable_inf_ei(1);
	wire_n00iil_dataout <= wire_nliii_w_lg_n00ili2237w(0) WHEN (n00iOl XOR n00iOi) = '1'  ELSE n00ili;
	wire_n00l0l_dataout <= n00l1i WHEN nlii00l = '1'  ELSE rxupdatefc;
	wire_n00l1l_dataout <= wire_nlO0lO_w_lg_n00iOO2233w(0) WHEN (wire_w_lg_nlii00l2234w(0) AND (rxupdatefc XOR n00l1i)) = '1'  ELSE n00iOO;
	wire_n0100i_dataout <= wire_n010OO_dataout AND NOT(n1OOll);
	wire_n0100l_dataout <= wire_n01i1i_dataout AND NOT(n1OOll);
	wire_n0100O_dataout <= wire_n01i1l_dataout AND NOT(n1OOll);
	wire_n0101i_dataout <= wire_n010lO_dataout AND NOT(n1OOll);
	wire_n0101l_dataout <= wire_n010Oi_dataout AND NOT(n1OOll);
	wire_n0101O_dataout <= wire_n010Ol_dataout AND NOT(n1OOll);
	wire_n010ii_dataout <= wire_n01i1O_dataout AND NOT(n1OOll);
	wire_n010il_dataout <= wire_n01i0i_dataout AND NOT(n1OOll);
	wire_n010iO_dataout <= wire_n01i0l_dataout AND NOT(n1OOll);
	wire_n010li_dataout <= wire_n01i0O_dataout AND NOT(n1OOll);
	wire_n010ll_dataout <= wire_n01iii_dataout AND NOT(n1OOll);
	wire_n010lO_dataout <= n1Oi0O OR nlii1Oi;
	wire_n010Oi_dataout <= n1Ol1l OR nlii1Ol;
	wire_n010Ol_dataout <= wire_n01iil_o(0) WHEN n1OOOl = '1'  ELSE n1Ol1O;
	wire_n010OO_dataout <= wire_n01iil_o(1) WHEN n1OOOl = '1'  ELSE n1Ol0i;
	wire_n01i0i_dataout <= wire_n01iil_o(5) WHEN n1OOOl = '1'  ELSE n1Olil;
	wire_n01i0l_dataout <= wire_n01iil_o(6) WHEN n1OOOl = '1'  ELSE n1OliO;
	wire_n01i0O_dataout <= wire_n01iil_o(7) WHEN n1OOOl = '1'  ELSE n1Olli;
	wire_n01i1i_dataout <= wire_n01iil_o(2) WHEN n1OOOl = '1'  ELSE n1Ol0l;
	wire_n01i1l_dataout <= wire_n01iil_o(3) WHEN n1OOOl = '1'  ELSE n1Ol0O;
	wire_n01i1O_dataout <= wire_n01iil_o(4) WHEN n1OOOl = '1'  ELSE n1Olii;
	wire_n01ii_dataout <= wire_n01ll_dataout OR nlilllO;
	wire_n01iii_dataout <= wire_n01iil_o(8) WHEN n1OOOl = '1'  ELSE n1Olll;
	wire_n01iiO_dataout <= wire_n01lil_dataout AND NOT(n1OOlO);
	wire_n01il_dataout <= wire_n01lO_dataout AND NOT(nlilllO);
	wire_n01ili_dataout <= wire_n01liO_dataout AND NOT(n1OOlO);
	wire_n01ill_dataout <= wire_n01lli_dataout AND NOT(n1OOlO);
	wire_n01ilO_dataout <= wire_n01lll_dataout AND NOT(n1OOlO);
	wire_n01iO_dataout <= wire_n01Oi_dataout OR nlilllO;
	wire_n01iOi_dataout <= wire_n01llO_dataout AND NOT(n1OOlO);
	wire_n01iOl_dataout <= wire_n01lOi_dataout AND NOT(n1OOlO);
	wire_n01iOO_dataout <= wire_n01lOl_dataout AND NOT(n1OOlO);
	wire_n01l0i_dataout <= wire_n01O1O_dataout AND NOT(n1OOlO);
	wire_n01l0l_dataout <= wire_n01O0i_dataout AND NOT(n1OOlO);
	wire_n01l0O_dataout <= wire_n01O0l_dataout AND NOT(n1OOlO);
	wire_n01l1i_dataout <= wire_n01lOO_dataout AND NOT(n1OOlO);
	wire_n01l1l_dataout <= wire_n01O1i_dataout AND NOT(n1OOlO);
	wire_n01l1O_dataout <= wire_n01O1l_dataout AND NOT(n1OOlO);
	wire_n01li_dataout <= wire_n01Ol_dataout OR nlilllO;
	wire_n01lii_dataout <= wire_n01O0O_dataout AND NOT(n1OOlO);
	wire_n01lil_dataout <= n1OllO OR nlii1OO;
	wire_n01liO_dataout <= n1OlOi OR nlii01i;
	wire_n01ll_dataout <= wire_n01OO_dataout WHEN wire_w_lg_nlillil325w(0) = '1'  ELSE n1l0O;
	wire_n01lli_dataout <= n1OlOl OR nlii01l;
	wire_n01lll_dataout <= n1OlOO OR nlii01O;
	wire_n01llO_dataout <= n1OO1i OR nlii00i;
	wire_n01lO_dataout <= wire_n001i_dataout WHEN wire_w_lg_nlillil325w(0) = '1'  ELSE n1lii;
	wire_n01lOi_dataout <= wire_n01Oii_o(0) WHEN n1OOOO = '1'  ELSE n1OO1l;
	wire_n01lOl_dataout <= wire_n01Oii_o(1) WHEN n1OOOO = '1'  ELSE n1OO1O;
	wire_n01lOO_dataout <= wire_n01Oii_o(2) WHEN n1OOOO = '1'  ELSE n1OO0i;
	wire_n01O0i_dataout <= wire_n01Oii_o(6) WHEN n1OOOO = '1'  ELSE n1OOil;
	wire_n01O0l_dataout <= wire_n01Oii_o(7) WHEN n1OOOO = '1'  ELSE n1OOiO;
	wire_n01O0O_dataout <= wire_n01Oii_o(8) WHEN n1OOOO = '1'  ELSE n1OOli;
	wire_n01O1i_dataout <= wire_n01Oii_o(3) WHEN n1OOOO = '1'  ELSE n1OO0l;
	wire_n01O1l_dataout <= wire_n01Oii_o(4) WHEN n1OOOO = '1'  ELSE n1OO0O;
	wire_n01O1O_dataout <= wire_n01Oii_o(5) WHEN n1OOOO = '1'  ELSE n1OOii;
	wire_n01Oi_dataout <= wire_n001l_dataout WHEN wire_w_lg_nlillil325w(0) = '1'  ELSE n1lil;
	wire_n01Ol_dataout <= wire_n001O_dataout WHEN wire_w_lg_nlillil325w(0) = '1'  ELSE n1liO;
	wire_n01Oli_dataout <= wire_n0011l_o(0) AND NOT(n1OOll);
	wire_n01Oll_dataout <= wire_n0011l_o(1) AND NOT(n1OOll);
	wire_n01OlO_dataout <= wire_n0011l_o(2) AND NOT(n1OOll);
	wire_n01OO_dataout <= wire_n000i_o(1) AND nlilliO;
	wire_n01OOi_dataout <= wire_n0011l_o(3) AND NOT(n1OOll);
	wire_n01OOl_dataout <= wire_n0011l_o(4) AND NOT(n1OOll);
	wire_n01OOO_dataout <= wire_n0011l_o(5) AND NOT(n1OOll);
	wire_n0i0OO_dataout <= n0iiiO OR wire_nliii_w_lg_ni1iOl2019w(0);
	wire_n0ii0i_dataout <= wire_n0iiil_dataout AND NOT(n0i0li);
	wire_n0ii0l_dataout <= n0i0ii AND NOT(ni1iOl);
	wire_n0ii0O_dataout <= n0i0il AND NOT(ni1iOl);
	wire_n0ii1i_dataout <= wire_n0ii0l_dataout AND NOT(n0i0li);
	wire_n0ii1l_dataout <= wire_n0ii0O_dataout OR n0i0li;
	wire_n0ii1O_dataout <= wire_n0iiii_dataout AND NOT(n0i0li);
	wire_n0iiii_dataout <= n0i0iO OR ni1iOl;
	wire_n0iiil_dataout <= n0iiiO AND NOT(ni1iOl);
	wire_n0ili_dataout <= n100O WHEN nliO1ii = '1'  ELSE nl01O;
	wire_n0ill_dataout <= nl0Oi OR rate;
	wire_n0ilO_dataout <= n0lOO AND NOT(rate);
	wire_n0iOi_dataout <= n0lOi WHEN rate = '1'  ELSE n0llO;
	wire_n0iOl_dataout <= ((n0O1i OR n0l1l) OR (NOT (nliO1il30 XOR nliO1il29))) WHEN rate = '1'  ELSE (n0lOO OR n0i0O);
	wire_n0l0li_dataout <= wire_n0l0Ol_dataout OR nlii0Ol;
	wire_n0l0ll_dataout <= wire_n0l0OO_dataout AND NOT(nlii0Ol);
	wire_n0l0lO_dataout <= wire_n0li1i_dataout OR nlii0Ol;
	wire_n0l0Oi_dataout <= wire_n0li1l_dataout OR nlii0Ol;
	wire_n0l0Ol_dataout <= wire_n0li1O_dataout WHEN wire_w_lg_nlii0li1950w(0) = '1'  ELSE n0iOiO;
	wire_n0l0OO_dataout <= wire_n0li0i_dataout WHEN wire_w_lg_nlii0li1950w(0) = '1'  ELSE n0iOli;
	wire_n0l10l_dataout <= wire_n0l10O_dataout AND NOT(nlii0Ol);
	wire_n0l10O_dataout <= wire_n0l1ii_dataout OR (wire_w_lg_nliiiii2003w(0) AND wire_w_lg_w_lg_nliii0O1986w2004w(0));
	wire_n0l1ii_dataout <= wire_n0l1il_dataout OR (wire_w_lg_nliii0O1986w(0) AND ((wire_nl01l_w_lg_w_lg_w_lg_w_lg_n0iOlO1988w1990w1992w1993w(0) OR (wire_nl01l_w_lg_w_lg_n0iOlO1995w1996w(0) AND wire_nl01l_w_lg_n0iOiO1991w(0))) OR wire_nl01l_w_lg_w_lg_w_lg_n0iOlO1995w1999w2000w(0)));
	wire_n0l1il_dataout <= wire_n0l1iO_dataout OR (wire_w_lg_nliii0O1986w(0) AND nlii0iO);
	wire_n0l1iO_dataout <= n0iO0l OR (wire_n0l01i_o AND (((nliii1O XOR n0iOil) OR (nlii0OO XOR n0iO0O)) OR (NOT (n0iOil XOR n0iO0O))));
	wire_n0li0i_dataout <= wire_n0liii_o(2) AND nlii0ll;
	wire_n0li0l_dataout <= wire_n0liii_o(3) AND nlii0ll;
	wire_n0li0O_dataout <= wire_n0liii_o(4) AND nlii0ll;
	wire_n0li1i_dataout <= wire_n0li0l_dataout WHEN wire_w_lg_nlii0li1950w(0) = '1'  ELSE n0iOll;
	wire_n0li1l_dataout <= wire_n0li0O_dataout WHEN wire_w_lg_nlii0li1950w(0) = '1'  ELSE n0iOlO;
	wire_n0li1O_dataout <= wire_n0liii_o(1) AND nlii0ll;
	wire_n0llOi_dataout <= n0iiiO WHEN nliiiOi = '1'  ELSE ni1i0l;
	wire_n0llOl_dataout <= ni1iOO OR rate;
	wire_n0llOO_dataout <= n0O11O AND NOT(rate);
	wire_n0lO1i_dataout <= n0O11i WHEN rate = '1'  ELSE n0lOOO;
	wire_n0lO1l_dataout <= (n0O10i OR n0lO0l) WHEN rate = '1'  ELSE (n0O11O OR n0lliO);
	wire_n0Oi0i_dataout <= wire_n0OiOO_dataout AND NOT(n0O1Ol);
	wire_n0Oi0l_dataout <= wire_n0Ol1i_dataout AND NOT(n0O1Ol);
	wire_n0Oi0O_dataout <= wire_n0Ol1l_dataout AND NOT(n0O1Ol);
	wire_n0Oiii_dataout <= wire_n0Ol1O_dataout AND NOT(n0O1Ol);
	wire_n0Oiil_dataout <= wire_n0Ol0i_dataout AND NOT(n0O1Ol);
	wire_n0OiiO_dataout <= wire_n0Ol0l_dataout AND NOT(n0O1Ol);
	wire_n0Oili_dataout <= wire_n0Ol0O_dataout AND NOT(n0O1Ol);
	wire_n0Oill_dataout <= wire_n0Olii_dataout AND NOT(n0O1Ol);
	wire_n0OilO_dataout <= wire_n0Olil_dataout AND NOT(n0O1Ol);
	wire_n0OiOi_dataout <= wire_n0OliO_dataout AND NOT(n0O1Ol);
	wire_n0OiOl_dataout <= wire_n0Olli_dataout AND NOT(n0O1Ol);
	wire_n0OiOO_dataout <= n0lliO OR nliil1i;
	wire_n0Ol0i_dataout <= wire_n0Olll_o(2) WHEN n0O01l = '1'  ELSE n0lOil;
	wire_n0Ol0l_dataout <= wire_n0Olll_o(3) WHEN n0O01l = '1'  ELSE n0lOiO;
	wire_n0Ol0O_dataout <= wire_n0Olll_o(4) WHEN n0O01l = '1'  ELSE n0lOli;
	wire_n0Ol1i_dataout <= n0lO0l OR nliil1l;
	wire_n0Ol1l_dataout <= wire_n0Olll_o(0) WHEN n0O01l = '1'  ELSE n0lO0O;
	wire_n0Ol1O_dataout <= wire_n0Olll_o(1) WHEN n0O01l = '1'  ELSE n0lOii;
	wire_n0Olii_dataout <= wire_n0Olll_o(5) WHEN n0O01l = '1'  ELSE n0lOll;
	wire_n0Olil_dataout <= wire_n0Olll_o(6) WHEN n0O01l = '1'  ELSE n0lOlO;
	wire_n0OliO_dataout <= wire_n0Olll_o(7) WHEN n0O01l = '1'  ELSE n0lOOi;
	wire_n0Olli_dataout <= wire_n0Olll_o(8) WHEN n0O01l = '1'  ELSE n0lOOl;
	wire_n0OllO_dataout <= wire_n0OOll_dataout AND NOT(n0O1OO);
	wire_n0OlOi_dataout <= wire_n0OOlO_dataout AND NOT(n0O1OO);
	wire_n0OlOl_dataout <= wire_n0OOOi_dataout AND NOT(n0O1OO);
	wire_n0OlOO_dataout <= wire_n0OOOl_dataout AND NOT(n0O1OO);
	wire_n0OO0i_dataout <= wire_ni111O_dataout AND NOT(n0O1OO);
	wire_n0OO0l_dataout <= wire_ni110i_dataout AND NOT(n0O1OO);
	wire_n0OO0O_dataout <= wire_ni110l_dataout AND NOT(n0O1OO);
	wire_n0OO1i_dataout <= wire_n0OOOO_dataout AND NOT(n0O1OO);
	wire_n0OO1l_dataout <= wire_ni111i_dataout AND NOT(n0O1OO);
	wire_n0OO1O_dataout <= wire_ni111l_dataout AND NOT(n0O1OO);
	wire_n0OOii_dataout <= wire_ni110O_dataout AND NOT(n0O1OO);
	wire_n0OOil_dataout <= wire_ni11ii_dataout AND NOT(n0O1OO);
	wire_n0OOiO_dataout <= wire_ni11il_dataout AND NOT(n0O1OO);
	wire_n0OOli_dataout <= wire_ni11iO_dataout AND NOT(n0O1OO);
	wire_n0OOll_dataout <= n0lOOO OR nliil1O;
	wire_n0OOlO_dataout <= n0O11i OR nliil0i;
	wire_n0OOOi_dataout <= n0O11l OR nliil0l;
	wire_n0OOOl_dataout <= n0O11O OR nliil0O;
	wire_n0OOOO_dataout <= n0O10i OR nliilii;
	wire_n1000i_dataout <= wire_n1000l_o(8) WHEN n11lll = '1'  ELSE n11iil;
	wire_n1000O_dataout <= wire_n10i0l_dataout AND NOT(n11liO);
	wire_n1001i_dataout <= wire_n1000l_o(5) WHEN n11lll = '1'  ELSE n11i0l;
	wire_n1001l_dataout <= wire_n1000l_o(6) WHEN n11lll = '1'  ELSE n11i0O;
	wire_n1001O_dataout <= wire_n1000l_o(7) WHEN n11lll = '1'  ELSE n11iii;
	wire_n100i_dataout <= n110O OR nl0lO;
	wire_n100ii_dataout <= wire_n10i0O_dataout AND NOT(n11liO);
	wire_n100il_dataout <= wire_n10iii_dataout AND NOT(n11liO);
	wire_n100iO_dataout <= wire_n10iil_dataout AND NOT(n11liO);
	wire_n100l_dataout <= n100O AND NOT(nl0lO);
	wire_n100li_dataout <= wire_n10iiO_dataout AND NOT(n11liO);
	wire_n100ll_dataout <= wire_n10ili_dataout AND NOT(n11liO);
	wire_n100lO_dataout <= wire_n10ill_dataout AND NOT(n11liO);
	wire_n100Oi_dataout <= wire_n10ilO_dataout AND NOT(n11liO);
	wire_n100Ol_dataout <= wire_n10iOi_dataout AND NOT(n11liO);
	wire_n100OO_dataout <= wire_n10iOl_dataout AND NOT(n11liO);
	wire_n1010i_dataout <= wire_n101OO_dataout AND NOT(n11lil);
	wire_n1010l_dataout <= wire_n1001i_dataout AND NOT(n11lil);
	wire_n1010O_dataout <= wire_n1001l_dataout AND NOT(n11lil);
	wire_n1011i_dataout <= wire_n101lO_dataout AND NOT(n11lil);
	wire_n1011l_dataout <= wire_n101Oi_dataout AND NOT(n11lil);
	wire_n1011O_dataout <= wire_n101Ol_dataout AND NOT(n11lil);
	wire_n101i_dataout <= wire_n100l_dataout AND NOT(n11ii);
	wire_n101ii_dataout <= wire_n1001O_dataout AND NOT(n11lil);
	wire_n101il_dataout <= wire_n1000i_dataout AND NOT(n11lil);
	wire_n101iO_dataout <= n1101O OR nli0liO;
	wire_n101l_dataout <= n110i AND NOT(nl0lO);
	wire_n101li_dataout <= n110Ol OR nli0lli;
	wire_n101ll_dataout <= wire_n1000l_o(0) WHEN n11lll = '1'  ELSE n110OO;
	wire_n101lO_dataout <= wire_n1000l_o(1) WHEN n11lll = '1'  ELSE n11i1i;
	wire_n101O_dataout <= n110l AND NOT(nl0lO);
	wire_n101Oi_dataout <= wire_n1000l_o(2) WHEN n11lll = '1'  ELSE n11i1l;
	wire_n101Ol_dataout <= wire_n1000l_o(3) WHEN n11lll = '1'  ELSE n11i1O;
	wire_n101OO_dataout <= wire_n1000l_o(4) WHEN n11lll = '1'  ELSE n11i0i;
	wire_n10i0i_dataout <= wire_n10l1O_dataout AND NOT(n11liO);
	wire_n10i0l_dataout <= n11iiO OR nli0lll;
	wire_n10i0O_dataout <= n11ili OR nli0llO;
	wire_n10i1i_dataout <= wire_n10iOO_dataout AND NOT(n11liO);
	wire_n10i1l_dataout <= wire_n10l1i_dataout AND NOT(n11liO);
	wire_n10i1O_dataout <= wire_n10l1l_dataout AND NOT(n11liO);
	wire_n10iii_dataout <= n11ill OR nli0lOi;
	wire_n10iil_dataout <= n11ilO OR nli0lOl;
	wire_n10iiO_dataout <= n11iOi OR nli0lOO;
	wire_n10ili_dataout <= wire_n10l0i_o(0) WHEN n11llO = '1'  ELSE n11iOl;
	wire_n10ill_dataout <= wire_n10l0i_o(1) WHEN n11llO = '1'  ELSE n11iOO;
	wire_n10ilO_dataout <= wire_n10l0i_o(2) WHEN n11llO = '1'  ELSE n11l1i;
	wire_n10iOi_dataout <= wire_n10l0i_o(3) WHEN n11llO = '1'  ELSE n11l1l;
	wire_n10iOl_dataout <= wire_n10l0i_o(4) WHEN n11llO = '1'  ELSE n11l1O;
	wire_n10iOO_dataout <= wire_n10l0i_o(5) WHEN n11llO = '1'  ELSE n11l0i;
	wire_n10l1i_dataout <= wire_n10l0i_o(6) WHEN n11llO = '1'  ELSE n11l0l;
	wire_n10l1l_dataout <= wire_n10l0i_o(7) WHEN n11llO = '1'  ELSE n11l0O;
	wire_n10l1O_dataout <= wire_n10l0i_o(8) WHEN n11llO = '1'  ELSE n11lii;
	wire_n10lii_dataout <= wire_n10lOl_o(0) AND NOT(n11lil);
	wire_n10lil_dataout <= wire_n10lOl_o(1) AND NOT(n11lil);
	wire_n10liO_dataout <= wire_n10lOl_o(2) AND NOT(n11lil);
	wire_n10lli_dataout <= wire_n10lOl_o(3) AND NOT(n11lil);
	wire_n10lll_dataout <= wire_n10lOl_o(4) AND NOT(n11lil);
	wire_n10llO_dataout <= wire_n10lOl_o(5) AND NOT(n11lil);
	wire_n10lOi_dataout <= wire_n10lOl_o(6) AND NOT(n11lil);
	wire_n10lOO_dataout <= wire_n10Oii_o(0) AND NOT(n11liO);
	wire_n10O0i_dataout <= wire_n10Oii_o(4) AND NOT(n11liO);
	wire_n10O0l_dataout <= wire_n10Oii_o(5) AND NOT(n11liO);
	wire_n10O0O_dataout <= wire_n10Oii_o(6) AND NOT(n11liO);
	wire_n10O1i_dataout <= wire_n10Oii_o(1) AND NOT(n11liO);
	wire_n10O1l_dataout <= wire_n10Oii_o(2) AND NOT(n11liO);
	wire_n10O1O_dataout <= wire_n10Oii_o(3) AND NOT(n11liO);
	wire_n10Oil_dataout <= nlOOiil AND enable_inf_ei(5);
	wire_n10OiO_dataout <= nlOO11O AND enable_inf_ei(4);
	wire_n10Oli_dataout <= n10OOl AND enable_inf_ei(3);
	wire_n10Oll_dataout <= nlOOiil AND enable_inf_ei(2);
	wire_n10OlO_dataout <= nlOO11O AND enable_inf_ei(1);
	wire_n10OOi_dataout <= n10OOl AND enable_inf_ei(0);
	wire_n10OOO_dataout <= ((wire_n10OiO_dataout OR wire_n10Oil_dataout) OR wire_n10Oli_dataout) WHEN rate = '1'  ELSE ((wire_n10OlO_dataout OR wire_n10Oll_dataout) OR wire_n10OOi_dataout);
	wire_n110ii_dataout <= nlOO11O WHEN nli0l0O = '1'  ELSE n10OOl;
	wire_n110il_dataout <= n1i1iO OR rate;
	wire_n110iO_dataout <= n11ilO AND NOT(rate);
	wire_n110li_dataout <= n11ili WHEN rate = '1'  ELSE n11iiO;
	wire_n110ll_dataout <= (n11iOi OR n110Ol) WHEN rate = '1'  ELSE (n11ilO OR n1101O);
	wire_n11lO_dataout <= n100O OR wire_nliii_w_lg_nl0lO394w(0);
	wire_n11Oi_dataout <= wire_n101l_dataout AND NOT(n11ii);
	wire_n11Ol_dataout <= wire_n101O_dataout OR n11ii;
	wire_n11OO_dataout <= wire_n100i_dataout AND NOT(n11ii);
	wire_n11OOi_dataout <= wire_n101iO_dataout AND NOT(n11lil);
	wire_n11OOl_dataout <= wire_n101li_dataout AND NOT(n11lil);
	wire_n11OOO_dataout <= wire_n101ll_dataout AND NOT(n11lil);
	wire_n1i00l_dataout <= wire_nliii_w_lg_n1i0ii2775w(0) WHEN (n1i0ll XOR n1i0li) = '1'  ELSE n1i0ii;
	wire_n1i0Ol_dataout <= wire_nlO0lO_w_lg_n1i0lO2771w(0) WHEN (wire_w_lg_nli0O1i2772w(0) AND (rxupdatefc XOR n1i0Oi)) = '1'  ELSE n1i0lO;
	wire_n1ii1l_dataout <= n1i0Oi WHEN nli0O1i = '1'  ELSE rxupdatefc;
	wire_n1l00i_dataout <= n1l10O OR n000ll;
	wire_n1l00l_dataout <= n1l00O AND NOT(n000ll);
	wire_n1l01i_dataout <= wire_n1l00l_dataout AND NOT(n1l1ii);
	wire_n1l01l_dataout <= n1l10i AND NOT(n000ll);
	wire_n1l01O_dataout <= n1l10l AND NOT(n000ll);
	wire_n1l1lO_dataout <= n1l00O OR wire_nliii_w_lg_n000ll2557w(0);
	wire_n1l1Oi_dataout <= wire_n1l01l_dataout AND NOT(n1l1ii);
	wire_n1l1Ol_dataout <= wire_n1l01O_dataout OR n1l1ii;
	wire_n1l1OO_dataout <= wire_n1l00i_dataout AND NOT(n1l1ii);
	wire_n1lO0i_dataout <= wire_n1lO0l_dataout OR (wire_w_lg_nlii11O2522w(0) AND ((wire_nl01l_w_lg_w_lg_w_lg_w_lg_n1lliO2524w2526w2528w2529w(0) OR (wire_nl01l_w_lg_w_lg_n1lliO2531w2532w(0) AND wire_nl01l_w_lg_n1ll0O2527w(0))) OR wire_nl01l_w_lg_w_lg_w_lg_n1lliO2531w2535w2536w(0)));
	wire_n1lO0l_dataout <= wire_n1lO0O_dataout OR (wire_w_lg_nlii11O2522w(0) AND nli0O0O);
	wire_n1lO0O_dataout <= n1ll1l OR (wire_n1lOOi_o AND (((nli0OOO XOR n1ll0l) OR (nli0OlO XOR n1ll1O)) OR (NOT (n1ll0l XOR n1ll1O))));
	wire_n1lO1l_dataout <= wire_n1lO1O_dataout AND NOT(nli0Oll);
	wire_n1lO1O_dataout <= wire_n1lO0i_dataout OR (wire_w_lg_nlii10i2539w(0) AND wire_w_lg_w_lg_nlii11O2522w2540w(0));
	wire_n1O01i_dataout <= wire_n1O00i_o(2) AND nli0Oil;
	wire_n1O01l_dataout <= wire_n1O00i_o(3) AND nli0Oil;
	wire_n1O01O_dataout <= wire_n1O00i_o(4) AND nli0Oil;
	wire_n1O0i_dataout <= wire_n1O0l_dataout OR (wire_w_lg_nlilOil361w(0) AND ((wire_nl01l_w_lg_w_lg_w_lg_w_lg_n1liO363w365w367w368w(0) OR (wire_nl01l_w_lg_w_lg_n1liO370w371w(0) AND wire_nl01l_w_lg_n1l0O366w(0))) OR wire_nl01l_w_lg_w_lg_w_lg_n1liO370w374w375w(0)));
	wire_n1O0l_dataout <= wire_n1O0O_dataout OR (wire_w_lg_nlilOil361w(0) AND nlillii);
	wire_n1O0O_dataout <= n1l1l OR (wire_n1OOi_o AND (((nlilO1O XOR n1l0l) OR (nlillOi XOR n1l1O)) OR (NOT (n1l0l XOR n1l1O))));
	wire_n1O1ii_dataout <= wire_n1O1ll_dataout OR nli0Oll;
	wire_n1O1il_dataout <= wire_n1O1lO_dataout AND NOT(nli0Oll);
	wire_n1O1iO_dataout <= wire_n1O1Oi_dataout OR nli0Oll;
	wire_n1O1l_dataout <= wire_n1O1O_dataout AND NOT(nlilllO);
	wire_n1O1li_dataout <= wire_n1O1Ol_dataout OR nli0Oll;
	wire_n1O1ll_dataout <= wire_n1O1OO_dataout WHEN wire_w_lg_nli0Oii2486w(0) = '1'  ELSE n1ll0O;
	wire_n1O1lO_dataout <= wire_n1O01i_dataout WHEN wire_w_lg_nli0Oii2486w(0) = '1'  ELSE n1llii;
	wire_n1O1O_dataout <= wire_n1O0i_dataout OR (wire_w_lg_nlilOll378w(0) AND wire_w_lg_w_lg_nlilOil361w379w(0));
	wire_n1O1Oi_dataout <= wire_n1O01l_dataout WHEN wire_w_lg_nli0Oii2486w(0) = '1'  ELSE n1llil;
	wire_n1O1Ol_dataout <= wire_n1O01O_dataout WHEN wire_w_lg_nli0Oii2486w(0) = '1'  ELSE n1lliO;
	wire_n1O1OO_dataout <= wire_n1O00i_o(1) AND nli0Oil;
	wire_n1Oili_dataout <= n1l00O WHEN nlii1li = '1'  ELSE n0001l;
	wire_n1Oill_dataout <= n000lO OR rate;
	wire_n1OilO_dataout <= n1OlOO AND NOT(rate);
	wire_n1OiOi_dataout <= n1OlOi WHEN rate = '1'  ELSE n1OllO;
	wire_n1OiOl_dataout <= (n1OO1i OR n1Ol1l) WHEN rate = '1'  ELSE (n1OlOO OR n1Oi0O);
	wire_ni00i_dataout <= wire_ni0OO_dataout AND NOT(n0Oll);
	wire_ni00l_dataout <= wire_nii1i_dataout AND NOT(n0Oll);
	wire_ni00O_dataout <= wire_nii1l_dataout AND NOT(n0Oll);
	wire_ni01i_dataout <= wire_ni0lO_dataout AND NOT(n0Oll);
	wire_ni01l_dataout <= wire_ni0Oi_dataout AND NOT(n0Oll);
	wire_ni01O_dataout <= wire_ni0Ol_dataout AND NOT(n0Oll);
	wire_ni0ii_dataout <= wire_nii1O_dataout AND NOT(n0Oll);
	wire_ni0il_dataout <= wire_nii0i_dataout AND NOT(n0Oll);
	wire_ni0iO_dataout <= wire_nii0l_dataout AND NOT(n0Oll);
	wire_ni0l0i_dataout <= wire_ni0lil_dataout AND NOT(ni0iOi);
	wire_ni0l0l_dataout <= wire_ni0liO_dataout OR ni0iOi;
	wire_ni0l0O_dataout <= wire_ni0lli_dataout AND NOT(ni0iOi);
	wire_ni0l1O_dataout <= ni0llO OR wire_nliii_w_lg_niOO1l1483w(0);
	wire_ni0li_dataout <= wire_nii0O_dataout AND NOT(n0Oll);
	wire_ni0lii_dataout <= wire_ni0lll_dataout AND NOT(ni0iOi);
	wire_ni0lil_dataout <= ni0ili AND NOT(niOO1l);
	wire_ni0liO_dataout <= ni0ill AND NOT(niOO1l);
	wire_ni0ll_dataout <= wire_niiii_dataout AND NOT(n0Oll);
	wire_ni0lli_dataout <= ni0ilO OR niOO1l;
	wire_ni0lll_dataout <= ni0llO AND NOT(niOO1l);
	wire_ni0lO_dataout <= n0i0O OR nliO01i;
	wire_ni0Oi_dataout <= n0l1l OR nliO01l;
	wire_ni0Ol_dataout <= wire_niiil_o(0) WHEN n0OOl = '1'  ELSE n0l1O;
	wire_ni0OO_dataout <= wire_niiil_o(1) WHEN n0OOl = '1'  ELSE n0l0i;
	wire_ni100i_dataout <= wire_ni100l_o(6) AND NOT(n0O1Ol);
	wire_ni100O_dataout <= wire_ni10Oi_o(0) AND NOT(n0O1OO);
	wire_ni101i_dataout <= wire_ni100l_o(3) AND NOT(n0O1Ol);
	wire_ni101l_dataout <= wire_ni100l_o(4) AND NOT(n0O1Ol);
	wire_ni101O_dataout <= wire_ni100l_o(5) AND NOT(n0O1Ol);
	wire_ni10ii_dataout <= wire_ni10Oi_o(1) AND NOT(n0O1OO);
	wire_ni10il_dataout <= wire_ni10Oi_o(2) AND NOT(n0O1OO);
	wire_ni10iO_dataout <= wire_ni10Oi_o(3) AND NOT(n0O1OO);
	wire_ni10li_dataout <= wire_ni10Oi_o(4) AND NOT(n0O1OO);
	wire_ni10ll_dataout <= wire_ni10Oi_o(5) AND NOT(n0O1OO);
	wire_ni10lO_dataout <= wire_ni10Oi_o(6) AND NOT(n0O1OO);
	wire_ni10Ol_dataout <= n0iOOl AND enable_inf_ei(5);
	wire_ni10OO_dataout <= n0iiiO AND enable_inf_ei(4);
	wire_ni110i_dataout <= wire_ni11li_o(3) WHEN n0O01O = '1'  ELSE n0O1il;
	wire_ni110l_dataout <= wire_ni11li_o(4) WHEN n0O01O = '1'  ELSE n0O1iO;
	wire_ni110O_dataout <= wire_ni11li_o(5) WHEN n0O01O = '1'  ELSE n0O1li;
	wire_ni111i_dataout <= wire_ni11li_o(0) WHEN n0O01O = '1'  ELSE n0O10l;
	wire_ni111l_dataout <= wire_ni11li_o(1) WHEN n0O01O = '1'  ELSE n0O10O;
	wire_ni111O_dataout <= wire_ni11li_o(2) WHEN n0O01O = '1'  ELSE n0O1ii;
	wire_ni11ii_dataout <= wire_ni11li_o(6) WHEN n0O01O = '1'  ELSE n0O1ll;
	wire_ni11il_dataout <= wire_ni11li_o(7) WHEN n0O01O = '1'  ELSE n0O1lO;
	wire_ni11iO_dataout <= wire_ni11li_o(8) WHEN n0O01O = '1'  ELSE n0O1Oi;
	wire_ni11Oi_dataout <= wire_ni100l_o(0) AND NOT(n0O1Ol);
	wire_ni11Ol_dataout <= wire_ni100l_o(1) AND NOT(n0O1Ol);
	wire_ni11OO_dataout <= wire_ni100l_o(2) AND NOT(n0O1Ol);
	wire_ni1i0i_dataout <= ni1i0l AND enable_inf_ei(0);
	wire_ni1i0O_dataout <= ((wire_ni10OO_dataout OR wire_ni10Ol_dataout) OR wire_ni1i1i_dataout) WHEN rate = '1'  ELSE ((wire_ni1i1O_dataout OR wire_ni1i1l_dataout) OR wire_ni1i0i_dataout);
	wire_ni1i1i_dataout <= ni1i0l AND enable_inf_ei(3);
	wire_ni1i1l_dataout <= n0iOOl AND enable_inf_ei(2);
	wire_ni1i1O_dataout <= n0iiiO AND enable_inf_ei(1);
	wire_ni1lll_dataout <= wire_nliii_w_lg_ni1lOi1701w(0) WHEN (ni1O1l XOR ni1O1i) = '1'  ELSE ni1lOi;
	wire_ni1O0l_dataout <= wire_nlO0lO_w_lg_ni1O1O1697w(0) WHEN (wire_w_lg_nliilil1698w(0) AND (rxupdatefc XOR ni1O0i)) = '1'  ELSE ni1O1O;
	wire_ni1Oil_dataout <= ni1O0i WHEN nliilil = '1'  ELSE rxupdatefc;
	wire_nii0i_dataout <= wire_niiil_o(5) WHEN n0OOl = '1'  ELSE n0lil;
	wire_nii0il_dataout <= wire_nii0iO_dataout AND NOT(nliiO1l);
	wire_nii0iO_dataout <= wire_nii0li_dataout OR (wire_w_lg_nliiOli1466w(0) AND wire_w_lg_w_lg_nliiOiO1449w1467w(0));
	wire_nii0l_dataout <= wire_niiil_o(6) WHEN n0OOl = '1'  ELSE n0liO;
	wire_nii0li_dataout <= wire_nii0ll_dataout OR (wire_w_lg_nliiOiO1449w(0) AND ((wire_nl01l_w_lg_w_lg_w_lg_w_lg_nii1OO1451w1453w1455w1456w(0) OR (wire_nl01l_w_lg_w_lg_nii1OO1458w1459w(0) AND wire_nl01l_w_lg_nii1lO1454w(0))) OR wire_nl01l_w_lg_w_lg_w_lg_nii1OO1458w1462w1463w(0)));
	wire_nii0ll_dataout <= wire_nii0lO_dataout OR (wire_w_lg_nliiOiO1449w(0) AND nliillO);
	wire_nii0lO_dataout <= nii1il OR (wire_niii0i_o AND (((nliiO0O XOR nii1ll) OR (nliiO1O XOR nii1iO)) OR (NOT (nii1ll XOR nii1iO))));
	wire_nii0O_dataout <= wire_niiil_o(7) WHEN n0OOl = '1'  ELSE n0lli;
	wire_nii1i_dataout <= wire_niiil_o(2) WHEN n0OOl = '1'  ELSE n0l0l;
	wire_nii1l_dataout <= wire_niiil_o(3) WHEN n0OOl = '1'  ELSE n0l0O;
	wire_nii1O_dataout <= wire_niiil_o(4) WHEN n0OOl = '1'  ELSE n0lii;
	wire_niiii_dataout <= wire_niiil_o(8) WHEN n0OOl = '1'  ELSE n0lll;
	wire_niiiO_dataout <= wire_nilil_dataout AND NOT(n0OlO);
	wire_niiiOi_dataout <= wire_niil1l_dataout OR nliiO1l;
	wire_niiiOl_dataout <= wire_niil1O_dataout AND NOT(nliiO1l);
	wire_niiiOO_dataout <= wire_niil0i_dataout OR nliiO1l;
	wire_niil0i_dataout <= wire_niilil_dataout WHEN wire_w_lg_nliilOi1413w(0) = '1'  ELSE nii1Ol;
	wire_niil0l_dataout <= wire_niiliO_dataout WHEN wire_w_lg_nliilOi1413w(0) = '1'  ELSE nii1OO;
	wire_niil0O_dataout <= wire_niilli_o(1) AND nliilOl;
	wire_niil1i_dataout <= wire_niil0l_dataout OR nliiO1l;
	wire_niil1l_dataout <= wire_niil0O_dataout WHEN wire_w_lg_nliilOi1413w(0) = '1'  ELSE nii1lO;
	wire_niil1O_dataout <= wire_niilii_dataout WHEN wire_w_lg_nliilOi1413w(0) = '1'  ELSE nii1Oi;
	wire_niili_dataout <= wire_niliO_dataout AND NOT(n0OlO);
	wire_niilii_dataout <= wire_niilli_o(2) AND nliilOl;
	wire_niilil_dataout <= wire_niilli_o(3) AND nliilOl;
	wire_niiliO_dataout <= wire_niilli_o(4) AND nliilOl;
	wire_niill_dataout <= wire_nilli_dataout AND NOT(n0OlO);
	wire_niilO_dataout <= wire_nilll_dataout AND NOT(n0OlO);
	wire_niiOi_dataout <= wire_nillO_dataout AND NOT(n0OlO);
	wire_niiOl_dataout <= wire_nilOi_dataout AND NOT(n0OlO);
	wire_niiOO_dataout <= wire_nilOl_dataout AND NOT(n0OlO);
	wire_nil0i_dataout <= wire_niO1O_dataout AND NOT(n0OlO);
	wire_nil0l_dataout <= wire_niO0i_dataout AND NOT(n0OlO);
	wire_nil0O_dataout <= wire_niO0l_dataout AND NOT(n0OlO);
	wire_nil10i_dataout <= nil00i WHEN rate = '1'  ELSE nil01O;
	wire_nil10l_dataout <= (nil0ii OR nil1il) WHEN rate = '1'  ELSE (nil00O OR niiOlO);
	wire_nil11i_dataout <= ni0llO WHEN nlil11i = '1'  ELSE niOlil;
	wire_nil11l_dataout <= niOO1O OR rate;
	wire_nil11O_dataout <= nil00O AND NOT(rate);
	wire_nil1i_dataout <= wire_nilOO_dataout AND NOT(n0OlO);
	wire_nil1l_dataout <= wire_niO1i_dataout AND NOT(n0OlO);
	wire_nil1O_dataout <= wire_niO1l_dataout AND NOT(n0OlO);
	wire_nilii_dataout <= wire_niO0O_dataout AND NOT(n0OlO);
	wire_nilil_dataout <= n0llO OR nliO00i;
	wire_niliO_dataout <= n0lOi OR nliO00l;
	wire_nilli_dataout <= n0lOl OR nliO00O;
	wire_nillii_dataout <= wire_nilO1O_dataout AND NOT(nili1l);
	wire_nillil_dataout <= wire_nilO0i_dataout AND NOT(nili1l);
	wire_nilliO_dataout <= wire_nilO0l_dataout AND NOT(nili1l);
	wire_nilll_dataout <= n0lOO OR nliO0ii;
	wire_nillli_dataout <= wire_nilO0O_dataout AND NOT(nili1l);
	wire_nillll_dataout <= wire_nilOii_dataout AND NOT(nili1l);
	wire_nilllO_dataout <= wire_nilOil_dataout AND NOT(nili1l);
	wire_nillO_dataout <= n0O1i OR nliO0il;
	wire_nillOi_dataout <= wire_nilOiO_dataout AND NOT(nili1l);
	wire_nillOl_dataout <= wire_nilOli_dataout AND NOT(nili1l);
	wire_nillOO_dataout <= wire_nilOll_dataout AND NOT(nili1l);
	wire_nilO0i_dataout <= nil1il OR nlil10l;
	wire_nilO0l_dataout <= wire_nilOOl_o(0) WHEN nili0l = '1'  ELSE nil1iO;
	wire_nilO0O_dataout <= wire_nilOOl_o(1) WHEN nili0l = '1'  ELSE nil1li;
	wire_nilO1i_dataout <= wire_nilOlO_dataout AND NOT(nili1l);
	wire_nilO1l_dataout <= wire_nilOOi_dataout AND NOT(nili1l);
	wire_nilO1O_dataout <= niiOlO OR nlil10i;
	wire_nilOi_dataout <= wire_niOii_o(0) WHEN n0OOO = '1'  ELSE n0O1l;
	wire_nilOii_dataout <= wire_nilOOl_o(2) WHEN nili0l = '1'  ELSE nil1ll;
	wire_nilOil_dataout <= wire_nilOOl_o(3) WHEN nili0l = '1'  ELSE nil1lO;
	wire_nilOiO_dataout <= wire_nilOOl_o(4) WHEN nili0l = '1'  ELSE nil1Oi;
	wire_nilOl_dataout <= wire_niOii_o(1) WHEN n0OOO = '1'  ELSE n0O1O;
	wire_nilOli_dataout <= wire_nilOOl_o(5) WHEN nili0l = '1'  ELSE nil1Ol;
	wire_nilOll_dataout <= wire_nilOOl_o(6) WHEN nili0l = '1'  ELSE nil1OO;
	wire_nilOlO_dataout <= wire_nilOOl_o(7) WHEN nili0l = '1'  ELSE nil01i;
	wire_nilOO_dataout <= wire_niOii_o(2) WHEN n0OOO = '1'  ELSE n0O0i;
	wire_nilOOi_dataout <= wire_nilOOl_o(8) WHEN nili0l = '1'  ELSE nil01l;
	wire_nilOOO_dataout <= wire_niO1Ol_dataout AND NOT(nili1O);
	wire_niO00i_dataout <= wire_niO0Oi_o(0) WHEN nili0O = '1'  ELSE nil0il;
	wire_niO00l_dataout <= wire_niO0Oi_o(1) WHEN nili0O = '1'  ELSE nil0iO;
	wire_niO00O_dataout <= wire_niO0Oi_o(2) WHEN nili0O = '1'  ELSE nil0li;
	wire_niO01i_dataout <= nil00l OR nlil1il;
	wire_niO01l_dataout <= nil00O OR nlil1iO;
	wire_niO01O_dataout <= nil0ii OR nlil1li;
	wire_niO0i_dataout <= wire_niOii_o(6) WHEN n0OOO = '1'  ELSE n0Oil;
	wire_niO0ii_dataout <= wire_niO0Oi_o(3) WHEN nili0O = '1'  ELSE nil0ll;
	wire_niO0il_dataout <= wire_niO0Oi_o(4) WHEN nili0O = '1'  ELSE nil0lO;
	wire_niO0iO_dataout <= wire_niO0Oi_o(5) WHEN nili0O = '1'  ELSE nil0Oi;
	wire_niO0l_dataout <= wire_niOii_o(7) WHEN n0OOO = '1'  ELSE n0OiO;
	wire_niO0li_dataout <= wire_niO0Oi_o(6) WHEN nili0O = '1'  ELSE nil0Ol;
	wire_niO0ll_dataout <= wire_niO0Oi_o(7) WHEN nili0O = '1'  ELSE nil0OO;
	wire_niO0lO_dataout <= wire_niO0Oi_o(8) WHEN nili0O = '1'  ELSE nili1i;
	wire_niO0O_dataout <= wire_niOii_o(8) WHEN n0OOO = '1'  ELSE n0Oli;
	wire_niO10i_dataout <= wire_niO01O_dataout AND NOT(nili1O);
	wire_niO10l_dataout <= wire_niO00i_dataout AND NOT(nili1O);
	wire_niO10O_dataout <= wire_niO00l_dataout AND NOT(nili1O);
	wire_niO11i_dataout <= wire_niO1OO_dataout AND NOT(nili1O);
	wire_niO11l_dataout <= wire_niO01i_dataout AND NOT(nili1O);
	wire_niO11O_dataout <= wire_niO01l_dataout AND NOT(nili1O);
	wire_niO1i_dataout <= wire_niOii_o(3) WHEN n0OOO = '1'  ELSE n0O0l;
	wire_niO1ii_dataout <= wire_niO00O_dataout AND NOT(nili1O);
	wire_niO1il_dataout <= wire_niO0ii_dataout AND NOT(nili1O);
	wire_niO1iO_dataout <= wire_niO0il_dataout AND NOT(nili1O);
	wire_niO1l_dataout <= wire_niOii_o(4) WHEN n0OOO = '1'  ELSE n0O0O;
	wire_niO1li_dataout <= wire_niO0iO_dataout AND NOT(nili1O);
	wire_niO1ll_dataout <= wire_niO0li_dataout AND NOT(nili1O);
	wire_niO1lO_dataout <= wire_niO0ll_dataout AND NOT(nili1O);
	wire_niO1O_dataout <= wire_niOii_o(5) WHEN n0OOO = '1'  ELSE n0Oii;
	wire_niO1Oi_dataout <= wire_niO0lO_dataout AND NOT(nili1O);
	wire_niO1Ol_dataout <= nil01O OR nlil10O;
	wire_niO1OO_dataout <= nil00i OR nlil1ii;
	wire_niOi0i_dataout <= wire_niOiil_o(3) AND NOT(nili1l);
	wire_niOi0l_dataout <= wire_niOiil_o(4) AND NOT(nili1l);
	wire_niOi0O_dataout <= wire_niOiil_o(5) AND NOT(nili1l);
	wire_niOi1i_dataout <= wire_niOiil_o(0) AND NOT(nili1l);
	wire_niOi1l_dataout <= wire_niOiil_o(1) AND NOT(nili1l);
	wire_niOi1O_dataout <= wire_niOiil_o(2) AND NOT(nili1l);
	wire_niOiii_dataout <= wire_niOiil_o(6) AND NOT(nili1l);
	wire_niOiiO_dataout <= wire_niOl1i_o(0) AND NOT(nili1O);
	wire_niOili_dataout <= wire_niOl1i_o(1) AND NOT(nili1O);
	wire_niOill_dataout <= wire_niOl1i_o(2) AND NOT(nili1O);
	wire_niOilO_dataout <= wire_niOl1i_o(3) AND NOT(nili1O);
	wire_niOiOi_dataout <= wire_niOl1i_o(4) AND NOT(nili1O);
	wire_niOiOl_dataout <= wire_niOl1i_o(5) AND NOT(nili1O);
	wire_niOiOO_dataout <= wire_niOl1i_o(6) AND NOT(nili1O);
	wire_niOl0i_dataout <= niOlil AND enable_inf_ei(3);
	wire_niOl0l_dataout <= nii01l AND enable_inf_ei(2);
	wire_niOl0O_dataout <= ni0llO AND enable_inf_ei(1);
	wire_niOl1l_dataout <= nii01l AND enable_inf_ei(5);
	wire_niOl1O_dataout <= ni0llO AND enable_inf_ei(4);
	wire_niOli_dataout <= wire_nl11l_o(0) AND NOT(n0Oll);
	wire_niOlii_dataout <= niOlil AND enable_inf_ei(0);
	wire_niOliO_dataout <= ((wire_niOl1O_dataout OR wire_niOl1l_dataout) OR wire_niOl0i_dataout) WHEN rate = '1'  ELSE ((wire_niOl0O_dataout OR wire_niOl0l_dataout) OR wire_niOlii_dataout);
	wire_niOll_dataout <= wire_nl11l_o(1) AND NOT(n0Oll);
	wire_niOlO_dataout <= wire_nl11l_o(2) AND NOT(n0Oll);
	wire_niOOi_dataout <= wire_nl11l_o(3) AND NOT(n0Oll);
	wire_niOOl_dataout <= wire_nl11l_o(4) AND NOT(n0Oll);
	wire_niOOO_dataout <= wire_nl11l_o(5) AND NOT(n0Oll);
	wire_niOOOl_dataout <= wire_nliii_w_lg_nl111i1164w(0) WHEN (nl110l XOR nl110i) = '1'  ELSE nl111i;
	wire_nl00i_dataout <= (((wire_nl1lO_dataout OR wire_nl1ll_dataout) OR (NOT (nliOi1l6 XOR nliOi1l5))) OR wire_nl1Oi_dataout) WHEN rate = '1'  ELSE (((wire_nl1OO_dataout OR wire_nl1Ol_dataout) OR (NOT (nliOi0i4 XOR nliOi0i3))) OR wire_nl01i_dataout);
	wire_nl01i_dataout <= nl01O AND enable_inf_ei(0);
	wire_nl0ill_dataout <= wire_nl0ilO_dataout AND NOT(nlil00l);
	wire_nl0ilO_dataout <= wire_nl0iOi_dataout OR (wire_w_lg_nlil0Oi930w(0) AND wire_w_lg_w_lg_nlil0lO913w931w(0));
	wire_nl0iOi_dataout <= wire_nl0iOl_dataout OR (wire_w_lg_nlil0lO913w(0) AND ((wire_nl01l_w_lg_w_lg_w_lg_w_lg_nl0i1O915w917w919w920w(0) OR (wire_nl01l_w_lg_w_lg_nl0i1O922w923w(0) AND wire_nl01l_w_lg_nl00OO918w(0))) OR wire_nl01l_w_lg_w_lg_w_lg_nl0i1O922w926w927w(0)));
	wire_nl0iOl_dataout <= wire_nl0iOO_dataout OR (wire_w_lg_nlil0lO913w(0) AND nlil1OO);
	wire_nl0iOO_dataout <= nl00ll OR (wire_nl0lii_o AND (((nlil0iO XOR nl00Ol) OR (nlil00O XOR nl00lO)) OR (NOT (nl00Ol XOR nl00lO))));
	wire_nl0O0i_dataout <= wire_nl0Oil_dataout OR nlil00l;
	wire_nl0O0l_dataout <= wire_nl0OiO_dataout WHEN wire_w_lg_nlil01i877w(0) = '1'  ELSE nl00OO;
	wire_nl0O0O_dataout <= wire_nl0Oli_dataout WHEN wire_w_lg_nlil01i877w(0) = '1'  ELSE nl0i1i;
	wire_nl0O1i_dataout <= wire_nl0O0l_dataout OR nlil00l;
	wire_nl0O1l_dataout <= wire_nl0O0O_dataout AND NOT(nlil00l);
	wire_nl0O1O_dataout <= wire_nl0Oii_dataout OR nlil00l;
	wire_nl0Oii_dataout <= wire_nl0Oll_dataout WHEN wire_w_lg_nlil01i877w(0) = '1'  ELSE nl0i1l;
	wire_nl0Oil_dataout <= wire_nl0OlO_dataout WHEN wire_w_lg_nlil01i877w(0) = '1'  ELSE nl0i1O;
	wire_nl0OiO_dataout <= wire_nl0OOi_o(1) AND nlil01l;
	wire_nl0Oli_dataout <= wire_nl0OOi_o(2) AND nlil01l;
	wire_nl0Oll_dataout <= wire_nl0OOi_o(3) AND nlil01l;
	wire_nl0OlO_dataout <= wire_nl0OOi_o(4) AND nlil01l;
	wire_nl10i_dataout <= wire_nl1li_o(1) AND NOT(n0OlO);
	wire_nl10l_dataout <= wire_nl1li_o(2) AND NOT(n0OlO);
	wire_nl10O_dataout <= wire_nl1li_o(3) AND NOT(n0OlO);
	wire_nl11i_dataout <= wire_nl11l_o(6) AND NOT(n0Oll);
	wire_nl11il_dataout <= wire_nlO0lO_w_lg_nl110O1160w(0) WHEN (wire_w_lg_nlil1ll1161w(0) AND (rxupdatefc XOR nl11ii)) = '1'  ELSE nl110O;
	wire_nl11ll_dataout <= nl11ii WHEN nlil1ll = '1'  ELSE rxupdatefc;
	wire_nl11O_dataout <= wire_nl1li_o(0) AND NOT(n0OlO);
	wire_nl1ii_dataout <= wire_nl1li_o(4) AND NOT(n0OlO);
	wire_nl1il_dataout <= wire_nl1li_o(5) AND NOT(n0OlO);
	wire_nl1iO_dataout <= wire_nl1li_o(6) AND NOT(n0OlO);
	wire_nl1ll_dataout <= n1lll AND enable_inf_ei(5);
	wire_nl1lO_dataout <= n100O AND enable_inf_ei(4);
	wire_nl1O0O_dataout <= nl1OOO OR wire_nliii_w_lg_nlO10l946w(0);
	wire_nl1Oi_dataout <= nl01O AND enable_inf_ei(3);
	wire_nl1Oii_dataout <= wire_nl1Oll_dataout AND NOT(nl1O1i);
	wire_nl1Oil_dataout <= wire_nl1OlO_dataout OR nl1O1i;
	wire_nl1OiO_dataout <= wire_nl1OOi_dataout AND NOT(nl1O1i);
	wire_nl1Ol_dataout <= n1lll AND enable_inf_ei(2);
	wire_nl1Oli_dataout <= wire_nl1OOl_dataout AND NOT(nl1O1i);
	wire_nl1Oll_dataout <= nl1lOi AND NOT(nlO10l);
	wire_nl1OlO_dataout <= nl1lOl AND NOT(nlO10l);
	wire_nl1OO_dataout <= n100O AND enable_inf_ei(1);
	wire_nl1OOi_dataout <= nl1lOO OR nlO10l;
	wire_nl1OOl_dataout <= nl1OOO AND NOT(nlO10l);
	wire_nli00i_dataout <= nl1OOO WHEN nlili0i = '1'  ELSE nllOll;
	wire_nli00l_dataout <= nlO10O OR rate;
	wire_nli00O_dataout <= nliiiO AND NOT(rate);
	wire_nli0ii_dataout <= nliiii WHEN rate = '1'  ELSE nlii0O;
	wire_nli0il_dataout <= (nliili OR nli0ll) WHEN rate = '1'  ELSE (nliiiO OR nli1OO);
	wire_nliOill_dataout <= wire_nliii_w_lg_nliOiOi4386w(0) WHEN (nliOl1l XOR nliOl1i) = '1'  ELSE nliOiOi;
	wire_nliOl0l_dataout <= wire_nlO0lO_w_lg_nliOl1O4382w(0) WHEN (wire_w_lg_nli1i0O4383w(0) AND (rxupdatefc XOR nliOl0i)) = '1'  ELSE nliOl1O;
	wire_nliOli_dataout <= wire_nll10O_dataout AND NOT(nlil0l);
	wire_nliOlil_dataout <= nliOl0i WHEN nli1i0O = '1'  ELSE rxupdatefc;
	wire_nliOll_dataout <= wire_nll1ii_dataout AND NOT(nlil0l);
	wire_nliOlO_dataout <= wire_nll1il_dataout AND NOT(nlil0l);
	wire_nliOOi_dataout <= wire_nll1iO_dataout AND NOT(nlil0l);
	wire_nliOOl_dataout <= wire_nll1li_dataout AND NOT(nlil0l);
	wire_nliOOO_dataout <= wire_nll1ll_dataout AND NOT(nlil0l);
	wire_nll00i_dataout <= wire_nlli1O_dataout AND NOT(nlil0O);
	wire_nll00l_dataout <= wire_nlli0i_dataout AND NOT(nlil0O);
	wire_nll00O_dataout <= wire_nlli0l_dataout AND NOT(nlil0O);
	wire_nll00Oi_dataout <= wire_nll0i1l_dataout OR nli1iOO;
	wire_nll00Ol_dataout <= wire_nll0i1O_dataout AND NOT(nli1iOO);
	wire_nll00OO_dataout <= wire_nll0i0i_dataout OR nli1iOO;
	wire_nll01i_dataout <= wire_nll01l_o(8) WHEN nlilil = '1'  ELSE nlii0l;
	wire_nll01il_dataout <= wire_nll01iO_dataout AND NOT(nli1iOO);
	wire_nll01iO_dataout <= wire_nll01li_dataout OR (wire_w_lg_nli1lil4151w(0) AND wire_w_lg_w_lg_nli1lii4134w4152w(0));
	wire_nll01li_dataout <= wire_nll01ll_dataout OR (wire_w_lg_nli1lii4134w(0) AND ((wire_nl01l_w_lg_w_lg_w_lg_w_lg_nll1OOO4136w4138w4140w4141w(0) OR (wire_nl01l_w_lg_w_lg_nll1OOO4143w4144w(0) AND wire_nl01l_w_lg_nll1OlO4139w(0))) OR wire_nl01l_w_lg_w_lg_w_lg_nll1OOO4143w4147w4148w(0)));
	wire_nll01ll_dataout <= wire_nll01lO_dataout OR (wire_w_lg_nli1lii4134w(0) AND nli1ili);
	wire_nll01lO_dataout <= nll1Oil OR (wire_nll000i_o AND (((nli1l0i XOR nll1Oll) OR (nli1l1i XOR nll1OiO)) OR (NOT (nll1Oll XOR nll1OiO))));
	wire_nll01O_dataout <= wire_nlli1l_dataout AND NOT(nlil0O);
	wire_nll0i0i_dataout <= wire_nll0iil_dataout WHEN wire_w_lg_nli1ill4098w(0) = '1'  ELSE nll1OOl;
	wire_nll0i0l_dataout <= wire_nll0iiO_dataout WHEN wire_w_lg_nli1ill4098w(0) = '1'  ELSE nll1OOO;
	wire_nll0i0O_dataout <= wire_nll0ili_o(1) AND nli1ilO;
	wire_nll0i1i_dataout <= wire_nll0i0l_dataout OR nli1iOO;
	wire_nll0i1l_dataout <= wire_nll0i0O_dataout WHEN wire_w_lg_nli1ill4098w(0) = '1'  ELSE nll1OlO;
	wire_nll0i1O_dataout <= wire_nll0iii_dataout WHEN wire_w_lg_nli1ill4098w(0) = '1'  ELSE nll1OOi;
	wire_nll0ii_dataout <= wire_nlli0O_dataout AND NOT(nlil0O);
	wire_nll0iii_dataout <= wire_nll0ili_o(2) AND nli1ilO;
	wire_nll0iil_dataout <= wire_nll0ili_o(3) AND nli1ilO;
	wire_nll0iiO_dataout <= wire_nll0ili_o(4) AND nli1ilO;
	wire_nll0il_dataout <= wire_nlliii_dataout AND NOT(nlil0O);
	wire_nll0iO_dataout <= wire_nlliil_dataout AND NOT(nlil0O);
	wire_nll0li_dataout <= wire_nlliiO_dataout AND NOT(nlil0O);
	wire_nll0ll_dataout <= wire_nllili_dataout AND NOT(nlil0O);
	wire_nll0lO_dataout <= wire_nllill_dataout AND NOT(nlil0O);
	wire_nll0O0i_dataout <= nlli10i WHEN rate = '1'  ELSE nlli11O;
	wire_nll0O0l_dataout <= (nlli1ii OR nll0Oil) WHEN rate = '1'  ELSE (nlli10O OR nll0llO);
	wire_nll0O1i_dataout <= nll1ilO WHEN nli1lOl = '1'  ELSE nllliil;
	wire_nll0O1l_dataout <= nllll1O OR rate;
	wire_nll0O1O_dataout <= nlli10O AND NOT(rate);
	wire_nll0Oi_dataout <= wire_nllilO_dataout AND NOT(nlil0O);
	wire_nll0Ol_dataout <= wire_nlliOi_dataout AND NOT(nlil0O);
	wire_nll0OO_dataout <= wire_nlliOl_dataout AND NOT(nlil0O);
	wire_nll10i_dataout <= wire_nll1OO_dataout AND NOT(nlil0l);
	wire_nll10l_dataout <= wire_nll01i_dataout AND NOT(nlil0l);
	wire_nll10O_dataout <= nli1OO OR nliliii;
	wire_nll11i_dataout <= wire_nll1lO_dataout AND NOT(nlil0l);
	wire_nll11l_dataout <= wire_nll1Oi_dataout AND NOT(nlil0l);
	wire_nll11O_dataout <= wire_nll1Ol_dataout AND NOT(nlil0l);
	wire_nll1i0i_dataout <= wire_nll1iil_dataout AND NOT(nll10Oi);
	wire_nll1i0l_dataout <= wire_nll1iiO_dataout OR nll10Oi;
	wire_nll1i0O_dataout <= wire_nll1ili_dataout AND NOT(nll10Oi);
	wire_nll1i1O_dataout <= nll1ilO OR wire_nliii_w_lg_nllll1l4168w(0);
	wire_nll1ii_dataout <= nli0ll OR nliliil;
	wire_nll1iii_dataout <= wire_nll1ill_dataout AND NOT(nll10Oi);
	wire_nll1iil_dataout <= nll10li AND NOT(nllll1l);
	wire_nll1iiO_dataout <= nll10ll AND NOT(nllll1l);
	wire_nll1il_dataout <= wire_nll01l_o(0) WHEN nlilil = '1'  ELSE nli0lO;
	wire_nll1ili_dataout <= nll10lO OR nllll1l;
	wire_nll1ill_dataout <= nll1ilO AND NOT(nllll1l);
	wire_nll1iO_dataout <= wire_nll01l_o(1) WHEN nlilil = '1'  ELSE nli0Oi;
	wire_nll1li_dataout <= wire_nll01l_o(2) WHEN nlilil = '1'  ELSE nli0Ol;
	wire_nll1ll_dataout <= wire_nll01l_o(3) WHEN nlilil = '1'  ELSE nli0OO;
	wire_nll1lO_dataout <= wire_nll01l_o(4) WHEN nlilil = '1'  ELSE nlii1i;
	wire_nll1Oi_dataout <= wire_nll01l_o(5) WHEN nlilil = '1'  ELSE nlii1l;
	wire_nll1Ol_dataout <= wire_nll01l_o(6) WHEN nlilil = '1'  ELSE nlii1O;
	wire_nll1OO_dataout <= wire_nll01l_o(7) WHEN nlilil = '1'  ELSE nlii0i;
	wire_nlli0i_dataout <= nliiil OR nlilill;
	wire_nlli0l_dataout <= nliiiO OR nlililO;
	wire_nlli0O_dataout <= nliili OR nliliOi;
	wire_nlli1i_dataout <= wire_nlliOO_dataout AND NOT(nlil0O);
	wire_nlli1l_dataout <= nlii0O OR nliliiO;
	wire_nlli1O_dataout <= nliiii OR nlilili;
	wire_nlliii_dataout <= wire_nlll1i_o(0) WHEN nliliO = '1'  ELSE nliill;
	wire_nlliiii_dataout <= wire_nllil1O_dataout AND NOT(nlli01l);
	wire_nlliiil_dataout <= wire_nllil0i_dataout AND NOT(nlli01l);
	wire_nlliiiO_dataout <= wire_nllil0l_dataout AND NOT(nlli01l);
	wire_nlliil_dataout <= wire_nlll1i_o(1) WHEN nliliO = '1'  ELSE nliilO;
	wire_nlliili_dataout <= wire_nllil0O_dataout AND NOT(nlli01l);
	wire_nlliill_dataout <= wire_nllilii_dataout AND NOT(nlli01l);
	wire_nlliilO_dataout <= wire_nllilil_dataout AND NOT(nlli01l);
	wire_nlliiO_dataout <= wire_nlll1i_o(2) WHEN nliliO = '1'  ELSE nliiOi;
	wire_nlliiOi_dataout <= wire_nlliliO_dataout AND NOT(nlli01l);
	wire_nlliiOl_dataout <= wire_nllilli_dataout AND NOT(nlli01l);
	wire_nlliiOO_dataout <= wire_nllilll_dataout AND NOT(nlli01l);
	wire_nllil0i_dataout <= nll0Oil OR nli1O1O;
	wire_nllil0l_dataout <= wire_nllilOl_o(0) WHEN nlli00l = '1'  ELSE nll0OiO;
	wire_nllil0O_dataout <= wire_nllilOl_o(1) WHEN nlli00l = '1'  ELSE nll0Oli;
	wire_nllil1i_dataout <= wire_nllillO_dataout AND NOT(nlli01l);
	wire_nllil1l_dataout <= wire_nllilOi_dataout AND NOT(nlli01l);
	wire_nllil1O_dataout <= nll0llO OR nli1O1l;
	wire_nllili_dataout <= wire_nlll1i_o(3) WHEN nliliO = '1'  ELSE nliiOl;
	wire_nllilii_dataout <= wire_nllilOl_o(2) WHEN nlli00l = '1'  ELSE nll0Oll;
	wire_nllilil_dataout <= wire_nllilOl_o(3) WHEN nlli00l = '1'  ELSE nll0OlO;
	wire_nlliliO_dataout <= wire_nllilOl_o(4) WHEN nlli00l = '1'  ELSE nll0OOi;
	wire_nllill_dataout <= wire_nlll1i_o(4) WHEN nliliO = '1'  ELSE nliiOO;
	wire_nllilli_dataout <= wire_nllilOl_o(5) WHEN nlli00l = '1'  ELSE nll0OOl;
	wire_nllilll_dataout <= wire_nllilOl_o(6) WHEN nlli00l = '1'  ELSE nll0OOO;
	wire_nllillO_dataout <= wire_nllilOl_o(7) WHEN nlli00l = '1'  ELSE nlli11i;
	wire_nllilO_dataout <= wire_nlll1i_o(5) WHEN nliliO = '1'  ELSE nlil1i;
	wire_nllilOi_dataout <= wire_nllilOl_o(8) WHEN nlli00l = '1'  ELSE nlli11l;
	wire_nllilOO_dataout <= wire_nlliOOl_dataout AND NOT(nlli01O);
	wire_nlliO0i_dataout <= wire_nlll11O_dataout AND NOT(nlli01O);
	wire_nlliO0l_dataout <= wire_nlll10i_dataout AND NOT(nlli01O);
	wire_nlliO0O_dataout <= wire_nlll10l_dataout AND NOT(nlli01O);
	wire_nlliO1i_dataout <= wire_nlliOOO_dataout AND NOT(nlli01O);
	wire_nlliO1l_dataout <= wire_nlll11i_dataout AND NOT(nlli01O);
	wire_nlliO1O_dataout <= wire_nlll11l_dataout AND NOT(nlli01O);
	wire_nlliOi_dataout <= wire_nlll1i_o(6) WHEN nliliO = '1'  ELSE nlil1l;
	wire_nlliOii_dataout <= wire_nlll10O_dataout AND NOT(nlli01O);
	wire_nlliOil_dataout <= wire_nlll1ii_dataout AND NOT(nlli01O);
	wire_nlliOiO_dataout <= wire_nlll1il_dataout AND NOT(nlli01O);
	wire_nlliOl_dataout <= wire_nlll1i_o(7) WHEN nliliO = '1'  ELSE nlil1O;
	wire_nlliOli_dataout <= wire_nlll1iO_dataout AND NOT(nlli01O);
	wire_nlliOll_dataout <= wire_nlll1li_dataout AND NOT(nlli01O);
	wire_nlliOlO_dataout <= wire_nlll1ll_dataout AND NOT(nlli01O);
	wire_nlliOO_dataout <= wire_nlll1i_o(8) WHEN nliliO = '1'  ELSE nlil0i;
	wire_nlliOOi_dataout <= wire_nlll1lO_dataout AND NOT(nlli01O);
	wire_nlliOOl_dataout <= nlli11O OR nli1O0i;
	wire_nlliOOO_dataout <= nlli10i OR nli1O0l;
	wire_nlll00i_dataout <= wire_nlll0il_o(3) AND NOT(nlli01l);
	wire_nlll00l_dataout <= wire_nlll0il_o(4) AND NOT(nlli01l);
	wire_nlll00O_dataout <= wire_nlll0il_o(5) AND NOT(nlli01l);
	wire_nlll01i_dataout <= wire_nlll0il_o(0) AND NOT(nlli01l);
	wire_nlll01l_dataout <= wire_nlll0il_o(1) AND NOT(nlli01l);
	wire_nlll01O_dataout <= wire_nlll0il_o(2) AND NOT(nlli01l);
	wire_nlll0i_dataout <= wire_nlllll_o(0) AND NOT(nlil0l);
	wire_nlll0ii_dataout <= wire_nlll0il_o(6) AND NOT(nlli01l);
	wire_nlll0iO_dataout <= wire_nllli1i_o(0) AND NOT(nlli01O);
	wire_nlll0l_dataout <= wire_nlllll_o(1) AND NOT(nlil0l);
	wire_nlll0li_dataout <= wire_nllli1i_o(1) AND NOT(nlli01O);
	wire_nlll0ll_dataout <= wire_nllli1i_o(2) AND NOT(nlli01O);
	wire_nlll0lO_dataout <= wire_nllli1i_o(3) AND NOT(nlli01O);
	wire_nlll0O_dataout <= wire_nlllll_o(2) AND NOT(nlil0l);
	wire_nlll0Oi_dataout <= wire_nllli1i_o(4) AND NOT(nlli01O);
	wire_nlll0Ol_dataout <= wire_nllli1i_o(5) AND NOT(nlli01O);
	wire_nlll0OO_dataout <= wire_nllli1i_o(6) AND NOT(nlli01O);
	wire_nlll10i_dataout <= wire_nlll1Oi_o(0) WHEN nlli00O = '1'  ELSE nlli1il;
	wire_nlll10l_dataout <= wire_nlll1Oi_o(1) WHEN nlli00O = '1'  ELSE nlli1iO;
	wire_nlll10O_dataout <= wire_nlll1Oi_o(2) WHEN nlli00O = '1'  ELSE nlli1li;
	wire_nlll11i_dataout <= nlli10l OR nli1O0O;
	wire_nlll11l_dataout <= nlli10O OR nli1Oii;
	wire_nlll11O_dataout <= nlli1ii OR nli1Oil;
	wire_nlll1ii_dataout <= wire_nlll1Oi_o(3) WHEN nlli00O = '1'  ELSE nlli1ll;
	wire_nlll1il_dataout <= wire_nlll1Oi_o(4) WHEN nlli00O = '1'  ELSE nlli1lO;
	wire_nlll1iO_dataout <= wire_nlll1Oi_o(5) WHEN nlli00O = '1'  ELSE nlli1Oi;
	wire_nlll1li_dataout <= wire_nlll1Oi_o(6) WHEN nlli00O = '1'  ELSE nlli1Ol;
	wire_nlll1ll_dataout <= wire_nlll1Oi_o(7) WHEN nlli00O = '1'  ELSE nlli1OO;
	wire_nlll1lO_dataout <= wire_nlll1Oi_o(8) WHEN nlli00O = '1'  ELSE nlli01i;
	wire_nllli0i_dataout <= nllliil AND enable_inf_ei(3);
	wire_nllli0l_dataout <= nll011l AND enable_inf_ei(2);
	wire_nllli0O_dataout <= nll1ilO AND enable_inf_ei(1);
	wire_nllli1l_dataout <= nll011l AND enable_inf_ei(5);
	wire_nllli1O_dataout <= nll1ilO AND enable_inf_ei(4);
	wire_nlllii_dataout <= wire_nlllll_o(3) AND NOT(nlil0l);
	wire_nllliii_dataout <= nllliil AND enable_inf_ei(0);
	wire_nllliiO_dataout <= ((wire_nllli1O_dataout OR wire_nllli1l_dataout) OR wire_nllli0i_dataout) WHEN rate = '1'  ELSE ((wire_nllli0O_dataout OR wire_nllli0l_dataout) OR wire_nllliii_dataout);
	wire_nlllil_dataout <= wire_nlllll_o(4) AND NOT(nlil0l);
	wire_nllliO_dataout <= wire_nlllll_o(5) AND NOT(nlil0l);
	wire_nlllli_dataout <= wire_nlllll_o(6) AND NOT(nlil0l);
	wire_nllllO_dataout <= wire_nllO0i_o(0) AND NOT(nlil0O);
	wire_nllllOl_dataout <= wire_nliii_w_lg_nlllO1i3849w(0) WHEN (nlllO0l XOR nlllO0i) = '1'  ELSE nlllO1i;
	wire_nlllOi_dataout <= wire_nllO0i_o(1) AND NOT(nlil0O);
	wire_nlllOil_dataout <= wire_nlO0lO_w_lg_nlllO0O3845w(0) WHEN (wire_w_lg_nli1OiO3846w(0) AND (rxupdatefc XOR nlllOii)) = '1'  ELSE nlllO0O;
	wire_nlllOl_dataout <= wire_nllO0i_o(2) AND NOT(nlil0O);
	wire_nlllOll_dataout <= nlllOii WHEN nli1OiO = '1'  ELSE rxupdatefc;
	wire_nlllOO_dataout <= wire_nllO0i_o(3) AND NOT(nlil0O);
	wire_nllO0l_dataout <= nl0i0l AND enable_inf_ei(5);
	wire_nllO0O_dataout <= nl1OOO AND enable_inf_ei(4);
	wire_nllO1i_dataout <= wire_nllO0i_o(4) AND NOT(nlil0O);
	wire_nllO1l_dataout <= wire_nllO0i_o(5) AND NOT(nlil0O);
	wire_nllO1O_dataout <= wire_nllO0i_o(6) AND NOT(nlil0O);
	wire_nllOii_dataout <= nllOll AND enable_inf_ei(3);
	wire_nllOil_dataout <= nl0i0l AND enable_inf_ei(2);
	wire_nllOiO_dataout <= nl1OOO AND enable_inf_ei(1);
	wire_nllOl0O_dataout <= nllOlOO OR wire_nliii_w_lg_nlOiO0l3631w(0);
	wire_nllOli_dataout <= nllOll AND enable_inf_ei(0);
	wire_nllOlii_dataout <= wire_nllOlll_dataout AND NOT(nllOl1i);
	wire_nllOlil_dataout <= wire_nllOllO_dataout OR nllOl1i;
	wire_nllOliO_dataout <= wire_nllOlOi_dataout AND NOT(nllOl1i);
	wire_nllOlli_dataout <= wire_nllOlOl_dataout AND NOT(nllOl1i);
	wire_nllOlll_dataout <= nllOiOi AND NOT(nlOiO0l);
	wire_nllOllO_dataout <= nllOiOl AND NOT(nlOiO0l);
	wire_nllOlO_dataout <= ((wire_nllO0O_dataout OR wire_nllO0l_dataout) OR wire_nllOii_dataout) WHEN rate = '1'  ELSE ((wire_nllOiO_dataout OR wire_nllOil_dataout) OR wire_nllOli_dataout);
	wire_nllOlOi_dataout <= nllOiOO OR nlOiO0l;
	wire_nllOlOl_dataout <= nllOlOO AND NOT(nlOiO0l);
	wire_nlO010i_dataout <= nllOlOO WHEN nli001l = '1'  ELSE nlOilll;
	wire_nlO010l_dataout <= nlOiO0O OR rate;
	wire_nlO010O_dataout <= nlO00iO AND NOT(rate);
	wire_nlO01ii_dataout <= nlO00ii WHEN rate = '1'  ELSE nlO000O;
	wire_nlO01il_dataout <= (nlO00li OR nlO01ll) WHEN rate = '1'  ELSE (nlO00iO OR nlO1OOO);
	wire_nlO01O_dataout <= wire_nliii_w_lg_nlO00l627w(0) WHEN (nlO0li XOR nlO0iO) = '1'  ELSE nlO00l;
	wire_nlO0lli_dataout <= wire_nlO0O0O_dataout AND NOT(nlO0i0l);
	wire_nlO0lll_dataout <= wire_nlO0Oii_dataout AND NOT(nlO0i0l);
	wire_nlO0llO_dataout <= wire_nlO0Oil_dataout AND NOT(nlO0i0l);
	wire_nlO0lOi_dataout <= wire_nlO0OiO_dataout AND NOT(nlO0i0l);
	wire_nlO0lOl_dataout <= wire_nlO0Oli_dataout AND NOT(nlO0i0l);
	wire_nlO0lOO_dataout <= wire_nlO0Oll_dataout AND NOT(nlO0i0l);
	wire_nlO0O0i_dataout <= wire_nlO0OOO_dataout AND NOT(nlO0i0l);
	wire_nlO0O0l_dataout <= wire_nlOi11i_dataout AND NOT(nlO0i0l);
	wire_nlO0O0O_dataout <= nlO1OOO OR nli000l;
	wire_nlO0O1i_dataout <= wire_nlO0OlO_dataout AND NOT(nlO0i0l);
	wire_nlO0O1l_dataout <= wire_nlO0OOi_dataout AND NOT(nlO0i0l);
	wire_nlO0O1O_dataout <= wire_nlO0OOl_dataout AND NOT(nlO0i0l);
	wire_nlO0Oii_dataout <= nlO01ll OR nli000O;
	wire_nlO0Oil_dataout <= wire_nlOi11l_o(0) WHEN nlO0iil = '1'  ELSE nlO01lO;
	wire_nlO0OiO_dataout <= wire_nlOi11l_o(1) WHEN nlO0iil = '1'  ELSE nlO01Oi;
	wire_nlO0Ol_dataout <= wire_nlO0lO_w_lg_nlO0ll619w(0) WHEN (wire_w_lg_nlill1O620w(0) AND (rxupdatefc XOR nlO0Oi)) = '1'  ELSE nlO0ll;
	wire_nlO0Oli_dataout <= wire_nlOi11l_o(2) WHEN nlO0iil = '1'  ELSE nlO01Ol;
	wire_nlO0Oll_dataout <= wire_nlOi11l_o(3) WHEN nlO0iil = '1'  ELSE nlO01OO;
	wire_nlO0OlO_dataout <= wire_nlOi11l_o(4) WHEN nlO0iil = '1'  ELSE nlO001i;
	wire_nlO0OOi_dataout <= wire_nlOi11l_o(5) WHEN nlO0iil = '1'  ELSE nlO001l;
	wire_nlO0OOl_dataout <= wire_nlOi11l_o(6) WHEN nlO0iil = '1'  ELSE nlO001O;
	wire_nlO0OOO_dataout <= wire_nlOi11l_o(7) WHEN nlO0iil = '1'  ELSE nlO000i;
	wire_nlO10ll_dataout <= wire_nlO10lO_dataout AND NOT(nli011O);
	wire_nlO10lO_dataout <= wire_nlO10Oi_dataout OR (wire_w_lg_nli01ll3615w(0) AND wire_w_lg_w_lg_nli01li3598w3616w(0));
	wire_nlO10Oi_dataout <= wire_nlO10Ol_dataout OR (wire_w_lg_nli01li3598w(0) AND ((wire_nl01l_w_lg_w_lg_w_lg_w_lg_nlO101O3600w3602w3604w3605w(0) OR (wire_nl01l_w_lg_w_lg_nlO101O3607w3608w(0) AND wire_nl01l_w_lg_nlO11OO3603w(0))) OR wire_nl01l_w_lg_w_lg_w_lg_nlO101O3607w3611w3612w(0)));
	wire_nlO10Ol_dataout <= wire_nlO10OO_dataout OR (wire_w_lg_nli01li3598w(0) AND nli1OOi);
	wire_nlO10OO_dataout <= nlO11ll OR (wire_nlO1iii_o AND (((nli01ii XOR nlO11Ol) OR (nli010i XOR nlO11lO)) OR (NOT (nlO11Ol XOR nlO11lO))));
	wire_nlO1l0i_dataout <= wire_nlO1lil_dataout OR nli011O;
	wire_nlO1l0l_dataout <= wire_nlO1liO_dataout WHEN wire_w_lg_nli1OOl3562w(0) = '1'  ELSE nlO11OO;
	wire_nlO1l0O_dataout <= wire_nlO1lli_dataout WHEN wire_w_lg_nli1OOl3562w(0) = '1'  ELSE nlO101i;
	wire_nlO1l1i_dataout <= wire_nlO1l0l_dataout OR nli011O;
	wire_nlO1l1l_dataout <= wire_nlO1l0O_dataout AND NOT(nli011O);
	wire_nlO1l1O_dataout <= wire_nlO1lii_dataout OR nli011O;
	wire_nlO1lii_dataout <= wire_nlO1lll_dataout WHEN wire_w_lg_nli1OOl3562w(0) = '1'  ELSE nlO101l;
	wire_nlO1lil_dataout <= wire_nlO1llO_dataout WHEN wire_w_lg_nli1OOl3562w(0) = '1'  ELSE nlO101O;
	wire_nlO1liO_dataout <= wire_nlO1lOi_o(1) AND nli1OOO;
	wire_nlO1lli_dataout <= wire_nlO1lOi_o(2) AND nli1OOO;
	wire_nlO1lll_dataout <= wire_nlO1lOi_o(3) AND nli1OOO;
	wire_nlO1llO_dataout <= wire_nlO1lOi_o(4) AND nli1OOO;
	wire_nlOi00i_dataout <= nlO00il OR nli00iO;
	wire_nlOi00l_dataout <= nlO00iO OR nli00li;
	wire_nlOi00O_dataout <= nlO00li OR nli00ll;
	wire_nlOi01i_dataout <= wire_nlOi0OO_dataout AND NOT(nlO0i0O);
	wire_nlOi01l_dataout <= nlO000O OR nli00ii;
	wire_nlOi01O_dataout <= nlO00ii OR nli00il;
	wire_nlOi0ii_dataout <= wire_nlOii1i_o(0) WHEN nlO0iiO = '1'  ELSE nlO00ll;
	wire_nlOi0il_dataout <= wire_nlOii1i_o(1) WHEN nlO0iiO = '1'  ELSE nlO00lO;
	wire_nlOi0iO_dataout <= wire_nlOii1i_o(2) WHEN nlO0iiO = '1'  ELSE nlO00Oi;
	wire_nlOi0li_dataout <= wire_nlOii1i_o(3) WHEN nlO0iiO = '1'  ELSE nlO00Ol;
	wire_nlOi0ll_dataout <= wire_nlOii1i_o(4) WHEN nlO0iiO = '1'  ELSE nlO00OO;
	wire_nlOi0lO_dataout <= wire_nlOii1i_o(5) WHEN nlO0iiO = '1'  ELSE nlO0i1i;
	wire_nlOi0Oi_dataout <= wire_nlOii1i_o(6) WHEN nlO0iiO = '1'  ELSE nlO0i1l;
	wire_nlOi0Ol_dataout <= wire_nlOii1i_o(7) WHEN nlO0iiO = '1'  ELSE nlO0i1O;
	wire_nlOi0OO_dataout <= wire_nlOii1i_o(8) WHEN nlO0iiO = '1'  ELSE nlO0i0i;
	wire_nlOi10i_dataout <= wire_nlOi01O_dataout AND NOT(nlO0i0O);
	wire_nlOi10l_dataout <= wire_nlOi00i_dataout AND NOT(nlO0i0O);
	wire_nlOi10O_dataout <= wire_nlOi00l_dataout AND NOT(nlO0i0O);
	wire_nlOi11i_dataout <= wire_nlOi11l_o(8) WHEN nlO0iil = '1'  ELSE nlO000l;
	wire_nlOi11O_dataout <= wire_nlOi01l_dataout AND NOT(nlO0i0O);
	wire_nlOi1ii_dataout <= wire_nlOi00O_dataout AND NOT(nlO0i0O);
	wire_nlOi1il_dataout <= wire_nlOi0ii_dataout AND NOT(nlO0i0O);
	wire_nlOi1iO_dataout <= wire_nlOi0il_dataout AND NOT(nlO0i0O);
	wire_nlOi1l_dataout <= nlO0Oi WHEN nlill1O = '1'  ELSE rxupdatefc;
	wire_nlOi1li_dataout <= wire_nlOi0iO_dataout AND NOT(nlO0i0O);
	wire_nlOi1ll_dataout <= wire_nlOi0li_dataout AND NOT(nlO0i0O);
	wire_nlOi1lO_dataout <= wire_nlOi0ll_dataout AND NOT(nlO0i0O);
	wire_nlOi1Oi_dataout <= wire_nlOi0lO_dataout AND NOT(nlO0i0O);
	wire_nlOi1Ol_dataout <= wire_nlOi0Oi_dataout AND NOT(nlO0i0O);
	wire_nlOi1OO_dataout <= wire_nlOi0Ol_dataout AND NOT(nlO0i0O);
	wire_nlOii0i_dataout <= wire_nlOiill_o(0) AND NOT(nlO0i0l);
	wire_nlOii0l_dataout <= wire_nlOiill_o(1) AND NOT(nlO0i0l);
	wire_nlOii0O_dataout <= wire_nlOiill_o(2) AND NOT(nlO0i0l);
	wire_nlOiiii_dataout <= wire_nlOiill_o(3) AND NOT(nlO0i0l);
	wire_nlOiiil_dataout <= wire_nlOiill_o(4) AND NOT(nlO0i0l);
	wire_nlOiiiO_dataout <= wire_nlOiill_o(5) AND NOT(nlO0i0l);
	wire_nlOiili_dataout <= wire_nlOiill_o(6) AND NOT(nlO0i0l);
	wire_nlOiilO_dataout <= wire_nlOil0i_o(0) AND NOT(nlO0i0O);
	wire_nlOiiOi_dataout <= wire_nlOil0i_o(1) AND NOT(nlO0i0O);
	wire_nlOiiOl_dataout <= wire_nlOil0i_o(2) AND NOT(nlO0i0O);
	wire_nlOiiOO_dataout <= wire_nlOil0i_o(3) AND NOT(nlO0i0O);
	wire_nlOil0l_dataout <= nlO100l AND enable_inf_ei(5);
	wire_nlOil0O_dataout <= nllOlOO AND enable_inf_ei(4);
	wire_nlOil1i_dataout <= wire_nlOil0i_o(4) AND NOT(nlO0i0O);
	wire_nlOil1l_dataout <= wire_nlOil0i_o(5) AND NOT(nlO0i0O);
	wire_nlOil1O_dataout <= wire_nlOil0i_o(6) AND NOT(nlO0i0O);
	wire_nlOilii_dataout <= nlOilll AND enable_inf_ei(3);
	wire_nlOilil_dataout <= nlO100l AND enable_inf_ei(2);
	wire_nlOiliO_dataout <= nllOlOO AND enable_inf_ei(1);
	wire_nlOilli_dataout <= nlOilll AND enable_inf_ei(0);
	wire_nlOillO_dataout <= ((wire_nlOil0O_dataout OR wire_nlOil0l_dataout) OR wire_nlOilii_dataout) WHEN rate = '1'  ELSE ((wire_nlOiliO_dataout OR wire_nlOilil_dataout) OR wire_nlOilli_dataout);
	wire_nlOl11l_dataout <= wire_nliii_w_lg_nlOl10i3313w(0) WHEN (nlOl1il XOR nlOl1ii) = '1'  ELSE nlOl10i;
	wire_nlOl1ll_dataout <= wire_nlO0lO_w_lg_nlOl1iO3309w(0) WHEN (wire_w_lg_nli00lO3310w(0) AND (rxupdatefc XOR nlOl1li)) = '1'  ELSE nlOl1iO;
	wire_nlOl1Ol_dataout <= nlOl1li WHEN nli00lO = '1'  ELSE rxupdatefc;
	wire_nlOlOiO_dataout <= nlOO11O OR wire_nliii_w_lg_n1i1il3095w(0);
	wire_nlOlOli_dataout <= wire_nlOlOOl_dataout AND NOT(nlOlO0i);
	wire_nlOlOll_dataout <= wire_nlOlOOO_dataout OR nlOlO0i;
	wire_nlOlOlO_dataout <= wire_nlOO11i_dataout AND NOT(nlOlO0i);
	wire_nlOlOOi_dataout <= wire_nlOO11l_dataout AND NOT(nlOlO0i);
	wire_nlOlOOl_dataout <= nlOlO1i AND NOT(n1i1il);
	wire_nlOlOOO_dataout <= nlOlO1l AND NOT(n1i1il);
	wire_nlOO11i_dataout <= nlOlO1O OR n1i1il;
	wire_nlOO11l_dataout <= nlOO11O AND NOT(n1i1il);
	wire_nlOOiOl_dataout <= wire_nlOOiOO_dataout AND NOT(nli0iii);
	wire_nlOOiOO_dataout <= wire_nlOOl1i_dataout OR (wire_w_lg_nli0iOO3077w(0) AND wire_w_lg_w_lg_nli0iOl3060w3078w(0));
	wire_nlOOl1i_dataout <= wire_nlOOl1l_dataout OR (wire_w_lg_nli0iOl3060w(0) AND ((wire_nl01l_w_lg_w_lg_w_lg_w_lg_nlOOi0O3062w3064w3066w3067w(0) OR (wire_nl01l_w_lg_w_lg_nlOOi0O3069w3070w(0) AND wire_nl01l_w_lg_nlOOi1O3065w(0))) OR wire_nl01l_w_lg_w_lg_w_lg_nlOOi0O3069w3073w3074w(0)));
	wire_nlOOl1l_dataout <= wire_nlOOl1O_dataout OR (wire_w_lg_nli0iOl3060w(0) AND nli0i1l);
	wire_nlOOl1O_dataout <= nlOO0Ol OR (wire_nlOOlli_o AND (((nli0ill XOR nlOOi1l) OR (nli0iil XOR nlOO0OO)) OR (NOT (nlOOi1l XOR nlOO0OO))));
	wire_nlOOO0i_dataout <= wire_nlOOOil_dataout OR nli0iii;
	wire_nlOOO0l_dataout <= wire_nlOOOiO_dataout AND NOT(nli0iii);
	wire_nlOOO0O_dataout <= wire_nlOOOli_dataout OR nli0iii;
	wire_nlOOOii_dataout <= wire_nlOOOll_dataout OR nli0iii;
	wire_nlOOOil_dataout <= wire_nlOOOlO_dataout WHEN wire_w_lg_nli0i1O3024w(0) = '1'  ELSE nlOOi1O;
	wire_nlOOOiO_dataout <= wire_nlOOOOi_dataout WHEN wire_w_lg_nli0i1O3024w(0) = '1'  ELSE nlOOi0i;
	wire_nlOOOli_dataout <= wire_nlOOOOl_dataout WHEN wire_w_lg_nli0i1O3024w(0) = '1'  ELSE nlOOi0l;
	wire_nlOOOll_dataout <= wire_nlOOOOO_dataout WHEN wire_w_lg_nli0i1O3024w(0) = '1'  ELSE nlOOi0O;
	wire_nlOOOlO_dataout <= wire_n1111i_o(1) AND nli0i0i;
	wire_nlOOOOi_dataout <= wire_n1111i_o(2) AND nli0i0i;
	wire_nlOOOOl_dataout <= wire_n1111i_o(3) AND nli0i0i;
	wire_nlOOOOO_dataout <= wire_n1111i_o(4) AND nli0i0i;
	wire_n000i_a <= ( n1liO & n1lil & n1lii & n1l0O & "1");
	wire_n000i_b <= ( "1" & "1" & "1" & "0" & "1");
	n000i :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 5,
		width_b => 5,
		width_o => 5
	  )
	  PORT MAP ( 
		a => wire_n000i_a,
		b => wire_n000i_b,
		cin => wire_gnd,
		o => wire_n000i_o
	  );
	wire_n0011l_a <= ( n011ii & n0110O & n0110l & n0110i & n0111O & n0111l & n0111i);
	wire_n0011l_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "1");
	n0011l :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 7,
		width_b => 7,
		width_o => 7
	  )
	  PORT MAP ( 
		a => wire_n0011l_a,
		b => wire_n0011l_b,
		cin => wire_gnd,
		o => wire_n0011l_o
	  );
	wire_n001li_a <= ( n011Ol & n011Oi & n011lO & n011ll & n011li & n011iO & n011il);
	wire_n001li_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "1");
	n001li :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 7,
		width_b => 7,
		width_o => 7
	  )
	  PORT MAP ( 
		a => wire_n001li_a,
		b => wire_n001li_b,
		cin => wire_gnd,
		o => wire_n001li_o
	  );
	wire_n01iil_a <= ( n1Olll & n1Olli & n1OliO & n1Olil & n1Olii & n1Ol0O & n1Ol0l & n1Ol0i & n1Ol1O);
	wire_n01iil_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "1");
	n01iil :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 9,
		width_b => 9,
		width_o => 9
	  )
	  PORT MAP ( 
		a => wire_n01iil_a,
		b => wire_n01iil_b,
		cin => wire_gnd,
		o => wire_n01iil_o
	  );
	wire_n01Oii_a <= ( n1OOli & n1OOiO & n1OOil & n1OOii & n1OO0O & n1OO0l & n1OO0i & n1OO1O & n1OO1l);
	wire_n01Oii_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "1");
	n01Oii :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 9,
		width_b => 9,
		width_o => 9
	  )
	  PORT MAP ( 
		a => wire_n01Oii_a,
		b => wire_n01Oii_b,
		cin => wire_gnd,
		o => wire_n01Oii_o
	  );
	wire_n0liii_a <= ( n0iOlO & n0iOll & n0iOli & n0iOiO & "1");
	wire_n0liii_b <= ( "1" & "1" & "1" & "0" & "1");
	n0liii :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 5,
		width_b => 5,
		width_o => 5
	  )
	  PORT MAP ( 
		a => wire_n0liii_a,
		b => wire_n0liii_b,
		cin => wire_gnd,
		o => wire_n0liii_o
	  );
	wire_n0Olll_a <= ( n0lOOl & n0lOOi & n0lOlO & n0lOll & n0lOli & n0lOiO & n0lOil & n0lOii & n0lO0O);
	wire_n0Olll_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "1");
	n0Olll :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 9,
		width_b => 9,
		width_o => 9
	  )
	  PORT MAP ( 
		a => wire_n0Olll_a,
		b => wire_n0Olll_b,
		cin => wire_gnd,
		o => wire_n0Olll_o
	  );
	wire_n1000l_a <= ( n11iil & n11iii & n11i0O & n11i0l & n11i0i & n11i1O & n11i1l & n11i1i & n110OO);
	wire_n1000l_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "1");
	n1000l :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 9,
		width_b => 9,
		width_o => 9
	  )
	  PORT MAP ( 
		a => wire_n1000l_a,
		b => wire_n1000l_b,
		cin => wire_gnd,
		o => wire_n1000l_o
	  );
	wire_n10l0i_a <= ( n11lii & n11l0O & n11l0l & n11l0i & n11l1O & n11l1l & n11l1i & n11iOO & n11iOl);
	wire_n10l0i_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "1");
	n10l0i :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 9,
		width_b => 9,
		width_o => 9
	  )
	  PORT MAP ( 
		a => wire_n10l0i_a,
		b => wire_n10l0i_b,
		cin => wire_gnd,
		o => wire_n10l0i_o
	  );
	wire_n10lOl_a <= ( n11O0i & n11O1O & n11O1l & n11O1i & n11lOO & n11lOl & n11lOi);
	wire_n10lOl_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "1");
	n10lOl :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 7,
		width_b => 7,
		width_o => 7
	  )
	  PORT MAP ( 
		a => wire_n10lOl_a,
		b => wire_n10lOl_b,
		cin => wire_gnd,
		o => wire_n10lOl_o
	  );
	wire_n10Oii_a <= ( n11Oll & n11Oli & n11OiO & n11Oil & n11Oii & n11O0O & n11O0l);
	wire_n10Oii_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "1");
	n10Oii :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 7,
		width_b => 7,
		width_o => 7
	  )
	  PORT MAP ( 
		a => wire_n10Oii_a,
		b => wire_n10Oii_b,
		cin => wire_gnd,
		o => wire_n10Oii_o
	  );
	wire_n1111i_a <= ( nlOOi0O & nlOOi0l & nlOOi0i & nlOOi1O & "1");
	wire_n1111i_b <= ( "1" & "1" & "1" & "0" & "1");
	n1111i :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 5,
		width_b => 5,
		width_o => 5
	  )
	  PORT MAP ( 
		a => wire_n1111i_a,
		b => wire_n1111i_b,
		cin => wire_gnd,
		o => wire_n1111i_o
	  );
	wire_n1O00i_a <= ( n1lliO & n1llil & n1llii & n1ll0O & "1");
	wire_n1O00i_b <= ( "1" & "1" & "1" & "0" & "1");
	n1O00i :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 5,
		width_b => 5,
		width_o => 5
	  )
	  PORT MAP ( 
		a => wire_n1O00i_a,
		b => wire_n1O00i_b,
		cin => wire_gnd,
		o => wire_n1O00i_o
	  );
	wire_ni100l_a <= ( n0O0li & n0O0iO & n0O0il & n0O0ii & n0O00O & n0O00l & n0O00i);
	wire_ni100l_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "1");
	ni100l :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 7,
		width_b => 7,
		width_o => 7
	  )
	  PORT MAP ( 
		a => wire_ni100l_a,
		b => wire_ni100l_b,
		cin => wire_gnd,
		o => wire_ni100l_o
	  );
	wire_ni10Oi_a <= ( n0Oi1l & n0Oi1i & n0O0OO & n0O0Ol & n0O0Oi & n0O0lO & n0O0ll);
	wire_ni10Oi_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "1");
	ni10Oi :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 7,
		width_b => 7,
		width_o => 7
	  )
	  PORT MAP ( 
		a => wire_ni10Oi_a,
		b => wire_ni10Oi_b,
		cin => wire_gnd,
		o => wire_ni10Oi_o
	  );
	wire_ni11li_a <= ( n0O1Oi & n0O1lO & n0O1ll & n0O1li & n0O1iO & n0O1il & n0O1ii & n0O10O & n0O10l);
	wire_ni11li_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "1");
	ni11li :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 9,
		width_b => 9,
		width_o => 9
	  )
	  PORT MAP ( 
		a => wire_ni11li_a,
		b => wire_ni11li_b,
		cin => wire_gnd,
		o => wire_ni11li_o
	  );
	wire_niiil_a <= ( n0lll & n0lli & n0liO & n0lil & n0lii & n0l0O & wire_nliO01O24_w_lg_w_lg_q161w162w & n0l0i & n0l1O);
	wire_niiil_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "1");
	niiil :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 9,
		width_b => 9,
		width_o => 9
	  )
	  PORT MAP ( 
		a => wire_niiil_a,
		b => wire_niiil_b,
		cin => wire_gnd,
		o => wire_niiil_o
	  );
	wire_niilli_a <= ( nii1OO & nii1Ol & nii1Oi & nii1lO & "1");
	wire_niilli_b <= ( "1" & "1" & "1" & "0" & "1");
	niilli :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 5,
		width_b => 5,
		width_o => 5
	  )
	  PORT MAP ( 
		a => wire_niilli_a,
		b => wire_niilli_b,
		cin => wire_gnd,
		o => wire_niilli_o
	  );
	wire_nilOOl_a <= ( nil01l & nil01i & nil1OO & nil1Ol & nil1Oi & nil1lO & nil1ll & nil1li & nil1iO);
	wire_nilOOl_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "1");
	nilOOl :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 9,
		width_b => 9,
		width_o => 9
	  )
	  PORT MAP ( 
		a => wire_nilOOl_a,
		b => wire_nilOOl_b,
		cin => wire_gnd,
		o => wire_nilOOl_o
	  );
	wire_niO0Oi_a <= ( nili1i & nil0OO & nil0Ol & nil0Oi & nil0lO & nil0ll & nil0li & nil0iO & nil0il);
	wire_niO0Oi_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "1");
	niO0Oi :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 9,
		width_b => 9,
		width_o => 9
	  )
	  PORT MAP ( 
		a => wire_niO0Oi_a,
		b => wire_niO0Oi_b,
		cin => wire_gnd,
		o => wire_niO0Oi_o
	  );
	wire_niOii_a <= ( n0Oli & n0OiO & n0Oil & n0Oii & wire_nliO0iO22_w_lg_w_lg_q123w124w & wire_nliO0li20_w_lg_w_lg_q120w121w & n0O0i & n0O1O & n0O1l);
	wire_niOii_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "1");
	niOii :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 9,
		width_b => 9,
		width_o => 9
	  )
	  PORT MAP ( 
		a => wire_niOii_a,
		b => wire_niOii_b,
		cin => wire_gnd,
		o => wire_niOii_o
	  );
	wire_niOiil_a <= ( niliOi & nililO & nilill & nilili & niliiO & niliil & niliii);
	wire_niOiil_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "1");
	niOiil :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 7,
		width_b => 7,
		width_o => 7
	  )
	  PORT MAP ( 
		a => wire_niOiil_a,
		b => wire_niOiil_b,
		cin => wire_gnd,
		o => wire_niOiil_o
	  );
	wire_niOl1i_a <= ( nill0l & nill0i & nill1O & nill1l & nill1i & niliOO & niliOl);
	wire_niOl1i_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "1");
	niOl1i :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 7,
		width_b => 7,
		width_o => 7
	  )
	  PORT MAP ( 
		a => wire_niOl1i_a,
		b => wire_niOl1i_b,
		cin => wire_gnd,
		o => wire_niOl1i_o
	  );
	wire_nl0OOi_a <= ( nl0i1O & nl0i1l & nl0i1i & nl00OO & "1");
	wire_nl0OOi_b <= ( "1" & "1" & "1" & "0" & "1");
	nl0OOi :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 5,
		width_b => 5,
		width_o => 5
	  )
	  PORT MAP ( 
		a => wire_nl0OOi_a,
		b => wire_nl0OOi_b,
		cin => wire_gnd,
		o => wire_nl0OOi_o
	  );
	wire_nl11l_a <= ( wire_nliO0ll18_w_lg_w_lg_q91w92w & ni10O & ni10l & ni10i & wire_nliO0lO16_w_lg_w_lg_q85w86w & ni11l & ni11i);
	wire_nl11l_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "1");
	nl11l :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 7,
		width_b => 7,
		width_o => 7
	  )
	  PORT MAP ( 
		a => wire_nl11l_a,
		b => wire_nl11l_b,
		cin => wire_gnd,
		o => wire_nl11l_o
	  );
	wire_nl1li_a <= ( ni1Ol & ni1Oi & ni1lO & wire_nliO0Oi14_w_lg_w_lg_q54w55w & ni1li & wire_nliO0Ol12_w_lg_w_lg_q50w51w & wire_nliO0OO10_w_lg_w_lg_q46w47w);
	wire_nl1li_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "1");
	nl1li :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 7,
		width_b => 7,
		width_o => 7
	  )
	  PORT MAP ( 
		a => wire_nl1li_a,
		b => wire_nl1li_b,
		cin => wire_gnd,
		o => wire_nl1li_o
	  );
	wire_nll01l_a <= ( nlii0l & nlii0i & nlii1O & nlii1l & nlii1i & nli0OO & nli0Ol & nli0Oi & nli0lO);
	wire_nll01l_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "1");
	nll01l :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 9,
		width_b => 9,
		width_o => 9
	  )
	  PORT MAP ( 
		a => wire_nll01l_a,
		b => wire_nll01l_b,
		cin => wire_gnd,
		o => wire_nll01l_o
	  );
	wire_nll0ili_a <= ( nll1OOO & nll1OOl & nll1OOi & nll1OlO & "1");
	wire_nll0ili_b <= ( "1" & "1" & "1" & "0" & "1");
	nll0ili :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 5,
		width_b => 5,
		width_o => 5
	  )
	  PORT MAP ( 
		a => wire_nll0ili_a,
		b => wire_nll0ili_b,
		cin => wire_gnd,
		o => wire_nll0ili_o
	  );
	wire_nllilOl_a <= ( nlli11l & nlli11i & nll0OOO & nll0OOl & nll0OOi & nll0OlO & nll0Oll & nll0Oli & nll0OiO);
	wire_nllilOl_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "1");
	nllilOl :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 9,
		width_b => 9,
		width_o => 9
	  )
	  PORT MAP ( 
		a => wire_nllilOl_a,
		b => wire_nllilOl_b,
		cin => wire_gnd,
		o => wire_nllilOl_o
	  );
	wire_nlll0il_a <= ( nlli0Oi & nlli0lO & nlli0ll & nlli0li & nlli0iO & nlli0il & nlli0ii);
	wire_nlll0il_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "1");
	nlll0il :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 7,
		width_b => 7,
		width_o => 7
	  )
	  PORT MAP ( 
		a => wire_nlll0il_a,
		b => wire_nlll0il_b,
		cin => wire_gnd,
		o => wire_nlll0il_o
	  );
	wire_nlll1i_a <= ( nlil0i & nlil1O & nlil1l & nlil1i & nliiOO & nliiOl & nliiOi & nliilO & nliill);
	wire_nlll1i_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "1");
	nlll1i :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 9,
		width_b => 9,
		width_o => 9
	  )
	  PORT MAP ( 
		a => wire_nlll1i_a,
		b => wire_nlll1i_b,
		cin => wire_gnd,
		o => wire_nlll1i_o
	  );
	wire_nlll1Oi_a <= ( nlli01i & nlli1OO & nlli1Ol & nlli1Oi & nlli1lO & nlli1ll & nlli1li & nlli1iO & nlli1il);
	wire_nlll1Oi_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "1");
	nlll1Oi :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 9,
		width_b => 9,
		width_o => 9
	  )
	  PORT MAP ( 
		a => wire_nlll1Oi_a,
		b => wire_nlll1Oi_b,
		cin => wire_gnd,
		o => wire_nlll1Oi_o
	  );
	wire_nllli1i_a <= ( nllii0l & nllii0i & nllii1O & nllii1l & nllii1i & nlli0OO & nlli0Ol);
	wire_nllli1i_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "1");
	nllli1i :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 7,
		width_b => 7,
		width_o => 7
	  )
	  PORT MAP ( 
		a => wire_nllli1i_a,
		b => wire_nllli1i_b,
		cin => wire_gnd,
		o => wire_nllli1i_o
	  );
	wire_nlllll_a <= ( nliO1i & nlilOO & nlilOl & nlilOi & nlillO & nlilll & nlilli);
	wire_nlllll_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "1");
	nlllll :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 7,
		width_b => 7,
		width_o => 7
	  )
	  PORT MAP ( 
		a => wire_nlllll_a,
		b => wire_nlllll_b,
		cin => wire_gnd,
		o => wire_nlllll_o
	  );
	wire_nllO0i_a <= ( nliOil & nliOii & nliO0O & nliO0l & nliO0i & nliO1O & nliO1l);
	wire_nllO0i_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "1");
	nllO0i :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 7,
		width_b => 7,
		width_o => 7
	  )
	  PORT MAP ( 
		a => wire_nllO0i_a,
		b => wire_nllO0i_b,
		cin => wire_gnd,
		o => wire_nllO0i_o
	  );
	wire_nlO1lOi_a <= ( nlO101O & nlO101l & nlO101i & nlO11OO & "1");
	wire_nlO1lOi_b <= ( "1" & "1" & "1" & "0" & "1");
	nlO1lOi :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 5,
		width_b => 5,
		width_o => 5
	  )
	  PORT MAP ( 
		a => wire_nlO1lOi_a,
		b => wire_nlO1lOi_b,
		cin => wire_gnd,
		o => wire_nlO1lOi_o
	  );
	wire_nlOi11l_a <= ( nlO000l & nlO000i & nlO001O & nlO001l & nlO001i & nlO01OO & nlO01Ol & nlO01Oi & nlO01lO);
	wire_nlOi11l_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "1");
	nlOi11l :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 9,
		width_b => 9,
		width_o => 9
	  )
	  PORT MAP ( 
		a => wire_nlOi11l_a,
		b => wire_nlOi11l_b,
		cin => wire_gnd,
		o => wire_nlOi11l_o
	  );
	wire_nlOii1i_a <= ( nlO0i0i & nlO0i1O & nlO0i1l & nlO0i1i & nlO00OO & nlO00Ol & nlO00Oi & nlO00lO & nlO00ll);
	wire_nlOii1i_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "1");
	nlOii1i :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 9,
		width_b => 9,
		width_o => 9
	  )
	  PORT MAP ( 
		a => wire_nlOii1i_a,
		b => wire_nlOii1i_b,
		cin => wire_gnd,
		o => wire_nlOii1i_o
	  );
	wire_nlOiill_a <= ( nlO0l1i & nlO0iOO & nlO0iOl & nlO0iOi & nlO0ilO & nlO0ill & nlO0ili);
	wire_nlOiill_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "1");
	nlOiill :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 7,
		width_b => 7,
		width_o => 7
	  )
	  PORT MAP ( 
		a => wire_nlOiill_a,
		b => wire_nlOiill_b,
		cin => wire_gnd,
		o => wire_nlOiill_o
	  );
	wire_nlOil0i_a <= ( nlO0lil & nlO0lii & nlO0l0O & nlO0l0l & nlO0l0i & nlO0l1O & nlO0l1l);
	wire_nlOil0i_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "1");
	nlOil0i :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 7,
		width_b => 7,
		width_o => 7
	  )
	  PORT MAP ( 
		a => wire_nlOil0i_a,
		b => wire_nlOil0i_b,
		cin => wire_gnd,
		o => wire_nlOil0i_o
	  );
	wire_n010O_a <= ( n1liO & n1lil & n1lii & n1l0O);
	wire_n010O_b <= ( "1" & "0" & "0" & "1");
	n010O :  oper_less_than
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 4,
		width_b => 4
	  )
	  PORT MAP ( 
		a => wire_n010O_a,
		b => wire_n010O_b,
		cin => wire_vcc,
		o => wire_n010O_o
	  );
	wire_n0l01i_a <= ( n0iOlO & n0iOll & n0iOli & n0iOiO);
	wire_n0l01i_b <= ( "1" & "0" & "0" & "1");
	n0l01i :  oper_less_than
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 4,
		width_b => 4
	  )
	  PORT MAP ( 
		a => wire_n0l01i_a,
		b => wire_n0l01i_b,
		cin => wire_gnd,
		o => wire_n0l01i_o
	  );
	wire_n0l0iO_a <= ( n0iOlO & n0iOll & n0iOli & n0iOiO);
	wire_n0l0iO_b <= ( "1" & "0" & "0" & "1");
	n0l0iO :  oper_less_than
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 4,
		width_b => 4
	  )
	  PORT MAP ( 
		a => wire_n0l0iO_a,
		b => wire_n0l0iO_b,
		cin => wire_vcc,
		o => wire_n0l0iO_o
	  );
	wire_n1lOOi_a <= ( n1lliO & n1llil & n1llii & n1ll0O);
	wire_n1lOOi_b <= ( "1" & "0" & "0" & "1");
	n1lOOi :  oper_less_than
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 4,
		width_b => 4
	  )
	  PORT MAP ( 
		a => wire_n1lOOi_a,
		b => wire_n1lOOi_b,
		cin => wire_gnd,
		o => wire_n1lOOi_o
	  );
	wire_n1O10O_a <= ( n1lliO & n1llil & n1llii & n1ll0O);
	wire_n1O10O_b <= ( "1" & "0" & "0" & "1");
	n1O10O :  oper_less_than
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 4,
		width_b => 4
	  )
	  PORT MAP ( 
		a => wire_n1O10O_a,
		b => wire_n1O10O_b,
		cin => wire_vcc,
		o => wire_n1O10O_o
	  );
	wire_n1OOi_a <= ( n1liO & n1lil & n1lii & n1l0O);
	wire_n1OOi_b <= ( "1" & "0" & "0" & "1");
	n1OOi :  oper_less_than
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 4,
		width_b => 4
	  )
	  PORT MAP ( 
		a => wire_n1OOi_a,
		b => wire_n1OOi_b,
		cin => wire_gnd,
		o => wire_n1OOi_o
	  );
	wire_niii0i_a <= ( nii1OO & nii1Ol & nii1Oi & nii1lO);
	wire_niii0i_b <= ( "1" & "0" & "0" & "1");
	niii0i :  oper_less_than
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 4,
		width_b => 4
	  )
	  PORT MAP ( 
		a => wire_niii0i_a,
		b => wire_niii0i_b,
		cin => wire_gnd,
		o => wire_niii0i_o
	  );
	wire_niiilO_a <= ( nii1OO & nii1Ol & nii1Oi & nii1lO);
	wire_niiilO_b <= ( "1" & "0" & "0" & "1");
	niiilO :  oper_less_than
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 4,
		width_b => 4
	  )
	  PORT MAP ( 
		a => wire_niiilO_a,
		b => wire_niiilO_b,
		cin => wire_vcc,
		o => wire_niiilO_o
	  );
	wire_nl0lii_a <= ( nl0i1O & nl0i1l & nl0i1i & nl00OO);
	wire_nl0lii_b <= ( "1" & "0" & "0" & "1");
	nl0lii :  oper_less_than
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 4,
		width_b => 4
	  )
	  PORT MAP ( 
		a => wire_nl0lii_a,
		b => wire_nl0lii_b,
		cin => wire_gnd,
		o => wire_nl0lii_o
	  );
	wire_nl0lOO_a <= ( nl0i1O & nl0i1l & nl0i1i & nl00OO);
	wire_nl0lOO_b <= ( "1" & "0" & "0" & "1");
	nl0lOO :  oper_less_than
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 4,
		width_b => 4
	  )
	  PORT MAP ( 
		a => wire_nl0lOO_a,
		b => wire_nl0lOO_b,
		cin => wire_vcc,
		o => wire_nl0lOO_o
	  );
	wire_nll000i_a <= ( nll1OOO & nll1OOl & nll1OOi & nll1OlO);
	wire_nll000i_b <= ( "1" & "0" & "0" & "1");
	nll000i :  oper_less_than
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 4,
		width_b => 4
	  )
	  PORT MAP ( 
		a => wire_nll000i_a,
		b => wire_nll000i_b,
		cin => wire_gnd,
		o => wire_nll000i_o
	  );
	wire_nll00lO_a <= ( nll1OOO & nll1OOl & nll1OOi & nll1OlO);
	wire_nll00lO_b <= ( "1" & "0" & "0" & "1");
	nll00lO :  oper_less_than
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 4,
		width_b => 4
	  )
	  PORT MAP ( 
		a => wire_nll00lO_a,
		b => wire_nll00lO_b,
		cin => wire_vcc,
		o => wire_nll00lO_o
	  );
	wire_nlO1iii_a <= ( nlO101O & nlO101l & nlO101i & nlO11OO);
	wire_nlO1iii_b <= ( "1" & "0" & "0" & "1");
	nlO1iii :  oper_less_than
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 4,
		width_b => 4
	  )
	  PORT MAP ( 
		a => wire_nlO1iii_a,
		b => wire_nlO1iii_b,
		cin => wire_gnd,
		o => wire_nlO1iii_o
	  );
	wire_nlO1iOO_a <= ( nlO101O & nlO101l & nlO101i & nlO11OO);
	wire_nlO1iOO_b <= ( "1" & "0" & "0" & "1");
	nlO1iOO :  oper_less_than
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 4,
		width_b => 4
	  )
	  PORT MAP ( 
		a => wire_nlO1iOO_a,
		b => wire_nlO1iOO_b,
		cin => wire_vcc,
		o => wire_nlO1iOO_o
	  );
	wire_nlOOlli_a <= ( nlOOi0O & nlOOi0l & nlOOi0i & nlOOi1O);
	wire_nlOOlli_b <= ( "1" & "0" & "0" & "1");
	nlOOlli :  oper_less_than
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 4,
		width_b => 4
	  )
	  PORT MAP ( 
		a => wire_nlOOlli_a,
		b => wire_nlOOlli_b,
		cin => wire_gnd,
		o => wire_nlOOlli_o
	  );
	wire_nlOOO1O_a <= ( nlOOi0O & nlOOi0l & nlOOi0i & nlOOi1O);
	wire_nlOOO1O_b <= ( "1" & "0" & "0" & "1");
	nlOOO1O :  oper_less_than
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 4,
		width_b => 4
	  )
	  PORT MAP ( 
		a => wire_nlOOO1O_a,
		b => wire_nlOOO1O_b,
		cin => wire_vcc,
		o => wire_nlOOO1O_o
	  );
	wire_n0iii_data <= ( n0i0i & n0i0i & n0i0i & nlO00l & "1" & "1" & "1" & "1");
	wire_n0iii_sel <= ( nl0ll & nl0li & wire_nliO10i36_w_lg_w_lg_q257w258w);
	n0iii :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n0iii_data,
		o => wire_n0iii_o,
		sel => wire_n0iii_sel
	  );
	wire_n0iil_data <= ( wire_n0ill_dataout & nl0Oi & n1iOl & n10Oi & "1" & "1" & "1" & "1");
	wire_n0iil_sel <= ( nl0ll & nl0li & nl0iO);
	n0iil :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n0iil_data,
		o => wire_n0iil_o,
		sel => wire_n0iil_sel
	  );
	wire_n0iiO_data <= ( wire_n0ilO_dataout & wire_n0iOi_dataout & n0lOl & wire_n0iOl_dataout & wire_n0ili_dataout & wire_n0ili_dataout & wire_nliO10l34_w_lg_w_lg_q231w232w & wire_n0ili_dataout);
	wire_n0iiO_sel <= ( nl0ll & wire_nliO10O32_w_lg_w_lg_q225w226w & nl0iO);
	n0iiO :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n0iiO_data,
		o => wire_n0iiO_o,
		sel => wire_n0iiO_sel
	  );
	wire_n0llli_data <= ( n0llii & n0llii & n0llii & n00ili & "1" & "1" & "1" & "1");
	wire_n0llli_sel <= ( ni1iOi & ni1ilO & ni1ill);
	n0llli :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n0llli_data,
		o => wire_n0llli_o,
		sel => wire_n0llli_sel
	  );
	wire_n0llll_data <= ( wire_n0llOl_dataout & ni1iOO & n0iO1l & n0il1i & "1" & "1" & "1" & "1");
	wire_n0llll_sel <= ( ni1iOi & ni1ilO & ni1ill);
	n0llll :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n0llll_data,
		o => wire_n0llll_o,
		sel => wire_n0llll_sel
	  );
	wire_n0lllO_data <= ( wire_n0llOO_dataout & wire_n0lO1i_dataout & n0O11l & wire_n0lO1l_dataout & wire_n0llOi_dataout & wire_n0llOi_dataout & wire_n0llOi_dataout & wire_n0llOi_dataout);
	wire_n0lllO_sel <= ( ni1iOi & ni1ilO & ni1ill);
	n0lllO :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n0lllO_data,
		o => wire_n0lllO_o,
		sel => wire_n0lllO_sel
	  );
	wire_n1100i_data <= ( n1101i & n1101i & n1101i & nlOl10i & "1" & "1" & "1" & "1");
	wire_n1100i_sel <= ( n1i1ii & n1i10O & n1i10l);
	n1100i :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n1100i_data,
		o => wire_n1100i_o,
		sel => wire_n1100i_sel
	  );
	wire_n1100l_data <= ( wire_n110il_dataout & n1i1iO & nlOO0ll & nlOO1li & "1" & "1" & "1" & "1");
	wire_n1100l_sel <= ( n1i1ii & n1i10O & n1i10l);
	n1100l :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n1100l_data,
		o => wire_n1100l_o,
		sel => wire_n1100l_sel
	  );
	wire_n1100O_data <= ( wire_n110iO_dataout & wire_n110li_dataout & n11ill & wire_n110ll_dataout & wire_n110ii_dataout & wire_n110ii_dataout & wire_n110ii_dataout & wire_n110ii_dataout);
	wire_n1100O_sel <= ( n1i1ii & n1i10O & n1i10l);
	n1100O :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n1100O_data,
		o => wire_n1100O_o,
		sel => wire_n1100O_sel
	  );
	wire_n1Oiii_data <= ( n1Oi0i & n1Oi0i & n1Oi0i & n1i0ii & "1" & "1" & "1" & "1");
	wire_n1Oiii_sel <= ( n000li & n000iO & n000il);
	n1Oiii :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n1Oiii_data,
		o => wire_n1Oiii_o,
		sel => wire_n1Oiii_sel
	  );
	wire_n1Oiil_data <= ( wire_n1Oill_dataout & n000lO & n1liOl & n1l0Oi & "1" & "1" & "1" & "1");
	wire_n1Oiil_sel <= ( n000li & n000iO & n000il);
	n1Oiil :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n1Oiil_data,
		o => wire_n1Oiil_o,
		sel => wire_n1Oiil_sel
	  );
	wire_n1OiiO_data <= ( wire_n1OilO_dataout & wire_n1OiOi_dataout & n1OlOl & wire_n1OiOl_dataout & wire_n1Oili_dataout & wire_n1Oili_dataout & wire_n1Oili_dataout & wire_n1Oili_dataout);
	wire_n1OiiO_sel <= ( n000li & n000iO & n000il);
	n1OiiO :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n1OiiO_data,
		o => wire_n1OiiO_o,
		sel => wire_n1OiiO_sel
	  );
	wire_niiOOi_data <= ( niiOli & niiOli & niiOli & ni1lOi & "1" & "1" & "1" & "1");
	wire_niiOOi_sel <= ( niOO1i & niOlOO & niOlOl);
	niiOOi :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_niiOOi_data,
		o => wire_niiOOi_o,
		sel => wire_niiOOi_sel
	  );
	wire_niiOOl_data <= ( wire_nil11l_dataout & niOO1O & nii10l & ni0O0i & "1" & "1" & "1" & "1");
	wire_niiOOl_sel <= ( niOO1i & niOlOO & niOlOl);
	niiOOl :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_niiOOl_data,
		o => wire_niiOOl_o,
		sel => wire_niiOOl_sel
	  );
	wire_niiOOO_data <= ( wire_nil11O_dataout & wire_nil10i_dataout & nil00l & wire_nil10l_dataout & wire_nil11i_dataout & wire_nil11i_dataout & wire_nil11i_dataout & wire_nil11i_dataout);
	wire_niiOOO_sel <= ( niOO1i & niOlOO & niOlOl);
	niiOOO :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_niiOOO_data,
		o => wire_niiOOO_o,
		sel => wire_niiOOO_sel
	  );
	wire_nli01i_data <= ( nli1Oi & nli1Oi & nli1Oi & nl111i & "1" & "1" & "1" & "1");
	wire_nli01i_sel <= ( nlO10i & nlO11O & nlO11l);
	nli01i :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nli01i_data,
		o => wire_nli01i_o,
		sel => wire_nli01i_sel
	  );
	wire_nli01l_data <= ( wire_nli00l_dataout & nlO10O & nl00il & nl01ii & "1" & "1" & "1" & "1");
	wire_nli01l_sel <= ( nlO10i & nlO11O & nlO11l);
	nli01l :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nli01l_data,
		o => wire_nli01l_o,
		sel => wire_nli01l_sel
	  );
	wire_nli01O_data <= ( wire_nli00O_dataout & wire_nli0ii_dataout & nliiil & wire_nli0il_dataout & wire_nli00i_dataout & wire_nli00i_dataout & wire_nli00i_dataout & wire_nli00i_dataout);
	wire_nli01O_sel <= ( nlO10i & nlO11O & nlO11l);
	nli01O :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nli01O_data,
		o => wire_nli01O_o,
		sel => wire_nli01O_sel
	  );
	wire_nll0lOi_data <= ( nll0lli & nll0lli & nll0lli & nliOiOi & "1" & "1" & "1" & "1");
	wire_nll0lOi_sel <= ( nllll1i & nllliOO & nllliOl);
	nll0lOi :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nll0lOi_data,
		o => wire_nll0lOi_o,
		sel => wire_nll0lOi_sel
	  );
	wire_nll0lOl_data <= ( wire_nll0O1l_dataout & nllll1O & nll1O0l & nll1l0i & "1" & "1" & "1" & "1");
	wire_nll0lOl_sel <= ( nllll1i & nllliOO & nllliOl);
	nll0lOl :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nll0lOl_data,
		o => wire_nll0lOl_o,
		sel => wire_nll0lOl_sel
	  );
	wire_nll0lOO_data <= ( wire_nll0O1O_dataout & wire_nll0O0i_dataout & nlli10l & wire_nll0O0l_dataout & wire_nll0O1i_dataout & wire_nll0O1i_dataout & wire_nll0O1i_dataout & wire_nll0O1i_dataout);
	wire_nll0lOO_sel <= ( nllll1i & nllliOO & nllliOl);
	nll0lOO :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nll0lOO_data,
		o => wire_nll0lOO_o,
		sel => wire_nll0lOO_sel
	  );
	wire_nlO011i_data <= ( nlO1OOi & nlO1OOi & nlO1OOi & nlllO1i & "1" & "1" & "1" & "1");
	wire_nlO011i_sel <= ( nlOiO0i & nlOiO1O & nlOiO1l);
	nlO011i :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nlO011i_data,
		o => wire_nlO011i_o,
		sel => wire_nlO011i_sel
	  );
	wire_nlO011l_data <= ( wire_nlO010l_dataout & nlOiO0O & nlO11il & nllOOii & "1" & "1" & "1" & "1");
	wire_nlO011l_sel <= ( nlOiO0i & nlOiO1O & nlOiO1l);
	nlO011l :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nlO011l_data,
		o => wire_nlO011l_o,
		sel => wire_nlO011l_sel
	  );
	wire_nlO011O_data <= ( wire_nlO010O_dataout & wire_nlO01ii_dataout & nlO00il & wire_nlO01il_dataout & wire_nlO010i_dataout & wire_nlO010i_dataout & wire_nlO010i_dataout & wire_nlO010i_dataout);
	wire_nlO011O_sel <= ( nlOiO0i & nlOiO1O & nlOiO1l);
	nlO011O :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nlO011O_data,
		o => wire_nlO011O_o,
		sel => wire_nlO011O_sel
	  );
	wire_n0i0ll_data <= ( wire_n0ii1i_dataout & wire_nliii_w_lg_ni1iOl2019w);
	wire_n0i0ll_sel <= ( n0i0iO & wire_nl01l_w_lg_n0i0iO2046w);
	n0i0ll :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_n0i0ll_data,
		o => wire_n0i0ll_o,
		sel => wire_n0i0ll_sel
	  );
	wire_n0i0lO_data <= ( wire_n0ii1l_dataout & ni1iOl & "0");
	wire_n0i0lO_sel <= ( n0i0iO & n0i0il & n0i0ii);
	n0i0lO :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n0i0lO_data,
		o => wire_n0i0lO_o,
		sel => wire_n0i0lO_sel
	  );
	wire_n0i0Oi_data <= ( wire_n0ii1O_dataout & "0" & ni1iOl);
	wire_n0i0Oi_sel <= ( n0i0iO & n0i0il & n0i0ii);
	n0i0Oi :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n0i0Oi_data,
		o => wire_n0i0Oi_o,
		sel => wire_n0i0Oi_sel
	  );
	wire_n0i0Ol_data <= ( wire_n0ii0i_dataout & wire_n0i0OO_dataout & wire_n0iiil_dataout);
	wire_n0i0Ol_sel <= ( n0i0iO & n0i0il & n0i0ii);
	n0i0Ol :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n0i0Ol_data,
		o => wire_n0i0Ol_o,
		sel => wire_n0i0Ol_sel
	  );
	wire_n11il_data <= ( wire_n11Oi_dataout & wire_nliii_w_lg_nl0lO394w);
	wire_n11il_sel <= ( n110O & wire_nl01l_w_lg_n110O421w);
	n11il :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_n11il_data,
		o => wire_n11il_o,
		sel => wire_n11il_sel
	  );
	wire_n11iO_data <= ( wire_n11Ol_dataout & nl0lO & "0");
	wire_n11iO_sel <= ( n110O & n110l & n110i);
	n11iO :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n11iO_data,
		o => wire_n11iO_o,
		sel => wire_n11iO_sel
	  );
	wire_n11li_data <= ( wire_n11OO_dataout & "0" & nl0lO);
	wire_n11li_sel <= ( n110O & n110l & n110i);
	n11li :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n11li_data,
		o => wire_n11li_o,
		sel => wire_n11li_sel
	  );
	wire_n11ll_data <= ( wire_n101i_dataout & wire_n11lO_dataout & wire_n100l_dataout);
	wire_n11ll_sel <= ( n110O & n110l & n110i);
	n11ll :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n11ll_data,
		o => wire_n11ll_o,
		sel => wire_n11ll_sel
	  );
	wire_n1l1il_data <= ( wire_n1l1Oi_dataout & wire_nliii_w_lg_n000ll2557w);
	wire_n1l1il_sel <= ( n1l10O & wire_nl01l_w_lg_n1l10O2584w);
	n1l1il :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_n1l1il_data,
		o => wire_n1l1il_o,
		sel => wire_n1l1il_sel
	  );
	wire_n1l1iO_data <= ( wire_n1l1Ol_dataout & n000ll & "0");
	wire_n1l1iO_sel <= ( n1l10O & n1l10l & n1l10i);
	n1l1iO :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n1l1iO_data,
		o => wire_n1l1iO_o,
		sel => wire_n1l1iO_sel
	  );
	wire_n1l1li_data <= ( wire_n1l1OO_dataout & "0" & n000ll);
	wire_n1l1li_sel <= ( n1l10O & n1l10l & n1l10i);
	n1l1li :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n1l1li_data,
		o => wire_n1l1li_o,
		sel => wire_n1l1li_sel
	  );
	wire_n1l1ll_data <= ( wire_n1l01i_dataout & wire_n1l1lO_dataout & wire_n1l00l_dataout);
	wire_n1l1ll_sel <= ( n1l10O & n1l10l & n1l10i);
	n1l1ll :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n1l1ll_data,
		o => wire_n1l1ll_o,
		sel => wire_n1l1ll_sel
	  );
	wire_ni0iOl_data <= ( wire_ni0l0i_dataout & wire_nliii_w_lg_niOO1l1483w);
	wire_ni0iOl_sel <= ( ni0ilO & wire_nl01l_w_lg_ni0ilO1510w);
	ni0iOl :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_ni0iOl_data,
		o => wire_ni0iOl_o,
		sel => wire_ni0iOl_sel
	  );
	wire_ni0iOO_data <= ( wire_ni0l0l_dataout & niOO1l & "0");
	wire_ni0iOO_sel <= ( ni0ilO & ni0ill & ni0ili);
	ni0iOO :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_ni0iOO_data,
		o => wire_ni0iOO_o,
		sel => wire_ni0iOO_sel
	  );
	wire_ni0l1i_data <= ( wire_ni0l0O_dataout & "0" & niOO1l);
	wire_ni0l1i_sel <= ( ni0ilO & ni0ill & ni0ili);
	ni0l1i :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_ni0l1i_data,
		o => wire_ni0l1i_o,
		sel => wire_ni0l1i_sel
	  );
	wire_ni0l1l_data <= ( wire_ni0lii_dataout & wire_ni0l1O_dataout & wire_ni0lll_dataout);
	wire_ni0l1l_sel <= ( ni0ilO & ni0ill & ni0ili);
	ni0l1l :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_ni0l1l_data,
		o => wire_ni0l1l_o,
		sel => wire_ni0l1l_sel
	  );
	wire_nl1O0i_data <= ( wire_nl1OiO_dataout & "0" & nlO10l);
	wire_nl1O0i_sel <= ( nl1lOO & nl1lOl & nl1lOi);
	nl1O0i :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl1O0i_data,
		o => wire_nl1O0i_o,
		sel => wire_nl1O0i_sel
	  );
	wire_nl1O0l_data <= ( wire_nl1Oli_dataout & wire_nl1O0O_dataout & wire_nl1OOl_dataout);
	wire_nl1O0l_sel <= ( nl1lOO & nl1lOl & nl1lOi);
	nl1O0l :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl1O0l_data,
		o => wire_nl1O0l_o,
		sel => wire_nl1O0l_sel
	  );
	wire_nl1O1l_data <= ( wire_nl1Oii_dataout & wire_nliii_w_lg_nlO10l946w);
	wire_nl1O1l_sel <= ( nl1lOO & wire_nl01l_w_lg_nl1lOO973w);
	nl1O1l :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nl1O1l_data,
		o => wire_nl1O1l_o,
		sel => wire_nl1O1l_sel
	  );
	wire_nl1O1O_data <= ( wire_nl1Oil_dataout & nlO10l & "0");
	wire_nl1O1O_sel <= ( nl1lOO & nl1lOl & nl1lOi);
	nl1O1O :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl1O1O_data,
		o => wire_nl1O1O_o,
		sel => wire_nl1O1O_sel
	  );
	wire_nll10Ol_data <= ( wire_nll1i0i_dataout & wire_nliii_w_lg_nllll1l4168w);
	wire_nll10Ol_sel <= ( nll10lO & wire_nl01l_w_lg_nll10lO4195w);
	nll10Ol :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nll10Ol_data,
		o => wire_nll10Ol_o,
		sel => wire_nll10Ol_sel
	  );
	wire_nll10OO_data <= ( wire_nll1i0l_dataout & nllll1l & "0");
	wire_nll10OO_sel <= ( nll10lO & nll10ll & nll10li);
	nll10OO :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nll10OO_data,
		o => wire_nll10OO_o,
		sel => wire_nll10OO_sel
	  );
	wire_nll1i1i_data <= ( wire_nll1i0O_dataout & "0" & nllll1l);
	wire_nll1i1i_sel <= ( nll10lO & nll10ll & nll10li);
	nll1i1i :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nll1i1i_data,
		o => wire_nll1i1i_o,
		sel => wire_nll1i1i_sel
	  );
	wire_nll1i1l_data <= ( wire_nll1iii_dataout & wire_nll1i1O_dataout & wire_nll1ill_dataout);
	wire_nll1i1l_sel <= ( nll10lO & nll10ll & nll10li);
	nll1i1l :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nll1i1l_data,
		o => wire_nll1i1l_o,
		sel => wire_nll1i1l_sel
	  );
	wire_nllOl0i_data <= ( wire_nllOliO_dataout & "0" & nlOiO0l);
	wire_nllOl0i_sel <= ( nllOiOO & nllOiOl & nllOiOi);
	nllOl0i :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nllOl0i_data,
		o => wire_nllOl0i_o,
		sel => wire_nllOl0i_sel
	  );
	wire_nllOl0l_data <= ( wire_nllOlli_dataout & wire_nllOl0O_dataout & wire_nllOlOl_dataout);
	wire_nllOl0l_sel <= ( nllOiOO & nllOiOl & nllOiOi);
	nllOl0l :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nllOl0l_data,
		o => wire_nllOl0l_o,
		sel => wire_nllOl0l_sel
	  );
	wire_nllOl1l_data <= ( wire_nllOlii_dataout & wire_nliii_w_lg_nlOiO0l3631w);
	wire_nllOl1l_sel <= ( nllOiOO & wire_nl01l_w_lg_nllOiOO3658w);
	nllOl1l :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nllOl1l_data,
		o => wire_nllOl1l_o,
		sel => wire_nllOl1l_sel
	  );
	wire_nllOl1O_data <= ( wire_nllOlil_dataout & nlOiO0l & "0");
	wire_nllOl1O_sel <= ( nllOiOO & nllOiOl & nllOiOi);
	nllOl1O :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nllOl1O_data,
		o => wire_nllOl1O_o,
		sel => wire_nllOl1O_sel
	  );
	wire_nlOlO0l_data <= ( wire_nlOlOli_dataout & wire_nliii_w_lg_n1i1il3095w);
	wire_nlOlO0l_sel <= ( nlOlO1O & wire_nl01l_w_lg_nlOlO1O3122w);
	nlOlO0l :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nlOlO0l_data,
		o => wire_nlOlO0l_o,
		sel => wire_nlOlO0l_sel
	  );
	wire_nlOlO0O_data <= ( wire_nlOlOll_dataout & n1i1il & "0");
	wire_nlOlO0O_sel <= ( nlOlO1O & nlOlO1l & nlOlO1i);
	nlOlO0O :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nlOlO0O_data,
		o => wire_nlOlO0O_o,
		sel => wire_nlOlO0O_sel
	  );
	wire_nlOlOii_data <= ( wire_nlOlOlO_dataout & "0" & n1i1il);
	wire_nlOlOii_sel <= ( nlOlO1O & nlOlO1l & nlOlO1i);
	nlOlOii :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nlOlOii_data,
		o => wire_nlOlOii_o,
		sel => wire_nlOlOii_sel
	  );
	wire_nlOlOil_data <= ( wire_nlOlOOi_dataout & wire_nlOlOiO_dataout & wire_nlOO11l_dataout);
	wire_nlOlOil_sel <= ( nlOlO1O & nlOlO1l & nlOlO1i);
	nlOlOil :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nlOlOil_data,
		o => wire_nlOlOil_o,
		sel => wire_nlOlOil_sel
	  );

 END RTL; --stratixiv_pciehip_iei_detect
--synopsys translate_on
--VALID FILE
--IP Functional Simulation Model
--VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END


-- Copyright (C) 1991-2009 Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.

-- You may only use these simulation model output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event Altera disclaims all warranties of any kind).


--synopsys translate_off

 LIBRARY sgate;
 USE sgate.sgate_pack.all;

 LIBRARY stratixiv_pcie_hip;
 USE stratixiv_pcie_hip.stratixiv_pcie_hip_components.all;

--synthesis_resources = lut 14773 mux21 63920 oper_add 389 oper_decoder 2 oper_less_than 215 oper_mux 15 oper_selector 352 stratixiv_pciehip_pciexp_dcfiforam 7 stratixiv_pciehip_pciexp_dcram_rtry 1 stratixiv_pciehip_pciexp_dcram_rxvc 2 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  stratixiv_pciehip_pciexp_top_hip IS 
	 PORT 
	 ( 
		 adrd_rcv0	:	OUT  STD_LOGIC_VECTOR (10 DOWNTO 0);
		 adrd_rcv1	:	OUT  STD_LOGIC_VECTOR (10 DOWNTO 0);
		 adrd_rpl	:	OUT  STD_LOGIC_VECTOR (10 DOWNTO 0);
		 adwr_rcv0	:	OUT  STD_LOGIC_VECTOR (10 DOWNTO 0);
		 adwr_rcv1	:	OUT  STD_LOGIC_VECTOR (10 DOWNTO 0);
		 adwr_rpl	:	OUT  STD_LOGIC_VECTOR (10 DOWNTO 0);
		 clr_rxpath	:	OUT  STD_LOGIC;
		 core_clk	:	IN  STD_LOGIC;
		 core_clk_vc0	:	OUT  STD_LOGIC;
		 core_clk_vc1	:	OUT  STD_LOGIC;
		 core_crst	:	IN  STD_LOGIC;
		 core_npor	:	IN  STD_LOGIC;
		 core_rstn	:	IN  STD_LOGIC;
		 core_srst	:	IN  STD_LOGIC;
		 cpl_err	:	IN  STD_LOGIC_VECTOR (6 DOWNTO 0);
		 cpl_pending	:	IN  STD_LOGIC;
		 derr_rcv0	:	IN  STD_LOGIC;
		 derr_rcv1	:	IN  STD_LOGIC;
		 din_rcv0	:	OUT  STD_LOGIC_VECTOR (63 DOWNTO 0);
		 din_rcv1	:	OUT  STD_LOGIC_VECTOR (63 DOWNTO 0);
		 din_rpl	:	OUT  STD_LOGIC_VECTOR (63 DOWNTO 0);
		 dl_ack_phypm	:	OUT  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 dl_ack_req_upfc	:	OUT  STD_LOGIC;
		 dl_ack_snd_upfc	:	OUT  STD_LOGIC;
		 dl_aspm_cr0	:	IN  STD_LOGIC;
		 dl_comclk_reg	:	IN  STD_LOGIC;
		 dl_ctrl_link2	:	IN  STD_LOGIC_VECTOR (12 DOWNTO 0);
		 dl_current_deemp	:	OUT  STD_LOGIC;
		 dl_current_speed	:	OUT  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 dl_data_upfc	:	IN  STD_LOGIC_VECTOR (11 DOWNTO 0);
		 dl_dll_req	:	OUT  STD_LOGIC;
		 dl_err_dll	:	OUT  STD_LOGIC_VECTOR (4 DOWNTO 0);
		 dl_err_phy	:	OUT  STD_LOGIC;
		 dl_hdr_upfc	:	IN  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 dl_inh_dllp	:	IN  STD_LOGIC;
		 dl_link_auto_bdw_status	:	OUT  STD_LOGIC;
		 dl_link_bdw_mng_status	:	OUT  STD_LOGIC;
		 dl_ltssm	:	OUT  STD_LOGIC_VECTOR (4 DOWNTO 0);
		 dl_maxpload_dcr	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 dl_req_phycfg	:	IN  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 dl_req_phypm	:	IN  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 dl_req_upfc	:	IN  STD_LOGIC;
		 dl_req_wake	:	IN  STD_LOGIC;
		 dl_rpbuf_emp	:	OUT  STD_LOGIC;
		 dl_rst_enter_comp_bit	:	OUT  STD_LOGIC;
		 dl_rst_tx_margin_field	:	OUT  STD_LOGIC;
		 dl_rx_ecrcchk	:	IN  STD_LOGIC;
		 dl_rx_typ_pm	:	OUT  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 dl_rx_val_fc	:	OUT  STD_LOGIC;
		 dl_rx_val_pm	:	OUT  STD_LOGIC;
		 dl_snd_upfc	:	IN  STD_LOGIC;
		 dl_tx_ack_pm	:	OUT  STD_LOGIC;
		 dl_tx_req_pm	:	IN  STD_LOGIC;
		 dl_tx_typ_pm	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 dl_txcfg_extsy	:	IN  STD_LOGIC;
		 dl_typ_upfc	:	IN  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 dl_up	:	OUT  STD_LOGIC;
		 dl_vc_ctrl	:	IN  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 dl_vc_status	:	OUT  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 dl_vcid_map	:	IN  STD_LOGIC_VECTOR (23 DOWNTO 0);
		 dl_vcid_upfc	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 dlup_exit	:	OUT  STD_LOGIC;
		 dout_rcv0	:	IN  STD_LOGIC_VECTOR (63 DOWNTO 0);
		 dout_rcv1	:	IN  STD_LOGIC_VECTOR (63 DOWNTO 0);
		 dout_rpl	:	IN  STD_LOGIC_VECTOR (63 DOWNTO 0);
		 eidle_infer_sel	:	OUT  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 ev_128ns	:	OUT  STD_LOGIC;
		 ev_1us	:	OUT  STD_LOGIC;
		 hotrst_exit	:	OUT  STD_LOGIC;
		 int_status	:	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 k_bar	:	IN  STD_LOGIC_VECTOR (227 DOWNTO 0);
		 k_cnt	:	IN  STD_LOGIC_VECTOR (127 DOWNTO 0);
		 k_conf	:	IN  STD_LOGIC_VECTOR (383 DOWNTO 0);
		 k_dev	:	IN  STD_LOGIC_VECTOR (4 DOWNTO 0);
		 k_gbl_hip	:	IN  STD_LOGIC_VECTOR (63 DOWNTO 0);
		 k_hip	:	IN  STD_LOGIC_VECTOR (22 DOWNTO 0);
		 k_port	:	IN  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 k_ptr0	:	IN  STD_LOGIC_VECTOR (43 DOWNTO 0);
		 k_ptr1	:	IN  STD_LOGIC_VECTOR (43 DOWNTO 0);
		 k_rtry	:	IN  STD_LOGIC_VECTOR (10 DOWNTO 0);
		 k_vc0	:	IN  STD_LOGIC_VECTOR (55 DOWNTO 0);
		 k_vc1	:	IN  STD_LOGIC_VECTOR (55 DOWNTO 0);
		 k_vc2	:	IN  STD_LOGIC_VECTOR (55 DOWNTO 0);
		 k_vc3	:	IN  STD_LOGIC_VECTOR (55 DOWNTO 0);
		 k_vc4	:	IN  STD_LOGIC_VECTOR (55 DOWNTO 0);
		 k_vc5	:	IN  STD_LOGIC_VECTOR (55 DOWNTO 0);
		 k_vc6	:	IN  STD_LOGIC_VECTOR (55 DOWNTO 0);
		 k_vc7	:	IN  STD_LOGIC_VECTOR (55 DOWNTO 0);
		 l2_exit	:	OUT  STD_LOGIC;
		 lane_act	:	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 lane_reversal_enable	:	OUT  STD_LOGIC;
		 link_up	:	OUT  STD_LOGIC;
		 lmi_ack	:	OUT  STD_LOGIC;
		 lmi_addr	:	IN  STD_LOGIC_VECTOR (11 DOWNTO 0);
		 lmi_din	:	IN  STD_LOGIC_VECTOR (31 DOWNTO 0);
		 lmi_dout	:	OUT  STD_LOGIC_VECTOR (31 DOWNTO 0);
		 lmi_rden	:	IN  STD_LOGIC;
		 lmi_wren	:	IN  STD_LOGIC;
		 mode	:	IN  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 phy_clk	:	IN  STD_LOGIC;
		 phy_rstn	:	IN  STD_LOGIC;
		 phy_srst	:	IN  STD_LOGIC;
		 phystatus0	:	IN  STD_LOGIC;
		 phystatus1	:	IN  STD_LOGIC;
		 phystatus2	:	IN  STD_LOGIC;
		 phystatus3	:	IN  STD_LOGIC;
		 phystatus4	:	IN  STD_LOGIC;
		 phystatus5	:	IN  STD_LOGIC;
		 phystatus6	:	IN  STD_LOGIC;
		 phystatus7	:	IN  STD_LOGIC;
		 pld_clk	:	IN  STD_LOGIC;
		 pld_rstn	:	IN  STD_LOGIC;
		 pld_srst	:	IN  STD_LOGIC;
		 powerdown0	:	OUT  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 powerdown1	:	OUT  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 powerdown2	:	OUT  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 powerdown3	:	OUT  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 powerdown4	:	OUT  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 powerdown5	:	OUT  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 powerdown6	:	OUT  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 powerdown7	:	OUT  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 prstn	:	OUT  STD_LOGIC;
		 rate	:	OUT  STD_LOGIC;
		 reset_status	:	OUT  STD_LOGIC;
		 rx_bar_dec_vc0	:	OUT  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 rx_bar_dec_vc1	:	OUT  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 rx_be_vc0_0	:	OUT  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 rx_be_vc0_1	:	OUT  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 rx_be_vc1_0	:	OUT  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 rx_be_vc1_1	:	OUT  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 rx_data_vc0_0	:	OUT  STD_LOGIC_VECTOR (63 DOWNTO 0);
		 rx_data_vc0_1	:	OUT  STD_LOGIC_VECTOR (63 DOWNTO 0);
		 rx_data_vc1_0	:	OUT  STD_LOGIC_VECTOR (63 DOWNTO 0);
		 rx_data_vc1_1	:	OUT  STD_LOGIC_VECTOR (63 DOWNTO 0);
		 rx_eop_vc0_0	:	OUT  STD_LOGIC;
		 rx_eop_vc0_1	:	OUT  STD_LOGIC;
		 rx_eop_vc1_0	:	OUT  STD_LOGIC;
		 rx_eop_vc1_1	:	OUT  STD_LOGIC;
		 rx_err_vc0	:	OUT  STD_LOGIC;
		 rx_err_vc1	:	OUT  STD_LOGIC;
		 rx_fifo_empty_vc0	:	OUT  STD_LOGIC;
		 rx_fifo_empty_vc1	:	OUT  STD_LOGIC;
		 rx_fifo_full_vc0	:	OUT  STD_LOGIC;
		 rx_fifo_full_vc1	:	OUT  STD_LOGIC;
		 rx_fifo_rdp0	:	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 rx_fifo_rdp1	:	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 rx_fifo_wrp0	:	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 rx_fifo_wrp1	:	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 rx_mask_vc0	:	IN  STD_LOGIC;
		 rx_mask_vc1	:	IN  STD_LOGIC;
		 rx_ready_vc0	:	IN  STD_LOGIC;
		 rx_ready_vc1	:	IN  STD_LOGIC;
		 rx_sop_vc0_0	:	OUT  STD_LOGIC;
		 rx_sop_vc0_1	:	OUT  STD_LOGIC;
		 rx_sop_vc1_0	:	OUT  STD_LOGIC;
		 rx_sop_vc1_1	:	OUT  STD_LOGIC;
		 rx_valid_vc0	:	OUT  STD_LOGIC;
		 rx_valid_vc1	:	OUT  STD_LOGIC;
		 rxdata0	:	IN  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 rxdata1	:	IN  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 rxdata2	:	IN  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 rxdata3	:	IN  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 rxdata4	:	IN  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 rxdata5	:	IN  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 rxdata6	:	IN  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 rxdata7	:	IN  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 rxdatak0	:	IN  STD_LOGIC;
		 rxdatak1	:	IN  STD_LOGIC;
		 rxdatak2	:	IN  STD_LOGIC;
		 rxdatak3	:	IN  STD_LOGIC;
		 rxdatak4	:	IN  STD_LOGIC;
		 rxdatak5	:	IN  STD_LOGIC;
		 rxdatak6	:	IN  STD_LOGIC;
		 rxdatak7	:	IN  STD_LOGIC;
		 rxelecidle0	:	IN  STD_LOGIC;
		 rxelecidle1	:	IN  STD_LOGIC;
		 rxelecidle2	:	IN  STD_LOGIC;
		 rxelecidle3	:	IN  STD_LOGIC;
		 rxelecidle4	:	IN  STD_LOGIC;
		 rxelecidle5	:	IN  STD_LOGIC;
		 rxelecidle6	:	IN  STD_LOGIC;
		 rxelecidle7	:	IN  STD_LOGIC;
		 rxpolarity0	:	OUT  STD_LOGIC;
		 rxpolarity1	:	OUT  STD_LOGIC;
		 rxpolarity2	:	OUT  STD_LOGIC;
		 rxpolarity3	:	OUT  STD_LOGIC;
		 rxpolarity4	:	OUT  STD_LOGIC;
		 rxpolarity5	:	OUT  STD_LOGIC;
		 rxpolarity6	:	OUT  STD_LOGIC;
		 rxpolarity7	:	OUT  STD_LOGIC;
		 rxstatus0	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 rxstatus1	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 rxstatus2	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 rxstatus3	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 rxstatus4	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 rxstatus5	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 rxstatus6	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 rxstatus7	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 rxvalid0	:	IN  STD_LOGIC;
		 rxvalid1	:	IN  STD_LOGIC;
		 rxvalid2	:	IN  STD_LOGIC;
		 rxvalid3	:	IN  STD_LOGIC;
		 rxvalid4	:	IN  STD_LOGIC;
		 rxvalid5	:	IN  STD_LOGIC;
		 rxvalid6	:	IN  STD_LOGIC;
		 rxvalid7	:	IN  STD_LOGIC;
		 scan_mode	:	IN  STD_LOGIC;
		 serr_out	:	OUT  STD_LOGIC;
		 successful_speed_negotiation_int	:	OUT  STD_LOGIC;
		 swdn_in	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 swdn_wake	:	OUT  STD_LOGIC;
		 swup_hotrst	:	OUT  STD_LOGIC;
		 swup_in	:	IN  STD_LOGIC_VECTOR (6 DOWNTO 0);
		 test_in_hip	:	IN  STD_LOGIC_VECTOR (31 DOWNTO 0);
		 test_out_hip	:	OUT  STD_LOGIC_VECTOR (63 DOWNTO 0);
		 tl_aer_msi_num	:	IN  STD_LOGIC_VECTOR (4 DOWNTO 0);
		 tl_app_inta_ack	:	OUT  STD_LOGIC;
		 tl_app_inta_sts	:	IN  STD_LOGIC;
		 tl_app_msi_ack	:	OUT  STD_LOGIC;
		 tl_app_msi_num	:	IN  STD_LOGIC_VECTOR (4 DOWNTO 0);
		 tl_app_msi_req	:	IN  STD_LOGIC;
		 tl_app_msi_tc	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 tl_cfg_add	:	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 tl_cfg_ctl	:	OUT  STD_LOGIC_VECTOR (31 DOWNTO 0);
		 tl_cfg_ctl_wr	:	OUT  STD_LOGIC;
		 tl_cfg_sts	:	OUT  STD_LOGIC_VECTOR (52 DOWNTO 0);
		 tl_cfg_sts_wr	:	OUT  STD_LOGIC;
		 tl_hpg_ctrler	:	IN  STD_LOGIC_VECTOR (4 DOWNTO 0);
		 tl_pex_msi_num	:	IN  STD_LOGIC_VECTOR (4 DOWNTO 0);
		 tl_pm_auxpwr	:	IN  STD_LOGIC;
		 tl_pm_data	:	IN  STD_LOGIC_VECTOR (9 DOWNTO 0);
		 tl_pm_event	:	IN  STD_LOGIC;
		 tl_pme_to_cr	:	IN  STD_LOGIC;
		 tl_pme_to_sr	:	OUT  STD_LOGIC;
		 tl_slotclk_cfg	:	IN  STD_LOGIC;
		 tx_cred_vc0	:	OUT  STD_LOGIC_VECTOR (35 DOWNTO 0);
		 tx_cred_vc1	:	OUT  STD_LOGIC_VECTOR (35 DOWNTO 0);
		 tx_data_vc0_0	:	IN  STD_LOGIC_VECTOR (63 DOWNTO 0);
		 tx_data_vc0_1	:	IN  STD_LOGIC_VECTOR (63 DOWNTO 0);
		 tx_data_vc1_0	:	IN  STD_LOGIC_VECTOR (63 DOWNTO 0);
		 tx_data_vc1_1	:	IN  STD_LOGIC_VECTOR (63 DOWNTO 0);
		 tx_deemph	:	OUT  STD_LOGIC;
		 tx_eop_vc0_0	:	IN  STD_LOGIC;
		 tx_eop_vc0_1	:	IN  STD_LOGIC;
		 tx_eop_vc1_0	:	IN  STD_LOGIC;
		 tx_eop_vc1_1	:	IN  STD_LOGIC;
		 tx_err_vc0	:	IN  STD_LOGIC;
		 tx_err_vc1	:	IN  STD_LOGIC;
		 tx_fifo_empty_vc0	:	OUT  STD_LOGIC;
		 tx_fifo_empty_vc1	:	OUT  STD_LOGIC;
		 tx_fifo_full_vc0	:	OUT  STD_LOGIC;
		 tx_fifo_full_vc1	:	OUT  STD_LOGIC;
		 tx_fifo_rdp_vc0	:	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 tx_fifo_rdp_vc1	:	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 tx_fifo_wrp_vc0	:	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 tx_fifo_wrp_vc1	:	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 tx_margin	:	OUT  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 tx_ready_vc0	:	OUT  STD_LOGIC;
		 tx_ready_vc1	:	OUT  STD_LOGIC;
		 tx_sop_vc0_0	:	IN  STD_LOGIC;
		 tx_sop_vc0_1	:	IN  STD_LOGIC;
		 tx_sop_vc1_0	:	IN  STD_LOGIC;
		 tx_sop_vc1_1	:	IN  STD_LOGIC;
		 tx_valid_vc0	:	IN  STD_LOGIC;
		 tx_valid_vc1	:	IN  STD_LOGIC;
		 txcompl0	:	OUT  STD_LOGIC;
		 txcompl1	:	OUT  STD_LOGIC;
		 txcompl2	:	OUT  STD_LOGIC;
		 txcompl3	:	OUT  STD_LOGIC;
		 txcompl4	:	OUT  STD_LOGIC;
		 txcompl5	:	OUT  STD_LOGIC;
		 txcompl6	:	OUT  STD_LOGIC;
		 txcompl7	:	OUT  STD_LOGIC;
		 txdata0	:	OUT  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 txdata1	:	OUT  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 txdata2	:	OUT  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 txdata3	:	OUT  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 txdata4	:	OUT  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 txdata5	:	OUT  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 txdata6	:	OUT  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 txdata7	:	OUT  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 txdatak0	:	OUT  STD_LOGIC;
		 txdatak1	:	OUT  STD_LOGIC;
		 txdatak2	:	OUT  STD_LOGIC;
		 txdatak3	:	OUT  STD_LOGIC;
		 txdatak4	:	OUT  STD_LOGIC;
		 txdatak5	:	OUT  STD_LOGIC;
		 txdatak6	:	OUT  STD_LOGIC;
		 txdatak7	:	OUT  STD_LOGIC;
		 txdetectrx0	:	OUT  STD_LOGIC;
		 txdetectrx1	:	OUT  STD_LOGIC;
		 txdetectrx2	:	OUT  STD_LOGIC;
		 txdetectrx3	:	OUT  STD_LOGIC;
		 txdetectrx4	:	OUT  STD_LOGIC;
		 txdetectrx5	:	OUT  STD_LOGIC;
		 txdetectrx6	:	OUT  STD_LOGIC;
		 txdetectrx7	:	OUT  STD_LOGIC;
		 txelecidle0	:	OUT  STD_LOGIC;
		 txelecidle1	:	OUT  STD_LOGIC;
		 txelecidle2	:	OUT  STD_LOGIC;
		 txelecidle3	:	OUT  STD_LOGIC;
		 txelecidle4	:	OUT  STD_LOGIC;
		 txelecidle5	:	OUT  STD_LOGIC;
		 txelecidle6	:	OUT  STD_LOGIC;
		 txelecidle7	:	OUT  STD_LOGIC;
		 urstn	:	OUT  STD_LOGIC;
		 usrst	:	OUT  STD_LOGIC;
		 wake_oen	:	OUT  STD_LOGIC;
		 wren_rcv0	:	OUT  STD_LOGIC;
		 wren_rcv1	:	OUT  STD_LOGIC;
		 wren_rpl	:	OUT  STD_LOGIC
	 ); 
 END stratixiv_pciehip_pciexp_top_hip;

 ARCHITECTURE RTL OF stratixiv_pciehip_pciexp_top_hip IS

	 ATTRIBUTE synthesis_clearbox : natural;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS 1;
	 SIGNAL	 nili00i0l73	:	STD_LOGIC := '0';
	 SIGNAL	 nili00i0l74	:	STD_LOGIC := '0';
	 SIGNAL	 nili00i0O71	:	STD_LOGIC := '0';
	 SIGNAL	 nili00i0O72	:	STD_LOGIC := '0';
	 SIGNAL	 nili00i1i79	:	STD_LOGIC := '0';
	 SIGNAL	 nili00i1i80	:	STD_LOGIC := '0';
	 SIGNAL	 nili00i1l77	:	STD_LOGIC := '0';
	 SIGNAL	 nili00i1l78	:	STD_LOGIC := '0';
	 SIGNAL	 nili00i1O75	:	STD_LOGIC := '0';
	 SIGNAL	 nili00i1O76	:	STD_LOGIC := '0';
	 SIGNAL	 nilii10ll69	:	STD_LOGIC := '0';
	 SIGNAL	 nilii10ll70	:	STD_LOGIC := '0';
	 SIGNAL	 nilii10lO67	:	STD_LOGIC := '0';
	 SIGNAL	 nilii10lO68	:	STD_LOGIC := '0';
	 SIGNAL	 nilii1ill65	:	STD_LOGIC := '0';
	 SIGNAL	 nilii1ill66	:	STD_LOGIC := '0';
	 SIGNAL	 nilii1ilO63	:	STD_LOGIC := '0';
	 SIGNAL	 nilii1ilO64	:	STD_LOGIC := '0';
	 SIGNAL	 niliii0Oi61	:	STD_LOGIC := '0';
	 SIGNAL	 niliii0Oi62	:	STD_LOGIC := '0';
	 SIGNAL	 niliiiilO59	:	STD_LOGIC := '0';
	 SIGNAL	 niliiiilO60	:	STD_LOGIC := '0';
	 SIGNAL	 niliiiiOi57	:	STD_LOGIC := '0';
	 SIGNAL	 niliiiiOi58	:	STD_LOGIC := '0';
	 SIGNAL	 niliiiOlO55	:	STD_LOGIC := '0';
	 SIGNAL	 niliiiOlO56	:	STD_LOGIC := '0';
	 SIGNAL	 niliiiOOi53	:	STD_LOGIC := '0';
	 SIGNAL	 niliiiOOi54	:	STD_LOGIC := '0';
	 SIGNAL	 niliil1iO51	:	STD_LOGIC := '0';
	 SIGNAL	 niliil1iO52	:	STD_LOGIC := '0';
	 SIGNAL	 niliiliii49	:	STD_LOGIC := '0';
	 SIGNAL	 niliiliii50	:	STD_LOGIC := '0';
	 SIGNAL	 niliiliil47	:	STD_LOGIC := '0';
	 SIGNAL	 niliiliil48	:	STD_LOGIC := '0';
	 SIGNAL	 niliiliiO45	:	STD_LOGIC := '0';
	 SIGNAL	 niliiliiO46	:	STD_LOGIC := '0';
	 SIGNAL	 niliilili43	:	STD_LOGIC := '0';
	 SIGNAL	 niliilili44	:	STD_LOGIC := '0';
	 SIGNAL	 niliililO41	:	STD_LOGIC := '0';
	 SIGNAL	 niliililO42	:	STD_LOGIC := '0';
	 SIGNAL	 niliill0i33	:	STD_LOGIC := '0';
	 SIGNAL	 niliill0i34	:	STD_LOGIC := '0';
	 SIGNAL  wire_niliill0i34_w_lg_w_lg_q1213w1214w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niliill0i34_w_lg_q1213w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niliill0l31	:	STD_LOGIC := '0';
	 SIGNAL	 niliill0l32	:	STD_LOGIC := '0';
	 SIGNAL  wire_niliill0l32_w_lg_w_lg_q1186w1187w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niliill0l32_w_lg_q1186w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niliill0O29	:	STD_LOGIC := '0';
	 SIGNAL	 niliill0O30	:	STD_LOGIC := '0';
	 SIGNAL  wire_niliill0O30_w_lg_w_lg_q1175w1176w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niliill0O30_w_lg_q1175w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niliill1i39	:	STD_LOGIC := '0';
	 SIGNAL	 niliill1i40	:	STD_LOGIC := '0';
	 SIGNAL  wire_niliill1i40_w_lg_w_lg_q1258w1259w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niliill1i40_w_lg_q1258w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niliill1l37	:	STD_LOGIC := '0';
	 SIGNAL	 niliill1l38	:	STD_LOGIC := '0';
	 SIGNAL  wire_niliill1l38_w_lg_w_lg_q1249w1250w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niliill1l38_w_lg_q1249w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niliill1O35	:	STD_LOGIC := '0';
	 SIGNAL	 niliill1O36	:	STD_LOGIC := '0';
	 SIGNAL  wire_niliill1O36_w_lg_w_lg_q1241w1242w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niliill1O36_w_lg_q1241w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niliillii27	:	STD_LOGIC := '0';
	 SIGNAL	 niliillii28	:	STD_LOGIC := '0';
	 SIGNAL  wire_niliillii28_w_lg_w_lg_q1163w1164w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niliillii28_w_lg_q1163w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niliillil25	:	STD_LOGIC := '0';
	 SIGNAL	 niliillil26	:	STD_LOGIC := '0';
	 SIGNAL  wire_niliillil26_w_lg_w_lg_q1160w1161w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niliillil26_w_lg_q1160w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niliilliO23	:	STD_LOGIC := '0';
	 SIGNAL	 niliilliO24	:	STD_LOGIC := '0';
	 SIGNAL  wire_niliilliO24_w_lg_w_lg_q1142w1143w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niliilliO24_w_lg_q1142w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niliillli21	:	STD_LOGIC := '0';
	 SIGNAL	 niliillli22	:	STD_LOGIC := '0';
	 SIGNAL  wire_niliillli22_w_lg_w_lg_q1132w1133w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niliillli22_w_lg_q1132w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niliillll19	:	STD_LOGIC := '0';
	 SIGNAL	 niliillll20	:	STD_LOGIC := '0';
	 SIGNAL  wire_niliillll20_w_lg_w_lg_q1123w1124w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niliillll20_w_lg_q1123w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niliilllO17	:	STD_LOGIC := '0';
	 SIGNAL	 niliilllO18	:	STD_LOGIC := '0';
	 SIGNAL  wire_niliilllO18_w_lg_w_lg_q1116w1117w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niliilllO18_w_lg_q1116w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niliillOi15	:	STD_LOGIC := '0';
	 SIGNAL	 niliillOi16	:	STD_LOGIC := '0';
	 SIGNAL  wire_niliillOi16_w_lg_w_lg_q1110w1111w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niliillOi16_w_lg_q1110w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niliilO0O11	:	STD_LOGIC := '0';
	 SIGNAL	 niliilO0O12	:	STD_LOGIC := '0';
	 SIGNAL	 niliilO1l13	:	STD_LOGIC := '0';
	 SIGNAL	 niliilO1l14	:	STD_LOGIC := '0';
	 SIGNAL	 niliilOiO10	:	STD_LOGIC := '0';
	 SIGNAL	 niliilOiO9	:	STD_LOGIC := '0';
	 SIGNAL	 niliilOll7	:	STD_LOGIC := '0';
	 SIGNAL	 niliilOll8	:	STD_LOGIC := '0';
	 SIGNAL	 niliilOOO5	:	STD_LOGIC := '0';
	 SIGNAL	 niliilOOO6	:	STD_LOGIC := '0';
	 SIGNAL	 niliiO10l1	:	STD_LOGIC := '0';
	 SIGNAL	 niliiO10l2	:	STD_LOGIC := '0';
	 SIGNAL	 niliiO11O3	:	STD_LOGIC := '0';
	 SIGNAL	 niliiO11O4	:	STD_LOGIC := '0';
	 SIGNAL	n1llO1O	:	STD_LOGIC := '0';
	 SIGNAL	n1llOii	:	STD_LOGIC := '0';
	 SIGNAL	n1llOil	:	STD_LOGIC := '0';
	 SIGNAL	n1lO0Ol	:	STD_LOGIC := '0';
	 SIGNAL	nlO0OOlO	:	STD_LOGIC := '0';
	 SIGNAL	nlO0OOOl	:	STD_LOGIC := '0';
	 SIGNAL	nlO0OOOO	:	STD_LOGIC := '0';
	 SIGNAL	nlOi111i	:	STD_LOGIC := '0';
	 SIGNAL	wire_n1lO0Oi_CLRN	:	STD_LOGIC;
	 SIGNAL	n1llill	:	STD_LOGIC := '0';
	 SIGNAL	n1lO0lO	:	STD_LOGIC := '0';
	 SIGNAL	n1lO0OO	:	STD_LOGIC := '0';
	 SIGNAL	n1lOi1i	:	STD_LOGIC := '0';
	 SIGNAL	n1lOi1O	:	STD_LOGIC := '0';
	 SIGNAL	nlO0O0li	:	STD_LOGIC := '0';
	 SIGNAL	nlO0O0Ol	:	STD_LOGIC := '0';
	 SIGNAL	nlO0O0OO	:	STD_LOGIC := '0';
	 SIGNAL	nlO0O11O	:	STD_LOGIC := '0';
	 SIGNAL	nlO0OOOi	:	STD_LOGIC := '0';
	 SIGNAL	n1O10lO	:	STD_LOGIC := '0';
	 SIGNAL	n1O10Oi	:	STD_LOGIC := '0';
	 SIGNAL	n1O1i1l	:	STD_LOGIC := '0';
	 SIGNAL	wire_n1O1i1i_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_n1O1i1i_PRN	:	STD_LOGIC;
	 SIGNAL	n1lliiO	:	STD_LOGIC := '0';
	 SIGNAL	n1O100i	:	STD_LOGIC := '0';
	 SIGNAL	n1O100l	:	STD_LOGIC := '0';
	 SIGNAL	n1O100O	:	STD_LOGIC := '0';
	 SIGNAL	n1O101i	:	STD_LOGIC := '0';
	 SIGNAL	n1O101l	:	STD_LOGIC := '0';
	 SIGNAL	n1O101O	:	STD_LOGIC := '0';
	 SIGNAL	n1O10ii	:	STD_LOGIC := '0';
	 SIGNAL	n1O10il	:	STD_LOGIC := '0';
	 SIGNAL	n1O10iO	:	STD_LOGIC := '0';
	 SIGNAL	n1O10li	:	STD_LOGIC := '0';
	 SIGNAL	n1O10ll	:	STD_LOGIC := '0';
	 SIGNAL	n1O10Ol	:	STD_LOGIC := '0';
	 SIGNAL	n1O10OO	:	STD_LOGIC := '0';
	 SIGNAL	n1O11iO	:	STD_LOGIC := '0';
	 SIGNAL	n1O11Ol	:	STD_LOGIC := '0';
	 SIGNAL	n1O11OO	:	STD_LOGIC := '0';
	 SIGNAL	n1O1i0i	:	STD_LOGIC := '0';
	 SIGNAL	n1O1i0l	:	STD_LOGIC := '0';
	 SIGNAL	n1O1i0O	:	STD_LOGIC := '0';
	 SIGNAL	n1O1i1O	:	STD_LOGIC := '0';
	 SIGNAL	n1O1iii	:	STD_LOGIC := '0';
	 SIGNAL	n1O1iil	:	STD_LOGIC := '0';
	 SIGNAL	n1O1iiO	:	STD_LOGIC := '0';
	 SIGNAL	ni010il	:	STD_LOGIC := '0';
	 SIGNAL	ni010iO	:	STD_LOGIC := '0';
	 SIGNAL	ni010ll	:	STD_LOGIC := '0';
	 SIGNAL	ni1l1il	:	STD_LOGIC := '0';
	 SIGNAL	nlO0O0ll	:	STD_LOGIC := '0';
	 SIGNAL	nlO0O0lO	:	STD_LOGIC := '0';
	 SIGNAL	nlO0O0Oi	:	STD_LOGIC := '0';
	 SIGNAL	nlO0O11i	:	STD_LOGIC := '0';
	 SIGNAL	nlO0OiOi	:	STD_LOGIC := '0';
	 SIGNAL	nlO0Ol0i	:	STD_LOGIC := '0';
	 SIGNAL	nlO0Ol0l	:	STD_LOGIC := '0';
	 SIGNAL	nlO0Ol0O	:	STD_LOGIC := '0';
	 SIGNAL	nlO0Ol1O	:	STD_LOGIC := '0';
	 SIGNAL	nlO0Olii	:	STD_LOGIC := '0';
	 SIGNAL	nlO0Olil	:	STD_LOGIC := '0';
	 SIGNAL	nlO0OliO	:	STD_LOGIC := '0';
	 SIGNAL	nlO0Olli	:	STD_LOGIC := '0';
	 SIGNAL	nlO0Olll	:	STD_LOGIC := '0';
	 SIGNAL	nlO0OllO	:	STD_LOGIC := '0';
	 SIGNAL	nlO0OlOi	:	STD_LOGIC := '0';
	 SIGNAL	nlO0OlOl	:	STD_LOGIC := '0';
	 SIGNAL	nlO0OlOO	:	STD_LOGIC := '0';
	 SIGNAL	nlO0OO0i	:	STD_LOGIC := '0';
	 SIGNAL	nlO0OO0l	:	STD_LOGIC := '0';
	 SIGNAL	nlO0OO0O	:	STD_LOGIC := '0';
	 SIGNAL	nlO0OO1i	:	STD_LOGIC := '0';
	 SIGNAL	nlO0OO1l	:	STD_LOGIC := '0';
	 SIGNAL	nlO0OO1O	:	STD_LOGIC := '0';
	 SIGNAL	nlO0OOii	:	STD_LOGIC := '0';
	 SIGNAL	nlO0OOil	:	STD_LOGIC := '0';
	 SIGNAL	nlO0OOiO	:	STD_LOGIC := '0';
	 SIGNAL	nlO0OOli	:	STD_LOGIC := '0';
	 SIGNAL	nlO0OOll	:	STD_LOGIC := '0';
	 SIGNAL	nlOi0O0l	:	STD_LOGIC := '0';
	 SIGNAL	nlOi0O1l	:	STD_LOGIC := '0';
	 SIGNAL	nlOi0OlO	:	STD_LOGIC := '0';
	 SIGNAL	nlOi0OOi	:	STD_LOGIC := '0';
	 SIGNAL	nlOi0OOl	:	STD_LOGIC := '0';
	 SIGNAL	nlOi0OOO	:	STD_LOGIC := '0';
	 SIGNAL	nlOii00i	:	STD_LOGIC := '0';
	 SIGNAL	nlOii00l	:	STD_LOGIC := '0';
	 SIGNAL	nlOii00O	:	STD_LOGIC := '0';
	 SIGNAL	nlOii01i	:	STD_LOGIC := '0';
	 SIGNAL	nlOii01l	:	STD_LOGIC := '0';
	 SIGNAL	nlOii01O	:	STD_LOGIC := '0';
	 SIGNAL	nlOii0ii	:	STD_LOGIC := '0';
	 SIGNAL	nlOii0il	:	STD_LOGIC := '0';
	 SIGNAL	nlOii0iO	:	STD_LOGIC := '0';
	 SIGNAL	nlOii0li	:	STD_LOGIC := '0';
	 SIGNAL	nlOii0ll	:	STD_LOGIC := '0';
	 SIGNAL	nlOii0lO	:	STD_LOGIC := '0';
	 SIGNAL	nlOii0Oi	:	STD_LOGIC := '0';
	 SIGNAL	nlOii0Ol	:	STD_LOGIC := '0';
	 SIGNAL	nlOii0OO	:	STD_LOGIC := '0';
	 SIGNAL	nlOii10i	:	STD_LOGIC := '0';
	 SIGNAL	nlOii10l	:	STD_LOGIC := '0';
	 SIGNAL	nlOii10O	:	STD_LOGIC := '0';
	 SIGNAL	nlOii11i	:	STD_LOGIC := '0';
	 SIGNAL	nlOii11l	:	STD_LOGIC := '0';
	 SIGNAL	nlOii11O	:	STD_LOGIC := '0';
	 SIGNAL	nlOii1ii	:	STD_LOGIC := '0';
	 SIGNAL	nlOii1il	:	STD_LOGIC := '0';
	 SIGNAL	nlOii1iO	:	STD_LOGIC := '0';
	 SIGNAL	nlOii1li	:	STD_LOGIC := '0';
	 SIGNAL	nlOii1ll	:	STD_LOGIC := '0';
	 SIGNAL	nlOii1lO	:	STD_LOGIC := '0';
	 SIGNAL	nlOii1Oi	:	STD_LOGIC := '0';
	 SIGNAL	nlOii1Ol	:	STD_LOGIC := '0';
	 SIGNAL	nlOii1OO	:	STD_LOGIC := '0';
	 SIGNAL	nlOiii0i	:	STD_LOGIC := '0';
	 SIGNAL	nlOiii0l	:	STD_LOGIC := '0';
	 SIGNAL	nlOiii0O	:	STD_LOGIC := '0';
	 SIGNAL	nlOiii1i	:	STD_LOGIC := '0';
	 SIGNAL	nlOiii1l	:	STD_LOGIC := '0';
	 SIGNAL	nlOiii1O	:	STD_LOGIC := '0';
	 SIGNAL	nlOiiiii	:	STD_LOGIC := '0';
	 SIGNAL	nlOiiiil	:	STD_LOGIC := '0';
	 SIGNAL	nlOiiiiO	:	STD_LOGIC := '0';
	 SIGNAL	nlOiiili	:	STD_LOGIC := '0';
	 SIGNAL	nlOiiill	:	STD_LOGIC := '0';
	 SIGNAL	nlOiiilO	:	STD_LOGIC := '0';
	 SIGNAL	nlOiiiOi	:	STD_LOGIC := '0';
	 SIGNAL	nlOiiiOl	:	STD_LOGIC := '0';
	 SIGNAL	nlOiiiOO	:	STD_LOGIC := '0';
	 SIGNAL	nlOiil0i	:	STD_LOGIC := '0';
	 SIGNAL	nlOiil0l	:	STD_LOGIC := '0';
	 SIGNAL	nlOiil0O	:	STD_LOGIC := '0';
	 SIGNAL	nlOiil1i	:	STD_LOGIC := '0';
	 SIGNAL	nlOiil1l	:	STD_LOGIC := '0';
	 SIGNAL	nlOiil1O	:	STD_LOGIC := '0';
	 SIGNAL	nlOiilii	:	STD_LOGIC := '0';
	 SIGNAL	nlOiilil	:	STD_LOGIC := '0';
	 SIGNAL	nlOiiliO	:	STD_LOGIC := '0';
	 SIGNAL	nlOiilli	:	STD_LOGIC := '0';
	 SIGNAL	nlOiilll	:	STD_LOGIC := '0';
	 SIGNAL	nlOiillO	:	STD_LOGIC := '0';
	 SIGNAL	nlOiilOi	:	STD_LOGIC := '0';
	 SIGNAL	nlOiilOl	:	STD_LOGIC := '0';
	 SIGNAL	nlOiilOO	:	STD_LOGIC := '0';
	 SIGNAL	nlOiiO0i	:	STD_LOGIC := '0';
	 SIGNAL	nlOiiO0l	:	STD_LOGIC := '0';
	 SIGNAL	nlOiiO0O	:	STD_LOGIC := '0';
	 SIGNAL	nlOiiO1i	:	STD_LOGIC := '0';
	 SIGNAL	nlOiiO1l	:	STD_LOGIC := '0';
	 SIGNAL	nlOiiO1O	:	STD_LOGIC := '0';
	 SIGNAL	nlOiiOii	:	STD_LOGIC := '0';
	 SIGNAL	nlOiiOil	:	STD_LOGIC := '0';
	 SIGNAL	nlOiiOiO	:	STD_LOGIC := '0';
	 SIGNAL	nlOiiOli	:	STD_LOGIC := '0';
	 SIGNAL	nlOiiOll	:	STD_LOGIC := '0';
	 SIGNAL	nlOiiOlO	:	STD_LOGIC := '0';
	 SIGNAL	nlOiiOOi	:	STD_LOGIC := '0';
	 SIGNAL	nlOiiOOl	:	STD_LOGIC := '0';
	 SIGNAL	nlOiiOOO	:	STD_LOGIC := '0';
	 SIGNAL	nlOil00i	:	STD_LOGIC := '0';
	 SIGNAL	nlOil00l	:	STD_LOGIC := '0';
	 SIGNAL	nlOil00O	:	STD_LOGIC := '0';
	 SIGNAL	nlOil01i	:	STD_LOGIC := '0';
	 SIGNAL	nlOil01l	:	STD_LOGIC := '0';
	 SIGNAL	nlOil01O	:	STD_LOGIC := '0';
	 SIGNAL	nlOil0ii	:	STD_LOGIC := '0';
	 SIGNAL	nlOil0il	:	STD_LOGIC := '0';
	 SIGNAL	nlOil0iO	:	STD_LOGIC := '0';
	 SIGNAL	nlOil0li	:	STD_LOGIC := '0';
	 SIGNAL	nlOil0ll	:	STD_LOGIC := '0';
	 SIGNAL	nlOil0lO	:	STD_LOGIC := '0';
	 SIGNAL	nlOil0Oi	:	STD_LOGIC := '0';
	 SIGNAL	nlOil0Ol	:	STD_LOGIC := '0';
	 SIGNAL	nlOil0OO	:	STD_LOGIC := '0';
	 SIGNAL	nlOil10i	:	STD_LOGIC := '0';
	 SIGNAL	nlOil10l	:	STD_LOGIC := '0';
	 SIGNAL	nlOil10O	:	STD_LOGIC := '0';
	 SIGNAL	nlOil11i	:	STD_LOGIC := '0';
	 SIGNAL	nlOil11l	:	STD_LOGIC := '0';
	 SIGNAL	nlOil11O	:	STD_LOGIC := '0';
	 SIGNAL	nlOil1ii	:	STD_LOGIC := '0';
	 SIGNAL	nlOil1il	:	STD_LOGIC := '0';
	 SIGNAL	nlOil1iO	:	STD_LOGIC := '0';
	 SIGNAL	nlOil1li	:	STD_LOGIC := '0';
	 SIGNAL	nlOil1ll	:	STD_LOGIC := '0';
	 SIGNAL	nlOil1lO	:	STD_LOGIC := '0';
	 SIGNAL	nlOil1Oi	:	STD_LOGIC := '0';
	 SIGNAL	nlOil1Ol	:	STD_LOGIC := '0';
	 SIGNAL	nlOil1OO	:	STD_LOGIC := '0';
	 SIGNAL	nlOili0i	:	STD_LOGIC := '0';
	 SIGNAL	nlOili0l	:	STD_LOGIC := '0';
	 SIGNAL	nlOili0O	:	STD_LOGIC := '0';
	 SIGNAL	nlOili1i	:	STD_LOGIC := '0';
	 SIGNAL	nlOili1l	:	STD_LOGIC := '0';
	 SIGNAL	nlOili1O	:	STD_LOGIC := '0';
	 SIGNAL	nlOiliii	:	STD_LOGIC := '0';
	 SIGNAL	nlOiliil	:	STD_LOGIC := '0';
	 SIGNAL	nlOiliiO	:	STD_LOGIC := '0';
	 SIGNAL	nlOilili	:	STD_LOGIC := '0';
	 SIGNAL	nlOilill	:	STD_LOGIC := '0';
	 SIGNAL	nlOililO	:	STD_LOGIC := '0';
	 SIGNAL	nlOiliOi	:	STD_LOGIC := '0';
	 SIGNAL	nlOiliOl	:	STD_LOGIC := '0';
	 SIGNAL	nlOiliOO	:	STD_LOGIC := '0';
	 SIGNAL	nlOill0i	:	STD_LOGIC := '0';
	 SIGNAL	nlOill0l	:	STD_LOGIC := '0';
	 SIGNAL	nlOill0O	:	STD_LOGIC := '0';
	 SIGNAL	nlOill1i	:	STD_LOGIC := '0';
	 SIGNAL	nlOill1l	:	STD_LOGIC := '0';
	 SIGNAL	nlOill1O	:	STD_LOGIC := '0';
	 SIGNAL	nlOillii	:	STD_LOGIC := '0';
	 SIGNAL	nlOillil	:	STD_LOGIC := '0';
	 SIGNAL	nlOilliO	:	STD_LOGIC := '0';
	 SIGNAL	nlOillli	:	STD_LOGIC := '0';
	 SIGNAL	nlOillll	:	STD_LOGIC := '0';
	 SIGNAL	nlOilllO	:	STD_LOGIC := '0';
	 SIGNAL	nlOillOi	:	STD_LOGIC := '0';
	 SIGNAL	nlOillOl	:	STD_LOGIC := '0';
	 SIGNAL	nlOillOO	:	STD_LOGIC := '0';
	 SIGNAL	nlOilO0i	:	STD_LOGIC := '0';
	 SIGNAL	nlOilO0l	:	STD_LOGIC := '0';
	 SIGNAL	nlOilO0O	:	STD_LOGIC := '0';
	 SIGNAL	nlOilO1i	:	STD_LOGIC := '0';
	 SIGNAL	nlOilO1l	:	STD_LOGIC := '0';
	 SIGNAL	nlOilO1O	:	STD_LOGIC := '0';
	 SIGNAL	nlOilOii	:	STD_LOGIC := '0';
	 SIGNAL	nlOilOil	:	STD_LOGIC := '0';
	 SIGNAL	nlOilOiO	:	STD_LOGIC := '0';
	 SIGNAL	nlOilOli	:	STD_LOGIC := '0';
	 SIGNAL	nlOilOll	:	STD_LOGIC := '0';
	 SIGNAL	nlOilOlO	:	STD_LOGIC := '0';
	 SIGNAL	nlOilOOi	:	STD_LOGIC := '0';
	 SIGNAL	nlOilOOl	:	STD_LOGIC := '0';
	 SIGNAL	nlOilOOO	:	STD_LOGIC := '0';
	 SIGNAL	nlOiO10i	:	STD_LOGIC := '0';
	 SIGNAL	nlOiO11i	:	STD_LOGIC := '0';
	 SIGNAL	nlOiO11l	:	STD_LOGIC := '0';
	 SIGNAL	nlOiO11O	:	STD_LOGIC := '0';
	 SIGNAL	wire_ni010li_PRN	:	STD_LOGIC;
	 SIGNAL  wire_ni010li_w4027w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni010li_w_lg_w_lg_w_lg_w_lg_nlO0OOil4017w4018w4021w4024w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni010li_w_lg_w_lg_w_lg_nlO0OOil4017w4018w4021w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni010li_w_lg_nlO0O0Oi4043w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni010li_w_lg_w_lg_nlO0OOil4017w4018w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni010li_w_lg_w_lg_nlO0OOiO4019w4020w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni010li_w_lg_w_lg_nlO0OOli4022w4023w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni010li_w_lg_w_lg_nlO0OOll4025w4026w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni010li_w_lg_n1O10ii762w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni010li_w_lg_n1O10ll2867w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni010li_w_lg_nlO0OiOi4016w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni010li_w_lg_nlO0OOll3982w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni010li_w_lg_nlO0OOil4017w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni010li_w_lg_nlO0OOiO4019w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni010li_w_lg_nlO0OOli4022w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni010li_w_lg_nlO0OOll4025w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n1l1OOO	:	STD_LOGIC := '0';
	 SIGNAL	ni1iO1l	:	STD_LOGIC := '0';
	 SIGNAL	nilOlOlil	:	STD_LOGIC := '0';
	 SIGNAL	nilOO1iiO	:	STD_LOGIC := '0';
	 SIGNAL	niO1l000l	:	STD_LOGIC := '0';
	 SIGNAL	niO1l01iO	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1i1O	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1iil	:	STD_LOGIC := '0';
	 SIGNAL	nl10OO1lO	:	STD_LOGIC := '0';
	 SIGNAL	nl111110O	:	STD_LOGIC := '0';
	 SIGNAL	nl1111l0O	:	STD_LOGIC := '0';
	 SIGNAL	nl1111lOi	:	STD_LOGIC := '0';
	 SIGNAL	nl1iO0i1i	:	STD_LOGIC := '0';
	 SIGNAL	nl1l0010l	:	STD_LOGIC := '0';
	 SIGNAL	nlOi1OiO	:	STD_LOGIC := '0';
	 SIGNAL	nlOi1Oli	:	STD_LOGIC := '0';
	 SIGNAL	nlOi1OOi	:	STD_LOGIC := '0';
	 SIGNAL  wire_ni1iO1i_w54688w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1iO1i_w_lg_w_lg_w_lg_nl1l0010l54684w54686w54687w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1iO1i_w_lg_w_lg_nl1l0010l54684w54686w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1iO1i_w_lg_n1l1OOO3628w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1iO1i_w_lg_n1l1OOO3609w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1iO1i_w_lg_ni1iO1l2431w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1iO1i_w_lg_ni1iO1l2693w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1iO1i_w_lg_nl1iO0i1i57173w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1iO1i_w_lg_nl1l0010l54684w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1iO1i_w_lg_ni1iO1l2436w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1iO1i_w_lg_niO1l000l66430w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1iO1i_w_lg_niO1l01iO66085w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1iO1i_w_lg_nl10OO1lO55695w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1iO1i_w_lg_nl1iO0i1i55694w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1iO1i_w_lg_nl1l0010l55086w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1iO1i_w_lg_w_lg_n1l1OOO3628w3633w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1iO1i_w_lg_w_lg_ni1iO1l2431w2432w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1iO1i_w_lg_w_lg_w_lg_n1l1OOO3628w3633w3636w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1iO1i_w_lg_w_lg_w_lg_w_lg_n1l1OOO3628w3633w3636w3640w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1iO1i_w_lg_w_lg_n1l1OOO3515w3517w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1iO1i_w_lg_w_lg_nl10OO1lO56228w56229w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1iO1i_w_lg_n1l1OOO3491w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1iO1i_w_lg_n1l1OOO3501w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1iO1i_w_lg_n1l1OOO3515w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1iO1i_w_lg_nl10OO1lO56474w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1iO1i_w_lg_nl10OO1lO56228w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n01100i	:	STD_LOGIC := '0';
	 SIGNAL	n01100l	:	STD_LOGIC := '0';
	 SIGNAL	n01101i	:	STD_LOGIC := '0';
	 SIGNAL	n01101l	:	STD_LOGIC := '0';
	 SIGNAL	n01101O	:	STD_LOGIC := '0';
	 SIGNAL	n01110i	:	STD_LOGIC := '0';
	 SIGNAL	n01110l	:	STD_LOGIC := '0';
	 SIGNAL	n01110O	:	STD_LOGIC := '0';
	 SIGNAL	n01111i	:	STD_LOGIC := '0';
	 SIGNAL	n01111l	:	STD_LOGIC := '0';
	 SIGNAL	n01111O	:	STD_LOGIC := '0';
	 SIGNAL	n0111ii	:	STD_LOGIC := '0';
	 SIGNAL	n0111il	:	STD_LOGIC := '0';
	 SIGNAL	n0111iO	:	STD_LOGIC := '0';
	 SIGNAL	n0111li	:	STD_LOGIC := '0';
	 SIGNAL	n0111ll	:	STD_LOGIC := '0';
	 SIGNAL	n0111lO	:	STD_LOGIC := '0';
	 SIGNAL	n0111Oi	:	STD_LOGIC := '0';
	 SIGNAL	n0111Ol	:	STD_LOGIC := '0';
	 SIGNAL	n0111OO	:	STD_LOGIC := '0';
	 SIGNAL	n10000i	:	STD_LOGIC := '0';
	 SIGNAL	n10001i	:	STD_LOGIC := '0';
	 SIGNAL	n10001l	:	STD_LOGIC := '0';
	 SIGNAL	n10001O	:	STD_LOGIC := '0';
	 SIGNAL	n10010i	:	STD_LOGIC := '0';
	 SIGNAL	n10010l	:	STD_LOGIC := '0';
	 SIGNAL	n10010O	:	STD_LOGIC := '0';
	 SIGNAL	n10011i	:	STD_LOGIC := '0';
	 SIGNAL	n10011l	:	STD_LOGIC := '0';
	 SIGNAL	n10011O	:	STD_LOGIC := '0';
	 SIGNAL	n1001ii	:	STD_LOGIC := '0';
	 SIGNAL	n1001il	:	STD_LOGIC := '0';
	 SIGNAL	n1001iO	:	STD_LOGIC := '0';
	 SIGNAL	n1001li	:	STD_LOGIC := '0';
	 SIGNAL	n1001ll	:	STD_LOGIC := '0';
	 SIGNAL	n1001lO	:	STD_LOGIC := '0';
	 SIGNAL	n1001Oi	:	STD_LOGIC := '0';
	 SIGNAL	n1001Ol	:	STD_LOGIC := '0';
	 SIGNAL	n1001OO	:	STD_LOGIC := '0';
	 SIGNAL	n10100i	:	STD_LOGIC := '0';
	 SIGNAL	n10100l	:	STD_LOGIC := '0';
	 SIGNAL	n10100O	:	STD_LOGIC := '0';
	 SIGNAL	n10101i	:	STD_LOGIC := '0';
	 SIGNAL	n10101l	:	STD_LOGIC := '0';
	 SIGNAL	n10101O	:	STD_LOGIC := '0';
	 SIGNAL	n1010ii	:	STD_LOGIC := '0';
	 SIGNAL	n1010il	:	STD_LOGIC := '0';
	 SIGNAL	n1010iO	:	STD_LOGIC := '0';
	 SIGNAL	n1010li	:	STD_LOGIC := '0';
	 SIGNAL	n1010ll	:	STD_LOGIC := '0';
	 SIGNAL	n1010lO	:	STD_LOGIC := '0';
	 SIGNAL	n1010Oi	:	STD_LOGIC := '0';
	 SIGNAL	n1010Ol	:	STD_LOGIC := '0';
	 SIGNAL	n1010OO	:	STD_LOGIC := '0';
	 SIGNAL	n10110i	:	STD_LOGIC := '0';
	 SIGNAL	n10110l	:	STD_LOGIC := '0';
	 SIGNAL	n10110O	:	STD_LOGIC := '0';
	 SIGNAL	n10111i	:	STD_LOGIC := '0';
	 SIGNAL	n10111l	:	STD_LOGIC := '0';
	 SIGNAL	n10111O	:	STD_LOGIC := '0';
	 SIGNAL	n1011ii	:	STD_LOGIC := '0';
	 SIGNAL	n1011il	:	STD_LOGIC := '0';
	 SIGNAL	n1011iO	:	STD_LOGIC := '0';
	 SIGNAL	n1011li	:	STD_LOGIC := '0';
	 SIGNAL	n1011ll	:	STD_LOGIC := '0';
	 SIGNAL	n1011lO	:	STD_LOGIC := '0';
	 SIGNAL	n1011Oi	:	STD_LOGIC := '0';
	 SIGNAL	n1011Ol	:	STD_LOGIC := '0';
	 SIGNAL	n1011OO	:	STD_LOGIC := '0';
	 SIGNAL	n101i0i	:	STD_LOGIC := '0';
	 SIGNAL	n101i0l	:	STD_LOGIC := '0';
	 SIGNAL	n101i0O	:	STD_LOGIC := '0';
	 SIGNAL	n101i1i	:	STD_LOGIC := '0';
	 SIGNAL	n101i1l	:	STD_LOGIC := '0';
	 SIGNAL	n101i1O	:	STD_LOGIC := '0';
	 SIGNAL	n101iii	:	STD_LOGIC := '0';
	 SIGNAL	n101iil	:	STD_LOGIC := '0';
	 SIGNAL	n101iiO	:	STD_LOGIC := '0';
	 SIGNAL	n101ili	:	STD_LOGIC := '0';
	 SIGNAL	n101ill	:	STD_LOGIC := '0';
	 SIGNAL	n101ilO	:	STD_LOGIC := '0';
	 SIGNAL	n101iOi	:	STD_LOGIC := '0';
	 SIGNAL	n101iOl	:	STD_LOGIC := '0';
	 SIGNAL	n101iOO	:	STD_LOGIC := '0';
	 SIGNAL	n101l0i	:	STD_LOGIC := '0';
	 SIGNAL	n101l0l	:	STD_LOGIC := '0';
	 SIGNAL	n101l0O	:	STD_LOGIC := '0';
	 SIGNAL	n101l1i	:	STD_LOGIC := '0';
	 SIGNAL	n101l1l	:	STD_LOGIC := '0';
	 SIGNAL	n101l1O	:	STD_LOGIC := '0';
	 SIGNAL	n101lii	:	STD_LOGIC := '0';
	 SIGNAL	n101lil	:	STD_LOGIC := '0';
	 SIGNAL	n101liO	:	STD_LOGIC := '0';
	 SIGNAL	n101lli	:	STD_LOGIC := '0';
	 SIGNAL	n101lll	:	STD_LOGIC := '0';
	 SIGNAL	n101llO	:	STD_LOGIC := '0';
	 SIGNAL	n101lOi	:	STD_LOGIC := '0';
	 SIGNAL	n101lOl	:	STD_LOGIC := '0';
	 SIGNAL	n101lOO	:	STD_LOGIC := '0';
	 SIGNAL	n101O0i	:	STD_LOGIC := '0';
	 SIGNAL	n101O0l	:	STD_LOGIC := '0';
	 SIGNAL	n101O0O	:	STD_LOGIC := '0';
	 SIGNAL	n101O1i	:	STD_LOGIC := '0';
	 SIGNAL	n101O1l	:	STD_LOGIC := '0';
	 SIGNAL	n101O1O	:	STD_LOGIC := '0';
	 SIGNAL	n101Oii	:	STD_LOGIC := '0';
	 SIGNAL	n101Oil	:	STD_LOGIC := '0';
	 SIGNAL	n101OiO	:	STD_LOGIC := '0';
	 SIGNAL	n101Oli	:	STD_LOGIC := '0';
	 SIGNAL	n101Oll	:	STD_LOGIC := '0';
	 SIGNAL	n101OlO	:	STD_LOGIC := '0';
	 SIGNAL	n101OOi	:	STD_LOGIC := '0';
	 SIGNAL	n101OOl	:	STD_LOGIC := '0';
	 SIGNAL	n101OOO	:	STD_LOGIC := '0';
	 SIGNAL	n11O00i	:	STD_LOGIC := '0';
	 SIGNAL	n11O00l	:	STD_LOGIC := '0';
	 SIGNAL	n11O00O	:	STD_LOGIC := '0';
	 SIGNAL	n11O01i	:	STD_LOGIC := '0';
	 SIGNAL	n11O01l	:	STD_LOGIC := '0';
	 SIGNAL	n11O01O	:	STD_LOGIC := '0';
	 SIGNAL	n11O0ii	:	STD_LOGIC := '0';
	 SIGNAL	n11O0il	:	STD_LOGIC := '0';
	 SIGNAL	n11O0iO	:	STD_LOGIC := '0';
	 SIGNAL	n11O0li	:	STD_LOGIC := '0';
	 SIGNAL	n11O0ll	:	STD_LOGIC := '0';
	 SIGNAL	n11O0lO	:	STD_LOGIC := '0';
	 SIGNAL	n11O0Oi	:	STD_LOGIC := '0';
	 SIGNAL	n11O0Ol	:	STD_LOGIC := '0';
	 SIGNAL	n11O0OO	:	STD_LOGIC := '0';
	 SIGNAL	n11O1Oi	:	STD_LOGIC := '0';
	 SIGNAL	n11O1Ol	:	STD_LOGIC := '0';
	 SIGNAL	n11O1OO	:	STD_LOGIC := '0';
	 SIGNAL	n11Oi0i	:	STD_LOGIC := '0';
	 SIGNAL	n11Oi0l	:	STD_LOGIC := '0';
	 SIGNAL	n11Oi0O	:	STD_LOGIC := '0';
	 SIGNAL	n11Oi1i	:	STD_LOGIC := '0';
	 SIGNAL	n11Oi1l	:	STD_LOGIC := '0';
	 SIGNAL	n11Oi1O	:	STD_LOGIC := '0';
	 SIGNAL	n11Oiii	:	STD_LOGIC := '0';
	 SIGNAL	n11Oiil	:	STD_LOGIC := '0';
	 SIGNAL	n11OiiO	:	STD_LOGIC := '0';
	 SIGNAL	n11Oili	:	STD_LOGIC := '0';
	 SIGNAL	n11Oill	:	STD_LOGIC := '0';
	 SIGNAL	n11OilO	:	STD_LOGIC := '0';
	 SIGNAL	n11OiOi	:	STD_LOGIC := '0';
	 SIGNAL	n11OiOl	:	STD_LOGIC := '0';
	 SIGNAL	n11OiOO	:	STD_LOGIC := '0';
	 SIGNAL	n11Ol0i	:	STD_LOGIC := '0';
	 SIGNAL	n11Ol0l	:	STD_LOGIC := '0';
	 SIGNAL	n11Ol0O	:	STD_LOGIC := '0';
	 SIGNAL	n11Ol1i	:	STD_LOGIC := '0';
	 SIGNAL	n11Ol1l	:	STD_LOGIC := '0';
	 SIGNAL	n11Ol1O	:	STD_LOGIC := '0';
	 SIGNAL	n11Olii	:	STD_LOGIC := '0';
	 SIGNAL	n11Olil	:	STD_LOGIC := '0';
	 SIGNAL	n11OliO	:	STD_LOGIC := '0';
	 SIGNAL	n11Olli	:	STD_LOGIC := '0';
	 SIGNAL	n11Olll	:	STD_LOGIC := '0';
	 SIGNAL	n11OllO	:	STD_LOGIC := '0';
	 SIGNAL	n11OlOi	:	STD_LOGIC := '0';
	 SIGNAL	n11OlOl	:	STD_LOGIC := '0';
	 SIGNAL	n11OlOO	:	STD_LOGIC := '0';
	 SIGNAL	n11OO0i	:	STD_LOGIC := '0';
	 SIGNAL	n11OO0l	:	STD_LOGIC := '0';
	 SIGNAL	n11OO0O	:	STD_LOGIC := '0';
	 SIGNAL	n11OO1i	:	STD_LOGIC := '0';
	 SIGNAL	n11OO1l	:	STD_LOGIC := '0';
	 SIGNAL	n11OO1O	:	STD_LOGIC := '0';
	 SIGNAL	n11OOii	:	STD_LOGIC := '0';
	 SIGNAL	n11OOil	:	STD_LOGIC := '0';
	 SIGNAL	n11OOiO	:	STD_LOGIC := '0';
	 SIGNAL	n11OOli	:	STD_LOGIC := '0';
	 SIGNAL	n11OOll	:	STD_LOGIC := '0';
	 SIGNAL	n11OOlO	:	STD_LOGIC := '0';
	 SIGNAL	n11OOOi	:	STD_LOGIC := '0';
	 SIGNAL	n11OOOl	:	STD_LOGIC := '0';
	 SIGNAL	n11OOOO	:	STD_LOGIC := '0';
	 SIGNAL	n1iOl0i	:	STD_LOGIC := '0';
	 SIGNAL	n1iOl0l	:	STD_LOGIC := '0';
	 SIGNAL	n1iOl0O	:	STD_LOGIC := '0';
	 SIGNAL	n1iOlii	:	STD_LOGIC := '0';
	 SIGNAL	n1iOlil	:	STD_LOGIC := '0';
	 SIGNAL	n1iOliO	:	STD_LOGIC := '0';
	 SIGNAL	n1iOlli	:	STD_LOGIC := '0';
	 SIGNAL	n1iOlll	:	STD_LOGIC := '0';
	 SIGNAL	n1iOllO	:	STD_LOGIC := '0';
	 SIGNAL	n1iOlOi	:	STD_LOGIC := '0';
	 SIGNAL	n1iOlOl	:	STD_LOGIC := '0';
	 SIGNAL	n1iOlOO	:	STD_LOGIC := '0';
	 SIGNAL	n1iOO0i	:	STD_LOGIC := '0';
	 SIGNAL	n1iOO0l	:	STD_LOGIC := '0';
	 SIGNAL	n1iOO0O	:	STD_LOGIC := '0';
	 SIGNAL	n1iOO1i	:	STD_LOGIC := '0';
	 SIGNAL	n1iOO1l	:	STD_LOGIC := '0';
	 SIGNAL	n1iOO1O	:	STD_LOGIC := '0';
	 SIGNAL	n1iOOii	:	STD_LOGIC := '0';
	 SIGNAL	n1l1ill	:	STD_LOGIC := '0';
	 SIGNAL	n1l1ilO	:	STD_LOGIC := '0';
	 SIGNAL	n1l1iOi	:	STD_LOGIC := '0';
	 SIGNAL	n1l1iOl	:	STD_LOGIC := '0';
	 SIGNAL	n1l1iOO	:	STD_LOGIC := '0';
	 SIGNAL	n1l1l0i	:	STD_LOGIC := '0';
	 SIGNAL	n1l1l0l	:	STD_LOGIC := '0';
	 SIGNAL	n1l1l0O	:	STD_LOGIC := '0';
	 SIGNAL	n1l1l1i	:	STD_LOGIC := '0';
	 SIGNAL	n1l1l1l	:	STD_LOGIC := '0';
	 SIGNAL	n1l1l1O	:	STD_LOGIC := '0';
	 SIGNAL	n1l1lii	:	STD_LOGIC := '0';
	 SIGNAL	n1l1lil	:	STD_LOGIC := '0';
	 SIGNAL	n1l1liO	:	STD_LOGIC := '0';
	 SIGNAL	n1l1lli	:	STD_LOGIC := '0';
	 SIGNAL	n1l1lll	:	STD_LOGIC := '0';
	 SIGNAL	n1l1llO	:	STD_LOGIC := '0';
	 SIGNAL	n1l1lOi	:	STD_LOGIC := '0';
	 SIGNAL	n1l1lOl	:	STD_LOGIC := '0';
	 SIGNAL	n1l1lOO	:	STD_LOGIC := '0';
	 SIGNAL	n1l1O0i	:	STD_LOGIC := '0';
	 SIGNAL	n1l1O0l	:	STD_LOGIC := '0';
	 SIGNAL	n1l1O0O	:	STD_LOGIC := '0';
	 SIGNAL	n1l1O1i	:	STD_LOGIC := '0';
	 SIGNAL	n1l1O1l	:	STD_LOGIC := '0';
	 SIGNAL	n1l1O1O	:	STD_LOGIC := '0';
	 SIGNAL	n1l1Oii	:	STD_LOGIC := '0';
	 SIGNAL	n1l1Oil	:	STD_LOGIC := '0';
	 SIGNAL	n1l1OiO	:	STD_LOGIC := '0';
	 SIGNAL	n1l1Oli	:	STD_LOGIC := '0';
	 SIGNAL	n1l1Oll	:	STD_LOGIC := '0';
	 SIGNAL	n1l1OlO	:	STD_LOGIC := '0';
	 SIGNAL	n1l1OOi	:	STD_LOGIC := '0';
	 SIGNAL	n1l1OOl	:	STD_LOGIC := '0';
	 SIGNAL	n1llili	:	STD_LOGIC := '0';
	 SIGNAL	n1llO0i	:	STD_LOGIC := '0';
	 SIGNAL	n1llO0l	:	STD_LOGIC := '0';
	 SIGNAL	n1llO0O	:	STD_LOGIC := '0';
	 SIGNAL	n1lO00i	:	STD_LOGIC := '0';
	 SIGNAL	n1lO00l	:	STD_LOGIC := '0';
	 SIGNAL	n1lO00O	:	STD_LOGIC := '0';
	 SIGNAL	n1lO01i	:	STD_LOGIC := '0';
	 SIGNAL	n1lO01l	:	STD_LOGIC := '0';
	 SIGNAL	n1lO01O	:	STD_LOGIC := '0';
	 SIGNAL	n1lO0ii	:	STD_LOGIC := '0';
	 SIGNAL	n1lO0il	:	STD_LOGIC := '0';
	 SIGNAL	n1lO0iO	:	STD_LOGIC := '0';
	 SIGNAL	n1lO0li	:	STD_LOGIC := '0';
	 SIGNAL	n1lO0ll	:	STD_LOGIC := '0';
	 SIGNAL	n1lO10O	:	STD_LOGIC := '0';
	 SIGNAL	n1lO1ll	:	STD_LOGIC := '0';
	 SIGNAL	n1lO1lO	:	STD_LOGIC := '0';
	 SIGNAL	n1lO1Oi	:	STD_LOGIC := '0';
	 SIGNAL	n1lO1Ol	:	STD_LOGIC := '0';
	 SIGNAL	n1lO1OO	:	STD_LOGIC := '0';
	 SIGNAL	n1O0iil	:	STD_LOGIC := '0';
	 SIGNAL	n1O0lOi	:	STD_LOGIC := '0';
	 SIGNAL	n1O0lOl	:	STD_LOGIC := '0';
	 SIGNAL	n1O0lOO	:	STD_LOGIC := '0';
	 SIGNAL	n1O0O0i	:	STD_LOGIC := '0';
	 SIGNAL	n1O0O0l	:	STD_LOGIC := '0';
	 SIGNAL	n1O0O0O	:	STD_LOGIC := '0';
	 SIGNAL	n1O0O1i	:	STD_LOGIC := '0';
	 SIGNAL	n1O0O1l	:	STD_LOGIC := '0';
	 SIGNAL	n1O0O1O	:	STD_LOGIC := '0';
	 SIGNAL	n1O0Oii	:	STD_LOGIC := '0';
	 SIGNAL	n1O0Oil	:	STD_LOGIC := '0';
	 SIGNAL	n1O0OiO	:	STD_LOGIC := '0';
	 SIGNAL	n1O0Oli	:	STD_LOGIC := '0';
	 SIGNAL	n1O0Oll	:	STD_LOGIC := '0';
	 SIGNAL	n1O0OlO	:	STD_LOGIC := '0';
	 SIGNAL	n1O0OOi	:	STD_LOGIC := '0';
	 SIGNAL	n1O0OOl	:	STD_LOGIC := '0';
	 SIGNAL	n1O0OOO	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi00i	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi00l	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi00O	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi01i	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi01l	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi01O	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi0ii	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi0il	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi0iO	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi0li	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi0ll	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi0lO	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi0Oi	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi0Ol	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi0OO	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi10i	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi10l	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi10O	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi11i	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi11l	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi11O	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi1ii	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi1il	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi1iO	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi1li	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi1ll	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi1lO	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi1Oi	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi1Ol	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi1OO	:	STD_LOGIC := '0';
	 SIGNAL	n1Oii0i	:	STD_LOGIC := '0';
	 SIGNAL	n1Oii0l	:	STD_LOGIC := '0';
	 SIGNAL	n1Oii0O	:	STD_LOGIC := '0';
	 SIGNAL	n1Oii1i	:	STD_LOGIC := '0';
	 SIGNAL	n1Oii1l	:	STD_LOGIC := '0';
	 SIGNAL	n1Oii1O	:	STD_LOGIC := '0';
	 SIGNAL	n1Oiiii	:	STD_LOGIC := '0';
	 SIGNAL	n1Oiiil	:	STD_LOGIC := '0';
	 SIGNAL	n1OiiiO	:	STD_LOGIC := '0';
	 SIGNAL	n1Oiili	:	STD_LOGIC := '0';
	 SIGNAL	n1Oiill	:	STD_LOGIC := '0';
	 SIGNAL	n1OiilO	:	STD_LOGIC := '0';
	 SIGNAL	n1OiiOi	:	STD_LOGIC := '0';
	 SIGNAL	n1OiiOl	:	STD_LOGIC := '0';
	 SIGNAL	n1OiiOO	:	STD_LOGIC := '0';
	 SIGNAL	n1Oil0i	:	STD_LOGIC := '0';
	 SIGNAL	n1Oil0l	:	STD_LOGIC := '0';
	 SIGNAL	n1Oil0O	:	STD_LOGIC := '0';
	 SIGNAL	n1Oil1i	:	STD_LOGIC := '0';
	 SIGNAL	n1Oil1l	:	STD_LOGIC := '0';
	 SIGNAL	n1Oil1O	:	STD_LOGIC := '0';
	 SIGNAL	n1Oilii	:	STD_LOGIC := '0';
	 SIGNAL	n1Oilil	:	STD_LOGIC := '0';
	 SIGNAL	n1OiliO	:	STD_LOGIC := '0';
	 SIGNAL	n1Oilli	:	STD_LOGIC := '0';
	 SIGNAL	n1Oilll	:	STD_LOGIC := '0';
	 SIGNAL	n1OillO	:	STD_LOGIC := '0';
	 SIGNAL	n1OilOi	:	STD_LOGIC := '0';
	 SIGNAL	n1OilOl	:	STD_LOGIC := '0';
	 SIGNAL	n1OilOO	:	STD_LOGIC := '0';
	 SIGNAL	n1OiO0i	:	STD_LOGIC := '0';
	 SIGNAL	n1OiO0l	:	STD_LOGIC := '0';
	 SIGNAL	n1OiO0O	:	STD_LOGIC := '0';
	 SIGNAL	n1OiO1i	:	STD_LOGIC := '0';
	 SIGNAL	n1OiO1l	:	STD_LOGIC := '0';
	 SIGNAL	n1OiO1O	:	STD_LOGIC := '0';
	 SIGNAL	n1OiOii	:	STD_LOGIC := '0';
	 SIGNAL	n1OiOil	:	STD_LOGIC := '0';
	 SIGNAL	n1OiOiO	:	STD_LOGIC := '0';
	 SIGNAL	n1OiOli	:	STD_LOGIC := '0';
	 SIGNAL	n1OiOll	:	STD_LOGIC := '0';
	 SIGNAL	n1OiOlO	:	STD_LOGIC := '0';
	 SIGNAL	n1OiOOi	:	STD_LOGIC := '0';
	 SIGNAL	n1OiOOl	:	STD_LOGIC := '0';
	 SIGNAL	n1OiOOO	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol00i	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol00l	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol00O	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol01i	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol01l	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol01O	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol0ii	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol0il	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol0iO	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol0li	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol0ll	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol0lO	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol0Oi	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol0Ol	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol0OO	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol10i	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol10l	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol10O	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol11i	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol11l	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol11O	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol1ii	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol1il	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol1iO	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol1li	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol1ll	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol1lO	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol1Oi	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol1Ol	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol1OO	:	STD_LOGIC := '0';
	 SIGNAL	n1Oli0i	:	STD_LOGIC := '0';
	 SIGNAL	n1Oli0l	:	STD_LOGIC := '0';
	 SIGNAL	n1Oli0O	:	STD_LOGIC := '0';
	 SIGNAL	n1Oli1i	:	STD_LOGIC := '0';
	 SIGNAL	n1Oli1l	:	STD_LOGIC := '0';
	 SIGNAL	n1Oli1O	:	STD_LOGIC := '0';
	 SIGNAL	n1Oliii	:	STD_LOGIC := '0';
	 SIGNAL	n1Oliil	:	STD_LOGIC := '0';
	 SIGNAL	n1OliiO	:	STD_LOGIC := '0';
	 SIGNAL	n1Olili	:	STD_LOGIC := '0';
	 SIGNAL	n1Olill	:	STD_LOGIC := '0';
	 SIGNAL	n1OlilO	:	STD_LOGIC := '0';
	 SIGNAL	n1OliOi	:	STD_LOGIC := '0';
	 SIGNAL	n1OliOl	:	STD_LOGIC := '0';
	 SIGNAL	n1OliOO	:	STD_LOGIC := '0';
	 SIGNAL	n1Oll0i	:	STD_LOGIC := '0';
	 SIGNAL	n1Oll0l	:	STD_LOGIC := '0';
	 SIGNAL	n1Oll0O	:	STD_LOGIC := '0';
	 SIGNAL	n1Oll1i	:	STD_LOGIC := '0';
	 SIGNAL	n1Oll1l	:	STD_LOGIC := '0';
	 SIGNAL	n1Oll1O	:	STD_LOGIC := '0';
	 SIGNAL	n1Ollii	:	STD_LOGIC := '0';
	 SIGNAL	n1Ollil	:	STD_LOGIC := '0';
	 SIGNAL	n1OlliO	:	STD_LOGIC := '0';
	 SIGNAL	n1Ollli	:	STD_LOGIC := '0';
	 SIGNAL	n1Ollll	:	STD_LOGIC := '0';
	 SIGNAL	n1OlllO	:	STD_LOGIC := '0';
	 SIGNAL	n1OllOi	:	STD_LOGIC := '0';
	 SIGNAL	n1OllOl	:	STD_LOGIC := '0';
	 SIGNAL	n1OllOO	:	STD_LOGIC := '0';
	 SIGNAL	n1OlO0i	:	STD_LOGIC := '0';
	 SIGNAL	n1OlO0l	:	STD_LOGIC := '0';
	 SIGNAL	n1OlO0O	:	STD_LOGIC := '0';
	 SIGNAL	n1OlO1i	:	STD_LOGIC := '0';
	 SIGNAL	n1OlO1l	:	STD_LOGIC := '0';
	 SIGNAL	n1OlO1O	:	STD_LOGIC := '0';
	 SIGNAL	n1OlOii	:	STD_LOGIC := '0';
	 SIGNAL	n1OlOil	:	STD_LOGIC := '0';
	 SIGNAL	n1OlOiO	:	STD_LOGIC := '0';
	 SIGNAL	n1OlOli	:	STD_LOGIC := '0';
	 SIGNAL	n1OlOll	:	STD_LOGIC := '0';
	 SIGNAL	n1OlOlO	:	STD_LOGIC := '0';
	 SIGNAL	n1OlOOi	:	STD_LOGIC := '0';
	 SIGNAL	n1OlOOl	:	STD_LOGIC := '0';
	 SIGNAL	n1OlOOO	:	STD_LOGIC := '0';
	 SIGNAL	n1OO00i	:	STD_LOGIC := '0';
	 SIGNAL	n1OO00l	:	STD_LOGIC := '0';
	 SIGNAL	n1OO00O	:	STD_LOGIC := '0';
	 SIGNAL	n1OO01i	:	STD_LOGIC := '0';
	 SIGNAL	n1OO01l	:	STD_LOGIC := '0';
	 SIGNAL	n1OO01O	:	STD_LOGIC := '0';
	 SIGNAL	n1OO0ii	:	STD_LOGIC := '0';
	 SIGNAL	n1OO0il	:	STD_LOGIC := '0';
	 SIGNAL	n1OO0iO	:	STD_LOGIC := '0';
	 SIGNAL	n1OO0li	:	STD_LOGIC := '0';
	 SIGNAL	n1OO0ll	:	STD_LOGIC := '0';
	 SIGNAL	n1OO0lO	:	STD_LOGIC := '0';
	 SIGNAL	n1OO0Oi	:	STD_LOGIC := '0';
	 SIGNAL	n1OO0Ol	:	STD_LOGIC := '0';
	 SIGNAL	n1OO0OO	:	STD_LOGIC := '0';
	 SIGNAL	n1OO10i	:	STD_LOGIC := '0';
	 SIGNAL	n1OO10l	:	STD_LOGIC := '0';
	 SIGNAL	n1OO10O	:	STD_LOGIC := '0';
	 SIGNAL	n1OO11i	:	STD_LOGIC := '0';
	 SIGNAL	n1OO11l	:	STD_LOGIC := '0';
	 SIGNAL	n1OO11O	:	STD_LOGIC := '0';
	 SIGNAL	n1OO1ii	:	STD_LOGIC := '0';
	 SIGNAL	n1OO1il	:	STD_LOGIC := '0';
	 SIGNAL	n1OO1iO	:	STD_LOGIC := '0';
	 SIGNAL	n1OO1li	:	STD_LOGIC := '0';
	 SIGNAL	n1OO1ll	:	STD_LOGIC := '0';
	 SIGNAL	n1OO1lO	:	STD_LOGIC := '0';
	 SIGNAL	n1OO1Oi	:	STD_LOGIC := '0';
	 SIGNAL	n1OO1Ol	:	STD_LOGIC := '0';
	 SIGNAL	n1OO1OO	:	STD_LOGIC := '0';
	 SIGNAL	n1OOi0i	:	STD_LOGIC := '0';
	 SIGNAL	n1OOi0l	:	STD_LOGIC := '0';
	 SIGNAL	n1OOi0O	:	STD_LOGIC := '0';
	 SIGNAL	n1OOi1i	:	STD_LOGIC := '0';
	 SIGNAL	n1OOi1l	:	STD_LOGIC := '0';
	 SIGNAL	n1OOi1O	:	STD_LOGIC := '0';
	 SIGNAL	n1OOiii	:	STD_LOGIC := '0';
	 SIGNAL	n1OOiil	:	STD_LOGIC := '0';
	 SIGNAL	n1OOiiO	:	STD_LOGIC := '0';
	 SIGNAL	n1OOili	:	STD_LOGIC := '0';
	 SIGNAL	n1OOill	:	STD_LOGIC := '0';
	 SIGNAL	n1OOilO	:	STD_LOGIC := '0';
	 SIGNAL	n1OOiOi	:	STD_LOGIC := '0';
	 SIGNAL	n1OOiOl	:	STD_LOGIC := '0';
	 SIGNAL	n1OOiOO	:	STD_LOGIC := '0';
	 SIGNAL	n1OOl0i	:	STD_LOGIC := '0';
	 SIGNAL	n1OOl0l	:	STD_LOGIC := '0';
	 SIGNAL	n1OOl0O	:	STD_LOGIC := '0';
	 SIGNAL	n1OOl1i	:	STD_LOGIC := '0';
	 SIGNAL	n1OOl1l	:	STD_LOGIC := '0';
	 SIGNAL	n1OOl1O	:	STD_LOGIC := '0';
	 SIGNAL	n1OOlii	:	STD_LOGIC := '0';
	 SIGNAL	n1OOlil	:	STD_LOGIC := '0';
	 SIGNAL	n1OOliO	:	STD_LOGIC := '0';
	 SIGNAL	n1OOlli	:	STD_LOGIC := '0';
	 SIGNAL	n1OOlll	:	STD_LOGIC := '0';
	 SIGNAL	n1OOllO	:	STD_LOGIC := '0';
	 SIGNAL	n1OOlOi	:	STD_LOGIC := '0';
	 SIGNAL	n1OOlOl	:	STD_LOGIC := '0';
	 SIGNAL	n1OOlOO	:	STD_LOGIC := '0';
	 SIGNAL	n1OOO0i	:	STD_LOGIC := '0';
	 SIGNAL	n1OOO0l	:	STD_LOGIC := '0';
	 SIGNAL	n1OOO0O	:	STD_LOGIC := '0';
	 SIGNAL	n1OOO1i	:	STD_LOGIC := '0';
	 SIGNAL	n1OOO1l	:	STD_LOGIC := '0';
	 SIGNAL	n1OOO1O	:	STD_LOGIC := '0';
	 SIGNAL	n1OOOii	:	STD_LOGIC := '0';
	 SIGNAL	n1OOOil	:	STD_LOGIC := '0';
	 SIGNAL	n1OOOiO	:	STD_LOGIC := '0';
	 SIGNAL	n1OOOli	:	STD_LOGIC := '0';
	 SIGNAL	n1OOOll	:	STD_LOGIC := '0';
	 SIGNAL	n1OOOlO	:	STD_LOGIC := '0';
	 SIGNAL	n1OOOOi	:	STD_LOGIC := '0';
	 SIGNAL	n1OOOOl	:	STD_LOGIC := '0';
	 SIGNAL	n1OOOOO	:	STD_LOGIC := '0';
	 SIGNAL	ni1ilOl	:	STD_LOGIC := '0';
	 SIGNAL	ni1ilOO	:	STD_LOGIC := '0';
	 SIGNAL	ni1iO0i	:	STD_LOGIC := '0';
	 SIGNAL	ni1iO0l	:	STD_LOGIC := '0';
	 SIGNAL	ni1iO0O	:	STD_LOGIC := '0';
	 SIGNAL	ni1iO1O	:	STD_LOGIC := '0';
	 SIGNAL	ni1iOii	:	STD_LOGIC := '0';
	 SIGNAL	ni1iOil	:	STD_LOGIC := '0';
	 SIGNAL	ni1iOiO	:	STD_LOGIC := '0';
	 SIGNAL	ni1iOli	:	STD_LOGIC := '0';
	 SIGNAL	ni1iOll	:	STD_LOGIC := '0';
	 SIGNAL	ni1iOlO	:	STD_LOGIC := '0';
	 SIGNAL	ni1iOOi	:	STD_LOGIC := '0';
	 SIGNAL	ni1iOOl	:	STD_LOGIC := '0';
	 SIGNAL	ni1iOOO	:	STD_LOGIC := '0';
	 SIGNAL	ni1l10i	:	STD_LOGIC := '0';
	 SIGNAL	ni1l10l	:	STD_LOGIC := '0';
	 SIGNAL	ni1l11i	:	STD_LOGIC := '0';
	 SIGNAL	ni1l11l	:	STD_LOGIC := '0';
	 SIGNAL	ni1l11O	:	STD_LOGIC := '0';
	 SIGNAL	ni1l1ii	:	STD_LOGIC := '0';
	 SIGNAL	nilOlllil	:	STD_LOGIC := '0';
	 SIGNAL	nilOllOiO	:	STD_LOGIC := '0';
	 SIGNAL	nilOllOli	:	STD_LOGIC := '0';
	 SIGNAL	nilOllOll	:	STD_LOGIC := '0';
	 SIGNAL	nilOllOlO	:	STD_LOGIC := '0';
	 SIGNAL	nilOllOOi	:	STD_LOGIC := '0';
	 SIGNAL	nilOllOOl	:	STD_LOGIC := '0';
	 SIGNAL	nilOllOOO	:	STD_LOGIC := '0';
	 SIGNAL	nilOlO00i	:	STD_LOGIC := '0';
	 SIGNAL	nilOlO00l	:	STD_LOGIC := '0';
	 SIGNAL	nilOlO00O	:	STD_LOGIC := '0';
	 SIGNAL	nilOlO01i	:	STD_LOGIC := '0';
	 SIGNAL	nilOlO01l	:	STD_LOGIC := '0';
	 SIGNAL	nilOlO01O	:	STD_LOGIC := '0';
	 SIGNAL	nilOlO0ii	:	STD_LOGIC := '0';
	 SIGNAL	nilOlO0il	:	STD_LOGIC := '0';
	 SIGNAL	nilOlO0iO	:	STD_LOGIC := '0';
	 SIGNAL	nilOlO0li	:	STD_LOGIC := '0';
	 SIGNAL	nilOlO0ll	:	STD_LOGIC := '0';
	 SIGNAL	nilOlO0lO	:	STD_LOGIC := '0';
	 SIGNAL	nilOlO0Oi	:	STD_LOGIC := '0';
	 SIGNAL	nilOlO0Ol	:	STD_LOGIC := '0';
	 SIGNAL	nilOlO0OO	:	STD_LOGIC := '0';
	 SIGNAL	nilOlO10i	:	STD_LOGIC := '0';
	 SIGNAL	nilOlO10l	:	STD_LOGIC := '0';
	 SIGNAL	nilOlO10O	:	STD_LOGIC := '0';
	 SIGNAL	nilOlO11i	:	STD_LOGIC := '0';
	 SIGNAL	nilOlO11l	:	STD_LOGIC := '0';
	 SIGNAL	nilOlO11O	:	STD_LOGIC := '0';
	 SIGNAL	nilOlO1ii	:	STD_LOGIC := '0';
	 SIGNAL	nilOlO1il	:	STD_LOGIC := '0';
	 SIGNAL	nilOlO1iO	:	STD_LOGIC := '0';
	 SIGNAL	nilOlO1li	:	STD_LOGIC := '0';
	 SIGNAL	nilOlO1ll	:	STD_LOGIC := '0';
	 SIGNAL	nilOlO1lO	:	STD_LOGIC := '0';
	 SIGNAL	nilOlO1Oi	:	STD_LOGIC := '0';
	 SIGNAL	nilOlO1Ol	:	STD_LOGIC := '0';
	 SIGNAL	nilOlO1OO	:	STD_LOGIC := '0';
	 SIGNAL	nilOlOi0i	:	STD_LOGIC := '0';
	 SIGNAL	nilOlOi0l	:	STD_LOGIC := '0';
	 SIGNAL	nilOlOi0O	:	STD_LOGIC := '0';
	 SIGNAL	nilOlOi1i	:	STD_LOGIC := '0';
	 SIGNAL	nilOlOi1l	:	STD_LOGIC := '0';
	 SIGNAL	nilOlOi1O	:	STD_LOGIC := '0';
	 SIGNAL	nilOlOiii	:	STD_LOGIC := '0';
	 SIGNAL	nilOlOiil	:	STD_LOGIC := '0';
	 SIGNAL	nilOlOiiO	:	STD_LOGIC := '0';
	 SIGNAL	nilOlOili	:	STD_LOGIC := '0';
	 SIGNAL	nilOlOill	:	STD_LOGIC := '0';
	 SIGNAL	nilOlOilO	:	STD_LOGIC := '0';
	 SIGNAL	nilOlOiOi	:	STD_LOGIC := '0';
	 SIGNAL	nilOlOiOl	:	STD_LOGIC := '0';
	 SIGNAL	nilOlOiOO	:	STD_LOGIC := '0';
	 SIGNAL	nilOlOl0i	:	STD_LOGIC := '0';
	 SIGNAL	nilOlOl0l	:	STD_LOGIC := '0';
	 SIGNAL	nilOlOl0O	:	STD_LOGIC := '0';
	 SIGNAL	nilOlOl1i	:	STD_LOGIC := '0';
	 SIGNAL	nilOlOl1l	:	STD_LOGIC := '0';
	 SIGNAL	nilOlOl1O	:	STD_LOGIC := '0';
	 SIGNAL	nilOlOlii	:	STD_LOGIC := '0';
	 SIGNAL	nilOO000i	:	STD_LOGIC := '0';
	 SIGNAL	nilOO000l	:	STD_LOGIC := '0';
	 SIGNAL	nilOO000O	:	STD_LOGIC := '0';
	 SIGNAL	nilOO001i	:	STD_LOGIC := '0';
	 SIGNAL	nilOO001l	:	STD_LOGIC := '0';
	 SIGNAL	nilOO001O	:	STD_LOGIC := '0';
	 SIGNAL	nilOO010i	:	STD_LOGIC := '0';
	 SIGNAL	nilOO010l	:	STD_LOGIC := '0';
	 SIGNAL	nilOO010O	:	STD_LOGIC := '0';
	 SIGNAL	nilOO011i	:	STD_LOGIC := '0';
	 SIGNAL	nilOO011l	:	STD_LOGIC := '0';
	 SIGNAL	nilOO011O	:	STD_LOGIC := '0';
	 SIGNAL	nilOO01ii	:	STD_LOGIC := '0';
	 SIGNAL	nilOO01il	:	STD_LOGIC := '0';
	 SIGNAL	nilOO01iO	:	STD_LOGIC := '0';
	 SIGNAL	nilOO01li	:	STD_LOGIC := '0';
	 SIGNAL	nilOO01ll	:	STD_LOGIC := '0';
	 SIGNAL	nilOO01lO	:	STD_LOGIC := '0';
	 SIGNAL	nilOO01Oi	:	STD_LOGIC := '0';
	 SIGNAL	nilOO01Ol	:	STD_LOGIC := '0';
	 SIGNAL	nilOO01OO	:	STD_LOGIC := '0';
	 SIGNAL	nilOO1ili	:	STD_LOGIC := '0';
	 SIGNAL	nilOO1O0i	:	STD_LOGIC := '0';
	 SIGNAL	nilOO1O0l	:	STD_LOGIC := '0';
	 SIGNAL	nilOO1O0O	:	STD_LOGIC := '0';
	 SIGNAL	nilOO1O1i	:	STD_LOGIC := '0';
	 SIGNAL	nilOO1O1l	:	STD_LOGIC := '0';
	 SIGNAL	nilOO1O1O	:	STD_LOGIC := '0';
	 SIGNAL	nilOO1Oii	:	STD_LOGIC := '0';
	 SIGNAL	nilOO1Oil	:	STD_LOGIC := '0';
	 SIGNAL	nilOO1OiO	:	STD_LOGIC := '0';
	 SIGNAL	nilOO1Oli	:	STD_LOGIC := '0';
	 SIGNAL	nilOO1Oll	:	STD_LOGIC := '0';
	 SIGNAL	nilOO1OlO	:	STD_LOGIC := '0';
	 SIGNAL	nilOO1OOi	:	STD_LOGIC := '0';
	 SIGNAL	nilOO1OOl	:	STD_LOGIC := '0';
	 SIGNAL	nilOO1OOO	:	STD_LOGIC := '0';
	 SIGNAL	nilOOii0O	:	STD_LOGIC := '0';
	 SIGNAL	nilOOiiii	:	STD_LOGIC := '0';
	 SIGNAL	nilOOiiil	:	STD_LOGIC := '0';
	 SIGNAL	nilOOiiiO	:	STD_LOGIC := '0';
	 SIGNAL	nilOOiili	:	STD_LOGIC := '0';
	 SIGNAL	nilOOiill	:	STD_LOGIC := '0';
	 SIGNAL	nilOOiilO	:	STD_LOGIC := '0';
	 SIGNAL	nilOOiiOi	:	STD_LOGIC := '0';
	 SIGNAL	nilOOiiOl	:	STD_LOGIC := '0';
	 SIGNAL	nilOOiiOO	:	STD_LOGIC := '0';
	 SIGNAL	nilOOil0i	:	STD_LOGIC := '0';
	 SIGNAL	nilOOil0l	:	STD_LOGIC := '0';
	 SIGNAL	nilOOil0O	:	STD_LOGIC := '0';
	 SIGNAL	nilOOil1i	:	STD_LOGIC := '0';
	 SIGNAL	nilOOil1l	:	STD_LOGIC := '0';
	 SIGNAL	nilOOil1O	:	STD_LOGIC := '0';
	 SIGNAL	nilOOilii	:	STD_LOGIC := '0';
	 SIGNAL	nilOOilil	:	STD_LOGIC := '0';
	 SIGNAL	nilOOiliO	:	STD_LOGIC := '0';
	 SIGNAL	nilOOilli	:	STD_LOGIC := '0';
	 SIGNAL	nilOOilll	:	STD_LOGIC := '0';
	 SIGNAL	nilOOillO	:	STD_LOGIC := '0';
	 SIGNAL	nilOOilOi	:	STD_LOGIC := '0';
	 SIGNAL	nilOOilOl	:	STD_LOGIC := '0';
	 SIGNAL	nilOOilOO	:	STD_LOGIC := '0';
	 SIGNAL	nilOOiO0i	:	STD_LOGIC := '0';
	 SIGNAL	nilOOiO0l	:	STD_LOGIC := '0';
	 SIGNAL	nilOOiO0O	:	STD_LOGIC := '0';
	 SIGNAL	nilOOiO1i	:	STD_LOGIC := '0';
	 SIGNAL	nilOOiO1l	:	STD_LOGIC := '0';
	 SIGNAL	nilOOiO1O	:	STD_LOGIC := '0';
	 SIGNAL	nilOOiOii	:	STD_LOGIC := '0';
	 SIGNAL	nilOOiOil	:	STD_LOGIC := '0';
	 SIGNAL	nilOOiOiO	:	STD_LOGIC := '0';
	 SIGNAL	nilOOiOli	:	STD_LOGIC := '0';
	 SIGNAL	nilOOiOll	:	STD_LOGIC := '0';
	 SIGNAL	nilOOiOlO	:	STD_LOGIC := '0';
	 SIGNAL	nilOOiOOi	:	STD_LOGIC := '0';
	 SIGNAL	nilOOiOOl	:	STD_LOGIC := '0';
	 SIGNAL	nilOOiOOO	:	STD_LOGIC := '0';
	 SIGNAL	nilOOl00i	:	STD_LOGIC := '0';
	 SIGNAL	nilOOl00l	:	STD_LOGIC := '0';
	 SIGNAL	nilOOl00O	:	STD_LOGIC := '0';
	 SIGNAL	nilOOl01i	:	STD_LOGIC := '0';
	 SIGNAL	nilOOl01l	:	STD_LOGIC := '0';
	 SIGNAL	nilOOl01O	:	STD_LOGIC := '0';
	 SIGNAL	nilOOl0ii	:	STD_LOGIC := '0';
	 SIGNAL	nilOOl0il	:	STD_LOGIC := '0';
	 SIGNAL	nilOOl0iO	:	STD_LOGIC := '0';
	 SIGNAL	nilOOl0li	:	STD_LOGIC := '0';
	 SIGNAL	nilOOl0ll	:	STD_LOGIC := '0';
	 SIGNAL	nilOOl10i	:	STD_LOGIC := '0';
	 SIGNAL	nilOOl10l	:	STD_LOGIC := '0';
	 SIGNAL	nilOOl10O	:	STD_LOGIC := '0';
	 SIGNAL	nilOOl11i	:	STD_LOGIC := '0';
	 SIGNAL	nilOOl11l	:	STD_LOGIC := '0';
	 SIGNAL	nilOOl11O	:	STD_LOGIC := '0';
	 SIGNAL	nilOOl1ii	:	STD_LOGIC := '0';
	 SIGNAL	nilOOl1il	:	STD_LOGIC := '0';
	 SIGNAL	nilOOl1iO	:	STD_LOGIC := '0';
	 SIGNAL	nilOOl1li	:	STD_LOGIC := '0';
	 SIGNAL	nilOOl1ll	:	STD_LOGIC := '0';
	 SIGNAL	nilOOl1lO	:	STD_LOGIC := '0';
	 SIGNAL	nilOOl1Oi	:	STD_LOGIC := '0';
	 SIGNAL	nilOOl1Ol	:	STD_LOGIC := '0';
	 SIGNAL	nilOOl1OO	:	STD_LOGIC := '0';
	 SIGNAL	niO10100i	:	STD_LOGIC := '0';
	 SIGNAL	niO10100l	:	STD_LOGIC := '0';
	 SIGNAL	niO10100O	:	STD_LOGIC := '0';
	 SIGNAL	niO10101i	:	STD_LOGIC := '0';
	 SIGNAL	niO10101l	:	STD_LOGIC := '0';
	 SIGNAL	niO10101O	:	STD_LOGIC := '0';
	 SIGNAL	niO1010ii	:	STD_LOGIC := '0';
	 SIGNAL	niO1010il	:	STD_LOGIC := '0';
	 SIGNAL	niO1010iO	:	STD_LOGIC := '0';
	 SIGNAL	niO1010li	:	STD_LOGIC := '0';
	 SIGNAL	niO1010ll	:	STD_LOGIC := '0';
	 SIGNAL	niO1010lO	:	STD_LOGIC := '0';
	 SIGNAL	niO1010Oi	:	STD_LOGIC := '0';
	 SIGNAL	niO1010Ol	:	STD_LOGIC := '0';
	 SIGNAL	niO1010OO	:	STD_LOGIC := '0';
	 SIGNAL	niO10110i	:	STD_LOGIC := '0';
	 SIGNAL	niO10110l	:	STD_LOGIC := '0';
	 SIGNAL	niO10110O	:	STD_LOGIC := '0';
	 SIGNAL	niO10111i	:	STD_LOGIC := '0';
	 SIGNAL	niO10111l	:	STD_LOGIC := '0';
	 SIGNAL	niO10111O	:	STD_LOGIC := '0';
	 SIGNAL	niO1011ii	:	STD_LOGIC := '0';
	 SIGNAL	niO1011il	:	STD_LOGIC := '0';
	 SIGNAL	niO1011iO	:	STD_LOGIC := '0';
	 SIGNAL	niO1011li	:	STD_LOGIC := '0';
	 SIGNAL	niO1011ll	:	STD_LOGIC := '0';
	 SIGNAL	niO1011lO	:	STD_LOGIC := '0';
	 SIGNAL	niO1011Oi	:	STD_LOGIC := '0';
	 SIGNAL	niO1011Ol	:	STD_LOGIC := '0';
	 SIGNAL	niO1011OO	:	STD_LOGIC := '0';
	 SIGNAL	niO101i0i	:	STD_LOGIC := '0';
	 SIGNAL	niO101i0l	:	STD_LOGIC := '0';
	 SIGNAL	niO101i0O	:	STD_LOGIC := '0';
	 SIGNAL	niO101i1i	:	STD_LOGIC := '0';
	 SIGNAL	niO101i1l	:	STD_LOGIC := '0';
	 SIGNAL	niO101i1O	:	STD_LOGIC := '0';
	 SIGNAL	niO101iii	:	STD_LOGIC := '0';
	 SIGNAL	niO101iil	:	STD_LOGIC := '0';
	 SIGNAL	niO101iiO	:	STD_LOGIC := '0';
	 SIGNAL	niO101ili	:	STD_LOGIC := '0';
	 SIGNAL	niO101ill	:	STD_LOGIC := '0';
	 SIGNAL	niO101ilO	:	STD_LOGIC := '0';
	 SIGNAL	niO101iOi	:	STD_LOGIC := '0';
	 SIGNAL	niO101iOl	:	STD_LOGIC := '0';
	 SIGNAL	niO101iOO	:	STD_LOGIC := '0';
	 SIGNAL	niO101l0i	:	STD_LOGIC := '0';
	 SIGNAL	niO101l0l	:	STD_LOGIC := '0';
	 SIGNAL	niO101l1i	:	STD_LOGIC := '0';
	 SIGNAL	niO101l1l	:	STD_LOGIC := '0';
	 SIGNAL	niO101l1O	:	STD_LOGIC := '0';
	 SIGNAL	niO10i0Ol	:	STD_LOGIC := '0';
	 SIGNAL	niO10ii0i	:	STD_LOGIC := '0';
	 SIGNAL	niO10ii0l	:	STD_LOGIC := '0';
	 SIGNAL	niO10ii0O	:	STD_LOGIC := '0';
	 SIGNAL	niO10ii1l	:	STD_LOGIC := '0';
	 SIGNAL	niO10ii1O	:	STD_LOGIC := '0';
	 SIGNAL	niO10iiii	:	STD_LOGIC := '0';
	 SIGNAL	niO10iiil	:	STD_LOGIC := '0';
	 SIGNAL	niO10iiiO	:	STD_LOGIC := '0';
	 SIGNAL	niO10iili	:	STD_LOGIC := '0';
	 SIGNAL	niO10iill	:	STD_LOGIC := '0';
	 SIGNAL	niO10iilO	:	STD_LOGIC := '0';
	 SIGNAL	niO10iiOi	:	STD_LOGIC := '0';
	 SIGNAL	niO10iiOl	:	STD_LOGIC := '0';
	 SIGNAL	niO10iiOO	:	STD_LOGIC := '0';
	 SIGNAL	niO10il0i	:	STD_LOGIC := '0';
	 SIGNAL	niO10il0l	:	STD_LOGIC := '0';
	 SIGNAL	niO10il0O	:	STD_LOGIC := '0';
	 SIGNAL	niO10il1i	:	STD_LOGIC := '0';
	 SIGNAL	niO10il1l	:	STD_LOGIC := '0';
	 SIGNAL	niO10il1O	:	STD_LOGIC := '0';
	 SIGNAL	niO10ilii	:	STD_LOGIC := '0';
	 SIGNAL	niO10ilil	:	STD_LOGIC := '0';
	 SIGNAL	niO10iliO	:	STD_LOGIC := '0';
	 SIGNAL	niO10illi	:	STD_LOGIC := '0';
	 SIGNAL	niO10illl	:	STD_LOGIC := '0';
	 SIGNAL	niO10illO	:	STD_LOGIC := '0';
	 SIGNAL	niO10ilOi	:	STD_LOGIC := '0';
	 SIGNAL	niO10ilOl	:	STD_LOGIC := '0';
	 SIGNAL	niO10ilOO	:	STD_LOGIC := '0';
	 SIGNAL	niO10iO0i	:	STD_LOGIC := '0';
	 SIGNAL	niO10iO0l	:	STD_LOGIC := '0';
	 SIGNAL	niO10iO0O	:	STD_LOGIC := '0';
	 SIGNAL	niO10iO1i	:	STD_LOGIC := '0';
	 SIGNAL	niO10iO1l	:	STD_LOGIC := '0';
	 SIGNAL	niO10iO1O	:	STD_LOGIC := '0';
	 SIGNAL	niO10iOii	:	STD_LOGIC := '0';
	 SIGNAL	niO10iOil	:	STD_LOGIC := '0';
	 SIGNAL	niO10iOiO	:	STD_LOGIC := '0';
	 SIGNAL	niO10iOli	:	STD_LOGIC := '0';
	 SIGNAL	niO10iOll	:	STD_LOGIC := '0';
	 SIGNAL	niO10iOlO	:	STD_LOGIC := '0';
	 SIGNAL	niO10iOOi	:	STD_LOGIC := '0';
	 SIGNAL	niO10iOOl	:	STD_LOGIC := '0';
	 SIGNAL	niO10iOOO	:	STD_LOGIC := '0';
	 SIGNAL	niO10l00i	:	STD_LOGIC := '0';
	 SIGNAL	niO10l00l	:	STD_LOGIC := '0';
	 SIGNAL	niO10l01i	:	STD_LOGIC := '0';
	 SIGNAL	niO10l01l	:	STD_LOGIC := '0';
	 SIGNAL	niO10l01O	:	STD_LOGIC := '0';
	 SIGNAL	niO10l10i	:	STD_LOGIC := '0';
	 SIGNAL	niO10l10l	:	STD_LOGIC := '0';
	 SIGNAL	niO10l10O	:	STD_LOGIC := '0';
	 SIGNAL	niO10l11i	:	STD_LOGIC := '0';
	 SIGNAL	niO10l11l	:	STD_LOGIC := '0';
	 SIGNAL	niO10l11O	:	STD_LOGIC := '0';
	 SIGNAL	niO10l1ii	:	STD_LOGIC := '0';
	 SIGNAL	niO10l1il	:	STD_LOGIC := '0';
	 SIGNAL	niO10l1iO	:	STD_LOGIC := '0';
	 SIGNAL	niO10l1li	:	STD_LOGIC := '0';
	 SIGNAL	niO10l1ll	:	STD_LOGIC := '0';
	 SIGNAL	niO10l1lO	:	STD_LOGIC := '0';
	 SIGNAL	niO10l1Oi	:	STD_LOGIC := '0';
	 SIGNAL	niO10l1Ol	:	STD_LOGIC := '0';
	 SIGNAL	niO10l1OO	:	STD_LOGIC := '0';
	 SIGNAL	niO11i00i	:	STD_LOGIC := '0';
	 SIGNAL	niO11i00l	:	STD_LOGIC := '0';
	 SIGNAL	niO11i00O	:	STD_LOGIC := '0';
	 SIGNAL	niO11i01i	:	STD_LOGIC := '0';
	 SIGNAL	niO11i01l	:	STD_LOGIC := '0';
	 SIGNAL	niO11i01O	:	STD_LOGIC := '0';
	 SIGNAL	niO11i0ii	:	STD_LOGIC := '0';
	 SIGNAL	niO11i0il	:	STD_LOGIC := '0';
	 SIGNAL	niO11i0iO	:	STD_LOGIC := '0';
	 SIGNAL	niO11i0li	:	STD_LOGIC := '0';
	 SIGNAL	niO11i0ll	:	STD_LOGIC := '0';
	 SIGNAL	niO11i0lO	:	STD_LOGIC := '0';
	 SIGNAL	niO11i0Oi	:	STD_LOGIC := '0';
	 SIGNAL	niO11i0Ol	:	STD_LOGIC := '0';
	 SIGNAL	niO11i0OO	:	STD_LOGIC := '0';
	 SIGNAL	niO11i1ii	:	STD_LOGIC := '0';
	 SIGNAL	niO11i1il	:	STD_LOGIC := '0';
	 SIGNAL	niO11i1iO	:	STD_LOGIC := '0';
	 SIGNAL	niO11i1li	:	STD_LOGIC := '0';
	 SIGNAL	niO11i1ll	:	STD_LOGIC := '0';
	 SIGNAL	niO11i1lO	:	STD_LOGIC := '0';
	 SIGNAL	niO11i1Oi	:	STD_LOGIC := '0';
	 SIGNAL	niO11i1Ol	:	STD_LOGIC := '0';
	 SIGNAL	niO11i1OO	:	STD_LOGIC := '0';
	 SIGNAL	niO11ii0i	:	STD_LOGIC := '0';
	 SIGNAL	niO11ii0l	:	STD_LOGIC := '0';
	 SIGNAL	niO11ii0O	:	STD_LOGIC := '0';
	 SIGNAL	niO11ii1i	:	STD_LOGIC := '0';
	 SIGNAL	niO11ii1l	:	STD_LOGIC := '0';
	 SIGNAL	niO11ii1O	:	STD_LOGIC := '0';
	 SIGNAL	niO11iiii	:	STD_LOGIC := '0';
	 SIGNAL	niO11iiil	:	STD_LOGIC := '0';
	 SIGNAL	niO11iiiO	:	STD_LOGIC := '0';
	 SIGNAL	niO11iili	:	STD_LOGIC := '0';
	 SIGNAL	niO11iill	:	STD_LOGIC := '0';
	 SIGNAL	niO11iilO	:	STD_LOGIC := '0';
	 SIGNAL	niO11iiOi	:	STD_LOGIC := '0';
	 SIGNAL	niO11iiOl	:	STD_LOGIC := '0';
	 SIGNAL	niO11iiOO	:	STD_LOGIC := '0';
	 SIGNAL	niO11il0i	:	STD_LOGIC := '0';
	 SIGNAL	niO11il0l	:	STD_LOGIC := '0';
	 SIGNAL	niO11il0O	:	STD_LOGIC := '0';
	 SIGNAL	niO11il1i	:	STD_LOGIC := '0';
	 SIGNAL	niO11il1l	:	STD_LOGIC := '0';
	 SIGNAL	niO11il1O	:	STD_LOGIC := '0';
	 SIGNAL	niO11ilii	:	STD_LOGIC := '0';
	 SIGNAL	niO11ilil	:	STD_LOGIC := '0';
	 SIGNAL	niO11iliO	:	STD_LOGIC := '0';
	 SIGNAL	niO11illi	:	STD_LOGIC := '0';
	 SIGNAL	niO11illl	:	STD_LOGIC := '0';
	 SIGNAL	niO11illO	:	STD_LOGIC := '0';
	 SIGNAL	niO11ilOi	:	STD_LOGIC := '0';
	 SIGNAL	niO11ilOl	:	STD_LOGIC := '0';
	 SIGNAL	niO11ilOO	:	STD_LOGIC := '0';
	 SIGNAL	niO11iO0i	:	STD_LOGIC := '0';
	 SIGNAL	niO11iO0l	:	STD_LOGIC := '0';
	 SIGNAL	niO11iO1i	:	STD_LOGIC := '0';
	 SIGNAL	niO11iO1l	:	STD_LOGIC := '0';
	 SIGNAL	niO11iO1O	:	STD_LOGIC := '0';
	 SIGNAL	niO11OO0i	:	STD_LOGIC := '0';
	 SIGNAL	niO11OO0l	:	STD_LOGIC := '0';
	 SIGNAL	niO11OO0O	:	STD_LOGIC := '0';
	 SIGNAL	niO11OO1l	:	STD_LOGIC := '0';
	 SIGNAL	niO11OO1O	:	STD_LOGIC := '0';
	 SIGNAL	niO11OOii	:	STD_LOGIC := '0';
	 SIGNAL	niO11OOil	:	STD_LOGIC := '0';
	 SIGNAL	niO11OOiO	:	STD_LOGIC := '0';
	 SIGNAL	niO11OOli	:	STD_LOGIC := '0';
	 SIGNAL	niO11OOll	:	STD_LOGIC := '0';
	 SIGNAL	niO11OOlO	:	STD_LOGIC := '0';
	 SIGNAL	niO11OOOi	:	STD_LOGIC := '0';
	 SIGNAL	niO11OOOl	:	STD_LOGIC := '0';
	 SIGNAL	niO11OOOO	:	STD_LOGIC := '0';
	 SIGNAL	niO1i000i	:	STD_LOGIC := '0';
	 SIGNAL	niO1i000l	:	STD_LOGIC := '0';
	 SIGNAL	niO1i000O	:	STD_LOGIC := '0';
	 SIGNAL	niO1i001i	:	STD_LOGIC := '0';
	 SIGNAL	niO1i001l	:	STD_LOGIC := '0';
	 SIGNAL	niO1i001O	:	STD_LOGIC := '0';
	 SIGNAL	niO1i00ii	:	STD_LOGIC := '0';
	 SIGNAL	niO1i00il	:	STD_LOGIC := '0';
	 SIGNAL	niO1i00iO	:	STD_LOGIC := '0';
	 SIGNAL	niO1i00li	:	STD_LOGIC := '0';
	 SIGNAL	niO1i00ll	:	STD_LOGIC := '0';
	 SIGNAL	niO1i00lO	:	STD_LOGIC := '0';
	 SIGNAL	niO1i00Oi	:	STD_LOGIC := '0';
	 SIGNAL	niO1i00Ol	:	STD_LOGIC := '0';
	 SIGNAL	niO1i00OO	:	STD_LOGIC := '0';
	 SIGNAL	niO1i010i	:	STD_LOGIC := '0';
	 SIGNAL	niO1i010l	:	STD_LOGIC := '0';
	 SIGNAL	niO1i010O	:	STD_LOGIC := '0';
	 SIGNAL	niO1i011i	:	STD_LOGIC := '0';
	 SIGNAL	niO1i011l	:	STD_LOGIC := '0';
	 SIGNAL	niO1i011O	:	STD_LOGIC := '0';
	 SIGNAL	niO1i01ii	:	STD_LOGIC := '0';
	 SIGNAL	niO1i01il	:	STD_LOGIC := '0';
	 SIGNAL	niO1i01iO	:	STD_LOGIC := '0';
	 SIGNAL	niO1i01li	:	STD_LOGIC := '0';
	 SIGNAL	niO1i01ll	:	STD_LOGIC := '0';
	 SIGNAL	niO1i01lO	:	STD_LOGIC := '0';
	 SIGNAL	niO1i01Oi	:	STD_LOGIC := '0';
	 SIGNAL	niO1i01Ol	:	STD_LOGIC := '0';
	 SIGNAL	niO1i01OO	:	STD_LOGIC := '0';
	 SIGNAL	niO1i0i0i	:	STD_LOGIC := '0';
	 SIGNAL	niO1i0i0l	:	STD_LOGIC := '0';
	 SIGNAL	niO1i0i0O	:	STD_LOGIC := '0';
	 SIGNAL	niO1i0i1i	:	STD_LOGIC := '0';
	 SIGNAL	niO1i0i1l	:	STD_LOGIC := '0';
	 SIGNAL	niO1i0i1O	:	STD_LOGIC := '0';
	 SIGNAL	niO1i0iii	:	STD_LOGIC := '0';
	 SIGNAL	niO1i0iil	:	STD_LOGIC := '0';
	 SIGNAL	niO1i0iiO	:	STD_LOGIC := '0';
	 SIGNAL	niO1i0ili	:	STD_LOGIC := '0';
	 SIGNAL	niO1i0ill	:	STD_LOGIC := '0';
	 SIGNAL	niO1i0ilO	:	STD_LOGIC := '0';
	 SIGNAL	niO1i0iOi	:	STD_LOGIC := '0';
	 SIGNAL	niO1i0iOl	:	STD_LOGIC := '0';
	 SIGNAL	niO1i0iOO	:	STD_LOGIC := '0';
	 SIGNAL	niO1i0l0i	:	STD_LOGIC := '0';
	 SIGNAL	niO1i0l0l	:	STD_LOGIC := '0';
	 SIGNAL	niO1i0l0O	:	STD_LOGIC := '0';
	 SIGNAL	niO1i0l1i	:	STD_LOGIC := '0';
	 SIGNAL	niO1i0l1l	:	STD_LOGIC := '0';
	 SIGNAL	niO1i0l1O	:	STD_LOGIC := '0';
	 SIGNAL	niO1i0lii	:	STD_LOGIC := '0';
	 SIGNAL	niO1i0lil	:	STD_LOGIC := '0';
	 SIGNAL	niO1i1O0l	:	STD_LOGIC := '0';
	 SIGNAL	niO1i1O0O	:	STD_LOGIC := '0';
	 SIGNAL	niO1i1Oii	:	STD_LOGIC := '0';
	 SIGNAL	niO1i1Oil	:	STD_LOGIC := '0';
	 SIGNAL	niO1i1OiO	:	STD_LOGIC := '0';
	 SIGNAL	niO1i1Oli	:	STD_LOGIC := '0';
	 SIGNAL	niO1i1Oll	:	STD_LOGIC := '0';
	 SIGNAL	niO1i1OlO	:	STD_LOGIC := '0';
	 SIGNAL	niO1i1OOi	:	STD_LOGIC := '0';
	 SIGNAL	niO1i1OOl	:	STD_LOGIC := '0';
	 SIGNAL	niO1i1OOO	:	STD_LOGIC := '0';
	 SIGNAL	niO1iO0il	:	STD_LOGIC := '0';
	 SIGNAL	niO1iO0iO	:	STD_LOGIC := '0';
	 SIGNAL	niO1iO0li	:	STD_LOGIC := '0';
	 SIGNAL	niO1iOiOi	:	STD_LOGIC := '0';
	 SIGNAL	niO1iOiOl	:	STD_LOGIC := '0';
	 SIGNAL	niO1iOiOO	:	STD_LOGIC := '0';
	 SIGNAL	niO1iOl0i	:	STD_LOGIC := '0';
	 SIGNAL	niO1iOl0l	:	STD_LOGIC := '0';
	 SIGNAL	niO1iOl0O	:	STD_LOGIC := '0';
	 SIGNAL	niO1iOl1i	:	STD_LOGIC := '0';
	 SIGNAL	niO1iOl1l	:	STD_LOGIC := '0';
	 SIGNAL	niO1iOl1O	:	STD_LOGIC := '0';
	 SIGNAL	niO1iOlii	:	STD_LOGIC := '0';
	 SIGNAL	niO1iOlil	:	STD_LOGIC := '0';
	 SIGNAL	niO1iOliO	:	STD_LOGIC := '0';
	 SIGNAL	niO1iOlli	:	STD_LOGIC := '0';
	 SIGNAL	niO1iOlll	:	STD_LOGIC := '0';
	 SIGNAL	niO1iOllO	:	STD_LOGIC := '0';
	 SIGNAL	niO1iOlOi	:	STD_LOGIC := '0';
	 SIGNAL	niO1iOlOl	:	STD_LOGIC := '0';
	 SIGNAL	niO1iOlOO	:	STD_LOGIC := '0';
	 SIGNAL	niO1iOO0i	:	STD_LOGIC := '0';
	 SIGNAL	niO1iOO0l	:	STD_LOGIC := '0';
	 SIGNAL	niO1iOO1i	:	STD_LOGIC := '0';
	 SIGNAL	niO1iOO1l	:	STD_LOGIC := '0';
	 SIGNAL	niO1iOO1O	:	STD_LOGIC := '0';
	 SIGNAL	niO1l000i	:	STD_LOGIC := '0';
	 SIGNAL	niO1l000O	:	STD_LOGIC := '0';
	 SIGNAL	niO1l001i	:	STD_LOGIC := '0';
	 SIGNAL	niO1l001l	:	STD_LOGIC := '0';
	 SIGNAL	niO1l001O	:	STD_LOGIC := '0';
	 SIGNAL	niO1l00ii	:	STD_LOGIC := '0';
	 SIGNAL	niO1l00il	:	STD_LOGIC := '0';
	 SIGNAL	niO1l00iO	:	STD_LOGIC := '0';
	 SIGNAL	niO1l00li	:	STD_LOGIC := '0';
	 SIGNAL	niO1l00ll	:	STD_LOGIC := '0';
	 SIGNAL	niO1l00lO	:	STD_LOGIC := '0';
	 SIGNAL	niO1l00Oi	:	STD_LOGIC := '0';
	 SIGNAL	niO1l00Ol	:	STD_LOGIC := '0';
	 SIGNAL	niO1l00OO	:	STD_LOGIC := '0';
	 SIGNAL	niO1l010O	:	STD_LOGIC := '0';
	 SIGNAL	niO1l01ii	:	STD_LOGIC := '0';
	 SIGNAL	niO1l01il	:	STD_LOGIC := '0';
	 SIGNAL	niO1l01li	:	STD_LOGIC := '0';
	 SIGNAL	niO1l01ll	:	STD_LOGIC := '0';
	 SIGNAL	niO1l01lO	:	STD_LOGIC := '0';
	 SIGNAL	niO1l01Oi	:	STD_LOGIC := '0';
	 SIGNAL	niO1l01Ol	:	STD_LOGIC := '0';
	 SIGNAL	niO1l01OO	:	STD_LOGIC := '0';
	 SIGNAL	niO1l0i0i	:	STD_LOGIC := '0';
	 SIGNAL	niO1l0i0l	:	STD_LOGIC := '0';
	 SIGNAL	niO1l0i0O	:	STD_LOGIC := '0';
	 SIGNAL	niO1l0i1i	:	STD_LOGIC := '0';
	 SIGNAL	niO1l0i1l	:	STD_LOGIC := '0';
	 SIGNAL	niO1l0i1O	:	STD_LOGIC := '0';
	 SIGNAL	niO1l0iii	:	STD_LOGIC := '0';
	 SIGNAL	niO1l0iil	:	STD_LOGIC := '0';
	 SIGNAL	niO1l0iiO	:	STD_LOGIC := '0';
	 SIGNAL	niO1l0ili	:	STD_LOGIC := '0';
	 SIGNAL	niO1l0ill	:	STD_LOGIC := '0';
	 SIGNAL	niO1l0ilO	:	STD_LOGIC := '0';
	 SIGNAL	niO1l0iOi	:	STD_LOGIC := '0';
	 SIGNAL	niO1l0iOl	:	STD_LOGIC := '0';
	 SIGNAL	niO1l0iOO	:	STD_LOGIC := '0';
	 SIGNAL	niO1l0l0i	:	STD_LOGIC := '0';
	 SIGNAL	niO1l0l0l	:	STD_LOGIC := '0';
	 SIGNAL	niO1l0l0O	:	STD_LOGIC := '0';
	 SIGNAL	niO1l0l1i	:	STD_LOGIC := '0';
	 SIGNAL	niO1l0l1l	:	STD_LOGIC := '0';
	 SIGNAL	niO1l0l1O	:	STD_LOGIC := '0';
	 SIGNAL	niO1l0lii	:	STD_LOGIC := '0';
	 SIGNAL	niO1l0lil	:	STD_LOGIC := '0';
	 SIGNAL	nl10i000i	:	STD_LOGIC := '0';
	 SIGNAL	nl10i000l	:	STD_LOGIC := '0';
	 SIGNAL	nl10i000O	:	STD_LOGIC := '0';
	 SIGNAL	nl10i001i	:	STD_LOGIC := '0';
	 SIGNAL	nl10i001l	:	STD_LOGIC := '0';
	 SIGNAL	nl10i001O	:	STD_LOGIC := '0';
	 SIGNAL	nl10i00ii	:	STD_LOGIC := '0';
	 SIGNAL	nl10i00il	:	STD_LOGIC := '0';
	 SIGNAL	nl10i00iO	:	STD_LOGIC := '0';
	 SIGNAL	nl10i00li	:	STD_LOGIC := '0';
	 SIGNAL	nl10i00ll	:	STD_LOGIC := '0';
	 SIGNAL	nl10i00lO	:	STD_LOGIC := '0';
	 SIGNAL	nl10i00Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl10i00Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl10i00OO	:	STD_LOGIC := '0';
	 SIGNAL	nl10i010i	:	STD_LOGIC := '0';
	 SIGNAL	nl10i010l	:	STD_LOGIC := '0';
	 SIGNAL	nl10i010O	:	STD_LOGIC := '0';
	 SIGNAL	nl10i011i	:	STD_LOGIC := '0';
	 SIGNAL	nl10i011l	:	STD_LOGIC := '0';
	 SIGNAL	nl10i011O	:	STD_LOGIC := '0';
	 SIGNAL	nl10i01ii	:	STD_LOGIC := '0';
	 SIGNAL	nl10i01il	:	STD_LOGIC := '0';
	 SIGNAL	nl10i01iO	:	STD_LOGIC := '0';
	 SIGNAL	nl10i01li	:	STD_LOGIC := '0';
	 SIGNAL	nl10i01ll	:	STD_LOGIC := '0';
	 SIGNAL	nl10i01lO	:	STD_LOGIC := '0';
	 SIGNAL	nl10i01Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl10i01Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl10i01OO	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0i0i	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0i0l	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0i0O	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0i1i	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0i1l	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0i1O	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0iii	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0iil	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0iiO	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0ili	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0ill	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0ilO	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0iOi	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0iOl	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0iOO	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0l0i	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0l0l	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0l0O	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0l1i	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0l1l	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0l1O	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0lii	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0lil	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0liO	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0lli	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0lll	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0llO	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0lOi	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0lOl	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0lOO	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0O0i	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0O0l	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0O0O	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0O1i	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0O1l	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0O1O	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0Oii	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0Oil	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0OiO	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0Oli	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0Oll	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0OlO	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0OOi	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0OOl	:	STD_LOGIC := '0';
	 SIGNAL	nl10i0OOO	:	STD_LOGIC := '0';
	 SIGNAL	nl10i10lO	:	STD_LOGIC := '0';
	 SIGNAL	nl10i10Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl10i10Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl10i10OO	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1i0i	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1i0l	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1i0O	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1i1i	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1i1l	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1iii	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1iiO	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1ili	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1ill	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1ilO	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1iOi	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1iOl	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1iOO	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1l0i	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1l0l	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1l0O	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1l1i	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1l1l	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1l1O	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1lii	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1lil	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1liO	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1lli	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1lll	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1llO	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1lOi	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1lOl	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1lOO	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1O0i	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1O0l	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1O0O	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1O1i	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1O1l	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1O1O	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1Oii	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1Oil	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1OiO	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1Oli	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1Oll	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1OlO	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1OOi	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1OOl	:	STD_LOGIC := '0';
	 SIGNAL	nl10i1OOO	:	STD_LOGIC := '0';
	 SIGNAL	nl10ii00i	:	STD_LOGIC := '0';
	 SIGNAL	nl10ii00l	:	STD_LOGIC := '0';
	 SIGNAL	nl10ii00O	:	STD_LOGIC := '0';
	 SIGNAL	nl10ii01i	:	STD_LOGIC := '0';
	 SIGNAL	nl10ii01l	:	STD_LOGIC := '0';
	 SIGNAL	nl10ii01O	:	STD_LOGIC := '0';
	 SIGNAL	nl10ii0ii	:	STD_LOGIC := '0';
	 SIGNAL	nl10ii0il	:	STD_LOGIC := '0';
	 SIGNAL	nl10ii0iO	:	STD_LOGIC := '0';
	 SIGNAL	nl10ii0li	:	STD_LOGIC := '0';
	 SIGNAL	nl10ii0ll	:	STD_LOGIC := '0';
	 SIGNAL	nl10ii0lO	:	STD_LOGIC := '0';
	 SIGNAL	nl10ii0Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl10ii0Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl10ii0OO	:	STD_LOGIC := '0';
	 SIGNAL	nl10ii10i	:	STD_LOGIC := '0';
	 SIGNAL	nl10ii10l	:	STD_LOGIC := '0';
	 SIGNAL	nl10ii10O	:	STD_LOGIC := '0';
	 SIGNAL	nl10ii11i	:	STD_LOGIC := '0';
	 SIGNAL	nl10ii11l	:	STD_LOGIC := '0';
	 SIGNAL	nl10ii11O	:	STD_LOGIC := '0';
	 SIGNAL	nl10ii1ii	:	STD_LOGIC := '0';
	 SIGNAL	nl10ii1il	:	STD_LOGIC := '0';
	 SIGNAL	nl10ii1iO	:	STD_LOGIC := '0';
	 SIGNAL	nl10ii1li	:	STD_LOGIC := '0';
	 SIGNAL	nl10ii1ll	:	STD_LOGIC := '0';
	 SIGNAL	nl10ii1lO	:	STD_LOGIC := '0';
	 SIGNAL	nl10ii1Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl10ii1Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl10ii1OO	:	STD_LOGIC := '0';
	 SIGNAL	nl10iii0i	:	STD_LOGIC := '0';
	 SIGNAL	nl10iii0l	:	STD_LOGIC := '0';
	 SIGNAL	nl10iii0O	:	STD_LOGIC := '0';
	 SIGNAL	nl10iii1i	:	STD_LOGIC := '0';
	 SIGNAL	nl10iii1l	:	STD_LOGIC := '0';
	 SIGNAL	nl10iii1O	:	STD_LOGIC := '0';
	 SIGNAL	nl10iiiii	:	STD_LOGIC := '0';
	 SIGNAL	nl10iiiil	:	STD_LOGIC := '0';
	 SIGNAL	nl10iiiiO	:	STD_LOGIC := '0';
	 SIGNAL	nl10iiili	:	STD_LOGIC := '0';
	 SIGNAL	nl10iiill	:	STD_LOGIC := '0';
	 SIGNAL	nl10iiilO	:	STD_LOGIC := '0';
	 SIGNAL	nl10iiiOi	:	STD_LOGIC := '0';
	 SIGNAL	nl10iiiOl	:	STD_LOGIC := '0';
	 SIGNAL	nl10iiiOO	:	STD_LOGIC := '0';
	 SIGNAL	nl10iil0i	:	STD_LOGIC := '0';
	 SIGNAL	nl10iil0l	:	STD_LOGIC := '0';
	 SIGNAL	nl10iil0O	:	STD_LOGIC := '0';
	 SIGNAL	nl10iil1i	:	STD_LOGIC := '0';
	 SIGNAL	nl10iil1l	:	STD_LOGIC := '0';
	 SIGNAL	nl10iil1O	:	STD_LOGIC := '0';
	 SIGNAL	nl10iilii	:	STD_LOGIC := '0';
	 SIGNAL	nl10iilil	:	STD_LOGIC := '0';
	 SIGNAL	nl10iiliO	:	STD_LOGIC := '0';
	 SIGNAL	nl10iilli	:	STD_LOGIC := '0';
	 SIGNAL	nl10iilll	:	STD_LOGIC := '0';
	 SIGNAL	nl10iillO	:	STD_LOGIC := '0';
	 SIGNAL	nl10iilOi	:	STD_LOGIC := '0';
	 SIGNAL	nl10iilOl	:	STD_LOGIC := '0';
	 SIGNAL	nl10iilOO	:	STD_LOGIC := '0';
	 SIGNAL	nl10iiO0i	:	STD_LOGIC := '0';
	 SIGNAL	nl10iiO0l	:	STD_LOGIC := '0';
	 SIGNAL	nl10iiO0O	:	STD_LOGIC := '0';
	 SIGNAL	nl10iiO1i	:	STD_LOGIC := '0';
	 SIGNAL	nl10iiO1l	:	STD_LOGIC := '0';
	 SIGNAL	nl10iiO1O	:	STD_LOGIC := '0';
	 SIGNAL	nl10iiOii	:	STD_LOGIC := '0';
	 SIGNAL	nl10iiOil	:	STD_LOGIC := '0';
	 SIGNAL	nl10iiOiO	:	STD_LOGIC := '0';
	 SIGNAL	nl10iiOli	:	STD_LOGIC := '0';
	 SIGNAL	nl10iiOll	:	STD_LOGIC := '0';
	 SIGNAL	nl10iiOlO	:	STD_LOGIC := '0';
	 SIGNAL	nl10iiOOi	:	STD_LOGIC := '0';
	 SIGNAL	nl10iiOOl	:	STD_LOGIC := '0';
	 SIGNAL	nl10iiOOO	:	STD_LOGIC := '0';
	 SIGNAL	nl10il00i	:	STD_LOGIC := '0';
	 SIGNAL	nl10il00l	:	STD_LOGIC := '0';
	 SIGNAL	nl10il00O	:	STD_LOGIC := '0';
	 SIGNAL	nl10il01i	:	STD_LOGIC := '0';
	 SIGNAL	nl10il01l	:	STD_LOGIC := '0';
	 SIGNAL	nl10il01O	:	STD_LOGIC := '0';
	 SIGNAL	nl10il0ii	:	STD_LOGIC := '0';
	 SIGNAL	nl10il0il	:	STD_LOGIC := '0';
	 SIGNAL	nl10il0iO	:	STD_LOGIC := '0';
	 SIGNAL	nl10il0li	:	STD_LOGIC := '0';
	 SIGNAL	nl10il0ll	:	STD_LOGIC := '0';
	 SIGNAL	nl10il0lO	:	STD_LOGIC := '0';
	 SIGNAL	nl10il0Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl10il0Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl10il0OO	:	STD_LOGIC := '0';
	 SIGNAL	nl10il10i	:	STD_LOGIC := '0';
	 SIGNAL	nl10il10l	:	STD_LOGIC := '0';
	 SIGNAL	nl10il10O	:	STD_LOGIC := '0';
	 SIGNAL	nl10il11i	:	STD_LOGIC := '0';
	 SIGNAL	nl10il11l	:	STD_LOGIC := '0';
	 SIGNAL	nl10il11O	:	STD_LOGIC := '0';
	 SIGNAL	nl10il1ii	:	STD_LOGIC := '0';
	 SIGNAL	nl10il1il	:	STD_LOGIC := '0';
	 SIGNAL	nl10il1iO	:	STD_LOGIC := '0';
	 SIGNAL	nl10il1li	:	STD_LOGIC := '0';
	 SIGNAL	nl10il1ll	:	STD_LOGIC := '0';
	 SIGNAL	nl10il1lO	:	STD_LOGIC := '0';
	 SIGNAL	nl10il1Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl10il1Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl10il1OO	:	STD_LOGIC := '0';
	 SIGNAL	nl10ili0i	:	STD_LOGIC := '0';
	 SIGNAL	nl10ili0l	:	STD_LOGIC := '0';
	 SIGNAL	nl10ili0O	:	STD_LOGIC := '0';
	 SIGNAL	nl10ili1i	:	STD_LOGIC := '0';
	 SIGNAL	nl10ili1l	:	STD_LOGIC := '0';
	 SIGNAL	nl10ili1O	:	STD_LOGIC := '0';
	 SIGNAL	nl10iliii	:	STD_LOGIC := '0';
	 SIGNAL	nl10iliil	:	STD_LOGIC := '0';
	 SIGNAL	nl10iliiO	:	STD_LOGIC := '0';
	 SIGNAL	nl10ilili	:	STD_LOGIC := '0';
	 SIGNAL	nl10ilill	:	STD_LOGIC := '0';
	 SIGNAL	nl10ililO	:	STD_LOGIC := '0';
	 SIGNAL	nl10iliOi	:	STD_LOGIC := '0';
	 SIGNAL	nl10iliOl	:	STD_LOGIC := '0';
	 SIGNAL	nl10iliOO	:	STD_LOGIC := '0';
	 SIGNAL	nl10ill0i	:	STD_LOGIC := '0';
	 SIGNAL	nl10ill0l	:	STD_LOGIC := '0';
	 SIGNAL	nl10ill0O	:	STD_LOGIC := '0';
	 SIGNAL	nl10ill1i	:	STD_LOGIC := '0';
	 SIGNAL	nl10ill1l	:	STD_LOGIC := '0';
	 SIGNAL	nl10ill1O	:	STD_LOGIC := '0';
	 SIGNAL	nl10illii	:	STD_LOGIC := '0';
	 SIGNAL	nl10illil	:	STD_LOGIC := '0';
	 SIGNAL	nl10illiO	:	STD_LOGIC := '0';
	 SIGNAL	nl10illli	:	STD_LOGIC := '0';
	 SIGNAL	nl10illll	:	STD_LOGIC := '0';
	 SIGNAL	nl10illlO	:	STD_LOGIC := '0';
	 SIGNAL	nl10illOi	:	STD_LOGIC := '0';
	 SIGNAL	nl10illOl	:	STD_LOGIC := '0';
	 SIGNAL	nl10illOO	:	STD_LOGIC := '0';
	 SIGNAL	nl10ilO0i	:	STD_LOGIC := '0';
	 SIGNAL	nl10ilO0l	:	STD_LOGIC := '0';
	 SIGNAL	nl10ilO0O	:	STD_LOGIC := '0';
	 SIGNAL	nl10ilO1i	:	STD_LOGIC := '0';
	 SIGNAL	nl10ilO1l	:	STD_LOGIC := '0';
	 SIGNAL	nl10ilO1O	:	STD_LOGIC := '0';
	 SIGNAL	nl10ilOii	:	STD_LOGIC := '0';
	 SIGNAL	nl10ilOil	:	STD_LOGIC := '0';
	 SIGNAL	nl10ilOiO	:	STD_LOGIC := '0';
	 SIGNAL	nl10ilOli	:	STD_LOGIC := '0';
	 SIGNAL	nl10ilOll	:	STD_LOGIC := '0';
	 SIGNAL	nl10ilOlO	:	STD_LOGIC := '0';
	 SIGNAL	nl10ilOOi	:	STD_LOGIC := '0';
	 SIGNAL	nl10ilOOl	:	STD_LOGIC := '0';
	 SIGNAL	nl10ilOOO	:	STD_LOGIC := '0';
	 SIGNAL	nl10iO00i	:	STD_LOGIC := '0';
	 SIGNAL	nl10iO00l	:	STD_LOGIC := '0';
	 SIGNAL	nl10iO00O	:	STD_LOGIC := '0';
	 SIGNAL	nl10iO01i	:	STD_LOGIC := '0';
	 SIGNAL	nl10iO01l	:	STD_LOGIC := '0';
	 SIGNAL	nl10iO01O	:	STD_LOGIC := '0';
	 SIGNAL	nl10iO0ii	:	STD_LOGIC := '0';
	 SIGNAL	nl10iO0il	:	STD_LOGIC := '0';
	 SIGNAL	nl10iO0iO	:	STD_LOGIC := '0';
	 SIGNAL	nl10iO0li	:	STD_LOGIC := '0';
	 SIGNAL	nl10iO0ll	:	STD_LOGIC := '0';
	 SIGNAL	nl10iO0lO	:	STD_LOGIC := '0';
	 SIGNAL	nl10iO0Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl10iO0Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl10iO0OO	:	STD_LOGIC := '0';
	 SIGNAL	nl10iO10i	:	STD_LOGIC := '0';
	 SIGNAL	nl10iO10l	:	STD_LOGIC := '0';
	 SIGNAL	nl10iO10O	:	STD_LOGIC := '0';
	 SIGNAL	nl10iO11i	:	STD_LOGIC := '0';
	 SIGNAL	nl10iO11l	:	STD_LOGIC := '0';
	 SIGNAL	nl10iO11O	:	STD_LOGIC := '0';
	 SIGNAL	nl10iO1ii	:	STD_LOGIC := '0';
	 SIGNAL	nl10iO1il	:	STD_LOGIC := '0';
	 SIGNAL	nl10iO1iO	:	STD_LOGIC := '0';
	 SIGNAL	nl10iO1li	:	STD_LOGIC := '0';
	 SIGNAL	nl10iO1ll	:	STD_LOGIC := '0';
	 SIGNAL	nl10iO1lO	:	STD_LOGIC := '0';
	 SIGNAL	nl10iO1Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl10iO1Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl10iO1OO	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOi0i	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOi0l	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOi0O	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOi1i	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOi1l	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOi1O	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOiii	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOiil	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOiiO	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOili	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOill	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOilO	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOiOi	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOiOl	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOiOO	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOl0i	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOl0l	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOl0O	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOl1i	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOl1l	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOl1O	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOlii	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOlil	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOliO	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOlli	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOlll	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOllO	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOlOi	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOlOl	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOlOO	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOO0i	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOO0l	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOO0O	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOO1i	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOO1l	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOO1O	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOOii	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOOil	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOOiO	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOOli	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOOll	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOOlO	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOOOi	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOOOl	:	STD_LOGIC := '0';
	 SIGNAL	nl10iOOOO	:	STD_LOGIC := '0';
	 SIGNAL	nl10l000i	:	STD_LOGIC := '0';
	 SIGNAL	nl10l000l	:	STD_LOGIC := '0';
	 SIGNAL	nl10l000O	:	STD_LOGIC := '0';
	 SIGNAL	nl10l001i	:	STD_LOGIC := '0';
	 SIGNAL	nl10l001l	:	STD_LOGIC := '0';
	 SIGNAL	nl10l001O	:	STD_LOGIC := '0';
	 SIGNAL	nl10l00ii	:	STD_LOGIC := '0';
	 SIGNAL	nl10l00il	:	STD_LOGIC := '0';
	 SIGNAL	nl10l00iO	:	STD_LOGIC := '0';
	 SIGNAL	nl10l00li	:	STD_LOGIC := '0';
	 SIGNAL	nl10l00ll	:	STD_LOGIC := '0';
	 SIGNAL	nl10l00lO	:	STD_LOGIC := '0';
	 SIGNAL	nl10l00Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl10l00Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl10l00OO	:	STD_LOGIC := '0';
	 SIGNAL	nl10l010i	:	STD_LOGIC := '0';
	 SIGNAL	nl10l010l	:	STD_LOGIC := '0';
	 SIGNAL	nl10l010O	:	STD_LOGIC := '0';
	 SIGNAL	nl10l011i	:	STD_LOGIC := '0';
	 SIGNAL	nl10l011l	:	STD_LOGIC := '0';
	 SIGNAL	nl10l011O	:	STD_LOGIC := '0';
	 SIGNAL	nl10l01ii	:	STD_LOGIC := '0';
	 SIGNAL	nl10l01il	:	STD_LOGIC := '0';
	 SIGNAL	nl10l01iO	:	STD_LOGIC := '0';
	 SIGNAL	nl10l01li	:	STD_LOGIC := '0';
	 SIGNAL	nl10l01ll	:	STD_LOGIC := '0';
	 SIGNAL	nl10l01lO	:	STD_LOGIC := '0';
	 SIGNAL	nl10l01Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl10l01Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl10l01OO	:	STD_LOGIC := '0';
	 SIGNAL	nl10l0i0i	:	STD_LOGIC := '0';
	 SIGNAL	nl10l0i0l	:	STD_LOGIC := '0';
	 SIGNAL	nl10l0i0O	:	STD_LOGIC := '0';
	 SIGNAL	nl10l0i1i	:	STD_LOGIC := '0';
	 SIGNAL	nl10l0i1l	:	STD_LOGIC := '0';
	 SIGNAL	nl10l0i1O	:	STD_LOGIC := '0';
	 SIGNAL	nl10l0iii	:	STD_LOGIC := '0';
	 SIGNAL	nl10l100i	:	STD_LOGIC := '0';
	 SIGNAL	nl10l100l	:	STD_LOGIC := '0';
	 SIGNAL	nl10l100O	:	STD_LOGIC := '0';
	 SIGNAL	nl10l101i	:	STD_LOGIC := '0';
	 SIGNAL	nl10l101l	:	STD_LOGIC := '0';
	 SIGNAL	nl10l101O	:	STD_LOGIC := '0';
	 SIGNAL	nl10l10ii	:	STD_LOGIC := '0';
	 SIGNAL	nl10l10il	:	STD_LOGIC := '0';
	 SIGNAL	nl10l10iO	:	STD_LOGIC := '0';
	 SIGNAL	nl10l10li	:	STD_LOGIC := '0';
	 SIGNAL	nl10l10ll	:	STD_LOGIC := '0';
	 SIGNAL	nl10l10lO	:	STD_LOGIC := '0';
	 SIGNAL	nl10l10Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl10l10Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl10l10OO	:	STD_LOGIC := '0';
	 SIGNAL	nl10l110i	:	STD_LOGIC := '0';
	 SIGNAL	nl10l110l	:	STD_LOGIC := '0';
	 SIGNAL	nl10l110O	:	STD_LOGIC := '0';
	 SIGNAL	nl10l111i	:	STD_LOGIC := '0';
	 SIGNAL	nl10l111l	:	STD_LOGIC := '0';
	 SIGNAL	nl10l111O	:	STD_LOGIC := '0';
	 SIGNAL	nl10l11ii	:	STD_LOGIC := '0';
	 SIGNAL	nl10l11il	:	STD_LOGIC := '0';
	 SIGNAL	nl10l11iO	:	STD_LOGIC := '0';
	 SIGNAL	nl10l11li	:	STD_LOGIC := '0';
	 SIGNAL	nl10l11ll	:	STD_LOGIC := '0';
	 SIGNAL	nl10l11lO	:	STD_LOGIC := '0';
	 SIGNAL	nl10l11Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl10l11Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl10l11OO	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1i0i	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1i0l	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1i0O	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1i1i	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1i1l	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1i1O	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1iii	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1iil	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1iiO	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1ili	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1ill	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1ilO	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1iOi	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1iOl	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1iOO	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1l0i	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1l0l	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1l0O	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1l1i	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1l1l	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1l1O	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1lii	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1lil	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1liO	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1lli	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1lll	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1llO	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1lOi	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1lOl	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1lOO	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1O0i	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1O0l	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1O0O	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1O1i	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1O1l	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1O1O	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1Oii	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1Oil	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1OiO	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1Oli	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1Oll	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1OlO	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1OOi	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1OOl	:	STD_LOGIC := '0';
	 SIGNAL	nl10l1OOO	:	STD_LOGIC := '0';
	 SIGNAL	nl10OO00i	:	STD_LOGIC := '0';
	 SIGNAL	nl10OO00l	:	STD_LOGIC := '0';
	 SIGNAL	nl10OO00O	:	STD_LOGIC := '0';
	 SIGNAL	nl10OO01i	:	STD_LOGIC := '0';
	 SIGNAL	nl10OO01l	:	STD_LOGIC := '0';
	 SIGNAL	nl10OO01O	:	STD_LOGIC := '0';
	 SIGNAL	nl10OO0ii	:	STD_LOGIC := '0';
	 SIGNAL	nl10OO0il	:	STD_LOGIC := '0';
	 SIGNAL	nl10OO0iO	:	STD_LOGIC := '0';
	 SIGNAL	nl10OO0li	:	STD_LOGIC := '0';
	 SIGNAL	nl10OO0ll	:	STD_LOGIC := '0';
	 SIGNAL	nl10OO0lO	:	STD_LOGIC := '0';
	 SIGNAL	nl10OO10l	:	STD_LOGIC := '0';
	 SIGNAL	nl10OO10O	:	STD_LOGIC := '0';
	 SIGNAL	nl10OO1ii	:	STD_LOGIC := '0';
	 SIGNAL	nl10OO1il	:	STD_LOGIC := '0';
	 SIGNAL	nl10OO1iO	:	STD_LOGIC := '0';
	 SIGNAL	nl10OO1li	:	STD_LOGIC := '0';
	 SIGNAL	nl10OO1ll	:	STD_LOGIC := '0';
	 SIGNAL	nl10OO1Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl10OO1Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl10OO1OO	:	STD_LOGIC := '0';
	 SIGNAL	nl110i0Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl110i0Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl110i0OO	:	STD_LOGIC := '0';
	 SIGNAL	nl110ii1i	:	STD_LOGIC := '0';
	 SIGNAL	nl110ii1l	:	STD_LOGIC := '0';
	 SIGNAL	nl110ii1O	:	STD_LOGIC := '0';
	 SIGNAL	nl110iOOl	:	STD_LOGIC := '0';
	 SIGNAL	nl110iOOO	:	STD_LOGIC := '0';
	 SIGNAL	nl110l00i	:	STD_LOGIC := '0';
	 SIGNAL	nl110l00l	:	STD_LOGIC := '0';
	 SIGNAL	nl110l00O	:	STD_LOGIC := '0';
	 SIGNAL	nl110l01i	:	STD_LOGIC := '0';
	 SIGNAL	nl110l01l	:	STD_LOGIC := '0';
	 SIGNAL	nl110l01O	:	STD_LOGIC := '0';
	 SIGNAL	nl110l0ii	:	STD_LOGIC := '0';
	 SIGNAL	nl110l0il	:	STD_LOGIC := '0';
	 SIGNAL	nl110l0iO	:	STD_LOGIC := '0';
	 SIGNAL	nl110l0li	:	STD_LOGIC := '0';
	 SIGNAL	nl110l0ll	:	STD_LOGIC := '0';
	 SIGNAL	nl110l0lO	:	STD_LOGIC := '0';
	 SIGNAL	nl110l0Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl110l0Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl110l0OO	:	STD_LOGIC := '0';
	 SIGNAL	nl110l10i	:	STD_LOGIC := '0';
	 SIGNAL	nl110l10l	:	STD_LOGIC := '0';
	 SIGNAL	nl110l10O	:	STD_LOGIC := '0';
	 SIGNAL	nl110l11i	:	STD_LOGIC := '0';
	 SIGNAL	nl110l11l	:	STD_LOGIC := '0';
	 SIGNAL	nl110l11O	:	STD_LOGIC := '0';
	 SIGNAL	nl110l1ii	:	STD_LOGIC := '0';
	 SIGNAL	nl110l1il	:	STD_LOGIC := '0';
	 SIGNAL	nl110l1iO	:	STD_LOGIC := '0';
	 SIGNAL	nl110l1li	:	STD_LOGIC := '0';
	 SIGNAL	nl110l1ll	:	STD_LOGIC := '0';
	 SIGNAL	nl110l1lO	:	STD_LOGIC := '0';
	 SIGNAL	nl110l1Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl110l1Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl110l1OO	:	STD_LOGIC := '0';
	 SIGNAL	nl110li0i	:	STD_LOGIC := '0';
	 SIGNAL	nl110li0l	:	STD_LOGIC := '0';
	 SIGNAL	nl110li0O	:	STD_LOGIC := '0';
	 SIGNAL	nl110li1i	:	STD_LOGIC := '0';
	 SIGNAL	nl110li1l	:	STD_LOGIC := '0';
	 SIGNAL	nl110li1O	:	STD_LOGIC := '0';
	 SIGNAL	nl110liii	:	STD_LOGIC := '0';
	 SIGNAL	nl110liil	:	STD_LOGIC := '0';
	 SIGNAL	nl110liiO	:	STD_LOGIC := '0';
	 SIGNAL	nl110lili	:	STD_LOGIC := '0';
	 SIGNAL	nl110lill	:	STD_LOGIC := '0';
	 SIGNAL	nl110lilO	:	STD_LOGIC := '0';
	 SIGNAL	nl110liOi	:	STD_LOGIC := '0';
	 SIGNAL	nl110liOl	:	STD_LOGIC := '0';
	 SIGNAL	nl110liOO	:	STD_LOGIC := '0';
	 SIGNAL	nl110ll0i	:	STD_LOGIC := '0';
	 SIGNAL	nl110ll0l	:	STD_LOGIC := '0';
	 SIGNAL	nl110ll0O	:	STD_LOGIC := '0';
	 SIGNAL	nl110ll1i	:	STD_LOGIC := '0';
	 SIGNAL	nl110ll1l	:	STD_LOGIC := '0';
	 SIGNAL	nl110ll1O	:	STD_LOGIC := '0';
	 SIGNAL	nl110llii	:	STD_LOGIC := '0';
	 SIGNAL	nl110llil	:	STD_LOGIC := '0';
	 SIGNAL	nl110lliO	:	STD_LOGIC := '0';
	 SIGNAL	nl110llli	:	STD_LOGIC := '0';
	 SIGNAL	nl110llll	:	STD_LOGIC := '0';
	 SIGNAL	nl110lllO	:	STD_LOGIC := '0';
	 SIGNAL	nl110llOi	:	STD_LOGIC := '0';
	 SIGNAL	nl111111i	:	STD_LOGIC := '0';
	 SIGNAL	nl1111l0l	:	STD_LOGIC := '0';
	 SIGNAL	nl1111lii	:	STD_LOGIC := '0';
	 SIGNAL	nl1111lil	:	STD_LOGIC := '0';
	 SIGNAL	nl1111liO	:	STD_LOGIC := '0';
	 SIGNAL	nl1111lli	:	STD_LOGIC := '0';
	 SIGNAL	nl1111lll	:	STD_LOGIC := '0';
	 SIGNAL	nl1111llO	:	STD_LOGIC := '0';
	 SIGNAL	nl1111lOl	:	STD_LOGIC := '0';
	 SIGNAL	nl1111lOO	:	STD_LOGIC := '0';
	 SIGNAL	nl1111O1i	:	STD_LOGIC := '0';
	 SIGNAL	nl1111O1l	:	STD_LOGIC := '0';
	 SIGNAL	nl1111O1O	:	STD_LOGIC := '0';
	 SIGNAL	nl111i00O	:	STD_LOGIC := '0';
	 SIGNAL	nl111i0ii	:	STD_LOGIC := '0';
	 SIGNAL	nl111i0il	:	STD_LOGIC := '0';
	 SIGNAL	nl111i0iO	:	STD_LOGIC := '0';
	 SIGNAL	nl111i0li	:	STD_LOGIC := '0';
	 SIGNAL	nl111i0ll	:	STD_LOGIC := '0';
	 SIGNAL	nl111i0lO	:	STD_LOGIC := '0';
	 SIGNAL	nl111i0Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl111i0Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl111i0OO	:	STD_LOGIC := '0';
	 SIGNAL	nl111ii0i	:	STD_LOGIC := '0';
	 SIGNAL	nl111ii0l	:	STD_LOGIC := '0';
	 SIGNAL	nl111ii1i	:	STD_LOGIC := '0';
	 SIGNAL	nl111ii1l	:	STD_LOGIC := '0';
	 SIGNAL	nl111ii1O	:	STD_LOGIC := '0';
	 SIGNAL	nl111l0Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl111l0OO	:	STD_LOGIC := '0';
	 SIGNAL	nl111li0i	:	STD_LOGIC := '0';
	 SIGNAL	nl111li0l	:	STD_LOGIC := '0';
	 SIGNAL	nl111li0O	:	STD_LOGIC := '0';
	 SIGNAL	nl111li1i	:	STD_LOGIC := '0';
	 SIGNAL	nl111li1l	:	STD_LOGIC := '0';
	 SIGNAL	nl111li1O	:	STD_LOGIC := '0';
	 SIGNAL	nl111liii	:	STD_LOGIC := '0';
	 SIGNAL	nl111liil	:	STD_LOGIC := '0';
	 SIGNAL	nl111liiO	:	STD_LOGIC := '0';
	 SIGNAL	nl111lili	:	STD_LOGIC := '0';
	 SIGNAL	nl111lill	:	STD_LOGIC := '0';
	 SIGNAL	nl111lilO	:	STD_LOGIC := '0';
	 SIGNAL	nl111liOi	:	STD_LOGIC := '0';
	 SIGNAL	nl111liOl	:	STD_LOGIC := '0';
	 SIGNAL	nl111liOO	:	STD_LOGIC := '0';
	 SIGNAL	nl111ll0i	:	STD_LOGIC := '0';
	 SIGNAL	nl111ll0l	:	STD_LOGIC := '0';
	 SIGNAL	nl111ll0O	:	STD_LOGIC := '0';
	 SIGNAL	nl111ll1i	:	STD_LOGIC := '0';
	 SIGNAL	nl111ll1l	:	STD_LOGIC := '0';
	 SIGNAL	nl111ll1O	:	STD_LOGIC := '0';
	 SIGNAL	nl111llii	:	STD_LOGIC := '0';
	 SIGNAL	nl111llil	:	STD_LOGIC := '0';
	 SIGNAL	nl111lliO	:	STD_LOGIC := '0';
	 SIGNAL	nl111llli	:	STD_LOGIC := '0';
	 SIGNAL	nl111llll	:	STD_LOGIC := '0';
	 SIGNAL	nl111lllO	:	STD_LOGIC := '0';
	 SIGNAL	nl111llOi	:	STD_LOGIC := '0';
	 SIGNAL	nl111llOl	:	STD_LOGIC := '0';
	 SIGNAL	nl111llOO	:	STD_LOGIC := '0';
	 SIGNAL	nl111lO0i	:	STD_LOGIC := '0';
	 SIGNAL	nl111lO0l	:	STD_LOGIC := '0';
	 SIGNAL	nl111lO0O	:	STD_LOGIC := '0';
	 SIGNAL	nl111lO1i	:	STD_LOGIC := '0';
	 SIGNAL	nl111lO1l	:	STD_LOGIC := '0';
	 SIGNAL	nl111lO1O	:	STD_LOGIC := '0';
	 SIGNAL	nl111lOii	:	STD_LOGIC := '0';
	 SIGNAL	nl111lOil	:	STD_LOGIC := '0';
	 SIGNAL	nl111lOiO	:	STD_LOGIC := '0';
	 SIGNAL	nl111lOli	:	STD_LOGIC := '0';
	 SIGNAL	nl111lOll	:	STD_LOGIC := '0';
	 SIGNAL	nl111lOlO	:	STD_LOGIC := '0';
	 SIGNAL	nl111lOOi	:	STD_LOGIC := '0';
	 SIGNAL	nl111lOOl	:	STD_LOGIC := '0';
	 SIGNAL	nl111lOOO	:	STD_LOGIC := '0';
	 SIGNAL	nl111O10i	:	STD_LOGIC := '0';
	 SIGNAL	nl111O10l	:	STD_LOGIC := '0';
	 SIGNAL	nl111O10O	:	STD_LOGIC := '0';
	 SIGNAL	nl111O11i	:	STD_LOGIC := '0';
	 SIGNAL	nl111O11l	:	STD_LOGIC := '0';
	 SIGNAL	nl111O11O	:	STD_LOGIC := '0';
	 SIGNAL	nl111O1ii	:	STD_LOGIC := '0';
	 SIGNAL	nl111O1il	:	STD_LOGIC := '0';
	 SIGNAL	nl111O1iO	:	STD_LOGIC := '0';
	 SIGNAL	nl111O1li	:	STD_LOGIC := '0';
	 SIGNAL	nl111O1ll	:	STD_LOGIC := '0';
	 SIGNAL	nl111O1lO	:	STD_LOGIC := '0';
	 SIGNAL	nl111O1Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl11i0lli	:	STD_LOGIC := '0';
	 SIGNAL	nl11i0lll	:	STD_LOGIC := '0';
	 SIGNAL	nl11i0llO	:	STD_LOGIC := '0';
	 SIGNAL	nl11i0lOi	:	STD_LOGIC := '0';
	 SIGNAL	nl11i0lOl	:	STD_LOGIC := '0';
	 SIGNAL	nl11i0lOO	:	STD_LOGIC := '0';
	 SIGNAL	nl11i0O0i	:	STD_LOGIC := '0';
	 SIGNAL	nl11i0O0l	:	STD_LOGIC := '0';
	 SIGNAL	nl11i0O0O	:	STD_LOGIC := '0';
	 SIGNAL	nl11i0O1i	:	STD_LOGIC := '0';
	 SIGNAL	nl11i0O1l	:	STD_LOGIC := '0';
	 SIGNAL	nl11i0O1O	:	STD_LOGIC := '0';
	 SIGNAL	nl11i0Oii	:	STD_LOGIC := '0';
	 SIGNAL	nl11i0Oil	:	STD_LOGIC := '0';
	 SIGNAL	nl11i0OiO	:	STD_LOGIC := '0';
	 SIGNAL	nl11i0Oli	:	STD_LOGIC := '0';
	 SIGNAL	nl11i0Oll	:	STD_LOGIC := '0';
	 SIGNAL	nl11i0OlO	:	STD_LOGIC := '0';
	 SIGNAL	nl11i0OOi	:	STD_LOGIC := '0';
	 SIGNAL	nl11i0OOl	:	STD_LOGIC := '0';
	 SIGNAL	nl11i0OOO	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii00i	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii00l	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii00O	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii01i	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii01l	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii01O	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii0ii	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii0il	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii0iO	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii0li	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii0ll	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii0lO	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii0Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii0Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii0OO	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii10i	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii10l	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii10O	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii11i	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii11l	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii11O	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii1ii	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii1il	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii1iO	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii1li	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii1ll	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii1lO	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii1Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii1Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii1OO	:	STD_LOGIC := '0';
	 SIGNAL	nl11iii0i	:	STD_LOGIC := '0';
	 SIGNAL	nl11iii0l	:	STD_LOGIC := '0';
	 SIGNAL	nl11iii0O	:	STD_LOGIC := '0';
	 SIGNAL	nl11iii1i	:	STD_LOGIC := '0';
	 SIGNAL	nl11iii1l	:	STD_LOGIC := '0';
	 SIGNAL	nl11iii1O	:	STD_LOGIC := '0';
	 SIGNAL	nl11iiiii	:	STD_LOGIC := '0';
	 SIGNAL	nl11iiiil	:	STD_LOGIC := '0';
	 SIGNAL	nl11iiiiO	:	STD_LOGIC := '0';
	 SIGNAL	nl11O0Oii	:	STD_LOGIC := '0';
	 SIGNAL	nl11O0Oil	:	STD_LOGIC := '0';
	 SIGNAL	nl11O0OiO	:	STD_LOGIC := '0';
	 SIGNAL	nl11O0Oli	:	STD_LOGIC := '0';
	 SIGNAL	nl11O0Oll	:	STD_LOGIC := '0';
	 SIGNAL	nl11O0OlO	:	STD_LOGIC := '0';
	 SIGNAL	nl11O0OOi	:	STD_LOGIC := '0';
	 SIGNAL	nl11O0OOl	:	STD_LOGIC := '0';
	 SIGNAL	nl11O0OOO	:	STD_LOGIC := '0';
	 SIGNAL	nl11O1l1O	:	STD_LOGIC := '0';
	 SIGNAL	nl11O1Oll	:	STD_LOGIC := '0';
	 SIGNAL	nl11Oi10i	:	STD_LOGIC := '0';
	 SIGNAL	nl11Oi11i	:	STD_LOGIC := '0';
	 SIGNAL	nl11Oi11l	:	STD_LOGIC := '0';
	 SIGNAL	nl11Oi11O	:	STD_LOGIC := '0';
	 SIGNAL	nl11OiOOl	:	STD_LOGIC := '0';
	 SIGNAL	nl11OiOOO	:	STD_LOGIC := '0';
	 SIGNAL	nl11Ol10i	:	STD_LOGIC := '0';
	 SIGNAL	nl11Ol10l	:	STD_LOGIC := '0';
	 SIGNAL	nl11Ol10O	:	STD_LOGIC := '0';
	 SIGNAL	nl11Ol11i	:	STD_LOGIC := '0';
	 SIGNAL	nl11Ol11l	:	STD_LOGIC := '0';
	 SIGNAL	nl11Ol11O	:	STD_LOGIC := '0';
	 SIGNAL	nl11Ol1ii	:	STD_LOGIC := '0';
	 SIGNAL	nl11Ol1il	:	STD_LOGIC := '0';
	 SIGNAL	nl11Ol1iO	:	STD_LOGIC := '0';
	 SIGNAL	nl11Ol1li	:	STD_LOGIC := '0';
	 SIGNAL	nl11Ol1ll	:	STD_LOGIC := '0';
	 SIGNAL	nl11Ol1lO	:	STD_LOGIC := '0';
	 SIGNAL	nl1i0OOlO	:	STD_LOGIC := '0';
	 SIGNAL	nl1i0OOOi	:	STD_LOGIC := '0';
	 SIGNAL	nl1i0OOOl	:	STD_LOGIC := '0';
	 SIGNAL	nl1i0OOOO	:	STD_LOGIC := '0';
	 SIGNAL	nl1i1l10O	:	STD_LOGIC := '0';
	 SIGNAL	nl1i1l1iO	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii000i	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii000l	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii000O	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii001i	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii001l	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii001O	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii00ii	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii00il	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii00iO	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii00li	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii00ll	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii00lO	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii00Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii00Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii00OO	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii010i	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii010l	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii010O	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii011i	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii011l	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii011O	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii01ii	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii01il	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii01iO	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii01li	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii01ll	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii01lO	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii01Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii01Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii01OO	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0i0i	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0i0l	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0i0O	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0i1i	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0i1l	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0i1O	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0iii	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0iil	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0iiO	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0ili	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0ill	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0ilO	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0iOi	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0iOl	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0iOO	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0l0i	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0l0l	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0l0O	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0l1i	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0l1l	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0l1O	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0lii	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0lil	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0liO	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0lli	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0lll	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0llO	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0lOi	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0lOl	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0lOO	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0O0i	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0O0l	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0O0O	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0O1i	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0O1l	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0O1O	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0Oii	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0Oil	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0OiO	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0Oli	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0Oll	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0OlO	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0OOi	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0OOl	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii0OOO	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii100i	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii100l	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii100O	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii101i	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii101l	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii101O	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii10ii	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii10il	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii10iO	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii10li	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii10ll	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii10lO	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii10Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii10Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii10OO	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii110i	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii110l	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii110O	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii111i	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii111l	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii111O	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii11ii	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii11il	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii11iO	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii11li	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii11ll	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii11lO	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii11Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii11Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii11OO	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1i0i	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1i0l	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1i0O	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1i1i	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1i1l	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1i1O	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1iii	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1iil	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1iiO	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1ili	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1ill	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1ilO	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1iOi	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1iOl	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1iOO	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1l0i	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1l0l	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1l0O	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1l1i	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1l1l	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1l1O	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1lii	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1lil	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1liO	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1lli	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1lll	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1llO	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1lOi	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1lOl	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1lOO	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1O0i	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1O0l	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1O0O	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1O1i	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1O1l	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1O1O	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1Oii	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1Oil	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1OiO	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1Oli	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1Oll	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1OlO	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1OOi	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1OOl	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii1OOO	:	STD_LOGIC := '0';
	 SIGNAL	nl1iii00i	:	STD_LOGIC := '0';
	 SIGNAL	nl1iii00l	:	STD_LOGIC := '0';
	 SIGNAL	nl1iii00O	:	STD_LOGIC := '0';
	 SIGNAL	nl1iii01i	:	STD_LOGIC := '0';
	 SIGNAL	nl1iii01l	:	STD_LOGIC := '0';
	 SIGNAL	nl1iii01O	:	STD_LOGIC := '0';
	 SIGNAL	nl1iii0ii	:	STD_LOGIC := '0';
	 SIGNAL	nl1iii0il	:	STD_LOGIC := '0';
	 SIGNAL	nl1iii0iO	:	STD_LOGIC := '0';
	 SIGNAL	nl1iii0li	:	STD_LOGIC := '0';
	 SIGNAL	nl1iii0ll	:	STD_LOGIC := '0';
	 SIGNAL	nl1iii0lO	:	STD_LOGIC := '0';
	 SIGNAL	nl1iii0Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl1iii0Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl1iii0OO	:	STD_LOGIC := '0';
	 SIGNAL	nl1iii10i	:	STD_LOGIC := '0';
	 SIGNAL	nl1iii10l	:	STD_LOGIC := '0';
	 SIGNAL	nl1iii10O	:	STD_LOGIC := '0';
	 SIGNAL	nl1iii11i	:	STD_LOGIC := '0';
	 SIGNAL	nl1iii11l	:	STD_LOGIC := '0';
	 SIGNAL	nl1iii11O	:	STD_LOGIC := '0';
	 SIGNAL	nl1iii1ii	:	STD_LOGIC := '0';
	 SIGNAL	nl1iii1il	:	STD_LOGIC := '0';
	 SIGNAL	nl1iii1iO	:	STD_LOGIC := '0';
	 SIGNAL	nl1iii1li	:	STD_LOGIC := '0';
	 SIGNAL	nl1iii1ll	:	STD_LOGIC := '0';
	 SIGNAL	nl1iii1lO	:	STD_LOGIC := '0';
	 SIGNAL	nl1iii1Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl1iii1Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl1iii1OO	:	STD_LOGIC := '0';
	 SIGNAL	nl1iiii0i	:	STD_LOGIC := '0';
	 SIGNAL	nl1iiii0l	:	STD_LOGIC := '0';
	 SIGNAL	nl1iiii0O	:	STD_LOGIC := '0';
	 SIGNAL